/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: MultiThreeTag.java 62554 2011-04-15 18:08:28Z dougd $
 */

package com.sun.ts.tests.jsp.api.javax_servlet.jsp.tagext.jspidconsumer;

import com.sun.ts.tests.jsp.common.util.JspTestUtil;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.JspIdConsumer;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import java.io.IOException;

public class MultiThreeTag extends SimpleTagSupport 
        implements JspIdConsumer {

    private String jspId;
    private JspWriter out;
 
    public void setJspId(String id) {
        jspId = id;
    }

    public void doTag() throws JspException, IOException {

        out = getJspContext().getOut();

        try {
            String jspId1 = MultiOneTag.getJspId();
            String jspId2 = MultiTwoTag.getJspId();
            if (jspId == null || jspId1 == null || jspId2 == null) {
                out.println("Some ID(s) not assigned. Test FAILED");
                return;
            }
            out.println("MultiThreeTag: JspId is " + jspId);
            out.println("MultiThreeTag: JspId1 is " + jspId1);
            out.println("MultiThreeTag: JspId2 is " + jspId2);

            if (jspId == jspId1 || jspId == jspId2 || jspId1 == jspId2) {
                out.println("Identical IDs found. Test FAILED");
                return;
            }
            out.println("Test PASSED");

        } catch (Throwable t) {
            JspTestUtil.handleThrowable(t, out, "MultiThreeTag");
        }
    }
}
