/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: URLClient.java 62554 2011-04-15 18:08:28Z dougd $
 */

/*
 * @(#)URLClient.java	1.2 10/09/02
 */

package com.sun.ts.tests.jsp.api.javax_servlet.jsp.tagext.trycatchfinally;

import java.io.PrintWriter;
import com.sun.ts.lib.harness.EETest.Fault;
import com.sun.javatest.Status;
import com.sun.ts.tests.jsp.common.client.AbstractUrlClient;

/**
 * Test client for TryCatchFinally tag tests.
 */
public class URLClient extends AbstractUrlClient {

    /**
     * Entry point for different-VM execution.  It should delegate to method
     * run(String[], PrintWriter, PrintWriter), and this method should not
     * contain any test configuration.
     */
    public static void main(String[] args) {
        URLClient theTests = new URLClient();
        Status s = theTests.run(args, new PrintWriter(System.out), 
                   new PrintWriter(System.err));
        s.exit();
    }

    /**
     * Entry point for same-VM execution. In different-VM execution, the 
     * main method delegates to this method.
     */
    public Status run(String args[], PrintWriter out, PrintWriter err) {

        setContextRoot("/jsp_varinfo_web");
        setTestJsp("VariableInfoTest");

        return super.run(args, out, err);
    }
    
    /*
     *  @class.setup_props: webServerHost;
     *                      webServerPort;
     *                      ts_home; 
     */
     
    /* Run tests */
  
    //============================================ Tests ======
  
    /*
     * @testName: tryCatchFinallyTest
     * @assertion_ids: JSP:JAVADOC:339;JSP:JAVADOC:341
     * @test_Strategy: Validate the behavior of the container
     *                 when a tag implements the TryCatchFinally interface.
     */
    public void tryCatchFinallyTest() throws Fault {
        TEST_PROPS.setProperty(REQUEST,
            "GET /jsp_tcfinally_web/TryCatchFinallyTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty(SEARCH_STRING, "Test PASSED");
        invoke();
    }
}
