/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jsp.spec.core_syntax.directives.page;

import com.sun.ts.tests.jsp.common.util.JspTestUtil;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import java.io.IOException;

public class IsELIgnoredTrueActionTag extends SimpleTagSupport {

    private String dollarValue;
    private String poundValue;

    public void setDollarValue(String dollarValue) {
        this.dollarValue = dollarValue;
    }

    public void setPoundValue(String poundValue) {
        this.poundValue = poundValue;
    }

    public void doTag() throws JspException, IOException {
        JspWriter out = getJspContext().getOut();

        try {
            out.println("Dollar value = " + dollarValue);
            out.println("Pound value = " + poundValue); 
        } catch (Throwable t) {
            JspTestUtil.handleThrowable(t, out, "IsELIgnoredTrueActionTag");
        }
    }
}
