/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: EchoTag.java 62554 2011-04-15 18:08:28Z dougd $
 */

package com.sun.ts.tests.jsp.spec.jspdocument.general;

import javax.servlet.jsp.tagext.SimpleTagSupport;
import javax.servlet.jsp.tagext.JspFragment;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import java.io.IOException;

public class EchoTag extends SimpleTagSupport {

    private String _echo = null;
    private String _static = null;

    public void setEcho(String echo) {
        _echo = echo;
    }

    public void setStatic(String staticString) {
         _static = staticString;
    }

    public void doTag() throws JspException {
        JspWriter out = null;
        JspFragment body = null;
        try {
            out = getJspContext().getOut();
            body = getJspBody();
            if(body != null) {
                body.invoke(null);
            }
            if(_echo != null) {
                out.println("Expression from attribute: " + _echo);
            }
            if(_static != null) {
                out.println("String from attribute: " + _static);
            }
        } catch (IOException ioe) {
            throw new JspException("Unexpected IOException!", ioe);
        }
    }
}
