package com.sun.ts.tests.securityapi.idstore.common;

import java.util.Map;

import javax.enterprise.context.Dependent;
import javax.security.enterprise.identitystore.PasswordHash;

@Dependent
public class PlaintextPasswordHash implements PasswordHash {

    @Override
    public void initialize(Map<String, String> parameters) {
        
    }

    @Override
    public String generate(char[] password) {
        return new String(password);
    }

    @Override
    public boolean verify(char[] password, String hashedPassword) {
         //don't bother with constant time comparison; more portable
         //this way, and algorithm will be used only for testing.
        return (password != null && password.length > 0 &&
                hashedPassword != null && hashedPassword.length() > 0 &&
                hashedPassword.equals(new String(password)));
    }
}
