/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id:$
 */
package com.sun.ts.tests.servlet.api.javax_servlet.servletcontext302;

import java.io.PrintWriter;
import com.sun.javatest.Status;
import com.sun.ts.tests.servlet.common.client.AbstractUrlClient;

public class URLClient extends AbstractUrlClient {

    /**
     * Entry point for different-VM execution.  It should delegate to method
     * run(String[], PrintWriter, PrintWriter), and this method should not
     * contain any test configuration.
     */
    public static void main(String[] args) {
        URLClient theTests = new URLClient();
        Status s = theTests.run(args, new PrintWriter(System.out),
                new PrintWriter(System.err));
        s.exit();
    }

    /**
     * Entry point for same-VM execution. In different-VM execution, the
     * main method delegates to this method.
     */
    public Status run(String args[], PrintWriter out, PrintWriter err) {

        setContextRoot("/servlet_js_servletcontext302_web");
        setServletName("TestServlet");

        return super.run(args, out, err);
    }

    /*
     * @class.setup_props: webServerHost;
     *                     webServerPort;
     *                     ts_home;
     */
    /* Run test */

    /*
     * @testName:  addListenerTest
     *
     * @assertion_ids: Servlet:JAVADOC:671.9;
     *
     * @test_Strategy: In a ServletContextListener, call:
     *                 ServletContext.addListener(String GenericListener.className)
     *                 GenericListener does not implement any of the Listener class on the list:
     *                  - ServletContextAttributeListener
     *                  - HttpSessionListener
     *                  - HttpSessionAttributeListener
     *                  - ServletRequestListener
     *                  - ServletRequestAttributeListener
     *                 Verify the expected IllegalArgumentException is thrown.
     */
    public void addListenerTest() throws Fault {
        TEST_PROPS.setProperty(APITEST, "addListenerTest");
        TEST_PROPS.setProperty(SEARCH_STRING, "LISTENER_TEST=TRUE");
        TEST_PROPS.setProperty(UNEXPECTED_RESPONSE_MATCH, "AddGenericEventListenerString");
        invoke();
    }
}
