/*
 * Copyright (c) 2011, 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id:$
 */
package com.sun.ts.tests.servlet.api.javax_servlet.sessiontrackingmode;

import com.sun.ts.tests.servlet.common.servlets.GenericTCKServlet;
import com.sun.ts.tests.servlet.common.util.ServletTestUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.*;

public class TestServlet extends GenericTCKServlet {

    public void setSessionTrackingModes(ServletRequest request,
            ServletResponse response)
            throws ServletException, IOException {
        boolean passed = true;
        PrintWriter pw = response.getWriter();
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        pw.println((String) context.getAttribute("LOG"));

        Set<SessionTrackingMode> expected_modes = new HashSet();
        String expected = (String) context.getAttribute("MODES");
        StringTokenizer str = new StringTokenizer(expected, ";");

        while (str.hasMoreTokens()) {
            String mode = str.nextToken();
            pw.println("Expected SessionTrackingMode =" + mode);
            if (mode.equals(SessionTrackingMode.COOKIE.toString())) {
                expected_modes.add(SessionTrackingMode.COOKIE);
            } else if (mode.equals(SessionTrackingMode.SSL.toString())) {
                //SSL cannot be set with combination of other SessionTrackingMode
            	//expected_modes.add(SessionTrackingMode.SSL);
            } else if (mode.equals(SessionTrackingMode.URL.toString())) {
                expected_modes.add(SessionTrackingMode.URL);
            } else {
                passed = false;
                pw.println("Unrecogized SessionTrackingMode expected: " + mode);
            }

        }

        Set<SessionTrackingMode> results = null;

        if (expected_modes.isEmpty()) {
            results = context.getDefaultSessionTrackingModes();
        } else {
            results = context.getEffectiveSessionTrackingModes();
        }

        if (!results.containsAll(expected_modes)) {
            passed = false;
            pw.append("setSessionTrackingModes and getEffectiveSessionTrackingModes " +
                    "retuns different set of SessionTrackingModes");

            pw.append("getEffectiveSessionTrackingModes =");
            for (SessionTrackingMode tmp : results) {
                pw.append("           " + tmp);
            }
        }

        ServletTestUtil.printResult(pw, passed);
    }
}
