/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Ids$
 */
package com.sun.ts.tests.servlet.api.javax_servlet_http.httpservletrequest;

import com.sun.ts.tests.servlet.common.servlets.HttpTCKServlet;
import com.sun.ts.tests.servlet.common.util.ServletTestUtil;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletContext;
import java.io.IOException;
import java.io.PrintWriter;

public class getServletContextTest extends HttpTCKServlet {

    public void service(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        Boolean passed = true;

        ServletContext actual = request.getServletContext();
        ServletContext expected = this.getServletConfig().getServletContext();

        if (actual != expected) {
            passed = false;
            pw.println("getServletContext() returned inconsistent result");
        }
        ServletTestUtil.printResult(pw, passed);
    }
}
