/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id:$
 */
package com.sun.ts.tests.servlet.api.javax_servlet_http.httpservletrequest31;

import com.sun.javatest.Status;
import com.sun.ts.tests.servlet.api.common.request.HttpRequestClient;
import java.io.PrintWriter;

public class URLClient extends HttpRequestClient {

    private static final String CONTEXT_ROOT =
            "/servlet_jsh_httpservletrequest31_web";

    /**
     * Entry point for different-VM execution.  It should delegate to method
     * run(String[], PrintWriter, PrintWriter), and this method should not
     * contain any test configuration.
     */
    public static void main(String[] args) {
        URLClient theTests = new URLClient();
        Status s = theTests.run(args, new PrintWriter(System.out),
                new PrintWriter(System.err));
        s.exit();
    }

    /**
     * Entry point for same-VM execution. In different-VM execution, the
     * main method delegates to this method.
     */
    public Status run(String args[], PrintWriter out, PrintWriter err) {

        setServletName("TestServlet");
        setContextRoot(CONTEXT_ROOT);

        return super.run(args, out, err);
    }

    /*
     * @class.setup_props: webServerHost;
     *			   webServerPort;
     *			   ts_home;
     *
     */

    /* Run test */
    /*
     * @testName:      changeSessionIDTest
     *
     * @assertion_ids: Servlet:JAVADOC:929.1;
     *
     * @test_Strategy: Send an HttpServletRequest to server;
     *                 Verify that request.changeSessionId() throws IllegalStateException
     *                 when it is called without a session;
     */
}
