/*
 * Copyright (c) 2007, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id:$
 */

package com.sun.ts.tests.servlet.api.javax_servlet_http.part1;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;

@WebServlet("/TestServletWrapper")
@MultipartConfig(maxFileSize = 200)
public class TestServletWrapper extends com.sun.ts.tests.servlet.api.javax_servlet_http.part.TestServlet {

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    // Simply validate the default behavior of the RequestWrapper is to delegate
    // the call to the wrapped object.
    public void service(HttpServletRequest servletRequest, HttpServletResponse servletResponse)
        throws ServletException, IOException {
        HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper(servletRequest);
        super.service(wrapper, servletResponse);
    }
}
