/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */
package com.sun.ts.tests.servlet.api.javax_servlet_http.writelistener;

import javax.servlet.AsyncContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;

public class TestListener implements WriteListener {

    private ServletOutputStream output = null;
    private AsyncContext ac = null;

    TestListener(ServletOutputStream sos,
            AsyncContext c) {
        output = sos;
        ac = c;
    }

    public void onWritePossible() {
        String message = "=onWritePossible";
        try {
            output.write(message.getBytes());
            ac.complete();
        } catch (Exception ex) {
            ac.complete();
            throw new IllegalStateException(ex);
        }
    }

    public void onError(final Throwable t) {
        ac.complete();
        t.printStackTrace();
    }
}