/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */
package com.sun.ts.tests.servlet.spec.pluggability.common;

import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import java.util.ArrayList;

public final class RequestListener6 implements ServletRequestListener {

    public void requestDestroyed(ServletRequestEvent event) {
        ArrayList al = null;
        al = (ArrayList) event.getServletContext().getAttribute("testmessage");
        if (al != null) {
            al.add("RequestListener6 requestDestroyed");
            event.getServletContext().setAttribute("testmessage", al);
        }
    }

    public void requestInitialized(ServletRequestEvent event) {
        ArrayList al = null;
        al = (ArrayList) event.getServletContext().getAttribute("testmessage");
        if (al == null) {
            al = new ArrayList();
        }
        al.add("RequestListener6 requestInitialized");
        event.getServletContext().setAttribute("testmessage", al);
    }
}
