/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */



package com.sun.ts.tests.servlet.spec.security.secform;


import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.annotation.WebServlet;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.annotation.ServletSecurity.*;
import javax.servlet.annotation.HttpMethodConstraint;
import javax.servlet.annotation.HttpConstraint;
import javax.annotation.security.DeclareRoles;



/*
 * This should allow the Aministrator role perms to access any of the servlet
 * methods.  This is an annotation based equivalent of ServletSecTestServlet 
 * with the main difference being that this uses Servlet based annotations whereas
 * ServletSecTestServlet uses DD for configuring its security constraints.
 */


@DeclareRoles({"ADM", "MGR", "EMP"})
@ServletSecurity(value = @HttpConstraint(EmptyRoleSemantic.DENY),
        httpMethodConstraints = { @HttpMethodConstraint(value = "GET", rolesAllowed = "Administrator"),
                                  @HttpMethodConstraint(value = "POST", rolesAllowed = "Administrator")
         }) 
@WebServlet(name="ServletSecAnnoTestLogicalName", urlPatterns={"/ServletSecAnnoTest"})
public class ServletSecAnnoTestServlet extends HttpServlet {

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

        PrintWriter out = response.getWriter();

        System.out.println("Inside  ServletSecAnnoTestServlet ....." + "<BR>");
        System.out.println("The user principal is: " + request.getUserPrincipal().getName() + "<BR>");
        System.err.println("The user principal is: " + request.getUserPrincipal().getName() + "<BR>");
        
        out.println("The user principal is: " + request.getUserPrincipal().getName() + "<BR>");
        out.println("getRemoteUser(): " + request.getRemoteUser() + "<BR>");

        out.println("Inside  ServletSecAnnoTestServlet ....." + "<BR>");  // used for validating test7

        // Surround these with !'s so they are easier to search for.
        // (i.e. we can search for !true! or !false!)
        out.println("isUserInRole(\"ADM\"): !" + request.isUserInRole("ADM") + "!<BR>");
        out.println("isUserInRole(\"MGR\"): !" + request.isUserInRole("MGR") + "!<BR>");
        out.println("isUserInRole(\"VP\"): !" + request.isUserInRole("VP") + "!<BR>");
        out.println("isUserInRole(\"EMP\"): !" + request.isUserInRole("EMP") + "!<BR>");
        out.println("isUserInRole(\"Administrator\"): !" + request.isUserInRole("Administrator") + "!<BR>");
    }
}

