/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.servlet.spec.serverpush;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.PushBuilder;
import java.io.IOException;
import java.io.PrintWriter;

public class TestServlet extends HttpServlet {
  @Override
  protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
    PrintWriter pw = resp.getWriter();
    PushBuilder pb = req.newPushBuilder();
    if (pb == null) {
      pw.println("Get Null PushBuilder");
    } else {
      pw.println("hello");
      pb.path("index.html");
      pb.addHeader("If-Match", "*");
      pb.push();
      pw.println(pb.getPath() == null ? "path is cleared" : "path is not cleared");
      pw.println(pb.getHeader("If-Match") == null ? "conditional headers are cleared" : "conditional headers are not cleared");
    }
  }
}
