/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */
package com.sun.ts.tests.servlet.spec.srlistener;

import com.sun.ts.tests.servlet.common.util.ServletTestUtil;
import javax.servlet.ServletException;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.RequestDispatcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServlet;

public class ForwardedServlet extends HttpServlet {

    private static final String TEST_HEADER = "testname";
    private static final Class[] TEST_ARGS = {HttpServletRequest.class,
        HttpServletResponse.class
    };

    public void service(HttpServletRequest req, HttpServletResponse res)
            throws ServletException, IOException {
        String test = req.getParameter(TEST_HEADER);
        try {
            Method method = this.getClass().getMethod(test, TEST_ARGS);
            method.invoke(this, new Object[]{req, res});
        } catch (InvocationTargetException ite) {
            throw new ServletException(ite.getTargetException());
        } catch (NoSuchMethodException nsme) {
            throw new ServletException("Test: " + test + " does not exist");
        } catch (Throwable t) {
            throw new ServletException("Error executing test: " + test, t);
        }
    }

    public void simple(HttpServletRequest req, HttpServletResponse res)
            throws ServletException, IOException {
        PrintWriter pw = res.getWriter();
        pw.print("ForwardedServlet Invoked, simple method");
        System.out.println("In ForwardedServlet, simple method");
        ServletTestUtil.printResult(pw, true);
    }

    public void forwardagain(HttpServletRequest request,
            HttpServletResponse response)
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();

        String path = "/forward/SecondForwardedServlet?testname=simple";
        RequestDispatcher rd = getServletContext().getRequestDispatcher(path);
        System.out.println("In forwardedServlet, forwardagain method");
        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            rd.forward(request, response);
        }
    }

    public void include(HttpServletRequest request,
            HttpServletResponse response)
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();

        String path = "/include/IncludedServlet?testname=simple";
        RequestDispatcher rd = getServletContext().getRequestDispatcher(path);
        System.out.println("In forwardedServlet, include method");
        if (rd == null) {
            pw.println("Null RequestDispatcher got for path=" + path);
        } else {
            rd.forward(request, response);
        }
    }

    public void error(HttpServletRequest req, HttpServletResponse res)
            throws ServletException, IOException {
        System.out.println("In ForwardedServlet, error method");
        res.sendError(403);
    }
}
