/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.tck.tests.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.mvc.event.MvcEvent;
import javax.servlet.http.HttpServletRequest;

@ApplicationScoped
public class TraceManager {
    private final Map<String, TracedRequest> tracedRequests = new LinkedHashMap<String, TracedRequest>();
    @Inject
    private HttpServletRequest request;

    void eventObserved(MvcEvent event) {
        Class eventType = Arrays.stream(event.getClass().getInterfaces()).filter(type -> type.getPackage().getName().startsWith("javax.mvc")).findFirst().orElseThrow(() -> new IllegalStateException("Cannot identify event type"));
        this.logInternal(eventType.getSimpleName());
    }

    void controllerExecuted() {
        this.logInternal("ControllerExecuted");
    }

    void viewRendered() {
        this.logInternal("ViewRendered");
    }

    TracedRequest getTracedRequest(String id) {
        return this.tracedRequests.get(id);
    }

    private void logInternal(String event) {
        String tid = this.request.getParameter("tid");
        if (tid != null) {
            this.tracedRequests.computeIfAbsent(tid, _tid -> new TracedRequest()).add(event);
        }
    }

    public static class TracedRequest {
        private final List<String> events = new ArrayList<String>();

        void add(String message) {
            this.events.add(message);
        }

        public List<String> getEvents() {
            return this.events;
        }
    }
}

