/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.core.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.arquillian.core.impl.EventPointImpl;
import org.jboss.arquillian.core.impl.InjectionPointImpl;
import org.jboss.arquillian.core.impl.ObserverImpl;
import org.jboss.arquillian.core.impl.Reflections;
import org.jboss.arquillian.core.spi.EventPoint;
import org.jboss.arquillian.core.spi.Extension;
import org.jboss.arquillian.core.spi.InjectionPoint;
import org.jboss.arquillian.core.spi.ObserverMethod;
import org.jboss.arquillian.core.spi.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionImpl
implements Extension {
    private Object target;
    private List<InjectionPoint> injectionPoints;
    private List<EventPoint> eventPoints;
    private List<ObserverMethod> observers;

    public static ExtensionImpl of(Object target) {
        Validate.notNull((Object)target, (String)"Extension must be specified");
        return new ExtensionImpl(target, ExtensionImpl.injections(target, Reflections.getFieldInjectionPoints(target.getClass())), ExtensionImpl.events(target, Reflections.getEventPoints(target.getClass())), ExtensionImpl.observers(target, Reflections.getObserverMethods(target.getClass())));
    }

    private static List<ObserverMethod> observers(Object extension, List<Method> observerMethods) {
        ArrayList<ObserverMethod> result = new ArrayList<ObserverMethod>();
        for (Method method : observerMethods) {
            result.add(ObserverImpl.of(extension, method));
        }
        return result;
    }

    private static List<InjectionPoint> injections(Object extension, List<Field> injectionPoints) {
        ArrayList<InjectionPoint> result = new ArrayList<InjectionPoint>();
        for (Field field : injectionPoints) {
            result.add(InjectionPointImpl.of(extension, field));
        }
        return result;
    }

    private static List<EventPoint> events(Object extension, List<Field> eventPoints) {
        ArrayList<EventPoint> result = new ArrayList<EventPoint>();
        for (Field method : eventPoints) {
            result.add(EventPointImpl.of(extension, method));
        }
        return result;
    }

    ExtensionImpl(Object target, List<InjectionPoint> injectionPoints, List<EventPoint> eventPoints, List<ObserverMethod> observers) {
        this.target = target;
        this.injectionPoints = injectionPoints;
        this.eventPoints = eventPoints;
        this.observers = observers;
    }

    public Object getTarget() {
        return this.target;
    }

    public List<InjectionPoint> getInjectionPoints() {
        return Collections.unmodifiableList(this.injectionPoints);
    }

    public List<EventPoint> getEventPoints() {
        return Collections.unmodifiableList(this.eventPoints);
    }

    public List<ObserverMethod> getObservers() {
        return Collections.unmodifiableList(this.observers);
    }
}

