/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.core.impl.loadable;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.impl.loadable.ServiceRegistryLoader;
import org.jboss.arquillian.core.spi.ServiceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceRegistry {
    private final Injector injector;
    private final Map<Class<?>, Set<Class<?>>> registry = new HashMap();
    private final Map<Class<?>, Set<Class<?>>> vetoed;

    public ServiceRegistry(Injector injector, Map<Class<?>, Set<Class<?>>> vetoed) {
        this.vetoed = new HashMap(vetoed);
        this.injector = injector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void addService(Class<T> service, Class<? extends T> serviceImpl) {
        Map<Class<?>, Set<Class<?>>> map = this.registry;
        synchronized (map) {
            if (this.isImplementationVetoed(service, serviceImpl)) {
                return;
            }
            Set<Class<?>> registeredImpls = this.registry.get(service);
            if (registeredImpls == null) {
                registeredImpls = new HashSet();
            }
            registeredImpls.add(serviceImpl);
            this.registry.put(service, registeredImpls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void removeService(Class<T> service, Class<? extends T> serviceImpl) {
        Map<Class<?>, Set<Class<?>>> map = this.registry;
        synchronized (map) {
            Set<Class<?>> registeredImpls = this.registry.get(service);
            if (registeredImpls == null) {
                return;
            }
            registeredImpls.remove(serviceImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void overrideService(Class<T> service, Class<? extends T> oldServiceImpl, Class<? extends T> newServiceImpl) {
        Map<Class<?>, Set<Class<?>>> map = this.registry;
        synchronized (map) {
            if (this.isImplementationVetoed(service, newServiceImpl)) {
                return;
            }
            Set<Class<?>> vetoedImpls = this.vetoed.get(service);
            if (vetoedImpls == null) {
                vetoedImpls = new HashSet();
                this.vetoed.put(service, vetoedImpls);
            }
            vetoedImpls.add(oldServiceImpl);
            this.removeService(service, oldServiceImpl);
            this.addService(service, newServiceImpl);
        }
    }

    public <T> Set<Class<? extends T>> getServiceImpls(Class<T> service) {
        Set<Class<?>> registeredImpls = this.registry.get(service);
        HashSet<Class<T>> typedImpls = new HashSet<Class<T>>();
        if (registeredImpls == null) {
            return typedImpls;
        }
        for (Class<?> registeredImpl : registeredImpls) {
            typedImpls.add(registeredImpl.asSubclass(service));
        }
        return typedImpls;
    }

    private <T> boolean isImplementationVetoed(Class<?> service, Class<? extends T> serviceImpl) {
        Set<Class<?>> vetoedImpls = this.vetoed.get(service);
        return vetoedImpls != null && vetoedImpls.contains(serviceImpl);
    }

    public void clear() {
        this.registry.clear();
    }

    public ServiceLoader getServiceLoader() {
        return new ServiceRegistryLoader(this.injector, this);
    }
}

