/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.api.jakarta_servlet.jsp.tagext.bodycontent;

import ee.jakarta.tck.pages.api.jakarta_servlet.jsp.tagext.bodycontent.BodyContentClearBodyTag;
import ee.jakarta.tck.pages.api.jakarta_servlet.jsp.tagext.bodycontent.BodyContentFlushTag;
import ee.jakarta.tck.pages.api.jakarta_servlet.jsp.tagext.bodycontent.BodyContentGetStringTag;
import ee.jakarta.tck.pages.api.jakarta_servlet.jsp.tagext.bodycontent.BodyContentReadWriteTag;
import ee.jakarta.tck.pages.api.jakarta_servlet.jsp.tagext.bodycontent.BodyContentWriteOutTag;
import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import ee.jakarta.tck.pages.common.util.JspTestUtil;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        String packagePath = URLClientIT.class.getPackageName().replace(".", "/");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_bodycontent_web.war");
        archive.addClasses(new Class[]{BodyContentClearBodyTag.class, BodyContentFlushTag.class, BodyContentGetStringTag.class, BodyContentReadWriteTag.class, BodyContentWriteOutTag.class, JspTestUtil.class});
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_bodycontent_web.xml"));
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/bodycontent.tld", "bodycontent.tld");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/BodyContentClearBodyTest.jsp")), "BodyContentClearBodyTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/BodyContentFlushTest.jsp")), "BodyContentFlushTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/BodyContentGetStringTest.jsp")), "BodyContentGetStringTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/BodyContentReadWriteTest.jsp")), "BodyContentReadWriteTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/BodyContentWriteOutTest.jsp")), "BodyContentWriteOutTest.jsp");
        return archive;
    }

    @Test
    public void bodyContentFlushTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_bodycontent_web/BodyContentFlushTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
    }

    @Test
    public void bodyContentClearBodyTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_bodycontent_web/BodyContentClearBodyTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("unexpected_response_match", "Test FAILED");
        this.invoke();
    }

    @Test
    public void bodyContentReadWriteTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_bodycontent_web/BodyContentReadWriteTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "#TestPASSED#");
        this.invoke();
    }

    @Test
    public void bodyContentWriteOutTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_bodycontent_web/BodyContentWriteOutTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
    }

    @Test
    public void bodyContentGetStringTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_bodycontent_web/BodyContentGetStringTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
    }
}

