/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.spec.configuration.encoding;

import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    public URLClientIT() throws Exception {
        this.setContextRoot("/jsp_config_encode_web");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        String packagePath = URLClientIT.class.getPackageName().replace(".", "/");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_config_encode_web.war");
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_config_encode_web.xml"));
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/DifferentEncodingSpecifiedTest.jsp")), "DifferentEncodingSpecifiedTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/DifferentEncodingSpecifiedTest.jspx")), "DifferentEncodingSpecifiedTest.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/NoEncodingSpecifiedTest.jsp")), "NoEncodingSpecifiedTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/SameEncodingSpecifiedTest.jsp")), "SameEncodingSpecifiedTest.jsp");
        return archive;
    }

    @Test
    public void jspConfigurationEncodingTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_config_encode_web/NoEncodingSpecifiedTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("expected_headers", "Content-Type:text/plain;charset=UTF-8");
        this.invoke();
    }

    @Test
    public void jspConfigurationSameEncodingTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_config_encode_web/SameEncodingSpecifiedTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("expected_headers", "Content-Type:text/plain;charset=UTF-8");
        this.invoke();
    }

    @Test
    public void jspConfigurationDifferentEncodingTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_config_encode_web/DifferentEncodingSpecifiedTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_config_encode_web/DifferentEncodingSpecifiedTest.jspx HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }
}

