/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.spec.el.jsp;

import ee.jakarta.tck.pages.common.util.JspTestUtil;
import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.tagext.SimpleTagSupport;
import java.io.IOException;

public class ELDeferredValueCoercionTag
extends SimpleTagSupport {
    private static final int EXPECTEDINTVAL = 8128;
    private static final String EXPECTEDBOOKVAL = "Moby Dick";
    private ValueExpression intExpr;
    private ValueExpression bookExpr;

    public void setIntExpr(ValueExpression intExpr) {
        this.intExpr = intExpr;
    }

    public void setBookExpr(ValueExpression bookExpr) {
        this.bookExpr = bookExpr;
    }

    public void doTag() throws JspException, IOException {
        ELContext elContext = this.getJspContext().getELContext();
        JspWriter out = this.getJspContext().getOut();
        try {
            Class expectedIntClass = this.intExpr.getExpectedType();
            if (!expectedIntClass.getName().equals("int")) {
                out.println("Test FAILED. Expected type = int");
                out.println("Got type = " + expectedIntClass.getName());
                return;
            }
            Object intVal = this.intExpr.getValue(elContext);
            int coercedIntVal = (Integer)intVal;
            if (coercedIntVal != 8128) {
                out.println("Test FAILED. Wrong value for int expression.");
                out.println("Expected value: 8128");
                out.println("Got value: " + coercedIntVal);
                return;
            }
            Class expectedBookClass = this.bookExpr.getExpectedType();
            if (!expectedBookClass.getName().equals("java.lang.String")) {
                out.println("Test FAILED. Expected type = java.lang.String");
                out.println("Got type = " + expectedBookClass.getName());
                return;
            }
            Object bookVal = this.bookExpr.getValue(elContext);
            String coercedBookVal = (String)bookVal;
            if (!coercedBookVal.equals(EXPECTEDBOOKVAL)) {
                out.println("Test FAILED. Wrong value for book expression.");
                out.println("Expected value: Moby Dick");
                out.println("Got value: " + coercedBookVal);
                return;
            }
            out.println("Test PASSED.");
        }
        catch (Throwable t) {
            JspTestUtil.handleThrowable(t, out, "ELDeferredValueCoercionTag");
        }
    }
}

