/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.provider.overridestandard;

import ee.jakarta.tck.ws.rs.spec.provider.overridestandard.AbstractProvider;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

@Provider
public class TckFileProvider
extends AbstractProvider
implements MessageBodyReader<File>,
MessageBodyWriter<File> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == File.class;
    }

    public long getSize(File t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.getLength();
    }

    public void writeTo(File t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        FileReader fr = new FileReader(t);
        BufferedReader br = new BufferedReader(fr);
        String text = br.readLine();
        br.close();
        entityStream.write(text == null ? "".getBytes() : text.getBytes());
        entityStream.write(this.getWriterName().getBytes());
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isWriteable(type, genericType, annotations, mediaType);
    }

    public File readFrom(Class<File> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        File f = File.createTempFile("tckjaxrs", "tmp");
        FileWriter fw = new FileWriter(f);
        fw.write(this.getReaderName());
        fw.close();
        return f;
    }
}

