/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.api.jakarta_servlet_http.httpupgradehandler;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;

public class TCKReadListener
implements ReadListener {
    private ServletInputStream input = null;
    private ServletOutputStream output = null;
    private String delimiter = null;

    TCKReadListener(String del, ServletInputStream in, ServletOutputStream out) {
        this.input = in;
        this.output = out;
        this.delimiter = del;
    }

    public void onDataAvailable() {
        try {
            this.output.println("=onDataAvailable");
            StringBuilder sb = new StringBuilder();
            int len = -1;
            byte[] b = new byte[1024];
            while (this.input.isReady() && (len = this.input.read(b)) != -1) {
                String data = new String(b, 0, len);
                sb.append(data);
            }
            this.output.println(this.delimiter + sb.toString());
            this.output.flush();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void onAllDataRead() {
        try {
            this.output.println("=onAllDataRead");
            this.output.close();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void onError(Throwable t) {
        t.printStackTrace();
    }
}

