/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.common.util;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.Cookie;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletTestUtil {
    private static Logger LOGGER = LoggerFactory.getLogger(ServletTestUtil.class);
    public static boolean SUPPORT_CROSS_CONTEXT = Boolean.parseBoolean(System.getProperty("servlet.tck.support.crossContext", "true"));

    private ServletTestUtil() {
    }

    public static boolean checkEnumeration(Enumeration<String> e, String[] values) {
        return ServletTestUtil.checkEnumeration(e, values, true, true);
    }

    public static boolean checkEnumeration(Enumeration<?> e, String[] values, boolean enforceSizes, boolean allowDuplicates) {
        ArrayList foundValues = null;
        if (e == null || !e.hasMoreElements() || values == null) {
            return false;
        }
        if (!allowDuplicates) {
            foundValues = new ArrayList();
        }
        boolean valuesFound = true;
        Arrays.sort(values);
        int count = 0;
        while (e.hasMoreElements()) {
            Object val;
            block9: {
                try {
                    val = e.nextElement();
                    ++count;
                    if (allowDuplicates) break block9;
                    if (foundValues.contains(val)) {
                        LOGGER.debug("[ServletTestUtil] Duplicate values found in Enumeration when duplicates are not allowed.Values found in the Enumeration: {}", (Object)ServletTestUtil.getAsString(e));
                        valuesFound = false;
                        break;
                    }
                    foundValues.add(val);
                }
                catch (NoSuchElementException nsee) {
                    LOGGER.info("[ServletTestUtil] There were less elements in the Enumeration than expected");
                    valuesFound = false;
                    break;
                }
            }
            LOGGER.debug("[ServletTestUtil] Looking for '{}' in values: {}", val, (Object)ServletTestUtil.getAsString(values));
            if (Arrays.binarySearch(values, val) >= 0 || !enforceSizes) continue;
            LOGGER.info("[ServletTestUtil] Value '{}' not found.", val);
            valuesFound = false;
        }
        if (enforceSizes) {
            if (e.hasMoreElements()) {
                LOGGER.info("[ServletTestUtil] There were more elements in the Enumeration than expected.");
                valuesFound = false;
            }
            if (count != values.length) {
                LOGGER.info("[ServletTestUtil] There number of elements in the Enumeration did not match number of expected values.Expected number of Values= {}, Actual number of Enumeration elements= {}", (Object)values.length, (Object)count);
                valuesFound = false;
            }
        }
        return valuesFound;
    }

    public static boolean checkArrayList(ArrayList al, String[] values, boolean enforceSizes, boolean allowDuplicates) {
        ArrayList<String> foundValues = null;
        if (al == null || al.isEmpty() || values == null) {
            return false;
        }
        if (!allowDuplicates) {
            foundValues = new ArrayList<String>();
        }
        al.trimToSize();
        boolean valuesFound = true;
        Arrays.sort(values);
        int len = al.size();
        for (int i = 0; i < len; ++i) {
            String val = (String)al.get(i);
            LOGGER.debug("[ServletTestUtil] val= {}", (Object)val);
            if (!allowDuplicates) {
                if (foundValues.contains(val)) {
                    LOGGER.info("[ServletTestUtil] Duplicate values found in ArrayList when duplicates are not allowed.Values found in the ArrayList: {}", (Object)ServletTestUtil.getAsString(al));
                    valuesFound = false;
                    break;
                }
                foundValues.add(val);
            }
            LOGGER.debug("[ServletTestUtil] Looking for '{}' in values: {}", (Object)val, (Object)ServletTestUtil.getAsString(values));
            if (Arrays.binarySearch(values, val) >= 0 || !enforceSizes) continue;
            LOGGER.info("[ServletTestUtil] Value '{}' not found.", (Object)val);
            valuesFound = false;
        }
        if (enforceSizes && len != values.length) {
            LOGGER.info("[ServletTestUtil] There number of elements in the ArrayList did not match number of expected values.Expected number of Values= {}, Actual number of ArrayList elements= {}", (Object)values.length, (Object)len);
            valuesFound = false;
        }
        return valuesFound;
    }

    public static boolean compareString(String expected, String actual) {
        String[] list_expected = expected.split("[|]");
        boolean found = true;
        int n = list_expected.length;
        int startIdx = 0;
        int bodyLength = actual.length();
        for (int i = 0; i < n; ++i) {
            String search = list_expected[i];
            if (startIdx >= bodyLength) {
                startIdx = bodyLength;
            }
            int searchIdx = actual.toLowerCase().indexOf(search.toLowerCase(), startIdx);
            LOGGER.debug("[ServletTestUtil] Scanning response for search string: '{}' starting at index location: {}", (Object)search, (Object)startIdx);
            if (searchIdx < 0) {
                found = false;
                StringBuffer sb = new StringBuffer(255);
                sb.append("[ServletTestUtil] Unable to find the following search string in the server's response: '").append(search).append("' at index: ").append(startIdx).append("\n[ServletTestUtil] Server's response:\n").append("-------------------------------------------\n").append(actual).append("\n-------------------------------------------\n");
                LOGGER.debug(sb.toString());
                break;
            }
            LOGGER.debug("[ServletTestUtil] Found search string: '{}' at index '{}' in the server's response", (Object)search, (Object)searchIdx);
            startIdx = searchIdx + search.length();
        }
        return found;
    }

    public static String getAsString(Object[] sArray) {
        return sArray == null ? null : Stream.of(sArray).map(Object::toString).collect(Collectors.joining(",", "[", "]"));
    }

    public static String getAsString(List<String> al) {
        return al == null ? null : al.stream().collect(Collectors.joining(",", "[", "]"));
    }

    public static String getAsString(Enumeration e) {
        return ServletTestUtil.getAsString(ServletTestUtil.getAsArray(e));
    }

    public static Object[] getAsArray(Enumeration<Object> e) {
        ArrayList<Object> list = new ArrayList<Object>();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        return list.toArray(new Object[0]);
    }

    public static String[] getAsArray(String value) {
        StringTokenizer st = new StringTokenizer(value, ",");
        String[] retValues = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            retValues[i] = st.nextToken();
            ++i;
        }
        return retValues;
    }

    public static void printResult(PrintWriter pw, String s) {
        if (s == null || s.equals("")) {
            pw.println("Test PASSED");
        } else {
            pw.println("Test FAILED: " + s);
        }
    }

    public static void printResult(PrintWriter pw, boolean b) {
        if (b) {
            pw.println("Test PASSED");
        } else {
            pw.println("Test FAILED");
        }
    }

    public static void printResult(ServletOutputStream pw, boolean b) throws IOException {
        if (b) {
            pw.println("Test PASSED");
        } else {
            pw.println("Test FAILED");
        }
    }

    public static void printFailureData(PrintWriter pw, ArrayList result, Object[] expected) {
        pw.println("Unable to find the expected values:\n    " + ServletTestUtil.getAsString(expected) + "\nin the results returned by the test which were:\n   " + ServletTestUtil.getAsString(result));
    }

    public static void printFailureData(PrintWriter pw, Enumeration result, Object[] expected) {
        pw.println("Unable to find the expected values:\n    " + ServletTestUtil.getAsString(expected) + "\nin the results returned by the test which were:\n   " + ServletTestUtil.getAsString(result));
    }

    public static int findCookie(Cookie[] cookie, String name) {
        boolean found = false;
        int i = 0;
        if (cookie != null) {
            while (!found && i < cookie.length) {
                if (cookie[i].getName().equals(name)) {
                    found = true;
                    continue;
                }
                ++i;
            }
        } else {
            found = false;
        }
        if (found) {
            return i;
        }
        return -1;
    }
}

