/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.signature;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class SigTestResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String NL = System.getProperty("line.separator", "\n");
    private List<String> failedPkgs = new ArrayList<String>();
    private List<String> passedPkgs = new ArrayList<String>();
    private List<String> failedClasses = new ArrayList<String>();
    private List<String> passedClasses = new ArrayList<String>();

    public synchronized boolean passed() {
        return this.failedPkgs.size() == 0 && this.failedClasses.size() == 0;
    }

    public synchronized void addFailedPkg(String pkg) {
        this.failedPkgs.add(pkg);
    }

    public synchronized void addPassedPkg(String pkg) {
        this.passedPkgs.add(pkg);
    }

    public synchronized void addFailedClass(String className) {
        this.failedClasses.add(className);
    }

    public synchronized void addPassedClass(String className) {
        this.passedClasses.add(className);
    }

    public String toString() {
        String delim = "******************************************************" + NL;
        if (!this.pkgsTested() && !this.classesTested()) {
            return delim + "******** No packages or classes were tested **********" + NL + delim;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(delim);
        buf.append(delim);
        if (this.passed()) {
            buf.append("All package signatures passed.").append(NL);
        } else {
            buf.append("Some signatures failed.").append(NL);
            if (this.failedPkgs.size() > 0) {
                buf.append("\tFailed packages listed below: ").append(NL);
                this.formatList(this.failedPkgs, buf);
            }
            if (this.failedClasses.size() > 0) {
                buf.append("\tFailed classes listed below: ").append(NL);
                this.formatList(this.failedClasses, buf);
            }
        }
        if (this.passedPkgs.size() > 0) {
            buf.append("\tPassed packages listed below: ").append(NL);
            this.formatList(this.passedPkgs, buf);
        }
        if (this.passedClasses.size() > 0) {
            buf.append("\tPassed classes listed below: ").append(NL);
            this.formatList(this.passedClasses, buf);
        }
        buf.append("\t");
        buf.append(delim);
        buf.append(delim);
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void formatList(List<String> list, StringBuffer buf) {
        SigTestResult sigTestResult = this;
        synchronized (sigTestResult) {
            for (int i = 0; i < list.size(); ++i) {
                String pkg = list.get(i);
                buf.append("\t\t").append(pkg).append(NL);
            }
        }
    }

    private synchronized boolean pkgsTested() {
        return this.failedPkgs.size() != 0 || this.passedPkgs.size() != 0;
    }

    private synchronized boolean classesTested() {
        return this.failedClasses.size() != 0 || this.passedClasses.size() != 0;
    }
}

