/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.spec.annotationservlet.webfilter;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.annotation.WebInitParam;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import servlet.tck.common.util.StaticLog;

@WebFilter(filterName="filter2", dispatcherTypes={DispatcherType.FORWARD}, servletNames={"servlet1"}, value={"/Servlet1"}, initParams={@WebInitParam(name="name1", value="value1"), @WebInitParam(name="name2", value="value2")})
public final class TestFilter2
implements Filter {
    private FilterConfig filterConfig = null;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.filterConfig == null) {
            StaticLog.add("FAILED_FILTER2_INVOKED");
        } else {
            StaticLog.add("FILTER2_INVOKED");
            StaticLog.add("FilterName=" + this.filterConfig.getFilterName());
            Enumeration names = this.filterConfig.getInitParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                StaticLog.add("PName=" + name + " PVALUE=" + this.filterConfig.getInitParameter(name));
            }
            StaticLog.add("AsyncSupport=" + request.isAsyncSupported());
            FilterRegistration fr = this.filterConfig.getServletContext().getFilterRegistration(this.filterConfig.getFilterName());
            Collection mapping = fr.getServletNameMappings();
            for (String url : mapping) {
                StaticLog.add("URL=" + url);
            }
            StaticLog.add("DispatcherType=" + String.valueOf(request.getDispatcherType()));
            StaticLog.add("From=" + String.valueOf(request.getAttribute("from")));
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }
}

