/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.spec.httpservletresponse;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import servlet.tck.common.servlets.HttpTCKServlet;

public class HttpTestServlet
extends HttpTCKServlet {
    public void intHeaderTest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.addIntHeader("header1", 12345);
        response.flushBuffer();
        response.addIntHeader("header2", 56789);
    }

    public void flushBufferOnContentLengthTest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession(true);
        Object illegalStateException = session.getAttribute("IllegalStateException");
        if (illegalStateException instanceof IllegalStateException) {
            throw (IllegalStateException)illegalStateException;
        }
        int size = 40;
        response.setContentLength(size);
        ServletOutputStream out = response.getOutputStream();
        byte[] passed = "Test PASSED\n".getBytes(StandardCharsets.ISO_8859_1);
        out.write(passed);
        byte[] fill = new byte[size - passed.length];
        Arrays.fill(fill, (byte)120);
        out.write(fill);
        response.addIntHeader("header1", 12345);
        try {
            out.write(fill);
            session.setAttribute("IllegalStateException", (Object)new IllegalStateException("write did not fail"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void flushBufferOnContentLengthCommittedTest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession(true);
        Object illegalStateException = session.getAttribute("IllegalStateException");
        if (illegalStateException instanceof IllegalStateException) {
            throw (IllegalStateException)illegalStateException;
        }
        int size = 40;
        response.setContentLength(size);
        ServletOutputStream out = response.getOutputStream();
        byte[] passed = "Test PASSED\n".getBytes(StandardCharsets.ISO_8859_1);
        out.write(passed);
        response.flushBuffer();
        byte[] fill = new byte[size - passed.length];
        Arrays.fill(fill, (byte)120);
        out.write(fill);
        try {
            out.write(fill);
            session.setAttribute("IllegalStateException", (Object)new IllegalStateException("write did not fail"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sendErrorCommitTest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        response.sendError(200, "sendErrorCommitTest");
        response.addIntHeader("header1", 12345);
        pw.println("Test FAILED in sendErrorCommitTest");
    }

    public void sendRedirectClearBufferTest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        pw.println("Test FAILED in sendRedirectClearBufferTest");
        response.sendRedirect("/RedirectedTest");
    }

    public void sendRedirectCommitTest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        response.sendRedirect("/RedirectedTest");
        response.addIntHeader("header1", 12345);
        pw.println("Test FAILED in sendRedirectCommitTest");
    }
}

