/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.common.request;

import java.io.IOException;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import servlet.tck.common.request.HttpResponse;

public class HttpExchange {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpExchange.class);
    public static int DEFAULT_HTTP_PORT = 80;
    public static final int DEFAULT_SSL_PORT = 443;
    public static final int NO_AUTHENTICATION = 0;
    public static final int BASIC_AUTHENTICATION = 1;
    public static final int DIGEST_AUTHENTICATION = 2;
    private String method;
    private String host;
    private int port = DEFAULT_HTTP_PORT;
    private boolean _isSecure = false;
    private String _requestLine = null;
    private int _authType = 0;
    private boolean _useCookies = false;
    private boolean _redirect = false;
    List<HttpHeaders> headers = null;
    private boolean state;
    private String uri;
    private String query;
    private String content;
    private String username;
    private String password;
    private int authType;
    private String realm;
    private final Map<String, List<String>> requestHeaders = new HashMap<String, List<String>>();
    private boolean followRedirect;
    private final List<HttpCookie> httpCookies = new ArrayList<HttpCookie>();
    private static final ThreadLocal<HttpClient> httpClientThreadLocal = new ThreadLocal();

    public HttpExchange(String requestLine, String host, int port) {
        StringTokenizer st = new StringTokenizer(requestLine);
        try {
            this.method = st.nextToken();
            this.uri = st.nextToken();
            String version = st.nextToken();
        }
        catch (NoSuchElementException nsee) {
            throw new IllegalArgumentException("Request provided: " + requestLine + " is malformed.");
        }
        this.host = host;
        this.port = port;
        if (port == 443) {
            this._isSecure = true;
        }
        this._requestLine = requestLine;
        int queryStart = this.uri.indexOf(63);
        if (queryStart != -1) {
            this.query = this.uri.substring(queryStart + 1);
            this.uri = this.uri.substring(0, queryStart);
        }
    }

    public String getRequestPath() {
        return this.uri;
    }

    public String getRequestMethod() {
        return this.method;
    }

    public boolean isSecureRequest() {
        return this._isSecure;
    }

    public void setSecureRequest(boolean secure) {
        this._isSecure = secure;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setAuthenticationCredentials(String username, String password, int authType, String realm) {
        if (username == null) {
            throw new IllegalArgumentException("Username cannot be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Password cannot be null");
        }
        this.username = username;
        this.password = password;
        this.realm = realm;
        LOGGER.debug("Added credentials for '{}' with password '{}' in realm '{}'", new Object[]{username, password, realm});
        this._authType = authType;
    }

    public void addRequestHeader(String headerName, String headerValue) {
        this.requestHeaders.computeIfAbsent(headerName, k -> new ArrayList()).add(headerValue);
        LOGGER.debug("Added request header: {}:{}", (Object)headerName, (Object)headerValue);
    }

    public void addRequestHeader(String header) {
        StringTokenizer st = new StringTokenizer(header, "|");
        while (st.hasMoreTokens()) {
            String h = st.nextToken();
            if (h.toLowerCase().startsWith("cookie")) {
                this.createCookie(h);
                continue;
            }
            int col = h.indexOf(58);
            this.addRequestHeader(h.substring(0, col).trim(), h.substring(col + 1).trim());
        }
    }

    public void setRequestHeader(String headerName, String headerValue) {
        this.requestHeaders.computeIfAbsent(headerName, k -> new ArrayList()).add(headerValue);
        LOGGER.trace("Set request header: {}:{}", (Object)headerName, (Object)headerValue);
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirect = followRedirects;
    }

    public boolean getFollowRedirects() {
        return this.followRedirect;
    }

    /*
     * WARNING - void declaration
     */
    public HttpResponse execute() throws IOException {
        void var10_13;
        CookieManager cookieManager = new CookieManager();
        HttpClient.Builder builder = HttpClient.newBuilder().followRedirects(this.followRedirect ? HttpClient.Redirect.ALWAYS : HttpClient.Redirect.NEVER).version(HttpClient.Version.HTTP_1_1).cookieHandler(cookieManager);
        StringBuilder url = new StringBuilder();
        if (this.isSecureRequest()) {
            url.append("https://");
        } else {
            url.append("http://");
        }
        url.append(this.host).append(':').append(this.port);
        url.append(this.uri);
        if (this.query != null) {
            url.append('?').append(this.query);
        }
        HttpClient httpClient = null;
        if (this.state) {
            httpClient = httpClientThreadLocal.get();
        } else {
            httpClientThreadLocal.remove();
        }
        if (httpClient == null) {
            httpClient = builder.build();
        }
        if (this.state) {
            httpClientThreadLocal.set(httpClient);
        }
        URI uri = URI.create(url.toString());
        HttpRequest.Builder httpRequestBuilder = HttpRequest.newBuilder().uri(uri);
        if (!this.httpCookies.isEmpty()) {
            cookieManager.put(uri, this.httpCookies.stream().collect(Collectors.toMap(HttpCookie::getName, o -> Collections.singletonList(o.getValue()))));
            this.httpCookies.forEach(httpCookie -> cookieManager.getCookieStore().add(uri, (HttpCookie)httpCookie));
        }
        String string = this.method;
        int n = -1;
        switch (string.hashCode()) {
            case 70454: {
                if (!string.equals("GET")) break;
                boolean bl = false;
                break;
            }
            case 2213344: {
                if (!string.equals("HEAD")) break;
                boolean bl = true;
                break;
            }
            case 2461856: {
                if (!string.equals("POST")) break;
                int n2 = 2;
            }
        }
        switch (var10_13) {
            case 0: {
                httpRequestBuilder.GET();
                break;
            }
            case 1: {
                httpRequestBuilder.method("HEAD", HttpRequest.BodyPublishers.noBody());
                break;
            }
            case 2: {
                httpRequestBuilder.POST(this.content == null ? HttpRequest.BodyPublishers.noBody() : HttpRequest.BodyPublishers.ofString(this.content));
                break;
            }
            default: {
                throw new RuntimeException("unknown method " + this.method);
            }
        }
        switch (this._authType) {
            case 0: {
                break;
            }
            case 1: {
                httpRequestBuilder.header("Authorization", HttpExchange.getBasicAuthenticationHeader(this.username, this.password));
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Digest Authentication is not currently supported");
            }
        }
        for (Map.Entry entry : this.requestHeaders.entrySet()) {
            ((List)entry.getValue()).forEach(s -> httpRequestBuilder.header((String)entry.getKey(), (String)s));
        }
        try {
            java.net.http.HttpResponse<String> response = httpClient.send(httpRequestBuilder.build(), HttpResponse.BodyHandlers.ofString());
            return new HttpResponse(this.host, this.port, this._isSecure, this.method, response);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private static String getBasicAuthenticationHeader(String username, String password) {
        String valueToEncode = username + ":" + password;
        return "Basic " + Base64.getEncoder().encodeToString(valueToEncode.getBytes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(255);
        sb.append("[REQUEST LINE] -> ").append(this._requestLine).append('\n');
        for (Map.Entry<String, List<String>> header : this.requestHeaders.entrySet()) {
            sb.append("[REQUEST HEADER] -> ");
            sb.append(header.getKey()).append(':').append(header.getValue()).append(System.lineSeparator());
        }
        if (this.content != null) {
            sb.append("[REQUEST BODY LENGTH] -> ").append(this.content.length());
            sb.append('\n');
        }
        return sb.toString();
    }

    public boolean isState() {
        return this.state;
    }

    public void setState(boolean state) {
        this.state = state;
    }

    private void createCookie(String cookieHeader) {
        String cookieLine = cookieHeader.substring(cookieHeader.indexOf(58) + 1).trim();
        StringTokenizer st = new StringTokenizer(cookieLine, " ;");
        String cookieName = "";
        String cookieValue = "";
        String cookieDomain = "";
        String cookiePath = "";
        int cookieVersion = 1;
        if (!cookieLine.contains("$Version")) {
            cookieVersion = 0;
        }
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.charAt(0) != '$' && !token.startsWith("Domain") && !token.startsWith("Path")) {
                cookieName = token.substring(0, token.indexOf(61));
                cookieValue = token.substring(token.indexOf(61) + 1);
                continue;
            }
            if (token.contains("Domain")) {
                cookieDomain = token.substring(token.indexOf(61) + 1);
                continue;
            }
            if (!token.contains("Path")) continue;
            cookiePath = token.substring(token.indexOf(61) + 1);
        }
        HttpCookie httpCookie = new HttpCookie(cookieName, cookieValue);
        if (!cookieDomain.isBlank()) {
            httpCookie.setDomain(cookieDomain);
        }
        if (!cookiePath.isBlank()) {
            httpCookie.setPath(cookiePath);
        }
        httpCookie.setVersion(cookieVersion);
        this.httpCookies.add(httpCookie);
    }
}

