/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.handshakeresponse;

import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.impl.ClientConfigurator;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.handshakeresponse.SetHeadersConfigurator;
import jakarta.websocket.ClientEndpointConfig;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSCClientIT
extends WebSocketCommonClient {
    private static final long serialVersionUID = 2315071335485201973L;
    static final String KEY = "aFirstKey";
    static final String[] HEADERS = new String[]{"header1", "header2", "header3", "header4", "header5", "header6", "header7", "header8"};

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"wsc_ee_jakarta_websocket_handshakeresponse_web.war");
        archive.addPackages(true, Filters.exclude((Class[])new Class[]{WSCClientIT.class}), new String[]{"com.sun.ts.tests.websocket.ee.jakarta.websocket.handshakeresponse"});
        archive.addClasses(new Class[]{IOUtil.class});
        return archive;
    }

    public WSCClientIT() throws Exception {
        this.setContextRoot("wsc_ee_jakarta_websocket_handshakeresponse_web");
    }

    @Test
    public void headerToHeaderTest() throws Exception {
        ClientConfigurator configurator = new ClientConfigurator();
        configurator.addToRequestAndResponse(KEY, HEADERS);
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
        this.setClientEndpointConfig(config);
        this.invoke("echo", "anything", new String[]{"anything"});
        configurator.assertBeforeRequestHasBeenCalled();
        configurator.assertAfterResponseHasBeenCalled();
    }

    @Test
    public void addHeadersOnServerTest() throws Exception {
        ClientConfigurator configurator = new ClientConfigurator();
        configurator.addToResponse(KEY, SetHeadersConfigurator.HEADERS);
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)configurator).build();
        this.setClientEndpointConfig(config);
        this.invoke("setheaders", "anything", new String[]{"anything"});
        configurator.assertBeforeRequestHasBeenCalled();
        configurator.assertAfterResponseHasBeenCalled();
    }
}

