/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.client;

import com.sun.ts.tests.websocket.common.client.ClientEndpoint;
import com.sun.ts.tests.websocket.common.client.SendMessageCallback;
import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.stringbean.StringBean;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.client.ByteArrayMessageHandler;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.client.ByteArrayPartialMessageHandler;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.client.ByteBufferMessageHandler;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.client.ByteBufferPartialMessageHandler;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.client.InputStreamMessageHandler;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.client.LinkedListHashSetMessageHandler;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.client.PongMessageHandler;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.client.ReaderMessageHandler;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.client.StringBeanMessageHandler;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.client.StringListWholeMessageHandler;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.client.StringPartialMessageHandler;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.client.StringTextMessageHandler;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.common.StringList;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.session11.common.TypeEnum;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.PongMessage;
import jakarta.websocket.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.LinkedList;

public class MixedProgramaticEndpoint
extends ClientEndpoint<String> {
    TypeEnum type;
    WebSocketCommonClient.Entity entity;

    public MixedProgramaticEndpoint(TypeEnum type, WebSocketCommonClient.Entity entity) {
        this.type = type;
        this.entity = entity;
    }

    public void onOpen(Session session, EndpointConfig config) {
        switch (this.type) {
            case LINKEDLIST_HASHSET_TEXT: {
                LinkedList list = new LinkedList();
                Class<?> clzLLHS = list.getClass();
                session.addMessageHandler(clzLLHS, (MessageHandler.Whole)new LinkedListHashSetMessageHandler(this));
                break;
            }
            case LIST_TEXT: {
                session.addMessageHandler(StringList.class, (MessageHandler.Whole)new StringListWholeMessageHandler(this));
                break;
            }
            case STRINGBEAN: {
                session.addMessageHandler(StringBean.class, (MessageHandler.Whole)new StringBeanMessageHandler(this));
                break;
            }
            case STRING_WHOLE: {
                session.addMessageHandler(String.class, (MessageHandler.Whole)new StringTextMessageHandler(this));
                break;
            }
            case STRING_PARTIAL: {
                session.addMessageHandler(String.class, (MessageHandler.Partial)new StringPartialMessageHandler(this));
                break;
            }
            case READER: {
                session.addMessageHandler(Reader.class, (MessageHandler.Whole)new ReaderMessageHandler(this));
                break;
            }
            case PONG: {
                session.addMessageHandler(PongMessage.class, (MessageHandler.Whole)new PongMessageHandler(this));
                break;
            }
            case BYTEBUFFER_WHOLE: {
                session.addMessageHandler(ByteBuffer.class, (MessageHandler.Whole)new ByteBufferMessageHandler(this));
                break;
            }
            case BYTEBUFFER_PARTIAL: {
                session.addMessageHandler(ByteBuffer.class, (MessageHandler.Partial)new ByteBufferPartialMessageHandler(this));
                break;
            }
            case BYTEARRAY_WHOLE: {
                byte[] ba = new byte[]{};
                Class<?> baclz = ba.getClass();
                session.addMessageHandler(baclz, (MessageHandler.Whole)new ByteArrayMessageHandler(this));
                break;
            }
            case BYTEARRAY_PARTIAL: {
                byte[] ba = new byte[]{};
                Class<?> baclz = ba.getClass();
                session.addMessageHandler(baclz, (MessageHandler.Partial)new ByteArrayPartialMessageHandler(this));
                break;
            }
            case INPUTSTREAM: {
                session.addMessageHandler(InputStream.class, (MessageHandler.Whole)new InputStreamMessageHandler(this));
                break;
            }
        }
        new SendMessageCallback(this.entity).onOpen(session, config);
    }

    public void sendMessage(Session session) {
        try {
            session.getBasicRemote().sendText((String)this.entity.getEntityAt(String.class, 0));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

