/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.websocketmessage;

import com.sun.ts.tests.websocket.common.util.IOUtil;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.io.IOException;
import java.nio.ByteBuffer;

@ServerEndpoint(value="/partialbytebuffersession")
public class WSByteBufferPartialAndSessionServer {
    private static final System.Logger logger = System.getLogger(WSByteBufferPartialAndSessionServer.class.getName());
    StringBuilder sb = new StringBuilder();

    @OnMessage
    public void echo(ByteBuffer buf, Session s, boolean finito) throws IOException {
        this.sb.append(IOUtil.byteBufferToString((ByteBuffer)buf)).append("(").append(finito).append(")");
        if (finito) {
            s.getBasicRemote().sendText(this.sb.toString());
            this.sb = new StringBuilder();
        }
    }

    @OnError
    public void onError(Session session, Throwable t) throws IOException {
        logger.log(System.Logger.Level.INFO, "@OnError in " + this.getClass().getName());
        t.printStackTrace();
        String message = "Exception: " + IOUtil.printStackTrace((Throwable)t);
        session.getBasicRemote().sendText(message);
    }
}

