/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder.basic;

import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder.OPS;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder.WSCSuperEndpoint;
import jakarta.websocket.EncodeException;
import jakarta.websocket.Session;
import java.io.IOException;

public abstract class WSCCommonServer
implements WSCSuperEndpoint {
    private static final System.Logger logger = System.getLogger(WSCCommonServer.class.getName());

    public void onMessage(String msg, Session session) throws IOException, EncodeException {
        OPS op = OPS.valueOf(msg);
        switch (op) {
            case BOOL: {
                session.getBasicRemote().sendObject((Object)true);
                break;
            }
            case BYTE: {
                session.getBasicRemote().sendObject((Object)NUMERIC);
                break;
            }
            case CHAR: {
                session.getBasicRemote().sendObject((Object)Character.valueOf('1'));
                break;
            }
            case DOUBLE: {
                session.getBasicRemote().sendObject((Object)NUMERIC.doubleValue());
                break;
            }
            case FLOAT: {
                session.getBasicRemote().sendObject((Object)Float.valueOf(NUMERIC.floatValue()));
                break;
            }
            case INT: {
                session.getBasicRemote().sendObject((Object)NUMERIC.intValue());
                break;
            }
            case LONG: {
                session.getBasicRemote().sendObject((Object)NUMERIC.longValue());
                break;
            }
            case SHORT: {
                session.getBasicRemote().sendObject((Object)NUMERIC.shortValue());
            }
        }
    }

    public void onError(Session session, Throwable t) throws IOException {
        logger.log(System.Logger.Level.INFO, "@OnError in " + this.getClass().getName());
        t.printStackTrace();
        String message = "Exception: " + IOUtil.printStackTrace((Throwable)t);
        session.getBasicRemote().sendText(message);
    }
}

