/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.ui.views.symbexlauncher;

import org.eclipse.efm.execution.configuration.common.ui.api.ILaunchConfigurationGUIelement;
import org.eclipse.efm.execution.configuration.common.ui.api.IWidgetToolkit;
import org.eclipse.efm.execution.configuration.common.ui.util.GenericCompositeCreator;
import org.eclipse.efm.execution.ui.views.symbexlauncher.FormWidgetToolkit;
import org.eclipse.efm.ui.utils.ImageResources;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractSymbexWorkflowView
extends ViewPart
implements ILaunchConfigurationGUIelement {
    protected Composite parentComposite;
    protected FormWidgetToolkit toolkit;
    public ScrolledForm scrollform;
    private Label message_text_display;
    private Label message_image_display;
    private Composite message_display_parentcomposite;

    protected void setupFormFrame() {
        this.toolkit = new FormWidgetToolkit(this.parentComposite.getDisplay());
        this.scrollform = this.toolkit.createScrolledForm(this.parentComposite);
        GridLayout layout = new GridLayout(1, false);
        this.scrollform.getBody().setLayout((Layout)layout);
        this.createMessageDisplayGraphics();
    }

    private void createMessageDisplayGraphics() {
        this.message_display_parentcomposite = this.toolkit.createComposite(this.scrollform.getBody());
        GridLayout gl = new GridLayout(2, false);
        this.message_display_parentcomposite.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, false);
        this.message_display_parentcomposite.setLayoutData((Object)gd);
        this.message_image_display = this.toolkit.createLabel(this.message_display_parentcomposite, null);
        GridData gd2 = new GridData(4, 4, true, false);
        this.message_text_display = this.toolkit.createLabel(this.message_display_parentcomposite, null);
        this.message_text_display.setLayoutData((Object)gd2);
    }

    protected void setupTopLevelActionBars(Action[] acts) {
        IActionBars bars = this.getViewSite().getActionBars();
        IMenuManager pullDownMenuManager = bars.getMenuManager();
        pullDownMenuManager.removeAll();
        Action[] actionArray = acts;
        int n = acts.length;
        int n2 = 0;
        while (n2 < n) {
            Action action = actionArray[n2];
            pullDownMenuManager.add((IAction)action);
            pullDownMenuManager.add((IContributionItem)new Separator());
            ++n2;
        }
        IToolBarManager toolBarMenuManager = bars.getToolBarManager();
        toolBarMenuManager.removeAll();
        GenericCompositeCreator.fillToolBar((IToolBarManager)toolBarMenuManager, (Action[])acts);
    }

    protected void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.scrollform.getShell(), (String)"Symbex Workflow", (String)message);
    }

    public void setFocus() {
        this.scrollform.setFocus();
    }

    public IWidgetToolkit getWidgetToolkit() {
        return this.toolkit;
    }

    public FormWidgetToolkit getFormWidgetToolkit() {
        return this.toolkit;
    }

    public void setMessage(String message) {
        if (message != null) {
            this.message_text_display.setText(message);
        } else {
            this.message_text_display.setText("");
        }
        this.message_image_display.setImage(null);
        this.message_display_parentcomposite.layout();
    }

    public void setWarningMessage(String warningMessage) {
        if (warningMessage != null) {
            this.message_text_display.setText(warningMessage);
            this.message_image_display.setImage(ImageResources.getImage((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/warning_st_obj.png"));
        } else {
            this.message_text_display.setText("");
            this.message_image_display.setImage(null);
        }
        this.message_display_parentcomposite.layout();
    }

    public void setErrorMessage(String errorMessage) {
        if (errorMessage != null) {
            this.message_text_display.setText(errorMessage);
            this.message_image_display.setImage(ImageResources.getImage((String)"platform:/plugin/org.eclipse.efm.ui/resources/icons/error_st_obj.gif"));
        } else {
            this.message_text_display.setText("");
            this.message_image_display.setImage(null);
        }
        this.message_display_parentcomposite.layout();
    }
}

