/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.core.workflow.serializer;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.efm.execution.core.IWorkflowConfigurationConstants;
import org.eclipse.efm.execution.core.util.PrettyPrintWriter;
import org.eclipse.efm.execution.core.workflow.Director;
import org.eclipse.efm.execution.core.workflow.common.ManifestCustomImpl;
import org.eclipse.efm.execution.core.workflow.common.TraceSpecificationCustomImpl;
import org.eclipse.efm.execution.core.workflow.serializer.impl.TTCNTraceSerializerImpl;

public class TTCNTraceSerializerWorkerCustomImpl
extends TTCNTraceSerializerImpl
implements IWorkflowConfigurationConstants {
    protected TTCNTraceSerializerWorkerCustomImpl(Director director, String name) {
        this.setDirector(director);
        this.setName(name);
    }

    protected TTCNTraceSerializerWorkerCustomImpl(Director director, String name, String description) {
        this.setDirector(director);
        this.setName(name);
        this.setDescription(description);
    }

    public static TTCNTraceSerializerWorkerCustomImpl create(Director director, ILaunchConfiguration configuration) {
        boolean enabledCustomization;
        String str;
        TTCNTraceSerializerWorkerCustomImpl serializerWorker = new TTCNTraceSerializerWorkerCustomImpl(director, "TTCN_trace_generator");
        String specification = "input#env  = [*]\noutput#env = [*]\n// See full grammar of [Trace Specification] at the end of this generated file";
        if (specification != null && !specification.isEmpty()) {
            TraceSpecificationCustomImpl trace = TraceSpecificationCustomImpl.create("trace", specification);
            serializerWorker.setTrace(trace);
        }
        try {
            str = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_TTCN_FOLDER_NAME", "TTCN");
        }
        catch (CoreException e) {
            e.printStackTrace();
            str = "TTCN";
        }
        serializerWorker.setFolderName(str);
        try {
            enabledCustomization = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_TTCN_ENABLED_CUSTOMIZATION", false);
        }
        catch (CoreException e) {
            e.printStackTrace();
            enabledCustomization = false;
        }
        serializerWorker.setEnabledCustomization(enabledCustomization);
        serializerWorker.setEnabledAdapters(enabledCustomization);
        if (enabledCustomization) {
            try {
                str = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_TTCN_CONTROL_MODULE_NAME", "TTCN_ControlPart");
            }
            catch (CoreException e) {
                e.printStackTrace();
                str = "TTCN_ControlPart";
            }
            serializerWorker.setControlModuleName(str);
            try {
                str = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_TTCN_DECLARATIONS_MODULE_NAME", "TTCN_Declarations");
            }
            catch (CoreException e) {
                e.printStackTrace();
                str = "TTCN_Declarations";
            }
            serializerWorker.setDeclarationsModuleName(str);
            try {
                str = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_TTCN_TEMPLATES_MODULE_NAME", "TTCN_Templates");
            }
            catch (CoreException e) {
                e.printStackTrace();
                str = "TTCN_Templates";
            }
            serializerWorker.setTemplatesModuleName(str);
            try {
                str = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_TTCN_TESTCASES_MODULE_NAME", "TTCN_TestsAndControl");
            }
            catch (CoreException e) {
                e.printStackTrace();
                str = "TTCN_TestsAndControl";
            }
            serializerWorker.setTestcasesModuleName(str);
            try {
                str = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_TTCN_TESTCASES_STARTING_WRAPPER", "\t\tf_start();");
            }
            catch (CoreException e) {
                e.printStackTrace();
                str = "\t\tf_start();";
            }
            serializerWorker.setTestcasesStartingWrapper(str);
            try {
                str = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_TTCN_TESTCASES_ENDING_WRAPPER", "\t\tf_end();");
            }
            catch (CoreException e) {
                e.printStackTrace();
                str = "\t\tf_end();";
            }
            serializerWorker.setTestcasesEndingWrapper(str);
            try {
                str = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_TTCN_TESTCASES_SENDING_WRAPPER", "\t\t%7%_send( %8% );");
            }
            catch (CoreException e) {
                e.printStackTrace();
                str = "\t\t%7%_send( %8% );";
            }
            serializerWorker.setTestcasesSendingWrapper(str);
            try {
                str = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_TTCN_TESTCASES_RECEIVING_WRAPPER", "\t\t%7%_receive( %8% );");
            }
            catch (CoreException e) {
                e.printStackTrace();
                str = "\t\t%7%_receive( %8% );";
            }
            serializerWorker.setTestcasesReceivingWrapper(str);
            try {
                str = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_TTCN_ADAPTATION_MODULE_NAME", "TTCN_Adaptation");
            }
            catch (CoreException e) {
                e.printStackTrace();
                str = "TTCN_Adaptation";
            }
            serializerWorker.setAdaptationModuleName(str);
            try {
                str = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_TTCN_ADAPTATION_UTILS_IMPL", "\t// A testcase could just call the function below, when it needs to wait for a timeout.\n\t// In case the user wants he can activated altsteps in 'f_start()' to catch events\n\t// during this time period\n\tfunction f_waitForTimeout(float p_duration) {\n\t\ttimer t;\n\t\tt.start(p_duration);\n\t\tt.timeout;\n\t}");
            }
            catch (CoreException e) {
                e.printStackTrace();
                str = "\t// A testcase could just call the function below, when it needs to wait for a timeout.\n\t// In case the user wants he can activated altsteps in 'f_start()' to catch events\n\t// during this time period\n\tfunction f_waitForTimeout(float p_duration) {\n\t\ttimer t;\n\t\tt.start(p_duration);\n\t\tt.timeout;\n\t}";
            }
            serializerWorker.setAdaptationUtilsImpl(str);
            try {
                str = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_TTCN_TESTCASES_STARTING_ENDING_IMPL", "\tfunction f_start() runs on runsOn_%1% { }\n\tfunction f_end() runs on runsOn_%1% { }");
            }
            catch (CoreException e) {
                e.printStackTrace();
                str = "\tfunction f_start() runs on runsOn_%1% { }\n\tfunction f_end() runs on runsOn_%1% { }";
            }
            serializerWorker.setAdaptationStartingEndingImpl(str);
            try {
                str = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_TTCN_TESTCASES_SENDING_IMPL", "\tfunction %1%_send( template %5% pdu ) runs on runsOn_%3% {\n\t\t%7%.send( %5% );\n\t}");
            }
            catch (CoreException e) {
                e.printStackTrace();
                str = "\tfunction %1%_send( template %5% pdu ) runs on runsOn_%3% {\n\t\t%7%.send( %5% );\n\t}";
            }
            serializerWorker.setAdaptationSendingImpl(str);
            try {
                str = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_TTCN_TESTCASES_RECEIVING_IMPL", "\tfunction %1%_receive( template %5% pdu ) runs on runsOn_%3% {\n\t\t%7%.receive( %5% );\n\t}");
            }
            catch (CoreException e) {
                e.printStackTrace();
                str = "\tfunction %1%_receive( template %5% pdu ) runs on runsOn_%3% {\n\t\t%7%.receive( %5% );\n\t}";
            }
            serializerWorker.setAdaptationReceivingImpl(str);
        }
        return serializerWorker;
    }

    public void toWriter(PrettyPrintWriter writer) {
        TraceSpecificationCustomImpl trace;
        writer.commentLine(this.getComment());
        writer.appendTab("serializer#symbex#trace#ttcn");
        String str = this.getName();
        if (str != null) {
            writer.append(' ').append(str);
        }
        if ((str = this.getDescription()) != null) {
            writer.append(" '").append(str).append("'");
        }
        writer.appendEol(" {");
        PrettyPrintWriter writer2 = writer.itab2();
        ManifestCustomImpl manifest = (ManifestCustomImpl)this.getManifest();
        if (manifest != null) {
            manifest.toWriter(writer2);
        }
        writer2.appendTabEol("property [");
        writer2.appendTab2Eol("solver = 'CVC4'");
        if (this.isEnabledAdapters()) {
            writer2.appendTab2Eol("format = 'TTCN#TITAN'");
        } else {
            writer2.appendTab2Eol("format = 'TTCN#XLIA'");
        }
        writer2.appendTabEol("] // end property");
        writer2.appendTabEol("format [");
        str = this.getControlModuleName();
        if (str != null) {
            writer2.appendTab2("control#module#name = \"").append(str).appendEol("\"");
        }
        if ((str = this.getDeclarationsModuleName()) != null) {
            writer2.appendTab2("declarations#module#name = \"").append(str).appendEol("\"");
        }
        if ((str = this.getTemplatesModuleName()) != null) {
            writer2.appendTab2("templates#module#name = \"").append(str).appendEol("\"");
        }
        if ((str = this.getTestcasesModuleName()) != null) {
            writer2.appendTab2("testcases#module#name = \"").append(str).appendEol("\"");
        }
        if ((str = this.getAdaptationModuleName()) != null) {
            writer2.appendTab2("adaptation#module#name = \"").append(str).appendEol("\"");
        }
        writer2.appendTabEol("] // end format");
        writer2.appendTabEol("wrapper [");
        str = this.getTestcasesStartingWrapper();
        if (str != null) {
            writer2.appendTab2("testcases#starting = \"").append(str).appendEol("\"");
        }
        if ((str = this.getTestcasesEndingWrapper()) != null) {
            writer2.appendTab2("testcases#ending = \"").append(str).appendEol("\"");
        }
        if ((str = this.getTestcasesSendingWrapper()) != null) {
            writer2.appendTab2("testcases#sending = \"").append(str).appendEol("\"");
        }
        if ((str = this.getTestcasesReceivingWrapper()) != null) {
            writer2.appendTab2("testcases#receiving = \"").append(str).appendEol("\"");
        }
        writer2.appendTabEol("] // end wrapper");
        writer2.appendTabEol("implementation [");
        str = this.getAdaptationUtilsImpl();
        if (str != null) {
            writer2.appendTab2("adaptation#utils = ").append(str.startsWith("\t") && str.contains("\n") ? "\n\"" : "\"").append(str).appendEol("\"");
        }
        if ((str = this.getAdaptationStartingEndingImpl()) != null) {
            writer2.appendTab2("adaptation#starting#ending = ").append(str.startsWith("\t") && str.contains("\n") ? "\n\"" : "\"").append(str).appendEol("\"");
        }
        if ((str = this.getAdaptationSendingImpl()) != null) {
            writer2.appendTab2("adaptation#sending = ").append(str.startsWith("\t") && str.contains("\n") ? "\n\"" : "\"").append(str).appendEol("\"");
        }
        if ((str = this.getAdaptationReceivingImpl()) != null) {
            writer2.appendTab2("adaptation#receiving = ").append(str.startsWith("\t") && str.contains("\n") ? "\n\"" : "\"").append(str).appendEol("\"");
        }
        writer2.appendTabEol("] // end implementation");
        TraceSpecificationCustomImpl format = (TraceSpecificationCustomImpl)this.getFormat();
        if (format != null) {
            format.toWriter(writer2);
        }
        if ((trace = (TraceSpecificationCustomImpl)this.getTrace()) != null) {
            trace.toWriter(writer2);
        }
        String justifier = "";
        writer2.appendTabEol("vfs [");
        str = this.getFolderName();
        if (str != null) {
            writer2.appendTab2("folder = \"").append(str).appendEol("\"");
            justifier = "  ";
        }
        if ((str = this.getFileName()) != null) {
            writer2.appendTab2("file").append(justifier).append(" = \"").append(str).appendEol("\"");
        }
        writer2.appendTabEol("] // end vfs");
        writer.appendTabEol("}");
    }
}

