/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.javadoc;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IModularClassFile;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.CorextMessages;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.ui.PlatformUI;

public class JavaDocLocations {
    private static final String JAR_PROTOCOL = "jar";
    public static final String ARCHIVE_PREFIX = "jar:";
    private static final QualifiedName PROJECT_JAVADOC = new QualifiedName("org.eclipse.jdt.ui", "project_javadoc_location");

    private static IClasspathEntry getConvertedEntry(IClasspathEntry entry, IJavaProject project, Map<IPath, String> oldLocationMap) {
        IPath path = null;
        switch (entry.getEntryKind()) {
            case 2: 
            case 3: {
                return null;
            }
            case 5: {
                JavaDocLocations.convertContainer(entry, project, oldLocationMap);
                return null;
            }
            case 1: {
                path = entry.getPath();
                break;
            }
            case 4: {
                path = JavaCore.getResolvedVariablePath((IPath)entry.getPath());
                break;
            }
            default: {
                return null;
            }
        }
        if (path == null) {
            return null;
        }
        IClasspathAttribute[] extraAttributes = entry.getExtraAttributes();
        int i = 0;
        while (i < extraAttributes.length) {
            if ("javadoc_location".equals(extraAttributes[i].getName())) {
                return null;
            }
            ++i;
        }
        String libraryJavadocLocation = oldLocationMap.get(path);
        if (libraryJavadocLocation != null) {
            CPListElement element = CPListElement.createFromExisting(entry, project);
            element.setAttribute("javadoc_location", libraryJavadocLocation);
            return element.getClasspathEntry();
        }
        return null;
    }

    private static void convertContainer(IClasspathEntry entry, IJavaProject project, Map<IPath, String> oldLocationMap) {
        try {
            IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)project);
            if (container == null) {
                return;
            }
            IClasspathEntry[] entries = container.getClasspathEntries();
            boolean hasChange = false;
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry curr = entries[i];
                IClasspathEntry updatedEntry = JavaDocLocations.getConvertedEntry(curr, project, oldLocationMap);
                if (updatedEntry != null) {
                    entries[i] = updatedEntry;
                    hasChange = true;
                }
                ++i;
            }
            if (hasChange) {
                BuildPathSupport.requestContainerUpdate(project, container, entries);
            }
        }
        catch (CoreException coreException) {}
    }

    public static void setProjectJavadocLocation(IJavaProject project, URL url) {
        try {
            String location = url != null ? url.toExternalForm() : null;
            JavaDocLocations.setProjectJavadocLocation(project, location);
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
    }

    private static void setProjectJavadocLocation(IJavaProject project, String url) throws CoreException {
        project.getProject().setPersistentProperty(PROJECT_JAVADOC, url);
    }

    public static URL getProjectJavadocLocation(IJavaProject project) {
        String prop;
        block4: {
            if (!project.getProject().isAccessible()) {
                return null;
            }
            try {
                prop = project.getProject().getPersistentProperty(PROJECT_JAVADOC);
                if (prop != null) break block4;
                return null;
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
                return null;
            }
        }
        return JavaDocLocations.parseURL(prop);
    }

    public static URL getLibraryJavadocLocation(IClasspathEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Entry must not be null");
        }
        int kind = entry.getEntryKind();
        if (kind != 1 && kind != 4) {
            throw new IllegalArgumentException("Entry must be of kind CPE_LIBRARY or CPE_VARIABLE");
        }
        IClasspathAttribute[] extraAttributes = entry.getExtraAttributes();
        int i = 0;
        while (i < extraAttributes.length) {
            IClasspathAttribute attrib = extraAttributes[i];
            if ("javadoc_location".equals(attrib.getName())) {
                return JavaDocLocations.parseURL(attrib.getValue());
            }
            ++i;
        }
        return null;
    }

    public static URL getJavadocBaseLocation(IJavaElement element) throws JavaModelException {
        if (element.getElementType() == 2) {
            return JavaDocLocations.getProjectJavadocLocation((IJavaProject)element);
        }
        IPackageFragmentRoot root = JavaModelUtil.getPackageFragmentRoot((IJavaElement)element);
        if (root == null) {
            return null;
        }
        if (root.getKind() == 2) {
            IClasspathEntry entry = root.getResolvedClasspathEntry();
            URL javadocLocation = JavaDocLocations.getLibraryJavadocLocation(entry);
            if (javadocLocation != null) {
                return JavaDocLocations.getLibraryJavadocLocation(entry);
            }
            entry = root.getRawClasspathEntry();
            switch (entry.getEntryKind()) {
                case 1: 
                case 4: {
                    return JavaDocLocations.getLibraryJavadocLocation(entry);
                }
            }
            return null;
        }
        return JavaDocLocations.getProjectJavadocLocation(root.getJavaProject());
    }

    public static URL getJavadocLocation(IJavaElement element, boolean includeMemberReference) throws JavaModelException {
        URL baseLocation = JavaDocLocations.getJavadocBaseLocation(element);
        if (baseLocation == null) {
            return null;
        }
        String urlString = baseLocation.toExternalForm();
        StringBuffer urlBuffer = new StringBuffer(urlString);
        if (!urlString.endsWith("/")) {
            urlBuffer.append('/');
        }
        StringBuffer pathBuffer = new StringBuffer();
        StringBuffer fragmentBuffer = new StringBuffer();
        switch (element.getElementType()) {
            case 4: {
                JavaDocLocations.appendPackageSummaryPath((IPackageFragment)element, pathBuffer);
                break;
            }
            case 2: 
            case 3: {
                JavaDocLocations.appendIndexPath(pathBuffer);
                break;
            }
            case 12: {
                element = element.getParent();
            }
            case 5: {
                IType mainType = ((ICompilationUnit)element).findPrimaryType();
                if (mainType == null) {
                    return null;
                }
                JavaDocLocations.appendTypePath(mainType, pathBuffer);
                break;
            }
            case 6: {
                if (element instanceof IModularClassFile) {
                    try {
                        JavaDocLocations.appendModuleSummaryPath(((IModularClassFile)element).getModule(), pathBuffer);
                        break;
                    }
                    catch (JavaModelException javaModelException) {
                        return null;
                    }
                }
                JavaDocLocations.appendTypePath(((IOrdinaryClassFile)element).getType(), pathBuffer);
                break;
            }
            case 7: {
                JavaDocLocations.appendTypePath((IType)element, pathBuffer);
                break;
            }
            case 8: {
                IField field = (IField)element;
                JavaDocLocations.appendTypePath(field.getDeclaringType(), pathBuffer);
                if (!includeMemberReference) break;
                JavaDocLocations.appendFieldReference(field, fragmentBuffer);
                break;
            }
            case 9: {
                IMethod method = (IMethod)element;
                JavaDocLocations.appendTypePath(method.getDeclaringType(), pathBuffer);
                if (!includeMemberReference) break;
                JavaDocLocations.appendMethodReference(method, fragmentBuffer);
                break;
            }
            case 10: {
                JavaDocLocations.appendTypePath(((IMember)element).getDeclaringType(), pathBuffer);
                break;
            }
            case 13: {
                IImportDeclaration decl = (IImportDeclaration)element;
                if (decl.isOnDemand()) {
                    IJavaElement cont = JavaModelUtil.findTypeContainer((IJavaProject)element.getJavaProject(), (String)Signature.getQualifier((String)decl.getElementName()));
                    if (cont instanceof IType) {
                        JavaDocLocations.appendTypePath((IType)cont, pathBuffer);
                        break;
                    }
                    if (!(cont instanceof IPackageFragment)) break;
                    JavaDocLocations.appendPackageSummaryPath((IPackageFragment)cont, pathBuffer);
                    break;
                }
                IType imp = element.getJavaProject().findType(decl.getElementName());
                JavaDocLocations.appendTypePath(imp, pathBuffer);
                break;
            }
            case 11: {
                IJavaElement pack = element.getAncestor(4);
                if (pack != null) {
                    JavaDocLocations.appendPackageSummaryPath((IPackageFragment)pack, pathBuffer);
                    break;
                }
                return null;
            }
            case 17: {
                IModuleDescription module = (IModuleDescription)element;
                JavaDocLocations.appendModuleSummaryPath(module, pathBuffer);
                break;
            }
            default: {
                return null;
            }
        }
        try {
            String fragment = fragmentBuffer.length() == 0 ? null : fragmentBuffer.toString();
            try {
                URI relativeURI = new URI(null, null, pathBuffer.toString(), fragment);
                urlBuffer.append(relativeURI.toString());
                return new URL(urlBuffer.toString());
            }
            catch (URISyntaxException e) {
                JavaPlugin.log(e);
                return new URL(urlBuffer.append(pathBuffer).toString());
            }
        }
        catch (MalformedURLException e) {
            JavaPlugin.log(e);
            return null;
        }
    }

    private static void appendPackageSummaryPath(IPackageFragment pack, StringBuffer buf) {
        String packPath = pack.getElementName().replace('.', '/');
        buf.append(packPath);
        buf.append("/package-summary.html");
    }

    private static void appendModuleSummaryPath(IModuleDescription module, StringBuffer buf) {
        String moduleName = module.getElementName();
        buf.append(moduleName);
        buf.append("-summary.html");
    }

    private static void appendIndexPath(StringBuffer buf) {
        buf.append("index.html");
    }

    private static void appendTypePath(IType type, StringBuffer buf) {
        IPackageFragment pack = type.getPackageFragment();
        String packPath = pack.getElementName().replace('.', '/');
        String typePath = type.getTypeQualifiedName('.');
        if (packPath.length() > 0) {
            buf.append(packPath);
            buf.append('/');
        }
        buf.append(typePath);
        buf.append(".html");
    }

    private static void appendFieldReference(IField field, StringBuffer buf) {
        buf.append(field.getElementName());
    }

    private static void appendMethodReference(IMethod meth, StringBuffer buf) throws JavaModelException {
        buf.append(meth.getElementName());
        boolean is18OrHigher = JavaModelUtil.is18OrHigher((IJavaProject)meth.getJavaProject());
        buf.append(is18OrHigher ? (char)'-' : '(');
        String[] params = meth.getParameterTypes();
        IType declaringType = meth.getDeclaringType();
        boolean isVararg = Flags.isVarargs((int)meth.getFlags());
        int lastParam = params.length - 1;
        int i = 0;
        while (i <= lastParam) {
            String curr;
            String fullName;
            if (i != 0) {
                buf.append(is18OrHigher ? "-" : ", ");
            }
            if ((fullName = JavaModelUtil.getResolvedTypeName((String)(curr = Signature.getTypeErasure((String)params[i])), (IType)declaringType)) == null) {
                fullName = Signature.toString((String)Signature.getElementType((String)curr));
            }
            if (fullName != null) {
                buf.append(fullName);
                int dim = Signature.getArrayCount((String)curr);
                if (i == lastParam && isVararg) {
                    --dim;
                }
                while (dim > 0) {
                    buf.append(is18OrHigher ? ":A" : "[]");
                    --dim;
                }
                if (i == lastParam && isVararg) {
                    buf.append("...");
                }
            }
            ++i;
        }
        buf.append(is18OrHigher ? (char)'-' : ')');
    }

    public static String getBaseURL(IJavaElement element, boolean isBinary) throws JavaModelException {
        if (isBinary) {
            URL baseURL = JavaUI.getJavadocLocation(element, false);
            if (baseURL != null) {
                URL baseURL2;
                if (baseURL.getProtocol().equals(JAR_PROTOCOL) && (baseURL2 = PlatformUI.getWorkbench().getHelpSystem().resolve(baseURL.toExternalForm(), true)) != null) {
                    baseURL = baseURL2;
                }
                return baseURL.toExternalForm();
            }
        } else {
            IPath location;
            IResource resource = element.getResource();
            if (resource != null && (location = resource.getLocation()) != null) {
                return location.toFile().toURI().toString();
            }
        }
        return null;
    }

    public static String getExplanationForMissingJavadoc(IJavaElement element, IPackageFragmentRoot root) {
        String message = null;
        try {
            boolean isBinary;
            boolean bl = isBinary = root.exists() && root.getKind() == 2;
            if (isBinary) {
                boolean hasSource;
                boolean hasAttachedJavadoc = JavaDocLocations.getJavadocBaseLocation(element) != null;
                boolean hasAttachedSource = root.getSourceAttachmentPath() != null;
                IOpenable openable = element.getOpenable();
                boolean bl2 = hasSource = openable.getBuffer() != null;
                if (!hasAttachedSource && !hasAttachedJavadoc) {
                    message = CorextMessages.JavaDocLocations_noAttachments;
                } else if (!hasAttachedJavadoc && !hasSource) {
                    message = CorextMessages.JavaDocLocations_noAttachedJavadoc;
                } else if (!hasAttachedSource) {
                    message = CorextMessages.JavaDocLocations_noAttachedSource;
                } else if (!hasSource) {
                    message = CorextMessages.JavaDocLocations_noInformation;
                }
            }
        }
        catch (JavaModelException e) {
            message = CorextMessages.JavaDocLocations_error_gettingJavadoc;
            JavaPlugin.log(e);
        }
        return message;
    }

    public static String handleFailedJavadocFetch(CoreException e) {
        IStatus status = e.getStatus();
        if ("org.eclipse.jdt.core".equals(status.getPlugin())) {
            Throwable cause = e.getCause();
            int code = status.getCode();
            if (code == 1012 || code == 1008 && (cause instanceof FileNotFoundException || cause instanceof SocketException || cause instanceof UnknownHostException || cause instanceof ProtocolException)) {
                return CorextMessages.JavaDocLocations_error_gettingAttachedJavadoc;
            }
        }
        JavaPlugin.log(e);
        return CorextMessages.JavaDocLocations_error_gettingJavadoc;
    }

    public static URL parseURL(String url) {
        try {
            try {
                return new URI(url).toURL();
            }
            catch (URISyntaxException e) {
                try {
                    if (url.startsWith("file:/")) {
                        return new URI("file", null, url.substring(5), null).toURL();
                    }
                    return URIUtil.fromString((String)url).toURL();
                }
                catch (URISyntaxException uRISyntaxException) {
                    JavaPlugin.log(e);
                    return new URL(url);
                }
            }
        }
        catch (MalformedURLException e) {
            JavaPlugin.log(e);
            return null;
        }
    }

    public static File toFile(URL url) {
        try {
            return URIUtil.toFile((URI)url.toURI());
        }
        catch (URISyntaxException e) {
            JavaPlugin.log(e);
            return new File(url.getFile());
        }
    }
}

