/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import java.net.URL;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class OpenBrowserUtil {
    public static void open(final URL url, Display display) {
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                OpenBrowserUtil.internalOpen(url, false);
            }
        });
    }

    public static void openExternal(final URL url, Display display) {
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                OpenBrowserUtil.internalOpen(url, true);
            }
        });
    }

    private static void internalOpen(final URL url, final boolean useExternalBrowser) {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                URL helpSystemUrl = PlatformUI.getWorkbench().getHelpSystem().resolve(url.toExternalForm(), true);
                if (helpSystemUrl == null) {
                    return;
                }
                try {
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    IWebBrowser browser = useExternalBrowser ? browserSupport.getExternalBrowser() : browserSupport.createBrowser(null);
                    browser.openURL(helpSystemUrl);
                }
                catch (PartInitException ex) {
                    JavaPlugin.logErrorStatus("Opening Javadoc failed", ex.getStatus());
                }
            }
        });
    }

    @Deprecated
    public static void open(URL url, Display display, String title) {
        OpenBrowserUtil.open(url, display);
    }
}

