/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.jdt.internal.corext.refactoring.code.ConvertAnonymousToNestedRefactoring;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.jdt.internal.ui.refactoring.IVisibilityChangeListener;
import org.eclipse.jdt.internal.ui.refactoring.InputPageUtil;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ConvertAnonymousToNestedWizard
extends RefactoringWizard {
    static final String DIALOG_SETTING_SECTION = "ConvertAnonymousToNestedWizard";

    public ConvertAnonymousToNestedWizard(ConvertAnonymousToNestedRefactoring ref) {
        super((Refactoring)ref, 36);
        this.setDefaultPageTitle(RefactoringMessages.ConvertAnonymousToNestedAction_wizard_title);
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new ConvertAnonymousToNestedInputPage());
    }

    private static class ConvertAnonymousToNestedInputPage
    extends UserInputWizardPage {
        private static final String DESCRIPTION = RefactoringMessages.ConvertAnonymousToNestedInputPage_description;
        public static final String PAGE_NAME = "ConvertAnonymousToNestedInputPage";
        private static final String DECLARE_AS_STATIC = "DeclareAsStatic";
        private static final String DECLARE_AS_FINAL = "DeclareAsFinal";
        private static final String VISIBILITY_CONTROL = "VisibilityControl";
        private IDialogSettings fSettings;

        public ConvertAnonymousToNestedInputPage() {
            super(PAGE_NAME);
            this.setDescription(DESCRIPTION);
        }

        private void initializeDefaultSettings() {
            this.fSettings = this.getDialogSettings().getSection(ConvertAnonymousToNestedWizard.DIALOG_SETTING_SECTION);
            if (this.fSettings == null) {
                this.fSettings = this.getDialogSettings().addNewSection(ConvertAnonymousToNestedWizard.DIALOG_SETTING_SECTION);
                this.fSettings.put(DECLARE_AS_STATIC, this.getConvertRefactoring().getDeclareStatic());
                this.fSettings.put(DECLARE_AS_FINAL, this.getConvertRefactoring().getDeclareFinal());
                this.fSettings.put(VISIBILITY_CONTROL, this.getConvertRefactoring().getVisibility());
            }
        }

        public void createControl(Composite parent) {
            Composite result = new Composite(parent, 0);
            this.setControl((Control)result);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.verticalSpacing = 8;
            result.setLayout((Layout)layout);
            this.initializeDefaultSettings();
            this.addVisibilityControl(result);
            Text textField = this.addFieldNameField(result);
            this.addDeclareFinalCheckbox(result);
            this.addDeclareAsStaticCheckbox(result);
            textField.setFocus();
            this.setPageComplete(false);
            Dialog.applyDialogFont((Control)result);
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.convert_anonymous_to_nested_page_context");
        }

        private Text addFieldNameField(Composite result) {
            Label nameLabel = new Label(result, 0);
            nameLabel.setText(RefactoringMessages.ConvertAnonymousToNestedInputPage_class_name);
            nameLabel.setLayoutData((Object)new GridData());
            final Text classNameField = new Text(result, 2052);
            classNameField.setLayoutData((Object)new GridData(768));
            classNameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    this.getConvertRefactoring().setClassName(classNameField.getText());
                    this.updateStatus();
                }
            });
            TextFieldNavigationHandler.install(classNameField);
            return classNameField;
        }

        private void updateStatus() {
            this.setPageComplete(this.getConvertRefactoring().validateInput());
        }

        private void addVisibilityControl(Composite result) {
            int currectVisibility;
            final ConvertAnonymousToNestedRefactoring r = this.getConvertRefactoring();
            int[] availableVisibilities = r.getAvailableVisibilities();
            if (r.isLocalInnerType()) {
                currectVisibility = r.getVisibility();
            } else {
                currectVisibility = this.fSettings.getInt(VISIBILITY_CONTROL);
                r.setVisibility(currectVisibility);
            }
            IVisibilityChangeListener visibilityChangeListener = new IVisibilityChangeListener(){

                @Override
                public void visibilityChanged(int newVisibility) {
                    r.setVisibility(newVisibility);
                    fSettings.put(ConvertAnonymousToNestedInputPage.VISIBILITY_CONTROL, newVisibility);
                }

                @Override
                public void modifierChanged(int modifier, boolean isChecked) {
                }
            };
            Composite visibilityComposite = InputPageUtil.createVisibilityControl(result, visibilityChangeListener, availableVisibilities, currectVisibility);
            if (visibilityComposite != null) {
                GridData gd = new GridData(768);
                gd.horizontalSpan = 2;
                visibilityComposite.setLayoutData((Object)gd);
            }
        }

        public void addDeclareFinalCheckbox(Composite result) {
            final Button declareFinalCheckbox = new Button(result, 32);
            final ConvertAnonymousToNestedRefactoring r = this.getConvertRefactoring();
            declareFinalCheckbox.setEnabled(r.canEnableSettingFinal());
            boolean declareAsFinal = this.fSettings.getBoolean(DECLARE_AS_FINAL);
            r.setDeclareFinal(declareAsFinal);
            declareFinalCheckbox.setSelection(declareAsFinal);
            declareFinalCheckbox.setText(RefactoringMessages.ConvertAnonymousToNestedInputPage_declare_final);
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            declareFinalCheckbox.setLayoutData((Object)gd);
            declareFinalCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean declareFinal = declareFinalCheckbox.getSelection();
                    r.setDeclareFinal(declareFinal);
                    fSettings.put(ConvertAnonymousToNestedInputPage.DECLARE_AS_FINAL, declareFinal);
                }
            });
        }

        public void addDeclareAsStaticCheckbox(Composite result) {
            boolean isSelected;
            final Button declareAsStaticCheckbox = new Button(result, 32);
            final ConvertAnonymousToNestedRefactoring r = this.getConvertRefactoring();
            boolean isEnabled = !r.mustInnerClassBeStatic() && !r.isLocalInnerType();
            declareAsStaticCheckbox.setEnabled(isEnabled);
            if (isEnabled) {
                isSelected = this.fSettings.getBoolean(DECLARE_AS_STATIC);
                r.setDeclareStatic(isSelected);
            } else {
                isSelected = this.getConvertRefactoring().mustInnerClassBeStatic();
            }
            declareAsStaticCheckbox.setSelection(isSelected);
            declareAsStaticCheckbox.setText(RefactoringMessages.ConvertAnonymousToNestedInputPage_declare_static);
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            declareAsStaticCheckbox.setLayoutData((Object)gd);
            declareAsStaticCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean declareAsStatic = declareAsStaticCheckbox.getSelection();
                    r.setDeclareStatic(declareAsStatic);
                    fSettings.put(ConvertAnonymousToNestedInputPage.DECLARE_AS_STATIC, declareAsStatic);
                }
            });
        }

        private ConvertAnonymousToNestedRefactoring getConvertRefactoring() {
            return (ConvertAnonymousToNestedRefactoring)this.getRefactoring();
        }
    }
}

