/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java.hover;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.text.SimpleJavaSourceViewerConfiguration;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaSourceHover;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.text.IInformationControlExtension5;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SourceViewerInformationControl
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2,
IInformationControlExtension3,
IInformationControlExtension5,
DisposeListener {
    private Shell fShell;
    private StyledText fText;
    private Font fTextFont;
    private SourceViewer fViewer;
    private Label fStatusField;
    private Label fSeparator;
    private Font fStatusTextFont;
    private Color fStatusTextForegroundColor;
    private int fMaxWidth = -1;
    private int fMaxHeight = -1;
    private final int fOrientation;
    private Color fBackgroundColor;
    private boolean fIsSystemBackgroundColor = true;
    private JavaSourceViewerConfiguration fViewerConfiguration;
    private Map<String, JavaSourceViewerConfiguration> fKindToViewerConfiguration = new HashMap<String, JavaSourceViewerConfiguration>();

    public SourceViewerInformationControl(Shell parent, boolean isResizable, int orientation, String statusFieldText) {
        Assert.isLegal((orientation == 0x4000000 || orientation == 0x2000000 || orientation == 0 ? 1 : 0) != 0);
        this.fOrientation = orientation;
        int shellStyle = 0x4004 | orientation | (isResizable ? 16 : 0);
        int textStyle = isResizable ? 768 : 0;
        this.fShell = new Shell(parent, 0x84000 | shellStyle);
        Display display = this.fShell.getDisplay();
        this.initializeColors();
        Shell composite = this.fShell;
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        if (statusFieldText != null) {
            composite = new Composite((Composite)composite, 0);
            layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.verticalSpacing = 1;
            composite.setLayout((Layout)layout);
            gd = new GridData(1808);
            composite.setLayoutData((Object)gd);
            composite.setForeground(display.getSystemColor(28));
            composite.setBackground(this.fBackgroundColor);
        }
        IPreferenceStore store = JavaPlugin.getDefault().getCombinedPreferenceStore();
        this.fViewer = new JavaSourceViewer((Composite)composite, null, null, false, textStyle, store);
        this.fViewerConfiguration = new SimpleJavaSourceViewerConfiguration(JavaPlugin.getDefault().getJavaTextTools().getColorManager(), store, null, "___java_partitioning", false);
        this.fKindToViewerConfiguration.put("standard", this.fViewerConfiguration);
        this.fViewer.configure((SourceViewerConfiguration)this.fViewerConfiguration);
        this.fViewer.setEditable(false);
        this.fText = this.fViewer.getTextWidget();
        gd = new GridData(1809);
        this.fText.setLayoutData((Object)gd);
        this.fText.setForeground(display.getSystemColor(28));
        this.fText.setBackground(this.fBackgroundColor);
        this.initializeFont();
        this.fText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    SourceViewerInformationControl.this.fShell.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        if (statusFieldText != null) {
            this.fSeparator = new Label((Composite)composite, 259);
            this.fSeparator.setLayoutData((Object)new GridData(768));
            this.fStatusField = new Label((Composite)composite, 131072);
            this.fStatusField.setText(statusFieldText);
            Font font = this.fStatusField.getFont();
            FontData[] fontDatas = font.getFontData();
            int i = 0;
            while (i < fontDatas.length) {
                fontDatas[i].setHeight(fontDatas[i].getHeight() * 9 / 10);
                ++i;
            }
            this.fStatusTextFont = new Font((Device)this.fStatusField.getDisplay(), fontDatas);
            this.fStatusField.setFont(this.fStatusTextFont);
            GridData gd2 = new GridData(770);
            this.fStatusField.setLayoutData((Object)gd2);
            RGB javaDefaultColor = JavaUI.getColorManager().getColor("java_default").getRGB();
            this.fStatusTextForegroundColor = new Color((Device)this.fStatusField.getDisplay(), SourceViewerInformationControl.blend(this.fBackgroundColor.getRGB(), javaDefaultColor, 0.56f));
            this.fStatusField.setForeground(this.fStatusTextForegroundColor);
            this.fStatusField.setBackground(this.fBackgroundColor);
        }
        this.addDisposeListener(this);
    }

    private static RGB blend(RGB bg, RGB fg, float factor) {
        Assert.isLegal((bg != null ? 1 : 0) != 0);
        Assert.isLegal((fg != null ? 1 : 0) != 0);
        Assert.isLegal((factor >= 0.0f && factor <= 1.0f ? 1 : 0) != 0);
        float complement = 1.0f - factor;
        return new RGB((int)(complement * (float)bg.red + factor * (float)fg.red), (int)(complement * (float)bg.green + factor * (float)fg.green), (int)(complement * (float)bg.blue + factor * (float)fg.blue));
    }

    private void initializeColors() {
        IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
        RGB bgRGB = store.getBoolean("sourceHoverBackgroundColor.SystemDefault") ? SourceViewerInformationControl.getVisibleBackgroundColor(this.fShell.getDisplay()) : PreferenceConverter.getColor((IPreferenceStore)store, (String)"sourceHoverBackgroundColor");
        if (bgRGB != null) {
            this.fBackgroundColor = new Color((Device)this.fShell.getDisplay(), bgRGB);
            this.fIsSystemBackgroundColor = false;
        } else {
            this.fBackgroundColor = this.fShell.getDisplay().getSystemColor(29);
            this.fIsSystemBackgroundColor = true;
        }
    }

    public static RGB getVisibleBackgroundColor(Display display) {
        Color javaDefaultColor;
        RGB javaDefaultRGB;
        float[] javaDefaultHSB;
        float[] infoBgHSB = display.getSystemColor(29).getRGB().getHSB();
        if (Math.abs(infoBgHSB[2] - (javaDefaultHSB = (javaDefaultRGB = (javaDefaultColor = JavaUI.getColorManager().getColor("java_default")) != null ? javaDefaultColor.getRGB() : new RGB(255, 255, 255)).getHSB())[2]) < 0.5f) {
            IPreferenceStore preferenceStore = JavaPlugin.getDefault().getCombinedPreferenceStore();
            boolean useDefault = preferenceStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault");
            if (useDefault) {
                return display.getSystemColor(25).getRGB();
            }
            return PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)"AbstractTextEditor.Color.Background");
        }
        return null;
    }

    private void initializeFont() {
        this.fTextFont = JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont");
        StyledText styledText = this.getViewer().getTextWidget();
        styledText.setFont(this.fTextFont);
    }

    public void setInput(final Object input) {
        Display display;
        String content = null;
        if (input instanceof String) {
            content = (String)input;
        } else if (input instanceof JavaSourceHover.JavaSourceInformationInput) {
            content = ((JavaSourceHover.JavaSourceInformationInput)input).getHoverInfo();
        }
        this.setInformation(content);
        if (this.fShell != null && !this.fShell.isDisposed() && !(display = this.fShell.getDisplay()).isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    IJavaElement javaElement = null;
                    if (input instanceof JavaSourceHover.JavaSourceInformationInput) {
                        javaElement = ((JavaSourceHover.JavaSourceInformationInput)input).getJavaElement();
                    }
                    SourceViewerInformationControl.this.updateViewerConfiguration(javaElement);
                }
            });
        }
    }

    public void setInformation(String content) {
        if (content == null) {
            this.fViewer.setInput(null);
            return;
        }
        Document doc = new Document(content);
        JavaPlugin.getDefault().getJavaTextTools().setupJavaDocumentPartitioner((IDocument)doc, "___java_partitioning");
        this.fViewer.setInput((Object)doc);
    }

    private void updateViewerConfiguration(IJavaElement input) {
        if (this.fKindToViewerConfiguration != null) {
            JavaSourceViewerConfiguration oldViewerConfiguration = this.fViewerConfiguration;
            if (JavaModelUtil.isModule((IJavaElement)input)) {
                this.fViewerConfiguration = this.fKindToViewerConfiguration.get("module");
                if (this.fViewerConfiguration == null) {
                    IPreferenceStore store = JavaPlugin.getDefault().getCombinedPreferenceStore();
                    this.fViewerConfiguration = new SimpleJavaSourceViewerConfiguration(JavaPlugin.getDefault().getJavaTextTools().getColorManager(), store, null, "___java_partitioning", false, true);
                    this.fKindToViewerConfiguration.put("module", this.fViewerConfiguration);
                }
            } else {
                this.fViewerConfiguration = this.fKindToViewerConfiguration.get("standard");
            }
            if (this.fViewerConfiguration != null && !((Object)((Object)this.fViewerConfiguration)).equals((Object)oldViewerConfiguration)) {
                this.fViewer.configure((SourceViewerConfiguration)this.fViewerConfiguration);
            }
        }
    }

    public void setVisible(boolean visible) {
        this.fShell.setVisible(visible);
    }

    public void widgetDisposed(DisposeEvent event) {
        if (this.fStatusTextFont != null && !this.fStatusTextFont.isDisposed()) {
            this.fStatusTextFont.dispose();
        }
        this.fStatusTextFont = null;
        if (this.fStatusTextForegroundColor != null && !this.fStatusTextForegroundColor.isDisposed()) {
            this.fStatusTextForegroundColor.dispose();
        }
        this.fStatusTextForegroundColor = null;
        this.fTextFont = null;
        this.fShell = null;
        this.fText = null;
    }

    public final void dispose() {
        if (!this.fIsSystemBackgroundColor) {
            this.fBackgroundColor.dispose();
        }
        if (this.fShell != null && !this.fShell.isDisposed()) {
            this.fShell.dispose();
        } else {
            this.widgetDisposed(null);
        }
        this.fKindToViewerConfiguration = null;
    }

    public void setSize(int width, int height) {
        this.fShell.setSize(width, height);
    }

    public void setLocation(Point location) {
        this.fShell.setLocation(location);
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
        this.fMaxWidth = maxWidth;
        this.fMaxHeight = maxHeight;
    }

    public Point computeSizeHint() {
        int x = -1;
        int y = -1;
        Point size = this.fShell.computeSize(x, y);
        if (size.x > this.fMaxWidth) {
            x = this.fMaxWidth;
        }
        if (size.y > this.fMaxHeight) {
            y = this.fMaxHeight;
        }
        if (x != -1 || y != -1) {
            size = this.fShell.computeSize(x, y, false);
        }
        return size;
    }

    public void addDisposeListener(DisposeListener listener) {
        this.fShell.addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.fShell.removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        this.fText.setForeground(foreground);
    }

    public void setBackgroundColor(Color background) {
        this.fText.setBackground(background);
    }

    public boolean isFocusControl() {
        return this.fShell.getDisplay().getActiveShell() == this.fShell;
    }

    public void setFocus() {
        this.fShell.forceFocus();
        this.fText.setFocus();
    }

    public void addFocusListener(FocusListener listener) {
        this.fText.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.fText.removeFocusListener(listener);
    }

    public boolean hasContents() {
        return this.fText.getCharCount() > 0;
    }

    protected ISourceViewer getViewer() {
        return this.fViewer;
    }

    public Rectangle computeTrim() {
        Rectangle trim = this.fShell.computeTrim(0, 0, 0, 0);
        this.addInternalTrim(trim);
        return trim;
    }

    private void addInternalTrim(Rectangle trim) {
        Rectangle textTrim = this.fText.computeTrim(0, 0, 0, 0);
        trim.x += textTrim.x;
        trim.y += textTrim.y;
        trim.width += textTrim.width;
        trim.height += textTrim.height;
        if (this.fStatusField != null) {
            trim.height += this.fSeparator.computeSize((int)-1, (int)-1).y;
            trim.height += this.fStatusField.computeSize((int)-1, (int)-1).y;
            ++trim.height;
        }
    }

    public Rectangle getBounds() {
        return this.fShell.getBounds();
    }

    public boolean restoresLocation() {
        return false;
    }

    public boolean restoresSize() {
        return false;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new SourceViewerInformationControl(parent, true, SourceViewerInformationControl.this.fOrientation, null);
            }
        };
    }

    public boolean containsControl(Control control) {
        do {
            if (control == this.fShell) {
                return true;
            }
            if (!(control instanceof Shell)) continue;
            return false;
        } while ((control = control.getParent()) != null);
        return false;
    }

    public boolean isVisible() {
        return this.fShell != null && !this.fShell.isDisposed() && this.fShell.isVisible();
    }

    public Point computeSizeConstraints(int widthInChars, int heightInChars) {
        GC gc = new GC((Drawable)this.fText);
        gc.setFont(this.fTextFont);
        int width = gc.getFontMetrics().getAverageCharWidth();
        int height = this.fText.getLineHeight();
        gc.dispose();
        return new Point(widthInChars * width, heightInChars * height);
    }
}

