/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.core;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.efm.execution.core.Activator;
import org.eclipse.jface.preference.IPreferenceStore;

public class SymbexPreferenceUtil {
    private static IPath fDiversityInstallationLocation = null;
    private static IPath fDiversityAvmExecLocation = null;
    private static IPath fExternalDotGraphViewerPath;

    public static IPreferenceStore getDefaultPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public static boolean getBooleanPreference(String name) {
        return Activator.getDefault().getPreferenceStore().getBoolean(name);
    }

    public static String getStringPreference(String name) {
        return Activator.getDefault().getPreferenceStore().getString(name);
    }

    public static void setPreference(String name, String value) {
        Activator.getDefault().getPreferenceStore().setValue(name, value);
    }

    public static void loadGlobals(IPreferenceStore prefs) throws Exception {
        fDiversityInstallationLocation = new Path(prefs.getString("org.eclipse.efm.execution.core.PREF_DIVERSITY_INSTALLATION_LOCATION"));
        fDiversityAvmExecLocation = new Path(prefs.getString("org.eclipse.efm.execution.core.PREF_DIVERSITY_AVM_EXECUTABLE_LOCATION"));
        fExternalDotGraphViewerPath = new Path(prefs.getString("org.eclipse.efm.execution.core.PREF_DIVERSITY_GRAPH_VIEWER_LOCATION"));
    }

    public static IPath getDiversityInstallationLocation() {
        return fDiversityInstallationLocation;
    }

    public static String strDiversityInstallationLocation() {
        return fDiversityInstallationLocation.toOSString();
    }

    public static boolean hasDiversityInstallationLocation() {
        return fDiversityInstallationLocation != null;
    }

    public static void setDiversityInstallationLocation(IPath path) {
        fDiversityInstallationLocation = path;
    }

    public static IPath getDiversityAvmExecLocation() {
        return fDiversityAvmExecLocation;
    }

    public static String strDiversityAvmExecLocation() {
        return fDiversityAvmExecLocation.toOSString();
    }

    public static boolean hasDiversityAvmExecLocation() {
        return fDiversityAvmExecLocation != null && fDiversityAvmExecLocation.toFile().exists();
    }

    public static void setDiversityAvmExecLocation(IPath path) {
        fDiversityAvmExecLocation = path;
    }

    public static IPath getExternalDotGraphViewerPath() {
        return fExternalDotGraphViewerPath;
    }

    public static String strExternalDotGraphViewerPath() {
        return fExternalDotGraphViewerPath.toOSString();
    }

    public static boolean hasExternalDotGraphViewerPath() {
        return fExternalDotGraphViewerPath != null && fExternalDotGraphViewerPath.toFile().exists();
    }

    public static void setExternalDotGraphViewerPath(IPath path) {
        fExternalDotGraphViewerPath = path;
    }
}

