/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.search;

import org.eclipse.help.ui.RootScopePage;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class WebSearchPage
extends RootScopePage {
    private Text urlText;

    @Override
    protected int createScopeContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Label label = new Label(parent, 0);
        label.setText(Messages.WebSearchPage_label);
        GridData gd = new GridData(2);
        label.setLayoutData((Object)gd);
        this.urlText = new Text(parent, 2626);
        gd = new GridData(768);
        gd.heightHint = 64;
        gd.widthHint = 200;
        this.urlText.setLayoutData((Object)gd);
        this.urlText.addModifyListener(e -> this.validate());
        this.urlText.setEditable(this.getEngineDescriptor().isUserDefined());
        new Label(parent, 0);
        label = new Label(parent, 64);
        label.setText(Messages.WebSearchPage_info);
        gd = new GridData(768);
        gd.widthHint = 100;
        label.setLayoutData((Object)gd);
        this.applyDialogFont(parent);
        this.updateControls();
        return 2;
    }

    @Override
    protected void initializeDefaults(IPreferenceStore store) {
        super.initializeDefaults(store);
        String template = (String)this.getEngineDescriptor().getParameters().get("url");
        if (template != null) {
            store.setDefault(this.getStoreKey("url"), template);
        }
    }

    @Override
    protected void performDefaults() {
        this.getPreferenceStore().setToDefault(this.getStoreKey("url"));
        this.updateControls();
        super.performDefaults();
    }

    private void updateControls() {
        String template = this.getPreferenceStore().getString(this.getStoreKey("url"));
        this.urlText.setText(template != null ? template : "http://");
        this.validate();
    }

    private void validate() {
        String text = this.urlText.getText();
        this.setValid(text.length() > 0);
    }

    @Override
    public boolean performOk() {
        String urlTemplate = this.urlText.getText();
        this.getPreferenceStore().setValue(this.getStoreKey("url"), urlTemplate);
        return super.performOk();
    }

    private String getStoreKey(String key) {
        return String.valueOf(this.getEngineDescriptor().getId()) + "." + key;
    }
}

