/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.animation;

import fr.inria.zvtm.animation.Animation;
import fr.inria.zvtm.animation.AnimationFactory;
import fr.inria.zvtm.animation.DefaultTimingHandler;
import fr.inria.zvtm.animation.TickSource;
import fr.inria.zvtm.animation.TickThread;
import fr.inria.zvtm.animation.TimingHandler;
import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.Location;
import fr.inria.zvtm.engine.VirtualSpace;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.GuardedBy;
import org.jdesktop.animation.timing.interpolation.Interpolator;

public class AnimationManager {
    @GuardedBy(value="listsLock")
    private final List<Animation> pendingAnims = new LinkedList<Animation>();
    @GuardedBy(value="listsLock")
    private final List<Animation> runningAnims = new LinkedList<Animation>();
    private final Lock listsLock = new ReentrantLock();
    private final TickThread tickThread = new TickThread("tickThread");
    private final AnimationFactory animationFactory = new AnimationFactory(this);
    private final InteractiveCameraAnimation currentCamAnim;
    private final AtomicBoolean started = new AtomicBoolean(false);

    public AnimationManager(VirtualSpaceManager vsm) {
        this.currentCamAnim = new InteractiveCameraAnimation(vsm);
        Animation anim = this.createAnimation(-1, 1.0, Animation.RepeatBehavior.LOOP, this.currentCamAnim, Animation.Dimension.POSITION, this.currentCamAnim);
        this.startAnimation(anim, true);
    }

    Animation createAnimation(int duration, double repeatCount, Animation.RepeatBehavior repeatBehavior, Object subject, Animation.Dimension dimension, TimingHandler handler, Interpolator interpolator) {
        Animation retval = new Animation(this, duration, repeatCount, repeatBehavior, subject, dimension, handler);
        retval.setTimer(new TickSource(this.tickThread));
        retval.setInterpolator(interpolator);
        return retval;
    }

    Animation createAnimation(int duration, double repeatCount, Animation.RepeatBehavior repeatBehavior, Object subject, Animation.Dimension dimension, TimingHandler handler) {
        Animation retval = new Animation(this, duration, repeatCount, repeatBehavior, subject, dimension, handler);
        retval.setTimer(new TickSource(this.tickThread));
        return retval;
    }

    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.tickThread.start();
        }
    }

    public void stop() {
        this.tickThread.requestStop();
    }

    public AnimationFactory getAnimationFactory() {
        return this.animationFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAnimation(Animation anim, boolean force) {
        this.listsLock.lock();
        try {
            if (force) {
                this.cancelConflictingAnimations(anim);
            }
            this.pendingAnims.add(anim);
            this.startEligibleAnimations();
        }
        finally {
            this.listsLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAnimation(Animation anim) {
        this.listsLock.lock();
        try {
            if (this.pendingAnims.remove(anim)) {
                anim.handler.end(anim.subject, anim.dimension);
                return;
            }
            if (this.runningAnims.indexOf(anim) == -1) {
                return;
            }
            anim.stop();
            this.runningAnims.remove(anim);
        }
        finally {
            this.listsLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAnimation(Animation anim) {
        this.listsLock.lock();
        try {
            if (this.pendingAnims.remove(anim)) {
                return;
            }
            if (this.runningAnims.indexOf(anim) == -1) {
                return;
            }
            anim.cancel();
            this.runningAnims.remove(anim);
            this.startEligibleAnimations();
        }
        finally {
            this.listsLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pauseAnimation(Animation anim) {
        this.listsLock.lock();
        try {
            if (anim.isRunning()) {
                anim.pause();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.listsLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resumeAnimation(Animation anim) {
        this.listsLock.lock();
        try {
            anim.resume();
            boolean bl = anim.isRunning();
            return bl;
        }
        finally {
            this.listsLock.unlock();
        }
    }

    public void setResolution(int resolution) {
        this.tickThread.setResolution(resolution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onAnimationEnded(Animation anim) {
        this.listsLock.lock();
        try {
            assert (this.runningAnims.indexOf(anim) != -1);
            this.runningAnims.remove(anim);
            this.startEligibleAnimations();
        }
        finally {
            this.listsLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startEligibleAnimations() {
        this.listsLock.lock();
        try {
            LinkedList<Animation> transfer = new LinkedList<Animation>();
            for (Animation pending : this.pendingAnims) {
                boolean conflicts = false;
                for (Animation running : this.runningAnims) {
                    if (pending.orthogonalWith(running)) continue;
                    conflicts = true;
                }
                for (Animation willRun : transfer) {
                    if (pending.orthogonalWith(willRun)) continue;
                    conflicts = true;
                }
                if (conflicts) continue;
                transfer.add(pending);
            }
            this.pendingAnims.removeAll(transfer);
            this.runningAnims.addAll(transfer);
            for (Animation a : transfer) {
                a.start();
            }
        }
        finally {
            this.listsLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelConflictingAnimations(Animation anim) {
        this.listsLock.lock();
        try {
            LinkedList<Animation> remove = new LinkedList<Animation>();
            for (Animation pending : this.pendingAnims) {
                if (anim.orthogonalWith(pending)) continue;
                remove.add(pending);
            }
            this.pendingAnims.removeAll(remove);
            Animation cancel = null;
            for (Animation running : this.runningAnims) {
                if (anim.orthogonalWith(running)) continue;
                assert (null == cancel);
                cancel = running;
            }
            if (null != cancel) {
                cancel.cancel();
                this.runningAnims.remove(cancel);
            }
        }
        finally {
            this.listsLock.unlock();
        }
    }

    private static class InteractiveCameraAnimation
    extends DefaultTimingHandler {
        private final VirtualSpaceManager vsm;

        InteractiveCameraAnimation(VirtualSpaceManager vsm) {
            this.vsm = vsm;
        }

        public void timingEvent(float fraction, Object subject, Animation.Dimension dim) {
            for (VirtualSpace vs : this.vsm.getVirtualSpaces()) {
                for (Camera cam : vs.getCameraListAsArray()) {
                    this.animateInteractiveCamera(cam);
                }
            }
        }

        private void animateInteractiveCamera(Camera cam) {
            if (null != cam) {
                if (cam.getXspeed() != 0.0 || cam.getYspeed() != 0.0) {
                    cam.move(cam.getXspeed(), cam.getYspeed());
                }
                if (cam.getZspeed() != 0.0) {
                    if (cam.isCustomZoomInvariantLocationEnabled()) {
                        cam.setLocation(new Location(cam.vx + (double)Math.round((cam.vx - cam.getZilX()) * cam.getZspeed() / (cam.getAltitude() + cam.focal)), cam.vy + (double)Math.round((cam.vy - cam.getZilY()) * cam.getZspeed() / (cam.getAltitude() + cam.focal)), cam.getAltitude() + cam.getZspeed()));
                    } else {
                        double a = cam.getAltitude();
                        double b = 0.0;
                        if (a < 10.0 && a >= 0.0) {
                            a = 10.0;
                        }
                        if (a > -10.0 && a < 0.0) {
                            a = -10.0;
                        }
                        if (cam.getZspeed() == 0.0) {
                            return;
                        }
                        b = a + a * 0.01 * cam.getZspeed();
                        cam.altitudeOffset(b - a);
                    }
                }
            }
        }
    }
}

