/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.glyphs.PathElement;
import java.awt.Shape;
import java.awt.geom.CubicCurve2D;

class CBCElement
extends PathElement {
    double ctrlx1;
    double ctrly1;
    double ctrlx2;
    double ctrly2;
    CubicCurve2D[] pc;
    CubicCurve2D[] lpc;

    CBCElement(double x, double y, double ctrlx1, double ctrly1, double ctrlx2, double ctrly2, int nbCam) {
        this.type = (short)3;
        this.x = x;
        this.y = y;
        this.ctrlx1 = ctrlx1;
        this.ctrly1 = ctrly1;
        this.ctrlx2 = ctrlx2;
        this.ctrly2 = ctrly2;
        if (nbCam > 0) {
            this.initCams(nbCam);
        }
    }

    void initCams(int nbCam) {
        this.pc = new CubicCurve2D[nbCam];
        this.lpc = new CubicCurve2D[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new CubicCurve2D.Double();
            this.lpc[i] = new CubicCurve2D.Double();
        }
    }

    void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                CubicCurve2D[] ta = this.pc;
                this.pc = new CubicCurve2D[ta.length + 1];
                System.arraycopy(ta, 0, this.pc, 0, ta.length);
                this.pc[this.pc.length - 1] = new CubicCurve2D.Double();
                ta = this.lpc;
                this.lpc = new CubicCurve2D[ta.length + 1];
                System.arraycopy(ta, 0, this.lpc, 0, ta.length);
                this.lpc[this.lpc.length - 1] = new CubicCurve2D.Double();
            } else {
                System.err.println("DPath:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new CubicCurve2D[1];
            this.pc[0] = new CubicCurve2D.Double();
            this.lpc = new CubicCurve2D[1];
            this.lpc[0] = new CubicCurve2D.Double();
        } else {
            System.err.println("DPath:Error while adding camera " + verifIndex);
        }
    }

    void removeCamera(int index) {
        this.pc[index] = null;
        this.lpc[index] = null;
    }

    void project(int i, int hw, int hh, Camera c, double coef, double px, double py) {
        this.pc[i].setCurve(px, py, (double)hw + (this.ctrlx1 - c.vx) * coef, (double)hh - (this.ctrly1 - c.vy) * coef, (double)hw + (this.ctrlx2 - c.vx) * coef, (double)hh - (this.ctrly2 - c.vy) * coef, (double)hw + (this.x - c.vx) * coef, (double)hh - (this.y - c.vy) * coef);
    }

    void projectForLens(int i, int hw, int hh, double lx, double ly, double coef, double px, double py) {
        this.lpc[i].setCurve(px, py, (double)hw + (this.ctrlx1 - lx) * coef, (double)hh - (this.ctrly1 - ly) * coef, (double)hw + (this.ctrlx2 - lx) * coef, (double)hh - (this.ctrly2 - ly) * coef, (double)hw + (this.x - lx) * coef, (double)hh - (this.y - ly) * coef);
    }

    double getX(int i) {
        return this.pc[i].getX2();
    }

    double getY(int i) {
        return this.pc[i].getY2();
    }

    double getlX(int i) {
        return this.lpc[i].getX2();
    }

    double getlY(int i) {
        return this.lpc[i].getY2();
    }

    Shape getShape(int i) {
        return this.pc[i];
    }

    Shape getlShape(int i) {
        return this.lpc[i];
    }
}

