/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.VText;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.KeyEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class VTextLayout<T>
extends VText {
    static final FontRenderContext FRC = new FontRenderContext(null, false, true);
    TextLayout tl;
    static Color STRONG_CARET_COLOR = Color.BLACK;
    static Color WEAK_CARET_COLOR = Color.DARK_GRAY;
    Shape[] carets = new Shape[2];
    public static final int INSERTION_INDEX_UNDEFINED = -1;
    int insertionIndex = -1;
    static Color HIGHLIGHT_COLOR = Color.YELLOW;
    Shape highlighter = null;

    public VTextLayout(String t) {
        this(0.0, 0.0, 0, Color.BLACK, null, t, 0, mainFont, 1.0f, 1.0f);
    }

    public VTextLayout(double x, double y, int z, Color c, String t) {
        this(x, y, z, c, null, t, 0, mainFont, 1.0f, 1.0f);
    }

    public VTextLayout(double x, double y, int z, Color c, String t, short ta, Font f) {
        this(x, y, z, c, null, t, ta, f, 1.0f, 1.0f);
    }

    public VTextLayout(double x, double y, int z, Color c, String t, short ta, Font f, float scale) {
        this(x, y, z, c, null, t, ta, f, scale, 1.0f);
    }

    public VTextLayout(double x, double y, int z, Color c, String t, short ta, Font f, float scale, float alpha) {
        this(x, y, z, c, null, t, ta, f, scale, alpha);
    }

    public VTextLayout(double x, double y, int z, Color c, Color bkg, String t, short ta, Font f, float scale, float alpha) {
        super(x, y, z, c, bkg, t, ta, scale, alpha);
        this.setFont(f);
    }

    public TextLayout getTextLayout() {
        return this.tl;
    }

    public static void setCaretColors(Color sc, Color wc) {
        STRONG_CARET_COLOR = sc;
        WEAK_CARET_COLOR = wc;
    }

    public static Color getStrongCaretColor() {
        return STRONG_CARET_COLOR;
    }

    public static Color getWeakCaretColor() {
        return WEAK_CARET_COLOR;
    }

    public void setCaretPosition(int ii) {
        if (ii < 0) {
            this.insertionIndex = -1;
            this.carets = new Shape[]{null, null};
            return;
        }
        this.insertionIndex = ii;
        if (this.tl != null) {
            this.carets = this.tl.getCaretShapes(this.insertionIndex);
        }
        VirtualSpaceManager.INSTANCE.repaint();
    }

    public int getCaretPosition() {
        return this.insertionIndex;
    }

    public TextHitInfo hitTestChar(int jpx, int jpy, Camera c) {
        return this.hitTestChar(jpx, jpy, c, 0, 0);
    }

    public TextHitInfo hitTestChar(int jpx, int jpy, Camera c, int dx, int dy) {
        if (this.tl == null) {
            return null;
        }
        int i = c.getIndex();
        double tcoef = c.focal / (c.focal + c.altitude) * (double)this.scaleFactor;
        switch (this.text_anchor) {
            case 1: {
                return this.tl.hitTestChar((float)((double)(jpx - this.pc[i].cx) / tcoef + this.pc[i].cw / 2.0 / (double)this.scaleFactor - (double)dx), (float)((double)(jpy - this.pc[i].cy) / tcoef - (double)dy));
            }
            case 2: {
                return this.tl.hitTestChar((float)((double)(jpx - this.pc[i].cx) / tcoef + this.pc[i].cw / (double)this.scaleFactor - (double)dx), (float)((double)(jpy - this.pc[i].cy) / tcoef - (double)dy));
            }
        }
        return this.tl.hitTestChar((float)((double)(jpx - this.pc[i].cx) / tcoef - (double)dx), (float)((double)(jpy - this.pc[i].cy) / tcoef - (double)dy));
    }

    public void updateCaretPosition(int jpx, int jpy, Camera c) {
        this.setCaretPosition(this.hitTestChar(jpx, jpy, c).getInsertionIndex());
    }

    public static void setHighlightColor(Color c) {
        HIGHLIGHT_COLOR = c;
    }

    public static Color getHighlightColor() {
        return HIGHLIGHT_COLOR;
    }

    public void setHighlightPosition(int firstEndPoint, int secondEndPoint) {
        if (firstEndPoint < 0 || secondEndPoint < 0 || firstEndPoint == secondEndPoint) {
            this.highlighter = null;
            return;
        }
        if (this.tl != null) {
            this.highlighter = this.tl.getLogicalHighlightShape(firstEndPoint, secondEndPoint);
        }
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public void invalidate() {
        this.tl = this.text == null || this.text.length() == 0 ? null : new TextLayout(this.text, this.font != null ? this.font : VTextLayout.getMainFont(), FRC);
        try {
            for (int i = 0; i < this.pc.length; ++i) {
                this.pc[i].valid = false;
                this.pc[i].lvalid = false;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public double getSize() {
        for (int i = 0; i < this.pc.length; ++i) {
            if (!(this.pc[i] != null & this.pc[i].valid)) continue;
            return (float)Math.sqrt(this.pc[i].cw * this.pc[i].cw + this.pc[i].ch * this.pc[i].ch);
        }
        return 0.0;
    }

    @Override
    public boolean visibleInRegion(double wb, double nb, double eb, double sb, int i) {
        if (!this.validBounds(i)) {
            return true;
        }
        if (this.vx >= wb && this.vx <= eb && this.vy >= sb && this.vy <= nb) {
            return true;
        }
        if (this.text_anchor == 0) {
            return this.vx <= eb && this.vx + this.pc[i].cw >= wb && this.vy <= nb && this.vy + this.pc[i].ch >= sb;
        }
        if (this.text_anchor == 1) {
            return this.vx - this.pc[i].cw / 2.0 <= eb && this.vx + this.pc[i].cw / 2.0 >= wb && this.vy <= nb && this.vy + this.pc[i].ch >= sb;
        }
        return this.vx - this.pc[i].cw <= eb && this.vx >= wb && this.vy <= nb && this.vy + this.pc[i].ch >= sb;
    }

    @Override
    public boolean containedInRegion(double wb, double nb, double eb, double sb, int i) {
        return this.vx >= wb && this.vx <= eb && this.vy >= sb && this.vy <= nb && (this.text_anchor == 0 ? this.vx <= eb && this.vx + this.pc[i].cw >= wb && this.vy <= nb && this.vy - this.pc[i].ch >= sb : (this.text_anchor == 1 ? this.vx + this.pc[i].cw / 2.0 <= eb && this.vx - this.pc[i].cw / 2.0 >= wb && this.vy <= nb && this.vy - this.pc[i].ch >= sb : this.vx + this.pc[i].cw <= eb && this.vx >= wb && this.vy <= nb && this.vy - this.pc[i].ch >= sb));
    }

    @Override
    public boolean coordInside(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        boolean res = false;
        switch (this.text_anchor) {
            case 0: {
                if (!(cvx >= this.vx) || !(cvy >= this.vy) || !(cvx <= this.vx + this.pc[camIndex].cw) || !(cvy <= this.vy + this.pc[camIndex].ch)) break;
                res = true;
                break;
            }
            case 1: {
                if (!(cvx >= this.vx - this.pc[camIndex].cw / 2.0) || !(cvy >= this.vy) || !(cvx <= this.vx + this.pc[camIndex].cw / 2.0) || !(cvy <= this.vy + this.pc[camIndex].ch)) break;
                res = true;
                break;
            }
            default: {
                if (!(cvx <= this.vx) || !(cvy >= this.vy) || !(cvx >= this.vx - this.pc[camIndex].cw) || !(cvy <= this.vy + this.pc[camIndex].ch)) break;
                res = true;
            }
        }
        return res;
    }

    @Override
    public boolean visibleInDisc(double dvx, double dvy, double dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        if (this.text_anchor == 0) {
            return dvs.intersects(this.vx, this.vy, this.pc[camIndex].cw, this.pc[camIndex].ch);
        }
        if (this.text_anchor == 1) {
            return dvs.intersects(this.vx - this.pc[camIndex].cw / 2.0, this.vy, this.pc[camIndex].cw, this.pc[camIndex].ch);
        }
        return dvs.intersects(this.vx - this.pc[camIndex].cw, this.vy, this.pc[camIndex].cw, this.pc[camIndex].ch);
    }

    @Override
    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = d.width / 2 + (int)Math.round((this.vx - c.vx) * this.coef);
        this.pc[i].cy = d.height / 2 - (int)Math.round((this.vy - c.vy) * this.coef);
    }

    @Override
    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, double lensx, double lensy) {
        int i = c.getIndex();
        this.lcoef = c.focal / (c.focal + c.altitude) * (double)lensMag;
        this.pc[i].lcx = lensWidth / 2 + (int)Math.round((this.vx - lensx) * this.lcoef);
        this.pc[i].lcy = lensHeight / 2 - (int)Math.round((this.vy - lensy) * this.lcoef);
    }

    @Override
    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (!this.pc[i].valid || !this.zoomSensitive && this.coef != this.oldcoef) {
            if (this.text.length() > 0) {
                g.setFont(this.font != null ? this.font : VTextLayout.getMainFont());
                this.tl = new TextLayout(this.text, this.font != null ? this.font : VTextLayout.getMainFont(), g.getFontRenderContext());
                Rectangle2D bounds = g.getFontMetrics().getStringBounds(this.text, g);
                if (this.zoomSensitive) {
                    this.pc[i].cw = bounds.getWidth() * (double)this.scaleFactor;
                    this.pc[i].ch = bounds.getHeight() * (double)this.scaleFactor;
                } else {
                    this.pc[i].cw = bounds.getWidth() * (double)this.scaleFactor / this.coef;
                    this.pc[i].ch = bounds.getHeight() * (double)this.scaleFactor / this.coef;
                    this.oldcoef = this.coef;
                }
            } else {
                this.pc[i].ch = 1.0;
                this.pc[i].cw = 1.0;
            }
            this.pc[i].valid = true;
        }
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        double trueCoef = (double)this.scaleFactor * this.coef;
        if (trueCoef * (double)this.fontSize > (double)VText.TEXT_AS_LINE_PROJ_COEF || !this.zoomSensitive) {
            g.setFont(this.font != null ? this.font : VTextLayout.getMainFont());
            AffineTransform at = this.text_anchor == 0 ? AffineTransform.getTranslateInstance(dx + this.pc[i].cx, dy + this.pc[i].cy) : (this.text_anchor == 1 ? AffineTransform.getTranslateInstance((double)(dx + this.pc[i].cx) - this.pc[i].cw * this.coef / 2.0, dy + this.pc[i].cy) : AffineTransform.getTranslateInstance((double)(dx + this.pc[i].cx) - this.pc[i].cw * this.coef, dy + this.pc[i].cy));
            if (this.zoomSensitive) {
                at.concatenate(AffineTransform.getScaleInstance(trueCoef, trueCoef));
            }
            g.setTransform(at);
            int rectH = (int)Math.round(this.pc[i].ch / (double)this.scaleFactor);
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                if (this.isBorderDrawn()) {
                    g.setColor(this.borderColor);
                    g.fillRect(dx - this.paddingX, dy - rectH + 1 + 2 * this.paddingY, (int)Math.round(this.pc[i].cw / (double)this.scaleFactor + (double)this.paddingX), rectH - 1 + 2 * this.paddingY);
                }
                if (this.highlighter != null) {
                    g.setColor(HIGHLIGHT_COLOR);
                    g.fill(this.highlighter);
                }
                g.setColor(this.color);
                if (this.tl != null) {
                    this.tl.draw(g, 0.0f, 0.0f);
                }
                if (this.carets[0] != null) {
                    g.setColor(STRONG_CARET_COLOR);
                    g.draw(this.carets[0]);
                }
                if (this.carets[1] != null) {
                    g.setColor(WEAK_CARET_COLOR);
                    g.draw(this.carets[1]);
                }
                g.setComposite(acO);
            } else {
                if (this.isBorderDrawn()) {
                    g.setColor(this.borderColor);
                    g.fillRect(dx - this.paddingX, dy - rectH + 1 + 2 * this.paddingY, (int)Math.round(this.pc[i].cw / (double)this.scaleFactor + (double)this.paddingX), rectH - 1 + 2 * this.paddingY);
                }
                if (this.highlighter != null) {
                    g.setColor(HIGHLIGHT_COLOR);
                    g.fill(this.highlighter);
                }
                g.setColor(this.color);
                if (this.tl != null) {
                    this.tl.draw(g, 0.0f, 0.0f);
                }
                if (this.carets[0] != null) {
                    g.setColor(STRONG_CARET_COLOR);
                    g.draw(this.carets[0]);
                }
                if (this.carets[1] != null) {
                    g.setColor(WEAK_CARET_COLOR);
                    g.draw(this.carets[1]);
                }
            }
            g.setTransform(stdT);
        } else {
            g.setColor(this.color);
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
                g.setComposite(acO);
            } else {
                g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
            }
        }
    }

    @Override
    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (!this.pc[i].lvalid || !this.zoomSensitive && this.lcoef != this.oldlcoef) {
            if (this.text.length() > 0) {
                g.setFont(this.font != null ? this.font : VTextLayout.getMainFont());
                this.tl = new TextLayout(this.text, this.font != null ? this.font : VTextLayout.getMainFont(), g.getFontRenderContext());
                Rectangle2D bounds = g.getFontMetrics().getStringBounds(this.text, g);
                if (this.zoomSensitive) {
                    this.pc[i].lcw = bounds.getWidth() * (double)this.scaleFactor;
                    this.pc[i].lch = bounds.getHeight() * (double)this.scaleFactor;
                } else {
                    this.pc[i].lcw = bounds.getWidth() * (double)this.scaleFactor / this.lcoef;
                    this.pc[i].lch = bounds.getHeight() * (double)this.scaleFactor / this.lcoef;
                    this.oldlcoef = this.lcoef;
                }
            } else {
                this.pc[i].lch = 0.0;
                this.pc[i].lcw = 0.0;
            }
            this.pc[i].lvalid = true;
        }
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        double trueCoef = (double)this.scaleFactor * this.lcoef;
        g.setColor(this.color);
        if (trueCoef * (double)this.fontSize > (double)VText.TEXT_AS_LINE_PROJ_COEF || !this.zoomSensitive) {
            g.setFont(this.font != null ? this.font : VTextLayout.getMainFont());
            AffineTransform at = this.text_anchor == 0 ? AffineTransform.getTranslateInstance(dx + this.pc[i].lcx, dy + this.pc[i].lcy) : (this.text_anchor == 1 ? AffineTransform.getTranslateInstance((double)(dx + this.pc[i].lcx) - this.pc[i].lcw * this.lcoef / 2.0, dy + this.pc[i].lcy) : AffineTransform.getTranslateInstance((double)(dx + this.pc[i].lcx) - this.pc[i].lcw * this.lcoef, dy + this.pc[i].lcy));
            if (this.zoomSensitive) {
                at.concatenate(AffineTransform.getScaleInstance(trueCoef, trueCoef));
            }
            g.setTransform(at);
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                if (this.highlighter != null) {
                    g.setColor(HIGHLIGHT_COLOR);
                    g.fill(this.highlighter);
                }
                if (this.tl != null) {
                    this.tl.draw(g, 0.0f, 0.0f);
                }
                if (this.carets[0] != null) {
                    g.setColor(STRONG_CARET_COLOR);
                    g.draw(this.carets[0]);
                }
                if (this.carets[1] != null) {
                    g.setColor(WEAK_CARET_COLOR);
                    g.draw(this.carets[1]);
                }
                g.setComposite(acO);
            } else {
                if (this.highlighter != null) {
                    g.setColor(HIGHLIGHT_COLOR);
                    g.fill(this.highlighter);
                }
                if (this.tl != null) {
                    this.tl.draw(g, 0.0f, 0.0f);
                }
                if (this.carets[0] != null) {
                    g.setColor(STRONG_CARET_COLOR);
                    g.draw(this.carets[0]);
                }
                if (this.carets[1] != null) {
                    g.setColor(WEAK_CARET_COLOR);
                    g.draw(this.carets[1]);
                }
            }
            g.setTransform(stdT);
        } else if (this.alphaC != null) {
            g.setComposite(this.alphaC);
            g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
            g.setComposite(acO);
        } else {
            g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
        }
    }

    @Override
    public Point2D.Double getBounds(int i) {
        return new Point2D.Double(this.pc[i].cw, this.pc[i].ch);
    }

    @Override
    public void setFont(Font f) {
        if (f != null) {
            this.font = f;
            this.fontSize = this.font.getSize2D();
        } else {
            this.font = null;
            this.fontSize = VTextLayout.getMainFont().getSize2D();
        }
        VirtualSpaceManager.INSTANCE.repaint();
        this.invalidate();
    }

    @Override
    public Shape getJava2DShape() {
        return null;
    }

    @Override
    public Object clone() {
        VTextLayout<T> res = new VTextLayout<T>(this.vx, this.vy, this.vz, this.color, this.borderColor, new StringBuffer(this.text).toString(), this.text_anchor, this.font, this.getScale(), this.alphaC != null ? this.alphaC.getAlpha() : 1.0f);
        res.cursorInsideColor = this.cursorInsideColor;
        return res;
    }

    public static void editEvent(VTextLayout tl, KeyEvent e) {
        char c = e.getKeyChar();
        if (Character.isLetterOrDigit(c) || Character.isWhitespace(c)) {
            String res = tl.getText().substring(0, tl.getCaretPosition()) + String.valueOf(c) + tl.getText().substring(tl.getCaretPosition());
            tl.setText(res);
            tl.setCaretPosition(tl.getCaretPosition() + 1);
        } else if (e.getKeyCode() == 8) {
            if (tl.getText().length() == 0) {
                return;
            }
            String res = tl.getText().substring(0, tl.getCaretPosition() - 1) + tl.getText().substring(tl.getCaretPosition());
            tl.setText(res);
            tl.setCaretPosition(tl.getCaretPosition() - 1);
        } else if (e.getKeyCode() == 127) {
            if (tl.getText().length() == 0 || tl.getCaretPosition() >= tl.getText().length()) {
                return;
            }
            String res = tl.getText().substring(0, tl.getCaretPosition()) + tl.getText().substring(tl.getCaretPosition() + 1);
            tl.setText(res);
            if (tl.getCaretPosition() > tl.getText().length()) {
                tl.setCaretPosition(tl.getText().length());
            }
        } else if (e.getKeyCode() == 37) {
            if (tl.getCaretPosition() > 0) {
                tl.setCaretPosition(tl.getCaretPosition() - 1);
            }
        } else if (e.getKeyCode() == 39) {
            if (tl.getCaretPosition() < tl.getText().length()) {
                tl.setCaretPosition(tl.getCaretPosition() + 1);
            }
        } else if (e.getKeyCode() == 38) {
            tl.setCaretPosition(0);
        } else if (e.getKeyCode() == 40) {
            tl.setCaretPosition(tl.getText().length());
        }
    }
}

