/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.ecore.formalml.common.impl;

import org.eclipse.efm.ecore.formalml.common.ClassifierDefinition;
import org.eclipse.efm.ecore.formalml.common.CommonFactory;
import org.eclipse.efm.ecore.formalml.common.CommonPackage;
import org.eclipse.efm.ecore.formalml.common.QualifiedName;
import org.eclipse.efm.ecore.formalml.common.Type;
import org.eclipse.efm.ecore.formalml.common.TypedElement;
import org.eclipse.efm.ecore.formalml.common.VisibilityKind;
import org.eclipse.efm.ecore.formalml.common.impl.ClassifierDefinitionImpl;
import org.eclipse.efm.ecore.formalml.common.impl.QualifiedNameImpl;
import org.eclipse.efm.ecore.formalml.common.impl.TypeImpl;
import org.eclipse.efm.ecore.formalml.common.impl.TypedElementImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class CommonFactoryImpl
extends EFactoryImpl
implements CommonFactory {
    public static CommonFactory init() {
        try {
            CommonFactory theCommonFactory = (CommonFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/efm/FormalML/Common");
            if (theCommonFactory != null) {
                return theCommonFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new CommonFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 1: {
                return this.createQualifiedName();
            }
            case 3: {
                return this.createType();
            }
            case 4: {
                return this.createTypedElement();
            }
            case 5: {
                return this.createClassifierDefinition();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.createVisibilityKindFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.convertVisibilityKindToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public QualifiedName createQualifiedName() {
        QualifiedNameImpl qualifiedName = new QualifiedNameImpl();
        return qualifiedName;
    }

    @Override
    public Type createType() {
        TypeImpl type = new TypeImpl();
        return type;
    }

    @Override
    public TypedElement createTypedElement() {
        TypedElementImpl typedElement = new TypedElementImpl();
        return typedElement;
    }

    @Override
    public ClassifierDefinition createClassifierDefinition() {
        ClassifierDefinitionImpl classifierDefinition = new ClassifierDefinitionImpl();
        return classifierDefinition;
    }

    public VisibilityKind createVisibilityKindFromString(EDataType eDataType, String initialValue) {
        VisibilityKind result = VisibilityKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertVisibilityKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public CommonPackage getCommonPackage() {
        return (CommonPackage)this.getEPackage();
    }

    @Deprecated
    public static CommonPackage getPackage() {
        return CommonPackage.eINSTANCE;
    }
}

