/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.ecore.formalml.expression;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ValueElementSpecificationScheme implements Enumerator
{
    ANY(0, "any", "any"),
    VARIABLE(1, "variable", "variable"),
    TYPEDEF(2, "typedef", "typedef"),
    MESSAGE(3, "message", "message"),
    SIGNAL(4, "signal", "signal"),
    BUFFER(5, "buffer", "buffer"),
    CHANNEL(6, "channel", "channel"),
    PORT(7, "port", "port"),
    COM_POINT(8, "com_point", "com_point"),
    INSTANCE(9, "instance", "instance"),
    MACHINE(10, "machine", "machine"),
    MODEL(11, "model", "model"),
    PROCEDURE(12, "procedure", "procedure"),
    ROUTINE(13, "routine", "routine"),
    VERTEX(14, "vertex", "vertex");

    public static final int ANY_VALUE = 0;
    public static final int VARIABLE_VALUE = 1;
    public static final int TYPEDEF_VALUE = 2;
    public static final int MESSAGE_VALUE = 3;
    public static final int SIGNAL_VALUE = 4;
    public static final int BUFFER_VALUE = 5;
    public static final int CHANNEL_VALUE = 6;
    public static final int PORT_VALUE = 7;
    public static final int COM_POINT_VALUE = 8;
    public static final int INSTANCE_VALUE = 9;
    public static final int MACHINE_VALUE = 10;
    public static final int MODEL_VALUE = 11;
    public static final int PROCEDURE_VALUE = 12;
    public static final int ROUTINE_VALUE = 13;
    public static final int VERTEX_VALUE = 14;
    private static final ValueElementSpecificationScheme[] VALUES_ARRAY;
    public static final List<ValueElementSpecificationScheme> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ValueElementSpecificationScheme[]{ANY, VARIABLE, TYPEDEF, MESSAGE, SIGNAL, BUFFER, CHANNEL, PORT, COM_POINT, INSTANCE, MACHINE, MODEL, PROCEDURE, ROUTINE, VERTEX};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ValueElementSpecificationScheme get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ValueElementSpecificationScheme result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ValueElementSpecificationScheme getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ValueElementSpecificationScheme result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ValueElementSpecificationScheme get(int value) {
        switch (value) {
            case 0: {
                return ANY;
            }
            case 1: {
                return VARIABLE;
            }
            case 2: {
                return TYPEDEF;
            }
            case 3: {
                return MESSAGE;
            }
            case 4: {
                return SIGNAL;
            }
            case 5: {
                return BUFFER;
            }
            case 6: {
                return CHANNEL;
            }
            case 7: {
                return PORT;
            }
            case 8: {
                return COM_POINT;
            }
            case 9: {
                return INSTANCE;
            }
            case 10: {
                return MACHINE;
            }
            case 11: {
                return MODEL;
            }
            case 12: {
                return PROCEDURE;
            }
            case 13: {
                return ROUTINE;
            }
            case 14: {
                return VERTEX;
            }
        }
        return null;
    }

    private ValueElementSpecificationScheme(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

