/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.ecore.formalml.infrastructure;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DesignKind implements Enumerator
{
    MODEL(0, "model", "model"),
    INSTANCE(1, "instance", "instance"),
    PROTOTYPE(2, "prototype", "prototype");

    public static final int MODEL_VALUE = 0;
    public static final int INSTANCE_VALUE = 1;
    public static final int PROTOTYPE_VALUE = 2;
    private static final DesignKind[] VALUES_ARRAY;
    public static final List<DesignKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DesignKind[]{MODEL, INSTANCE, PROTOTYPE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DesignKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DesignKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DesignKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DesignKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DesignKind get(int value) {
        switch (value) {
            case 0: {
                return MODEL;
            }
            case 1: {
                return INSTANCE;
            }
            case 2: {
                return PROTOTYPE;
            }
        }
        return null;
    }

    private DesignKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

