/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.propertypages;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.propertypages.InstanceFilterEditor;
import org.eclipse.jdt.internal.debug.ui.propertypages.ThreadFilterEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class JavaBreakpointAdvancedPage
extends PropertyPage {
    ThreadFilterEditor fThreadFilterEditor;
    InstanceFilterEditor fInstanceFilterEditor;

    public boolean performOk() {
        this.doStore();
        return super.performOk();
    }

    protected void doStore() {
        this.fThreadFilterEditor.doStore();
        if (this.fInstanceFilterEditor != null) {
            this.fInstanceFilterEditor.doStore();
        }
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setFont(parent.getFont());
        mainComposite.setLayout((Layout)new GridLayout());
        mainComposite.setLayoutData((Object)new GridData(1808));
        this.createThreadFilterEditor(mainComposite);
        this.createTypeSpecificEditors(mainComposite);
        this.createInstanceFilterEditor(mainComposite);
        this.setValid(true);
        return mainComposite;
    }

    public void createInstanceFilterEditor(Composite parent) {
        IJavaBreakpoint breakpoint = this.getBreakpoint();
        try {
            IJavaObject[] instances = breakpoint.getInstanceFilters();
            if (instances.length > 0) {
                this.fInstanceFilterEditor = new InstanceFilterEditor(parent, breakpoint);
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
    }

    protected void createTypeSpecificEditors(Composite parent) {
    }

    protected void createThreadFilterEditor(Composite parent) {
        this.fThreadFilterEditor = new ThreadFilterEditor(parent, this);
    }

    public IJavaBreakpoint getBreakpoint() {
        return (IJavaBreakpoint)this.getElement();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IJavaDebugHelpContextIds.JAVA_BREAKPOINT_ADVANCED_PROPERTY_PAGE);
    }
}

