/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import fr.inria.zvtm.engine.Location;
import fr.inria.zvtm.engine.SwingWorker;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import net.claribole.zgrviewer.BookmarksList;
import net.claribole.zgrviewer.GraphicsManager;
import net.claribole.zgrviewer.Plugin;
import net.claribole.zgrviewer.TextViewer;
import net.claribole.zgrviewer.Utils;
import net.claribole.zgrviewer.WebBrowser;
import net.claribole.zgrviewer.ZGRViewer;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigManager {
    public static final String zgrvURI = "http://zvtm.sourceforge.net/zgrviewer";
    static final String MAIN_TITLE = "ZGRViewer";
    static int mainViewW = 800;
    static int mainViewH = 600;
    static int mainViewX = 0;
    static int mainViewY = 0;
    static int rdW = 300;
    static int rdH = 200;
    static Font defaultFont = new Font("Dialog", 0, 12);
    static Font SMALL_FONT = new Font("Dialog", 0, 10);
    static final String _BLANK = "_blank";
    static final String _SELF = "_self";
    static Font PIEMENU_FONT = defaultFont;
    Color backgroundColor = Color.WHITE;
    static Color HIGHLIGHT_COLOR = Color.RED;
    public static Color OBSERVED_REGION_COLOR = new Color(186, 135, 186);
    public static Color OBSERVED_REGION_BORDER_COLOR = Color.getHSBColor(0.83519f, 0.28f, 0.45f);
    public static Color OBSERVED_REGION_CROSSHAIR_COLOR = new Color(115, 83, 115);
    public static Color PIEMENU_FILL_COLOR;
    public static Color PIEMENU_BORDER_COLOR;
    public static Color PIEMENU_INSIDE_COLOR;
    public static final float PIEMENU_MAIN_ALPHA = 0.85f;
    public static final float PIEMENU_SUB_ALPHA = 0.95f;
    static boolean SAVE_WINDOW_LAYOUT;
    static boolean DELETE_TEMP_FILES;
    static boolean ANTIALIASING;
    static boolean DYNASPOT;
    static boolean FORCE_SILENT;
    static String CMD_LINE_OPTS;
    static File m_TmpDir;
    static File m_PrjDir;
    static File m_DotPath;
    static File m_NeatoPath;
    static File m_CircoPath;
    static File m_TwopiPath;
    static File m_GraphVizFontDir;
    static File m_LastDir;
    static File m_LastExportDir;
    public static File plugInDir;
    Plugin[] plugins;
    private Hashtable tmpPluginSettings;
    File lastFileOpened = null;
    static String PREFS_FILE_NAME;
    static String OLD_PREFS_FILE_NAME;
    public static final int ANIM_MOVE_LENGTH = 300;
    public static float MAG_FACTOR;
    static WebBrowser webBrowser;
    static boolean autoDetectBrowser;
    static File browserPath;
    static String browserOptions;
    static boolean useProxy;
    static String proxyHost;
    static String proxyPort;
    double SD_ZOOM_THRESHOLD = 300.0;
    boolean SD_ZOOM_ENABLED = false;
    double autoZoomFactor = 1.0;
    double autoUnzoomFactor = -0.5;
    static Vector LAST_COMMANDS;
    static int COMMAND_LIMIT;
    GraphicsManager grMngr;
    static File[] pluginJARs;
    HashMap<String, Location> bookmarks = new HashMap(1);
    static final String BK_SEP = "\t";

    ConfigManager(GraphicsManager gm, boolean applet) {
        this.grMngr = gm;
        LAST_COMMANDS = new Vector();
        if (!applet) {
            m_TmpDir = new File(System.getProperty("java.io.tmpdir"));
        }
    }

    void loadConfig() {
        File cfgFile = new File(System.getProperty("user.home") + File.separatorChar + PREFS_FILE_NAME);
        if (!cfgFile.exists()) {
            cfgFile = new File(System.getProperty("user.home") + File.separatorChar + OLD_PREFS_FILE_NAME);
        }
        if (cfgFile.exists()) {
            System.out.println("Loading Preferences from : " + cfgFile.getAbsolutePath());
            try {
                Document d = Utils.parse(cfgFile, false);
                d.normalize();
                Element rt = d.getDocumentElement();
                Element e = (Element)rt.getElementsByTagNameNS(zgrvURI, "directories").item(0);
                try {
                    m_TmpDir = new File(e.getElementsByTagNameNS(zgrvURI, "tmpDir").item(0).getFirstChild().getNodeValue());
                    DELETE_TEMP_FILES = new Boolean(((Element)e.getElementsByTagNameNS(zgrvURI, "tmpDir").item(0)).getAttribute("value"));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    m_PrjDir = new File(e.getElementsByTagNameNS(zgrvURI, "graphDir").item(0).getFirstChild().getNodeValue());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    m_DotPath = new File(e.getElementsByTagNameNS(zgrvURI, "dot").item(0).getFirstChild().getNodeValue());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    m_NeatoPath = new File(e.getElementsByTagNameNS(zgrvURI, "neato").item(0).getFirstChild().getNodeValue());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    m_CircoPath = new File(e.getElementsByTagNameNS(zgrvURI, "circo").item(0).getFirstChild().getNodeValue());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    m_TwopiPath = new File(e.getElementsByTagNameNS(zgrvURI, "twopi").item(0).getFirstChild().getNodeValue());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    m_GraphVizFontDir = new File(e.getElementsByTagNameNS(zgrvURI, "graphvizFontDir").item(0).getFirstChild().getNodeValue());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    e = (Element)rt.getElementsByTagNameNS(zgrvURI, "webBrowser").item(0);
                    autoDetectBrowser = new Boolean(e.getAttribute("autoDetect"));
                    browserPath = new File(e.getAttribute("path"));
                    browserOptions = e.getAttribute("options");
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    e = (Element)rt.getElementsByTagNameNS(zgrvURI, "proxy").item(0);
                    ConfigManager.updateProxy(new Boolean(e.getAttribute("enable")), e.getAttribute("host"), e.getAttribute("port"));
                }
                catch (Exception ex) {
                    System.getProperties().put("proxySet", "false");
                }
                try {
                    e = (Element)rt.getElementsByTagNameNS(zgrvURI, "preferences").item(0);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    ANTIALIASING = new Boolean(e.getAttribute("antialiasing"));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    DYNASPOT = new Boolean(e.getAttribute("dynaspot"));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    HIGHLIGHT_COLOR = new Color(new Integer(e.getAttribute("highlightColor")));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    SAVE_WINDOW_LAYOUT = new Boolean(e.getAttribute("saveWindowLayout"));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    this.setSDZoomEnabled(new Boolean(e.getAttribute("sdZoom")));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    this.setSDZoomFactor(Integer.parseInt(e.getAttribute("sdZoomFactor")));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    this.setMagnificationFactor(Float.parseFloat(e.getAttribute("magFactor")));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    CMD_LINE_OPTS = e.getAttribute("cmdL_options");
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    FORCE_SILENT = new Boolean(e.getAttribute("silent"));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    if (SAVE_WINDOW_LAYOUT) {
                        e = (Element)rt.getElementsByTagNameNS(zgrvURI, "windows").item(0);
                        mainViewX = new Integer(e.getAttribute("mainX"));
                        mainViewY = new Integer(e.getAttribute("mainY"));
                        mainViewW = new Integer(e.getAttribute("mainW"));
                        mainViewH = new Integer(e.getAttribute("mainH"));
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    e = (Element)rt.getElementsByTagNameNS(zgrvURI, "plugins").item(0);
                    if (e != null) {
                        this.loadPluginPreferences(e);
                    }
                }
                catch (Exception ex) {
                    System.err.println("Failed to set some plugin preferences");
                }
                LAST_COMMANDS.removeAllElements();
                try {
                    NodeList nl = ((Element)rt.getElementsByTagNameNS(zgrvURI, "commandLines").item(0)).getElementsByTagNameNS(zgrvURI, "li");
                    for (int i = 0; i < nl.getLength(); ++i) {
                        if (i >= COMMAND_LIMIT) continue;
                        LAST_COMMANDS.add(nl.item(i).getFirstChild().getNodeValue());
                    }
                }
                catch (NullPointerException ex1) {
                }
            }
            catch (Exception ex) {
                System.err.println("Error while loading ZGRViewer configuration file (" + cfgFile.getAbsolutePath() + "): ");
                ex.printStackTrace();
            }
        } else {
            System.out.println("No Preferences File Found in : " + System.getProperty("user.home"));
        }
    }

    void loadPluginPreferences(Element pluginsEL) {
        NodeList nl = pluginsEL.getElementsByTagNameNS(zgrvURI, "plugin");
        this.tmpPluginSettings = new Hashtable();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element pluginEL = (Element)nl.item(i);
            String pluginName = pluginEL.getAttribute("name");
            Hashtable<String, String> ht = new Hashtable<String, String>();
            NodeList nl2 = pluginEL.getElementsByTagNameNS(zgrvURI, "setting");
            for (int j = 0; j < nl2.getLength(); ++j) {
                Element settingEL = (Element)nl2.item(j);
                try {
                    Node txtVal = settingEL.getFirstChild();
                    ht.put(settingEL.getAttribute("name"), txtVal != null ? txtVal.getNodeValue() : null);
                    continue;
                }
                catch (Exception ex) {
                    System.err.println("Failed to set some plugin preferences for " + pluginName);
                }
            }
            this.tmpPluginSettings.put(pluginName, ht);
        }
    }

    void saveConfig() {
        File cfgFile;
        int i;
        DOMImplementationImpl di = new DOMImplementationImpl();
        Document cfg = di.createDocument(zgrvURI, "zgrv:config", null);
        Element rt = cfg.getDocumentElement();
        rt.setAttribute("xmlns:zgrv", zgrvURI);
        Element dirs = cfg.createElementNS(zgrvURI, "zgrv:directories");
        rt.appendChild(dirs);
        Element aDir = cfg.createElementNS(zgrvURI, "zgrv:tmpDir");
        aDir.appendChild(cfg.createTextNode(m_TmpDir.toString()));
        aDir.setAttribute("value", String.valueOf(DELETE_TEMP_FILES));
        dirs.appendChild(aDir);
        aDir = cfg.createElementNS(zgrvURI, "zgrv:graphDir");
        aDir.appendChild(cfg.createTextNode(m_PrjDir.toString()));
        dirs.appendChild(aDir);
        aDir = cfg.createElementNS(zgrvURI, "zgrv:dot");
        aDir.appendChild(cfg.createTextNode(m_DotPath.toString()));
        dirs.appendChild(aDir);
        aDir = cfg.createElementNS(zgrvURI, "zgrv:neato");
        aDir.appendChild(cfg.createTextNode(m_NeatoPath.toString()));
        dirs.appendChild(aDir);
        aDir = cfg.createElementNS(zgrvURI, "zgrv:circo");
        aDir.appendChild(cfg.createTextNode(m_CircoPath.toString()));
        dirs.appendChild(aDir);
        aDir = cfg.createElementNS(zgrvURI, "zgrv:twopi");
        aDir.appendChild(cfg.createTextNode(m_TwopiPath.toString()));
        dirs.appendChild(aDir);
        aDir = cfg.createElementNS(zgrvURI, "zgrv:graphvizFontDir");
        aDir.appendChild(cfg.createTextNode(m_GraphVizFontDir.toString()));
        dirs.appendChild(aDir);
        Element consts = cfg.createElementNS(zgrvURI, "zgrv:webBrowser");
        consts.setAttribute("autoDetect", String.valueOf(autoDetectBrowser));
        consts.setAttribute("path", browserPath.toString());
        consts.setAttribute("options", browserOptions);
        rt.appendChild(consts);
        consts = cfg.createElementNS(zgrvURI, "zgrv:proxy");
        consts.setAttribute("enable", String.valueOf(useProxy));
        consts.setAttribute("host", proxyHost);
        consts.setAttribute("port", proxyPort);
        rt.appendChild(consts);
        consts = cfg.createElementNS(zgrvURI, "zgrv:preferences");
        rt.appendChild(consts);
        consts.setAttribute("antialiasing", String.valueOf(ANTIALIASING));
        consts.setAttribute("dynaspot", String.valueOf(DYNASPOT));
        consts.setAttribute("highlightColor", Integer.toString(HIGHLIGHT_COLOR.getRGB()));
        consts.setAttribute("silent", String.valueOf(FORCE_SILENT));
        consts.setAttribute("saveWindowLayout", String.valueOf(SAVE_WINDOW_LAYOUT));
        consts.setAttribute("sdZoom", String.valueOf(this.SD_ZOOM_ENABLED));
        consts.setAttribute("sdZoomFactor", String.valueOf(this.getSDZoomFactor()));
        consts.setAttribute("magFactor", String.valueOf(this.getMagnificationFactor()));
        consts.setAttribute("cmdL_options", CMD_LINE_OPTS);
        if (SAVE_WINDOW_LAYOUT) {
            this.updateWindowVariables();
            consts = cfg.createElementNS(zgrvURI, "zgrv:windows");
            consts.setAttribute("mainX", String.valueOf(mainViewX));
            consts.setAttribute("mainY", String.valueOf(mainViewY));
            consts.setAttribute("mainW", String.valueOf(mainViewW));
            consts.setAttribute("mainH", String.valueOf(mainViewH));
            rt.appendChild(consts);
        }
        Element pluginsEL = cfg.createElementNS(zgrvURI, "zgrv:plugins");
        rt.appendChild(pluginsEL);
        for (i = 0; i < this.plugins.length; ++i) {
            Hashtable pluginSettings = this.plugins[i].savePreferences();
            if (pluginSettings == null || pluginSettings.size() <= 0) continue;
            Element pluginEL = cfg.createElementNS(zgrvURI, "zgrv:plugin");
            pluginsEL.appendChild(pluginEL);
            pluginEL.setAttribute("name", this.plugins[i].getName());
            Enumeration e = pluginSettings.keys();
            while (e.hasMoreElements()) {
                String settingName = (String)e.nextElement();
                String settingValue = (String)pluginSettings.get(settingName);
                Element settingEL = cfg.createElementNS(zgrvURI, "zgrv:setting");
                settingEL.setAttribute("name", settingName);
                settingEL.appendChild(cfg.createTextNode(settingValue));
                pluginEL.appendChild(settingEL);
            }
        }
        consts = cfg.createElementNS(zgrvURI, "zgrv:commandLines");
        rt.appendChild(consts);
        if (LAST_COMMANDS != null) {
            for (i = 0; i < LAST_COMMANDS.size(); ++i) {
                Element aCommand = cfg.createElementNS(zgrvURI, "zgrv:li");
                aCommand.appendChild(cfg.createTextNode((String)LAST_COMMANDS.elementAt(i)));
                consts.appendChild(aCommand);
            }
        }
        if ((cfgFile = new File(System.getProperty("user.home") + File.separatorChar + PREFS_FILE_NAME)).exists()) {
            cfgFile.delete();
        }
        Utils.serialize(cfg, cfgFile);
    }

    void saveCommandLines() {
        try {
            Element cLines;
            Element rt;
            Document d;
            File cfgFile = new File(System.getProperty("user.home") + File.separatorChar + PREFS_FILE_NAME);
            if (!cfgFile.exists()) {
                cfgFile = new File(System.getProperty("user.home") + File.separatorChar + OLD_PREFS_FILE_NAME);
            }
            if (cfgFile.exists()) {
                d = Utils.parse(cfgFile, false);
                d.normalize();
                rt = d.getDocumentElement();
                if (rt.getElementsByTagNameNS(zgrvURI, "commandLines").getLength() > 0) {
                    rt.removeChild(rt.getElementsByTagNameNS(zgrvURI, "commandLines").item(0));
                }
                cLines = d.createElementNS(zgrvURI, "zgrv:commandLines");
                if (LAST_COMMANDS != null) {
                    for (int i = 0; i < LAST_COMMANDS.size(); ++i) {
                        Element aCmdLine = d.createElementNS(zgrvURI, "zgrv:li");
                        aCmdLine.appendChild(d.createTextNode((String)LAST_COMMANDS.elementAt(i)));
                        cLines.appendChild(aCmdLine);
                    }
                }
            } else {
                DOMImplementationImpl di = new DOMImplementationImpl();
                d = di.createDocument(zgrvURI, "zgrv:config", null);
                rt = d.getDocumentElement();
                rt.setAttribute("xmlns:zgrv", zgrvURI);
                cLines = d.createElementNS(zgrvURI, "zgrv:commandLines");
                if (LAST_COMMANDS != null) {
                    for (int i = 0; i < LAST_COMMANDS.size(); ++i) {
                        Element aCmdLine = d.createElementNS(zgrvURI, "zgrv:li");
                        aCmdLine.appendChild(d.createTextNode((String)LAST_COMMANDS.elementAt(i)));
                        cLines.appendChild(aCmdLine);
                    }
                }
            }
            rt.appendChild(cLines);
            cfgFile = new File(System.getProperty("user.home") + File.separatorChar + PREFS_FILE_NAME);
            Utils.serialize(d, cfgFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static boolean checkProgram(short prg) {
        switch (prg) {
            case 0: {
                return m_TmpDir.exists() && m_DotPath.exists();
            }
            case 1: {
                return m_TmpDir.exists() && m_NeatoPath.exists();
            }
            case 3: {
                return m_TmpDir.exists() && m_TwopiPath.exists();
            }
            case 2: {
                return m_TmpDir.exists() && m_CircoPath.exists();
            }
        }
        return false;
    }

    static String getDirStatus() {
        StringBuffer sb = new StringBuffer();
        sb.append("Temp Directory (required): ");
        sb.append(m_TmpDir.exists() ? m_TmpDir.toString() : "NOT SET");
        sb.append("\n");
        sb.append("Absolute Path to dot (required if using dot): ");
        sb.append(m_DotPath.exists() ? m_DotPath.toString() : "NOT SET");
        sb.append("\n");
        sb.append("Absolute Path to neato (required if using neato): ");
        sb.append(m_NeatoPath.exists() ? m_NeatoPath.toString() : "NOT SET");
        sb.append("\n");
        sb.append("Absolute Path to circo (required if using circo): ");
        sb.append(m_CircoPath.exists() ? m_CircoPath.toString() : "NOT SET");
        sb.append("\n");
        sb.append("Absolute Path to twopi (required if using twopi): ");
        sb.append(m_TwopiPath.exists() ? m_TwopiPath.toString() : "NOT SET");
        sb.append("\n");
        sb.append("GraphViz Font Directory (optional): ");
        sb.append(m_GraphVizFontDir.exists() ? m_GraphVizFontDir.toString() : "NOT SET");
        sb.append("\n");
        sb.append("Are you sure you want to continue?");
        return sb.toString();
    }

    void updateWindowVariables() {
        mainViewX = this.grMngr.mainView.getFrame().getX();
        mainViewY = this.grMngr.mainView.getFrame().getY();
        mainViewW = this.grMngr.mainView.getFrame().getWidth();
        mainViewH = this.grMngr.mainView.getFrame().getHeight();
    }

    public void setSDZoomEnabled(boolean b) {
        this.SD_ZOOM_ENABLED = b;
    }

    public boolean isSDZoomEnabled() {
        return this.SD_ZOOM_ENABLED;
    }

    public void setSDZoomFactor(double f) {
        this.autoZoomFactor = f - 1.0;
        this.autoUnzoomFactor = (1.0 - f) / f;
    }

    public int getSDZoomFactor() {
        return (int)this.autoZoomFactor + 1;
    }

    public void setSDZoomThreshold(double t) {
        this.SD_ZOOM_THRESHOLD = t;
    }

    public double getSDZoomThreshold() {
        return this.SD_ZOOM_THRESHOLD;
    }

    public void setMagnificationFactor(float f) {
        MAG_FACTOR = f;
    }

    public float getMagnificationFactor() {
        return MAG_FACTOR;
    }

    void rememberCommandLine(String cmdLine) {
        boolean exists = false;
        for (int i = 0; i < LAST_COMMANDS.size(); ++i) {
            if (!((String)LAST_COMMANDS.elementAt(i)).equals(cmdLine)) continue;
            if (i > 0) {
                String tmp = (String)LAST_COMMANDS.firstElement();
                LAST_COMMANDS.setElementAt(cmdLine, 0);
                LAST_COMMANDS.setElementAt(tmp, i);
            }
            return;
        }
        LAST_COMMANDS.insertElementAt(cmdLine, 0);
        if (LAST_COMMANDS.size() > COMMAND_LIMIT) {
            LAST_COMMANDS.removeElementAt(COMMAND_LIMIT);
        }
    }

    static void updateProxy(boolean use, String hostname, String port) {
        useProxy = use;
        proxyHost = hostname;
        proxyPort = port;
        if (useProxy) {
            System.getProperties().put("proxySet", "true");
            System.getProperties().put("proxyHost", proxyHost);
            System.getProperties().put("proxyPort", proxyPort);
        } else {
            System.getProperties().put("proxySet", "false");
        }
    }

    static void setPlugInJARs(String[] list) {
        pluginJARs = new File[list.length];
        for (int i = 0; i < list.length; ++i) {
            ConfigManager.pluginJARs[i] = new File(list[i]);
        }
    }

    protected void initPlugins(ZGRViewer application) {
        Vector<Plugin> plgs = new Vector<Plugin>();
        if (pluginJARs == null) {
            pluginJARs = plugInDir.listFiles();
        }
        if (pluginJARs != null && pluginJARs.length > 0) {
            URL[] urls = new URL[pluginJARs.length];
            for (int i = 0; i < pluginJARs.length; ++i) {
                try {
                    urls[i] = pluginJARs[i].toURI().toURL();
                    continue;
                }
                catch (MalformedURLException mue) {
                    System.err.println("Failed to instantiate a class loader for plug-ins: " + mue);
                }
            }
            URLClassLoader ucl = new URLClassLoader(urls);
            Plugin plgInstance = null;
            for (int i = 0; i < pluginJARs.length; ++i) {
                try {
                    JarFile jf = new JarFile(pluginJARs[i]);
                    Enumeration<JarEntry> e = jf.entries();
                    while (e.hasMoreElements()) {
                        String s = e.nextElement().getName();
                        if (!s.endsWith(".class")) continue;
                        s = Utils.replaceString(s, "/", ".");
                        s = s.substring(0, s.length() - 6);
                        try {
                            Class<?> c = ucl.loadClass(s);
                            Class<?>[] interfaces = c.getInterfaces();
                            try {
                                for (int j = 0; j < interfaces.length; ++j) {
                                    if (!interfaces[j].getName().equals("net.claribole.zgrviewer.Plugin")) continue;
                                    plgInstance = (Plugin)c.newInstance();
                                    System.out.print("Loading plugin: " + plgInstance.getName() + " " + plgInstance.getVersion() + "... ");
                                    plgInstance.setApplication(application);
                                    plgs.add(plgInstance);
                                    System.out.println("OK");
                                }
                                plgInstance = null;
                            }
                            catch (InstantiationException ie) {
                                System.err.println("Unable to create plug-in object for class " + s + ": " + ie.getMessage());
                                ie.printStackTrace();
                            }
                            catch (IllegalAccessException ie) {
                                System.err.println("Unable to create plug-in object for class " + s + ": " + ie.getMessage());
                                ie.printStackTrace();
                            }
                        }
                        catch (ClassNotFoundException ex) {
                            System.err.println("Failed to load plug-in class " + s);
                        }
                    }
                    continue;
                }
                catch (IOException ex2) {
                    System.err.println("Failed to load plug-in from JAR file " + pluginJARs[i].getAbsolutePath());
                    continue;
                }
                catch (NoClassDefFoundError ex2) {
                    System.err.println("One or more plugins might have failed to initialize because of the following error:\nNo Class Definition Found for " + ex2.getMessage());
                    continue;
                }
                catch (ClassFormatError ex2) {
                    System.err.println("One or more plugins might have failed to initialize because of the following error:\nClass Format Error for " + ex2.getMessage());
                }
            }
        }
        this.plugins = new Plugin[plgs.size()];
        for (int i = 0; i < plgs.size(); ++i) {
            this.plugins[i] = (Plugin)plgs.elementAt(i);
            try {
                this.plugins[i].loadPreferences((Hashtable)this.tmpPluginSettings.get(this.plugins[i].getName()));
                continue;
            }
            catch (NullPointerException ex) {
                // empty catch block
            }
        }
    }

    void notifyPlugins(short event) {
        if (this.plugins == null) {
            return;
        }
        for (int i = 0; i < this.plugins.length; ++i) {
            this.plugins[i].eventOccured(event);
        }
    }

    void terminatePlugins() {
        if (this.plugins == null) {
            return;
        }
        for (int i = 0; i < this.plugins.length; ++i) {
            this.plugins[i].terminate();
        }
    }

    void showPluginInfo() {
        StringBuffer info = new StringBuffer();
        for (int i = 0; i < this.plugins.length; ++i) {
            info.append(this.plugins[i].getName() + "\nVersion: " + this.plugins[i].getVersion() + "\nAuthors: " + this.plugins[i].getAuthor() + "\n");
            if (this.plugins[i].getURL() != null) {
                info.append("More information:" + this.plugins[i].getURL().toString() + "\n");
            }
            info.append("\n");
        }
        new TextViewer(info, "Installed ZGRViewer Plugins", 0, 0, 0, 400, 300, false);
    }

    public void bookmarkCurrentLocation(BookmarksList bl) {
        String bkLabel = JOptionPane.showInputDialog(bl, "Bookmark Label:", "Add bookmark", -1);
        if (bkLabel != null && bkLabel.length() > 0) {
            this.bookmarks.put(bkLabel, this.grMngr.mainCamera.getLocation());
            bl.updateList();
        }
    }

    public void saveBookmarks(BookmarksList bl) {
        final JFileChooser fc = new JFileChooser(m_LastExportDir != null ? m_LastExportDir : m_PrjDir);
        fc.setDialogTitle("Export SVG");
        int returnVal = fc.showSaveDialog(bl);
        if (returnVal == 0) {
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    ConfigManager.this.serializeBookmarks(fc.getSelectedFile());
                    return null;
                }
            };
            worker.start();
        }
    }

    void loadBookmarks(final BookmarksList bl) {
        final JFileChooser fc = new JFileChooser(m_LastDir != null ? m_LastDir : m_PrjDir);
        fc.setFileSelectionMode(0);
        fc.setDialogTitle("Find DOT File");
        int returnVal = fc.showOpenDialog(bl);
        if (returnVal == 0) {
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    ConfigManager.this.parseBookmarks(fc.getSelectedFile(), bl);
                    return null;
                }
            };
            worker.start();
        }
    }

    public void parseBookmarks(File f, BookmarksList bl) {
        try {
            FileInputStream fis = new FileInputStream(f);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
            String line = br.readLine();
            while (line != null) {
                if (line.length() > 0) {
                    String[] bk = line.split(BK_SEP);
                    this.bookmarks.put(bk[0], new Location(Double.parseDouble(bk[1]), Double.parseDouble(bk[2]), Double.parseDouble(bk[3])));
                }
                line = br.readLine();
            }
            fis.close();
            bl.updateList();
        }
        catch (Exception ex) {
            System.err.println("Error while parsing bookmarks");
            ex.printStackTrace();
        }
    }

    public void serializeBookmarks(File f) {
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"));
            for (String label : this.bookmarks.keySet()) {
                Location l = this.bookmarks.get(label);
                bw.write(label + BK_SEP + String.valueOf(l.getX()) + BK_SEP + String.valueOf(l.getY()) + BK_SEP + String.valueOf(l.getAltitude()));
                bw.newLine();
            }
            bw.flush();
        }
        catch (Exception ex) {
            System.err.println("Error while saving bookmarks");
            ex.printStackTrace();
        }
    }

    public void showBookmarks() {
        new BookmarksList(this);
    }

    static {
        if (!Utils.osIsWindows() && !Utils.osIsMacOS()) {
            OBSERVED_REGION_BORDER_COLOR = OBSERVED_REGION_CROSSHAIR_COLOR = Color.RED;
        }
        PIEMENU_FILL_COLOR = Color.BLACK;
        PIEMENU_BORDER_COLOR = Color.WHITE;
        PIEMENU_INSIDE_COLOR = Color.DARK_GRAY;
        SAVE_WINDOW_LAYOUT = false;
        DELETE_TEMP_FILES = true;
        ANTIALIASING = false;
        DYNASPOT = false;
        FORCE_SILENT = true;
        CMD_LINE_OPTS = "";
        m_PrjDir = new File("graphs");
        m_DotPath = new File("dot");
        m_NeatoPath = new File("neato");
        m_CircoPath = new File("circo");
        m_TwopiPath = new File("twopi");
        m_GraphVizFontDir = new File("");
        m_LastDir = null;
        m_LastExportDir = null;
        plugInDir = new File("plugins");
        PREFS_FILE_NAME = ".zgrviewer";
        OLD_PREFS_FILE_NAME = "zgrviewer.cfg";
        MAG_FACTOR = 0.5f;
        autoDetectBrowser = true;
        browserPath = new File("");
        browserOptions = "";
        useProxy = false;
        proxyHost = "";
        proxyPort = "80";
        COMMAND_LIMIT = 5;
        pluginJARs = null;
    }
}

