/*****************************************************************************
* Copyright (c) 2016 CEA LIST.
*
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*  Arnault Lapitre (CEA LIST) arnault.lapitre@cea.fr
*  - Initial API and implementation
*****************************************************************************/
grammar InternalFormalML;

options {
	superClass=AbstractInternalContentAssistParser;
	backtrack=true;
}

@lexer::header {
package org.eclipse.efm.formalml.xtext.ide.contentassist.antlr.internal;

// Hack: Use our own Lexer superclass by means of import. 
// Currently there is no other way to specify the superclass for the lexer.
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.Lexer;
}

@parser::header {
package org.eclipse.efm.formalml.xtext.ide.contentassist.antlr.internal;

import java.io.InputStream;
import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.AbstractInternalContentAssistParser;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.DFA;
import org.eclipse.efm.formalml.xtext.services.FormalMLGrammarAccess;

}
@parser::members {
	private FormalMLGrammarAccess grammarAccess;

	public void setGrammarAccess(FormalMLGrammarAccess grammarAccess) {
		this.grammarAccess = grammarAccess;
	}

	@Override
	protected Grammar getGrammar() {
		return grammarAccess.getGrammar();
	}

	@Override
	protected String getValueForTokenName(String tokenName) {
		return tokenName;
	}
}

// Entry rule entryRuleXlia
entryRuleXlia
:
{ before(grammarAccess.getXliaRule()); }
	 ruleXlia
{ after(grammarAccess.getXliaRule()); } 
	 EOF 
;

// Rule Xlia
ruleXlia 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getXliaAccess().getGroup()); }
		(rule__Xlia__Group__0)
		{ after(grammarAccess.getXliaAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleXliaPrologObject
entryRuleXliaPrologObject
:
{ before(grammarAccess.getXliaPrologObjectRule()); }
	 ruleXliaPrologObject
{ after(grammarAccess.getXliaPrologObjectRule()); } 
	 EOF 
;

// Rule XliaPrologObject
ruleXliaPrologObject 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getXliaPrologObjectAccess().getGroup()); }
		(rule__XliaPrologObject__Group__0)
		{ after(grammarAccess.getXliaPrologObjectAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleXliaPrologAttribute
entryRuleXliaPrologAttribute
:
{ before(grammarAccess.getXliaPrologAttributeRule()); }
	 ruleXliaPrologAttribute
{ after(grammarAccess.getXliaPrologAttributeRule()); } 
	 EOF 
;

// Rule XliaPrologAttribute
ruleXliaPrologAttribute 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getXliaPrologAttributeAccess().getGroup()); }
		(rule__XliaPrologAttribute__Group__0)
		{ after(grammarAccess.getXliaPrologAttributeAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleXliaOptionObject
entryRuleXliaOptionObject
:
{ before(grammarAccess.getXliaOptionObjectRule()); }
	 ruleXliaOptionObject
{ after(grammarAccess.getXliaOptionObjectRule()); } 
	 EOF 
;

// Rule XliaOptionObject
ruleXliaOptionObject 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getXliaOptionObjectAccess().getGroup()); }
		(rule__XliaOptionObject__Group__0)
		{ after(grammarAccess.getXliaOptionObjectAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleXliaNamedElement
entryRuleXliaNamedElement
:
{ before(grammarAccess.getXliaNamedElementRule()); }
	 ruleXliaNamedElement
{ after(grammarAccess.getXliaNamedElementRule()); } 
	 EOF 
;

// Rule XliaNamedElement
ruleXliaNamedElement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getXliaNamedElementAccess().getAlternatives()); }
		(rule__XliaNamedElement__Alternatives)
		{ after(grammarAccess.getXliaNamedElementAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleXliaObject
entryRuleXliaObject
:
{ before(grammarAccess.getXliaObjectRule()); }
	 ruleXliaObject
{ after(grammarAccess.getXliaObjectRule()); } 
	 EOF 
;

// Rule XliaObject
ruleXliaObject 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getXliaObjectAccess().getGroup()); }
		(rule__XliaObject__Group__0)
		{ after(grammarAccess.getXliaObjectAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleXliaAttribute
entryRuleXliaAttribute
:
{ before(grammarAccess.getXliaAttributeRule()); }
	 ruleXliaAttribute
{ after(grammarAccess.getXliaAttributeRule()); } 
	 EOF 
;

// Rule XliaAttribute
ruleXliaAttribute 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getXliaAttributeAccess().getGroup()); }
		(rule__XliaAttribute__Group__0)
		{ after(grammarAccess.getXliaAttributeAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleEBoolean
entryRuleEBoolean
:
{ before(grammarAccess.getEBooleanRule()); }
	 ruleEBoolean
{ after(grammarAccess.getEBooleanRule()); } 
	 EOF 
;

// Rule EBoolean
ruleEBoolean 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getEBooleanAccess().getAlternatives()); }
		(rule__EBoolean__Alternatives)
		{ after(grammarAccess.getEBooleanAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleEInt
entryRuleEInt
:
{ before(grammarAccess.getEIntRule()); }
	 ruleEInt
{ after(grammarAccess.getEIntRule()); } 
	 EOF 
;

// Rule EInt
ruleEInt 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getEIntAccess().getGroup()); }
		(rule__EInt__Group__0)
		{ after(grammarAccess.getEIntAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleEInteger
entryRuleEInteger
:
{ before(grammarAccess.getEIntegerRule()); }
	 ruleEInteger
{ after(grammarAccess.getEIntegerRule()); } 
	 EOF 
;

// Rule EInteger
ruleEInteger 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getEIntegerAccess().getGroup()); }
		(rule__EInteger__Group__0)
		{ after(grammarAccess.getEIntegerAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleEDouble
entryRuleEDouble
:
{ before(grammarAccess.getEDoubleRule()); }
	 ruleEDouble
{ after(grammarAccess.getEDoubleRule()); } 
	 EOF 
;

// Rule EDouble
ruleEDouble 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getEDoubleAccess().getGroup()); }
		(rule__EDouble__Group__0)
		{ after(grammarAccess.getEDoubleAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleECharacter
entryRuleECharacter
:
{ before(grammarAccess.getECharacterRule()); }
	 ruleECharacter
{ after(grammarAccess.getECharacterRule()); } 
	 EOF 
;

// Rule ECharacter
ruleECharacter 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getECharacterAccess().getCHARACTERTerminalRuleCall()); }
		RULE_CHARACTER
		{ after(grammarAccess.getECharacterAccess().getCHARACTERTerminalRuleCall()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleEString
entryRuleEString
:
{ before(grammarAccess.getEStringRule()); }
	 ruleEString
{ after(grammarAccess.getEStringRule()); } 
	 EOF 
;

// Rule EString
ruleEString 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getEStringAccess().getSTRINGTerminalRuleCall()); }
		RULE_STRING
		{ after(grammarAccess.getEStringAccess().getSTRINGTerminalRuleCall()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleESIdentifier
entryRuleESIdentifier
:
{ before(grammarAccess.getESIdentifierRule()); }
	 ruleESIdentifier
{ after(grammarAccess.getESIdentifierRule()); } 
	 EOF 
;

// Rule ESIdentifier
ruleESIdentifier 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getESIdentifierAccess().getXLIA_IDTerminalRuleCall()); }
		RULE_XLIA_ID
		{ after(grammarAccess.getESIdentifierAccess().getXLIA_IDTerminalRuleCall()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleESUfid
entryRuleESUfid
:
{ before(grammarAccess.getESUfidRule()); }
	 ruleESUfid
{ after(grammarAccess.getESUfidRule()); } 
	 EOF 
;

// Rule ESUfid
ruleESUfid 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getESUfidAccess().getGroup()); }
		(rule__ESUfid__Group__0)
		{ after(grammarAccess.getESUfidAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleUnrestrictedName
entryRuleUnrestrictedName
:
{ before(grammarAccess.getUnrestrictedNameRule()); }
	 ruleUnrestrictedName
{ after(grammarAccess.getUnrestrictedNameRule()); } 
	 EOF 
;

// Rule UnrestrictedName
ruleUnrestrictedName 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getUnrestrictedNameAccess().getSTRINGTerminalRuleCall()); }
		RULE_STRING
		{ after(grammarAccess.getUnrestrictedNameAccess().getSTRINGTerminalRuleCall()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleUnqualifiedName
entryRuleUnqualifiedName
:
{ before(grammarAccess.getUnqualifiedNameRule()); }
	 ruleUnqualifiedName
{ after(grammarAccess.getUnqualifiedNameRule()); } 
	 EOF 
;

// Rule UnqualifiedName
ruleUnqualifiedName 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getUnqualifiedNameAccess().getNameBindingAssignment()); }
		(rule__UnqualifiedName__NameBindingAssignment)
		{ after(grammarAccess.getUnqualifiedNameAccess().getNameBindingAssignment()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleNameBinding
entryRuleNameBinding
:
{ before(grammarAccess.getNameBindingRule()); }
	 ruleNameBinding
{ after(grammarAccess.getNameBindingRule()); } 
	 EOF 
;

// Rule NameBinding
ruleNameBinding 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getNameBindingAccess().getXLIA_IDTerminalRuleCall()); }
		RULE_XLIA_ID
		{ after(grammarAccess.getNameBindingAccess().getXLIA_IDTerminalRuleCall()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleSystem
entryRuleSystem
:
{ before(grammarAccess.getSystemRule()); }
	 ruleSystem
{ after(grammarAccess.getSystemRule()); } 
	 EOF 
;

// Rule System
ruleSystem 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getSystemAccess().getGroup()); }
		(rule__System__Group__0)
		{ after(grammarAccess.getSystemAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleAnyMachineBlock
entryRuleAnyMachineBlock
:
{ before(grammarAccess.getAnyMachineBlockRule()); }
	 ruleAnyMachineBlock
{ after(grammarAccess.getAnyMachineBlockRule()); } 
	 EOF 
;

// Rule AnyMachineBlock
ruleAnyMachineBlock 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAnyMachineBlockAccess().getAlternatives()); }
		(rule__AnyMachineBlock__Alternatives)
		{ after(grammarAccess.getAnyMachineBlockAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleInstanceMachine
entryRuleInstanceMachine
:
{ before(grammarAccess.getInstanceMachineRule()); }
	 ruleInstanceMachine
{ after(grammarAccess.getInstanceMachineRule()); } 
	 EOF 
;

// Rule InstanceMachine
ruleInstanceMachine 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getInstanceMachineAccess().getGroup()); }
		(rule__InstanceMachine__Group__0)
		{ after(grammarAccess.getInstanceMachineAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleSlotParameter
entryRuleSlotParameter
:
{ before(grammarAccess.getSlotParameterRule()); }
	 ruleSlotParameter
{ after(grammarAccess.getSlotParameterRule()); } 
	 EOF 
;

// Rule SlotParameter
ruleSlotParameter 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getSlotParameterAccess().getGroup()); }
		(rule__SlotParameter__Group__0)
		{ after(grammarAccess.getSlotParameterAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleSlotProperty
entryRuleSlotProperty
:
{ before(grammarAccess.getSlotPropertyRule()); }
	 ruleSlotProperty
{ after(grammarAccess.getSlotPropertyRule()); } 
	 EOF 
;

// Rule SlotProperty
ruleSlotProperty 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getSlotPropertyAccess().getGroup()); }
		(rule__SlotProperty__Group__0)
		{ after(grammarAccess.getSlotPropertyAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleMachineBlock
entryRuleMachineBlock
:
{ before(grammarAccess.getMachineBlockRule()); }
	 ruleMachineBlock
{ after(grammarAccess.getMachineBlockRule()); } 
	 EOF 
;

// Rule MachineBlock
ruleMachineBlock 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getMachineBlockAccess().getGroup()); }
		(rule__MachineBlock__Group__0)
		{ after(grammarAccess.getMachineBlockAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleProcedure
entryRuleProcedure
:
{ before(grammarAccess.getProcedureRule()); }
	 ruleProcedure
{ after(grammarAccess.getProcedureRule()); } 
	 EOF 
;

// Rule Procedure
ruleProcedure 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getProcedureAccess().getGroup()); }
		(rule__Procedure__Group__0)
		{ after(grammarAccess.getProcedureAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleProcedureExecution
entryRuleProcedureExecution
:
{ before(grammarAccess.getProcedureExecutionRule()); }
	 ruleProcedureExecution
{ after(grammarAccess.getProcedureExecutionRule()); } 
	 EOF 
;

// Rule ProcedureExecution
ruleProcedureExecution 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getProcedureExecutionAccess().getGroup()); }
		(rule__ProcedureExecution__Group__0)
		{ after(grammarAccess.getProcedureExecutionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBehavior
entryRuleBehavior
:
{ before(grammarAccess.getBehaviorRule()); }
	 ruleBehavior
{ after(grammarAccess.getBehaviorRule()); } 
	 EOF 
;

// Rule Behavior
ruleBehavior 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBehaviorAccess().getStatemachineParserRuleCall()); }
		ruleStatemachine
		{ after(grammarAccess.getBehaviorAccess().getStatemachineParserRuleCall()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleMoeBehavior
entryRuleMoeBehavior
:
{ before(grammarAccess.getMoeBehaviorRule()); }
	 ruleMoeBehavior
{ after(grammarAccess.getMoeBehaviorRule()); } 
	 EOF 
;

// Rule MoeBehavior
ruleMoeBehavior 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getMoeBehaviorAccess().getGroup()); }
		(rule__MoeBehavior__Group__0)
		{ after(grammarAccess.getMoeBehaviorAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleStatemachine
entryRuleStatemachine
:
{ before(grammarAccess.getStatemachineRule()); }
	 ruleStatemachine
{ after(grammarAccess.getStatemachineRule()); } 
	 EOF 
;

// Rule Statemachine
ruleStatemachine 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getStatemachineAccess().getGroup()); }
		(rule__Statemachine__Group__0)
		{ after(grammarAccess.getStatemachineAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleStatemachineRegion
entryRuleStatemachineRegion
:
{ before(grammarAccess.getStatemachineRegionRule()); }
	 ruleStatemachineRegion
{ after(grammarAccess.getStatemachineRegionRule()); } 
	 EOF 
;

// Rule StatemachineRegion
ruleStatemachineRegion 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getStatemachineRegionAccess().getGroup()); }
		(rule__StatemachineRegion__Group__0)
		{ after(grammarAccess.getStatemachineRegionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleStatemachineRegionLite
entryRuleStatemachineRegionLite
:
{ before(grammarAccess.getStatemachineRegionLiteRule()); }
	 ruleStatemachineRegionLite
{ after(grammarAccess.getStatemachineRegionLiteRule()); } 
	 EOF 
;

// Rule StatemachineRegionLite
ruleStatemachineRegionLite 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		(
			{ before(grammarAccess.getStatemachineRegionLiteAccess().getAlternatives()); }
			(rule__StatemachineRegionLite__Alternatives)
			{ after(grammarAccess.getStatemachineRegionLiteAccess().getAlternatives()); }
		)
		(
			{ before(grammarAccess.getStatemachineRegionLiteAccess().getAlternatives()); }
			(rule__StatemachineRegionLite__Alternatives)*
			{ after(grammarAccess.getStatemachineRegionLiteAccess().getAlternatives()); }
		)
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleState
entryRuleState
:
{ before(grammarAccess.getStateRule()); }
	 ruleState
{ after(grammarAccess.getStateRule()); } 
	 EOF 
;

// Rule State
ruleState 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getStateAccess().getAlternatives()); }
		(rule__State__Alternatives)
		{ after(grammarAccess.getStateAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleCompositeState
entryRuleCompositeState
:
{ before(grammarAccess.getCompositeStateRule()); }
	 ruleCompositeState
{ after(grammarAccess.getCompositeStateRule()); } 
	 EOF 
;

// Rule CompositeState
ruleCompositeState 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getCompositeStateAccess().getGroup()); }
		(rule__CompositeState__Group__0)
		{ after(grammarAccess.getCompositeStateAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulemoeCompositeStateRoutines
entryRulemoeCompositeStateRoutines
:
{ before(grammarAccess.getMoeCompositeStateRoutinesRule()); }
	 rulemoeCompositeStateRoutines
{ after(grammarAccess.getMoeCompositeStateRoutinesRule()); } 
	 EOF 
;

// Rule moeCompositeStateRoutines
rulemoeCompositeStateRoutines 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getMoeCompositeStateRoutinesAccess().getGroup()); }
		(rule__MoeCompositeStateRoutines__Group__0)
		{ after(grammarAccess.getMoeCompositeStateRoutinesAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleSimpleState
entryRuleSimpleState
:
{ before(grammarAccess.getSimpleStateRule()); }
	 ruleSimpleState
{ after(grammarAccess.getSimpleStateRule()); } 
	 EOF 
;

// Rule SimpleState
ruleSimpleState 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getSimpleStateAccess().getGroup()); }
		(rule__SimpleState__Group__0)
		{ after(grammarAccess.getSimpleStateAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulemoeSimpleStateRoutines
entryRulemoeSimpleStateRoutines
:
{ before(grammarAccess.getMoeSimpleStateRoutinesRule()); }
	 rulemoeSimpleStateRoutines
{ after(grammarAccess.getMoeSimpleStateRoutinesRule()); } 
	 EOF 
;

// Rule moeSimpleStateRoutines
rulemoeSimpleStateRoutines 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getMoeSimpleStateRoutinesAccess().getGroup()); }
		(rule__MoeSimpleStateRoutines__Group__0)
		{ after(grammarAccess.getMoeSimpleStateRoutinesAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleStartState
entryRuleStartState
:
{ before(grammarAccess.getStartStateRule()); }
	 ruleStartState
{ after(grammarAccess.getStartStateRule()); } 
	 EOF 
;

// Rule StartState
ruleStartState 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getStartStateAccess().getGroup()); }
		(rule__StartState__Group__0)
		{ after(grammarAccess.getStartStateAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulemoeStartStateRoutines
entryRulemoeStartStateRoutines
:
{ before(grammarAccess.getMoeStartStateRoutinesRule()); }
	 rulemoeStartStateRoutines
{ after(grammarAccess.getMoeStartStateRoutinesRule()); } 
	 EOF 
;

// Rule moeStartStateRoutines
rulemoeStartStateRoutines 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getMoeStartStateRoutinesAccess().getGroup()); }
		(rule__MoeStartStateRoutines__Group__0)
		{ after(grammarAccess.getMoeStartStateRoutinesAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleFinalState
entryRuleFinalState
:
{ before(grammarAccess.getFinalStateRule()); }
	 ruleFinalState
{ after(grammarAccess.getFinalStateRule()); } 
	 EOF 
;

// Rule FinalState
ruleFinalState 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFinalStateAccess().getGroup()); }
		(rule__FinalState__Group__0)
		{ after(grammarAccess.getFinalStateAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulemoeFinalStateRoutines
entryRulemoeFinalStateRoutines
:
{ before(grammarAccess.getMoeFinalStateRoutinesRule()); }
	 rulemoeFinalStateRoutines
{ after(grammarAccess.getMoeFinalStateRoutinesRule()); } 
	 EOF 
;

// Rule moeFinalStateRoutines
rulemoeFinalStateRoutines 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getMoeFinalStateRoutinesAccess().getGroup()); }
		(rule__MoeFinalStateRoutines__Group__0)
		{ after(grammarAccess.getMoeFinalStateRoutinesAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePseudostate
entryRulePseudostate
:
{ before(grammarAccess.getPseudostateRule()); }
	 rulePseudostate
{ after(grammarAccess.getPseudostateRule()); } 
	 EOF 
;

// Rule Pseudostate
rulePseudostate 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPseudostateAccess().getAlternatives()); }
		(rule__Pseudostate__Alternatives)
		{ after(grammarAccess.getPseudostateAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleOtherPseudostate
entryRuleOtherPseudostate
:
{ before(grammarAccess.getOtherPseudostateRule()); }
	 ruleOtherPseudostate
{ after(grammarAccess.getOtherPseudostateRule()); } 
	 EOF 
;

// Rule OtherPseudostate
ruleOtherPseudostate 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getOtherPseudostateAccess().getGroup()); }
		(rule__OtherPseudostate__Group__0)
		{ after(grammarAccess.getOtherPseudostateAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePseudostateInitial
entryRulePseudostateInitial
:
{ before(grammarAccess.getPseudostateInitialRule()); }
	 rulePseudostateInitial
{ after(grammarAccess.getPseudostateInitialRule()); } 
	 EOF 
;

// Rule PseudostateInitial
rulePseudostateInitial 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPseudostateInitialAccess().getGroup()); }
		(rule__PseudostateInitial__Group__0)
		{ after(grammarAccess.getPseudostateInitialAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleEndingPseudostate
entryRuleEndingPseudostate
:
{ before(grammarAccess.getEndingPseudostateRule()); }
	 ruleEndingPseudostate
{ after(grammarAccess.getEndingPseudostateRule()); } 
	 EOF 
;

// Rule EndingPseudostate
ruleEndingPseudostate 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getEndingPseudostateAccess().getGroup()); }
		(rule__EndingPseudostate__Group__0)
		{ after(grammarAccess.getEndingPseudostateAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleModelOfExecution
entryRuleModelOfExecution
:
{ before(grammarAccess.getModelOfExecutionRule()); }
	 ruleModelOfExecution
{ after(grammarAccess.getModelOfExecutionRule()); } 
	 EOF 
;

// Rule ModelOfExecution
ruleModelOfExecution 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getModelOfExecutionAccess().getGroup()); }
		(rule__ModelOfExecution__Group__0)
		{ after(grammarAccess.getModelOfExecutionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulemoeRoutine
entryRulemoeRoutine
:
{ before(grammarAccess.getMoeRoutineRule()); }
	 rulemoeRoutine
{ after(grammarAccess.getMoeRoutineRule()); } 
	 EOF 
;

// Rule moeRoutine
rulemoeRoutine 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getMoeRoutineAccess().getGroup()); }
		(rule__MoeRoutine__Group__0)
		{ after(grammarAccess.getMoeRoutineAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleRoutine
entryRuleRoutine
:
{ before(grammarAccess.getRoutineRule()); }
	 ruleRoutine
{ after(grammarAccess.getRoutineRule()); } 
	 EOF 
;

// Rule Routine
ruleRoutine 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getRoutineAccess().getGroup()); }
		(rule__Routine__Group__0)
		{ after(grammarAccess.getRoutineAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleModelOfInteraction
entryRuleModelOfInteraction
:
{ before(grammarAccess.getModelOfInteractionRule()); }
	 ruleModelOfInteraction
{ after(grammarAccess.getModelOfInteractionRule()); } 
	 EOF 
;

// Rule ModelOfInteraction
ruleModelOfInteraction 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getModelOfInteractionAccess().getGroup()); }
		(rule__ModelOfInteraction__Group__0)
		{ after(grammarAccess.getModelOfInteractionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleRoute
entryRuleRoute
:
{ before(grammarAccess.getRouteRule()); }
	 ruleRoute
{ after(grammarAccess.getRouteRule()); } 
	 EOF 
;

// Rule Route
ruleRoute 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getRouteAccess().getGroup()); }
		(rule__Route__Group__0)
		{ after(grammarAccess.getRouteAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleComRouteProtocol
entryRuleComRouteProtocol
:
{ before(grammarAccess.getComRouteProtocolRule()); }
	 ruleComRouteProtocol
{ after(grammarAccess.getComRouteProtocolRule()); } 
	 EOF 
;

// Rule ComRouteProtocol
ruleComRouteProtocol 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getComRouteProtocolAccess().getAlternatives()); }
		(rule__ComRouteProtocol__Alternatives)
		{ after(grammarAccess.getComRouteProtocolAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleConnection
entryRuleConnection
:
{ before(grammarAccess.getConnectionRule()); }
	 ruleConnection
{ after(grammarAccess.getConnectionRule()); } 
	 EOF 
;

// Rule Connection
ruleConnection 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getConnectionAccess().getGroup()); }
		(rule__Connection__Group__0)
		{ after(grammarAccess.getConnectionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleComProtocol
entryRuleComProtocol
:
{ before(grammarAccess.getComProtocolRule()); }
	 ruleComProtocol
{ after(grammarAccess.getComProtocolRule()); } 
	 EOF 
;

// Rule ComProtocol
ruleComProtocol 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getComProtocolAccess().getAlternatives()); }
		(rule__ComProtocol__Alternatives)
		{ after(grammarAccess.getComProtocolAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleComPoint
entryRuleComPoint
:
{ before(grammarAccess.getComPointRule()); }
	 ruleComPoint
{ after(grammarAccess.getComPointRule()); } 
	 EOF 
;

// Rule ComPoint
ruleComPoint 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getComPointAccess().getGroup()); }
		(rule__ComPoint__Group__0)
		{ after(grammarAccess.getComPointAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleComPointProtocol
entryRuleComPointProtocol
:
{ before(grammarAccess.getComPointProtocolRule()); }
	 ruleComPointProtocol
{ after(grammarAccess.getComPointProtocolRule()); } 
	 EOF 
;

// Rule ComPointProtocol
ruleComPointProtocol 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getComPointProtocolAccess().getAlternatives()); }
		(rule__ComPointProtocol__Alternatives)
		{ after(grammarAccess.getComPointProtocolAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleComBuffer
entryRuleComBuffer
:
{ before(grammarAccess.getComBufferRule()); }
	 ruleComBuffer
{ after(grammarAccess.getComBufferRule()); } 
	 EOF 
;

// Rule ComBuffer
ruleComBuffer 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getComBufferAccess().getGroup()); }
		(rule__ComBuffer__Group__0)
		{ after(grammarAccess.getComBufferAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleComElement
entryRuleComElement
:
{ before(grammarAccess.getComElementRule()); }
	 ruleComElement
{ after(grammarAccess.getComElementRule()); } 
	 EOF 
;

// Rule ComElement
ruleComElement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getComElementAccess().getGroup()); }
		(rule__ComElement__Group__0)
		{ after(grammarAccess.getComElementAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLiteralPureReferenceMachine
entryRuleLiteralPureReferenceMachine
:
{ before(grammarAccess.getLiteralPureReferenceMachineRule()); }
	 ruleLiteralPureReferenceMachine
{ after(grammarAccess.getLiteralPureReferenceMachineRule()); } 
	 EOF 
;

// Rule LiteralPureReferenceMachine
ruleLiteralPureReferenceMachine 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLiteralPureReferenceMachineAccess().getAlternatives()); }
		(rule__LiteralPureReferenceMachine__Alternatives)
		{ after(grammarAccess.getLiteralPureReferenceMachineAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTypeDefinition
entryRuleTypeDefinition
:
{ before(grammarAccess.getTypeDefinitionRule()); }
	 ruleTypeDefinition
{ after(grammarAccess.getTypeDefinitionRule()); } 
	 EOF 
;

// Rule TypeDefinition
ruleTypeDefinition 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTypeDefinitionAccess().getAlternatives()); }
		(rule__TypeDefinition__Alternatives)
		{ after(grammarAccess.getTypeDefinitionAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleDataTypeMultiplicity
entryRuleDataTypeMultiplicity
:
{ before(grammarAccess.getDataTypeMultiplicityRule()); }
	 ruleDataTypeMultiplicity
{ after(grammarAccess.getDataTypeMultiplicityRule()); } 
	 EOF 
;

// Rule DataTypeMultiplicity
ruleDataTypeMultiplicity 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getDataTypeMultiplicityAccess().getAlternatives()); }
		(rule__DataTypeMultiplicity__Alternatives)
		{ after(grammarAccess.getDataTypeMultiplicityAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleDataTypeReference
entryRuleDataTypeReference
:
{ before(grammarAccess.getDataTypeReferenceRule()); }
	 ruleDataTypeReference
{ after(grammarAccess.getDataTypeReferenceRule()); } 
	 EOF 
;

// Rule DataTypeReference
ruleDataTypeReference 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getDataTypeReferenceAccess().getAlternatives()); }
		(rule__DataTypeReference__Alternatives)
		{ after(grammarAccess.getDataTypeReferenceAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleOtherDataTypeDefinition
entryRuleOtherDataTypeDefinition
:
{ before(grammarAccess.getOtherDataTypeDefinitionRule()); }
	 ruleOtherDataTypeDefinition
{ after(grammarAccess.getOtherDataTypeDefinitionRule()); } 
	 EOF 
;

// Rule OtherDataTypeDefinition
ruleOtherDataTypeDefinition 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getOtherDataTypeDefinitionAccess().getGroup()); }
		(rule__OtherDataTypeDefinition__Group__0)
		{ after(grammarAccess.getOtherDataTypeDefinitionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleOtherDataTypeDefinitionImpl
entryRuleOtherDataTypeDefinitionImpl
:
{ before(grammarAccess.getOtherDataTypeDefinitionImplRule()); }
	 ruleOtherDataTypeDefinitionImpl
{ after(grammarAccess.getOtherDataTypeDefinitionImplRule()); } 
	 EOF 
;

// Rule OtherDataTypeDefinitionImpl
ruleOtherDataTypeDefinitionImpl 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getOtherDataTypeDefinitionImplAccess().getGroup()); }
		(rule__OtherDataTypeDefinitionImpl__Group__0)
		{ after(grammarAccess.getOtherDataTypeDefinitionImplAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleDataType
entryRuleDataType
:
{ before(grammarAccess.getDataTypeRule()); }
	 ruleDataType
{ after(grammarAccess.getDataTypeRule()); } 
	 EOF 
;

// Rule DataType
ruleDataType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getDataTypeAccess().getAlternatives()); }
		(rule__DataType__Alternatives)
		{ after(grammarAccess.getDataTypeAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleSimpleDataType
entryRuleSimpleDataType
:
{ before(grammarAccess.getSimpleDataTypeRule()); }
	 ruleSimpleDataType
{ after(grammarAccess.getSimpleDataTypeRule()); } 
	 EOF 
;

// Rule SimpleDataType
ruleSimpleDataType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getSimpleDataTypeAccess().getAlternatives()); }
		(rule__SimpleDataType__Alternatives)
		{ after(grammarAccess.getSimpleDataTypeAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleStructuredDataType
entryRuleStructuredDataType
:
{ before(grammarAccess.getStructuredDataTypeRule()); }
	 ruleStructuredDataType
{ after(grammarAccess.getStructuredDataTypeRule()); } 
	 EOF 
;

// Rule StructuredDataType
ruleStructuredDataType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getStructuredDataTypeAccess().getAlternatives()); }
		(rule__StructuredDataType__Alternatives)
		{ after(grammarAccess.getStructuredDataTypeAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePrimitiveType
entryRulePrimitiveType
:
{ before(grammarAccess.getPrimitiveTypeRule()); }
	 rulePrimitiveType
{ after(grammarAccess.getPrimitiveTypeRule()); } 
	 EOF 
;

// Rule PrimitiveType
rulePrimitiveType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPrimitiveTypeAccess().getAlternatives()); }
		(rule__PrimitiveType__Alternatives)
		{ after(grammarAccess.getPrimitiveTypeAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePrimitiveNumberType
entryRulePrimitiveNumberType
:
{ before(grammarAccess.getPrimitiveNumberTypeRule()); }
	 rulePrimitiveNumberType
{ after(grammarAccess.getPrimitiveNumberTypeRule()); } 
	 EOF 
;

// Rule PrimitiveNumberType
rulePrimitiveNumberType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPrimitiveNumberTypeAccess().getAlternatives()); }
		(rule__PrimitiveNumberType__Alternatives)
		{ after(grammarAccess.getPrimitiveNumberTypeAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePrimitiveIntegerType
entryRulePrimitiveIntegerType
:
{ before(grammarAccess.getPrimitiveIntegerTypeRule()); }
	 rulePrimitiveIntegerType
{ after(grammarAccess.getPrimitiveIntegerTypeRule()); } 
	 EOF 
;

// Rule PrimitiveIntegerType
rulePrimitiveIntegerType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPrimitiveIntegerTypeAccess().getGroup()); }
		(rule__PrimitiveIntegerType__Group__0)
		{ after(grammarAccess.getPrimitiveIntegerTypeAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePrimitiveRationalType
entryRulePrimitiveRationalType
:
{ before(grammarAccess.getPrimitiveRationalTypeRule()); }
	 rulePrimitiveRationalType
{ after(grammarAccess.getPrimitiveRationalTypeRule()); } 
	 EOF 
;

// Rule PrimitiveRationalType
rulePrimitiveRationalType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPrimitiveRationalTypeAccess().getGroup()); }
		(rule__PrimitiveRationalType__Group__0)
		{ after(grammarAccess.getPrimitiveRationalTypeAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePrimitiveFloatType
entryRulePrimitiveFloatType
:
{ before(grammarAccess.getPrimitiveFloatTypeRule()); }
	 rulePrimitiveFloatType
{ after(grammarAccess.getPrimitiveFloatTypeRule()); } 
	 EOF 
;

// Rule PrimitiveFloatType
rulePrimitiveFloatType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPrimitiveFloatTypeAccess().getGroup()); }
		(rule__PrimitiveFloatType__Group__0)
		{ after(grammarAccess.getPrimitiveFloatTypeAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePrimitiveRealType
entryRulePrimitiveRealType
:
{ before(grammarAccess.getPrimitiveRealTypeRule()); }
	 rulePrimitiveRealType
{ after(grammarAccess.getPrimitiveRealTypeRule()); } 
	 EOF 
;

// Rule PrimitiveRealType
rulePrimitiveRealType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPrimitiveRealTypeAccess().getGroup()); }
		(rule__PrimitiveRealType__Group__0)
		{ after(grammarAccess.getPrimitiveRealTypeAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePrimitiveTimeType
entryRulePrimitiveTimeType
:
{ before(grammarAccess.getPrimitiveTimeTypeRule()); }
	 rulePrimitiveTimeType
{ after(grammarAccess.getPrimitiveTimeTypeRule()); } 
	 EOF 
;

// Rule PrimitiveTimeType
rulePrimitiveTimeType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPrimitiveTimeTypeAccess().getAlternatives()); }
		(rule__PrimitiveTimeType__Alternatives)
		{ after(grammarAccess.getPrimitiveTimeTypeAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePrimitiveTimeNumberType
entryRulePrimitiveTimeNumberType
:
{ before(grammarAccess.getPrimitiveTimeNumberTypeRule()); }
	 rulePrimitiveTimeNumberType
{ after(grammarAccess.getPrimitiveTimeNumberTypeRule()); } 
	 EOF 
;

// Rule PrimitiveTimeNumberType
rulePrimitiveTimeNumberType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPrimitiveTimeNumberTypeAccess().getAlternatives()); }
		(rule__PrimitiveTimeNumberType__Alternatives)
		{ after(grammarAccess.getPrimitiveTimeNumberTypeAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleOtherPrimitiveType
entryRuleOtherPrimitiveType
:
{ before(grammarAccess.getOtherPrimitiveTypeRule()); }
	 ruleOtherPrimitiveType
{ after(grammarAccess.getOtherPrimitiveTypeRule()); } 
	 EOF 
;

// Rule OtherPrimitiveType
ruleOtherPrimitiveType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getOtherPrimitiveTypeAccess().getAlternatives()); }
		(rule__OtherPrimitiveType__Alternatives)
		{ after(grammarAccess.getOtherPrimitiveTypeAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePrimitiveBooleanType
entryRulePrimitiveBooleanType
:
{ before(grammarAccess.getPrimitiveBooleanTypeRule()); }
	 rulePrimitiveBooleanType
{ after(grammarAccess.getPrimitiveBooleanTypeRule()); } 
	 EOF 
;

// Rule PrimitiveBooleanType
rulePrimitiveBooleanType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPrimitiveBooleanTypeAccess().getGroup()); }
		(rule__PrimitiveBooleanType__Group__0)
		{ after(grammarAccess.getPrimitiveBooleanTypeAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePrimitiveCharacterType
entryRulePrimitiveCharacterType
:
{ before(grammarAccess.getPrimitiveCharacterTypeRule()); }
	 rulePrimitiveCharacterType
{ after(grammarAccess.getPrimitiveCharacterTypeRule()); } 
	 EOF 
;

// Rule PrimitiveCharacterType
rulePrimitiveCharacterType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPrimitiveCharacterTypeAccess().getGroup()); }
		(rule__PrimitiveCharacterType__Group__0)
		{ after(grammarAccess.getPrimitiveCharacterTypeAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePrimitiveStringType
entryRulePrimitiveStringType
:
{ before(grammarAccess.getPrimitiveStringTypeRule()); }
	 rulePrimitiveStringType
{ after(grammarAccess.getPrimitiveStringTypeRule()); } 
	 EOF 
;

// Rule PrimitiveStringType
rulePrimitiveStringType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPrimitiveStringTypeAccess().getGroup()); }
		(rule__PrimitiveStringType__Group__0)
		{ after(grammarAccess.getPrimitiveStringTypeAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePrimitiveInstanceType
entryRulePrimitiveInstanceType
:
{ before(grammarAccess.getPrimitiveInstanceTypeRule()); }
	 rulePrimitiveInstanceType
{ after(grammarAccess.getPrimitiveInstanceTypeRule()); } 
	 EOF 
;

// Rule PrimitiveInstanceType
rulePrimitiveInstanceType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPrimitiveInstanceTypeAccess().getGroup()); }
		(rule__PrimitiveInstanceType__Group__0)
		{ after(grammarAccess.getPrimitiveInstanceTypeAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleIntervalType
entryRuleIntervalType
:
{ before(grammarAccess.getIntervalTypeRule()); }
	 ruleIntervalType
{ after(grammarAccess.getIntervalTypeRule()); } 
	 EOF 
;

// Rule IntervalType
ruleIntervalType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIntervalTypeAccess().getGroup()); }
		(rule__IntervalType__Group__0)
		{ after(grammarAccess.getIntervalTypeAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleIntervalTypeDefinition
entryRuleIntervalTypeDefinition
:
{ before(grammarAccess.getIntervalTypeDefinitionRule()); }
	 ruleIntervalTypeDefinition
{ after(grammarAccess.getIntervalTypeDefinitionRule()); } 
	 EOF 
;

// Rule IntervalTypeDefinition
ruleIntervalTypeDefinition 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIntervalTypeDefinitionAccess().getGroup()); }
		(rule__IntervalTypeDefinition__Group__0)
		{ after(grammarAccess.getIntervalTypeDefinitionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleIntervalTypeDefinitionImpl
entryRuleIntervalTypeDefinitionImpl
:
{ before(grammarAccess.getIntervalTypeDefinitionImplRule()); }
	 ruleIntervalTypeDefinitionImpl
{ after(grammarAccess.getIntervalTypeDefinitionImplRule()); } 
	 EOF 
;

// Rule IntervalTypeDefinitionImpl
ruleIntervalTypeDefinitionImpl 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIntervalTypeDefinitionImplAccess().getGroup()); }
		(rule__IntervalTypeDefinitionImpl__Group__0)
		{ after(grammarAccess.getIntervalTypeDefinitionImplAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleCollectionType
entryRuleCollectionType
:
{ before(grammarAccess.getCollectionTypeRule()); }
	 ruleCollectionType
{ after(grammarAccess.getCollectionTypeRule()); } 
	 EOF 
;

// Rule CollectionType
ruleCollectionType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getCollectionTypeAccess().getGroup()); }
		(rule__CollectionType__Group__0)
		{ after(grammarAccess.getCollectionTypeAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleCollectionTypeDefinition
entryRuleCollectionTypeDefinition
:
{ before(grammarAccess.getCollectionTypeDefinitionRule()); }
	 ruleCollectionTypeDefinition
{ after(grammarAccess.getCollectionTypeDefinitionRule()); } 
	 EOF 
;

// Rule CollectionTypeDefinition
ruleCollectionTypeDefinition 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getCollectionTypeDefinitionAccess().getGroup()); }
		(rule__CollectionTypeDefinition__Group__0)
		{ after(grammarAccess.getCollectionTypeDefinitionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleCollectionTypeDefinitionImpl
entryRuleCollectionTypeDefinitionImpl
:
{ before(grammarAccess.getCollectionTypeDefinitionImplRule()); }
	 ruleCollectionTypeDefinitionImpl
{ after(grammarAccess.getCollectionTypeDefinitionImplRule()); } 
	 EOF 
;

// Rule CollectionTypeDefinitionImpl
ruleCollectionTypeDefinitionImpl 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getCollectionTypeDefinitionImplAccess().getGroup()); }
		(rule__CollectionTypeDefinitionImpl__Group__0)
		{ after(grammarAccess.getCollectionTypeDefinitionImplAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleEnumerationType
entryRuleEnumerationType
:
{ before(grammarAccess.getEnumerationTypeRule()); }
	 ruleEnumerationType
{ after(grammarAccess.getEnumerationTypeRule()); } 
	 EOF 
;

// Rule EnumerationType
ruleEnumerationType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getEnumerationTypeAccess().getGroup()); }
		(rule__EnumerationType__Group__0)
		{ after(grammarAccess.getEnumerationTypeAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleEnumerationTypeDefinition
entryRuleEnumerationTypeDefinition
:
{ before(grammarAccess.getEnumerationTypeDefinitionRule()); }
	 ruleEnumerationTypeDefinition
{ after(grammarAccess.getEnumerationTypeDefinitionRule()); } 
	 EOF 
;

// Rule EnumerationTypeDefinition
ruleEnumerationTypeDefinition 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getEnumerationTypeDefinitionAccess().getGroup()); }
		(rule__EnumerationTypeDefinition__Group__0)
		{ after(grammarAccess.getEnumerationTypeDefinitionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleEnumerationTypeDefinitionImpl
entryRuleEnumerationTypeDefinitionImpl
:
{ before(grammarAccess.getEnumerationTypeDefinitionImplRule()); }
	 ruleEnumerationTypeDefinitionImpl
{ after(grammarAccess.getEnumerationTypeDefinitionImplRule()); } 
	 EOF 
;

// Rule EnumerationTypeDefinitionImpl
ruleEnumerationTypeDefinitionImpl 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getEnumerationTypeDefinitionImplAccess().getGroup()); }
		(rule__EnumerationTypeDefinitionImpl__Group__0)
		{ after(grammarAccess.getEnumerationTypeDefinitionImplAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleEnumerationLiteral
entryRuleEnumerationLiteral
:
{ before(grammarAccess.getEnumerationLiteralRule()); }
	 ruleEnumerationLiteral
{ after(grammarAccess.getEnumerationLiteralRule()); } 
	 EOF 
;

// Rule EnumerationLiteral
ruleEnumerationLiteral 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getEnumerationLiteralAccess().getGroup()); }
		(rule__EnumerationLiteral__Group__0)
		{ after(grammarAccess.getEnumerationLiteralAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleStructureType
entryRuleStructureType
:
{ before(grammarAccess.getStructureTypeRule()); }
	 ruleStructureType
{ after(grammarAccess.getStructureTypeRule()); } 
	 EOF 
;

// Rule StructureType
ruleStructureType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getStructureTypeAccess().getGroup()); }
		(rule__StructureType__Group__0)
		{ after(grammarAccess.getStructureTypeAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleStructureTypeDefinition
entryRuleStructureTypeDefinition
:
{ before(grammarAccess.getStructureTypeDefinitionRule()); }
	 ruleStructureTypeDefinition
{ after(grammarAccess.getStructureTypeDefinitionRule()); } 
	 EOF 
;

// Rule StructureTypeDefinition
ruleStructureTypeDefinition 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getStructureTypeDefinitionAccess().getGroup()); }
		(rule__StructureTypeDefinition__Group__0)
		{ after(grammarAccess.getStructureTypeDefinitionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleStructureTypeDefinitionImpl
entryRuleStructureTypeDefinitionImpl
:
{ before(grammarAccess.getStructureTypeDefinitionImplRule()); }
	 ruleStructureTypeDefinitionImpl
{ after(grammarAccess.getStructureTypeDefinitionImplRule()); } 
	 EOF 
;

// Rule StructureTypeDefinitionImpl
ruleStructureTypeDefinitionImpl 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getStructureTypeDefinitionImplAccess().getGroup()); }
		(rule__StructureTypeDefinitionImpl__Group__0)
		{ after(grammarAccess.getStructureTypeDefinitionImplAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleUnionType
entryRuleUnionType
:
{ before(grammarAccess.getUnionTypeRule()); }
	 ruleUnionType
{ after(grammarAccess.getUnionTypeRule()); } 
	 EOF 
;

// Rule UnionType
ruleUnionType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getUnionTypeAccess().getGroup()); }
		(rule__UnionType__Group__0)
		{ after(grammarAccess.getUnionTypeAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleUnionTypeDefinition
entryRuleUnionTypeDefinition
:
{ before(grammarAccess.getUnionTypeDefinitionRule()); }
	 ruleUnionTypeDefinition
{ after(grammarAccess.getUnionTypeDefinitionRule()); } 
	 EOF 
;

// Rule UnionTypeDefinition
ruleUnionTypeDefinition 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getUnionTypeDefinitionAccess().getGroup()); }
		(rule__UnionTypeDefinition__Group__0)
		{ after(grammarAccess.getUnionTypeDefinitionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleUnionTypeDefinitionImpl
entryRuleUnionTypeDefinitionImpl
:
{ before(grammarAccess.getUnionTypeDefinitionImplRule()); }
	 ruleUnionTypeDefinitionImpl
{ after(grammarAccess.getUnionTypeDefinitionImplRule()); } 
	 EOF 
;

// Rule UnionTypeDefinitionImpl
ruleUnionTypeDefinitionImpl 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getUnionTypeDefinitionImplAccess().getGroup()); }
		(rule__UnionTypeDefinitionImpl__Group__0)
		{ after(grammarAccess.getUnionTypeDefinitionImplAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleChoiceType
entryRuleChoiceType
:
{ before(grammarAccess.getChoiceTypeRule()); }
	 ruleChoiceType
{ after(grammarAccess.getChoiceTypeRule()); } 
	 EOF 
;

// Rule ChoiceType
ruleChoiceType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getChoiceTypeAccess().getGroup()); }
		(rule__ChoiceType__Group__0)
		{ after(grammarAccess.getChoiceTypeAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleChoiceTypeDefinition
entryRuleChoiceTypeDefinition
:
{ before(grammarAccess.getChoiceTypeDefinitionRule()); }
	 ruleChoiceTypeDefinition
{ after(grammarAccess.getChoiceTypeDefinitionRule()); } 
	 EOF 
;

// Rule ChoiceTypeDefinition
ruleChoiceTypeDefinition 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getChoiceTypeDefinitionAccess().getGroup()); }
		(rule__ChoiceTypeDefinition__Group__0)
		{ after(grammarAccess.getChoiceTypeDefinitionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleChoiceTypeDefinitionImpl
entryRuleChoiceTypeDefinitionImpl
:
{ before(grammarAccess.getChoiceTypeDefinitionImplRule()); }
	 ruleChoiceTypeDefinitionImpl
{ after(grammarAccess.getChoiceTypeDefinitionImplRule()); } 
	 EOF 
;

// Rule ChoiceTypeDefinitionImpl
ruleChoiceTypeDefinitionImpl 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getChoiceTypeDefinitionImplAccess().getGroup()); }
		(rule__ChoiceTypeDefinitionImpl__Group__0)
		{ after(grammarAccess.getChoiceTypeDefinitionImplAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleModifier
entryRuleModifier
:
{ before(grammarAccess.getModifierRule()); }
	 ruleModifier
{ after(grammarAccess.getModifierRule()); } 
	 EOF 
;

// Rule Modifier
ruleModifier 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getModifierAccess().getGroup()); }
		(rule__Modifier__Group__0)
		{ after(grammarAccess.getModifierAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleVariable
entryRuleVariable
:
{ before(grammarAccess.getVariableRule()); }
	 ruleVariable
{ after(grammarAccess.getVariableRule()); } 
	 EOF 
;

// Rule Variable
ruleVariable 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableAccess().getGroup()); }
		(rule__Variable__Group__0)
		{ after(grammarAccess.getVariableAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleOnWriteRoutine
entryRuleOnWriteRoutine
:
{ before(grammarAccess.getOnWriteRoutineRule()); }
	 ruleOnWriteRoutine
{ after(grammarAccess.getOnWriteRoutineRule()); } 
	 EOF 
;

// Rule OnWriteRoutine
ruleOnWriteRoutine 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getOnWriteRoutineAccess().getGroup()); }
		(rule__OnWriteRoutine__Group__0)
		{ after(grammarAccess.getOnWriteRoutineAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleVariableRoutineParameter
entryRuleVariableRoutineParameter
:
{ before(grammarAccess.getVariableRoutineParameterRule()); }
	 ruleVariableRoutineParameter
{ after(grammarAccess.getVariableRoutineParameterRule()); } 
	 EOF 
;

// Rule VariableRoutineParameter
ruleVariableRoutineParameter 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableRoutineParameterAccess().getGroup()); }
		(rule__VariableRoutineParameter__Group__0)
		{ after(grammarAccess.getVariableRoutineParameterAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleVariablePublic
entryRuleVariablePublic
:
{ before(grammarAccess.getVariablePublicRule()); }
	 ruleVariablePublic
{ after(grammarAccess.getVariablePublicRule()); } 
	 EOF 
;

// Rule VariablePublic
ruleVariablePublic 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariablePublicAccess().getGroup()); }
		(rule__VariablePublic__Group__0)
		{ after(grammarAccess.getVariablePublicAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleVariableProtected
entryRuleVariableProtected
:
{ before(grammarAccess.getVariableProtectedRule()); }
	 ruleVariableProtected
{ after(grammarAccess.getVariableProtectedRule()); } 
	 EOF 
;

// Rule VariableProtected
ruleVariableProtected 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariableProtectedAccess().getGroup()); }
		(rule__VariableProtected__Group__0)
		{ after(grammarAccess.getVariableProtectedAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleVariablePrivate
entryRuleVariablePrivate
:
{ before(grammarAccess.getVariablePrivateRule()); }
	 ruleVariablePrivate
{ after(grammarAccess.getVariablePrivateRule()); } 
	 EOF 
;

// Rule VariablePrivate
ruleVariablePrivate 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getVariablePrivateAccess().getGroup()); }
		(rule__VariablePrivate__Group__0)
		{ after(grammarAccess.getVariablePrivateAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleFunctionalParameterSet
entryRuleFunctionalParameterSet
:
{ before(grammarAccess.getFunctionalParameterSetRule()); }
	 ruleFunctionalParameterSet
{ after(grammarAccess.getFunctionalParameterSetRule()); } 
	 EOF 
;

// Rule FunctionalParameterSet
ruleFunctionalParameterSet 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFunctionalParameterSetAccess().getGroup()); }
		(rule__FunctionalParameterSet__Group__0)
		{ after(grammarAccess.getFunctionalParameterSetAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleFunctionalParameter
entryRuleFunctionalParameter
:
{ before(grammarAccess.getFunctionalParameterRule()); }
	 ruleFunctionalParameter
{ after(grammarAccess.getFunctionalParameterRule()); } 
	 EOF 
;

// Rule FunctionalParameter
ruleFunctionalParameter 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFunctionalParameterAccess().getGroup()); }
		(rule__FunctionalParameter__Group__0)
		{ after(grammarAccess.getFunctionalParameterAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleFormalParameterSet
entryRuleFormalParameterSet
:
{ before(grammarAccess.getFormalParameterSetRule()); }
	 ruleFormalParameterSet
{ after(grammarAccess.getFormalParameterSetRule()); } 
	 EOF 
;

// Rule FormalParameterSet
ruleFormalParameterSet 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFormalParameterSetAccess().getGroup()); }
		(rule__FormalParameterSet__Group__0)
		{ after(grammarAccess.getFormalParameterSetAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleFormalParameter
entryRuleFormalParameter
:
{ before(grammarAccess.getFormalParameterRule()); }
	 ruleFormalParameter
{ after(grammarAccess.getFormalParameterRule()); } 
	 EOF 
;

// Rule FormalParameter
ruleFormalParameter 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getFormalParameterAccess().getGroup()); }
		(rule__FormalParameter__Group__0)
		{ after(grammarAccess.getFormalParameterAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleParameterInput
entryRuleParameterInput
:
{ before(grammarAccess.getParameterInputRule()); }
	 ruleParameterInput
{ after(grammarAccess.getParameterInputRule()); } 
	 EOF 
;

// Rule ParameterInput
ruleParameterInput 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getParameterInputAccess().getGroup()); }
		(rule__ParameterInput__Group__0)
		{ after(grammarAccess.getParameterInputAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleParameterInout
entryRuleParameterInout
:
{ before(grammarAccess.getParameterInoutRule()); }
	 ruleParameterInout
{ after(grammarAccess.getParameterInoutRule()); } 
	 EOF 
;

// Rule ParameterInout
ruleParameterInout 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getParameterInoutAccess().getGroup()); }
		(rule__ParameterInout__Group__0)
		{ after(grammarAccess.getParameterInoutAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleParameterOutput
entryRuleParameterOutput
:
{ before(grammarAccess.getParameterOutputRule()); }
	 ruleParameterOutput
{ after(grammarAccess.getParameterOutputRule()); } 
	 EOF 
;

// Rule ParameterOutput
ruleParameterOutput 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getParameterOutputAccess().getGroup()); }
		(rule__ParameterOutput__Group__0)
		{ after(grammarAccess.getParameterOutputAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleParameterReturn
entryRuleParameterReturn
:
{ before(grammarAccess.getParameterReturnRule()); }
	 ruleParameterReturn
{ after(grammarAccess.getParameterReturnRule()); } 
	 EOF 
;

// Rule ParameterReturn
ruleParameterReturn 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getParameterReturnAccess().getGroup()); }
		(rule__ParameterReturn__Group__0)
		{ after(grammarAccess.getParameterReturnAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBufferContainerType
entryRuleBufferContainerType
:
{ before(grammarAccess.getBufferContainerTypeRule()); }
	 ruleBufferContainerType
{ after(grammarAccess.getBufferContainerTypeRule()); } 
	 EOF 
;

// Rule BufferContainerType
ruleBufferContainerType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBufferContainerTypeAccess().getGroup()); }
		(rule__BufferContainerType__Group__0)
		{ after(grammarAccess.getBufferContainerTypeAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBuffer
entryRuleBuffer
:
{ before(grammarAccess.getBufferRule()); }
	 ruleBuffer
{ after(grammarAccess.getBufferRule()); } 
	 EOF 
;

// Rule Buffer
ruleBuffer 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBufferAccess().getGroup()); }
		(rule__Buffer__Group__0)
		{ after(grammarAccess.getBufferAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBufferPublic
entryRuleBufferPublic
:
{ before(grammarAccess.getBufferPublicRule()); }
	 ruleBufferPublic
{ after(grammarAccess.getBufferPublicRule()); } 
	 EOF 
;

// Rule BufferPublic
ruleBufferPublic 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBufferPublicAccess().getGroup()); }
		(rule__BufferPublic__Group__0)
		{ after(grammarAccess.getBufferPublicAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBufferProtected
entryRuleBufferProtected
:
{ before(grammarAccess.getBufferProtectedRule()); }
	 ruleBufferProtected
{ after(grammarAccess.getBufferProtectedRule()); } 
	 EOF 
;

// Rule BufferProtected
ruleBufferProtected 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBufferProtectedAccess().getGroup()); }
		(rule__BufferProtected__Group__0)
		{ after(grammarAccess.getBufferProtectedAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBufferPrivate
entryRuleBufferPrivate
:
{ before(grammarAccess.getBufferPrivateRule()); }
	 ruleBufferPrivate
{ after(grammarAccess.getBufferPrivateRule()); } 
	 EOF 
;

// Rule BufferPrivate
ruleBufferPrivate 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBufferPrivateAccess().getGroup()); }
		(rule__BufferPrivate__Group__0)
		{ after(grammarAccess.getBufferPrivateAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePort
entryRulePort
:
{ before(grammarAccess.getPortRule()); }
	 rulePort
{ after(grammarAccess.getPortRule()); } 
	 EOF 
;

// Rule Port
rulePort 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPortAccess().getGroup()); }
		(rule__Port__Group__0)
		{ after(grammarAccess.getPortAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePortPublic
entryRulePortPublic
:
{ before(grammarAccess.getPortPublicRule()); }
	 rulePortPublic
{ after(grammarAccess.getPortPublicRule()); } 
	 EOF 
;

// Rule PortPublic
rulePortPublic 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPortPublicAccess().getGroup()); }
		(rule__PortPublic__Group__0)
		{ after(grammarAccess.getPortPublicAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePortProtected
entryRulePortProtected
:
{ before(grammarAccess.getPortProtectedRule()); }
	 rulePortProtected
{ after(grammarAccess.getPortProtectedRule()); } 
	 EOF 
;

// Rule PortProtected
rulePortProtected 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPortProtectedAccess().getGroup()); }
		(rule__PortProtected__Group__0)
		{ after(grammarAccess.getPortProtectedAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePortPrivate
entryRulePortPrivate
:
{ before(grammarAccess.getPortPrivateRule()); }
	 rulePortPrivate
{ after(grammarAccess.getPortPrivateRule()); } 
	 EOF 
;

// Rule PortPrivate
rulePortPrivate 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPortPrivateAccess().getGroup()); }
		(rule__PortPrivate__Group__0)
		{ after(grammarAccess.getPortPrivateAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleSignal
entryRuleSignal
:
{ before(grammarAccess.getSignalRule()); }
	 ruleSignal
{ after(grammarAccess.getSignalRule()); } 
	 EOF 
;

// Rule Signal
ruleSignal 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getSignalAccess().getGroup()); }
		(rule__Signal__Group__0)
		{ after(grammarAccess.getSignalAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleSignalPublic
entryRuleSignalPublic
:
{ before(grammarAccess.getSignalPublicRule()); }
	 ruleSignalPublic
{ after(grammarAccess.getSignalPublicRule()); } 
	 EOF 
;

// Rule SignalPublic
ruleSignalPublic 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getSignalPublicAccess().getGroup()); }
		(rule__SignalPublic__Group__0)
		{ after(grammarAccess.getSignalPublicAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleSignalProtected
entryRuleSignalProtected
:
{ before(grammarAccess.getSignalProtectedRule()); }
	 ruleSignalProtected
{ after(grammarAccess.getSignalProtectedRule()); } 
	 EOF 
;

// Rule SignalProtected
ruleSignalProtected 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getSignalProtectedAccess().getGroup()); }
		(rule__SignalProtected__Group__0)
		{ after(grammarAccess.getSignalProtectedAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleSignalPrivate
entryRuleSignalPrivate
:
{ before(grammarAccess.getSignalPrivateRule()); }
	 ruleSignalPrivate
{ after(grammarAccess.getSignalPrivateRule()); } 
	 EOF 
;

// Rule SignalPrivate
ruleSignalPrivate 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getSignalPrivateAccess().getGroup()); }
		(rule__SignalPrivate__Group__0)
		{ after(grammarAccess.getSignalPrivateAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleChannel
entryRuleChannel
:
{ before(grammarAccess.getChannelRule()); }
	 ruleChannel
{ after(grammarAccess.getChannelRule()); } 
	 EOF 
;

// Rule Channel
ruleChannel 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getChannelAccess().getGroup()); }
		(rule__Channel__Group__0)
		{ after(grammarAccess.getChannelAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleSignalReference
entryRuleSignalReference
:
{ before(grammarAccess.getSignalReferenceRule()); }
	 ruleSignalReference
{ after(grammarAccess.getSignalReferenceRule()); } 
	 EOF 
;

// Rule SignalReference
ruleSignalReference 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getSignalReferenceAccess().getGroup()); }
		(rule__SignalReference__Group__0)
		{ after(grammarAccess.getSignalReferenceAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleChannelPublic
entryRuleChannelPublic
:
{ before(grammarAccess.getChannelPublicRule()); }
	 ruleChannelPublic
{ after(grammarAccess.getChannelPublicRule()); } 
	 EOF 
;

// Rule ChannelPublic
ruleChannelPublic 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getChannelPublicAccess().getGroup()); }
		(rule__ChannelPublic__Group__0)
		{ after(grammarAccess.getChannelPublicAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleChannelProtected
entryRuleChannelProtected
:
{ before(grammarAccess.getChannelProtectedRule()); }
	 ruleChannelProtected
{ after(grammarAccess.getChannelProtectedRule()); } 
	 EOF 
;

// Rule ChannelProtected
ruleChannelProtected 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getChannelProtectedAccess().getGroup()); }
		(rule__ChannelProtected__Group__0)
		{ after(grammarAccess.getChannelProtectedAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleChannelPrivate
entryRuleChannelPrivate
:
{ before(grammarAccess.getChannelPrivateRule()); }
	 ruleChannelPrivate
{ after(grammarAccess.getChannelPrivateRule()); } 
	 EOF 
;

// Rule ChannelPrivate
ruleChannelPrivate 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getChannelPrivateAccess().getGroup()); }
		(rule__ChannelPrivate__Group__0)
		{ after(grammarAccess.getChannelPrivateAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTransition
entryRuleTransition
:
{ before(grammarAccess.getTransitionRule()); }
	 ruleTransition
{ after(grammarAccess.getTransitionRule()); } 
	 EOF 
;

// Rule Transition
ruleTransition 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTransitionAccess().getGroup()); }
		(rule__Transition__Group__0)
		{ after(grammarAccess.getTransitionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTransitionMoe
entryRuleTransitionMoe
:
{ before(grammarAccess.getTransitionMoeRule()); }
	 ruleTransitionMoe
{ after(grammarAccess.getTransitionMoeRule()); } 
	 EOF 
;

// Rule TransitionMoe
ruleTransitionMoe 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTransitionMoeAccess().getGroup()); }
		(rule__TransitionMoe__Group__0)
		{ after(grammarAccess.getTransitionMoeAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTransitionBehavior
entryRuleTransitionBehavior
:
{ before(grammarAccess.getTransitionBehaviorRule()); }
	 ruleTransitionBehavior
{ after(grammarAccess.getTransitionBehaviorRule()); } 
	 EOF 
;

// Rule TransitionBehavior
ruleTransitionBehavior 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTransitionBehaviorAccess().getGroup()); }
		(rule__TransitionBehavior__Group__0)
		{ after(grammarAccess.getTransitionBehaviorAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTransitionTrigger
entryRuleTransitionTrigger
:
{ before(grammarAccess.getTransitionTriggerRule()); }
	 ruleTransitionTrigger
{ after(grammarAccess.getTransitionTriggerRule()); } 
	 EOF 
;

// Rule TransitionTrigger
ruleTransitionTrigger 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTransitionTriggerAccess().getInputComStatementParserRuleCall()); }
		ruleInputComStatement
		{ after(grammarAccess.getTransitionTriggerAccess().getInputComStatementParserRuleCall()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTransitionGuard
entryRuleTransitionGuard
:
{ before(grammarAccess.getTransitionGuardRule()); }
	 ruleTransitionGuard
{ after(grammarAccess.getTransitionGuardRule()); } 
	 EOF 
;

// Rule TransitionGuard
ruleTransitionGuard 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTransitionGuardAccess().getAlternatives()); }
		(rule__TransitionGuard__Alternatives)
		{ after(grammarAccess.getTransitionGuardAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTransitionGuardExpression
entryRuleTransitionGuardExpression
:
{ before(grammarAccess.getTransitionGuardExpressionRule()); }
	 ruleTransitionGuardExpression
{ after(grammarAccess.getTransitionGuardExpressionRule()); } 
	 EOF 
;

// Rule TransitionGuardExpression
ruleTransitionGuardExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTransitionGuardExpressionAccess().getGroup()); }
		(rule__TransitionGuardExpression__Group__0)
		{ after(grammarAccess.getTransitionGuardExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTransitionTimedGuard
entryRuleTransitionTimedGuard
:
{ before(grammarAccess.getTransitionTimedGuardRule()); }
	 ruleTransitionTimedGuard
{ after(grammarAccess.getTransitionTimedGuardRule()); } 
	 EOF 
;

// Rule TransitionTimedGuard
ruleTransitionTimedGuard 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTransitionTimedGuardAccess().getAlternatives()); }
		(rule__TransitionTimedGuard__Alternatives)
		{ after(grammarAccess.getTransitionTimedGuardAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTransitionEffect
entryRuleTransitionEffect
:
{ before(grammarAccess.getTransitionEffectRule()); }
	 ruleTransitionEffect
{ after(grammarAccess.getTransitionEffectRule()); } 
	 EOF 
;

// Rule TransitionEffect
ruleTransitionEffect 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTransitionEffectAccess().getGroup()); }
		(rule__TransitionEffect__Group__0)
		{ after(grammarAccess.getTransitionEffectAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTransitionEffectStatement
entryRuleTransitionEffectStatement
:
{ before(grammarAccess.getTransitionEffectStatementRule()); }
	 ruleTransitionEffectStatement
{ after(grammarAccess.getTransitionEffectStatementRule()); } 
	 EOF 
;

// Rule TransitionEffectStatement
ruleTransitionEffectStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTransitionEffectStatementAccess().getAlternatives()); }
		(rule__TransitionEffectStatement__Alternatives)
		{ after(grammarAccess.getTransitionEffectStatementAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleStatement
entryRuleStatement
:
{ before(grammarAccess.getStatementRule()); }
	 ruleStatement
{ after(grammarAccess.getStatementRule()); } 
	 EOF 
;

// Rule Statement
ruleStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getStatementAccess().getAlternatives()); }
		(rule__Statement__Alternatives)
		{ after(grammarAccess.getStatementAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBlockStatement
entryRuleBlockStatement
:
{ before(grammarAccess.getBlockStatementRule()); }
	 ruleBlockStatement
{ after(grammarAccess.getBlockStatementRule()); } 
	 EOF 
;

// Rule BlockStatement
ruleBlockStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBlockStatementAccess().getGroup()); }
		(rule__BlockStatement__Group__0)
		{ after(grammarAccess.getBlockStatementAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBlockStatementScheduler
entryRuleBlockStatementScheduler
:
{ before(grammarAccess.getBlockStatementSchedulerRule()); }
	 ruleBlockStatementScheduler
{ after(grammarAccess.getBlockStatementSchedulerRule()); } 
	 EOF 
;

// Rule BlockStatementScheduler
ruleBlockStatementScheduler 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBlockStatementSchedulerAccess().getAlternatives()); }
		(rule__BlockStatementScheduler__Alternatives)
		{ after(grammarAccess.getBlockStatementSchedulerAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleExpressionStatement
entryRuleExpressionStatement
:
{ before(grammarAccess.getExpressionStatementRule()); }
	 ruleExpressionStatement
{ after(grammarAccess.getExpressionStatementRule()); } 
	 EOF 
;

// Rule ExpressionStatement
ruleExpressionStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getExpressionStatementAccess().getAlternatives()); }
		(rule__ExpressionStatement__Alternatives)
		{ after(grammarAccess.getExpressionStatementAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleGuardStatement
entryRuleGuardStatement
:
{ before(grammarAccess.getGuardStatementRule()); }
	 ruleGuardStatement
{ after(grammarAccess.getGuardStatementRule()); } 
	 EOF 
;

// Rule GuardStatement
ruleGuardStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getGuardStatementAccess().getGroup()); }
		(rule__GuardStatement__Group__0)
		{ after(grammarAccess.getGuardStatementAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTimedGuardStatement
entryRuleTimedGuardStatement
:
{ before(grammarAccess.getTimedGuardStatementRule()); }
	 ruleTimedGuardStatement
{ after(grammarAccess.getTimedGuardStatementRule()); } 
	 EOF 
;

// Rule TimedGuardStatement
ruleTimedGuardStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTimedGuardStatementAccess().getGroup()); }
		(rule__TimedGuardStatement__Group__0)
		{ after(grammarAccess.getTimedGuardStatementAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleEventGuardStatement
entryRuleEventGuardStatement
:
{ before(grammarAccess.getEventGuardStatementRule()); }
	 ruleEventGuardStatement
{ after(grammarAccess.getEventGuardStatementRule()); } 
	 EOF 
;

// Rule EventGuardStatement
ruleEventGuardStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getEventGuardStatementAccess().getGroup()); }
		(rule__EventGuardStatement__Group__0)
		{ after(grammarAccess.getEventGuardStatementAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleCheckSatGuardStatement
entryRuleCheckSatGuardStatement
:
{ before(grammarAccess.getCheckSatGuardStatementRule()); }
	 ruleCheckSatGuardStatement
{ after(grammarAccess.getCheckSatGuardStatementRule()); } 
	 EOF 
;

// Rule CheckSatGuardStatement
ruleCheckSatGuardStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getCheckSatGuardStatementAccess().getGroup()); }
		(rule__CheckSatGuardStatement__Group__0)
		{ after(grammarAccess.getCheckSatGuardStatementAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleInputComStatement
entryRuleInputComStatement
:
{ before(grammarAccess.getInputComStatementRule()); }
	 ruleInputComStatement
{ after(grammarAccess.getInputComStatementRule()); } 
	 EOF 
;

// Rule InputComStatement
ruleInputComStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getInputComStatementAccess().getGroup()); }
		(rule__InputComStatement__Group__0)
		{ after(grammarAccess.getInputComStatementAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleOutputComStatement
entryRuleOutputComStatement
:
{ before(grammarAccess.getOutputComStatementRule()); }
	 ruleOutputComStatement
{ after(grammarAccess.getOutputComStatementRule()); } 
	 EOF 
;

// Rule OutputComStatement
ruleOutputComStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getOutputComStatementAccess().getGroup()); }
		(rule__OutputComStatement__Group__0)
		{ after(grammarAccess.getOutputComStatementAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleExpressionAsMachine
entryRuleExpressionAsMachine
:
{ before(grammarAccess.getExpressionAsMachineRule()); }
	 ruleExpressionAsMachine
{ after(grammarAccess.getExpressionAsMachineRule()); } 
	 EOF 
;

// Rule ExpressionAsMachine
ruleExpressionAsMachine 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getExpressionAsMachineAccess().getMachineAssignment()); }
		(rule__ExpressionAsMachine__MachineAssignment)
		{ after(grammarAccess.getExpressionAsMachineAccess().getMachineAssignment()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleIfStatement
entryRuleIfStatement
:
{ before(grammarAccess.getIfStatementRule()); }
	 ruleIfStatement
{ after(grammarAccess.getIfStatementRule()); } 
	 EOF 
;

// Rule IfStatement
ruleIfStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIfStatementAccess().getGroup()); }
		(rule__IfStatement__Group__0)
		{ after(grammarAccess.getIfStatementAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleElseIfStatement
entryRuleElseIfStatement
:
{ before(grammarAccess.getElseIfStatementRule()); }
	 ruleElseIfStatement
{ after(grammarAccess.getElseIfStatementRule()); } 
	 EOF 
;

// Rule ElseIfStatement
ruleElseIfStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getElseIfStatementAccess().getGroup()); }
		(rule__ElseIfStatement__Group__0)
		{ after(grammarAccess.getElseIfStatementAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleWhileDoStatement
entryRuleWhileDoStatement
:
{ before(grammarAccess.getWhileDoStatementRule()); }
	 ruleWhileDoStatement
{ after(grammarAccess.getWhileDoStatementRule()); } 
	 EOF 
;

// Rule WhileDoStatement
ruleWhileDoStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getWhileDoStatementAccess().getGroup()); }
		(rule__WhileDoStatement__Group__0)
		{ after(grammarAccess.getWhileDoStatementAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleDoWhileStatement
entryRuleDoWhileStatement
:
{ before(grammarAccess.getDoWhileStatementRule()); }
	 ruleDoWhileStatement
{ after(grammarAccess.getDoWhileStatementRule()); } 
	 EOF 
;

// Rule DoWhileStatement
ruleDoWhileStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getDoWhileStatementAccess().getGroup()); }
		(rule__DoWhileStatement__Group__0)
		{ after(grammarAccess.getDoWhileStatementAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleForStatement
entryRuleForStatement
:
{ before(grammarAccess.getForStatementRule()); }
	 ruleForStatement
{ after(grammarAccess.getForStatementRule()); } 
	 EOF 
;

// Rule ForStatement
ruleForStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getForStatementAccess().getAlternatives()); }
		(rule__ForStatement__Alternatives)
		{ after(grammarAccess.getForStatementAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleForAssignmentExpression
entryRuleForAssignmentExpression
:
{ before(grammarAccess.getForAssignmentExpressionRule()); }
	 ruleForAssignmentExpression
{ after(grammarAccess.getForAssignmentExpressionRule()); } 
	 EOF 
;

// Rule ForAssignmentExpression
ruleForAssignmentExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getForAssignmentExpressionAccess().getAlternatives()); }
		(rule__ForAssignmentExpression__Alternatives)
		{ after(grammarAccess.getForAssignmentExpressionAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleForEachStatement
entryRuleForEachStatement
:
{ before(grammarAccess.getForEachStatementRule()); }
	 ruleForEachStatement
{ after(grammarAccess.getForEachStatementRule()); } 
	 EOF 
;

// Rule ForEachStatement
ruleForEachStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getForEachStatementAccess().getAlternatives()); }
		(rule__ForEachStatement__Alternatives)
		{ after(grammarAccess.getForEachStatementAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleInterruptStatement
entryRuleInterruptStatement
:
{ before(grammarAccess.getInterruptStatementRule()); }
	 ruleInterruptStatement
{ after(grammarAccess.getInterruptStatementRule()); } 
	 EOF 
;

// Rule InterruptStatement
ruleInterruptStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getInterruptStatementAccess().getGroup()); }
		(rule__InterruptStatement__Group__0)
		{ after(grammarAccess.getInterruptStatementAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleActivityStatement
entryRuleActivityStatement
:
{ before(grammarAccess.getActivityStatementRule()); }
	 ruleActivityStatement
{ after(grammarAccess.getActivityStatementRule()); } 
	 EOF 
;

// Rule ActivityStatement
ruleActivityStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getActivityStatementAccess().getGroup()); }
		(rule__ActivityStatement__Group__0)
		{ after(grammarAccess.getActivityStatementAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleInvokeStatement
entryRuleInvokeStatement
:
{ before(grammarAccess.getInvokeStatementRule()); }
	 ruleInvokeStatement
{ after(grammarAccess.getInvokeStatementRule()); } 
	 EOF 
;

// Rule InvokeStatement
ruleInvokeStatement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getInvokeStatementAccess().getAlternatives()); }
		(rule__InvokeStatement__Alternatives)
		{ after(grammarAccess.getInvokeStatementAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleExpression
entryRuleExpression
:
{ before(grammarAccess.getExpressionRule()); }
	 ruleExpression
{ after(grammarAccess.getExpressionRule()); } 
	 EOF 
;

// Rule Expression
ruleExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getExpressionAccess().getAlternatives()); }
		(rule__Expression__Alternatives)
		{ after(grammarAccess.getExpressionAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleAssignmentExpression
entryRuleAssignmentExpression
:
{ before(grammarAccess.getAssignmentExpressionRule()); }
	 ruleAssignmentExpression
{ after(grammarAccess.getAssignmentExpressionRule()); } 
	 EOF 
;

// Rule AssignmentExpression
ruleAssignmentExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAssignmentExpressionAccess().getGroup()); }
		(rule__AssignmentExpression__Group__0)
		{ after(grammarAccess.getAssignmentExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleAssignmentOperator
entryRuleAssignmentOperator
:
{ before(grammarAccess.getAssignmentOperatorRule()); }
	 ruleAssignmentOperator
{ after(grammarAccess.getAssignmentOperatorRule()); } 
	 EOF 
;

// Rule AssignmentOperator
ruleAssignmentOperator 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getAlternatives()); }
		(rule__AssignmentOperator__Alternatives)
		{ after(grammarAccess.getAssignmentOperatorAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLeftHandSideExpression
entryRuleLeftHandSideExpression
:
{ before(grammarAccess.getLeftHandSideExpressionRule()); }
	 ruleLeftHandSideExpression
{ after(grammarAccess.getLeftHandSideExpressionRule()); } 
	 EOF 
;

// Rule LeftHandSideExpression
ruleLeftHandSideExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLeftHandSideExpressionAccess().getGroup()); }
		(rule__LeftHandSideExpression__Group__0)
		{ after(grammarAccess.getLeftHandSideExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleConditionalTestExpression
entryRuleConditionalTestExpression
:
{ before(grammarAccess.getConditionalTestExpressionRule()); }
	 ruleConditionalTestExpression
{ after(grammarAccess.getConditionalTestExpressionRule()); } 
	 EOF 
;

// Rule ConditionalTestExpression
ruleConditionalTestExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getConditionalTestExpressionAccess().getGroup()); }
		(rule__ConditionalTestExpression__Group__0)
		{ after(grammarAccess.getConditionalTestExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLogicalOrExpression
entryRuleLogicalOrExpression
:
{ before(grammarAccess.getLogicalOrExpressionRule()); }
	 ruleLogicalOrExpression
{ after(grammarAccess.getLogicalOrExpressionRule()); } 
	 EOF 
;

// Rule LogicalOrExpression
ruleLogicalOrExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLogicalOrExpressionAccess().getGroup()); }
		(rule__LogicalOrExpression__Group__0)
		{ after(grammarAccess.getLogicalOrExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLogicalAndExpression
entryRuleLogicalAndExpression
:
{ before(grammarAccess.getLogicalAndExpressionRule()); }
	 ruleLogicalAndExpression
{ after(grammarAccess.getLogicalAndExpressionRule()); } 
	 EOF 
;

// Rule LogicalAndExpression
ruleLogicalAndExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLogicalAndExpressionAccess().getGroup()); }
		(rule__LogicalAndExpression__Group__0)
		{ after(grammarAccess.getLogicalAndExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBitwiseOrExpression
entryRuleBitwiseOrExpression
:
{ before(grammarAccess.getBitwiseOrExpressionRule()); }
	 ruleBitwiseOrExpression
{ after(grammarAccess.getBitwiseOrExpressionRule()); } 
	 EOF 
;

// Rule BitwiseOrExpression
ruleBitwiseOrExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBitwiseOrExpressionAccess().getGroup()); }
		(rule__BitwiseOrExpression__Group__0)
		{ after(grammarAccess.getBitwiseOrExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBitwiseXorExpression
entryRuleBitwiseXorExpression
:
{ before(grammarAccess.getBitwiseXorExpressionRule()); }
	 ruleBitwiseXorExpression
{ after(grammarAccess.getBitwiseXorExpressionRule()); } 
	 EOF 
;

// Rule BitwiseXorExpression
ruleBitwiseXorExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBitwiseXorExpressionAccess().getGroup()); }
		(rule__BitwiseXorExpression__Group__0)
		{ after(grammarAccess.getBitwiseXorExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBitwiseAndExpression
entryRuleBitwiseAndExpression
:
{ before(grammarAccess.getBitwiseAndExpressionRule()); }
	 ruleBitwiseAndExpression
{ after(grammarAccess.getBitwiseAndExpressionRule()); } 
	 EOF 
;

// Rule BitwiseAndExpression
ruleBitwiseAndExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBitwiseAndExpressionAccess().getGroup()); }
		(rule__BitwiseAndExpression__Group__0)
		{ after(grammarAccess.getBitwiseAndExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleEqualityExpression
entryRuleEqualityExpression
:
{ before(grammarAccess.getEqualityExpressionRule()); }
	 ruleEqualityExpression
{ after(grammarAccess.getEqualityExpressionRule()); } 
	 EOF 
;

// Rule EqualityExpression
ruleEqualityExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getEqualityExpressionAccess().getGroup()); }
		(rule__EqualityExpression__Group__0)
		{ after(grammarAccess.getEqualityExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleEqualityOperator
entryRuleEqualityOperator
:
{ before(grammarAccess.getEqualityOperatorRule()); }
	 ruleEqualityOperator
{ after(grammarAccess.getEqualityOperatorRule()); } 
	 EOF 
;

// Rule EqualityOperator
ruleEqualityOperator 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getEqualityOperatorAccess().getAlternatives()); }
		(rule__EqualityOperator__Alternatives)
		{ after(grammarAccess.getEqualityOperatorAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleRelationalExpression
entryRuleRelationalExpression
:
{ before(grammarAccess.getRelationalExpressionRule()); }
	 ruleRelationalExpression
{ after(grammarAccess.getRelationalExpressionRule()); } 
	 EOF 
;

// Rule RelationalExpression
ruleRelationalExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getRelationalExpressionAccess().getGroup()); }
		(rule__RelationalExpression__Group__0)
		{ after(grammarAccess.getRelationalExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleRelationalOperator
entryRuleRelationalOperator
:
{ before(grammarAccess.getRelationalOperatorRule()); }
	 ruleRelationalOperator
{ after(grammarAccess.getRelationalOperatorRule()); } 
	 EOF 
;

// Rule RelationalOperator
ruleRelationalOperator 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getRelationalOperatorAccess().getAlternatives()); }
		(rule__RelationalOperator__Alternatives)
		{ after(grammarAccess.getRelationalOperatorAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleAdditiveExpression
entryRuleAdditiveExpression
:
{ before(grammarAccess.getAdditiveExpressionRule()); }
	 ruleAdditiveExpression
{ after(grammarAccess.getAdditiveExpressionRule()); } 
	 EOF 
;

// Rule AdditiveExpression
ruleAdditiveExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAdditiveExpressionAccess().getGroup()); }
		(rule__AdditiveExpression__Group__0)
		{ after(grammarAccess.getAdditiveExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleMultiplicativeExpression
entryRuleMultiplicativeExpression
:
{ before(grammarAccess.getMultiplicativeExpressionRule()); }
	 ruleMultiplicativeExpression
{ after(grammarAccess.getMultiplicativeExpressionRule()); } 
	 EOF 
;

// Rule MultiplicativeExpression
ruleMultiplicativeExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getMultiplicativeExpressionAccess().getGroup()); }
		(rule__MultiplicativeExpression__Group__0)
		{ after(grammarAccess.getMultiplicativeExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleUnaryExpression
entryRuleUnaryExpression
:
{ before(grammarAccess.getUnaryExpressionRule()); }
	 ruleUnaryExpression
{ after(grammarAccess.getUnaryExpressionRule()); } 
	 EOF 
;

// Rule UnaryExpression
ruleUnaryExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getUnaryExpressionAccess().getAlternatives()); }
		(rule__UnaryExpression__Alternatives)
		{ after(grammarAccess.getUnaryExpressionAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePostfixUnaryExpression
entryRulePostfixUnaryExpression
:
{ before(grammarAccess.getPostfixUnaryExpressionRule()); }
	 rulePostfixUnaryExpression
{ after(grammarAccess.getPostfixUnaryExpressionRule()); } 
	 EOF 
;

// Rule PostfixUnaryExpression
rulePostfixUnaryExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPostfixUnaryExpressionAccess().getIncrementOrDecrementPostfixExpressionParserRuleCall()); }
		ruleIncrementOrDecrementPostfixExpression
		{ after(grammarAccess.getPostfixUnaryExpressionAccess().getIncrementOrDecrementPostfixExpressionParserRuleCall()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleIncrementOrDecrementPostfixExpression
entryRuleIncrementOrDecrementPostfixExpression
:
{ before(grammarAccess.getIncrementOrDecrementPostfixExpressionRule()); }
	 ruleIncrementOrDecrementPostfixExpression
{ after(grammarAccess.getIncrementOrDecrementPostfixExpressionRule()); } 
	 EOF 
;

// Rule IncrementOrDecrementPostfixExpression
ruleIncrementOrDecrementPostfixExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIncrementOrDecrementPostfixExpressionAccess().getGroup()); }
		(rule__IncrementOrDecrementPostfixExpression__Group__0)
		{ after(grammarAccess.getIncrementOrDecrementPostfixExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePrefixUnaryExpression
entryRulePrefixUnaryExpression
:
{ before(grammarAccess.getPrefixUnaryExpressionRule()); }
	 rulePrefixUnaryExpression
{ after(grammarAccess.getPrefixUnaryExpressionRule()); } 
	 EOF 
;

// Rule PrefixUnaryExpression
rulePrefixUnaryExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPrefixUnaryExpressionAccess().getIncrementOrDecrementPrefixExpressionParserRuleCall()); }
		ruleIncrementOrDecrementPrefixExpression
		{ after(grammarAccess.getPrefixUnaryExpressionAccess().getIncrementOrDecrementPrefixExpressionParserRuleCall()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleIncrementOrDecrementPrefixExpression
entryRuleIncrementOrDecrementPrefixExpression
:
{ before(grammarAccess.getIncrementOrDecrementPrefixExpressionRule()); }
	 ruleIncrementOrDecrementPrefixExpression
{ after(grammarAccess.getIncrementOrDecrementPrefixExpressionRule()); } 
	 EOF 
;

// Rule IncrementOrDecrementPrefixExpression
ruleIncrementOrDecrementPrefixExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getIncrementOrDecrementPrefixExpressionAccess().getGroup()); }
		(rule__IncrementOrDecrementPrefixExpression__Group__0)
		{ after(grammarAccess.getIncrementOrDecrementPrefixExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleAffixOperator
entryRuleAffixOperator
:
{ before(grammarAccess.getAffixOperatorRule()); }
	 ruleAffixOperator
{ after(grammarAccess.getAffixOperatorRule()); } 
	 EOF 
;

// Rule AffixOperator
ruleAffixOperator 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getAffixOperatorAccess().getAlternatives()); }
		(rule__AffixOperator__Alternatives)
		{ after(grammarAccess.getAffixOperatorAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleNewfreshExpression
entryRuleNewfreshExpression
:
{ before(grammarAccess.getNewfreshExpressionRule()); }
	 ruleNewfreshExpression
{ after(grammarAccess.getNewfreshExpressionRule()); } 
	 EOF 
;

// Rule NewfreshExpression
ruleNewfreshExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getNewfreshExpressionAccess().getAlternatives()); }
		(rule__NewfreshExpression__Alternatives)
		{ after(grammarAccess.getNewfreshExpressionAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleCastExpression
entryRuleCastExpression
:
{ before(grammarAccess.getCastExpressionRule()); }
	 ruleCastExpression
{ after(grammarAccess.getCastExpressionRule()); } 
	 EOF 
;

// Rule CastExpression
ruleCastExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getCastExpressionAccess().getGroup()); }
		(rule__CastExpression__Group__0)
		{ after(grammarAccess.getCastExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleArithmeticUnaryExpression
entryRuleArithmeticUnaryExpression
:
{ before(grammarAccess.getArithmeticUnaryExpressionRule()); }
	 ruleArithmeticUnaryExpression
{ after(grammarAccess.getArithmeticUnaryExpressionRule()); } 
	 EOF 
;

// Rule ArithmeticUnaryExpression
ruleArithmeticUnaryExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getArithmeticUnaryExpressionAccess().getGroup()); }
		(rule__ArithmeticUnaryExpression__Group__0)
		{ after(grammarAccess.getArithmeticUnaryExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleArithmeticUnaryOperator
entryRuleArithmeticUnaryOperator
:
{ before(grammarAccess.getArithmeticUnaryOperatorRule()); }
	 ruleArithmeticUnaryOperator
{ after(grammarAccess.getArithmeticUnaryOperatorRule()); } 
	 EOF 
;

// Rule ArithmeticUnaryOperator
ruleArithmeticUnaryOperator 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getArithmeticUnaryOperatorAccess().getAlternatives()); }
		(rule__ArithmeticUnaryOperator__Alternatives)
		{ after(grammarAccess.getArithmeticUnaryOperatorAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleQuantifiedLogicalExpression
entryRuleQuantifiedLogicalExpression
:
{ before(grammarAccess.getQuantifiedLogicalExpressionRule()); }
	 ruleQuantifiedLogicalExpression
{ after(grammarAccess.getQuantifiedLogicalExpressionRule()); } 
	 EOF 
;

// Rule QuantifiedLogicalExpression
ruleQuantifiedLogicalExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getQuantifiedLogicalExpressionAccess().getGroup()); }
		(rule__QuantifiedLogicalExpression__Group__0)
		{ after(grammarAccess.getQuantifiedLogicalExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBoundVariable
entryRuleBoundVariable
:
{ before(grammarAccess.getBoundVariableRule()); }
	 ruleBoundVariable
{ after(grammarAccess.getBoundVariableRule()); } 
	 EOF 
;

// Rule BoundVariable
ruleBoundVariable 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBoundVariableAccess().getGroup()); }
		(rule__BoundVariable__Group__0)
		{ after(grammarAccess.getBoundVariableAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLogicalUnaryExpression
entryRuleLogicalUnaryExpression
:
{ before(grammarAccess.getLogicalUnaryExpressionRule()); }
	 ruleLogicalUnaryExpression
{ after(grammarAccess.getLogicalUnaryExpressionRule()); } 
	 EOF 
;

// Rule LogicalUnaryExpression
ruleLogicalUnaryExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLogicalUnaryExpressionAccess().getGroup()); }
		(rule__LogicalUnaryExpression__Group__0)
		{ after(grammarAccess.getLogicalUnaryExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBitwiseUnaryExpression
entryRuleBitwiseUnaryExpression
:
{ before(grammarAccess.getBitwiseUnaryExpressionRule()); }
	 ruleBitwiseUnaryExpression
{ after(grammarAccess.getBitwiseUnaryExpressionRule()); } 
	 EOF 
;

// Rule BitwiseUnaryExpression
ruleBitwiseUnaryExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBitwiseUnaryExpressionAccess().getGroup()); }
		(rule__BitwiseUnaryExpression__Group__0)
		{ after(grammarAccess.getBitwiseUnaryExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePrimaryExpression
entryRulePrimaryExpression
:
{ before(grammarAccess.getPrimaryExpressionRule()); }
	 rulePrimaryExpression
{ after(grammarAccess.getPrimaryExpressionRule()); } 
	 EOF 
;

// Rule PrimaryExpression
rulePrimaryExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getGroup()); }
		(rule__PrimaryExpression__Group__0)
		{ after(grammarAccess.getPrimaryExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleBaseExpression
entryRuleBaseExpression
:
{ before(grammarAccess.getBaseExpressionRule()); }
	 ruleBaseExpression
{ after(grammarAccess.getBaseExpressionRule()); } 
	 EOF 
;

// Rule BaseExpression
ruleBaseExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getBaseExpressionAccess().getAlternatives()); }
		(rule__BaseExpression__Alternatives)
		{ after(grammarAccess.getBaseExpressionAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleInvokeExpressionDeprecated
entryRuleInvokeExpressionDeprecated
:
{ before(grammarAccess.getInvokeExpressionDeprecatedRule()); }
	 ruleInvokeExpressionDeprecated
{ after(grammarAccess.getInvokeExpressionDeprecatedRule()); } 
	 EOF 
;

// Rule InvokeExpressionDeprecated
ruleInvokeExpressionDeprecated 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getInvokeExpressionDeprecatedAccess().getGroup()); }
		(rule__InvokeExpressionDeprecated__Group__0)
		{ after(grammarAccess.getInvokeExpressionDeprecatedAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleInstantiationExpression
entryRuleInstantiationExpression
:
{ before(grammarAccess.getInstantiationExpressionRule()); }
	 ruleInstantiationExpression
{ after(grammarAccess.getInstantiationExpressionRule()); } 
	 EOF 
;

// Rule InstantiationExpression
ruleInstantiationExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getInstantiationExpressionAccess().getGroup()); }
		(rule__InstantiationExpression__Group__0)
		{ after(grammarAccess.getInstantiationExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleDynamicInstanceSpecification
entryRuleDynamicInstanceSpecification
:
{ before(grammarAccess.getDynamicInstanceSpecificationRule()); }
	 ruleDynamicInstanceSpecification
{ after(grammarAccess.getDynamicInstanceSpecificationRule()); } 
	 EOF 
;

// Rule DynamicInstanceSpecification
ruleDynamicInstanceSpecification 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getDynamicInstanceSpecificationAccess().getGroup()); }
		(rule__DynamicInstanceSpecification__Group__0)
		{ after(grammarAccess.getDynamicInstanceSpecificationAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleTupleParameterExpression
entryRuleTupleParameterExpression
:
{ before(grammarAccess.getTupleParameterExpressionRule()); }
	 ruleTupleParameterExpression
{ after(grammarAccess.getTupleParameterExpressionRule()); } 
	 EOF 
;

// Rule TupleParameterExpression
ruleTupleParameterExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getTupleParameterExpressionAccess().getGroup()); }
		(rule__TupleParameterExpression__Group__0)
		{ after(grammarAccess.getTupleParameterExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleMixTupleExpressionList
entryRuleMixTupleExpressionList
:
{ before(grammarAccess.getMixTupleExpressionListRule()); }
	 ruleMixTupleExpressionList
{ after(grammarAccess.getMixTupleExpressionListRule()); } 
	 EOF 
;

// Rule MixTupleExpressionList
ruleMixTupleExpressionList 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getMixTupleExpressionListAccess().getGroup()); }
		(rule__MixTupleExpressionList__Group__0)
		{ after(grammarAccess.getMixTupleExpressionListAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRulePositionalTupleExpressionList
entryRulePositionalTupleExpressionList
:
{ before(grammarAccess.getPositionalTupleExpressionListRule()); }
	 rulePositionalTupleExpressionList
{ after(grammarAccess.getPositionalTupleExpressionListRule()); } 
	 EOF 
;

// Rule PositionalTupleExpressionList
rulePositionalTupleExpressionList 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getPositionalTupleExpressionListAccess().getGroup()); }
		(rule__PositionalTupleExpressionList__Group__0)
		{ after(grammarAccess.getPositionalTupleExpressionListAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleNamedExpression
entryRuleNamedExpression
:
{ before(grammarAccess.getNamedExpressionRule()); }
	 ruleNamedExpression
{ after(grammarAccess.getNamedExpressionRule()); } 
	 EOF 
;

// Rule NamedExpression
ruleNamedExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getNamedExpressionAccess().getGroup()); }
		(rule__NamedExpression__Group__0)
		{ after(grammarAccess.getNamedExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLiteralReferenceableExpression
entryRuleLiteralReferenceableExpression
:
{ before(grammarAccess.getLiteralReferenceableExpressionRule()); }
	 ruleLiteralReferenceableExpression
{ after(grammarAccess.getLiteralReferenceableExpressionRule()); } 
	 EOF 
;

// Rule LiteralReferenceableExpression
ruleLiteralReferenceableExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLiteralReferenceableExpressionAccess().getAlternatives()); }
		(rule__LiteralReferenceableExpression__Alternatives)
		{ after(grammarAccess.getLiteralReferenceableExpressionAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLiteralTerminalExpression
entryRuleLiteralTerminalExpression
:
{ before(grammarAccess.getLiteralTerminalExpressionRule()); }
	 ruleLiteralTerminalExpression
{ after(grammarAccess.getLiteralTerminalExpressionRule()); } 
	 EOF 
;

// Rule LiteralTerminalExpression
ruleLiteralTerminalExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLiteralTerminalExpressionAccess().getAlternatives()); }
		(rule__LiteralTerminalExpression__Alternatives)
		{ after(grammarAccess.getLiteralTerminalExpressionAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLiteralBooleanExpression
entryRuleLiteralBooleanExpression
:
{ before(grammarAccess.getLiteralBooleanExpressionRule()); }
	 ruleLiteralBooleanExpression
{ after(grammarAccess.getLiteralBooleanExpressionRule()); } 
	 EOF 
;

// Rule LiteralBooleanExpression
ruleLiteralBooleanExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLiteralBooleanExpressionAccess().getGroup()); }
		(rule__LiteralBooleanExpression__Group__0)
		{ after(grammarAccess.getLiteralBooleanExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLiteralIntegerExpression
entryRuleLiteralIntegerExpression
:
{ before(grammarAccess.getLiteralIntegerExpressionRule()); }
	 ruleLiteralIntegerExpression
{ after(grammarAccess.getLiteralIntegerExpressionRule()); } 
	 EOF 
;

// Rule LiteralIntegerExpression
ruleLiteralIntegerExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLiteralIntegerExpressionAccess().getGroup()); }
		(rule__LiteralIntegerExpression__Group__0)
		{ after(grammarAccess.getLiteralIntegerExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLiteralRationalExpression
entryRuleLiteralRationalExpression
:
{ before(grammarAccess.getLiteralRationalExpressionRule()); }
	 ruleLiteralRationalExpression
{ after(grammarAccess.getLiteralRationalExpressionRule()); } 
	 EOF 
;

// Rule LiteralRationalExpression
ruleLiteralRationalExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLiteralRationalExpressionAccess().getGroup()); }
		(rule__LiteralRationalExpression__Group__0)
		{ after(grammarAccess.getLiteralRationalExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLiteralFloatExpression
entryRuleLiteralFloatExpression
:
{ before(grammarAccess.getLiteralFloatExpressionRule()); }
	 ruleLiteralFloatExpression
{ after(grammarAccess.getLiteralFloatExpressionRule()); } 
	 EOF 
;

// Rule LiteralFloatExpression
ruleLiteralFloatExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLiteralFloatExpressionAccess().getGroup()); }
		(rule__LiteralFloatExpression__Group__0)
		{ after(grammarAccess.getLiteralFloatExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLiteralCharacterExpression
entryRuleLiteralCharacterExpression
:
{ before(grammarAccess.getLiteralCharacterExpressionRule()); }
	 ruleLiteralCharacterExpression
{ after(grammarAccess.getLiteralCharacterExpressionRule()); } 
	 EOF 
;

// Rule LiteralCharacterExpression
ruleLiteralCharacterExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLiteralCharacterExpressionAccess().getGroup()); }
		(rule__LiteralCharacterExpression__Group__0)
		{ after(grammarAccess.getLiteralCharacterExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLiteralStringExpression
entryRuleLiteralStringExpression
:
{ before(grammarAccess.getLiteralStringExpressionRule()); }
	 ruleLiteralStringExpression
{ after(grammarAccess.getLiteralStringExpressionRule()); } 
	 EOF 
;

// Rule LiteralStringExpression
ruleLiteralStringExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLiteralStringExpressionAccess().getGroup()); }
		(rule__LiteralStringExpression__Group__0)
		{ after(grammarAccess.getLiteralStringExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLiteralNullExpression
entryRuleLiteralNullExpression
:
{ before(grammarAccess.getLiteralNullExpressionRule()); }
	 ruleLiteralNullExpression
{ after(grammarAccess.getLiteralNullExpressionRule()); } 
	 EOF 
;

// Rule LiteralNullExpression
ruleLiteralNullExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLiteralNullExpressionAccess().getGroup()); }
		(rule__LiteralNullExpression__Group__0)
		{ after(grammarAccess.getLiteralNullExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleNullPrimitiveInstanceType
entryRuleNullPrimitiveInstanceType
:
{ before(grammarAccess.getNullPrimitiveInstanceTypeRule()); }
	 ruleNullPrimitiveInstanceType
{ after(grammarAccess.getNullPrimitiveInstanceTypeRule()); } 
	 EOF 
;

// Rule NullPrimitiveInstanceType
ruleNullPrimitiveInstanceType 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getNullPrimitiveInstanceTypeAccess().getAlternatives()); }
		(rule__NullPrimitiveInstanceType__Alternatives)
		{ after(grammarAccess.getNullPrimitiveInstanceTypeAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLiteralCollectionExpression
entryRuleLiteralCollectionExpression
:
{ before(grammarAccess.getLiteralCollectionExpressionRule()); }
	 ruleLiteralCollectionExpression
{ after(grammarAccess.getLiteralCollectionExpressionRule()); } 
	 EOF 
;

// Rule LiteralCollectionExpression
ruleLiteralCollectionExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLiteralCollectionExpressionAccess().getGroup()); }
		(rule__LiteralCollectionExpression__Group__0)
		{ after(grammarAccess.getLiteralCollectionExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLiteralReferenceExpression
entryRuleLiteralReferenceExpression
:
{ before(grammarAccess.getLiteralReferenceExpressionRule()); }
	 ruleLiteralReferenceExpression
{ after(grammarAccess.getLiteralReferenceExpressionRule()); } 
	 EOF 
;

// Rule LiteralReferenceExpression
ruleLiteralReferenceExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLiteralReferenceExpressionAccess().getAlternatives()); }
		(rule__LiteralReferenceExpression__Alternatives)
		{ after(grammarAccess.getLiteralReferenceExpressionAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLiteralReferenceElement
entryRuleLiteralReferenceElement
:
{ before(grammarAccess.getLiteralReferenceElementRule()); }
	 ruleLiteralReferenceElement
{ after(grammarAccess.getLiteralReferenceElementRule()); } 
	 EOF 
;

// Rule LiteralReferenceElement
ruleLiteralReferenceElement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLiteralReferenceElementAccess().getGroup()); }
		(rule__LiteralReferenceElement__Group__0)
		{ after(grammarAccess.getLiteralReferenceElementAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLiteralPureReferenceElement
entryRuleLiteralPureReferenceElement
:
{ before(grammarAccess.getLiteralPureReferenceElementRule()); }
	 ruleLiteralPureReferenceElement
{ after(grammarAccess.getLiteralPureReferenceElementRule()); } 
	 EOF 
;

// Rule LiteralPureReferenceElement
ruleLiteralPureReferenceElement 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLiteralPureReferenceElementAccess().getGroup()); }
		(rule__LiteralPureReferenceElement__Group__0)
		{ after(grammarAccess.getLiteralPureReferenceElementAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLiteralReferenceVariableContext
entryRuleLiteralReferenceVariableContext
:
{ before(grammarAccess.getLiteralReferenceVariableContextRule()); }
	 ruleLiteralReferenceVariableContext
{ after(grammarAccess.getLiteralReferenceVariableContextRule()); } 
	 EOF 
;

// Rule LiteralReferenceVariableContext
ruleLiteralReferenceVariableContext 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLiteralReferenceVariableContextAccess().getAlternatives()); }
		(rule__LiteralReferenceVariableContext__Alternatives)
		{ after(grammarAccess.getLiteralReferenceVariableContextAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLiteralTimeExpression
entryRuleLiteralTimeExpression
:
{ before(grammarAccess.getLiteralTimeExpressionRule()); }
	 ruleLiteralTimeExpression
{ after(grammarAccess.getLiteralTimeExpressionRule()); } 
	 EOF 
;

// Rule LiteralTimeExpression
ruleLiteralTimeExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLiteralTimeExpressionAccess().getGroup()); }
		(rule__LiteralTimeExpression__Group__0)
		{ after(grammarAccess.getLiteralTimeExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLiteralTimeDeltaExpression
entryRuleLiteralTimeDeltaExpression
:
{ before(grammarAccess.getLiteralTimeDeltaExpressionRule()); }
	 ruleLiteralTimeDeltaExpression
{ after(grammarAccess.getLiteralTimeDeltaExpressionRule()); } 
	 EOF 
;

// Rule LiteralTimeDeltaExpression
ruleLiteralTimeDeltaExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLiteralTimeDeltaExpressionAccess().getGroup()); }
		(rule__LiteralTimeDeltaExpression__Group__0)
		{ after(grammarAccess.getLiteralTimeDeltaExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLiteralReferenceMachineContext
entryRuleLiteralReferenceMachineContext
:
{ before(grammarAccess.getLiteralReferenceMachineContextRule()); }
	 ruleLiteralReferenceMachineContext
{ after(grammarAccess.getLiteralReferenceMachineContextRule()); } 
	 EOF 
;

// Rule LiteralReferenceMachineContext
ruleLiteralReferenceMachineContext 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLiteralReferenceMachineContextAccess().getAlternatives()); }
		(rule__LiteralReferenceMachineContext__Alternatives)
		{ after(grammarAccess.getLiteralReferenceMachineContextAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLiteralThisExpression
entryRuleLiteralThisExpression
:
{ before(grammarAccess.getLiteralThisExpressionRule()); }
	 ruleLiteralThisExpression
{ after(grammarAccess.getLiteralThisExpressionRule()); } 
	 EOF 
;

// Rule LiteralThisExpression
ruleLiteralThisExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLiteralThisExpressionAccess().getGroup()); }
		(rule__LiteralThisExpression__Group__0)
		{ after(grammarAccess.getLiteralThisExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLiteralSelfExpression
entryRuleLiteralSelfExpression
:
{ before(grammarAccess.getLiteralSelfExpressionRule()); }
	 ruleLiteralSelfExpression
{ after(grammarAccess.getLiteralSelfExpressionRule()); } 
	 EOF 
;

// Rule LiteralSelfExpression
ruleLiteralSelfExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLiteralSelfExpressionAccess().getGroup()); }
		(rule__LiteralSelfExpression__Group__0)
		{ after(grammarAccess.getLiteralSelfExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLiteralParentExpression
entryRuleLiteralParentExpression
:
{ before(grammarAccess.getLiteralParentExpressionRule()); }
	 ruleLiteralParentExpression
{ after(grammarAccess.getLiteralParentExpressionRule()); } 
	 EOF 
;

// Rule LiteralParentExpression
ruleLiteralParentExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLiteralParentExpressionAccess().getGroup()); }
		(rule__LiteralParentExpression__Group__0)
		{ after(grammarAccess.getLiteralParentExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLiteralSuperExpression
entryRuleLiteralSuperExpression
:
{ before(grammarAccess.getLiteralSuperExpressionRule()); }
	 ruleLiteralSuperExpression
{ after(grammarAccess.getLiteralSuperExpressionRule()); } 
	 EOF 
;

// Rule LiteralSuperExpression
ruleLiteralSuperExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLiteralSuperExpressionAccess().getGroup()); }
		(rule__LiteralSuperExpression__Group__0)
		{ after(grammarAccess.getLiteralSuperExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLiteralSystemExpression
entryRuleLiteralSystemExpression
:
{ before(grammarAccess.getLiteralSystemExpressionRule()); }
	 ruleLiteralSystemExpression
{ after(grammarAccess.getLiteralSystemExpressionRule()); } 
	 EOF 
;

// Rule LiteralSystemExpression
ruleLiteralSystemExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLiteralSystemExpressionAccess().getGroup()); }
		(rule__LiteralSystemExpression__Group__0)
		{ after(grammarAccess.getLiteralSystemExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLiteralEnvExpression
entryRuleLiteralEnvExpression
:
{ before(grammarAccess.getLiteralEnvExpressionRule()); }
	 ruleLiteralEnvExpression
{ after(grammarAccess.getLiteralEnvExpressionRule()); } 
	 EOF 
;

// Rule LiteralEnvExpression
ruleLiteralEnvExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLiteralEnvExpressionAccess().getGroup()); }
		(rule__LiteralEnvExpression__Group__0)
		{ after(grammarAccess.getLiteralEnvExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleLiteralPureReferenceExpression
entryRuleLiteralPureReferenceExpression
:
{ before(grammarAccess.getLiteralPureReferenceExpressionRule()); }
	 ruleLiteralPureReferenceExpression
{ after(grammarAccess.getLiteralPureReferenceExpressionRule()); } 
	 EOF 
;

// Rule LiteralPureReferenceExpression
ruleLiteralPureReferenceExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getLiteralPureReferenceExpressionAccess().getAlternatives()); }
		(rule__LiteralPureReferenceExpression__Alternatives)
		{ after(grammarAccess.getLiteralPureReferenceExpressionAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleValueSelectionExpression
entryRuleValueSelectionExpression
:
{ before(grammarAccess.getValueSelectionExpressionRule()); }
	 ruleValueSelectionExpression
{ after(grammarAccess.getValueSelectionExpressionRule()); } 
	 EOF 
;

// Rule ValueSelectionExpression
ruleValueSelectionExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getValueSelectionExpressionAccess().getGroup()); }
		(rule__ValueSelectionExpression__Group__0)
		{ after(grammarAccess.getValueSelectionExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Entry rule entryRuleValuePureNamedMachineExpression
entryRuleValuePureNamedMachineExpression
:
{ before(grammarAccess.getValuePureNamedMachineExpressionRule()); }
	 ruleValuePureNamedMachineExpression
{ after(grammarAccess.getValuePureNamedMachineExpressionRule()); } 
	 EOF 
;

// Rule ValuePureNamedMachineExpression
ruleValuePureNamedMachineExpression 
	@init {
		int stackSize = keepStackSize();
	}
	:
	(
		{ before(grammarAccess.getValuePureNamedMachineExpressionAccess().getGroup()); }
		(rule__ValuePureNamedMachineExpression__Group__0)
		{ after(grammarAccess.getValuePureNamedMachineExpressionAccess().getGroup()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule VisibilityKind
ruleVisibilityKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVisibilityKindAccess().getAlternatives()); }
		(rule__VisibilityKind__Alternatives)
		{ after(grammarAccess.getVisibilityKindAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule DesignKind
ruleDesignKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getDesignKindAccess().getAlternatives()); }
		(rule__DesignKind__Alternatives)
		{ after(grammarAccess.getDesignKindAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule PseudostateKind
rulePseudostateKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPseudostateKindAccess().getAlternatives()); }
		(rule__PseudostateKind__Alternatives)
		{ after(grammarAccess.getPseudostateKindAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule PseudostateInitialKind
rulePseudostateInitialKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPseudostateInitialKindAccess().getInitialEnumLiteralDeclaration()); }
		('initial')
		{ after(grammarAccess.getPseudostateInitialKindAccess().getInitialEnumLiteralDeclaration()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule EndingPseudostateKind
ruleEndingPseudostateKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEndingPseudostateKindAccess().getAlternatives()); }
		(rule__EndingPseudostateKind__Alternatives)
		{ after(grammarAccess.getEndingPseudostateKindAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule ComProtocolKind
ruleComProtocolKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getComProtocolKindAccess().getAlternatives()); }
		(rule__ComProtocolKind__Alternatives)
		{ after(grammarAccess.getComProtocolKindAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule ComEnvRdvProtocolKind
ruleComEnvRdvProtocolKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getComEnvRdvProtocolKindAccess().getAlternatives()); }
		(rule__ComEnvRdvProtocolKind__Alternatives)
		{ after(grammarAccess.getComEnvRdvProtocolKindAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule ComMultiRdvProtocolKind
ruleComMultiRdvProtocolKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getComMultiRdvProtocolKindAccess().getMulti_rdvEnumLiteralDeclaration()); }
		('multi_rdv')
		{ after(grammarAccess.getComMultiRdvProtocolKindAccess().getMulti_rdvEnumLiteralDeclaration()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule BufferProtocolKind
ruleBufferProtocolKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBufferProtocolKindAccess().getBufferEnumLiteralDeclaration()); }
		('buffer')
		{ after(grammarAccess.getBufferProtocolKindAccess().getBufferEnumLiteralDeclaration()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule ComCastKing
ruleComCastKing
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getComCastKingAccess().getAlternatives()); }
		(rule__ComCastKing__Alternatives)
		{ after(grammarAccess.getComCastKingAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule PrimitiveNumberSign
rulePrimitiveNumberSign
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimitiveNumberSignAccess().getAlternatives()); }
		(rule__PrimitiveNumberSign__Alternatives)
		{ after(grammarAccess.getPrimitiveNumberSignAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule PrimitiveInstanceKind
rulePrimitiveInstanceKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimitiveInstanceKindAccess().getAlternatives()); }
		(rule__PrimitiveInstanceKind__Alternatives)
		{ after(grammarAccess.getPrimitiveInstanceKindAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule CollectionKind
ruleCollectionKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getCollectionKindAccess().getAlternatives()); }
		(rule__CollectionKind__Alternatives)
		{ after(grammarAccess.getCollectionKindAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule PublicVariableVisibilityKind
rulePublicVariableVisibilityKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPublicVariableVisibilityKindAccess().getPublicEnumLiteralDeclaration()); }
		('var')
		{ after(grammarAccess.getPublicVariableVisibilityKindAccess().getPublicEnumLiteralDeclaration()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule ProtectedVariableVisibilityKind
ruleProtectedVariableVisibilityKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getProtectedVariableVisibilityKindAccess().getProtectedEnumLiteralDeclaration()); }
		('var')
		{ after(grammarAccess.getProtectedVariableVisibilityKindAccess().getProtectedEnumLiteralDeclaration()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule PrivateVariableVisibilityKind
rulePrivateVariableVisibilityKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrivateVariableVisibilityKindAccess().getPrivateEnumLiteralDeclaration()); }
		('var')
		{ after(grammarAccess.getPrivateVariableVisibilityKindAccess().getPrivateEnumLiteralDeclaration()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule ParameterDirectionKind
ruleParameterDirectionKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getParameterDirectionKindAccess().getAlternatives()); }
		(rule__ParameterDirectionKind__Alternatives)
		{ after(grammarAccess.getParameterDirectionKindAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule BlockParameterDirectionKind
ruleBlockParameterDirectionKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBlockParameterDirectionKindAccess().getAlternatives()); }
		(rule__BlockParameterDirectionKind__Alternatives)
		{ after(grammarAccess.getBlockParameterDirectionKindAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule ParameterInputDirectionKind
ruleParameterInputDirectionKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getParameterInputDirectionKindAccess().getInEnumLiteralDeclaration()); }
		('var')
		{ after(grammarAccess.getParameterInputDirectionKindAccess().getInEnumLiteralDeclaration()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule ParameterInoutDirectionKind
ruleParameterInoutDirectionKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getParameterInoutDirectionKindAccess().getInoutEnumLiteralDeclaration()); }
		('var')
		{ after(grammarAccess.getParameterInoutDirectionKindAccess().getInoutEnumLiteralDeclaration()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule ParameterOutputDirectionKind
ruleParameterOutputDirectionKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getParameterOutputDirectionKindAccess().getOutEnumLiteralDeclaration()); }
		('var')
		{ after(grammarAccess.getParameterOutputDirectionKindAccess().getOutEnumLiteralDeclaration()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule ParameterReturnDirectionKind
ruleParameterReturnDirectionKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getParameterReturnDirectionKindAccess().getReturnEnumLiteralDeclaration()); }
		('var')
		{ after(grammarAccess.getParameterReturnDirectionKindAccess().getReturnEnumLiteralDeclaration()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule BufferContainerKind
ruleBufferContainerKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBufferContainerKindAccess().getAlternatives()); }
		(rule__BufferContainerKind__Alternatives)
		{ after(grammarAccess.getBufferContainerKindAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule PublicBufferVisibilityKind
rulePublicBufferVisibilityKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPublicBufferVisibilityKindAccess().getPublicEnumLiteralDeclaration()); }
		('buffer')
		{ after(grammarAccess.getPublicBufferVisibilityKindAccess().getPublicEnumLiteralDeclaration()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule ProtectedBufferVisibilityKind
ruleProtectedBufferVisibilityKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getProtectedBufferVisibilityKindAccess().getProtectedEnumLiteralDeclaration()); }
		('buffer')
		{ after(grammarAccess.getProtectedBufferVisibilityKindAccess().getProtectedEnumLiteralDeclaration()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule PrivateBufferVisibilityKind
rulePrivateBufferVisibilityKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrivateBufferVisibilityKindAccess().getPrivateEnumLiteralDeclaration()); }
		('buffer')
		{ after(grammarAccess.getPrivateBufferVisibilityKindAccess().getPrivateEnumLiteralDeclaration()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule PublicPortVisibilityKind
rulePublicPortVisibilityKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPublicPortVisibilityKindAccess().getPublicEnumLiteralDeclaration()); }
		('port')
		{ after(grammarAccess.getPublicPortVisibilityKindAccess().getPublicEnumLiteralDeclaration()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule ProtectedPortVisibilityKind
ruleProtectedPortVisibilityKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getProtectedPortVisibilityKindAccess().getProtectedEnumLiteralDeclaration()); }
		('port')
		{ after(grammarAccess.getProtectedPortVisibilityKindAccess().getProtectedEnumLiteralDeclaration()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule PrivatePortVisibilityKind
rulePrivatePortVisibilityKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrivatePortVisibilityKindAccess().getPrivateEnumLiteralDeclaration()); }
		('port')
		{ after(grammarAccess.getPrivatePortVisibilityKindAccess().getPrivateEnumLiteralDeclaration()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule PublicSignalVisibilityKind
rulePublicSignalVisibilityKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPublicSignalVisibilityKindAccess().getPublicEnumLiteralDeclaration()); }
		('signal')
		{ after(grammarAccess.getPublicSignalVisibilityKindAccess().getPublicEnumLiteralDeclaration()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule ProtectedSignalVisibilityKind
ruleProtectedSignalVisibilityKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getProtectedSignalVisibilityKindAccess().getProtectedEnumLiteralDeclaration()); }
		('signal')
		{ after(grammarAccess.getProtectedSignalVisibilityKindAccess().getProtectedEnumLiteralDeclaration()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule PrivateSignalVisibilityKind
rulePrivateSignalVisibilityKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrivateSignalVisibilityKindAccess().getPrivateEnumLiteralDeclaration()); }
		('signal')
		{ after(grammarAccess.getPrivateSignalVisibilityKindAccess().getPrivateEnumLiteralDeclaration()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule ChannelDirection
ruleChannelDirection
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getChannelDirectionAccess().getAlternatives()); }
		(rule__ChannelDirection__Alternatives)
		{ after(grammarAccess.getChannelDirectionAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule PublicChannelVisibilityKind
rulePublicChannelVisibilityKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPublicChannelVisibilityKindAccess().getPublicEnumLiteralDeclaration()); }
		('channel')
		{ after(grammarAccess.getPublicChannelVisibilityKindAccess().getPublicEnumLiteralDeclaration()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule ProtectedChannelVisibilityKind
ruleProtectedChannelVisibilityKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getProtectedChannelVisibilityKindAccess().getProtectedEnumLiteralDeclaration()); }
		('channel')
		{ after(grammarAccess.getProtectedChannelVisibilityKindAccess().getProtectedEnumLiteralDeclaration()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule PrivateChannelVisibilityKind
rulePrivateChannelVisibilityKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrivateChannelVisibilityKindAccess().getPrivateEnumLiteralDeclaration()); }
		('channel')
		{ after(grammarAccess.getPrivateChannelVisibilityKindAccess().getPrivateEnumLiteralDeclaration()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule TransitionMoc
ruleTransitionMoc
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTransitionMocAccess().getAlternatives()); }
		(rule__TransitionMoc__Alternatives)
		{ after(grammarAccess.getTransitionMocAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule InterruptStatementKind
ruleInterruptStatementKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getInterruptStatementKindAccess().getAlternatives()); }
		(rule__InterruptStatementKind__Alternatives)
		{ after(grammarAccess.getInterruptStatementKindAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule OPERATOR_ACTIVITY
ruleOPERATOR_ACTIVITY
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getOPERATOR_ACTIVITYAccess().getAlternatives()); }
		(rule__OPERATOR_ACTIVITY__Alternatives)
		{ after(grammarAccess.getOPERATOR_ACTIVITYAccess().getAlternatives()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule AnyPrimitiveInstanceKind
ruleAnyPrimitiveInstanceKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAnyPrimitiveInstanceKindAccess().getAnyEnumLiteralDeclaration()); }
		('$null')
		{ after(grammarAccess.getAnyPrimitiveInstanceKindAccess().getAnyEnumLiteralDeclaration()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule ValueDotFieldExpressionKind
ruleValueDotFieldExpressionKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getValueDotFieldExpressionKindAccess().getFieldEnumLiteralDeclaration()); }
		('.')
		{ after(grammarAccess.getValueDotFieldExpressionKindAccess().getFieldEnumLiteralDeclaration()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule ValueArrowFieldExpressionKind
ruleValueArrowFieldExpressionKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getValueArrowFieldExpressionKindAccess().getFieldEnumLiteralDeclaration()); }
		('->')
		{ after(grammarAccess.getValueArrowFieldExpressionKindAccess().getFieldEnumLiteralDeclaration()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule ValueIndexExpressionKind
ruleValueIndexExpressionKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getValueIndexExpressionKindAccess().getIndexEnumLiteralDeclaration()); }
		('[')
		{ after(grammarAccess.getValueIndexExpressionKindAccess().getIndexEnumLiteralDeclaration()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

// Rule ValueParameterExpressionKind
ruleValueParameterExpressionKind
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getValueParameterExpressionKindAccess().getParameterEnumLiteralDeclaration()); }
		('(')
		{ after(grammarAccess.getValueParameterExpressionKindAccess().getParameterEnumLiteralDeclaration()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaPrologObject__NameAlternatives_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getXliaPrologObjectAccess().getNameFormalMLKeyword_0_0_0()); }
		'@FormalML'
		{ after(grammarAccess.getXliaPrologObjectAccess().getNameFormalMLKeyword_0_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getXliaPrologObjectAccess().getNameXliaKeyword_0_0_1()); }
		'@xlia'
		{ after(grammarAccess.getXliaPrologObjectAccess().getNameXliaKeyword_0_0_1()); }
	)
	|
	(
		{ before(grammarAccess.getXliaPrologObjectAccess().getNameXfspKeyword_0_0_2()); }
		'@xfsp'
		{ after(grammarAccess.getXliaPrologObjectAccess().getNameXfspKeyword_0_0_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaPrologAttribute__NameAlternatives_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getXliaPrologAttributeAccess().getNameSystemKeyword_0_0_0()); }
		'system'
		{ after(grammarAccess.getXliaPrologAttributeAccess().getNameSystemKeyword_0_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getXliaPrologAttributeAccess().getNamePackageKeyword_0_0_1()); }
		'package'
		{ after(grammarAccess.getXliaPrologAttributeAccess().getNamePackageKeyword_0_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaPrologAttribute__ValueAlternatives_1_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getXliaPrologAttributeAccess().getValueLiteralFloatExpressionParserRuleCall_1_1_0_0()); }
		ruleLiteralFloatExpression
		{ after(grammarAccess.getXliaPrologAttributeAccess().getValueLiteralFloatExpressionParserRuleCall_1_1_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getXliaPrologAttributeAccess().getValueLiteralStringExpressionParserRuleCall_1_1_0_1()); }
		ruleLiteralStringExpression
		{ after(grammarAccess.getXliaPrologAttributeAccess().getValueLiteralStringExpressionParserRuleCall_1_1_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaNamedElement__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getXliaNamedElementAccess().getXliaObjectParserRuleCall_0()); }
		ruleXliaObject
		{ after(grammarAccess.getXliaNamedElementAccess().getXliaObjectParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getXliaNamedElementAccess().getXliaAttributeParserRuleCall_1()); }
		ruleXliaAttribute
		{ after(grammarAccess.getXliaNamedElementAccess().getXliaAttributeParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__EBoolean__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEBooleanAccess().getTrueKeyword_0()); }
		'true'
		{ after(grammarAccess.getEBooleanAccess().getTrueKeyword_0()); }
	)
	|
	(
		{ before(grammarAccess.getEBooleanAccess().getFalseKeyword_1()); }
		'false'
		{ after(grammarAccess.getEBooleanAccess().getFalseKeyword_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ESUfid__Alternatives_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getESUfidAccess().getFullStopKeyword_1_0_0()); }
		'.'
		{ after(grammarAccess.getESUfidAccess().getFullStopKeyword_1_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getESUfidAccess().getColonKeyword_1_0_1()); }
		':'
		{ after(grammarAccess.getESUfidAccess().getColonKeyword_1_0_1()); }
	)
	|
	(
		{ before(grammarAccess.getESUfidAccess().getColonColonKeyword_1_0_2()); }
		'::'
		{ after(grammarAccess.getESUfidAccess().getColonColonKeyword_1_0_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Alternatives_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSystemAccess().getTimedAssignment_0_1_0()); }
		(rule__System__TimedAssignment_0_1_0)
		{ after(grammarAccess.getSystemAccess().getTimedAssignment_0_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getInput_enabledAssignment_0_1_1()); }
		(rule__System__Input_enabledAssignment_0_1_1)
		{ after(grammarAccess.getSystemAccess().getInput_enabledAssignment_0_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Alternatives_2_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSystemAccess().getAndKeyword_2_2_0()); }
		'and'
		{ after(grammarAccess.getSystemAccess().getAndKeyword_2_2_0()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getOrKeyword_2_2_1()); }
		'or'
		{ after(grammarAccess.getSystemAccess().getOrKeyword_2_2_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Alternatives_6
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSystemAccess().getPortAssignment_6_0()); }
		(rule__System__PortAssignment_6_0)
		{ after(grammarAccess.getSystemAccess().getPortAssignment_6_0()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getSignalAssignment_6_1()); }
		(rule__System__SignalAssignment_6_1)
		{ after(grammarAccess.getSystemAccess().getSignalAssignment_6_1()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getBufferAssignment_6_2()); }
		(rule__System__BufferAssignment_6_2)
		{ after(grammarAccess.getSystemAccess().getBufferAssignment_6_2()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getChannelAssignment_6_3()); }
		(rule__System__ChannelAssignment_6_3)
		{ after(grammarAccess.getSystemAccess().getChannelAssignment_6_3()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getTypedefAssignment_6_4()); }
		(rule__System__TypedefAssignment_6_4)
		{ after(grammarAccess.getSystemAccess().getTypedefAssignment_6_4()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getPropertyAssignment_6_5()); }
		(rule__System__PropertyAssignment_6_5)
		{ after(grammarAccess.getSystemAccess().getPropertyAssignment_6_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Alternatives_7
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSystemAccess().getGroup_7_0()); }
		(rule__System__Group_7_0__0)
		{ after(grammarAccess.getSystemAccess().getGroup_7_0()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getGroup_7_1()); }
		(rule__System__Group_7_1__0)
		{ after(grammarAccess.getSystemAccess().getGroup_7_1()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getGroup_7_2()); }
		(rule__System__Group_7_2__0)
		{ after(grammarAccess.getSystemAccess().getGroup_7_2()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getGroup_7_3()); }
		(rule__System__Group_7_3__0)
		{ after(grammarAccess.getSystemAccess().getGroup_7_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Alternatives_7_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSystemAccess().getPortAssignment_7_0_1_0()); }
		(rule__System__PortAssignment_7_0_1_0)
		{ after(grammarAccess.getSystemAccess().getPortAssignment_7_0_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getSignalAssignment_7_0_1_1()); }
		(rule__System__SignalAssignment_7_0_1_1)
		{ after(grammarAccess.getSystemAccess().getSignalAssignment_7_0_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getBufferAssignment_7_0_1_2()); }
		(rule__System__BufferAssignment_7_0_1_2)
		{ after(grammarAccess.getSystemAccess().getBufferAssignment_7_0_1_2()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getChannelAssignment_7_0_1_3()); }
		(rule__System__ChannelAssignment_7_0_1_3)
		{ after(grammarAccess.getSystemAccess().getChannelAssignment_7_0_1_3()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getTypedefAssignment_7_0_1_4()); }
		(rule__System__TypedefAssignment_7_0_1_4)
		{ after(grammarAccess.getSystemAccess().getTypedefAssignment_7_0_1_4()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getPropertyAssignment_7_0_1_5()); }
		(rule__System__PropertyAssignment_7_0_1_5)
		{ after(grammarAccess.getSystemAccess().getPropertyAssignment_7_0_1_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Alternatives_7_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSystemAccess().getPortAssignment_7_1_1_0()); }
		(rule__System__PortAssignment_7_1_1_0)
		{ after(grammarAccess.getSystemAccess().getPortAssignment_7_1_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getSignalAssignment_7_1_1_1()); }
		(rule__System__SignalAssignment_7_1_1_1)
		{ after(grammarAccess.getSystemAccess().getSignalAssignment_7_1_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getBufferAssignment_7_1_1_2()); }
		(rule__System__BufferAssignment_7_1_1_2)
		{ after(grammarAccess.getSystemAccess().getBufferAssignment_7_1_1_2()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getChannelAssignment_7_1_1_3()); }
		(rule__System__ChannelAssignment_7_1_1_3)
		{ after(grammarAccess.getSystemAccess().getChannelAssignment_7_1_1_3()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getTypedefAssignment_7_1_1_4()); }
		(rule__System__TypedefAssignment_7_1_1_4)
		{ after(grammarAccess.getSystemAccess().getTypedefAssignment_7_1_1_4()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getPropertyAssignment_7_1_1_5()); }
		(rule__System__PropertyAssignment_7_1_1_5)
		{ after(grammarAccess.getSystemAccess().getPropertyAssignment_7_1_1_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Alternatives_7_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSystemAccess().getPortAssignment_7_2_1_0()); }
		(rule__System__PortAssignment_7_2_1_0)
		{ after(grammarAccess.getSystemAccess().getPortAssignment_7_2_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getSignalAssignment_7_2_1_1()); }
		(rule__System__SignalAssignment_7_2_1_1)
		{ after(grammarAccess.getSystemAccess().getSignalAssignment_7_2_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getBufferAssignment_7_2_1_2()); }
		(rule__System__BufferAssignment_7_2_1_2)
		{ after(grammarAccess.getSystemAccess().getBufferAssignment_7_2_1_2()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getChannelAssignment_7_2_1_3()); }
		(rule__System__ChannelAssignment_7_2_1_3)
		{ after(grammarAccess.getSystemAccess().getChannelAssignment_7_2_1_3()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getTypedefAssignment_7_2_1_4()); }
		(rule__System__TypedefAssignment_7_2_1_4)
		{ after(grammarAccess.getSystemAccess().getTypedefAssignment_7_2_1_4()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getPropertyAssignment_7_2_1_5()); }
		(rule__System__PropertyAssignment_7_2_1_5)
		{ after(grammarAccess.getSystemAccess().getPropertyAssignment_7_2_1_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Alternatives_7_3_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSystemAccess().getPortAssignment_7_3_1_0()); }
		(rule__System__PortAssignment_7_3_1_0)
		{ after(grammarAccess.getSystemAccess().getPortAssignment_7_3_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getSignalAssignment_7_3_1_1()); }
		(rule__System__SignalAssignment_7_3_1_1)
		{ after(grammarAccess.getSystemAccess().getSignalAssignment_7_3_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getBufferAssignment_7_3_1_2()); }
		(rule__System__BufferAssignment_7_3_1_2)
		{ after(grammarAccess.getSystemAccess().getBufferAssignment_7_3_1_2()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getChannelAssignment_7_3_1_3()); }
		(rule__System__ChannelAssignment_7_3_1_3)
		{ after(grammarAccess.getSystemAccess().getChannelAssignment_7_3_1_3()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getTypedefAssignment_7_3_1_4()); }
		(rule__System__TypedefAssignment_7_3_1_4)
		{ after(grammarAccess.getSystemAccess().getTypedefAssignment_7_3_1_4()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getPropertyAssignment_7_3_1_5()); }
		(rule__System__PropertyAssignment_7_3_1_5)
		{ after(grammarAccess.getSystemAccess().getPropertyAssignment_7_3_1_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Alternatives_8
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSystemAccess().getAlternatives_8_0()); }
		(rule__System__Alternatives_8_0)*
		{ after(grammarAccess.getSystemAccess().getAlternatives_8_0()); }
	)
	|
	(
		(
			{ before(grammarAccess.getSystemAccess().getAlternatives_8_1()); }
			(rule__System__Alternatives_8_1)
			{ after(grammarAccess.getSystemAccess().getAlternatives_8_1()); }
		)
		(
			{ before(grammarAccess.getSystemAccess().getAlternatives_8_1()); }
			(rule__System__Alternatives_8_1)*
			{ after(grammarAccess.getSystemAccess().getAlternatives_8_1()); }
		)
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Alternatives_8_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSystemAccess().getGroup_8_0_0()); }
		(rule__System__Group_8_0_0__0)
		{ after(grammarAccess.getSystemAccess().getGroup_8_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getGroup_8_0_1()); }
		(rule__System__Group_8_0_1__0)
		{ after(grammarAccess.getSystemAccess().getGroup_8_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Alternatives_8_0_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSystemAccess().getRoutineKeyword_8_0_0_0_0()); }
		'@routine:'
		{ after(grammarAccess.getSystemAccess().getRoutineKeyword_8_0_0_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getMacroKeyword_8_0_0_0_1()); }
		'@macro:'
		{ after(grammarAccess.getSystemAccess().getMacroKeyword_8_0_0_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Alternatives_8_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSystemAccess().getRoutineAssignment_8_1_0()); }
		(rule__System__RoutineAssignment_8_1_0)
		{ after(grammarAccess.getSystemAccess().getRoutineAssignment_8_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getProcedureAssignment_8_1_1()); }
		(rule__System__ProcedureAssignment_8_1_1)
		{ after(grammarAccess.getSystemAccess().getProcedureAssignment_8_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Alternatives_9
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSystemAccess().getGroup_9_0()); }
		(rule__System__Group_9_0__0)
		{ after(grammarAccess.getSystemAccess().getGroup_9_0()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getGroup_9_1()); }
		(rule__System__Group_9_1__0)
		{ after(grammarAccess.getSystemAccess().getGroup_9_1()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getGroup_9_2()); }
		(rule__System__Group_9_2__0)
		{ after(grammarAccess.getSystemAccess().getGroup_9_2()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getGroup_9_3()); }
		(rule__System__Group_9_3__0)
		{ after(grammarAccess.getSystemAccess().getGroup_9_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Alternatives_9_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSystemAccess().getCompositeKeyword_9_0_0_0()); }
		'@composite:'
		{ after(grammarAccess.getSystemAccess().getCompositeKeyword_9_0_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getMachineKeyword_9_0_0_1()); }
		'@machine:'
		{ after(grammarAccess.getSystemAccess().getMachineKeyword_9_0_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Alternatives_9_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSystemAccess().getMachineAssignment_9_0_1_0()); }
		(rule__System__MachineAssignment_9_0_1_0)
		{ after(grammarAccess.getSystemAccess().getMachineAssignment_9_0_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getInstanceAssignment_9_0_1_1()); }
		(rule__System__InstanceAssignment_9_0_1_1)
		{ after(grammarAccess.getSystemAccess().getInstanceAssignment_9_0_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Alternatives_10
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSystemAccess().getGroup_10_0()); }
		(rule__System__Group_10_0__0)
		{ after(grammarAccess.getSystemAccess().getGroup_10_0()); }
	)
	|
	(
		{ before(grammarAccess.getSystemAccess().getGroup_10_1()); }
		(rule__System__Group_10_1__0)
		{ after(grammarAccess.getSystemAccess().getGroup_10_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AnyMachineBlock__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAnyMachineBlockAccess().getMachineBlockParserRuleCall_0()); }
		ruleMachineBlock
		{ after(grammarAccess.getAnyMachineBlockAccess().getMachineBlockParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getAnyMachineBlockAccess().getStatemachineParserRuleCall_1()); }
		ruleStatemachine
		{ after(grammarAccess.getAnyMachineBlockAccess().getStatemachineParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getInstanceMachineAccess().getMachineKeyword_1_0()); }
		'machine'
		{ after(grammarAccess.getInstanceMachineAccess().getMachineKeyword_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getInstanceMachineAccess().getStatemachineKeyword_1_1()); }
		'statemachine'
		{ after(grammarAccess.getInstanceMachineAccess().getStatemachineKeyword_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Alternatives_8
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getInstanceMachineAccess().getGroup_8_0()); }
		(rule__InstanceMachine__Group_8_0__0)
		{ after(grammarAccess.getInstanceMachineAccess().getGroup_8_0()); }
	)
	|
	(
		{ before(grammarAccess.getInstanceMachineAccess().getGroup_8_1()); }
		(rule__InstanceMachine__Group_8_1__0)
		{ after(grammarAccess.getInstanceMachineAccess().getGroup_8_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SlotParameter__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSlotParameterAccess().getColonKeyword_1_0()); }
		':'
		{ after(grammarAccess.getSlotParameterAccess().getColonKeyword_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getSlotParameterAccess().getEqualsSignKeyword_1_1()); }
		'='
		{ after(grammarAccess.getSlotParameterAccess().getEqualsSignKeyword_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getSlotParameterAccess().getColonEqualsSignKeyword_1_2()); }
		':='
		{ after(grammarAccess.getSlotParameterAccess().getColonEqualsSignKeyword_1_2()); }
	)
	|
	(
		{ before(grammarAccess.getSlotParameterAccess().getColonColonEqualsSignKeyword_1_3()); }
		'::='
		{ after(grammarAccess.getSlotParameterAccess().getColonColonEqualsSignKeyword_1_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SlotProperty__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSlotPropertyAccess().getEqualsSignKeyword_1_0()); }
		'='
		{ after(grammarAccess.getSlotPropertyAccess().getEqualsSignKeyword_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getSlotPropertyAccess().getColonKeyword_1_1()); }
		':'
		{ after(grammarAccess.getSlotPropertyAccess().getColonKeyword_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getSlotPropertyAccess().getColonEqualsSignKeyword_1_2()); }
		':='
		{ after(grammarAccess.getSlotPropertyAccess().getColonEqualsSignKeyword_1_2()); }
	)
	|
	(
		{ before(grammarAccess.getSlotPropertyAccess().getColonColonEqualsSignKeyword_1_3()); }
		'::='
		{ after(grammarAccess.getSlotPropertyAccess().getColonColonEqualsSignKeyword_1_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Alternatives_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMachineBlockAccess().getTimedAssignment_0_1_0()); }
		(rule__MachineBlock__TimedAssignment_0_1_0)
		{ after(grammarAccess.getMachineBlockAccess().getTimedAssignment_0_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getInput_enabledAssignment_0_1_1()); }
		(rule__MachineBlock__Input_enabledAssignment_0_1_1)
		{ after(grammarAccess.getMachineBlockAccess().getInput_enabledAssignment_0_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Alternatives_2_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMachineBlockAccess().getAndKeyword_2_2_0()); }
		'and'
		{ after(grammarAccess.getMachineBlockAccess().getAndKeyword_2_2_0()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getOrKeyword_2_2_1()); }
		'or'
		{ after(grammarAccess.getMachineBlockAccess().getOrKeyword_2_2_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Alternatives_6
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMachineBlockAccess().getPortAssignment_6_0()); }
		(rule__MachineBlock__PortAssignment_6_0)
		{ after(grammarAccess.getMachineBlockAccess().getPortAssignment_6_0()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getSignalAssignment_6_1()); }
		(rule__MachineBlock__SignalAssignment_6_1)
		{ after(grammarAccess.getMachineBlockAccess().getSignalAssignment_6_1()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getBufferAssignment_6_2()); }
		(rule__MachineBlock__BufferAssignment_6_2)
		{ after(grammarAccess.getMachineBlockAccess().getBufferAssignment_6_2()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getChannelAssignment_6_3()); }
		(rule__MachineBlock__ChannelAssignment_6_3)
		{ after(grammarAccess.getMachineBlockAccess().getChannelAssignment_6_3()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getTypedefAssignment_6_4()); }
		(rule__MachineBlock__TypedefAssignment_6_4)
		{ after(grammarAccess.getMachineBlockAccess().getTypedefAssignment_6_4()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getPropertyAssignment_6_5()); }
		(rule__MachineBlock__PropertyAssignment_6_5)
		{ after(grammarAccess.getMachineBlockAccess().getPropertyAssignment_6_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Alternatives_7
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMachineBlockAccess().getGroup_7_0()); }
		(rule__MachineBlock__Group_7_0__0)
		{ after(grammarAccess.getMachineBlockAccess().getGroup_7_0()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getGroup_7_1()); }
		(rule__MachineBlock__Group_7_1__0)
		{ after(grammarAccess.getMachineBlockAccess().getGroup_7_1()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getGroup_7_2()); }
		(rule__MachineBlock__Group_7_2__0)
		{ after(grammarAccess.getMachineBlockAccess().getGroup_7_2()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getGroup_7_3()); }
		(rule__MachineBlock__Group_7_3__0)
		{ after(grammarAccess.getMachineBlockAccess().getGroup_7_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Alternatives_7_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMachineBlockAccess().getPortAssignment_7_0_1_0()); }
		(rule__MachineBlock__PortAssignment_7_0_1_0)
		{ after(grammarAccess.getMachineBlockAccess().getPortAssignment_7_0_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getSignalAssignment_7_0_1_1()); }
		(rule__MachineBlock__SignalAssignment_7_0_1_1)
		{ after(grammarAccess.getMachineBlockAccess().getSignalAssignment_7_0_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getBufferAssignment_7_0_1_2()); }
		(rule__MachineBlock__BufferAssignment_7_0_1_2)
		{ after(grammarAccess.getMachineBlockAccess().getBufferAssignment_7_0_1_2()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getChannelAssignment_7_0_1_3()); }
		(rule__MachineBlock__ChannelAssignment_7_0_1_3)
		{ after(grammarAccess.getMachineBlockAccess().getChannelAssignment_7_0_1_3()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getTypedefAssignment_7_0_1_4()); }
		(rule__MachineBlock__TypedefAssignment_7_0_1_4)
		{ after(grammarAccess.getMachineBlockAccess().getTypedefAssignment_7_0_1_4()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getPropertyAssignment_7_0_1_5()); }
		(rule__MachineBlock__PropertyAssignment_7_0_1_5)
		{ after(grammarAccess.getMachineBlockAccess().getPropertyAssignment_7_0_1_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Alternatives_7_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMachineBlockAccess().getPortAssignment_7_1_1_0()); }
		(rule__MachineBlock__PortAssignment_7_1_1_0)
		{ after(grammarAccess.getMachineBlockAccess().getPortAssignment_7_1_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getSignalAssignment_7_1_1_1()); }
		(rule__MachineBlock__SignalAssignment_7_1_1_1)
		{ after(grammarAccess.getMachineBlockAccess().getSignalAssignment_7_1_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getBufferAssignment_7_1_1_2()); }
		(rule__MachineBlock__BufferAssignment_7_1_1_2)
		{ after(grammarAccess.getMachineBlockAccess().getBufferAssignment_7_1_1_2()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getChannelAssignment_7_1_1_3()); }
		(rule__MachineBlock__ChannelAssignment_7_1_1_3)
		{ after(grammarAccess.getMachineBlockAccess().getChannelAssignment_7_1_1_3()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getTypedefAssignment_7_1_1_4()); }
		(rule__MachineBlock__TypedefAssignment_7_1_1_4)
		{ after(grammarAccess.getMachineBlockAccess().getTypedefAssignment_7_1_1_4()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getPropertyAssignment_7_1_1_5()); }
		(rule__MachineBlock__PropertyAssignment_7_1_1_5)
		{ after(grammarAccess.getMachineBlockAccess().getPropertyAssignment_7_1_1_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Alternatives_7_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMachineBlockAccess().getPortAssignment_7_2_1_0()); }
		(rule__MachineBlock__PortAssignment_7_2_1_0)
		{ after(grammarAccess.getMachineBlockAccess().getPortAssignment_7_2_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getSignalAssignment_7_2_1_1()); }
		(rule__MachineBlock__SignalAssignment_7_2_1_1)
		{ after(grammarAccess.getMachineBlockAccess().getSignalAssignment_7_2_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getBufferAssignment_7_2_1_2()); }
		(rule__MachineBlock__BufferAssignment_7_2_1_2)
		{ after(grammarAccess.getMachineBlockAccess().getBufferAssignment_7_2_1_2()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getChannelAssignment_7_2_1_3()); }
		(rule__MachineBlock__ChannelAssignment_7_2_1_3)
		{ after(grammarAccess.getMachineBlockAccess().getChannelAssignment_7_2_1_3()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getTypedefAssignment_7_2_1_4()); }
		(rule__MachineBlock__TypedefAssignment_7_2_1_4)
		{ after(grammarAccess.getMachineBlockAccess().getTypedefAssignment_7_2_1_4()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getPropertyAssignment_7_2_1_5()); }
		(rule__MachineBlock__PropertyAssignment_7_2_1_5)
		{ after(grammarAccess.getMachineBlockAccess().getPropertyAssignment_7_2_1_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Alternatives_7_3_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMachineBlockAccess().getPortAssignment_7_3_1_0()); }
		(rule__MachineBlock__PortAssignment_7_3_1_0)
		{ after(grammarAccess.getMachineBlockAccess().getPortAssignment_7_3_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getSignalAssignment_7_3_1_1()); }
		(rule__MachineBlock__SignalAssignment_7_3_1_1)
		{ after(grammarAccess.getMachineBlockAccess().getSignalAssignment_7_3_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getBufferAssignment_7_3_1_2()); }
		(rule__MachineBlock__BufferAssignment_7_3_1_2)
		{ after(grammarAccess.getMachineBlockAccess().getBufferAssignment_7_3_1_2()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getChannelAssignment_7_3_1_3()); }
		(rule__MachineBlock__ChannelAssignment_7_3_1_3)
		{ after(grammarAccess.getMachineBlockAccess().getChannelAssignment_7_3_1_3()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getTypedefAssignment_7_3_1_4()); }
		(rule__MachineBlock__TypedefAssignment_7_3_1_4)
		{ after(grammarAccess.getMachineBlockAccess().getTypedefAssignment_7_3_1_4()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getPropertyAssignment_7_3_1_5()); }
		(rule__MachineBlock__PropertyAssignment_7_3_1_5)
		{ after(grammarAccess.getMachineBlockAccess().getPropertyAssignment_7_3_1_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Alternatives_8
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMachineBlockAccess().getAlternatives_8_0()); }
		(rule__MachineBlock__Alternatives_8_0)*
		{ after(grammarAccess.getMachineBlockAccess().getAlternatives_8_0()); }
	)
	|
	(
		(
			{ before(grammarAccess.getMachineBlockAccess().getAlternatives_8_1()); }
			(rule__MachineBlock__Alternatives_8_1)
			{ after(grammarAccess.getMachineBlockAccess().getAlternatives_8_1()); }
		)
		(
			{ before(grammarAccess.getMachineBlockAccess().getAlternatives_8_1()); }
			(rule__MachineBlock__Alternatives_8_1)*
			{ after(grammarAccess.getMachineBlockAccess().getAlternatives_8_1()); }
		)
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Alternatives_8_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMachineBlockAccess().getGroup_8_0_0()); }
		(rule__MachineBlock__Group_8_0_0__0)
		{ after(grammarAccess.getMachineBlockAccess().getGroup_8_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getGroup_8_0_1()); }
		(rule__MachineBlock__Group_8_0_1__0)
		{ after(grammarAccess.getMachineBlockAccess().getGroup_8_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Alternatives_8_0_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMachineBlockAccess().getRoutineKeyword_8_0_0_0_0()); }
		'@routine:'
		{ after(grammarAccess.getMachineBlockAccess().getRoutineKeyword_8_0_0_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getMacroKeyword_8_0_0_0_1()); }
		'@macro:'
		{ after(grammarAccess.getMachineBlockAccess().getMacroKeyword_8_0_0_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Alternatives_8_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMachineBlockAccess().getRoutineAssignment_8_1_0()); }
		(rule__MachineBlock__RoutineAssignment_8_1_0)
		{ after(grammarAccess.getMachineBlockAccess().getRoutineAssignment_8_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getProcedureAssignment_8_1_1()); }
		(rule__MachineBlock__ProcedureAssignment_8_1_1)
		{ after(grammarAccess.getMachineBlockAccess().getProcedureAssignment_8_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Alternatives_9
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMachineBlockAccess().getGroup_9_0()); }
		(rule__MachineBlock__Group_9_0__0)
		{ after(grammarAccess.getMachineBlockAccess().getGroup_9_0()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getGroup_9_1()); }
		(rule__MachineBlock__Group_9_1__0)
		{ after(grammarAccess.getMachineBlockAccess().getGroup_9_1()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getGroup_9_2()); }
		(rule__MachineBlock__Group_9_2__0)
		{ after(grammarAccess.getMachineBlockAccess().getGroup_9_2()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getGroup_9_3()); }
		(rule__MachineBlock__Group_9_3__0)
		{ after(grammarAccess.getMachineBlockAccess().getGroup_9_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Alternatives_9_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMachineBlockAccess().getCompositeKeyword_9_0_0_0()); }
		'@composite:'
		{ after(grammarAccess.getMachineBlockAccess().getCompositeKeyword_9_0_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getMachineKeyword_9_0_0_1()); }
		'@machine:'
		{ after(grammarAccess.getMachineBlockAccess().getMachineKeyword_9_0_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Alternatives_9_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMachineBlockAccess().getMachineAssignment_9_0_1_0()); }
		(rule__MachineBlock__MachineAssignment_9_0_1_0)
		{ after(grammarAccess.getMachineBlockAccess().getMachineAssignment_9_0_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getInstanceAssignment_9_0_1_1()); }
		(rule__MachineBlock__InstanceAssignment_9_0_1_1)
		{ after(grammarAccess.getMachineBlockAccess().getInstanceAssignment_9_0_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Alternatives_10
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMachineBlockAccess().getGroup_10_0()); }
		(rule__MachineBlock__Group_10_0__0)
		{ after(grammarAccess.getMachineBlockAccess().getGroup_10_0()); }
	)
	|
	(
		{ before(grammarAccess.getMachineBlockAccess().getGroup_10_1()); }
		(rule__MachineBlock__Group_10_1__0)
		{ after(grammarAccess.getMachineBlockAccess().getGroup_10_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Alternatives_2_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getProcedureAccess().getAndKeyword_2_2_0()); }
		'and'
		{ after(grammarAccess.getProcedureAccess().getAndKeyword_2_2_0()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getOrKeyword_2_2_1()); }
		'or'
		{ after(grammarAccess.getProcedureAccess().getOrKeyword_2_2_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Alternatives_5_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getProcedureAccess().getParameterAssignment_5_1_1_0()); }
		(rule__Procedure__ParameterAssignment_5_1_1_0)
		{ after(grammarAccess.getProcedureAccess().getParameterAssignment_5_1_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getGroup_5_1_1_1()); }
		(rule__Procedure__Group_5_1_1_1__0)
		{ after(grammarAccess.getProcedureAccess().getGroup_5_1_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Alternatives_7
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getProcedureAccess().getGroup_7_0()); }
		(rule__Procedure__Group_7_0__0)
		{ after(grammarAccess.getProcedureAccess().getGroup_7_0()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getAlternatives_7_1()); }
		(rule__Procedure__Alternatives_7_1)*
		{ after(grammarAccess.getProcedureAccess().getAlternatives_7_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Alternatives_7_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getProcedureAccess().getGroup_7_0_1_0()); }
		(rule__Procedure__Group_7_0_1_0__0)
		{ after(grammarAccess.getProcedureAccess().getGroup_7_0_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getGroup_7_0_1_1()); }
		(rule__Procedure__Group_7_0_1_1__0)
		{ after(grammarAccess.getProcedureAccess().getGroup_7_0_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getGroup_7_0_1_2()); }
		(rule__Procedure__Group_7_0_1_2__0)
		{ after(grammarAccess.getProcedureAccess().getGroup_7_0_1_2()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getGroup_7_0_1_3()); }
		(rule__Procedure__Group_7_0_1_3__0)
		{ after(grammarAccess.getProcedureAccess().getGroup_7_0_1_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Alternatives_7_0_1_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getProcedureAccess().getParameterAssignment_7_0_1_0_1_0()); }
		(rule__Procedure__ParameterAssignment_7_0_1_0_1_0)
		{ after(grammarAccess.getProcedureAccess().getParameterAssignment_7_0_1_0_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getGroup_7_0_1_0_1_1()); }
		(rule__Procedure__Group_7_0_1_0_1_1__0)
		{ after(grammarAccess.getProcedureAccess().getGroup_7_0_1_0_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Alternatives_7_0_1_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getProcedureAccess().getParameterAssignment_7_0_1_1_1_0()); }
		(rule__Procedure__ParameterAssignment_7_0_1_1_1_0)
		{ after(grammarAccess.getProcedureAccess().getParameterAssignment_7_0_1_1_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getGroup_7_0_1_1_1_1()); }
		(rule__Procedure__Group_7_0_1_1_1_1__0)
		{ after(grammarAccess.getProcedureAccess().getGroup_7_0_1_1_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Alternatives_7_0_1_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getProcedureAccess().getParameterAssignment_7_0_1_2_1_0()); }
		(rule__Procedure__ParameterAssignment_7_0_1_2_1_0)
		{ after(grammarAccess.getProcedureAccess().getParameterAssignment_7_0_1_2_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getGroup_7_0_1_2_1_1()); }
		(rule__Procedure__Group_7_0_1_2_1_1__0)
		{ after(grammarAccess.getProcedureAccess().getGroup_7_0_1_2_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Alternatives_7_0_1_3_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getProcedureAccess().getParameterAssignment_7_0_1_3_1_0()); }
		(rule__Procedure__ParameterAssignment_7_0_1_3_1_0)
		{ after(grammarAccess.getProcedureAccess().getParameterAssignment_7_0_1_3_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getGroup_7_0_1_3_1_1()); }
		(rule__Procedure__Group_7_0_1_3_1_1__0)
		{ after(grammarAccess.getProcedureAccess().getGroup_7_0_1_3_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Alternatives_7_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getProcedureAccess().getPortAssignment_7_1_0()); }
		(rule__Procedure__PortAssignment_7_1_0)
		{ after(grammarAccess.getProcedureAccess().getPortAssignment_7_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getSignalAssignment_7_1_1()); }
		(rule__Procedure__SignalAssignment_7_1_1)
		{ after(grammarAccess.getProcedureAccess().getSignalAssignment_7_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getBufferAssignment_7_1_2()); }
		(rule__Procedure__BufferAssignment_7_1_2)
		{ after(grammarAccess.getProcedureAccess().getBufferAssignment_7_1_2()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getChannelAssignment_7_1_3()); }
		(rule__Procedure__ChannelAssignment_7_1_3)
		{ after(grammarAccess.getProcedureAccess().getChannelAssignment_7_1_3()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getTypedefAssignment_7_1_4()); }
		(rule__Procedure__TypedefAssignment_7_1_4)
		{ after(grammarAccess.getProcedureAccess().getTypedefAssignment_7_1_4()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getPropertyAssignment_7_1_5()); }
		(rule__Procedure__PropertyAssignment_7_1_5)
		{ after(grammarAccess.getProcedureAccess().getPropertyAssignment_7_1_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Alternatives_8
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getProcedureAccess().getGroup_8_0()); }
		(rule__Procedure__Group_8_0__0)
		{ after(grammarAccess.getProcedureAccess().getGroup_8_0()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getGroup_8_1()); }
		(rule__Procedure__Group_8_1__0)
		{ after(grammarAccess.getProcedureAccess().getGroup_8_1()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getGroup_8_2()); }
		(rule__Procedure__Group_8_2__0)
		{ after(grammarAccess.getProcedureAccess().getGroup_8_2()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getGroup_8_3()); }
		(rule__Procedure__Group_8_3__0)
		{ after(grammarAccess.getProcedureAccess().getGroup_8_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Alternatives_8_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getProcedureAccess().getParameterAssignment_8_0_1_0()); }
		(rule__Procedure__ParameterAssignment_8_0_1_0)
		{ after(grammarAccess.getProcedureAccess().getParameterAssignment_8_0_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getGroup_8_0_1_1()); }
		(rule__Procedure__Group_8_0_1_1__0)
		{ after(grammarAccess.getProcedureAccess().getGroup_8_0_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Alternatives_8_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getProcedureAccess().getParameterAssignment_8_1_1_0()); }
		(rule__Procedure__ParameterAssignment_8_1_1_0)
		{ after(grammarAccess.getProcedureAccess().getParameterAssignment_8_1_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getGroup_8_1_1_1()); }
		(rule__Procedure__Group_8_1_1_1__0)
		{ after(grammarAccess.getProcedureAccess().getGroup_8_1_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Alternatives_8_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getProcedureAccess().getParameterAssignment_8_2_1_0()); }
		(rule__Procedure__ParameterAssignment_8_2_1_0)
		{ after(grammarAccess.getProcedureAccess().getParameterAssignment_8_2_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getGroup_8_2_1_1()); }
		(rule__Procedure__Group_8_2_1_1__0)
		{ after(grammarAccess.getProcedureAccess().getGroup_8_2_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Alternatives_8_3_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getProcedureAccess().getParameterAssignment_8_3_1_0()); }
		(rule__Procedure__ParameterAssignment_8_3_1_0)
		{ after(grammarAccess.getProcedureAccess().getParameterAssignment_8_3_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getGroup_8_3_1_1()); }
		(rule__Procedure__Group_8_3_1_1__0)
		{ after(grammarAccess.getProcedureAccess().getGroup_8_3_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Alternatives_9
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getProcedureAccess().getGroup_9_0()); }
		(rule__Procedure__Group_9_0__0)
		{ after(grammarAccess.getProcedureAccess().getGroup_9_0()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getGroup_9_1()); }
		(rule__Procedure__Group_9_1__0)
		{ after(grammarAccess.getProcedureAccess().getGroup_9_1()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getGroup_9_2()); }
		(rule__Procedure__Group_9_2__0)
		{ after(grammarAccess.getProcedureAccess().getGroup_9_2()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getGroup_9_3()); }
		(rule__Procedure__Group_9_3__0)
		{ after(grammarAccess.getProcedureAccess().getGroup_9_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Alternatives_9_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getProcedureAccess().getPortAssignment_9_0_1_0()); }
		(rule__Procedure__PortAssignment_9_0_1_0)
		{ after(grammarAccess.getProcedureAccess().getPortAssignment_9_0_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getSignalAssignment_9_0_1_1()); }
		(rule__Procedure__SignalAssignment_9_0_1_1)
		{ after(grammarAccess.getProcedureAccess().getSignalAssignment_9_0_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getBufferAssignment_9_0_1_2()); }
		(rule__Procedure__BufferAssignment_9_0_1_2)
		{ after(grammarAccess.getProcedureAccess().getBufferAssignment_9_0_1_2()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getChannelAssignment_9_0_1_3()); }
		(rule__Procedure__ChannelAssignment_9_0_1_3)
		{ after(grammarAccess.getProcedureAccess().getChannelAssignment_9_0_1_3()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getTypedefAssignment_9_0_1_4()); }
		(rule__Procedure__TypedefAssignment_9_0_1_4)
		{ after(grammarAccess.getProcedureAccess().getTypedefAssignment_9_0_1_4()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getPropertyAssignment_9_0_1_5()); }
		(rule__Procedure__PropertyAssignment_9_0_1_5)
		{ after(grammarAccess.getProcedureAccess().getPropertyAssignment_9_0_1_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Alternatives_9_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getProcedureAccess().getPortAssignment_9_1_1_0()); }
		(rule__Procedure__PortAssignment_9_1_1_0)
		{ after(grammarAccess.getProcedureAccess().getPortAssignment_9_1_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getSignalAssignment_9_1_1_1()); }
		(rule__Procedure__SignalAssignment_9_1_1_1)
		{ after(grammarAccess.getProcedureAccess().getSignalAssignment_9_1_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getBufferAssignment_9_1_1_2()); }
		(rule__Procedure__BufferAssignment_9_1_1_2)
		{ after(grammarAccess.getProcedureAccess().getBufferAssignment_9_1_1_2()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getChannelAssignment_9_1_1_3()); }
		(rule__Procedure__ChannelAssignment_9_1_1_3)
		{ after(grammarAccess.getProcedureAccess().getChannelAssignment_9_1_1_3()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getTypedefAssignment_9_1_1_4()); }
		(rule__Procedure__TypedefAssignment_9_1_1_4)
		{ after(grammarAccess.getProcedureAccess().getTypedefAssignment_9_1_1_4()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getPropertyAssignment_9_1_1_5()); }
		(rule__Procedure__PropertyAssignment_9_1_1_5)
		{ after(grammarAccess.getProcedureAccess().getPropertyAssignment_9_1_1_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Alternatives_9_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getProcedureAccess().getPortAssignment_9_2_1_0()); }
		(rule__Procedure__PortAssignment_9_2_1_0)
		{ after(grammarAccess.getProcedureAccess().getPortAssignment_9_2_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getSignalAssignment_9_2_1_1()); }
		(rule__Procedure__SignalAssignment_9_2_1_1)
		{ after(grammarAccess.getProcedureAccess().getSignalAssignment_9_2_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getBufferAssignment_9_2_1_2()); }
		(rule__Procedure__BufferAssignment_9_2_1_2)
		{ after(grammarAccess.getProcedureAccess().getBufferAssignment_9_2_1_2()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getChannelAssignment_9_2_1_3()); }
		(rule__Procedure__ChannelAssignment_9_2_1_3)
		{ after(grammarAccess.getProcedureAccess().getChannelAssignment_9_2_1_3()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getTypedefAssignment_9_2_1_4()); }
		(rule__Procedure__TypedefAssignment_9_2_1_4)
		{ after(grammarAccess.getProcedureAccess().getTypedefAssignment_9_2_1_4()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getPropertyAssignment_9_2_1_5()); }
		(rule__Procedure__PropertyAssignment_9_2_1_5)
		{ after(grammarAccess.getProcedureAccess().getPropertyAssignment_9_2_1_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Alternatives_9_3_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getProcedureAccess().getPortAssignment_9_3_1_0()); }
		(rule__Procedure__PortAssignment_9_3_1_0)
		{ after(grammarAccess.getProcedureAccess().getPortAssignment_9_3_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getSignalAssignment_9_3_1_1()); }
		(rule__Procedure__SignalAssignment_9_3_1_1)
		{ after(grammarAccess.getProcedureAccess().getSignalAssignment_9_3_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getBufferAssignment_9_3_1_2()); }
		(rule__Procedure__BufferAssignment_9_3_1_2)
		{ after(grammarAccess.getProcedureAccess().getBufferAssignment_9_3_1_2()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getChannelAssignment_9_3_1_3()); }
		(rule__Procedure__ChannelAssignment_9_3_1_3)
		{ after(grammarAccess.getProcedureAccess().getChannelAssignment_9_3_1_3()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getTypedefAssignment_9_3_1_4()); }
		(rule__Procedure__TypedefAssignment_9_3_1_4)
		{ after(grammarAccess.getProcedureAccess().getTypedefAssignment_9_3_1_4()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getPropertyAssignment_9_3_1_5()); }
		(rule__Procedure__PropertyAssignment_9_3_1_5)
		{ after(grammarAccess.getProcedureAccess().getPropertyAssignment_9_3_1_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Alternatives_10
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getProcedureAccess().getAlternatives_10_0()); }
		(rule__Procedure__Alternatives_10_0)*
		{ after(grammarAccess.getProcedureAccess().getAlternatives_10_0()); }
	)
	|
	(
		(
			{ before(grammarAccess.getProcedureAccess().getAlternatives_10_1()); }
			(rule__Procedure__Alternatives_10_1)
			{ after(grammarAccess.getProcedureAccess().getAlternatives_10_1()); }
		)
		(
			{ before(grammarAccess.getProcedureAccess().getAlternatives_10_1()); }
			(rule__Procedure__Alternatives_10_1)*
			{ after(grammarAccess.getProcedureAccess().getAlternatives_10_1()); }
		)
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Alternatives_10_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getProcedureAccess().getGroup_10_0_0()); }
		(rule__Procedure__Group_10_0_0__0)
		{ after(grammarAccess.getProcedureAccess().getGroup_10_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getGroup_10_0_1()); }
		(rule__Procedure__Group_10_0_1__0)
		{ after(grammarAccess.getProcedureAccess().getGroup_10_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Alternatives_10_0_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getProcedureAccess().getRoutineKeyword_10_0_0_0_0()); }
		'@routine:'
		{ after(grammarAccess.getProcedureAccess().getRoutineKeyword_10_0_0_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getMacroKeyword_10_0_0_0_1()); }
		'@macro:'
		{ after(grammarAccess.getProcedureAccess().getMacroKeyword_10_0_0_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Alternatives_10_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getProcedureAccess().getRoutineAssignment_10_1_0()); }
		(rule__Procedure__RoutineAssignment_10_1_0)
		{ after(grammarAccess.getProcedureAccess().getRoutineAssignment_10_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getProcedureAssignment_10_1_1()); }
		(rule__Procedure__ProcedureAssignment_10_1_1)
		{ after(grammarAccess.getProcedureAccess().getProcedureAssignment_10_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Alternatives_11
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		(
			{ before(grammarAccess.getProcedureAccess().getRegionAssignment_11_0()); }
			(rule__Procedure__RegionAssignment_11_0)
			{ after(grammarAccess.getProcedureAccess().getRegionAssignment_11_0()); }
		)
		(
			{ before(grammarAccess.getProcedureAccess().getRegionAssignment_11_0()); }
			(rule__Procedure__RegionAssignment_11_0)*
			{ after(grammarAccess.getProcedureAccess().getRegionAssignment_11_0()); }
		)
	)
	|
	(
		{ before(grammarAccess.getProcedureAccess().getRegionAssignment_11_1()); }
		(rule__Procedure__RegionAssignment_11_1)
		{ after(grammarAccess.getProcedureAccess().getRegionAssignment_11_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeBehavior__Alternatives_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMoeBehaviorAccess().getPortAssignment_1_1_0()); }
		(rule__MoeBehavior__PortAssignment_1_1_0)
		{ after(grammarAccess.getMoeBehaviorAccess().getPortAssignment_1_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getMoeBehaviorAccess().getSignalAssignment_1_1_1()); }
		(rule__MoeBehavior__SignalAssignment_1_1_1)
		{ after(grammarAccess.getMoeBehaviorAccess().getSignalAssignment_1_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getMoeBehaviorAccess().getBufferAssignment_1_1_2()); }
		(rule__MoeBehavior__BufferAssignment_1_1_2)
		{ after(grammarAccess.getMoeBehaviorAccess().getBufferAssignment_1_1_2()); }
	)
	|
	(
		{ before(grammarAccess.getMoeBehaviorAccess().getChannelAssignment_1_1_3()); }
		(rule__MoeBehavior__ChannelAssignment_1_1_3)
		{ after(grammarAccess.getMoeBehaviorAccess().getChannelAssignment_1_1_3()); }
	)
	|
	(
		{ before(grammarAccess.getMoeBehaviorAccess().getTypedefAssignment_1_1_4()); }
		(rule__MoeBehavior__TypedefAssignment_1_1_4)
		{ after(grammarAccess.getMoeBehaviorAccess().getTypedefAssignment_1_1_4()); }
	)
	|
	(
		{ before(grammarAccess.getMoeBehaviorAccess().getPropertyAssignment_1_1_5()); }
		(rule__MoeBehavior__PropertyAssignment_1_1_5)
		{ after(grammarAccess.getMoeBehaviorAccess().getPropertyAssignment_1_1_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Alternatives_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStatemachineAccess().getTimedAssignment_1_1_0()); }
		(rule__Statemachine__TimedAssignment_1_1_0)
		{ after(grammarAccess.getStatemachineAccess().getTimedAssignment_1_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getInput_enabledAssignment_1_1_1()); }
		(rule__Statemachine__Input_enabledAssignment_1_1_1)
		{ after(grammarAccess.getStatemachineAccess().getInput_enabledAssignment_1_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Alternatives_3_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStatemachineAccess().getOrKeyword_3_2_0()); }
		'or'
		{ after(grammarAccess.getStatemachineAccess().getOrKeyword_3_2_0()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getAndKeyword_3_2_1()); }
		'and'
		{ after(grammarAccess.getStatemachineAccess().getAndKeyword_3_2_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Alternatives_7
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStatemachineAccess().getGroup_7_0()); }
		(rule__Statemachine__Group_7_0__0)
		{ after(grammarAccess.getStatemachineAccess().getGroup_7_0()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getAlternatives_7_1()); }
		(rule__Statemachine__Alternatives_7_1)*
		{ after(grammarAccess.getStatemachineAccess().getAlternatives_7_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Alternatives_7_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStatemachineAccess().getGroup_7_0_1_0()); }
		(rule__Statemachine__Group_7_0_1_0__0)
		{ after(grammarAccess.getStatemachineAccess().getGroup_7_0_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getGroup_7_0_1_1()); }
		(rule__Statemachine__Group_7_0_1_1__0)
		{ after(grammarAccess.getStatemachineAccess().getGroup_7_0_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getGroup_7_0_1_2()); }
		(rule__Statemachine__Group_7_0_1_2__0)
		{ after(grammarAccess.getStatemachineAccess().getGroup_7_0_1_2()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getGroup_7_0_1_3()); }
		(rule__Statemachine__Group_7_0_1_3__0)
		{ after(grammarAccess.getStatemachineAccess().getGroup_7_0_1_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Alternatives_7_0_1_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStatemachineAccess().getParameterAssignment_7_0_1_0_1_0()); }
		(rule__Statemachine__ParameterAssignment_7_0_1_0_1_0)
		{ after(grammarAccess.getStatemachineAccess().getParameterAssignment_7_0_1_0_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getGroup_7_0_1_0_1_1()); }
		(rule__Statemachine__Group_7_0_1_0_1_1__0)
		{ after(grammarAccess.getStatemachineAccess().getGroup_7_0_1_0_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Alternatives_7_0_1_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStatemachineAccess().getParameterAssignment_7_0_1_1_1_0()); }
		(rule__Statemachine__ParameterAssignment_7_0_1_1_1_0)
		{ after(grammarAccess.getStatemachineAccess().getParameterAssignment_7_0_1_1_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getGroup_7_0_1_1_1_1()); }
		(rule__Statemachine__Group_7_0_1_1_1_1__0)
		{ after(grammarAccess.getStatemachineAccess().getGroup_7_0_1_1_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Alternatives_7_0_1_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStatemachineAccess().getParameterAssignment_7_0_1_2_1_0()); }
		(rule__Statemachine__ParameterAssignment_7_0_1_2_1_0)
		{ after(grammarAccess.getStatemachineAccess().getParameterAssignment_7_0_1_2_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getGroup_7_0_1_2_1_1()); }
		(rule__Statemachine__Group_7_0_1_2_1_1__0)
		{ after(grammarAccess.getStatemachineAccess().getGroup_7_0_1_2_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Alternatives_7_0_1_3_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStatemachineAccess().getParameterAssignment_7_0_1_3_1_0()); }
		(rule__Statemachine__ParameterAssignment_7_0_1_3_1_0)
		{ after(grammarAccess.getStatemachineAccess().getParameterAssignment_7_0_1_3_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getGroup_7_0_1_3_1_1()); }
		(rule__Statemachine__Group_7_0_1_3_1_1__0)
		{ after(grammarAccess.getStatemachineAccess().getGroup_7_0_1_3_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Alternatives_7_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStatemachineAccess().getPortAssignment_7_1_0()); }
		(rule__Statemachine__PortAssignment_7_1_0)
		{ after(grammarAccess.getStatemachineAccess().getPortAssignment_7_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getSignalAssignment_7_1_1()); }
		(rule__Statemachine__SignalAssignment_7_1_1)
		{ after(grammarAccess.getStatemachineAccess().getSignalAssignment_7_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getBufferAssignment_7_1_2()); }
		(rule__Statemachine__BufferAssignment_7_1_2)
		{ after(grammarAccess.getStatemachineAccess().getBufferAssignment_7_1_2()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getChannelAssignment_7_1_3()); }
		(rule__Statemachine__ChannelAssignment_7_1_3)
		{ after(grammarAccess.getStatemachineAccess().getChannelAssignment_7_1_3()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getTypedefAssignment_7_1_4()); }
		(rule__Statemachine__TypedefAssignment_7_1_4)
		{ after(grammarAccess.getStatemachineAccess().getTypedefAssignment_7_1_4()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getPropertyAssignment_7_1_5()); }
		(rule__Statemachine__PropertyAssignment_7_1_5)
		{ after(grammarAccess.getStatemachineAccess().getPropertyAssignment_7_1_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Alternatives_8
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStatemachineAccess().getGroup_8_0()); }
		(rule__Statemachine__Group_8_0__0)
		{ after(grammarAccess.getStatemachineAccess().getGroup_8_0()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getGroup_8_1()); }
		(rule__Statemachine__Group_8_1__0)
		{ after(grammarAccess.getStatemachineAccess().getGroup_8_1()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getGroup_8_2()); }
		(rule__Statemachine__Group_8_2__0)
		{ after(grammarAccess.getStatemachineAccess().getGroup_8_2()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getGroup_8_3()); }
		(rule__Statemachine__Group_8_3__0)
		{ after(grammarAccess.getStatemachineAccess().getGroup_8_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Alternatives_8_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStatemachineAccess().getParameterAssignment_8_0_1_0()); }
		(rule__Statemachine__ParameterAssignment_8_0_1_0)
		{ after(grammarAccess.getStatemachineAccess().getParameterAssignment_8_0_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getGroup_8_0_1_1()); }
		(rule__Statemachine__Group_8_0_1_1__0)
		{ after(grammarAccess.getStatemachineAccess().getGroup_8_0_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Alternatives_8_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStatemachineAccess().getParameterAssignment_8_1_1_0()); }
		(rule__Statemachine__ParameterAssignment_8_1_1_0)
		{ after(grammarAccess.getStatemachineAccess().getParameterAssignment_8_1_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getGroup_8_1_1_1()); }
		(rule__Statemachine__Group_8_1_1_1__0)
		{ after(grammarAccess.getStatemachineAccess().getGroup_8_1_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Alternatives_8_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStatemachineAccess().getParameterAssignment_8_2_1_0()); }
		(rule__Statemachine__ParameterAssignment_8_2_1_0)
		{ after(grammarAccess.getStatemachineAccess().getParameterAssignment_8_2_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getGroup_8_2_1_1()); }
		(rule__Statemachine__Group_8_2_1_1__0)
		{ after(grammarAccess.getStatemachineAccess().getGroup_8_2_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Alternatives_8_3_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStatemachineAccess().getParameterAssignment_8_3_1_0()); }
		(rule__Statemachine__ParameterAssignment_8_3_1_0)
		{ after(grammarAccess.getStatemachineAccess().getParameterAssignment_8_3_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getGroup_8_3_1_1()); }
		(rule__Statemachine__Group_8_3_1_1__0)
		{ after(grammarAccess.getStatemachineAccess().getGroup_8_3_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Alternatives_9
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStatemachineAccess().getGroup_9_0()); }
		(rule__Statemachine__Group_9_0__0)
		{ after(grammarAccess.getStatemachineAccess().getGroup_9_0()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getGroup_9_1()); }
		(rule__Statemachine__Group_9_1__0)
		{ after(grammarAccess.getStatemachineAccess().getGroup_9_1()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getGroup_9_2()); }
		(rule__Statemachine__Group_9_2__0)
		{ after(grammarAccess.getStatemachineAccess().getGroup_9_2()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getGroup_9_3()); }
		(rule__Statemachine__Group_9_3__0)
		{ after(grammarAccess.getStatemachineAccess().getGroup_9_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Alternatives_9_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStatemachineAccess().getPortAssignment_9_0_1_0()); }
		(rule__Statemachine__PortAssignment_9_0_1_0)
		{ after(grammarAccess.getStatemachineAccess().getPortAssignment_9_0_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getSignalAssignment_9_0_1_1()); }
		(rule__Statemachine__SignalAssignment_9_0_1_1)
		{ after(grammarAccess.getStatemachineAccess().getSignalAssignment_9_0_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getBufferAssignment_9_0_1_2()); }
		(rule__Statemachine__BufferAssignment_9_0_1_2)
		{ after(grammarAccess.getStatemachineAccess().getBufferAssignment_9_0_1_2()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getChannelAssignment_9_0_1_3()); }
		(rule__Statemachine__ChannelAssignment_9_0_1_3)
		{ after(grammarAccess.getStatemachineAccess().getChannelAssignment_9_0_1_3()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getTypedefAssignment_9_0_1_4()); }
		(rule__Statemachine__TypedefAssignment_9_0_1_4)
		{ after(grammarAccess.getStatemachineAccess().getTypedefAssignment_9_0_1_4()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getPropertyAssignment_9_0_1_5()); }
		(rule__Statemachine__PropertyAssignment_9_0_1_5)
		{ after(grammarAccess.getStatemachineAccess().getPropertyAssignment_9_0_1_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Alternatives_9_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStatemachineAccess().getPortAssignment_9_1_1_0()); }
		(rule__Statemachine__PortAssignment_9_1_1_0)
		{ after(grammarAccess.getStatemachineAccess().getPortAssignment_9_1_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getSignalAssignment_9_1_1_1()); }
		(rule__Statemachine__SignalAssignment_9_1_1_1)
		{ after(grammarAccess.getStatemachineAccess().getSignalAssignment_9_1_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getBufferAssignment_9_1_1_2()); }
		(rule__Statemachine__BufferAssignment_9_1_1_2)
		{ after(grammarAccess.getStatemachineAccess().getBufferAssignment_9_1_1_2()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getChannelAssignment_9_1_1_3()); }
		(rule__Statemachine__ChannelAssignment_9_1_1_3)
		{ after(grammarAccess.getStatemachineAccess().getChannelAssignment_9_1_1_3()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getTypedefAssignment_9_1_1_4()); }
		(rule__Statemachine__TypedefAssignment_9_1_1_4)
		{ after(grammarAccess.getStatemachineAccess().getTypedefAssignment_9_1_1_4()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getPropertyAssignment_9_1_1_5()); }
		(rule__Statemachine__PropertyAssignment_9_1_1_5)
		{ after(grammarAccess.getStatemachineAccess().getPropertyAssignment_9_1_1_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Alternatives_9_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStatemachineAccess().getPortAssignment_9_2_1_0()); }
		(rule__Statemachine__PortAssignment_9_2_1_0)
		{ after(grammarAccess.getStatemachineAccess().getPortAssignment_9_2_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getSignalAssignment_9_2_1_1()); }
		(rule__Statemachine__SignalAssignment_9_2_1_1)
		{ after(grammarAccess.getStatemachineAccess().getSignalAssignment_9_2_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getBufferAssignment_9_2_1_2()); }
		(rule__Statemachine__BufferAssignment_9_2_1_2)
		{ after(grammarAccess.getStatemachineAccess().getBufferAssignment_9_2_1_2()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getChannelAssignment_9_2_1_3()); }
		(rule__Statemachine__ChannelAssignment_9_2_1_3)
		{ after(grammarAccess.getStatemachineAccess().getChannelAssignment_9_2_1_3()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getTypedefAssignment_9_2_1_4()); }
		(rule__Statemachine__TypedefAssignment_9_2_1_4)
		{ after(grammarAccess.getStatemachineAccess().getTypedefAssignment_9_2_1_4()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getPropertyAssignment_9_2_1_5()); }
		(rule__Statemachine__PropertyAssignment_9_2_1_5)
		{ after(grammarAccess.getStatemachineAccess().getPropertyAssignment_9_2_1_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Alternatives_9_3_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStatemachineAccess().getPortAssignment_9_3_1_0()); }
		(rule__Statemachine__PortAssignment_9_3_1_0)
		{ after(grammarAccess.getStatemachineAccess().getPortAssignment_9_3_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getSignalAssignment_9_3_1_1()); }
		(rule__Statemachine__SignalAssignment_9_3_1_1)
		{ after(grammarAccess.getStatemachineAccess().getSignalAssignment_9_3_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getBufferAssignment_9_3_1_2()); }
		(rule__Statemachine__BufferAssignment_9_3_1_2)
		{ after(grammarAccess.getStatemachineAccess().getBufferAssignment_9_3_1_2()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getChannelAssignment_9_3_1_3()); }
		(rule__Statemachine__ChannelAssignment_9_3_1_3)
		{ after(grammarAccess.getStatemachineAccess().getChannelAssignment_9_3_1_3()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getTypedefAssignment_9_3_1_4()); }
		(rule__Statemachine__TypedefAssignment_9_3_1_4)
		{ after(grammarAccess.getStatemachineAccess().getTypedefAssignment_9_3_1_4()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getPropertyAssignment_9_3_1_5()); }
		(rule__Statemachine__PropertyAssignment_9_3_1_5)
		{ after(grammarAccess.getStatemachineAccess().getPropertyAssignment_9_3_1_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Alternatives_10
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStatemachineAccess().getAlternatives_10_0()); }
		(rule__Statemachine__Alternatives_10_0)*
		{ after(grammarAccess.getStatemachineAccess().getAlternatives_10_0()); }
	)
	|
	(
		(
			{ before(grammarAccess.getStatemachineAccess().getAlternatives_10_1()); }
			(rule__Statemachine__Alternatives_10_1)
			{ after(grammarAccess.getStatemachineAccess().getAlternatives_10_1()); }
		)
		(
			{ before(grammarAccess.getStatemachineAccess().getAlternatives_10_1()); }
			(rule__Statemachine__Alternatives_10_1)*
			{ after(grammarAccess.getStatemachineAccess().getAlternatives_10_1()); }
		)
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Alternatives_10_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStatemachineAccess().getGroup_10_0_0()); }
		(rule__Statemachine__Group_10_0_0__0)
		{ after(grammarAccess.getStatemachineAccess().getGroup_10_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getGroup_10_0_1()); }
		(rule__Statemachine__Group_10_0_1__0)
		{ after(grammarAccess.getStatemachineAccess().getGroup_10_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Alternatives_10_0_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStatemachineAccess().getRoutineKeyword_10_0_0_0_0()); }
		'@routine:'
		{ after(grammarAccess.getStatemachineAccess().getRoutineKeyword_10_0_0_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getMacroKeyword_10_0_0_0_1()); }
		'@macro:'
		{ after(grammarAccess.getStatemachineAccess().getMacroKeyword_10_0_0_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Alternatives_10_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStatemachineAccess().getRoutineAssignment_10_1_0()); }
		(rule__Statemachine__RoutineAssignment_10_1_0)
		{ after(grammarAccess.getStatemachineAccess().getRoutineAssignment_10_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getProcedureAssignment_10_1_1()); }
		(rule__Statemachine__ProcedureAssignment_10_1_1)
		{ after(grammarAccess.getStatemachineAccess().getProcedureAssignment_10_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Alternatives_11
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStatemachineAccess().getGroup_11_0()); }
		(rule__Statemachine__Group_11_0__0)
		{ after(grammarAccess.getStatemachineAccess().getGroup_11_0()); }
	)
	|
	(
		(
			{ before(grammarAccess.getStatemachineAccess().getRegionAssignment_11_1()); }
			(rule__Statemachine__RegionAssignment_11_1)
			{ after(grammarAccess.getStatemachineAccess().getRegionAssignment_11_1()); }
		)
		(
			{ before(grammarAccess.getStatemachineAccess().getRegionAssignment_11_1()); }
			(rule__Statemachine__RegionAssignment_11_1)*
			{ after(grammarAccess.getStatemachineAccess().getRegionAssignment_11_1()); }
		)
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getRegionAssignment_11_2()); }
		(rule__Statemachine__RegionAssignment_11_2)
		{ after(grammarAccess.getStatemachineAccess().getRegionAssignment_11_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Alternatives_11_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStatemachineAccess().getCompositeKeyword_11_0_0_0()); }
		'@composite:'
		{ after(grammarAccess.getStatemachineAccess().getCompositeKeyword_11_0_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineAccess().getStatemachineKeyword_11_0_0_1()); }
		'@statemachine:'
		{ after(grammarAccess.getStatemachineAccess().getStatemachineKeyword_11_0_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__StatemachineRegion__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStatemachineRegionAccess().getRegionKeyword_1_0()); }
		'@region:'
		{ after(grammarAccess.getStatemachineRegionAccess().getRegionKeyword_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineRegionAccess().getGroup_1_1()); }
		(rule__StatemachineRegion__Group_1_1__0)
		{ after(grammarAccess.getStatemachineRegionAccess().getGroup_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__StatemachineRegion__Alternatives_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStatemachineRegionAccess().getVertexAssignment_2_0()); }
		(rule__StatemachineRegion__VertexAssignment_2_0)
		{ after(grammarAccess.getStatemachineRegionAccess().getVertexAssignment_2_0()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineRegionAccess().getVertexAssignment_2_1()); }
		(rule__StatemachineRegion__VertexAssignment_2_1)
		{ after(grammarAccess.getStatemachineRegionAccess().getVertexAssignment_2_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__StatemachineRegionLite__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStatemachineRegionLiteAccess().getVertexAssignment_0()); }
		(rule__StatemachineRegionLite__VertexAssignment_0)
		{ after(grammarAccess.getStatemachineRegionLiteAccess().getVertexAssignment_0()); }
	)
	|
	(
		{ before(grammarAccess.getStatemachineRegionLiteAccess().getVertexAssignment_1()); }
		(rule__StatemachineRegionLite__VertexAssignment_1)
		{ after(grammarAccess.getStatemachineRegionLiteAccess().getVertexAssignment_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__State__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStateAccess().getCompositeStateParserRuleCall_0()); }
		ruleCompositeState
		{ after(grammarAccess.getStateAccess().getCompositeStateParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getStateAccess().getStartStateParserRuleCall_1()); }
		ruleStartState
		{ after(grammarAccess.getStateAccess().getStartStateParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getStateAccess().getSimpleStateParserRuleCall_2()); }
		ruleSimpleState
		{ after(grammarAccess.getStateAccess().getSimpleStateParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getStateAccess().getFinalStateParserRuleCall_3()); }
		ruleFinalState
		{ after(grammarAccess.getStateAccess().getFinalStateParserRuleCall_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Alternatives_4
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getCompositeStateAccess().getOrKeyword_4_0()); }
		'or'
		{ after(grammarAccess.getCompositeStateAccess().getOrKeyword_4_0()); }
	)
	|
	(
		{ before(grammarAccess.getCompositeStateAccess().getOrthogonalAssignment_4_1()); }
		(rule__CompositeState__OrthogonalAssignment_4_1)
		{ after(grammarAccess.getCompositeStateAccess().getOrthogonalAssignment_4_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Alternatives_8
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getCompositeStateAccess().getGroup_8_0()); }
		(rule__CompositeState__Group_8_0__0)
		{ after(grammarAccess.getCompositeStateAccess().getGroup_8_0()); }
	)
	|
	(
		{ before(grammarAccess.getCompositeStateAccess().getSemicolonKeyword_8_1()); }
		';'
		{ after(grammarAccess.getCompositeStateAccess().getSemicolonKeyword_8_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Alternatives_8_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		(
			{ before(grammarAccess.getCompositeStateAccess().getAlternatives_8_0_1_0()); }
			(rule__CompositeState__Alternatives_8_0_1_0)
			{ after(grammarAccess.getCompositeStateAccess().getAlternatives_8_0_1_0()); }
		)
		(
			{ before(grammarAccess.getCompositeStateAccess().getAlternatives_8_0_1_0()); }
			(rule__CompositeState__Alternatives_8_0_1_0)*
			{ after(grammarAccess.getCompositeStateAccess().getAlternatives_8_0_1_0()); }
		)
	)
	|
	(
		{ before(grammarAccess.getCompositeStateAccess().getGroup_8_0_1_1()); }
		(rule__CompositeState__Group_8_0_1_1__0)
		{ after(grammarAccess.getCompositeStateAccess().getGroup_8_0_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Alternatives_8_0_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getCompositeStateAccess().getRegionAssignment_8_0_1_0_0()); }
		(rule__CompositeState__RegionAssignment_8_0_1_0_0)
		{ after(grammarAccess.getCompositeStateAccess().getRegionAssignment_8_0_1_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getCompositeStateAccess().getGroup_8_0_1_0_1()); }
		(rule__CompositeState__Group_8_0_1_0_1__0)
		{ after(grammarAccess.getCompositeStateAccess().getGroup_8_0_1_0_1()); }
	)
	|
	(
		{ before(grammarAccess.getCompositeStateAccess().getGroup_8_0_1_0_2()); }
		(rule__CompositeState__Group_8_0_1_0_2__0)
		{ after(grammarAccess.getCompositeStateAccess().getGroup_8_0_1_0_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Alternatives_8_0_1_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getCompositeStateAccess().getTransitionAssignment_8_0_1_1_1_0()); }
		(rule__CompositeState__TransitionAssignment_8_0_1_1_1_0)
		{ after(grammarAccess.getCompositeStateAccess().getTransitionAssignment_8_0_1_1_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getCompositeStateAccess().getMoeAssignment_8_0_1_1_1_1()); }
		(rule__CompositeState__MoeAssignment_8_0_1_1_1_1)
		{ after(grammarAccess.getCompositeStateAccess().getMoeAssignment_8_0_1_1_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeCompositeStateRoutines__NameAlternatives_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMoeCompositeStateRoutinesAccess().getNameInitKeyword_1_0_0()); }
		'@init'
		{ after(grammarAccess.getMoeCompositeStateRoutinesAccess().getNameInitKeyword_1_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getMoeCompositeStateRoutinesAccess().getNameFinalKeyword_1_0_1()); }
		'@final'
		{ after(grammarAccess.getMoeCompositeStateRoutinesAccess().getNameFinalKeyword_1_0_1()); }
	)
	|
	(
		{ before(grammarAccess.getMoeCompositeStateRoutinesAccess().getNameEnableKeyword_1_0_2()); }
		'@enable'
		{ after(grammarAccess.getMoeCompositeStateRoutinesAccess().getNameEnableKeyword_1_0_2()); }
	)
	|
	(
		{ before(grammarAccess.getMoeCompositeStateRoutinesAccess().getNameDisableKeyword_1_0_3()); }
		'@disable'
		{ after(grammarAccess.getMoeCompositeStateRoutinesAccess().getNameDisableKeyword_1_0_3()); }
	)
	|
	(
		{ before(grammarAccess.getMoeCompositeStateRoutinesAccess().getNameConcurrencyKeyword_1_0_4()); }
		'@concurrency'
		{ after(grammarAccess.getMoeCompositeStateRoutinesAccess().getNameConcurrencyKeyword_1_0_4()); }
	)
	|
	(
		{ before(grammarAccess.getMoeCompositeStateRoutinesAccess().getNameScheduleKeyword_1_0_5()); }
		'@schedule'
		{ after(grammarAccess.getMoeCompositeStateRoutinesAccess().getNameScheduleKeyword_1_0_5()); }
	)
	|
	(
		{ before(grammarAccess.getMoeCompositeStateRoutinesAccess().getNameIrunKeyword_1_0_6()); }
		'@irun'
		{ after(grammarAccess.getMoeCompositeStateRoutinesAccess().getNameIrunKeyword_1_0_6()); }
	)
	|
	(
		{ before(grammarAccess.getMoeCompositeStateRoutinesAccess().getNameRunKeyword_1_0_7()); }
		'@run'
		{ after(grammarAccess.getMoeCompositeStateRoutinesAccess().getNameRunKeyword_1_0_7()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleState__Alternatives_5
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSimpleStateAccess().getGroup_5_0()); }
		(rule__SimpleState__Group_5_0__0)
		{ after(grammarAccess.getSimpleStateAccess().getGroup_5_0()); }
	)
	|
	(
		{ before(grammarAccess.getSimpleStateAccess().getSemicolonKeyword_5_1()); }
		';'
		{ after(grammarAccess.getSimpleStateAccess().getSemicolonKeyword_5_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleState__Alternatives_5_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSimpleStateAccess().getTransitionAssignment_5_0_1_0()); }
		(rule__SimpleState__TransitionAssignment_5_0_1_0)
		{ after(grammarAccess.getSimpleStateAccess().getTransitionAssignment_5_0_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getSimpleStateAccess().getMoeAssignment_5_0_1_1()); }
		(rule__SimpleState__MoeAssignment_5_0_1_1)
		{ after(grammarAccess.getSimpleStateAccess().getMoeAssignment_5_0_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeSimpleStateRoutines__NameAlternatives_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMoeSimpleStateRoutinesAccess().getNameEnableKeyword_1_0_0()); }
		'@enable'
		{ after(grammarAccess.getMoeSimpleStateRoutinesAccess().getNameEnableKeyword_1_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getMoeSimpleStateRoutinesAccess().getNameDisableKeyword_1_0_1()); }
		'@disable'
		{ after(grammarAccess.getMoeSimpleStateRoutinesAccess().getNameDisableKeyword_1_0_1()); }
	)
	|
	(
		{ before(grammarAccess.getMoeSimpleStateRoutinesAccess().getNameIrunKeyword_1_0_2()); }
		'@irun'
		{ after(grammarAccess.getMoeSimpleStateRoutinesAccess().getNameIrunKeyword_1_0_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__StartState__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStartStateAccess().getGroup_1_0()); }
		(rule__StartState__Group_1_0__0)
		{ after(grammarAccess.getStartStateAccess().getGroup_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getStartStateAccess().getSimpleAssignment_1_1()); }
		(rule__StartState__SimpleAssignment_1_1)
		{ after(grammarAccess.getStartStateAccess().getSimpleAssignment_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__StartState__Alternatives_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStartStateAccess().getGroup_3_0()); }
		(rule__StartState__Group_3_0__0)
		{ after(grammarAccess.getStartStateAccess().getGroup_3_0()); }
	)
	|
	(
		{ before(grammarAccess.getStartStateAccess().getSemicolonKeyword_3_1()); }
		';'
		{ after(grammarAccess.getStartStateAccess().getSemicolonKeyword_3_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__StartState__Alternatives_3_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStartStateAccess().getTransitionAssignment_3_0_1_0()); }
		(rule__StartState__TransitionAssignment_3_0_1_0)
		{ after(grammarAccess.getStartStateAccess().getTransitionAssignment_3_0_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getStartStateAccess().getMoeAssignment_3_0_1_1()); }
		(rule__StartState__MoeAssignment_3_0_1_1)
		{ after(grammarAccess.getStartStateAccess().getMoeAssignment_3_0_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeStartStateRoutines__NameAlternatives_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMoeStartStateRoutinesAccess().getNameInitKeyword_1_0_0()); }
		'@init'
		{ after(grammarAccess.getMoeStartStateRoutinesAccess().getNameInitKeyword_1_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getMoeStartStateRoutinesAccess().getNameEnableKeyword_1_0_1()); }
		'@enable'
		{ after(grammarAccess.getMoeStartStateRoutinesAccess().getNameEnableKeyword_1_0_1()); }
	)
	|
	(
		{ before(grammarAccess.getMoeStartStateRoutinesAccess().getNameDisableKeyword_1_0_2()); }
		'@disable'
		{ after(grammarAccess.getMoeStartStateRoutinesAccess().getNameDisableKeyword_1_0_2()); }
	)
	|
	(
		{ before(grammarAccess.getMoeStartStateRoutinesAccess().getNameIrunKeyword_1_0_3()); }
		'@irun'
		{ after(grammarAccess.getMoeStartStateRoutinesAccess().getNameIrunKeyword_1_0_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FinalState__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFinalStateAccess().getGroup_1_0()); }
		(rule__FinalState__Group_1_0__0)
		{ after(grammarAccess.getFinalStateAccess().getGroup_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getFinalStateAccess().getSimpleAssignment_1_1()); }
		(rule__FinalState__SimpleAssignment_1_1)
		{ after(grammarAccess.getFinalStateAccess().getSimpleAssignment_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__FinalState__Alternatives_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getFinalStateAccess().getGroup_3_0()); }
		(rule__FinalState__Group_3_0__0)
		{ after(grammarAccess.getFinalStateAccess().getGroup_3_0()); }
	)
	|
	(
		{ before(grammarAccess.getFinalStateAccess().getSemicolonKeyword_3_1()); }
		';'
		{ after(grammarAccess.getFinalStateAccess().getSemicolonKeyword_3_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeFinalStateRoutines__NameAlternatives_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMoeFinalStateRoutinesAccess().getNameEnableKeyword_1_0_0()); }
		'@enable'
		{ after(grammarAccess.getMoeFinalStateRoutinesAccess().getNameEnableKeyword_1_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getMoeFinalStateRoutinesAccess().getNameFinalKeyword_1_0_1()); }
		'@final'
		{ after(grammarAccess.getMoeFinalStateRoutinesAccess().getNameFinalKeyword_1_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Pseudostate__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPseudostateAccess().getPseudostateInitialParserRuleCall_0()); }
		rulePseudostateInitial
		{ after(grammarAccess.getPseudostateAccess().getPseudostateInitialParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getPseudostateAccess().getEndingPseudostateParserRuleCall_1()); }
		ruleEndingPseudostate
		{ after(grammarAccess.getPseudostateAccess().getEndingPseudostateParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getPseudostateAccess().getOtherPseudostateParserRuleCall_2()); }
		ruleOtherPseudostate
		{ after(grammarAccess.getPseudostateAccess().getOtherPseudostateParserRuleCall_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherPseudostate__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getOtherPseudostateAccess().getStateKeyword_1_0()); }
		'state'
		{ after(grammarAccess.getOtherPseudostateAccess().getStateKeyword_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getOtherPseudostateAccess().getPseudostateKeyword_1_1()); }
		'pseudostate'
		{ after(grammarAccess.getOtherPseudostateAccess().getPseudostateKeyword_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherPseudostate__Alternatives_8
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getOtherPseudostateAccess().getGroup_8_0()); }
		(rule__OtherPseudostate__Group_8_0__0)
		{ after(grammarAccess.getOtherPseudostateAccess().getGroup_8_0()); }
	)
	|
	(
		{ before(grammarAccess.getOtherPseudostateAccess().getSemicolonKeyword_8_1()); }
		';'
		{ after(grammarAccess.getOtherPseudostateAccess().getSemicolonKeyword_8_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PseudostateInitial__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPseudostateInitialAccess().getGroup_1_0()); }
		(rule__PseudostateInitial__Group_1_0__0)
		{ after(grammarAccess.getPseudostateInitialAccess().getGroup_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getPseudostateInitialAccess().getNameAssignment_1_1()); }
		(rule__PseudostateInitial__NameAssignment_1_1)
		{ after(grammarAccess.getPseudostateInitialAccess().getNameAssignment_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PseudostateInitial__Alternatives_1_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPseudostateInitialAccess().getStateKeyword_1_0_0_0()); }
		'state'
		{ after(grammarAccess.getPseudostateInitialAccess().getStateKeyword_1_0_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getPseudostateInitialAccess().getPseudostateKeyword_1_0_0_1()); }
		'pseudostate'
		{ after(grammarAccess.getPseudostateInitialAccess().getPseudostateKeyword_1_0_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PseudostateInitial__NameAlternatives_1_0_5_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPseudostateInitialAccess().getNameESIdentifierParserRuleCall_1_0_5_0_0()); }
		ruleESIdentifier
		{ after(grammarAccess.getPseudostateInitialAccess().getNameESIdentifierParserRuleCall_1_0_5_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getPseudostateInitialAccess().getNameInitialKeyword_1_0_5_0_1()); }
		'#initial'
		{ after(grammarAccess.getPseudostateInitialAccess().getNameInitialKeyword_1_0_5_0_1()); }
	)
	|
	(
		{ before(grammarAccess.getPseudostateInitialAccess().getNameInitKeyword_1_0_5_0_2()); }
		'#init'
		{ after(grammarAccess.getPseudostateInitialAccess().getNameInitKeyword_1_0_5_0_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PseudostateInitial__NameAlternatives_1_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPseudostateInitialAccess().getNameInitialKeyword_1_1_0_0()); }
		'#initial'
		{ after(grammarAccess.getPseudostateInitialAccess().getNameInitialKeyword_1_1_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getPseudostateInitialAccess().getNameInitKeyword_1_1_0_1()); }
		'#init'
		{ after(grammarAccess.getPseudostateInitialAccess().getNameInitKeyword_1_1_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PseudostateInitial__Alternatives_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPseudostateInitialAccess().getGroup_3_0()); }
		(rule__PseudostateInitial__Group_3_0__0)
		{ after(grammarAccess.getPseudostateInitialAccess().getGroup_3_0()); }
	)
	|
	(
		{ before(grammarAccess.getPseudostateInitialAccess().getSemicolonKeyword_3_1()); }
		';'
		{ after(grammarAccess.getPseudostateInitialAccess().getSemicolonKeyword_3_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__EndingPseudostate__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEndingPseudostateAccess().getStateKeyword_1_0()); }
		'state'
		{ after(grammarAccess.getEndingPseudostateAccess().getStateKeyword_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getEndingPseudostateAccess().getPseudostateKeyword_1_1()); }
		'pseudostate'
		{ after(grammarAccess.getEndingPseudostateAccess().getPseudostateKeyword_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__EndingPseudostate__Alternatives_8
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEndingPseudostateAccess().getGroup_8_0()); }
		(rule__EndingPseudostate__Group_8_0__0)
		{ after(grammarAccess.getEndingPseudostateAccess().getGroup_8_0()); }
	)
	|
	(
		{ before(grammarAccess.getEndingPseudostateAccess().getSemicolonKeyword_8_1()); }
		';'
		{ after(grammarAccess.getEndingPseudostateAccess().getSemicolonKeyword_8_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeRoutine__Alternatives_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMoeRoutineAccess().getGroup_2_1_0()); }
		(rule__MoeRoutine__Group_2_1_0__0)
		{ after(grammarAccess.getMoeRoutineAccess().getGroup_2_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getMoeRoutineAccess().getCodomainAssignment_2_1_1()); }
		(rule__MoeRoutine__CodomainAssignment_2_1_1)
		{ after(grammarAccess.getMoeRoutineAccess().getCodomainAssignment_2_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Routine__Alternatives_6_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getRoutineAccess().getGroup_6_1_0()); }
		(rule__Routine__Group_6_1_0__0)
		{ after(grammarAccess.getRoutineAccess().getGroup_6_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getRoutineAccess().getCodomainAssignment_6_1_1()); }
		(rule__Routine__CodomainAssignment_6_1_1)
		{ after(grammarAccess.getRoutineAccess().getCodomainAssignment_6_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfInteraction__Alternatives_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getModelOfInteractionAccess().getRoutesAssignment_2_0()); }
		(rule__ModelOfInteraction__RoutesAssignment_2_0)
		{ after(grammarAccess.getModelOfInteractionAccess().getRoutesAssignment_2_0()); }
	)
	|
	(
		{ before(grammarAccess.getModelOfInteractionAccess().getConnectionsAssignment_2_1()); }
		(rule__ModelOfInteraction__ConnectionsAssignment_2_1)
		{ after(grammarAccess.getModelOfInteractionAccess().getConnectionsAssignment_2_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Route__Alternatives_7
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getRouteAccess().getAsteriskKeyword_7_0()); }
		'*'
		{ after(grammarAccess.getRouteAccess().getAsteriskKeyword_7_0()); }
	)
	|
	(
		{ before(grammarAccess.getRouteAccess().getGroup_7_1()); }
		(rule__Route__Group_7_1__0)
		{ after(grammarAccess.getRouteAccess().getGroup_7_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComRouteProtocol__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getComRouteProtocolAccess().getProtocolAssignment_0()); }
		(rule__ComRouteProtocol__ProtocolAssignment_0)
		{ after(grammarAccess.getComRouteProtocolAccess().getProtocolAssignment_0()); }
	)
	|
	(
		{ before(grammarAccess.getComRouteProtocolAccess().getGroup_1()); }
		(rule__ComRouteProtocol__Group_1__0)
		{ after(grammarAccess.getComRouteProtocolAccess().getGroup_1()); }
	)
	|
	(
		{ before(grammarAccess.getComRouteProtocolAccess().getInner_bufferAssignment_2()); }
		(rule__ComRouteProtocol__Inner_bufferAssignment_2)
		{ after(grammarAccess.getComRouteProtocolAccess().getInner_bufferAssignment_2()); }
	)
	|
	(
		{ before(grammarAccess.getComRouteProtocolAccess().getBufferAssignment_3()); }
		(rule__ComRouteProtocol__BufferAssignment_3)
		{ after(grammarAccess.getComRouteProtocolAccess().getBufferAssignment_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComRouteProtocol__Alternatives_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getComRouteProtocolAccess().getGroup_1_1_0()); }
		(rule__ComRouteProtocol__Group_1_1_0__0)
		{ after(grammarAccess.getComRouteProtocolAccess().getGroup_1_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getComRouteProtocolAccess().getGroup_1_1_1()); }
		(rule__ComRouteProtocol__Group_1_1_1__0)
		{ after(grammarAccess.getComRouteProtocolAccess().getGroup_1_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComRouteProtocol__Alternatives_1_1_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getComRouteProtocolAccess().getInner_bufferAssignment_1_1_0_1_0()); }
		(rule__ComRouteProtocol__Inner_bufferAssignment_1_1_0_1_0)
		{ after(grammarAccess.getComRouteProtocolAccess().getInner_bufferAssignment_1_1_0_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getComRouteProtocolAccess().getBufferAssignment_1_1_0_1_1()); }
		(rule__ComRouteProtocol__BufferAssignment_1_1_0_1_1)
		{ after(grammarAccess.getComRouteProtocolAccess().getBufferAssignment_1_1_0_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComRouteProtocol__Alternatives_1_1_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getComRouteProtocolAccess().getInner_bufferAssignment_1_1_1_1_0()); }
		(rule__ComRouteProtocol__Inner_bufferAssignment_1_1_1_1_0)
		{ after(grammarAccess.getComRouteProtocolAccess().getInner_bufferAssignment_1_1_1_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getComRouteProtocolAccess().getBufferAssignment_1_1_1_1_1()); }
		(rule__ComRouteProtocol__BufferAssignment_1_1_1_1_1)
		{ after(grammarAccess.getComRouteProtocolAccess().getBufferAssignment_1_1_1_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Connection__Alternatives_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getConnectionAccess().getConnectorKeyword_0_0()); }
		'connector'
		{ after(grammarAccess.getConnectionAccess().getConnectorKeyword_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getConnectionAccess().getConnectKeyword_0_1()); }
		'connect'
		{ after(grammarAccess.getConnectionAccess().getConnectKeyword_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComProtocol__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getComProtocolAccess().getProtocolAssignment_0()); }
		(rule__ComProtocol__ProtocolAssignment_0)
		{ after(grammarAccess.getComProtocolAccess().getProtocolAssignment_0()); }
	)
	|
	(
		{ before(grammarAccess.getComProtocolAccess().getGroup_1()); }
		(rule__ComProtocol__Group_1__0)
		{ after(grammarAccess.getComProtocolAccess().getGroup_1()); }
	)
	|
	(
		{ before(grammarAccess.getComProtocolAccess().getGroup_2()); }
		(rule__ComProtocol__Group_2__0)
		{ after(grammarAccess.getComProtocolAccess().getGroup_2()); }
	)
	|
	(
		{ before(grammarAccess.getComProtocolAccess().getInner_bufferAssignment_3()); }
		(rule__ComProtocol__Inner_bufferAssignment_3)
		{ after(grammarAccess.getComProtocolAccess().getInner_bufferAssignment_3()); }
	)
	|
	(
		{ before(grammarAccess.getComProtocolAccess().getBufferAssignment_4()); }
		(rule__ComProtocol__BufferAssignment_4)
		{ after(grammarAccess.getComProtocolAccess().getBufferAssignment_4()); }
	)
	|
	(
		{ before(grammarAccess.getComProtocolAccess().getCastAssignment_5()); }
		(rule__ComProtocol__CastAssignment_5)
		{ after(grammarAccess.getComProtocolAccess().getCastAssignment_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComProtocol__Alternatives_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getComProtocolAccess().getGroup_2_1_0()); }
		(rule__ComProtocol__Group_2_1_0__0)
		{ after(grammarAccess.getComProtocolAccess().getGroup_2_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getComProtocolAccess().getGroup_2_1_1()); }
		(rule__ComProtocol__Group_2_1_1__0)
		{ after(grammarAccess.getComProtocolAccess().getGroup_2_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComProtocol__Alternatives_2_1_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getComProtocolAccess().getInner_bufferAssignment_2_1_0_1_0()); }
		(rule__ComProtocol__Inner_bufferAssignment_2_1_0_1_0)
		{ after(grammarAccess.getComProtocolAccess().getInner_bufferAssignment_2_1_0_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getComProtocolAccess().getBufferAssignment_2_1_0_1_1()); }
		(rule__ComProtocol__BufferAssignment_2_1_0_1_1)
		{ after(grammarAccess.getComProtocolAccess().getBufferAssignment_2_1_0_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComProtocol__Alternatives_2_1_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getComProtocolAccess().getInner_bufferAssignment_2_1_1_1_0()); }
		(rule__ComProtocol__Inner_bufferAssignment_2_1_1_1_0)
		{ after(grammarAccess.getComProtocolAccess().getInner_bufferAssignment_2_1_1_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getComProtocolAccess().getBufferAssignment_2_1_1_1_1()); }
		(rule__ComProtocol__BufferAssignment_2_1_1_1_1)
		{ after(grammarAccess.getComProtocolAccess().getBufferAssignment_2_1_1_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPoint__Alternatives_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getComPointAccess().getGroup_3_0()); }
		(rule__ComPoint__Group_3_0__0)
		{ after(grammarAccess.getComPointAccess().getGroup_3_0()); }
	)
	|
	(
		{ before(grammarAccess.getComPointAccess().getGroup_3_1()); }
		(rule__ComPoint__Group_3_1__0)
		{ after(grammarAccess.getComPointAccess().getGroup_3_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPointProtocol__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getComPointProtocolAccess().getGroup_0()); }
		(rule__ComPointProtocol__Group_0__0)
		{ after(grammarAccess.getComPointProtocolAccess().getGroup_0()); }
	)
	|
	(
		{ before(grammarAccess.getComPointProtocolAccess().getInner_bufferAssignment_1()); }
		(rule__ComPointProtocol__Inner_bufferAssignment_1)
		{ after(grammarAccess.getComPointProtocolAccess().getInner_bufferAssignment_1()); }
	)
	|
	(
		{ before(grammarAccess.getComPointProtocolAccess().getBufferAssignment_2()); }
		(rule__ComPointProtocol__BufferAssignment_2)
		{ after(grammarAccess.getComPointProtocolAccess().getBufferAssignment_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPointProtocol__Alternatives_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getComPointProtocolAccess().getGroup_0_1_0()); }
		(rule__ComPointProtocol__Group_0_1_0__0)
		{ after(grammarAccess.getComPointProtocolAccess().getGroup_0_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getComPointProtocolAccess().getGroup_0_1_1()); }
		(rule__ComPointProtocol__Group_0_1_1__0)
		{ after(grammarAccess.getComPointProtocolAccess().getGroup_0_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPointProtocol__Alternatives_0_1_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getComPointProtocolAccess().getInner_bufferAssignment_0_1_0_1_0()); }
		(rule__ComPointProtocol__Inner_bufferAssignment_0_1_0_1_0)
		{ after(grammarAccess.getComPointProtocolAccess().getInner_bufferAssignment_0_1_0_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getComPointProtocolAccess().getBufferAssignment_0_1_0_1_1()); }
		(rule__ComPointProtocol__BufferAssignment_0_1_0_1_1)
		{ after(grammarAccess.getComPointProtocolAccess().getBufferAssignment_0_1_0_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPointProtocol__Alternatives_0_1_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getComPointProtocolAccess().getInner_bufferAssignment_0_1_1_1_0()); }
		(rule__ComPointProtocol__Inner_bufferAssignment_0_1_1_1_0)
		{ after(grammarAccess.getComPointProtocolAccess().getInner_bufferAssignment_0_1_1_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getComPointProtocolAccess().getBufferAssignment_0_1_1_1_1()); }
		(rule__ComPointProtocol__BufferAssignment_0_1_1_1_1)
		{ after(grammarAccess.getComPointProtocolAccess().getBufferAssignment_0_1_1_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComBuffer__KindAlternatives_0_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getComBufferAccess().getKindValueDotFieldExpressionKindEnumRuleCall_0_1_0_0()); }
		ruleValueDotFieldExpressionKind
		{ after(grammarAccess.getComBufferAccess().getKindValueDotFieldExpressionKindEnumRuleCall_0_1_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getComBufferAccess().getKindValueArrowFieldExpressionKindEnumRuleCall_0_1_0_1()); }
		ruleValueArrowFieldExpressionKind
		{ after(grammarAccess.getComBufferAccess().getKindValueArrowFieldExpressionKindEnumRuleCall_0_1_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComElement__KindAlternatives_0_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getComElementAccess().getKindValueDotFieldExpressionKindEnumRuleCall_0_1_0_0()); }
		ruleValueDotFieldExpressionKind
		{ after(grammarAccess.getComElementAccess().getKindValueDotFieldExpressionKindEnumRuleCall_0_1_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getComElementAccess().getKindValueArrowFieldExpressionKindEnumRuleCall_0_1_0_1()); }
		ruleValueArrowFieldExpressionKind
		{ after(grammarAccess.getComElementAccess().getKindValueArrowFieldExpressionKindEnumRuleCall_0_1_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__LiteralPureReferenceMachine__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLiteralPureReferenceMachineAccess().getGroup_0()); }
		(rule__LiteralPureReferenceMachine__Group_0__0)
		{ after(grammarAccess.getLiteralPureReferenceMachineAccess().getGroup_0()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralPureReferenceMachineAccess().getLiteralReferenceMachineContextParserRuleCall_1()); }
		ruleLiteralReferenceMachineContext
		{ after(grammarAccess.getLiteralPureReferenceMachineAccess().getLiteralReferenceMachineContextParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TypeDefinition__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTypeDefinitionAccess().getEnumerationTypeDefinitionParserRuleCall_0()); }
		ruleEnumerationTypeDefinition
		{ after(grammarAccess.getTypeDefinitionAccess().getEnumerationTypeDefinitionParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getTypeDefinitionAccess().getStructureTypeDefinitionParserRuleCall_1()); }
		ruleStructureTypeDefinition
		{ after(grammarAccess.getTypeDefinitionAccess().getStructureTypeDefinitionParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getTypeDefinitionAccess().getUnionTypeDefinitionParserRuleCall_2()); }
		ruleUnionTypeDefinition
		{ after(grammarAccess.getTypeDefinitionAccess().getUnionTypeDefinitionParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getTypeDefinitionAccess().getChoiceTypeDefinitionParserRuleCall_3()); }
		ruleChoiceTypeDefinition
		{ after(grammarAccess.getTypeDefinitionAccess().getChoiceTypeDefinitionParserRuleCall_3()); }
	)
	|
	(
		{ before(grammarAccess.getTypeDefinitionAccess().getIntervalTypeDefinitionParserRuleCall_4()); }
		ruleIntervalTypeDefinition
		{ after(grammarAccess.getTypeDefinitionAccess().getIntervalTypeDefinitionParserRuleCall_4()); }
	)
	|
	(
		{ before(grammarAccess.getTypeDefinitionAccess().getCollectionTypeDefinitionParserRuleCall_5()); }
		ruleCollectionTypeDefinition
		{ after(grammarAccess.getTypeDefinitionAccess().getCollectionTypeDefinitionParserRuleCall_5()); }
	)
	|
	(
		{ before(grammarAccess.getTypeDefinitionAccess().getOtherDataTypeDefinitionParserRuleCall_6()); }
		ruleOtherDataTypeDefinition
		{ after(grammarAccess.getTypeDefinitionAccess().getOtherDataTypeDefinitionParserRuleCall_6()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__DataTypeMultiplicity__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getDataTypeMultiplicityAccess().getLiteralIntegerExpressionParserRuleCall_0()); }
		ruleLiteralIntegerExpression
		{ after(grammarAccess.getDataTypeMultiplicityAccess().getLiteralIntegerExpressionParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getDataTypeMultiplicityAccess().getLiteralReferenceElementParserRuleCall_1()); }
		ruleLiteralReferenceElement
		{ after(grammarAccess.getDataTypeMultiplicityAccess().getLiteralReferenceElementParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__DataTypeReference__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getDataTypeReferenceAccess().getGroup_0()); }
		(rule__DataTypeReference__Group_0__0)
		{ after(grammarAccess.getDataTypeReferenceAccess().getGroup_0()); }
	)
	|
	(
		{ before(grammarAccess.getDataTypeReferenceAccess().getGroup_1()); }
		(rule__DataTypeReference__Group_1__0)
		{ after(grammarAccess.getDataTypeReferenceAccess().getGroup_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinition__Alternatives_5
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getOtherDataTypeDefinitionAccess().getGroup_5_0()); }
		(rule__OtherDataTypeDefinition__Group_5_0__0)
		{ after(grammarAccess.getOtherDataTypeDefinitionAccess().getGroup_5_0()); }
	)
	|
	(
		{ before(grammarAccess.getOtherDataTypeDefinitionAccess().getGroup_5_1()); }
		(rule__OtherDataTypeDefinition__Group_5_1__0)
		{ after(grammarAccess.getOtherDataTypeDefinitionAccess().getGroup_5_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinitionImpl__Alternatives_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getOtherDataTypeDefinitionImplAccess().getGroup_3_0()); }
		(rule__OtherDataTypeDefinitionImpl__Group_3_0__0)
		{ after(grammarAccess.getOtherDataTypeDefinitionImplAccess().getGroup_3_0()); }
	)
	|
	(
		{ before(grammarAccess.getOtherDataTypeDefinitionImplAccess().getGroup_3_1()); }
		(rule__OtherDataTypeDefinitionImpl__Group_3_1__0)
		{ after(grammarAccess.getOtherDataTypeDefinitionImplAccess().getGroup_3_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__DataType__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getDataTypeAccess().getDataTypeReferenceParserRuleCall_0()); }
		ruleDataTypeReference
		{ after(grammarAccess.getDataTypeAccess().getDataTypeReferenceParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getDataTypeAccess().getStructuredDataTypeParserRuleCall_1()); }
		ruleStructuredDataType
		{ after(grammarAccess.getDataTypeAccess().getStructuredDataTypeParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleDataType__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSimpleDataTypeAccess().getPrimitiveTypeParserRuleCall_0()); }
		rulePrimitiveType
		{ after(grammarAccess.getSimpleDataTypeAccess().getPrimitiveTypeParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getSimpleDataTypeAccess().getIntervalTypeParserRuleCall_1()); }
		ruleIntervalType
		{ after(grammarAccess.getSimpleDataTypeAccess().getIntervalTypeParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getSimpleDataTypeAccess().getCollectionTypeParserRuleCall_2()); }
		ruleCollectionType
		{ after(grammarAccess.getSimpleDataTypeAccess().getCollectionTypeParserRuleCall_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__StructuredDataType__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStructuredDataTypeAccess().getEnumerationTypeParserRuleCall_0()); }
		ruleEnumerationType
		{ after(grammarAccess.getStructuredDataTypeAccess().getEnumerationTypeParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getStructuredDataTypeAccess().getStructureTypeParserRuleCall_1()); }
		ruleStructureType
		{ after(grammarAccess.getStructuredDataTypeAccess().getStructureTypeParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getStructuredDataTypeAccess().getUnionTypeParserRuleCall_2()); }
		ruleUnionType
		{ after(grammarAccess.getStructuredDataTypeAccess().getUnionTypeParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getStructuredDataTypeAccess().getChoiceTypeParserRuleCall_3()); }
		ruleChoiceType
		{ after(grammarAccess.getStructuredDataTypeAccess().getChoiceTypeParserRuleCall_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveType__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimitiveTypeAccess().getPrimitiveNumberTypeParserRuleCall_0()); }
		rulePrimitiveNumberType
		{ after(grammarAccess.getPrimitiveTypeAccess().getPrimitiveNumberTypeParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveTypeAccess().getOtherPrimitiveTypeParserRuleCall_1()); }
		ruleOtherPrimitiveType
		{ after(grammarAccess.getPrimitiveTypeAccess().getOtherPrimitiveTypeParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveNumberType__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimitiveNumberTypeAccess().getPrimitiveIntegerTypeParserRuleCall_0()); }
		rulePrimitiveIntegerType
		{ after(grammarAccess.getPrimitiveNumberTypeAccess().getPrimitiveIntegerTypeParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveNumberTypeAccess().getPrimitiveRationalTypeParserRuleCall_1()); }
		rulePrimitiveRationalType
		{ after(grammarAccess.getPrimitiveNumberTypeAccess().getPrimitiveRationalTypeParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveNumberTypeAccess().getPrimitiveFloatTypeParserRuleCall_2()); }
		rulePrimitiveFloatType
		{ after(grammarAccess.getPrimitiveNumberTypeAccess().getPrimitiveFloatTypeParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveNumberTypeAccess().getPrimitiveRealTypeParserRuleCall_3()); }
		rulePrimitiveRealType
		{ after(grammarAccess.getPrimitiveNumberTypeAccess().getPrimitiveRealTypeParserRuleCall_3()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveNumberTypeAccess().getPrimitiveTimeTypeParserRuleCall_4()); }
		rulePrimitiveTimeType
		{ after(grammarAccess.getPrimitiveNumberTypeAccess().getPrimitiveTimeTypeParserRuleCall_4()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveIntegerType__Alternatives_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimitiveIntegerTypeAccess().getIntegerKeyword_2_0()); }
		'integer'
		{ after(grammarAccess.getPrimitiveIntegerTypeAccess().getIntegerKeyword_2_0()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveIntegerTypeAccess().getUintegerKeyword_2_1()); }
		'uinteger'
		{ after(grammarAccess.getPrimitiveIntegerTypeAccess().getUintegerKeyword_2_1()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveIntegerTypeAccess().getIntKeyword_2_2()); }
		'int'
		{ after(grammarAccess.getPrimitiveIntegerTypeAccess().getIntKeyword_2_2()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveIntegerTypeAccess().getUintKeyword_2_3()); }
		'uint'
		{ after(grammarAccess.getPrimitiveIntegerTypeAccess().getUintKeyword_2_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveIntegerType__Alternatives_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimitiveIntegerTypeAccess().getGroup_3_0()); }
		(rule__PrimitiveIntegerType__Group_3_0__0)
		{ after(grammarAccess.getPrimitiveIntegerTypeAccess().getGroup_3_0()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveIntegerTypeAccess().getGroup_3_1()); }
		(rule__PrimitiveIntegerType__Group_3_1__0)
		{ after(grammarAccess.getPrimitiveIntegerTypeAccess().getGroup_3_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRationalType__Alternatives_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimitiveRationalTypeAccess().getRationalKeyword_2_0()); }
		'rational'
		{ after(grammarAccess.getPrimitiveRationalTypeAccess().getRationalKeyword_2_0()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveRationalTypeAccess().getUrationalKeyword_2_1()); }
		'urational'
		{ after(grammarAccess.getPrimitiveRationalTypeAccess().getUrationalKeyword_2_1()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveRationalTypeAccess().getRatKeyword_2_2()); }
		'rat'
		{ after(grammarAccess.getPrimitiveRationalTypeAccess().getRatKeyword_2_2()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveRationalTypeAccess().getUratKeyword_2_3()); }
		'urat'
		{ after(grammarAccess.getPrimitiveRationalTypeAccess().getUratKeyword_2_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRationalType__Alternatives_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimitiveRationalTypeAccess().getGroup_3_0()); }
		(rule__PrimitiveRationalType__Group_3_0__0)
		{ after(grammarAccess.getPrimitiveRationalTypeAccess().getGroup_3_0()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveRationalTypeAccess().getGroup_3_1()); }
		(rule__PrimitiveRationalType__Group_3_1__0)
		{ after(grammarAccess.getPrimitiveRationalTypeAccess().getGroup_3_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveFloatType__Alternatives_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimitiveFloatTypeAccess().getFloatKeyword_2_0()); }
		'float'
		{ after(grammarAccess.getPrimitiveFloatTypeAccess().getFloatKeyword_2_0()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveFloatTypeAccess().getUfloatKeyword_2_1()); }
		'ufloat'
		{ after(grammarAccess.getPrimitiveFloatTypeAccess().getUfloatKeyword_2_1()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveFloatTypeAccess().getDoubleKeyword_2_2()); }
		'double'
		{ after(grammarAccess.getPrimitiveFloatTypeAccess().getDoubleKeyword_2_2()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveFloatTypeAccess().getUdoubleKeyword_2_3()); }
		'udouble'
		{ after(grammarAccess.getPrimitiveFloatTypeAccess().getUdoubleKeyword_2_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveFloatType__Alternatives_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimitiveFloatTypeAccess().getGroup_3_0()); }
		(rule__PrimitiveFloatType__Group_3_0__0)
		{ after(grammarAccess.getPrimitiveFloatTypeAccess().getGroup_3_0()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveFloatTypeAccess().getGroup_3_1()); }
		(rule__PrimitiveFloatType__Group_3_1__0)
		{ after(grammarAccess.getPrimitiveFloatTypeAccess().getGroup_3_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRealType__Alternatives_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimitiveRealTypeAccess().getRealKeyword_2_0()); }
		'real'
		{ after(grammarAccess.getPrimitiveRealTypeAccess().getRealKeyword_2_0()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveRealTypeAccess().getUrealKeyword_2_1()); }
		'ureal'
		{ after(grammarAccess.getPrimitiveRealTypeAccess().getUrealKeyword_2_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRealType__Alternatives_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimitiveRealTypeAccess().getGroup_3_0()); }
		(rule__PrimitiveRealType__Group_3_0__0)
		{ after(grammarAccess.getPrimitiveRealTypeAccess().getGroup_3_0()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveRealTypeAccess().getGroup_3_1()); }
		(rule__PrimitiveRealType__Group_3_1__0)
		{ after(grammarAccess.getPrimitiveRealTypeAccess().getGroup_3_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveTimeType__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimitiveTimeTypeAccess().getGroup_0()); }
		(rule__PrimitiveTimeType__Group_0__0)
		{ after(grammarAccess.getPrimitiveTimeTypeAccess().getGroup_0()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveTimeTypeAccess().getGroup_1()); }
		(rule__PrimitiveTimeType__Group_1__0)
		{ after(grammarAccess.getPrimitiveTimeTypeAccess().getGroup_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveTimeType__Alternatives_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimitiveTimeTypeAccess().getGroup_0_2_0()); }
		(rule__PrimitiveTimeType__Group_0_2_0__0)
		{ after(grammarAccess.getPrimitiveTimeTypeAccess().getGroup_0_2_0()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveTimeTypeAccess().getSupportAssignment_0_2_1()); }
		(rule__PrimitiveTimeType__SupportAssignment_0_2_1)
		{ after(grammarAccess.getPrimitiveTimeTypeAccess().getSupportAssignment_0_2_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveTimeType__Alternatives_1_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimitiveTimeTypeAccess().getGroup_1_2_0()); }
		(rule__PrimitiveTimeType__Group_1_2_0__0)
		{ after(grammarAccess.getPrimitiveTimeTypeAccess().getGroup_1_2_0()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveTimeTypeAccess().getSupportAssignment_1_2_1()); }
		(rule__PrimitiveTimeType__SupportAssignment_1_2_1)
		{ after(grammarAccess.getPrimitiveTimeTypeAccess().getSupportAssignment_1_2_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveTimeNumberType__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimitiveTimeNumberTypeAccess().getPrimitiveIntegerTypeParserRuleCall_0()); }
		rulePrimitiveIntegerType
		{ after(grammarAccess.getPrimitiveTimeNumberTypeAccess().getPrimitiveIntegerTypeParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveTimeNumberTypeAccess().getPrimitiveRationalTypeParserRuleCall_1()); }
		rulePrimitiveRationalType
		{ after(grammarAccess.getPrimitiveTimeNumberTypeAccess().getPrimitiveRationalTypeParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveTimeNumberTypeAccess().getPrimitiveFloatTypeParserRuleCall_2()); }
		rulePrimitiveFloatType
		{ after(grammarAccess.getPrimitiveTimeNumberTypeAccess().getPrimitiveFloatTypeParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveTimeNumberTypeAccess().getPrimitiveRealTypeParserRuleCall_3()); }
		rulePrimitiveRealType
		{ after(grammarAccess.getPrimitiveTimeNumberTypeAccess().getPrimitiveRealTypeParserRuleCall_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherPrimitiveType__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getOtherPrimitiveTypeAccess().getPrimitiveBooleanTypeParserRuleCall_0()); }
		rulePrimitiveBooleanType
		{ after(grammarAccess.getOtherPrimitiveTypeAccess().getPrimitiveBooleanTypeParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getOtherPrimitiveTypeAccess().getPrimitiveCharacterTypeParserRuleCall_1()); }
		rulePrimitiveCharacterType
		{ after(grammarAccess.getOtherPrimitiveTypeAccess().getPrimitiveCharacterTypeParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getOtherPrimitiveTypeAccess().getPrimitiveStringTypeParserRuleCall_2()); }
		rulePrimitiveStringType
		{ after(grammarAccess.getOtherPrimitiveTypeAccess().getPrimitiveStringTypeParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getOtherPrimitiveTypeAccess().getPrimitiveInstanceTypeParserRuleCall_3()); }
		rulePrimitiveInstanceType
		{ after(grammarAccess.getOtherPrimitiveTypeAccess().getPrimitiveInstanceTypeParserRuleCall_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveBooleanType__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimitiveBooleanTypeAccess().getBooleanKeyword_1_0()); }
		'boolean'
		{ after(grammarAccess.getPrimitiveBooleanTypeAccess().getBooleanKeyword_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveBooleanTypeAccess().getBoolKeyword_1_1()); }
		'bool'
		{ after(grammarAccess.getPrimitiveBooleanTypeAccess().getBoolKeyword_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveStringType__Alternatives_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimitiveStringTypeAccess().getGroup_2_0()); }
		(rule__PrimitiveStringType__Group_2_0__0)
		{ after(grammarAccess.getPrimitiveStringTypeAccess().getGroup_2_0()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveStringTypeAccess().getGroup_2_1()); }
		(rule__PrimitiveStringType__Group_2_1__0)
		{ after(grammarAccess.getPrimitiveStringTypeAccess().getGroup_2_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalType__Alternatives_4
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIntervalTypeAccess().getLopenAssignment_4_0()); }
		(rule__IntervalType__LopenAssignment_4_0)
		{ after(grammarAccess.getIntervalTypeAccess().getLopenAssignment_4_0()); }
	)
	|
	(
		{ before(grammarAccess.getIntervalTypeAccess().getLeftSquareBracketKeyword_4_1()); }
		'['
		{ after(grammarAccess.getIntervalTypeAccess().getLeftSquareBracketKeyword_4_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalType__Alternatives_8
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIntervalTypeAccess().getRightSquareBracketKeyword_8_0()); }
		']'
		{ after(grammarAccess.getIntervalTypeAccess().getRightSquareBracketKeyword_8_0()); }
	)
	|
	(
		{ before(grammarAccess.getIntervalTypeAccess().getRopenAssignment_8_1()); }
		(rule__IntervalType__RopenAssignment_8_1)
		{ after(grammarAccess.getIntervalTypeAccess().getRopenAssignment_8_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinition__Alternatives_8
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIntervalTypeDefinitionAccess().getLopenAssignment_8_0()); }
		(rule__IntervalTypeDefinition__LopenAssignment_8_0)
		{ after(grammarAccess.getIntervalTypeDefinitionAccess().getLopenAssignment_8_0()); }
	)
	|
	(
		{ before(grammarAccess.getIntervalTypeDefinitionAccess().getLeftSquareBracketKeyword_8_1()); }
		'['
		{ after(grammarAccess.getIntervalTypeDefinitionAccess().getLeftSquareBracketKeyword_8_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinition__Alternatives_12
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIntervalTypeDefinitionAccess().getRightSquareBracketKeyword_12_0()); }
		']'
		{ after(grammarAccess.getIntervalTypeDefinitionAccess().getRightSquareBracketKeyword_12_0()); }
	)
	|
	(
		{ before(grammarAccess.getIntervalTypeDefinitionAccess().getRopenAssignment_12_1()); }
		(rule__IntervalTypeDefinition__RopenAssignment_12_1)
		{ after(grammarAccess.getIntervalTypeDefinitionAccess().getRopenAssignment_12_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinitionImpl__Alternatives_6
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIntervalTypeDefinitionImplAccess().getLopenAssignment_6_0()); }
		(rule__IntervalTypeDefinitionImpl__LopenAssignment_6_0)
		{ after(grammarAccess.getIntervalTypeDefinitionImplAccess().getLopenAssignment_6_0()); }
	)
	|
	(
		{ before(grammarAccess.getIntervalTypeDefinitionImplAccess().getLeftSquareBracketKeyword_6_1()); }
		'['
		{ after(grammarAccess.getIntervalTypeDefinitionImplAccess().getLeftSquareBracketKeyword_6_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinitionImpl__Alternatives_10
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getIntervalTypeDefinitionImplAccess().getRightSquareBracketKeyword_10_0()); }
		']'
		{ after(grammarAccess.getIntervalTypeDefinitionImplAccess().getRightSquareBracketKeyword_10_0()); }
	)
	|
	(
		{ before(grammarAccess.getIntervalTypeDefinitionImplAccess().getRopenAssignment_10_1()); }
		(rule__IntervalTypeDefinitionImpl__RopenAssignment_10_1)
		{ after(grammarAccess.getIntervalTypeDefinitionImplAccess().getRopenAssignment_10_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionType__Alternatives_2_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getCollectionTypeAccess().getSizeAssignment_2_2_1_0()); }
		(rule__CollectionType__SizeAssignment_2_2_1_0)
		{ after(grammarAccess.getCollectionTypeAccess().getSizeAssignment_2_2_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getCollectionTypeAccess().getUnboundedAssignment_2_2_1_1()); }
		(rule__CollectionType__UnboundedAssignment_2_2_1_1)
		{ after(grammarAccess.getCollectionTypeAccess().getUnboundedAssignment_2_2_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinition__Alternatives_8_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getCollectionTypeDefinitionAccess().getSizeAssignment_8_1_0()); }
		(rule__CollectionTypeDefinition__SizeAssignment_8_1_0)
		{ after(grammarAccess.getCollectionTypeDefinitionAccess().getSizeAssignment_8_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getCollectionTypeDefinitionAccess().getUnboundedAssignment_8_1_1()); }
		(rule__CollectionTypeDefinition__UnboundedAssignment_8_1_1)
		{ after(grammarAccess.getCollectionTypeDefinitionAccess().getUnboundedAssignment_8_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinitionImpl__Alternatives_6_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getCollectionTypeDefinitionImplAccess().getSizeAssignment_6_1_0()); }
		(rule__CollectionTypeDefinitionImpl__SizeAssignment_6_1_0)
		{ after(grammarAccess.getCollectionTypeDefinitionImplAccess().getSizeAssignment_6_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getCollectionTypeDefinitionImplAccess().getUnboundedAssignment_6_1_1()); }
		(rule__CollectionTypeDefinitionImpl__UnboundedAssignment_6_1_1)
		{ after(grammarAccess.getCollectionTypeDefinitionImplAccess().getUnboundedAssignment_6_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVariableAccess().getVarKeyword_1_0()); }
		'var'
		{ after(grammarAccess.getVariableAccess().getVarKeyword_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getVariableAccess().getConstAssignment_1_1()); }
		(rule__Variable__ConstAssignment_1_1)
		{ after(grammarAccess.getVariableAccess().getConstAssignment_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getVariableAccess().getGroup_1_2()); }
		(rule__Variable__Group_1_2__0)
		{ after(grammarAccess.getVariableAccess().getGroup_1_2()); }
	)
	|
	(
		{ before(grammarAccess.getVariableAccess().getGroup_1_3()); }
		(rule__Variable__Group_1_3__0)
		{ after(grammarAccess.getVariableAccess().getGroup_1_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Alternatives_1_2_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVariableAccess().getConstAssignment_1_2_0_0()); }
		(rule__Variable__ConstAssignment_1_2_0_0)
		{ after(grammarAccess.getVariableAccess().getConstAssignment_1_2_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getVariableAccess().getConstAssignment_1_2_0_1()); }
		(rule__Variable__ConstAssignment_1_2_0_1)
		{ after(grammarAccess.getVariableAccess().getConstAssignment_1_2_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Alternatives_1_3_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVariableAccess().getVarKeyword_1_3_1_0()); }
		'var'
		{ after(grammarAccess.getVariableAccess().getVarKeyword_1_3_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getVariableAccess().getConstAssignment_1_3_1_1()); }
		(rule__Variable__ConstAssignment_1_3_1_1)
		{ after(grammarAccess.getVariableAccess().getConstAssignment_1_3_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Alternatives_7
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVariableAccess().getGroup_7_0()); }
		(rule__Variable__Group_7_0__0)
		{ after(grammarAccess.getVariableAccess().getGroup_7_0()); }
	)
	|
	(
		{ before(grammarAccess.getVariableAccess().getSemicolonKeyword_7_1()); }
		';'
		{ after(grammarAccess.getVariableAccess().getSemicolonKeyword_7_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePublic__Alternatives_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVariablePublicAccess().getConstAssignment_1_0_0()); }
		(rule__VariablePublic__ConstAssignment_1_0_0)
		{ after(grammarAccess.getVariablePublicAccess().getConstAssignment_1_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getVariablePublicAccess().getConstAssignment_1_0_1()); }
		(rule__VariablePublic__ConstAssignment_1_0_1)
		{ after(grammarAccess.getVariablePublicAccess().getConstAssignment_1_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePublic__Alternatives_8
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVariablePublicAccess().getGroup_8_0()); }
		(rule__VariablePublic__Group_8_0__0)
		{ after(grammarAccess.getVariablePublicAccess().getGroup_8_0()); }
	)
	|
	(
		{ before(grammarAccess.getVariablePublicAccess().getSemicolonKeyword_8_1()); }
		';'
		{ after(grammarAccess.getVariablePublicAccess().getSemicolonKeyword_8_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableProtected__Alternatives_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVariableProtectedAccess().getConstAssignment_1_0_0()); }
		(rule__VariableProtected__ConstAssignment_1_0_0)
		{ after(grammarAccess.getVariableProtectedAccess().getConstAssignment_1_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getVariableProtectedAccess().getConstAssignment_1_0_1()); }
		(rule__VariableProtected__ConstAssignment_1_0_1)
		{ after(grammarAccess.getVariableProtectedAccess().getConstAssignment_1_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableProtected__Alternatives_8
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVariableProtectedAccess().getGroup_8_0()); }
		(rule__VariableProtected__Group_8_0__0)
		{ after(grammarAccess.getVariableProtectedAccess().getGroup_8_0()); }
	)
	|
	(
		{ before(grammarAccess.getVariableProtectedAccess().getSemicolonKeyword_8_1()); }
		';'
		{ after(grammarAccess.getVariableProtectedAccess().getSemicolonKeyword_8_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePrivate__Alternatives_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVariablePrivateAccess().getConstAssignment_1_0_0()); }
		(rule__VariablePrivate__ConstAssignment_1_0_0)
		{ after(grammarAccess.getVariablePrivateAccess().getConstAssignment_1_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getVariablePrivateAccess().getConstAssignment_1_0_1()); }
		(rule__VariablePrivate__ConstAssignment_1_0_1)
		{ after(grammarAccess.getVariablePrivateAccess().getConstAssignment_1_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePrivate__Alternatives_8
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVariablePrivateAccess().getGroup_8_0()); }
		(rule__VariablePrivate__Group_8_0__0)
		{ after(grammarAccess.getVariablePrivateAccess().getGroup_8_0()); }
	)
	|
	(
		{ before(grammarAccess.getVariablePrivateAccess().getSemicolonKeyword_8_1()); }
		';'
		{ after(grammarAccess.getVariablePrivateAccess().getSemicolonKeyword_8_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferContainerType__Alternatives_2_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBufferContainerTypeAccess().getSizeAssignment_2_1_0()); }
		(rule__BufferContainerType__SizeAssignment_2_1_0)
		{ after(grammarAccess.getBufferContainerTypeAccess().getSizeAssignment_2_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getBufferContainerTypeAccess().getUnboundedAssignment_2_1_1()); }
		(rule__BufferContainerType__UnboundedAssignment_2_1_1)
		{ after(grammarAccess.getBufferContainerTypeAccess().getUnboundedAssignment_2_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Port__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPortAccess().getGroup_1_0()); }
		(rule__Port__Group_1_0__0)
		{ after(grammarAccess.getPortAccess().getGroup_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getPortAccess().getGroup_1_1()); }
		(rule__Port__Group_1_1__0)
		{ after(grammarAccess.getPortAccess().getGroup_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPublic__Alternatives_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPortPublicAccess().getGroup_0_0()); }
		(rule__PortPublic__Group_0_0__0)
		{ after(grammarAccess.getPortPublicAccess().getGroup_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getPortPublicAccess().getGroup_0_1()); }
		(rule__PortPublic__Group_0_1__0)
		{ after(grammarAccess.getPortPublicAccess().getGroup_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PortProtected__Alternatives_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPortProtectedAccess().getGroup_0_0()); }
		(rule__PortProtected__Group_0_0__0)
		{ after(grammarAccess.getPortProtectedAccess().getGroup_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getPortProtectedAccess().getGroup_0_1()); }
		(rule__PortProtected__Group_0_1__0)
		{ after(grammarAccess.getPortProtectedAccess().getGroup_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPrivate__Alternatives_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPortPrivateAccess().getGroup_0_0()); }
		(rule__PortPrivate__Group_0_0__0)
		{ after(grammarAccess.getPortPrivateAccess().getGroup_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getPortPrivateAccess().getGroup_0_1()); }
		(rule__PortPrivate__Group_0_1__0)
		{ after(grammarAccess.getPortPrivateAccess().getGroup_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Alternatives_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSignalAccess().getGroup_0_0()); }
		(rule__Signal__Group_0_0__0)
		{ after(grammarAccess.getSignalAccess().getGroup_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getSignalAccess().getGroup_0_1()); }
		(rule__Signal__Group_0_1__0)
		{ after(grammarAccess.getSignalAccess().getGroup_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPublic__Alternatives_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSignalPublicAccess().getGroup_0_0()); }
		(rule__SignalPublic__Group_0_0__0)
		{ after(grammarAccess.getSignalPublicAccess().getGroup_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getSignalPublicAccess().getGroup_0_1()); }
		(rule__SignalPublic__Group_0_1__0)
		{ after(grammarAccess.getSignalPublicAccess().getGroup_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalProtected__Alternatives_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSignalProtectedAccess().getGroup_0_0()); }
		(rule__SignalProtected__Group_0_0__0)
		{ after(grammarAccess.getSignalProtectedAccess().getGroup_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getSignalProtectedAccess().getGroup_0_1()); }
		(rule__SignalProtected__Group_0_1__0)
		{ after(grammarAccess.getSignalProtectedAccess().getGroup_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPrivate__Alternatives_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getSignalPrivateAccess().getGroup_0_0()); }
		(rule__SignalPrivate__Group_0_0__0)
		{ after(grammarAccess.getSignalPrivateAccess().getGroup_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getSignalPrivateAccess().getGroup_0_1()); }
		(rule__SignalPrivate__Group_0_1__0)
		{ after(grammarAccess.getSignalPrivateAccess().getGroup_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Alternatives_5
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTransitionAccess().getGroup_5_0()); }
		(rule__Transition__Group_5_0__0)
		{ after(grammarAccess.getTransitionAccess().getGroup_5_0()); }
	)
	|
	(
		{ before(grammarAccess.getTransitionAccess().getGroup_5_1()); }
		(rule__Transition__Group_5_1__0)
		{ after(grammarAccess.getTransitionAccess().getGroup_5_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Alternatives_5_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTransitionAccess().getGroup_5_0_1_0()); }
		(rule__Transition__Group_5_0_1_0__0)
		{ after(grammarAccess.getTransitionAccess().getGroup_5_0_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getTransitionAccess().getBehaviorAssignment_5_0_1_1()); }
		(rule__Transition__BehaviorAssignment_5_0_1_1)
		{ after(grammarAccess.getTransitionAccess().getBehaviorAssignment_5_0_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Alternatives_5_0_1_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTransitionAccess().getGuardAssignment_5_0_1_0_1_0()); }
		(rule__Transition__GuardAssignment_5_0_1_0_1_0)
		{ after(grammarAccess.getTransitionAccess().getGuardAssignment_5_0_1_0_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getTransitionAccess().getGuardKeyword_5_0_1_0_1_1()); }
		'@guard:'
		{ after(grammarAccess.getTransitionAccess().getGuardKeyword_5_0_1_0_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Alternatives_5_0_1_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTransitionAccess().getTguardAssignment_5_0_1_0_2_0()); }
		(rule__Transition__TguardAssignment_5_0_1_0_2_0)
		{ after(grammarAccess.getTransitionAccess().getTguardAssignment_5_0_1_0_2_0()); }
	)
	|
	(
		{ before(grammarAccess.getTransitionAccess().getTguardKeyword_5_0_1_0_2_1()); }
		'@tguard:'
		{ after(grammarAccess.getTransitionAccess().getTguardKeyword_5_0_1_0_2_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Alternatives_5_1_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTransitionAccess().getGroup_5_1_2_0()); }
		(rule__Transition__Group_5_1_2_0__0)
		{ after(grammarAccess.getTransitionAccess().getGroup_5_1_2_0()); }
	)
	|
	(
		{ before(grammarAccess.getTransitionAccess().getSemicolonKeyword_5_1_2_1()); }
		';'
		{ after(grammarAccess.getTransitionAccess().getSemicolonKeyword_5_1_2_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Alternatives_5_1_2_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTransitionAccess().getGroup_5_1_2_0_1_0()); }
		(rule__Transition__Group_5_1_2_0_1_0__0)
		{ after(grammarAccess.getTransitionAccess().getGroup_5_1_2_0_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getTransitionAccess().getBehaviorAssignment_5_1_2_0_1_1()); }
		(rule__Transition__BehaviorAssignment_5_1_2_0_1_1)
		{ after(grammarAccess.getTransitionAccess().getBehaviorAssignment_5_1_2_0_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Alternatives_5_1_2_0_1_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTransitionAccess().getGuardAssignment_5_1_2_0_1_0_1_0()); }
		(rule__Transition__GuardAssignment_5_1_2_0_1_0_1_0)
		{ after(grammarAccess.getTransitionAccess().getGuardAssignment_5_1_2_0_1_0_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getTransitionAccess().getGuardKeyword_5_1_2_0_1_0_1_1()); }
		'@guard:'
		{ after(grammarAccess.getTransitionAccess().getGuardKeyword_5_1_2_0_1_0_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Alternatives_5_1_2_0_1_0_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTransitionAccess().getTguardAssignment_5_1_2_0_1_0_2_0()); }
		(rule__Transition__TguardAssignment_5_1_2_0_1_0_2_0)
		{ after(grammarAccess.getTransitionAccess().getTguardAssignment_5_1_2_0_1_0_2_0()); }
	)
	|
	(
		{ before(grammarAccess.getTransitionAccess().getTguardKeyword_5_1_2_0_1_0_2_1()); }
		'@tguard:'
		{ after(grammarAccess.getTransitionAccess().getTguardKeyword_5_1_2_0_1_0_2_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TransitionMoe__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTransitionMoeAccess().getGroup_1_0()); }
		(rule__TransitionMoe__Group_1_0__0)
		{ after(grammarAccess.getTransitionMoeAccess().getGroup_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getTransitionMoeAccess().getGroup_1_1()); }
		(rule__TransitionMoe__Group_1_1__0)
		{ after(grammarAccess.getTransitionMoeAccess().getGroup_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TransitionMoe__Alternatives_1_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTransitionMoeAccess().getGroup_1_0_1_0()); }
		(rule__TransitionMoe__Group_1_0_1_0__0)
		{ after(grammarAccess.getTransitionMoeAccess().getGroup_1_0_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getTransitionMoeAccess().getIsElseAssignment_1_0_1_1()); }
		(rule__TransitionMoe__IsElseAssignment_1_0_1_1)
		{ after(grammarAccess.getTransitionMoeAccess().getIsElseAssignment_1_0_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TransitionGuard__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTransitionGuardAccess().getGroup_0()); }
		(rule__TransitionGuard__Group_0__0)
		{ after(grammarAccess.getTransitionGuardAccess().getGroup_0()); }
	)
	|
	(
		{ before(grammarAccess.getTransitionGuardAccess().getGroup_1()); }
		(rule__TransitionGuard__Group_1__0)
		{ after(grammarAccess.getTransitionGuardAccess().getGroup_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TransitionGuard__Alternatives_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTransitionGuardAccess().getGroup_1_1_0()); }
		(rule__TransitionGuard__Group_1_1_0__0)
		{ after(grammarAccess.getTransitionGuardAccess().getGroup_1_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getTransitionGuardAccess().getGuardStatementParserRuleCall_1_1_1()); }
		ruleGuardStatement
		{ after(grammarAccess.getTransitionGuardAccess().getGuardStatementParserRuleCall_1_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getTransitionGuardAccess().getEventGuardStatementParserRuleCall_1_1_2()); }
		ruleEventGuardStatement
		{ after(grammarAccess.getTransitionGuardAccess().getEventGuardStatementParserRuleCall_1_1_2()); }
	)
	|
	(
		{ before(grammarAccess.getTransitionGuardAccess().getCheckSatGuardStatementParserRuleCall_1_1_3()); }
		ruleCheckSatGuardStatement
		{ after(grammarAccess.getTransitionGuardAccess().getCheckSatGuardStatementParserRuleCall_1_1_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TransitionGuard__Alternatives_1_1_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTransitionGuardAccess().getGroup_1_1_0_1_0()); }
		(rule__TransitionGuard__Group_1_1_0_1_0__0)
		{ after(grammarAccess.getTransitionGuardAccess().getGroup_1_1_0_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getTransitionGuardAccess().getConditionAssignment_1_1_0_1_1()); }
		(rule__TransitionGuard__ConditionAssignment_1_1_0_1_1)
		{ after(grammarAccess.getTransitionGuardAccess().getConditionAssignment_1_1_0_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TransitionGuardExpression__OperatorAlternatives_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTransitionGuardExpressionAccess().getOperatorAmpersandAmpersandKeyword_1_0_0()); }
		'&&'
		{ after(grammarAccess.getTransitionGuardExpressionAccess().getOperatorAmpersandAmpersandKeyword_1_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getTransitionGuardExpressionAccess().getOperatorAndKeyword_1_0_1()); }
		'and'
		{ after(grammarAccess.getTransitionGuardExpressionAccess().getOperatorAndKeyword_1_0_1()); }
	)
	|
	(
		{ before(grammarAccess.getTransitionGuardExpressionAccess().getOperatorVerticalLineVerticalLineKeyword_1_0_2()); }
		'||'
		{ after(grammarAccess.getTransitionGuardExpressionAccess().getOperatorVerticalLineVerticalLineKeyword_1_0_2()); }
	)
	|
	(
		{ before(grammarAccess.getTransitionGuardExpressionAccess().getOperatorOrKeyword_1_0_3()); }
		'or'
		{ after(grammarAccess.getTransitionGuardExpressionAccess().getOperatorOrKeyword_1_0_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TransitionTimedGuard__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTransitionTimedGuardAccess().getGroup_0()); }
		(rule__TransitionTimedGuard__Group_0__0)
		{ after(grammarAccess.getTransitionTimedGuardAccess().getGroup_0()); }
	)
	|
	(
		{ before(grammarAccess.getTransitionTimedGuardAccess().getGroup_1()); }
		(rule__TransitionTimedGuard__Group_1__0)
		{ after(grammarAccess.getTransitionTimedGuardAccess().getGroup_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TransitionTimedGuard__Alternatives_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTransitionTimedGuardAccess().getGroup_1_1_0()); }
		(rule__TransitionTimedGuard__Group_1_1_0__0)
		{ after(grammarAccess.getTransitionTimedGuardAccess().getGroup_1_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getTransitionTimedGuardAccess().getTimedGuardStatementParserRuleCall_1_1_1()); }
		ruleTimedGuardStatement
		{ after(grammarAccess.getTransitionTimedGuardAccess().getTimedGuardStatementParserRuleCall_1_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TransitionTimedGuard__Alternatives_1_1_0_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTransitionTimedGuardAccess().getGroup_1_1_0_1_0()); }
		(rule__TransitionTimedGuard__Group_1_1_0_1_0__0)
		{ after(grammarAccess.getTransitionTimedGuardAccess().getGroup_1_1_0_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getTransitionTimedGuardAccess().getConditionAssignment_1_1_0_1_1()); }
		(rule__TransitionTimedGuard__ConditionAssignment_1_1_0_1_1)
		{ after(grammarAccess.getTransitionTimedGuardAccess().getConditionAssignment_1_1_0_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TransitionEffectStatement__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTransitionEffectStatementAccess().getExpressionStatementParserRuleCall_0()); }
		ruleExpressionStatement
		{ after(grammarAccess.getTransitionEffectStatementAccess().getExpressionStatementParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getTransitionEffectStatementAccess().getOutputComStatementParserRuleCall_1()); }
		ruleOutputComStatement
		{ after(grammarAccess.getTransitionEffectStatementAccess().getOutputComStatementParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getTransitionEffectStatementAccess().getIfStatementParserRuleCall_2()); }
		ruleIfStatement
		{ after(grammarAccess.getTransitionEffectStatementAccess().getIfStatementParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getTransitionEffectStatementAccess().getWhileDoStatementParserRuleCall_3()); }
		ruleWhileDoStatement
		{ after(grammarAccess.getTransitionEffectStatementAccess().getWhileDoStatementParserRuleCall_3()); }
	)
	|
	(
		{ before(grammarAccess.getTransitionEffectStatementAccess().getDoWhileStatementParserRuleCall_4()); }
		ruleDoWhileStatement
		{ after(grammarAccess.getTransitionEffectStatementAccess().getDoWhileStatementParserRuleCall_4()); }
	)
	|
	(
		{ before(grammarAccess.getTransitionEffectStatementAccess().getForStatementParserRuleCall_5()); }
		ruleForStatement
		{ after(grammarAccess.getTransitionEffectStatementAccess().getForStatementParserRuleCall_5()); }
	)
	|
	(
		{ before(grammarAccess.getTransitionEffectStatementAccess().getForEachStatementParserRuleCall_6()); }
		ruleForEachStatement
		{ after(grammarAccess.getTransitionEffectStatementAccess().getForEachStatementParserRuleCall_6()); }
	)
	|
	(
		{ before(grammarAccess.getTransitionEffectStatementAccess().getInterruptStatementParserRuleCall_7()); }
		ruleInterruptStatement
		{ after(grammarAccess.getTransitionEffectStatementAccess().getInterruptStatementParserRuleCall_7()); }
	)
	|
	(
		{ before(grammarAccess.getTransitionEffectStatementAccess().getActivityStatementParserRuleCall_8()); }
		ruleActivityStatement
		{ after(grammarAccess.getTransitionEffectStatementAccess().getActivityStatementParserRuleCall_8()); }
	)
	|
	(
		{ before(grammarAccess.getTransitionEffectStatementAccess().getInvokeStatementParserRuleCall_9()); }
		ruleInvokeStatement
		{ after(grammarAccess.getTransitionEffectStatementAccess().getInvokeStatementParserRuleCall_9()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statement__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getStatementAccess().getBlockStatementParserRuleCall_0()); }
		ruleBlockStatement
		{ after(grammarAccess.getStatementAccess().getBlockStatementParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getStatementAccess().getExpressionStatementParserRuleCall_1()); }
		ruleExpressionStatement
		{ after(grammarAccess.getStatementAccess().getExpressionStatementParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getStatementAccess().getGuardStatementParserRuleCall_2()); }
		ruleGuardStatement
		{ after(grammarAccess.getStatementAccess().getGuardStatementParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getStatementAccess().getTimedGuardStatementParserRuleCall_3()); }
		ruleTimedGuardStatement
		{ after(grammarAccess.getStatementAccess().getTimedGuardStatementParserRuleCall_3()); }
	)
	|
	(
		{ before(grammarAccess.getStatementAccess().getEventGuardStatementParserRuleCall_4()); }
		ruleEventGuardStatement
		{ after(grammarAccess.getStatementAccess().getEventGuardStatementParserRuleCall_4()); }
	)
	|
	(
		{ before(grammarAccess.getStatementAccess().getCheckSatGuardStatementParserRuleCall_5()); }
		ruleCheckSatGuardStatement
		{ after(grammarAccess.getStatementAccess().getCheckSatGuardStatementParserRuleCall_5()); }
	)
	|
	(
		{ before(grammarAccess.getStatementAccess().getInputComStatementParserRuleCall_6()); }
		ruleInputComStatement
		{ after(grammarAccess.getStatementAccess().getInputComStatementParserRuleCall_6()); }
	)
	|
	(
		{ before(grammarAccess.getStatementAccess().getOutputComStatementParserRuleCall_7()); }
		ruleOutputComStatement
		{ after(grammarAccess.getStatementAccess().getOutputComStatementParserRuleCall_7()); }
	)
	|
	(
		{ before(grammarAccess.getStatementAccess().getIfStatementParserRuleCall_8()); }
		ruleIfStatement
		{ after(grammarAccess.getStatementAccess().getIfStatementParserRuleCall_8()); }
	)
	|
	(
		{ before(grammarAccess.getStatementAccess().getWhileDoStatementParserRuleCall_9()); }
		ruleWhileDoStatement
		{ after(grammarAccess.getStatementAccess().getWhileDoStatementParserRuleCall_9()); }
	)
	|
	(
		{ before(grammarAccess.getStatementAccess().getDoWhileStatementParserRuleCall_10()); }
		ruleDoWhileStatement
		{ after(grammarAccess.getStatementAccess().getDoWhileStatementParserRuleCall_10()); }
	)
	|
	(
		{ before(grammarAccess.getStatementAccess().getForStatementParserRuleCall_11()); }
		ruleForStatement
		{ after(grammarAccess.getStatementAccess().getForStatementParserRuleCall_11()); }
	)
	|
	(
		{ before(grammarAccess.getStatementAccess().getForEachStatementParserRuleCall_12()); }
		ruleForEachStatement
		{ after(grammarAccess.getStatementAccess().getForEachStatementParserRuleCall_12()); }
	)
	|
	(
		{ before(grammarAccess.getStatementAccess().getInterruptStatementParserRuleCall_13()); }
		ruleInterruptStatement
		{ after(grammarAccess.getStatementAccess().getInterruptStatementParserRuleCall_13()); }
	)
	|
	(
		{ before(grammarAccess.getStatementAccess().getActivityStatementParserRuleCall_14()); }
		ruleActivityStatement
		{ after(grammarAccess.getStatementAccess().getActivityStatementParserRuleCall_14()); }
	)
	|
	(
		{ before(grammarAccess.getStatementAccess().getInvokeStatementParserRuleCall_15()); }
		ruleInvokeStatement
		{ after(grammarAccess.getStatementAccess().getInvokeStatementParserRuleCall_15()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BlockStatementScheduler__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBlockStatementSchedulerAccess().getVerticalLineSemicolonVerticalLineKeyword_0()); }
		'|;|'
		{ after(grammarAccess.getBlockStatementSchedulerAccess().getVerticalLineSemicolonVerticalLineKeyword_0()); }
	)
	|
	(
		{ before(grammarAccess.getBlockStatementSchedulerAccess().getVerticalLineSectionSignVerticalLineKeyword_1()); }
		'|\u00A7|'
		{ after(grammarAccess.getBlockStatementSchedulerAccess().getVerticalLineSectionSignVerticalLineKeyword_1()); }
	)
	|
	(
		{ before(grammarAccess.getBlockStatementSchedulerAccess().getVerticalLineSemicolonSemicolonVerticalLineKeyword_2()); }
		'|;;|'
		{ after(grammarAccess.getBlockStatementSchedulerAccess().getVerticalLineSemicolonSemicolonVerticalLineKeyword_2()); }
	)
	|
	(
		{ before(grammarAccess.getBlockStatementSchedulerAccess().getVerticalLineFullStopVerticalLineKeyword_3()); }
		'|.|'
		{ after(grammarAccess.getBlockStatementSchedulerAccess().getVerticalLineFullStopVerticalLineKeyword_3()); }
	)
	|
	(
		{ before(grammarAccess.getBlockStatementSchedulerAccess().getVerticalLineSolidusSemicolonVerticalLineKeyword_4()); }
		'|/;|'
		{ after(grammarAccess.getBlockStatementSchedulerAccess().getVerticalLineSolidusSemicolonVerticalLineKeyword_4()); }
	)
	|
	(
		{ before(grammarAccess.getBlockStatementSchedulerAccess().getIKeyword_5()); }
		'|i|'
		{ after(grammarAccess.getBlockStatementSchedulerAccess().getIKeyword_5()); }
	)
	|
	(
		{ before(grammarAccess.getBlockStatementSchedulerAccess().getInterleavingKeyword_6()); }
		'|interleaving|'
		{ after(grammarAccess.getBlockStatementSchedulerAccess().getInterleavingKeyword_6()); }
	)
	|
	(
		{ before(grammarAccess.getBlockStatementSchedulerAccess().getVerticalLineTildeVerticalLineKeyword_7()); }
		'|~|'
		{ after(grammarAccess.getBlockStatementSchedulerAccess().getVerticalLineTildeVerticalLineKeyword_7()); }
	)
	|
	(
		{ before(grammarAccess.getBlockStatementSchedulerAccess().getPartialOrderKeyword_8()); }
		'|partial-order|'
		{ after(grammarAccess.getBlockStatementSchedulerAccess().getPartialOrderKeyword_8()); }
	)
	|
	(
		{ before(grammarAccess.getBlockStatementSchedulerAccess().getVerticalLineCommaVerticalLineKeyword_9()); }
		'|,|'
		{ after(grammarAccess.getBlockStatementSchedulerAccess().getVerticalLineCommaVerticalLineKeyword_9()); }
	)
	|
	(
		{ before(grammarAccess.getBlockStatementSchedulerAccess().getParallelKeyword_10()); }
		'|parallel|'
		{ after(grammarAccess.getBlockStatementSchedulerAccess().getParallelKeyword_10()); }
	)
	|
	(
		{ before(grammarAccess.getBlockStatementSchedulerAccess().getAKeyword_11()); }
		'|a|'
		{ after(grammarAccess.getBlockStatementSchedulerAccess().getAKeyword_11()); }
	)
	|
	(
		{ before(grammarAccess.getBlockStatementSchedulerAccess().getAsyncKeyword_12()); }
		'|async|'
		{ after(grammarAccess.getBlockStatementSchedulerAccess().getAsyncKeyword_12()); }
	)
	|
	(
		{ before(grammarAccess.getBlockStatementSchedulerAccess().getPartialOrderKeyword_13()); }
		'|partial-order|'
		{ after(grammarAccess.getBlockStatementSchedulerAccess().getPartialOrderKeyword_13()); }
	)
	|
	(
		{ before(grammarAccess.getBlockStatementSchedulerAccess().getAndKeyword_14()); }
		'|and|'
		{ after(grammarAccess.getBlockStatementSchedulerAccess().getAndKeyword_14()); }
	)
	|
	(
		{ before(grammarAccess.getBlockStatementSchedulerAccess().getOrKeyword_15()); }
		'|or|'
		{ after(grammarAccess.getBlockStatementSchedulerAccess().getOrKeyword_15()); }
	)
	|
	(
		{ before(grammarAccess.getBlockStatementSchedulerAccess().getAndThenKeyword_16()); }
		'|and#then|'
		{ after(grammarAccess.getBlockStatementSchedulerAccess().getAndThenKeyword_16()); }
	)
	|
	(
		{ before(grammarAccess.getBlockStatementSchedulerAccess().getOrElseKeyword_17()); }
		'|or#else|'
		{ after(grammarAccess.getBlockStatementSchedulerAccess().getOrElseKeyword_17()); }
	)
	|
	(
		{ before(grammarAccess.getBlockStatementSchedulerAccess().getIndetKeyword_18()); }
		'|indet|'
		{ after(grammarAccess.getBlockStatementSchedulerAccess().getIndetKeyword_18()); }
	)
	|
	(
		{ before(grammarAccess.getBlockStatementSchedulerAccess().getVerticalLineSolidusReverseSolidusVerticalLineKeyword_19()); }
		'|/\\|'
		{ after(grammarAccess.getBlockStatementSchedulerAccess().getVerticalLineSolidusReverseSolidusVerticalLineKeyword_19()); }
	)
	|
	(
		{ before(grammarAccess.getBlockStatementSchedulerAccess().getForkKeyword_20()); }
		'|fork|'
		{ after(grammarAccess.getBlockStatementSchedulerAccess().getForkKeyword_20()); }
	)
	|
	(
		{ before(grammarAccess.getBlockStatementSchedulerAccess().getJoinKeyword_21()); }
		'|join|'
		{ after(grammarAccess.getBlockStatementSchedulerAccess().getJoinKeyword_21()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ExpressionStatement__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getExpressionStatementAccess().getGroup_0()); }
		(rule__ExpressionStatement__Group_0__0)
		{ after(grammarAccess.getExpressionStatementAccess().getGroup_0()); }
	)
	|
	(
		{ before(grammarAccess.getExpressionStatementAccess().getGroup_1()); }
		(rule__ExpressionStatement__Group_1__0)
		{ after(grammarAccess.getExpressionStatementAccess().getGroup_1()); }
	)
	|
	(
		{ before(grammarAccess.getExpressionStatementAccess().getGroup_2()); }
		(rule__ExpressionStatement__Group_2__0)
		{ after(grammarAccess.getExpressionStatementAccess().getGroup_2()); }
	)
	|
	(
		{ before(grammarAccess.getExpressionStatementAccess().getGroup_3()); }
		(rule__ExpressionStatement__Group_3__0)
		{ after(grammarAccess.getExpressionStatementAccess().getGroup_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__InputComStatement__Alternatives_3_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getInputComStatementAccess().getLessThanSignEqualsSignEqualsSignKeyword_3_1_0_0()); }
		'<=='
		{ after(grammarAccess.getInputComStatementAccess().getLessThanSignEqualsSignEqualsSignKeyword_3_1_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getInputComStatementAccess().getViaKeyword_3_1_0_1()); }
		'via'
		{ after(grammarAccess.getInputComStatementAccess().getViaKeyword_3_1_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__OutputComStatement__Alternatives_3_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getOutputComStatementAccess().getEqualsSignEqualsSignGreaterThanSignKeyword_3_1_0_0()); }
		'==>'
		{ after(grammarAccess.getOutputComStatementAccess().getEqualsSignEqualsSignGreaterThanSignKeyword_3_1_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getOutputComStatementAccess().getViaKeyword_3_1_0_1()); }
		'via'
		{ after(grammarAccess.getOutputComStatementAccess().getViaKeyword_3_1_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ElseIfStatement__Alternatives_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getElseIfStatementAccess().getElseifKeyword_0_0()); }
		'elseif'
		{ after(grammarAccess.getElseIfStatementAccess().getElseifKeyword_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getElseIfStatementAccess().getGroup_0_1()); }
		(rule__ElseIfStatement__Group_0_1__0)
		{ after(grammarAccess.getElseIfStatementAccess().getGroup_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForStatement__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getForStatementAccess().getGroup_0()); }
		(rule__ForStatement__Group_0__0)
		{ after(grammarAccess.getForStatementAccess().getGroup_0()); }
	)
	|
	(
		{ before(grammarAccess.getForStatementAccess().getGroup_1()); }
		(rule__ForStatement__Group_1__0)
		{ after(grammarAccess.getForStatementAccess().getGroup_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForAssignmentExpression__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getForAssignmentExpressionAccess().getAssignmentExpressionParserRuleCall_0()); }
		ruleAssignmentExpression
		{ after(grammarAccess.getForAssignmentExpressionAccess().getAssignmentExpressionParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getForAssignmentExpressionAccess().getIncrementOrDecrementPrefixExpressionParserRuleCall_1()); }
		ruleIncrementOrDecrementPrefixExpression
		{ after(grammarAccess.getForAssignmentExpressionAccess().getIncrementOrDecrementPrefixExpressionParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getForAssignmentExpressionAccess().getIncrementOrDecrementPostfixExpressionParserRuleCall_2()); }
		ruleIncrementOrDecrementPostfixExpression
		{ after(grammarAccess.getForAssignmentExpressionAccess().getIncrementOrDecrementPostfixExpressionParserRuleCall_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ForEachStatement__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getForEachStatementAccess().getGroup_0()); }
		(rule__ForEachStatement__Group_0__0)
		{ after(grammarAccess.getForEachStatementAccess().getGroup_0()); }
	)
	|
	(
		{ before(grammarAccess.getForEachStatementAccess().getGroup_1()); }
		(rule__ForEachStatement__Group_1__0)
		{ after(grammarAccess.getForEachStatementAccess().getGroup_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__InterruptStatement__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getInterruptStatementAccess().getExprAssignment_1_0()); }
		(rule__InterruptStatement__ExprAssignment_1_0)
		{ after(grammarAccess.getInterruptStatementAccess().getExprAssignment_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getInterruptStatementAccess().getGroup_1_1()); }
		(rule__InterruptStatement__Group_1_1__0)
		{ after(grammarAccess.getInterruptStatementAccess().getGroup_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__InvokeStatement__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getInvokeStatementAccess().getGroup_0()); }
		(rule__InvokeStatement__Group_0__0)
		{ after(grammarAccess.getInvokeStatementAccess().getGroup_0()); }
	)
	|
	(
		{ before(grammarAccess.getInvokeStatementAccess().getGroup_1()); }
		(rule__InvokeStatement__Group_1__0)
		{ after(grammarAccess.getInvokeStatementAccess().getGroup_1()); }
	)
	|
	(
		{ before(grammarAccess.getInvokeStatementAccess().getGroup_2()); }
		(rule__InvokeStatement__Group_2__0)
		{ after(grammarAccess.getInvokeStatementAccess().getGroup_2()); }
	)
	|
	(
		{ before(grammarAccess.getInvokeStatementAccess().getGroup_3()); }
		(rule__InvokeStatement__Group_3__0)
		{ after(grammarAccess.getInvokeStatementAccess().getGroup_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__InvokeStatement__Alternatives_1_4_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getInvokeStatementAccess().getGroup_1_4_1_0()); }
		(rule__InvokeStatement__Group_1_4_1_0__0)
		{ after(grammarAccess.getInvokeStatementAccess().getGroup_1_4_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getInvokeStatementAccess().getGroup_1_4_1_1()); }
		(rule__InvokeStatement__Group_1_4_1_1__0)
		{ after(grammarAccess.getInvokeStatementAccess().getGroup_1_4_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__InvokeStatement__Alternatives_2_5_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getInvokeStatementAccess().getGroup_2_5_1_0()); }
		(rule__InvokeStatement__Group_2_5_1_0__0)
		{ after(grammarAccess.getInvokeStatementAccess().getGroup_2_5_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getInvokeStatementAccess().getGroup_2_5_1_1()); }
		(rule__InvokeStatement__Group_2_5_1_1__0)
		{ after(grammarAccess.getInvokeStatementAccess().getGroup_2_5_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__InvokeStatement__Alternatives_3_3_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getInvokeStatementAccess().getGroup_3_3_1_0()); }
		(rule__InvokeStatement__Group_3_3_1_0__0)
		{ after(grammarAccess.getInvokeStatementAccess().getGroup_3_3_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getInvokeStatementAccess().getGroup_3_3_1_1()); }
		(rule__InvokeStatement__Group_3_3_1_1__0)
		{ after(grammarAccess.getInvokeStatementAccess().getGroup_3_3_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Expression__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getExpressionAccess().getAssignmentExpressionParserRuleCall_0()); }
		ruleAssignmentExpression
		{ after(grammarAccess.getExpressionAccess().getAssignmentExpressionParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getExpressionAccess().getConditionalTestExpressionParserRuleCall_1()); }
		ruleConditionalTestExpression
		{ after(grammarAccess.getExpressionAccess().getConditionalTestExpressionParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AssignmentOperator__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getEqualsSignKeyword_0()); }
		'='
		{ after(grammarAccess.getAssignmentOperatorAccess().getEqualsSignKeyword_0()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getColonEqualsSignKeyword_1()); }
		':='
		{ after(grammarAccess.getAssignmentOperatorAccess().getColonEqualsSignKeyword_1()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getColonColonEqualsSignKeyword_2()); }
		'::='
		{ after(grammarAccess.getAssignmentOperatorAccess().getColonColonEqualsSignKeyword_2()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getPlusSignEqualsSignKeyword_3()); }
		'+='
		{ after(grammarAccess.getAssignmentOperatorAccess().getPlusSignEqualsSignKeyword_3()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getHyphenMinusEqualsSignKeyword_4()); }
		'-='
		{ after(grammarAccess.getAssignmentOperatorAccess().getHyphenMinusEqualsSignKeyword_4()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getAsteriskEqualsSignKeyword_5()); }
		'*='
		{ after(grammarAccess.getAssignmentOperatorAccess().getAsteriskEqualsSignKeyword_5()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getSolidusEqualsSignKeyword_6()); }
		'/='
		{ after(grammarAccess.getAssignmentOperatorAccess().getSolidusEqualsSignKeyword_6()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getPercentSignEqualsSignKeyword_7()); }
		'%='
		{ after(grammarAccess.getAssignmentOperatorAccess().getPercentSignEqualsSignKeyword_7()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getAmpersandAmpersandEqualsSignKeyword_8()); }
		'&&='
		{ after(grammarAccess.getAssignmentOperatorAccess().getAmpersandAmpersandEqualsSignKeyword_8()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getVerticalLineVerticalLineEqualsSignKeyword_9()); }
		'||='
		{ after(grammarAccess.getAssignmentOperatorAccess().getVerticalLineVerticalLineEqualsSignKeyword_9()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getAmpersandEqualsSignKeyword_10()); }
		'&='
		{ after(grammarAccess.getAssignmentOperatorAccess().getAmpersandEqualsSignKeyword_10()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getVerticalLineEqualsSignKeyword_11()); }
		'|='
		{ after(grammarAccess.getAssignmentOperatorAccess().getVerticalLineEqualsSignKeyword_11()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getCircumflexAccentEqualsSignKeyword_12()); }
		'^='
		{ after(grammarAccess.getAssignmentOperatorAccess().getCircumflexAccentEqualsSignKeyword_12()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getLessThanSignLessThanSignEqualsSignKeyword_13()); }
		'<<='
		{ after(grammarAccess.getAssignmentOperatorAccess().getLessThanSignLessThanSignEqualsSignKeyword_13()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getGreaterThanSignGreaterThanSignEqualsSignKeyword_14()); }
		'>>='
		{ after(grammarAccess.getAssignmentOperatorAccess().getGreaterThanSignGreaterThanSignEqualsSignKeyword_14()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getGreaterThanSignGreaterThanSignGreaterThanSignEqualsSignKeyword_15()); }
		'>>>='
		{ after(grammarAccess.getAssignmentOperatorAccess().getGreaterThanSignGreaterThanSignGreaterThanSignEqualsSignKeyword_15()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getLessThanSignEqualsSignLessThanSignKeyword_16()); }
		'<=<'
		{ after(grammarAccess.getAssignmentOperatorAccess().getLessThanSignEqualsSignLessThanSignKeyword_16()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getCircumflexAccentEqualsSignLessThanSignKeyword_17()); }
		'^=<'
		{ after(grammarAccess.getAssignmentOperatorAccess().getCircumflexAccentEqualsSignLessThanSignKeyword_17()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getCircumflexAccentEqualsSignGreaterThanSignKeyword_18()); }
		'^=>'
		{ after(grammarAccess.getAssignmentOperatorAccess().getCircumflexAccentEqualsSignGreaterThanSignKeyword_18()); }
	)
	|
	(
		{ before(grammarAccess.getAssignmentOperatorAccess().getGreaterThanSignEqualsSignGreaterThanSignKeyword_19()); }
		'>=>'
		{ after(grammarAccess.getAssignmentOperatorAccess().getGreaterThanSignEqualsSignGreaterThanSignKeyword_19()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__LeftHandSideExpression__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLeftHandSideExpressionAccess().getLvalueAssignment_1_0()); }
		(rule__LeftHandSideExpression__LvalueAssignment_1_0)
		{ after(grammarAccess.getLeftHandSideExpressionAccess().getLvalueAssignment_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_1()); }
		(rule__LeftHandSideExpression__Group_1_1__0)
		{ after(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalOrExpression__OperatorAlternatives_1_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLogicalOrExpressionAccess().getOperatorVerticalLineVerticalLineKeyword_1_1_0_0()); }
		'||'
		{ after(grammarAccess.getLogicalOrExpressionAccess().getOperatorVerticalLineVerticalLineKeyword_1_1_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getLogicalOrExpressionAccess().getOperatorOrKeyword_1_1_0_1()); }
		'or'
		{ after(grammarAccess.getLogicalOrExpressionAccess().getOperatorOrKeyword_1_1_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalOrExpression__Alternatives_1_3_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLogicalOrExpressionAccess().getVerticalLineVerticalLineKeyword_1_3_0_0()); }
		'||'
		{ after(grammarAccess.getLogicalOrExpressionAccess().getVerticalLineVerticalLineKeyword_1_3_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getLogicalOrExpressionAccess().getOrKeyword_1_3_0_1()); }
		'or'
		{ after(grammarAccess.getLogicalOrExpressionAccess().getOrKeyword_1_3_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalAndExpression__OperatorAlternatives_1_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLogicalAndExpressionAccess().getOperatorAmpersandAmpersandKeyword_1_1_0_0()); }
		'&&'
		{ after(grammarAccess.getLogicalAndExpressionAccess().getOperatorAmpersandAmpersandKeyword_1_1_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getLogicalAndExpressionAccess().getOperatorAndKeyword_1_1_0_1()); }
		'and'
		{ after(grammarAccess.getLogicalAndExpressionAccess().getOperatorAndKeyword_1_1_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalAndExpression__Alternatives_1_3_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLogicalAndExpressionAccess().getAmpersandAmpersandKeyword_1_3_0_0()); }
		'&&'
		{ after(grammarAccess.getLogicalAndExpressionAccess().getAmpersandAmpersandKeyword_1_3_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getLogicalAndExpressionAccess().getAndKeyword_1_3_0_1()); }
		'and'
		{ after(grammarAccess.getLogicalAndExpressionAccess().getAndKeyword_1_3_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__EqualityOperator__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEqualityOperatorAccess().getEqualsSignEqualsSignKeyword_0()); }
		'=='
		{ after(grammarAccess.getEqualityOperatorAccess().getEqualsSignEqualsSignKeyword_0()); }
	)
	|
	(
		{ before(grammarAccess.getEqualityOperatorAccess().getExclamationMarkEqualsSignKeyword_1()); }
		'!='
		{ after(grammarAccess.getEqualityOperatorAccess().getExclamationMarkEqualsSignKeyword_1()); }
	)
	|
	(
		{ before(grammarAccess.getEqualityOperatorAccess().getEqualsSignEqualsSignEqualsSignKeyword_2()); }
		'==='
		{ after(grammarAccess.getEqualityOperatorAccess().getEqualsSignEqualsSignEqualsSignKeyword_2()); }
	)
	|
	(
		{ before(grammarAccess.getEqualityOperatorAccess().getEqualsSignExclamationMarkEqualsSignKeyword_3()); }
		'=!='
		{ after(grammarAccess.getEqualityOperatorAccess().getEqualsSignExclamationMarkEqualsSignKeyword_3()); }
	)
	|
	(
		{ before(grammarAccess.getEqualityOperatorAccess().getEqualsSignSolidusEqualsSignKeyword_4()); }
		'=/='
		{ after(grammarAccess.getEqualityOperatorAccess().getEqualsSignSolidusEqualsSignKeyword_4()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__RelationalOperator__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getRelationalOperatorAccess().getLessThanSignKeyword_0()); }
		'<'
		{ after(grammarAccess.getRelationalOperatorAccess().getLessThanSignKeyword_0()); }
	)
	|
	(
		{ before(grammarAccess.getRelationalOperatorAccess().getGreaterThanSignKeyword_1()); }
		'>'
		{ after(grammarAccess.getRelationalOperatorAccess().getGreaterThanSignKeyword_1()); }
	)
	|
	(
		{ before(grammarAccess.getRelationalOperatorAccess().getLessThanSignEqualsSignKeyword_2()); }
		'<='
		{ after(grammarAccess.getRelationalOperatorAccess().getLessThanSignEqualsSignKeyword_2()); }
	)
	|
	(
		{ before(grammarAccess.getRelationalOperatorAccess().getGreaterThanSignEqualsSignKeyword_3()); }
		'>='
		{ after(grammarAccess.getRelationalOperatorAccess().getGreaterThanSignEqualsSignKeyword_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AdditiveExpression__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAdditiveExpressionAccess().getGroup_1_0()); }
		(rule__AdditiveExpression__Group_1_0__0)
		{ after(grammarAccess.getAdditiveExpressionAccess().getGroup_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getAdditiveExpressionAccess().getGroup_1_1()); }
		(rule__AdditiveExpression__Group_1_1__0)
		{ after(grammarAccess.getAdditiveExpressionAccess().getGroup_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MultiplicativeExpression__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMultiplicativeExpressionAccess().getGroup_1_0()); }
		(rule__MultiplicativeExpression__Group_1_0__0)
		{ after(grammarAccess.getMultiplicativeExpressionAccess().getGroup_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getMultiplicativeExpressionAccess().getGroup_1_1()); }
		(rule__MultiplicativeExpression__Group_1_1__0)
		{ after(grammarAccess.getMultiplicativeExpressionAccess().getGroup_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getMultiplicativeExpressionAccess().getGroup_1_2()); }
		(rule__MultiplicativeExpression__Group_1_2__0)
		{ after(grammarAccess.getMultiplicativeExpressionAccess().getGroup_1_2()); }
	)
	|
	(
		{ before(grammarAccess.getMultiplicativeExpressionAccess().getGroup_1_3()); }
		(rule__MultiplicativeExpression__Group_1_3__0)
		{ after(grammarAccess.getMultiplicativeExpressionAccess().getGroup_1_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnaryExpression__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getUnaryExpressionAccess().getLiteralTerminalExpressionParserRuleCall_0()); }
		ruleLiteralTerminalExpression
		{ after(grammarAccess.getUnaryExpressionAccess().getLiteralTerminalExpressionParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getUnaryExpressionAccess().getArithmeticUnaryExpressionParserRuleCall_1()); }
		ruleArithmeticUnaryExpression
		{ after(grammarAccess.getUnaryExpressionAccess().getArithmeticUnaryExpressionParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getUnaryExpressionAccess().getLogicalUnaryExpressionParserRuleCall_2()); }
		ruleLogicalUnaryExpression
		{ after(grammarAccess.getUnaryExpressionAccess().getLogicalUnaryExpressionParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getUnaryExpressionAccess().getQuantifiedLogicalExpressionParserRuleCall_3()); }
		ruleQuantifiedLogicalExpression
		{ after(grammarAccess.getUnaryExpressionAccess().getQuantifiedLogicalExpressionParserRuleCall_3()); }
	)
	|
	(
		{ before(grammarAccess.getUnaryExpressionAccess().getBitwiseUnaryExpressionParserRuleCall_4()); }
		ruleBitwiseUnaryExpression
		{ after(grammarAccess.getUnaryExpressionAccess().getBitwiseUnaryExpressionParserRuleCall_4()); }
	)
	|
	(
		{ before(grammarAccess.getUnaryExpressionAccess().getNewfreshExpressionParserRuleCall_5()); }
		ruleNewfreshExpression
		{ after(grammarAccess.getUnaryExpressionAccess().getNewfreshExpressionParserRuleCall_5()); }
	)
	|
	(
		{ before(grammarAccess.getUnaryExpressionAccess().getCastExpressionParserRuleCall_6()); }
		ruleCastExpression
		{ after(grammarAccess.getUnaryExpressionAccess().getCastExpressionParserRuleCall_6()); }
	)
	|
	(
		{ before(grammarAccess.getUnaryExpressionAccess().getPrefixUnaryExpressionParserRuleCall_7()); }
		rulePrefixUnaryExpression
		{ after(grammarAccess.getUnaryExpressionAccess().getPrefixUnaryExpressionParserRuleCall_7()); }
	)
	|
	(
		{ before(grammarAccess.getUnaryExpressionAccess().getPostfixUnaryExpressionParserRuleCall_8()); }
		rulePostfixUnaryExpression
		{ after(grammarAccess.getUnaryExpressionAccess().getPostfixUnaryExpressionParserRuleCall_8()); }
	)
	|
	(
		{ before(grammarAccess.getUnaryExpressionAccess().getPrimaryExpressionParserRuleCall_9()); }
		rulePrimaryExpression
		{ after(grammarAccess.getUnaryExpressionAccess().getPrimaryExpressionParserRuleCall_9()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__AffixOperator__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getAffixOperatorAccess().getPlusSignPlusSignKeyword_0()); }
		'++'
		{ after(grammarAccess.getAffixOperatorAccess().getPlusSignPlusSignKeyword_0()); }
	)
	|
	(
		{ before(grammarAccess.getAffixOperatorAccess().getHyphenMinusHyphenMinusKeyword_1()); }
		'--'
		{ after(grammarAccess.getAffixOperatorAccess().getHyphenMinusHyphenMinusKeyword_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__NewfreshExpression__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getNewfreshExpressionAccess().getGroup_0()); }
		(rule__NewfreshExpression__Group_0__0)
		{ after(grammarAccess.getNewfreshExpressionAccess().getGroup_0()); }
	)
	|
	(
		{ before(grammarAccess.getNewfreshExpressionAccess().getGroup_1()); }
		(rule__NewfreshExpression__Group_1__0)
		{ after(grammarAccess.getNewfreshExpressionAccess().getGroup_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ArithmeticUnaryOperator__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getArithmeticUnaryOperatorAccess().getPlusSignKeyword_0()); }
		'+'
		{ after(grammarAccess.getArithmeticUnaryOperatorAccess().getPlusSignKeyword_0()); }
	)
	|
	(
		{ before(grammarAccess.getArithmeticUnaryOperatorAccess().getHyphenMinusKeyword_1()); }
		'-'
		{ after(grammarAccess.getArithmeticUnaryOperatorAccess().getHyphenMinusKeyword_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__QuantifiedLogicalExpression__QuantifierAlternatives_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getQuantifiedLogicalExpressionAccess().getQuantifierForallKeyword_0_0_0()); }
		'forall'
		{ after(grammarAccess.getQuantifiedLogicalExpressionAccess().getQuantifierForallKeyword_0_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getQuantifiedLogicalExpressionAccess().getQuantifierExistsKeyword_0_0_1()); }
		'exists'
		{ after(grammarAccess.getQuantifiedLogicalExpressionAccess().getQuantifierExistsKeyword_0_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__LogicalUnaryExpression__OperatorAlternatives_0_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLogicalUnaryExpressionAccess().getOperatorExclamationMarkKeyword_0_0_0()); }
		'!'
		{ after(grammarAccess.getLogicalUnaryExpressionAccess().getOperatorExclamationMarkKeyword_0_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getLogicalUnaryExpressionAccess().getOperatorNotKeyword_0_0_1()); }
		'not'
		{ after(grammarAccess.getLogicalUnaryExpressionAccess().getOperatorNotKeyword_0_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimaryExpression__Alternatives_1_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getGroup_1_3_0()); }
		(rule__PrimaryExpression__Group_1_3_0__0)
		{ after(grammarAccess.getPrimaryExpressionAccess().getGroup_1_3_0()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getGroup_1_3_1()); }
		(rule__PrimaryExpression__Group_1_3_1__0)
		{ after(grammarAccess.getPrimaryExpressionAccess().getGroup_1_3_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimaryExpression__Alternatives_2_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getGroup_2_3_0()); }
		(rule__PrimaryExpression__Group_2_3_0__0)
		{ after(grammarAccess.getPrimaryExpressionAccess().getGroup_2_3_0()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getGroup_2_3_1()); }
		(rule__PrimaryExpression__Group_2_3_1__0)
		{ after(grammarAccess.getPrimaryExpressionAccess().getGroup_2_3_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimaryExpression__Alternatives_2_4_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getGroup_2_4_3_0()); }
		(rule__PrimaryExpression__Group_2_4_3_0__0)
		{ after(grammarAccess.getPrimaryExpressionAccess().getGroup_2_4_3_0()); }
	)
	|
	(
		{ before(grammarAccess.getPrimaryExpressionAccess().getGroup_2_4_3_1()); }
		(rule__PrimaryExpression__Group_2_4_3_1__0)
		{ after(grammarAccess.getPrimaryExpressionAccess().getGroup_2_4_3_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BaseExpression__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBaseExpressionAccess().getLiteralReferenceableExpressionParserRuleCall_0()); }
		ruleLiteralReferenceableExpression
		{ after(grammarAccess.getBaseExpressionAccess().getLiteralReferenceableExpressionParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getBaseExpressionAccess().getGroup_1()); }
		(rule__BaseExpression__Group_1__0)
		{ after(grammarAccess.getBaseExpressionAccess().getGroup_1()); }
	)
	|
	(
		{ before(grammarAccess.getBaseExpressionAccess().getInvokeExpressionDeprecatedParserRuleCall_2()); }
		ruleInvokeExpressionDeprecated
		{ after(grammarAccess.getBaseExpressionAccess().getInvokeExpressionDeprecatedParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getBaseExpressionAccess().getInstantiationExpressionParserRuleCall_3()); }
		ruleInstantiationExpression
		{ after(grammarAccess.getBaseExpressionAccess().getInstantiationExpressionParserRuleCall_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__DynamicInstanceSpecification__Alternatives_3
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getDynamicInstanceSpecificationAccess().getGroup_3_0()); }
		(rule__DynamicInstanceSpecification__Group_3_0__0)
		{ after(grammarAccess.getDynamicInstanceSpecificationAccess().getGroup_3_0()); }
	)
	|
	(
		{ before(grammarAccess.getDynamicInstanceSpecificationAccess().getGroup_3_1()); }
		(rule__DynamicInstanceSpecification__Group_3_1__0)
		{ after(grammarAccess.getDynamicInstanceSpecificationAccess().getGroup_3_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MixTupleExpressionList__ValueAlternatives_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMixTupleExpressionListAccess().getValueExpressionParserRuleCall_1_0_0()); }
		ruleExpression
		{ after(grammarAccess.getMixTupleExpressionListAccess().getValueExpressionParserRuleCall_1_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getMixTupleExpressionListAccess().getValueNamedExpressionParserRuleCall_1_0_1()); }
		ruleNamedExpression
		{ after(grammarAccess.getMixTupleExpressionListAccess().getValueNamedExpressionParserRuleCall_1_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__MixTupleExpressionList__ValueAlternatives_2_1_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getMixTupleExpressionListAccess().getValueExpressionParserRuleCall_2_1_0_0()); }
		ruleExpression
		{ after(grammarAccess.getMixTupleExpressionListAccess().getValueExpressionParserRuleCall_2_1_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getMixTupleExpressionListAccess().getValueNamedExpressionParserRuleCall_2_1_0_1()); }
		ruleNamedExpression
		{ after(grammarAccess.getMixTupleExpressionListAccess().getValueNamedExpressionParserRuleCall_2_1_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__NamedExpression__Alternatives_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getNamedExpressionAccess().getColonKeyword_1_0()); }
		':'
		{ after(grammarAccess.getNamedExpressionAccess().getColonKeyword_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getNamedExpressionAccess().getEqualsSignGreaterThanSignKeyword_1_1()); }
		'=>'
		{ after(grammarAccess.getNamedExpressionAccess().getEqualsSignGreaterThanSignKeyword_1_1()); }
	)
	|
	(
		{ before(grammarAccess.getNamedExpressionAccess().getLessThanSignHyphenMinusKeyword_1_2()); }
		'<-'
		{ after(grammarAccess.getNamedExpressionAccess().getLessThanSignHyphenMinusKeyword_1_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__LiteralReferenceableExpression__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLiteralReferenceableExpressionAccess().getLiteralCollectionExpressionParserRuleCall_0()); }
		ruleLiteralCollectionExpression
		{ after(grammarAccess.getLiteralReferenceableExpressionAccess().getLiteralCollectionExpressionParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralReferenceableExpressionAccess().getLiteralReferenceExpressionParserRuleCall_1()); }
		ruleLiteralReferenceExpression
		{ after(grammarAccess.getLiteralReferenceableExpressionAccess().getLiteralReferenceExpressionParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__LiteralTerminalExpression__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLiteralTerminalExpressionAccess().getLiteralBooleanExpressionParserRuleCall_0()); }
		ruleLiteralBooleanExpression
		{ after(grammarAccess.getLiteralTerminalExpressionAccess().getLiteralBooleanExpressionParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralTerminalExpressionAccess().getLiteralIntegerExpressionParserRuleCall_1()); }
		ruleLiteralIntegerExpression
		{ after(grammarAccess.getLiteralTerminalExpressionAccess().getLiteralIntegerExpressionParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralTerminalExpressionAccess().getLiteralRationalExpressionParserRuleCall_2()); }
		ruleLiteralRationalExpression
		{ after(grammarAccess.getLiteralTerminalExpressionAccess().getLiteralRationalExpressionParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralTerminalExpressionAccess().getLiteralFloatExpressionParserRuleCall_3()); }
		ruleLiteralFloatExpression
		{ after(grammarAccess.getLiteralTerminalExpressionAccess().getLiteralFloatExpressionParserRuleCall_3()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralTerminalExpressionAccess().getLiteralCharacterExpressionParserRuleCall_4()); }
		ruleLiteralCharacterExpression
		{ after(grammarAccess.getLiteralTerminalExpressionAccess().getLiteralCharacterExpressionParserRuleCall_4()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralTerminalExpressionAccess().getLiteralStringExpressionParserRuleCall_5()); }
		ruleLiteralStringExpression
		{ after(grammarAccess.getLiteralTerminalExpressionAccess().getLiteralStringExpressionParserRuleCall_5()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralTerminalExpressionAccess().getLiteralNullExpressionParserRuleCall_6()); }
		ruleLiteralNullExpression
		{ after(grammarAccess.getLiteralTerminalExpressionAccess().getLiteralNullExpressionParserRuleCall_6()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__NullPrimitiveInstanceType__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getNullPrimitiveInstanceTypeAccess().getGroup_0()); }
		(rule__NullPrimitiveInstanceType__Group_0__0)
		{ after(grammarAccess.getNullPrimitiveInstanceTypeAccess().getGroup_0()); }
	)
	|
	(
		{ before(grammarAccess.getNullPrimitiveInstanceTypeAccess().getGroup_1()); }
		(rule__NullPrimitiveInstanceType__Group_1__0)
		{ after(grammarAccess.getNullPrimitiveInstanceTypeAccess().getGroup_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__LiteralCollectionExpression__Alternatives_3_0
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLiteralCollectionExpressionAccess().getValueAssignment_3_0_0()); }
		(rule__LiteralCollectionExpression__ValueAssignment_3_0_0)
		{ after(grammarAccess.getLiteralCollectionExpressionAccess().getValueAssignment_3_0_0()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralCollectionExpressionAccess().getValueAssignment_3_0_1()); }
		(rule__LiteralCollectionExpression__ValueAssignment_3_0_1)
		{ after(grammarAccess.getLiteralCollectionExpressionAccess().getValueAssignment_3_0_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__LiteralCollectionExpression__Alternatives_3_1_1
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLiteralCollectionExpressionAccess().getValueAssignment_3_1_1_0()); }
		(rule__LiteralCollectionExpression__ValueAssignment_3_1_1_0)
		{ after(grammarAccess.getLiteralCollectionExpressionAccess().getValueAssignment_3_1_1_0()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralCollectionExpressionAccess().getValueAssignment_3_1_1_1()); }
		(rule__LiteralCollectionExpression__ValueAssignment_3_1_1_1)
		{ after(grammarAccess.getLiteralCollectionExpressionAccess().getValueAssignment_3_1_1_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__LiteralReferenceExpression__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLiteralReferenceExpressionAccess().getLiteralReferenceElementParserRuleCall_0()); }
		ruleLiteralReferenceElement
		{ after(grammarAccess.getLiteralReferenceExpressionAccess().getLiteralReferenceElementParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralReferenceExpressionAccess().getLiteralReferenceVariableContextParserRuleCall_1()); }
		ruleLiteralReferenceVariableContext
		{ after(grammarAccess.getLiteralReferenceExpressionAccess().getLiteralReferenceVariableContextParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralReferenceExpressionAccess().getLiteralReferenceMachineContextParserRuleCall_2()); }
		ruleLiteralReferenceMachineContext
		{ after(grammarAccess.getLiteralReferenceExpressionAccess().getLiteralReferenceMachineContextParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralReferenceExpressionAccess().getLiteralEnvExpressionParserRuleCall_3()); }
		ruleLiteralEnvExpression
		{ after(grammarAccess.getLiteralReferenceExpressionAccess().getLiteralEnvExpressionParserRuleCall_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__LiteralReferenceElement__Alternatives_2
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLiteralReferenceElementAccess().getGroup_2_0()); }
		(rule__LiteralReferenceElement__Group_2_0__0)
		{ after(grammarAccess.getLiteralReferenceElementAccess().getGroup_2_0()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralReferenceElementAccess().getGroup_2_1()); }
		(rule__LiteralReferenceElement__Group_2_1__0)
		{ after(grammarAccess.getLiteralReferenceElementAccess().getGroup_2_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__LiteralReferenceVariableContext__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLiteralReferenceVariableContextAccess().getLiteralTimeExpressionParserRuleCall_0()); }
		ruleLiteralTimeExpression
		{ after(grammarAccess.getLiteralReferenceVariableContextAccess().getLiteralTimeExpressionParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralReferenceVariableContextAccess().getLiteralTimeDeltaExpressionParserRuleCall_1()); }
		ruleLiteralTimeDeltaExpression
		{ after(grammarAccess.getLiteralReferenceVariableContextAccess().getLiteralTimeDeltaExpressionParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__LiteralReferenceMachineContext__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLiteralReferenceMachineContextAccess().getLiteralThisExpressionParserRuleCall_0()); }
		ruleLiteralThisExpression
		{ after(grammarAccess.getLiteralReferenceMachineContextAccess().getLiteralThisExpressionParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralReferenceMachineContextAccess().getLiteralSelfExpressionParserRuleCall_1()); }
		ruleLiteralSelfExpression
		{ after(grammarAccess.getLiteralReferenceMachineContextAccess().getLiteralSelfExpressionParserRuleCall_1()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralReferenceMachineContextAccess().getLiteralParentExpressionParserRuleCall_2()); }
		ruleLiteralParentExpression
		{ after(grammarAccess.getLiteralReferenceMachineContextAccess().getLiteralParentExpressionParserRuleCall_2()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralReferenceMachineContextAccess().getLiteralSuperExpressionParserRuleCall_3()); }
		ruleLiteralSuperExpression
		{ after(grammarAccess.getLiteralReferenceMachineContextAccess().getLiteralSuperExpressionParserRuleCall_3()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralReferenceMachineContextAccess().getLiteralSystemExpressionParserRuleCall_4()); }
		ruleLiteralSystemExpression
		{ after(grammarAccess.getLiteralReferenceMachineContextAccess().getLiteralSystemExpressionParserRuleCall_4()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralReferenceMachineContextAccess().getLiteralEnvExpressionParserRuleCall_5()); }
		ruleLiteralEnvExpression
		{ after(grammarAccess.getLiteralReferenceMachineContextAccess().getLiteralEnvExpressionParserRuleCall_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__LiteralPureReferenceExpression__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getLiteralPureReferenceExpressionAccess().getLiteralPureReferenceElementParserRuleCall_0()); }
		ruleLiteralPureReferenceElement
		{ after(grammarAccess.getLiteralPureReferenceExpressionAccess().getLiteralPureReferenceElementParserRuleCall_0()); }
	)
	|
	(
		{ before(grammarAccess.getLiteralPureReferenceExpressionAccess().getLiteralReferenceMachineContextParserRuleCall_1()); }
		ruleLiteralReferenceMachineContext
		{ after(grammarAccess.getLiteralPureReferenceExpressionAccess().getLiteralReferenceMachineContextParserRuleCall_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__VisibilityKind__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getVisibilityKindAccess().getPublicEnumLiteralDeclaration_0()); }
		('public')
		{ after(grammarAccess.getVisibilityKindAccess().getPublicEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getVisibilityKindAccess().getPrivateEnumLiteralDeclaration_1()); }
		('private')
		{ after(grammarAccess.getVisibilityKindAccess().getPrivateEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getVisibilityKindAccess().getProtectedEnumLiteralDeclaration_2()); }
		('protected')
		{ after(grammarAccess.getVisibilityKindAccess().getProtectedEnumLiteralDeclaration_2()); }
	)
	|
	(
		{ before(grammarAccess.getVisibilityKindAccess().getPackageEnumLiteralDeclaration_3()); }
		('package')
		{ after(grammarAccess.getVisibilityKindAccess().getPackageEnumLiteralDeclaration_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__DesignKind__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getDesignKindAccess().getModelEnumLiteralDeclaration_0()); }
		('model')
		{ after(grammarAccess.getDesignKindAccess().getModelEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getDesignKindAccess().getPrototypeEnumLiteralDeclaration_1()); }
		('prototype')
		{ after(grammarAccess.getDesignKindAccess().getPrototypeEnumLiteralDeclaration_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PseudostateKind__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPseudostateKindAccess().getJunctionEnumLiteralDeclaration_0()); }
		('junction')
		{ after(grammarAccess.getPseudostateKindAccess().getJunctionEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getPseudostateKindAccess().getChoiceEnumLiteralDeclaration_1()); }
		('choice')
		{ after(grammarAccess.getPseudostateKindAccess().getChoiceEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getPseudostateKindAccess().getJunctionEnumLiteralDeclaration_2()); }
		('entryPoint')
		{ after(grammarAccess.getPseudostateKindAccess().getJunctionEnumLiteralDeclaration_2()); }
	)
	|
	(
		{ before(grammarAccess.getPseudostateKindAccess().getChoiceEnumLiteralDeclaration_3()); }
		('exitPoint')
		{ after(grammarAccess.getPseudostateKindAccess().getChoiceEnumLiteralDeclaration_3()); }
	)
	|
	(
		{ before(grammarAccess.getPseudostateKindAccess().getForkEnumLiteralDeclaration_4()); }
		('fork')
		{ after(grammarAccess.getPseudostateKindAccess().getForkEnumLiteralDeclaration_4()); }
	)
	|
	(
		{ before(grammarAccess.getPseudostateKindAccess().getJoinEnumLiteralDeclaration_5()); }
		('join')
		{ after(grammarAccess.getPseudostateKindAccess().getJoinEnumLiteralDeclaration_5()); }
	)
	|
	(
		{ before(grammarAccess.getPseudostateKindAccess().getDeepHistoryEnumLiteralDeclaration_6()); }
		('dhistory')
		{ after(grammarAccess.getPseudostateKindAccess().getDeepHistoryEnumLiteralDeclaration_6()); }
	)
	|
	(
		{ before(grammarAccess.getPseudostateKindAccess().getShallowHistoryEnumLiteralDeclaration_7()); }
		('shistory')
		{ after(grammarAccess.getPseudostateKindAccess().getShallowHistoryEnumLiteralDeclaration_7()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__EndingPseudostateKind__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getEndingPseudostateKindAccess().getTerminateEnumLiteralDeclaration_0()); }
		('terminal')
		{ after(grammarAccess.getEndingPseudostateKindAccess().getTerminateEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getEndingPseudostateKindAccess().getReturnEnumLiteralDeclaration_1()); }
		('return')
		{ after(grammarAccess.getEndingPseudostateKindAccess().getReturnEnumLiteralDeclaration_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComProtocolKind__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getComProtocolKindAccess().getEnvEnumLiteralDeclaration_0()); }
		('env')
		{ after(grammarAccess.getComProtocolKindAccess().getEnvEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getComProtocolKindAccess().getRdvEnumLiteralDeclaration_1()); }
		('rdv')
		{ after(grammarAccess.getComProtocolKindAccess().getRdvEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getComProtocolKindAccess().getMulti_rdvEnumLiteralDeclaration_2()); }
		('multi_rdv')
		{ after(grammarAccess.getComProtocolKindAccess().getMulti_rdvEnumLiteralDeclaration_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComEnvRdvProtocolKind__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getComEnvRdvProtocolKindAccess().getEnvEnumLiteralDeclaration_0()); }
		('env')
		{ after(grammarAccess.getComEnvRdvProtocolKindAccess().getEnvEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getComEnvRdvProtocolKindAccess().getRdvEnumLiteralDeclaration_1()); }
		('rdv')
		{ after(grammarAccess.getComEnvRdvProtocolKindAccess().getRdvEnumLiteralDeclaration_1()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComCastKing__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getComCastKingAccess().getUnicastEnumLiteralDeclaration_0()); }
		('unicast')
		{ after(grammarAccess.getComCastKingAccess().getUnicastEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getComCastKingAccess().getAnycastEnumLiteralDeclaration_1()); }
		('anycast')
		{ after(grammarAccess.getComCastKingAccess().getAnycastEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getComCastKingAccess().getMulticastEnumLiteralDeclaration_2()); }
		('multicast')
		{ after(grammarAccess.getComCastKingAccess().getMulticastEnumLiteralDeclaration_2()); }
	)
	|
	(
		{ before(grammarAccess.getComCastKingAccess().getBroadcastEnumLiteralDeclaration_3()); }
		('broadcast')
		{ after(grammarAccess.getComCastKingAccess().getBroadcastEnumLiteralDeclaration_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveNumberSign__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimitiveNumberSignAccess().getPositiveEnumLiteralDeclaration_0()); }
		('+')
		{ after(grammarAccess.getPrimitiveNumberSignAccess().getPositiveEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveNumberSignAccess().getPositive_strictEnumLiteralDeclaration_1()); }
		('++')
		{ after(grammarAccess.getPrimitiveNumberSignAccess().getPositive_strictEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveNumberSignAccess().getNegativeEnumLiteralDeclaration_2()); }
		('-')
		{ after(grammarAccess.getPrimitiveNumberSignAccess().getNegativeEnumLiteralDeclaration_2()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveNumberSignAccess().getNegative_strictEnumLiteralDeclaration_3()); }
		('--')
		{ after(grammarAccess.getPrimitiveNumberSignAccess().getNegative_strictEnumLiteralDeclaration_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveInstanceKind__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getPrimitiveInstanceKindAccess().getBufferEnumLiteralDeclaration_0()); }
		('buffer')
		{ after(grammarAccess.getPrimitiveInstanceKindAccess().getBufferEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveInstanceKindAccess().getMessageEnumLiteralDeclaration_1()); }
		('message')
		{ after(grammarAccess.getPrimitiveInstanceKindAccess().getMessageEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveInstanceKindAccess().getPortEnumLiteralDeclaration_2()); }
		('port')
		{ after(grammarAccess.getPrimitiveInstanceKindAccess().getPortEnumLiteralDeclaration_2()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveInstanceKindAccess().getSignalEnumLiteralDeclaration_3()); }
		('signal')
		{ after(grammarAccess.getPrimitiveInstanceKindAccess().getSignalEnumLiteralDeclaration_3()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveInstanceKindAccess().getMachineEnumLiteralDeclaration_4()); }
		('machine')
		{ after(grammarAccess.getPrimitiveInstanceKindAccess().getMachineEnumLiteralDeclaration_4()); }
	)
	|
	(
		{ before(grammarAccess.getPrimitiveInstanceKindAccess().getVertexEnumLiteralDeclaration_5()); }
		('vertex')
		{ after(grammarAccess.getPrimitiveInstanceKindAccess().getVertexEnumLiteralDeclaration_5()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionKind__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getCollectionKindAccess().getVectorEnumLiteralDeclaration_0()); }
		('vector')
		{ after(grammarAccess.getCollectionKindAccess().getVectorEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getCollectionKindAccess().getRvectorEnumLiteralDeclaration_1()); }
		('rvector')
		{ after(grammarAccess.getCollectionKindAccess().getRvectorEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getCollectionKindAccess().getListEnumLiteralDeclaration_2()); }
		('list')
		{ after(grammarAccess.getCollectionKindAccess().getListEnumLiteralDeclaration_2()); }
	)
	|
	(
		{ before(grammarAccess.getCollectionKindAccess().getSetEnumLiteralDeclaration_3()); }
		('set')
		{ after(grammarAccess.getCollectionKindAccess().getSetEnumLiteralDeclaration_3()); }
	)
	|
	(
		{ before(grammarAccess.getCollectionKindAccess().getBagEnumLiteralDeclaration_4()); }
		('bag')
		{ after(grammarAccess.getCollectionKindAccess().getBagEnumLiteralDeclaration_4()); }
	)
	|
	(
		{ before(grammarAccess.getCollectionKindAccess().getFifoEnumLiteralDeclaration_5()); }
		('fifo')
		{ after(grammarAccess.getCollectionKindAccess().getFifoEnumLiteralDeclaration_5()); }
	)
	|
	(
		{ before(grammarAccess.getCollectionKindAccess().getLifoEnumLiteralDeclaration_6()); }
		('lifo')
		{ after(grammarAccess.getCollectionKindAccess().getLifoEnumLiteralDeclaration_6()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterDirectionKind__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getParameterDirectionKindAccess().getInEnumLiteralDeclaration_0()); }
		('in')
		{ after(grammarAccess.getParameterDirectionKindAccess().getInEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getParameterDirectionKindAccess().getInoutEnumLiteralDeclaration_1()); }
		('inout')
		{ after(grammarAccess.getParameterDirectionKindAccess().getInoutEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getParameterDirectionKindAccess().getOutEnumLiteralDeclaration_2()); }
		('out')
		{ after(grammarAccess.getParameterDirectionKindAccess().getOutEnumLiteralDeclaration_2()); }
	)
	|
	(
		{ before(grammarAccess.getParameterDirectionKindAccess().getReturnEnumLiteralDeclaration_3()); }
		('return')
		{ after(grammarAccess.getParameterDirectionKindAccess().getReturnEnumLiteralDeclaration_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BlockParameterDirectionKind__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBlockParameterDirectionKindAccess().getInEnumLiteralDeclaration_0()); }
		('input')
		{ after(grammarAccess.getBlockParameterDirectionKindAccess().getInEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getBlockParameterDirectionKindAccess().getInoutEnumLiteralDeclaration_1()); }
		('inout')
		{ after(grammarAccess.getBlockParameterDirectionKindAccess().getInoutEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getBlockParameterDirectionKindAccess().getOutEnumLiteralDeclaration_2()); }
		('output')
		{ after(grammarAccess.getBlockParameterDirectionKindAccess().getOutEnumLiteralDeclaration_2()); }
	)
	|
	(
		{ before(grammarAccess.getBlockParameterDirectionKindAccess().getReturnEnumLiteralDeclaration_3()); }
		('return')
		{ after(grammarAccess.getBlockParameterDirectionKindAccess().getReturnEnumLiteralDeclaration_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferContainerKind__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getBufferContainerKindAccess().getSetEnumLiteralDeclaration_0()); }
		('set')
		{ after(grammarAccess.getBufferContainerKindAccess().getSetEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getBufferContainerKindAccess().getBagEnumLiteralDeclaration_1()); }
		('bag')
		{ after(grammarAccess.getBufferContainerKindAccess().getBagEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getBufferContainerKindAccess().getFifoEnumLiteralDeclaration_2()); }
		('fifo')
		{ after(grammarAccess.getBufferContainerKindAccess().getFifoEnumLiteralDeclaration_2()); }
	)
	|
	(
		{ before(grammarAccess.getBufferContainerKindAccess().getLifoEnumLiteralDeclaration_3()); }
		('lifo')
		{ after(grammarAccess.getBufferContainerKindAccess().getLifoEnumLiteralDeclaration_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelDirection__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getChannelDirectionAccess().getInputEnumLiteralDeclaration_0()); }
		('input')
		{ after(grammarAccess.getChannelDirectionAccess().getInputEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getChannelDirectionAccess().getInoutEnumLiteralDeclaration_1()); }
		('inout')
		{ after(grammarAccess.getChannelDirectionAccess().getInoutEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getChannelDirectionAccess().getOutputEnumLiteralDeclaration_2()); }
		('output')
		{ after(grammarAccess.getChannelDirectionAccess().getOutputEnumLiteralDeclaration_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__TransitionMoc__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getTransitionMocAccess().getSimpleEnumLiteralDeclaration_0()); }
		('simple')
		{ after(grammarAccess.getTransitionMocAccess().getSimpleEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getTransitionMocAccess().getAbortEnumLiteralDeclaration_1()); }
		('abort')
		{ after(grammarAccess.getTransitionMocAccess().getAbortEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getTransitionMocAccess().getFinalEnumLiteralDeclaration_2()); }
		('final')
		{ after(grammarAccess.getTransitionMocAccess().getFinalEnumLiteralDeclaration_2()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__InterruptStatementKind__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getInterruptStatementKindAccess().getBreakEnumLiteralDeclaration_0()); }
		('break')
		{ after(grammarAccess.getInterruptStatementKindAccess().getBreakEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getInterruptStatementKindAccess().getContinueEnumLiteralDeclaration_1()); }
		('continue')
		{ after(grammarAccess.getInterruptStatementKindAccess().getContinueEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getInterruptStatementKindAccess().getReturnEnumLiteralDeclaration_2()); }
		('return')
		{ after(grammarAccess.getInterruptStatementKindAccess().getReturnEnumLiteralDeclaration_2()); }
	)
	|
	(
		{ before(grammarAccess.getInterruptStatementKindAccess().getExitEnumLiteralDeclaration_3()); }
		('exit')
		{ after(grammarAccess.getInterruptStatementKindAccess().getExitEnumLiteralDeclaration_3()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__OPERATOR_ACTIVITY__Alternatives
	@init {
		int stackSize = keepStackSize();
	}
:
	(
		{ before(grammarAccess.getOPERATOR_ACTIVITYAccess().getInitEnumLiteralDeclaration_0()); }
		('init')
		{ after(grammarAccess.getOPERATOR_ACTIVITYAccess().getInitEnumLiteralDeclaration_0()); }
	)
	|
	(
		{ before(grammarAccess.getOPERATOR_ACTIVITYAccess().getFinalEnumLiteralDeclaration_1()); }
		('final')
		{ after(grammarAccess.getOPERATOR_ACTIVITYAccess().getFinalEnumLiteralDeclaration_1()); }
	)
	|
	(
		{ before(grammarAccess.getOPERATOR_ACTIVITYAccess().getDestroyEnumLiteralDeclaration_2()); }
		('destroy')
		{ after(grammarAccess.getOPERATOR_ACTIVITYAccess().getDestroyEnumLiteralDeclaration_2()); }
	)
	|
	(
		{ before(grammarAccess.getOPERATOR_ACTIVITYAccess().getStartEnumLiteralDeclaration_3()); }
		('start')
		{ after(grammarAccess.getOPERATOR_ACTIVITYAccess().getStartEnumLiteralDeclaration_3()); }
	)
	|
	(
		{ before(grammarAccess.getOPERATOR_ACTIVITYAccess().getStopEnumLiteralDeclaration_4()); }
		('stop')
		{ after(grammarAccess.getOPERATOR_ACTIVITYAccess().getStopEnumLiteralDeclaration_4()); }
	)
	|
	(
		{ before(grammarAccess.getOPERATOR_ACTIVITYAccess().getRestartEnumLiteralDeclaration_5()); }
		('restart')
		{ after(grammarAccess.getOPERATOR_ACTIVITYAccess().getRestartEnumLiteralDeclaration_5()); }
	)
	|
	(
		{ before(grammarAccess.getOPERATOR_ACTIVITYAccess().getSuspendEnumLiteralDeclaration_6()); }
		('suspend')
		{ after(grammarAccess.getOPERATOR_ACTIVITYAccess().getSuspendEnumLiteralDeclaration_6()); }
	)
	|
	(
		{ before(grammarAccess.getOPERATOR_ACTIVITYAccess().getResumeEnumLiteralDeclaration_7()); }
		('resume')
		{ after(grammarAccess.getOPERATOR_ACTIVITYAccess().getResumeEnumLiteralDeclaration_7()); }
	)
	|
	(
		{ before(grammarAccess.getOPERATOR_ACTIVITYAccess().getWaitEnumLiteralDeclaration_8()); }
		('wait')
		{ after(grammarAccess.getOPERATOR_ACTIVITYAccess().getWaitEnumLiteralDeclaration_8()); }
	)
	|
	(
		{ before(grammarAccess.getOPERATOR_ACTIVITYAccess().getDisableEnumLiteralDeclaration_9()); }
		('disable')
		{ after(grammarAccess.getOPERATOR_ACTIVITYAccess().getDisableEnumLiteralDeclaration_9()); }
	)
	|
	(
		{ before(grammarAccess.getOPERATOR_ACTIVITYAccess().getEnableEnumLiteralDeclaration_10()); }
		('enable')
		{ after(grammarAccess.getOPERATOR_ACTIVITYAccess().getEnableEnumLiteralDeclaration_10()); }
	)
	|
	(
		{ before(grammarAccess.getOPERATOR_ACTIVITYAccess().getAbortEnumLiteralDeclaration_11()); }
		('abort')
		{ after(grammarAccess.getOPERATOR_ACTIVITYAccess().getAbortEnumLiteralDeclaration_11()); }
	)
	|
	(
		{ before(grammarAccess.getOPERATOR_ACTIVITYAccess().getScheduleEnumLiteralDeclaration_12()); }
		('schedule')
		{ after(grammarAccess.getOPERATOR_ACTIVITYAccess().getScheduleEnumLiteralDeclaration_12()); }
	)
	|
	(
		{ before(grammarAccess.getOPERATOR_ACTIVITYAccess().getIrunEnumLiteralDeclaration_13()); }
		('irun')
		{ after(grammarAccess.getOPERATOR_ACTIVITYAccess().getIrunEnumLiteralDeclaration_13()); }
	)
	|
	(
		{ before(grammarAccess.getOPERATOR_ACTIVITYAccess().getRunEnumLiteralDeclaration_14()); }
		('run')
		{ after(grammarAccess.getOPERATOR_ACTIVITYAccess().getRunEnumLiteralDeclaration_14()); }
	)
	|
	(
		{ before(grammarAccess.getOPERATOR_ACTIVITYAccess().getRtcEnumLiteralDeclaration_15()); }
		('rtc')
		{ after(grammarAccess.getOPERATOR_ACTIVITYAccess().getRtcEnumLiteralDeclaration_15()); }
	)
;
finally {
	restoreStackSize(stackSize);
}

rule__Xlia__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Xlia__Group__0__Impl
	rule__Xlia__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Xlia__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getXliaAccess().getPrologAssignment_0()); }
	(rule__Xlia__PrologAssignment_0)
	{ after(grammarAccess.getXliaAccess().getPrologAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Xlia__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Xlia__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Xlia__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getXliaAccess().getSystemAssignment_1()); }
	(rule__Xlia__SystemAssignment_1)
	{ after(grammarAccess.getXliaAccess().getSystemAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__XliaPrologObject__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__XliaPrologObject__Group__0__Impl
	rule__XliaPrologObject__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaPrologObject__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getXliaPrologObjectAccess().getNameAssignment_0()); }
	(rule__XliaPrologObject__NameAssignment_0)
	{ after(grammarAccess.getXliaPrologObjectAccess().getNameAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaPrologObject__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__XliaPrologObject__Group__1__Impl
	rule__XliaPrologObject__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaPrologObject__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getXliaPrologObjectAccess().getLessThanSignKeyword_1()); }
	'<'
	{ after(grammarAccess.getXliaPrologObjectAccess().getLessThanSignKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaPrologObject__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__XliaPrologObject__Group__2__Impl
	rule__XliaPrologObject__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaPrologObject__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getXliaPrologObjectAccess().getElementsAssignment_2()); }
	(rule__XliaPrologObject__ElementsAssignment_2)
	{ after(grammarAccess.getXliaPrologObjectAccess().getElementsAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaPrologObject__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__XliaPrologObject__Group__3__Impl
	rule__XliaPrologObject__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaPrologObject__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getXliaPrologObjectAccess().getGreaterThanSignColonKeyword_3()); }
	'>:'
	{ after(grammarAccess.getXliaPrologObjectAccess().getGreaterThanSignColonKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaPrologObject__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__XliaPrologObject__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaPrologObject__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getXliaPrologObjectAccess().getElementsAssignment_4()); }
	(rule__XliaPrologObject__ElementsAssignment_4)?
	{ after(grammarAccess.getXliaPrologObjectAccess().getElementsAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__XliaPrologAttribute__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__XliaPrologAttribute__Group__0__Impl
	rule__XliaPrologAttribute__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaPrologAttribute__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getXliaPrologAttributeAccess().getNameAssignment_0()); }
	(rule__XliaPrologAttribute__NameAssignment_0)
	{ after(grammarAccess.getXliaPrologAttributeAccess().getNameAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaPrologAttribute__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__XliaPrologAttribute__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaPrologAttribute__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getXliaPrologAttributeAccess().getGroup_1()); }
	(rule__XliaPrologAttribute__Group_1__0)?
	{ after(grammarAccess.getXliaPrologAttributeAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__XliaPrologAttribute__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__XliaPrologAttribute__Group_1__0__Impl
	rule__XliaPrologAttribute__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaPrologAttribute__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getXliaPrologAttributeAccess().getCommaKeyword_1_0()); }
	','
	{ after(grammarAccess.getXliaPrologAttributeAccess().getCommaKeyword_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaPrologAttribute__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__XliaPrologAttribute__Group_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaPrologAttribute__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getXliaPrologAttributeAccess().getValueAssignment_1_1()); }
	(rule__XliaPrologAttribute__ValueAssignment_1_1)
	{ after(grammarAccess.getXliaPrologAttributeAccess().getValueAssignment_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__XliaOptionObject__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__XliaOptionObject__Group__0__Impl
	rule__XliaOptionObject__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaOptionObject__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getXliaOptionObjectAccess().getNameAssignment_0()); }
	(rule__XliaOptionObject__NameAssignment_0)
	{ after(grammarAccess.getXliaOptionObjectAccess().getNameAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaOptionObject__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__XliaOptionObject__Group__1__Impl
	rule__XliaOptionObject__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaOptionObject__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getXliaOptionObjectAccess().getLeftCurlyBracketKeyword_1()); }
	'{'
	{ after(grammarAccess.getXliaOptionObjectAccess().getLeftCurlyBracketKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaOptionObject__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__XliaOptionObject__Group__2__Impl
	rule__XliaOptionObject__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaOptionObject__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getXliaOptionObjectAccess().getElementsAssignment_2()); }
	(rule__XliaOptionObject__ElementsAssignment_2)*
	{ after(grammarAccess.getXliaOptionObjectAccess().getElementsAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaOptionObject__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__XliaOptionObject__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaOptionObject__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getXliaOptionObjectAccess().getRightCurlyBracketKeyword_3()); }
	'}'
	{ after(grammarAccess.getXliaOptionObjectAccess().getRightCurlyBracketKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__XliaObject__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__XliaObject__Group__0__Impl
	rule__XliaObject__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaObject__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getXliaObjectAccess().getNameAssignment_0()); }
	(rule__XliaObject__NameAssignment_0)
	{ after(grammarAccess.getXliaObjectAccess().getNameAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaObject__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__XliaObject__Group__1__Impl
	rule__XliaObject__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaObject__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getXliaObjectAccess().getLeftCurlyBracketKeyword_1()); }
	'{'
	{ after(grammarAccess.getXliaObjectAccess().getLeftCurlyBracketKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaObject__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__XliaObject__Group__2__Impl
	rule__XliaObject__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaObject__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getXliaObjectAccess().getElementsAssignment_2()); }
	(rule__XliaObject__ElementsAssignment_2)*
	{ after(grammarAccess.getXliaObjectAccess().getElementsAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaObject__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__XliaObject__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaObject__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getXliaObjectAccess().getRightCurlyBracketKeyword_3()); }
	'}'
	{ after(grammarAccess.getXliaObjectAccess().getRightCurlyBracketKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__XliaAttribute__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__XliaAttribute__Group__0__Impl
	rule__XliaAttribute__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaAttribute__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getXliaAttributeAccess().getNameAssignment_0()); }
	(rule__XliaAttribute__NameAssignment_0)
	{ after(grammarAccess.getXliaAttributeAccess().getNameAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaAttribute__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__XliaAttribute__Group__1__Impl
	rule__XliaAttribute__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaAttribute__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getXliaAttributeAccess().getEqualsSignKeyword_1()); }
	'='
	{ after(grammarAccess.getXliaAttributeAccess().getEqualsSignKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaAttribute__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__XliaAttribute__Group__2__Impl
	rule__XliaAttribute__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaAttribute__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getXliaAttributeAccess().getValueAssignment_2()); }
	(rule__XliaAttribute__ValueAssignment_2)
	{ after(grammarAccess.getXliaAttributeAccess().getValueAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaAttribute__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__XliaAttribute__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__XliaAttribute__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getXliaAttributeAccess().getSemicolonKeyword_3()); }
	';'
	{ after(grammarAccess.getXliaAttributeAccess().getSemicolonKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__EInt__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EInt__Group__0__Impl
	rule__EInt__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__EInt__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEIntAccess().getHyphenMinusKeyword_0()); }
	('-')?
	{ after(grammarAccess.getEIntAccess().getHyphenMinusKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EInt__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EInt__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__EInt__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEIntAccess().getINTTerminalRuleCall_1()); }
	RULE_INT
	{ after(grammarAccess.getEIntAccess().getINTTerminalRuleCall_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__EInteger__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EInteger__Group__0__Impl
	rule__EInteger__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__EInteger__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEIntegerAccess().getHyphenMinusKeyword_0()); }
	('-')?
	{ after(grammarAccess.getEIntegerAccess().getHyphenMinusKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EInteger__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EInteger__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__EInteger__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEIntegerAccess().getINTTerminalRuleCall_1()); }
	RULE_INT
	{ after(grammarAccess.getEIntegerAccess().getINTTerminalRuleCall_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__EDouble__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EDouble__Group__0__Impl
	rule__EDouble__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__EDouble__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEDoubleAccess().getHyphenMinusKeyword_0()); }
	('-')?
	{ after(grammarAccess.getEDoubleAccess().getHyphenMinusKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EDouble__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EDouble__Group__1__Impl
	rule__EDouble__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__EDouble__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEDoubleAccess().getINTTerminalRuleCall_1()); }
	(RULE_INT)?
	{ after(grammarAccess.getEDoubleAccess().getINTTerminalRuleCall_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EDouble__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EDouble__Group__2__Impl
	rule__EDouble__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__EDouble__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEDoubleAccess().getFullStopKeyword_2()); }
	'.'
	{ after(grammarAccess.getEDoubleAccess().getFullStopKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EDouble__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EDouble__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__EDouble__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEDoubleAccess().getINTTerminalRuleCall_3()); }
	RULE_INT
	{ after(grammarAccess.getEDoubleAccess().getINTTerminalRuleCall_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ESUfid__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ESUfid__Group__0__Impl
	rule__ESUfid__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ESUfid__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getESUfidAccess().getXLIA_IDTerminalRuleCall_0()); }
	RULE_XLIA_ID
	{ after(grammarAccess.getESUfidAccess().getXLIA_IDTerminalRuleCall_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ESUfid__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ESUfid__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ESUfid__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getESUfidAccess().getGroup_1()); }
	(rule__ESUfid__Group_1__0)*
	{ after(grammarAccess.getESUfidAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ESUfid__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ESUfid__Group_1__0__Impl
	rule__ESUfid__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ESUfid__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getESUfidAccess().getAlternatives_1_0()); }
	(rule__ESUfid__Alternatives_1_0)
	{ after(grammarAccess.getESUfidAccess().getAlternatives_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ESUfid__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ESUfid__Group_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ESUfid__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getESUfidAccess().getXLIA_IDTerminalRuleCall_1_1()); }
	RULE_XLIA_ID
	{ after(grammarAccess.getESUfidAccess().getXLIA_IDTerminalRuleCall_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__System__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group__0__Impl
	rule__System__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getUnorderedGroup_0()); }
	(rule__System__UnorderedGroup_0)
	{ after(grammarAccess.getSystemAccess().getUnorderedGroup_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group__1__Impl
	rule__System__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getSystemKeyword_1()); }
	'system'
	{ after(grammarAccess.getSystemAccess().getSystemKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group__2__Impl
	rule__System__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getGroup_2()); }
	(rule__System__Group_2__0)?
	{ after(grammarAccess.getSystemAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group__3__Impl
	rule__System__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getNameAssignment_3()); }
	(rule__System__NameAssignment_3)
	{ after(grammarAccess.getSystemAccess().getNameAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group__4__Impl
	rule__System__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getUnrestrictedNameAssignment_4()); }
	(rule__System__UnrestrictedNameAssignment_4)?
	{ after(grammarAccess.getSystemAccess().getUnrestrictedNameAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group__5__Impl
	rule__System__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getLeftCurlyBracketKeyword_5()); }
	'{'
	{ after(grammarAccess.getSystemAccess().getLeftCurlyBracketKeyword_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group__6__Impl
	rule__System__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getAlternatives_6()); }
	(rule__System__Alternatives_6)*
	{ after(grammarAccess.getSystemAccess().getAlternatives_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group__7__Impl
	rule__System__Group__8
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getAlternatives_7()); }
	(rule__System__Alternatives_7)*
	{ after(grammarAccess.getSystemAccess().getAlternatives_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group__8__Impl
	rule__System__Group__9
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getAlternatives_8()); }
	(rule__System__Alternatives_8)
	{ after(grammarAccess.getSystemAccess().getAlternatives_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group__9
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group__9__Impl
	rule__System__Group__10
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group__9__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getAlternatives_9()); }
	(rule__System__Alternatives_9)*
	{ after(grammarAccess.getSystemAccess().getAlternatives_9()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group__10
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group__10__Impl
	rule__System__Group__11
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group__10__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getAlternatives_10()); }
	(rule__System__Alternatives_10)*
	{ after(grammarAccess.getSystemAccess().getAlternatives_10()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group__11
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group__11__Impl
	rule__System__Group__12
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group__11__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getMainAssignment_11()); }
	(rule__System__MainAssignment_11)
	{ after(grammarAccess.getSystemAccess().getMainAssignment_11()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group__12
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group__12__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group__12__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getRightCurlyBracketKeyword_12()); }
	'}'
	{ after(grammarAccess.getSystemAccess().getRightCurlyBracketKeyword_12()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__System__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group_2__0__Impl
	rule__System__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getLessThanSignKeyword_2_0()); }
	'<'
	{ after(grammarAccess.getSystemAccess().getLessThanSignKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group_2__1__Impl
	rule__System__Group_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getMocKeyword_2_1()); }
	('moc:')?
	{ after(grammarAccess.getSystemAccess().getMocKeyword_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group_2__2__Impl
	rule__System__Group_2__3
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getAlternatives_2_2()); }
	(rule__System__Alternatives_2_2)
	{ after(grammarAccess.getSystemAccess().getAlternatives_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_2__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group_2__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_2__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getGreaterThanSignKeyword_2_3()); }
	'>'
	{ after(grammarAccess.getSystemAccess().getGreaterThanSignKeyword_2_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__System__Group_7_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group_7_0__0__Impl
	rule__System__Group_7_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_7_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getPropertyKeyword_7_0_0()); }
	'@property:'
	{ after(grammarAccess.getSystemAccess().getPropertyKeyword_7_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_7_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group_7_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_7_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getAlternatives_7_0_1()); }
	(rule__System__Alternatives_7_0_1)*
	{ after(grammarAccess.getSystemAccess().getAlternatives_7_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__System__Group_7_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group_7_1__0__Impl
	rule__System__Group_7_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_7_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getPublicKeyword_7_1_0()); }
	'@public:'
	{ after(grammarAccess.getSystemAccess().getPublicKeyword_7_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_7_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group_7_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_7_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getAlternatives_7_1_1()); }
	(rule__System__Alternatives_7_1_1)*
	{ after(grammarAccess.getSystemAccess().getAlternatives_7_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__System__Group_7_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group_7_2__0__Impl
	rule__System__Group_7_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_7_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getProtectedKeyword_7_2_0()); }
	'@protected:'
	{ after(grammarAccess.getSystemAccess().getProtectedKeyword_7_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_7_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group_7_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_7_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getAlternatives_7_2_1()); }
	(rule__System__Alternatives_7_2_1)*
	{ after(grammarAccess.getSystemAccess().getAlternatives_7_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__System__Group_7_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group_7_3__0__Impl
	rule__System__Group_7_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_7_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getPrivateKeyword_7_3_0()); }
	'@private:'
	{ after(grammarAccess.getSystemAccess().getPrivateKeyword_7_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_7_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group_7_3__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_7_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getAlternatives_7_3_1()); }
	(rule__System__Alternatives_7_3_1)*
	{ after(grammarAccess.getSystemAccess().getAlternatives_7_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__System__Group_8_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group_8_0_0__0__Impl
	rule__System__Group_8_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_8_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getAlternatives_8_0_0_0()); }
	(rule__System__Alternatives_8_0_0_0)
	{ after(grammarAccess.getSystemAccess().getAlternatives_8_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_8_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group_8_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_8_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getSystemAccess().getRoutineAssignment_8_0_0_1()); }
		(rule__System__RoutineAssignment_8_0_0_1)
		{ after(grammarAccess.getSystemAccess().getRoutineAssignment_8_0_0_1()); }
	)
	(
		{ before(grammarAccess.getSystemAccess().getRoutineAssignment_8_0_0_1()); }
		(rule__System__RoutineAssignment_8_0_0_1)*
		{ after(grammarAccess.getSystemAccess().getRoutineAssignment_8_0_0_1()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}


rule__System__Group_8_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group_8_0_1__0__Impl
	rule__System__Group_8_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_8_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getProcedureKeyword_8_0_1_0()); }
	'@procedure:'
	{ after(grammarAccess.getSystemAccess().getProcedureKeyword_8_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_8_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group_8_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_8_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getSystemAccess().getProcedureAssignment_8_0_1_1()); }
		(rule__System__ProcedureAssignment_8_0_1_1)
		{ after(grammarAccess.getSystemAccess().getProcedureAssignment_8_0_1_1()); }
	)
	(
		{ before(grammarAccess.getSystemAccess().getProcedureAssignment_8_0_1_1()); }
		(rule__System__ProcedureAssignment_8_0_1_1)*
		{ after(grammarAccess.getSystemAccess().getProcedureAssignment_8_0_1_1()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}


rule__System__Group_9_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group_9_0__0__Impl
	rule__System__Group_9_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_9_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getAlternatives_9_0_0()); }
	(rule__System__Alternatives_9_0_0)
	{ after(grammarAccess.getSystemAccess().getAlternatives_9_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_9_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group_9_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_9_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getSystemAccess().getAlternatives_9_0_1()); }
		(rule__System__Alternatives_9_0_1)
		{ after(grammarAccess.getSystemAccess().getAlternatives_9_0_1()); }
	)
	(
		{ before(grammarAccess.getSystemAccess().getAlternatives_9_0_1()); }
		(rule__System__Alternatives_9_0_1)*
		{ after(grammarAccess.getSystemAccess().getAlternatives_9_0_1()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}


rule__System__Group_9_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group_9_1__0__Impl
	rule__System__Group_9_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_9_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getModelKeyword_9_1_0()); }
	'@model:'
	{ after(grammarAccess.getSystemAccess().getModelKeyword_9_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_9_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group_9_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_9_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getMachineAssignment_9_1_1()); }
	(rule__System__MachineAssignment_9_1_1)*
	{ after(grammarAccess.getSystemAccess().getMachineAssignment_9_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__System__Group_9_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group_9_2__0__Impl
	rule__System__Group_9_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_9_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getPrototypeKeyword_9_2_0()); }
	'@prototype:'
	{ after(grammarAccess.getSystemAccess().getPrototypeKeyword_9_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_9_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group_9_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_9_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getMachineAssignment_9_2_1()); }
	(rule__System__MachineAssignment_9_2_1)*
	{ after(grammarAccess.getSystemAccess().getMachineAssignment_9_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__System__Group_9_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group_9_3__0__Impl
	rule__System__Group_9_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_9_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getInstanceKeyword_9_3_0()); }
	'@instance:'
	{ after(grammarAccess.getSystemAccess().getInstanceKeyword_9_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_9_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group_9_3__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_9_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getInstanceAssignment_9_3_1()); }
	(rule__System__InstanceAssignment_9_3_1)*
	{ after(grammarAccess.getSystemAccess().getInstanceAssignment_9_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__System__Group_10_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group_10_0__0__Impl
	rule__System__Group_10_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_10_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getBehaviorKeyword_10_0_0()); }
	'@behavior:'
	{ after(grammarAccess.getSystemAccess().getBehaviorKeyword_10_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_10_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group_10_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_10_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getSystemAccess().getBehaviorAssignment_10_0_1()); }
		(rule__System__BehaviorAssignment_10_0_1)
		{ after(grammarAccess.getSystemAccess().getBehaviorAssignment_10_0_1()); }
	)
	(
		{ before(grammarAccess.getSystemAccess().getBehaviorAssignment_10_0_1()); }
		(rule__System__BehaviorAssignment_10_0_1)*
		{ after(grammarAccess.getSystemAccess().getBehaviorAssignment_10_0_1()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}


rule__System__Group_10_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group_10_1__0__Impl
	rule__System__Group_10_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_10_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSystemAccess().getStatemachineKeyword_10_1_0()); }
	'@statemachine:'
	{ after(grammarAccess.getSystemAccess().getStatemachineKeyword_10_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_10_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__System__Group_10_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__System__Group_10_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getSystemAccess().getBehaviorAssignment_10_1_1()); }
		(rule__System__BehaviorAssignment_10_1_1)
		{ after(grammarAccess.getSystemAccess().getBehaviorAssignment_10_1_1()); }
	)
	(
		{ before(grammarAccess.getSystemAccess().getBehaviorAssignment_10_1_1()); }
		(rule__System__BehaviorAssignment_10_1_1)*
		{ after(grammarAccess.getSystemAccess().getBehaviorAssignment_10_1_1()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}


rule__InstanceMachine__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InstanceMachine__Group__0__Impl
	rule__InstanceMachine__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInstanceMachineAccess().getInstanceKeyword_0()); }
	'instance'
	{ after(grammarAccess.getInstanceMachineAccess().getInstanceKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InstanceMachine__Group__1__Impl
	rule__InstanceMachine__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInstanceMachineAccess().getAlternatives_1()); }
	(rule__InstanceMachine__Alternatives_1)?
	{ after(grammarAccess.getInstanceMachineAccess().getAlternatives_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InstanceMachine__Group__2__Impl
	rule__InstanceMachine__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInstanceMachineAccess().getLessThanSignKeyword_2()); }
	'<'
	{ after(grammarAccess.getInstanceMachineAccess().getLessThanSignKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InstanceMachine__Group__3__Impl
	rule__InstanceMachine__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInstanceMachineAccess().getModelKeyword_3()); }
	('model:')?
	{ after(grammarAccess.getInstanceMachineAccess().getModelKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InstanceMachine__Group__4__Impl
	rule__InstanceMachine__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInstanceMachineAccess().getModelAssignment_4()); }
	(rule__InstanceMachine__ModelAssignment_4)
	{ after(grammarAccess.getInstanceMachineAccess().getModelAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InstanceMachine__Group__5__Impl
	rule__InstanceMachine__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInstanceMachineAccess().getGreaterThanSignKeyword_5()); }
	'>'
	{ after(grammarAccess.getInstanceMachineAccess().getGreaterThanSignKeyword_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InstanceMachine__Group__6__Impl
	rule__InstanceMachine__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInstanceMachineAccess().getNameAssignment_6()); }
	(rule__InstanceMachine__NameAssignment_6)
	{ after(grammarAccess.getInstanceMachineAccess().getNameAssignment_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InstanceMachine__Group__7__Impl
	rule__InstanceMachine__Group__8
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInstanceMachineAccess().getUnrestrictedNameAssignment_7()); }
	(rule__InstanceMachine__UnrestrictedNameAssignment_7)?
	{ after(grammarAccess.getInstanceMachineAccess().getUnrestrictedNameAssignment_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InstanceMachine__Group__8__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInstanceMachineAccess().getAlternatives_8()); }
	(rule__InstanceMachine__Alternatives_8)
	{ after(grammarAccess.getInstanceMachineAccess().getAlternatives_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__InstanceMachine__Group_8_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InstanceMachine__Group_8_0__0__Impl
	rule__InstanceMachine__Group_8_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group_8_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInstanceMachineAccess().getGroup_8_0_0()); }
	(rule__InstanceMachine__Group_8_0_0__0)?
	{ after(grammarAccess.getInstanceMachineAccess().getGroup_8_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group_8_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InstanceMachine__Group_8_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group_8_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInstanceMachineAccess().getSemicolonKeyword_8_0_1()); }
	';'
	{ after(grammarAccess.getInstanceMachineAccess().getSemicolonKeyword_8_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__InstanceMachine__Group_8_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InstanceMachine__Group_8_0_0__0__Impl
	rule__InstanceMachine__Group_8_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group_8_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInstanceMachineAccess().getLeftParenthesisKeyword_8_0_0_0()); }
	'('
	{ after(grammarAccess.getInstanceMachineAccess().getLeftParenthesisKeyword_8_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group_8_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InstanceMachine__Group_8_0_0__1__Impl
	rule__InstanceMachine__Group_8_0_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group_8_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInstanceMachineAccess().getGroup_8_0_0_1()); }
	(rule__InstanceMachine__Group_8_0_0_1__0)?
	{ after(grammarAccess.getInstanceMachineAccess().getGroup_8_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group_8_0_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InstanceMachine__Group_8_0_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group_8_0_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInstanceMachineAccess().getRightParenthesisKeyword_8_0_0_2()); }
	')'
	{ after(grammarAccess.getInstanceMachineAccess().getRightParenthesisKeyword_8_0_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__InstanceMachine__Group_8_0_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InstanceMachine__Group_8_0_0_1__0__Impl
	rule__InstanceMachine__Group_8_0_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group_8_0_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInstanceMachineAccess().getSlotAssignment_8_0_0_1_0()); }
	(rule__InstanceMachine__SlotAssignment_8_0_0_1_0)
	{ after(grammarAccess.getInstanceMachineAccess().getSlotAssignment_8_0_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group_8_0_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InstanceMachine__Group_8_0_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group_8_0_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInstanceMachineAccess().getGroup_8_0_0_1_1()); }
	(rule__InstanceMachine__Group_8_0_0_1_1__0)*
	{ after(grammarAccess.getInstanceMachineAccess().getGroup_8_0_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__InstanceMachine__Group_8_0_0_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InstanceMachine__Group_8_0_0_1_1__0__Impl
	rule__InstanceMachine__Group_8_0_0_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group_8_0_0_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInstanceMachineAccess().getCommaKeyword_8_0_0_1_1_0()); }
	','
	{ after(grammarAccess.getInstanceMachineAccess().getCommaKeyword_8_0_0_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group_8_0_0_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InstanceMachine__Group_8_0_0_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group_8_0_0_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInstanceMachineAccess().getSlotAssignment_8_0_0_1_1_1()); }
	(rule__InstanceMachine__SlotAssignment_8_0_0_1_1_1)
	{ after(grammarAccess.getInstanceMachineAccess().getSlotAssignment_8_0_0_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__InstanceMachine__Group_8_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InstanceMachine__Group_8_1__0__Impl
	rule__InstanceMachine__Group_8_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group_8_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInstanceMachineAccess().getLeftCurlyBracketKeyword_8_1_0()); }
	'{'
	{ after(grammarAccess.getInstanceMachineAccess().getLeftCurlyBracketKeyword_8_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group_8_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InstanceMachine__Group_8_1__1__Impl
	rule__InstanceMachine__Group_8_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group_8_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInstanceMachineAccess().getGroup_8_1_1()); }
	(rule__InstanceMachine__Group_8_1_1__0)*
	{ after(grammarAccess.getInstanceMachineAccess().getGroup_8_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group_8_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InstanceMachine__Group_8_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group_8_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInstanceMachineAccess().getRightCurlyBracketKeyword_8_1_2()); }
	'}'
	{ after(grammarAccess.getInstanceMachineAccess().getRightCurlyBracketKeyword_8_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__InstanceMachine__Group_8_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InstanceMachine__Group_8_1_1__0__Impl
	rule__InstanceMachine__Group_8_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group_8_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInstanceMachineAccess().getSlotAssignment_8_1_1_0()); }
	(rule__InstanceMachine__SlotAssignment_8_1_1_0)
	{ after(grammarAccess.getInstanceMachineAccess().getSlotAssignment_8_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group_8_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__InstanceMachine__Group_8_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__InstanceMachine__Group_8_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getInstanceMachineAccess().getSemicolonKeyword_8_1_1_1()); }
	';'
	{ after(grammarAccess.getInstanceMachineAccess().getSemicolonKeyword_8_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SlotParameter__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SlotParameter__Group__0__Impl
	rule__SlotParameter__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SlotParameter__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSlotParameterAccess().getXliaPropertyAssignment_0()); }
	(rule__SlotParameter__XliaPropertyAssignment_0)
	{ after(grammarAccess.getSlotParameterAccess().getXliaPropertyAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SlotParameter__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SlotParameter__Group__1__Impl
	rule__SlotParameter__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__SlotParameter__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSlotParameterAccess().getAlternatives_1()); }
	(rule__SlotParameter__Alternatives_1)
	{ after(grammarAccess.getSlotParameterAccess().getAlternatives_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SlotParameter__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SlotParameter__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SlotParameter__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSlotParameterAccess().getValueAssignment_2()); }
	(rule__SlotParameter__ValueAssignment_2)
	{ after(grammarAccess.getSlotParameterAccess().getValueAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SlotProperty__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SlotProperty__Group__0__Impl
	rule__SlotProperty__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SlotProperty__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSlotPropertyAccess().getXliaPropertyAssignment_0()); }
	(rule__SlotProperty__XliaPropertyAssignment_0)
	{ after(grammarAccess.getSlotPropertyAccess().getXliaPropertyAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SlotProperty__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SlotProperty__Group__1__Impl
	rule__SlotProperty__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__SlotProperty__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSlotPropertyAccess().getAlternatives_1()); }
	(rule__SlotProperty__Alternatives_1)
	{ after(grammarAccess.getSlotPropertyAccess().getAlternatives_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SlotProperty__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SlotProperty__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SlotProperty__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSlotPropertyAccess().getValueAssignment_2()); }
	(rule__SlotProperty__ValueAssignment_2)
	{ after(grammarAccess.getSlotPropertyAccess().getValueAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MachineBlock__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group__0__Impl
	rule__MachineBlock__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getUnorderedGroup_0()); }
	(rule__MachineBlock__UnorderedGroup_0)
	{ after(grammarAccess.getMachineBlockAccess().getUnorderedGroup_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group__1__Impl
	rule__MachineBlock__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getMachineKeyword_1()); }
	'machine'
	{ after(grammarAccess.getMachineBlockAccess().getMachineKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group__2__Impl
	rule__MachineBlock__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getGroup_2()); }
	(rule__MachineBlock__Group_2__0)?
	{ after(grammarAccess.getMachineBlockAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group__3__Impl
	rule__MachineBlock__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getNameAssignment_3()); }
	(rule__MachineBlock__NameAssignment_3)
	{ after(grammarAccess.getMachineBlockAccess().getNameAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group__4__Impl
	rule__MachineBlock__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getUnrestrictedNameAssignment_4()); }
	(rule__MachineBlock__UnrestrictedNameAssignment_4)?
	{ after(grammarAccess.getMachineBlockAccess().getUnrestrictedNameAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group__5__Impl
	rule__MachineBlock__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getLeftCurlyBracketKeyword_5()); }
	'{'
	{ after(grammarAccess.getMachineBlockAccess().getLeftCurlyBracketKeyword_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group__6__Impl
	rule__MachineBlock__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getAlternatives_6()); }
	(rule__MachineBlock__Alternatives_6)*
	{ after(grammarAccess.getMachineBlockAccess().getAlternatives_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group__7__Impl
	rule__MachineBlock__Group__8
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getAlternatives_7()); }
	(rule__MachineBlock__Alternatives_7)*
	{ after(grammarAccess.getMachineBlockAccess().getAlternatives_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group__8__Impl
	rule__MachineBlock__Group__9
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getAlternatives_8()); }
	(rule__MachineBlock__Alternatives_8)
	{ after(grammarAccess.getMachineBlockAccess().getAlternatives_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group__9
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group__9__Impl
	rule__MachineBlock__Group__10
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group__9__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getAlternatives_9()); }
	(rule__MachineBlock__Alternatives_9)*
	{ after(grammarAccess.getMachineBlockAccess().getAlternatives_9()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group__10
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group__10__Impl
	rule__MachineBlock__Group__11
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group__10__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getAlternatives_10()); }
	(rule__MachineBlock__Alternatives_10)*
	{ after(grammarAccess.getMachineBlockAccess().getAlternatives_10()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group__11
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group__11__Impl
	rule__MachineBlock__Group__12
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group__11__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getMainAssignment_11()); }
	(rule__MachineBlock__MainAssignment_11)
	{ after(grammarAccess.getMachineBlockAccess().getMainAssignment_11()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group__12
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group__12__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group__12__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getRightCurlyBracketKeyword_12()); }
	'}'
	{ after(grammarAccess.getMachineBlockAccess().getRightCurlyBracketKeyword_12()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MachineBlock__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group_2__0__Impl
	rule__MachineBlock__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getLessThanSignKeyword_2_0()); }
	'<'
	{ after(grammarAccess.getMachineBlockAccess().getLessThanSignKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group_2__1__Impl
	rule__MachineBlock__Group_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getMocKeyword_2_1()); }
	('moc:')?
	{ after(grammarAccess.getMachineBlockAccess().getMocKeyword_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group_2__2__Impl
	rule__MachineBlock__Group_2__3
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getAlternatives_2_2()); }
	(rule__MachineBlock__Alternatives_2_2)
	{ after(grammarAccess.getMachineBlockAccess().getAlternatives_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_2__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group_2__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_2__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getGreaterThanSignKeyword_2_3()); }
	'>'
	{ after(grammarAccess.getMachineBlockAccess().getGreaterThanSignKeyword_2_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MachineBlock__Group_7_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group_7_0__0__Impl
	rule__MachineBlock__Group_7_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_7_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getPropertyKeyword_7_0_0()); }
	'@property:'
	{ after(grammarAccess.getMachineBlockAccess().getPropertyKeyword_7_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_7_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group_7_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_7_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getAlternatives_7_0_1()); }
	(rule__MachineBlock__Alternatives_7_0_1)*
	{ after(grammarAccess.getMachineBlockAccess().getAlternatives_7_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MachineBlock__Group_7_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group_7_1__0__Impl
	rule__MachineBlock__Group_7_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_7_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getPublicKeyword_7_1_0()); }
	'@public:'
	{ after(grammarAccess.getMachineBlockAccess().getPublicKeyword_7_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_7_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group_7_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_7_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getAlternatives_7_1_1()); }
	(rule__MachineBlock__Alternatives_7_1_1)*
	{ after(grammarAccess.getMachineBlockAccess().getAlternatives_7_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MachineBlock__Group_7_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group_7_2__0__Impl
	rule__MachineBlock__Group_7_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_7_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getProtectedKeyword_7_2_0()); }
	'@protected:'
	{ after(grammarAccess.getMachineBlockAccess().getProtectedKeyword_7_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_7_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group_7_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_7_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getAlternatives_7_2_1()); }
	(rule__MachineBlock__Alternatives_7_2_1)*
	{ after(grammarAccess.getMachineBlockAccess().getAlternatives_7_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MachineBlock__Group_7_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group_7_3__0__Impl
	rule__MachineBlock__Group_7_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_7_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getPrivateKeyword_7_3_0()); }
	'@private:'
	{ after(grammarAccess.getMachineBlockAccess().getPrivateKeyword_7_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_7_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group_7_3__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_7_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getAlternatives_7_3_1()); }
	(rule__MachineBlock__Alternatives_7_3_1)*
	{ after(grammarAccess.getMachineBlockAccess().getAlternatives_7_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MachineBlock__Group_8_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group_8_0_0__0__Impl
	rule__MachineBlock__Group_8_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_8_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getAlternatives_8_0_0_0()); }
	(rule__MachineBlock__Alternatives_8_0_0_0)
	{ after(grammarAccess.getMachineBlockAccess().getAlternatives_8_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_8_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group_8_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_8_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getMachineBlockAccess().getRoutineAssignment_8_0_0_1()); }
		(rule__MachineBlock__RoutineAssignment_8_0_0_1)
		{ after(grammarAccess.getMachineBlockAccess().getRoutineAssignment_8_0_0_1()); }
	)
	(
		{ before(grammarAccess.getMachineBlockAccess().getRoutineAssignment_8_0_0_1()); }
		(rule__MachineBlock__RoutineAssignment_8_0_0_1)*
		{ after(grammarAccess.getMachineBlockAccess().getRoutineAssignment_8_0_0_1()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MachineBlock__Group_8_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group_8_0_1__0__Impl
	rule__MachineBlock__Group_8_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_8_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getProcedureKeyword_8_0_1_0()); }
	'@procedure:'
	{ after(grammarAccess.getMachineBlockAccess().getProcedureKeyword_8_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_8_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group_8_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_8_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getMachineBlockAccess().getProcedureAssignment_8_0_1_1()); }
		(rule__MachineBlock__ProcedureAssignment_8_0_1_1)
		{ after(grammarAccess.getMachineBlockAccess().getProcedureAssignment_8_0_1_1()); }
	)
	(
		{ before(grammarAccess.getMachineBlockAccess().getProcedureAssignment_8_0_1_1()); }
		(rule__MachineBlock__ProcedureAssignment_8_0_1_1)*
		{ after(grammarAccess.getMachineBlockAccess().getProcedureAssignment_8_0_1_1()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MachineBlock__Group_9_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group_9_0__0__Impl
	rule__MachineBlock__Group_9_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_9_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getAlternatives_9_0_0()); }
	(rule__MachineBlock__Alternatives_9_0_0)
	{ after(grammarAccess.getMachineBlockAccess().getAlternatives_9_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_9_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group_9_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_9_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getMachineBlockAccess().getAlternatives_9_0_1()); }
		(rule__MachineBlock__Alternatives_9_0_1)
		{ after(grammarAccess.getMachineBlockAccess().getAlternatives_9_0_1()); }
	)
	(
		{ before(grammarAccess.getMachineBlockAccess().getAlternatives_9_0_1()); }
		(rule__MachineBlock__Alternatives_9_0_1)*
		{ after(grammarAccess.getMachineBlockAccess().getAlternatives_9_0_1()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MachineBlock__Group_9_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group_9_1__0__Impl
	rule__MachineBlock__Group_9_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_9_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getModelKeyword_9_1_0()); }
	'@model:'
	{ after(grammarAccess.getMachineBlockAccess().getModelKeyword_9_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_9_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group_9_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_9_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getMachineAssignment_9_1_1()); }
	(rule__MachineBlock__MachineAssignment_9_1_1)*
	{ after(grammarAccess.getMachineBlockAccess().getMachineAssignment_9_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MachineBlock__Group_9_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group_9_2__0__Impl
	rule__MachineBlock__Group_9_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_9_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getPrototypeKeyword_9_2_0()); }
	'@prototype:'
	{ after(grammarAccess.getMachineBlockAccess().getPrototypeKeyword_9_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_9_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group_9_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_9_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getMachineAssignment_9_2_1()); }
	(rule__MachineBlock__MachineAssignment_9_2_1)*
	{ after(grammarAccess.getMachineBlockAccess().getMachineAssignment_9_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MachineBlock__Group_9_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group_9_3__0__Impl
	rule__MachineBlock__Group_9_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_9_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getInstanceKeyword_9_3_0()); }
	'@instance:'
	{ after(grammarAccess.getMachineBlockAccess().getInstanceKeyword_9_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_9_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group_9_3__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_9_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getInstanceAssignment_9_3_1()); }
	(rule__MachineBlock__InstanceAssignment_9_3_1)*
	{ after(grammarAccess.getMachineBlockAccess().getInstanceAssignment_9_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MachineBlock__Group_10_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group_10_0__0__Impl
	rule__MachineBlock__Group_10_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_10_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getBehaviorKeyword_10_0_0()); }
	'@behavior:'
	{ after(grammarAccess.getMachineBlockAccess().getBehaviorKeyword_10_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_10_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group_10_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_10_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getMachineBlockAccess().getBehaviorAssignment_10_0_1()); }
		(rule__MachineBlock__BehaviorAssignment_10_0_1)
		{ after(grammarAccess.getMachineBlockAccess().getBehaviorAssignment_10_0_1()); }
	)
	(
		{ before(grammarAccess.getMachineBlockAccess().getBehaviorAssignment_10_0_1()); }
		(rule__MachineBlock__BehaviorAssignment_10_0_1)*
		{ after(grammarAccess.getMachineBlockAccess().getBehaviorAssignment_10_0_1()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MachineBlock__Group_10_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group_10_1__0__Impl
	rule__MachineBlock__Group_10_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_10_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMachineBlockAccess().getStatemachineKeyword_10_1_0()); }
	'@statemachine:'
	{ after(grammarAccess.getMachineBlockAccess().getStatemachineKeyword_10_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_10_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MachineBlock__Group_10_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MachineBlock__Group_10_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getMachineBlockAccess().getBehaviorAssignment_10_1_1()); }
		(rule__MachineBlock__BehaviorAssignment_10_1_1)
		{ after(grammarAccess.getMachineBlockAccess().getBehaviorAssignment_10_1_1()); }
	)
	(
		{ before(grammarAccess.getMachineBlockAccess().getBehaviorAssignment_10_1_1()); }
		(rule__MachineBlock__BehaviorAssignment_10_1_1)*
		{ after(grammarAccess.getMachineBlockAccess().getBehaviorAssignment_10_1_1()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Procedure__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group__0__Impl
	rule__Procedure__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getVisibilityAssignment_0()); }
	(rule__Procedure__VisibilityAssignment_0)?
	{ after(grammarAccess.getProcedureAccess().getVisibilityAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group__1__Impl
	rule__Procedure__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getProcedureKeyword_1()); }
	'procedure'
	{ after(grammarAccess.getProcedureAccess().getProcedureKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group__2__Impl
	rule__Procedure__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getGroup_2()); }
	(rule__Procedure__Group_2__0)?
	{ after(grammarAccess.getProcedureAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group__3__Impl
	rule__Procedure__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getNameAssignment_3()); }
	(rule__Procedure__NameAssignment_3)
	{ after(grammarAccess.getProcedureAccess().getNameAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group__4__Impl
	rule__Procedure__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getUnrestrictedNameAssignment_4()); }
	(rule__Procedure__UnrestrictedNameAssignment_4)?
	{ after(grammarAccess.getProcedureAccess().getUnrestrictedNameAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group__5__Impl
	rule__Procedure__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getGroup_5()); }
	(rule__Procedure__Group_5__0)?
	{ after(grammarAccess.getProcedureAccess().getGroup_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group__6__Impl
	rule__Procedure__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getLeftCurlyBracketKeyword_6()); }
	'{'
	{ after(grammarAccess.getProcedureAccess().getLeftCurlyBracketKeyword_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group__7__Impl
	rule__Procedure__Group__8
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getAlternatives_7()); }
	(rule__Procedure__Alternatives_7)
	{ after(grammarAccess.getProcedureAccess().getAlternatives_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group__8__Impl
	rule__Procedure__Group__9
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getAlternatives_8()); }
	(rule__Procedure__Alternatives_8)*
	{ after(grammarAccess.getProcedureAccess().getAlternatives_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group__9
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group__9__Impl
	rule__Procedure__Group__10
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group__9__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getAlternatives_9()); }
	(rule__Procedure__Alternatives_9)*
	{ after(grammarAccess.getProcedureAccess().getAlternatives_9()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group__10
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group__10__Impl
	rule__Procedure__Group__11
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group__10__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getAlternatives_10()); }
	(rule__Procedure__Alternatives_10)
	{ after(grammarAccess.getProcedureAccess().getAlternatives_10()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group__11
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group__11__Impl
	rule__Procedure__Group__12
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group__11__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getAlternatives_11()); }
	(rule__Procedure__Alternatives_11)?
	{ after(grammarAccess.getProcedureAccess().getAlternatives_11()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group__12
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group__12__Impl
	rule__Procedure__Group__13
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group__12__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getExecutionAssignment_12()); }
	(rule__Procedure__ExecutionAssignment_12)?
	{ after(grammarAccess.getProcedureAccess().getExecutionAssignment_12()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group__13
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group__13__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group__13__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getRightCurlyBracketKeyword_13()); }
	'}'
	{ after(grammarAccess.getProcedureAccess().getRightCurlyBracketKeyword_13()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Procedure__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_2__0__Impl
	rule__Procedure__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getLessThanSignKeyword_2_0()); }
	'<'
	{ after(grammarAccess.getProcedureAccess().getLessThanSignKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_2__1__Impl
	rule__Procedure__Group_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getMocKeyword_2_1()); }
	('moc:')?
	{ after(grammarAccess.getProcedureAccess().getMocKeyword_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_2__2__Impl
	rule__Procedure__Group_2__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getAlternatives_2_2()); }
	(rule__Procedure__Alternatives_2_2)
	{ after(grammarAccess.getProcedureAccess().getAlternatives_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_2__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_2__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_2__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getGreaterThanSignKeyword_2_3()); }
	'>'
	{ after(grammarAccess.getProcedureAccess().getGreaterThanSignKeyword_2_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Procedure__Group_5__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_5__0__Impl
	rule__Procedure__Group_5__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_5__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getGroup_5_0()); }
	(rule__Procedure__Group_5_0__0)?
	{ after(grammarAccess.getProcedureAccess().getGroup_5_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_5__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_5__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_5__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getGroup_5_1()); }
	(rule__Procedure__Group_5_1__0)?
	{ after(grammarAccess.getProcedureAccess().getGroup_5_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Procedure__Group_5_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_5_0__0__Impl
	rule__Procedure__Group_5_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_5_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getLeftParenthesisKeyword_5_0_0()); }
	'('
	{ after(grammarAccess.getProcedureAccess().getLeftParenthesisKeyword_5_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_5_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_5_0__1__Impl
	rule__Procedure__Group_5_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_5_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getGroup_5_0_1()); }
	(rule__Procedure__Group_5_0_1__0)?
	{ after(grammarAccess.getProcedureAccess().getGroup_5_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_5_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_5_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_5_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getRightParenthesisKeyword_5_0_2()); }
	')'
	{ after(grammarAccess.getProcedureAccess().getRightParenthesisKeyword_5_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Procedure__Group_5_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_5_0_1__0__Impl
	rule__Procedure__Group_5_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_5_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getParameterAssignment_5_0_1_0()); }
	(rule__Procedure__ParameterAssignment_5_0_1_0)
	{ after(grammarAccess.getProcedureAccess().getParameterAssignment_5_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_5_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_5_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_5_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getGroup_5_0_1_1()); }
	(rule__Procedure__Group_5_0_1_1__0)*
	{ after(grammarAccess.getProcedureAccess().getGroup_5_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Procedure__Group_5_0_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_5_0_1_1__0__Impl
	rule__Procedure__Group_5_0_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_5_0_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getCommaKeyword_5_0_1_1_0()); }
	','
	{ after(grammarAccess.getProcedureAccess().getCommaKeyword_5_0_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_5_0_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_5_0_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_5_0_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getParameterAssignment_5_0_1_1_1()); }
	(rule__Procedure__ParameterAssignment_5_0_1_1_1)
	{ after(grammarAccess.getProcedureAccess().getParameterAssignment_5_0_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Procedure__Group_5_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_5_1__0__Impl
	rule__Procedure__Group_5_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_5_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getHyphenMinusHyphenMinusGreaterThanSignKeyword_5_1_0()); }
	'-->'
	{ after(grammarAccess.getProcedureAccess().getHyphenMinusHyphenMinusGreaterThanSignKeyword_5_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_5_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_5_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_5_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getAlternatives_5_1_1()); }
	(rule__Procedure__Alternatives_5_1_1)
	{ after(grammarAccess.getProcedureAccess().getAlternatives_5_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Procedure__Group_5_1_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_5_1_1_1__0__Impl
	rule__Procedure__Group_5_1_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_5_1_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getLeftParenthesisKeyword_5_1_1_1_0()); }
	'('
	{ after(grammarAccess.getProcedureAccess().getLeftParenthesisKeyword_5_1_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_5_1_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_5_1_1_1__1__Impl
	rule__Procedure__Group_5_1_1_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_5_1_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getParameterAssignment_5_1_1_1_1()); }
	(rule__Procedure__ParameterAssignment_5_1_1_1_1)
	{ after(grammarAccess.getProcedureAccess().getParameterAssignment_5_1_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_5_1_1_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_5_1_1_1__2__Impl
	rule__Procedure__Group_5_1_1_1__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_5_1_1_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getGroup_5_1_1_1_2()); }
	(rule__Procedure__Group_5_1_1_1_2__0)*
	{ after(grammarAccess.getProcedureAccess().getGroup_5_1_1_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_5_1_1_1__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_5_1_1_1__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_5_1_1_1__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getRightParenthesisKeyword_5_1_1_1_3()); }
	')'
	{ after(grammarAccess.getProcedureAccess().getRightParenthesisKeyword_5_1_1_1_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Procedure__Group_5_1_1_1_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_5_1_1_1_2__0__Impl
	rule__Procedure__Group_5_1_1_1_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_5_1_1_1_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getCommaKeyword_5_1_1_1_2_0()); }
	','
	{ after(grammarAccess.getProcedureAccess().getCommaKeyword_5_1_1_1_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_5_1_1_1_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_5_1_1_1_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_5_1_1_1_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getParameterAssignment_5_1_1_1_2_1()); }
	(rule__Procedure__ParameterAssignment_5_1_1_1_2_1)
	{ after(grammarAccess.getProcedureAccess().getParameterAssignment_5_1_1_1_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Procedure__Group_7_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_7_0__0__Impl
	rule__Procedure__Group_7_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getParameterKeyword_7_0_0()); }
	'@parameter:'
	{ after(grammarAccess.getProcedureAccess().getParameterKeyword_7_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_7_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getAlternatives_7_0_1()); }
	(rule__Procedure__Alternatives_7_0_1)*
	{ after(grammarAccess.getProcedureAccess().getAlternatives_7_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Procedure__Group_7_0_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_7_0_1_0__0__Impl
	rule__Procedure__Group_7_0_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getInputKeyword_7_0_1_0_0()); }
	'input'
	{ after(grammarAccess.getProcedureAccess().getInputKeyword_7_0_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_7_0_1_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getAlternatives_7_0_1_0_1()); }
	(rule__Procedure__Alternatives_7_0_1_0_1)
	{ after(grammarAccess.getProcedureAccess().getAlternatives_7_0_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Procedure__Group_7_0_1_0_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_7_0_1_0_1_1__0__Impl
	rule__Procedure__Group_7_0_1_0_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0_1_0_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getLeftCurlyBracketKeyword_7_0_1_0_1_1_0()); }
	'{'
	{ after(grammarAccess.getProcedureAccess().getLeftCurlyBracketKeyword_7_0_1_0_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0_1_0_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_7_0_1_0_1_1__1__Impl
	rule__Procedure__Group_7_0_1_0_1_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0_1_0_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getProcedureAccess().getParameterAssignment_7_0_1_0_1_1_1()); }
		(rule__Procedure__ParameterAssignment_7_0_1_0_1_1_1)
		{ after(grammarAccess.getProcedureAccess().getParameterAssignment_7_0_1_0_1_1_1()); }
	)
	(
		{ before(grammarAccess.getProcedureAccess().getParameterAssignment_7_0_1_0_1_1_1()); }
		(rule__Procedure__ParameterAssignment_7_0_1_0_1_1_1)*
		{ after(grammarAccess.getProcedureAccess().getParameterAssignment_7_0_1_0_1_1_1()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0_1_0_1_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_7_0_1_0_1_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0_1_0_1_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getRightCurlyBracketKeyword_7_0_1_0_1_1_2()); }
	'}'
	{ after(grammarAccess.getProcedureAccess().getRightCurlyBracketKeyword_7_0_1_0_1_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Procedure__Group_7_0_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_7_0_1_1__0__Impl
	rule__Procedure__Group_7_0_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getInoutKeyword_7_0_1_1_0()); }
	'inout'
	{ after(grammarAccess.getProcedureAccess().getInoutKeyword_7_0_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_7_0_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getAlternatives_7_0_1_1_1()); }
	(rule__Procedure__Alternatives_7_0_1_1_1)
	{ after(grammarAccess.getProcedureAccess().getAlternatives_7_0_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Procedure__Group_7_0_1_1_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_7_0_1_1_1_1__0__Impl
	rule__Procedure__Group_7_0_1_1_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0_1_1_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getLeftCurlyBracketKeyword_7_0_1_1_1_1_0()); }
	'{'
	{ after(grammarAccess.getProcedureAccess().getLeftCurlyBracketKeyword_7_0_1_1_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0_1_1_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_7_0_1_1_1_1__1__Impl
	rule__Procedure__Group_7_0_1_1_1_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0_1_1_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getProcedureAccess().getParameterAssignment_7_0_1_1_1_1_1()); }
		(rule__Procedure__ParameterAssignment_7_0_1_1_1_1_1)
		{ after(grammarAccess.getProcedureAccess().getParameterAssignment_7_0_1_1_1_1_1()); }
	)
	(
		{ before(grammarAccess.getProcedureAccess().getParameterAssignment_7_0_1_1_1_1_1()); }
		(rule__Procedure__ParameterAssignment_7_0_1_1_1_1_1)*
		{ after(grammarAccess.getProcedureAccess().getParameterAssignment_7_0_1_1_1_1_1()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0_1_1_1_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_7_0_1_1_1_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0_1_1_1_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getRightCurlyBracketKeyword_7_0_1_1_1_1_2()); }
	'}'
	{ after(grammarAccess.getProcedureAccess().getRightCurlyBracketKeyword_7_0_1_1_1_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Procedure__Group_7_0_1_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_7_0_1_2__0__Impl
	rule__Procedure__Group_7_0_1_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0_1_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getOutputKeyword_7_0_1_2_0()); }
	'output'
	{ after(grammarAccess.getProcedureAccess().getOutputKeyword_7_0_1_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0_1_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_7_0_1_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0_1_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getAlternatives_7_0_1_2_1()); }
	(rule__Procedure__Alternatives_7_0_1_2_1)
	{ after(grammarAccess.getProcedureAccess().getAlternatives_7_0_1_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Procedure__Group_7_0_1_2_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_7_0_1_2_1_1__0__Impl
	rule__Procedure__Group_7_0_1_2_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0_1_2_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getLeftCurlyBracketKeyword_7_0_1_2_1_1_0()); }
	'{'
	{ after(grammarAccess.getProcedureAccess().getLeftCurlyBracketKeyword_7_0_1_2_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0_1_2_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_7_0_1_2_1_1__1__Impl
	rule__Procedure__Group_7_0_1_2_1_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0_1_2_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getProcedureAccess().getParameterAssignment_7_0_1_2_1_1_1()); }
		(rule__Procedure__ParameterAssignment_7_0_1_2_1_1_1)
		{ after(grammarAccess.getProcedureAccess().getParameterAssignment_7_0_1_2_1_1_1()); }
	)
	(
		{ before(grammarAccess.getProcedureAccess().getParameterAssignment_7_0_1_2_1_1_1()); }
		(rule__Procedure__ParameterAssignment_7_0_1_2_1_1_1)*
		{ after(grammarAccess.getProcedureAccess().getParameterAssignment_7_0_1_2_1_1_1()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0_1_2_1_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_7_0_1_2_1_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0_1_2_1_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getRightCurlyBracketKeyword_7_0_1_2_1_1_2()); }
	'}'
	{ after(grammarAccess.getProcedureAccess().getRightCurlyBracketKeyword_7_0_1_2_1_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Procedure__Group_7_0_1_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_7_0_1_3__0__Impl
	rule__Procedure__Group_7_0_1_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0_1_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getReturnKeyword_7_0_1_3_0()); }
	'return'
	{ after(grammarAccess.getProcedureAccess().getReturnKeyword_7_0_1_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0_1_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_7_0_1_3__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0_1_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getAlternatives_7_0_1_3_1()); }
	(rule__Procedure__Alternatives_7_0_1_3_1)
	{ after(grammarAccess.getProcedureAccess().getAlternatives_7_0_1_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Procedure__Group_7_0_1_3_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_7_0_1_3_1_1__0__Impl
	rule__Procedure__Group_7_0_1_3_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0_1_3_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getLeftCurlyBracketKeyword_7_0_1_3_1_1_0()); }
	'{'
	{ after(grammarAccess.getProcedureAccess().getLeftCurlyBracketKeyword_7_0_1_3_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0_1_3_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_7_0_1_3_1_1__1__Impl
	rule__Procedure__Group_7_0_1_3_1_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0_1_3_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getProcedureAccess().getParameterAssignment_7_0_1_3_1_1_1()); }
		(rule__Procedure__ParameterAssignment_7_0_1_3_1_1_1)
		{ after(grammarAccess.getProcedureAccess().getParameterAssignment_7_0_1_3_1_1_1()); }
	)
	(
		{ before(grammarAccess.getProcedureAccess().getParameterAssignment_7_0_1_3_1_1_1()); }
		(rule__Procedure__ParameterAssignment_7_0_1_3_1_1_1)*
		{ after(grammarAccess.getProcedureAccess().getParameterAssignment_7_0_1_3_1_1_1()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0_1_3_1_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_7_0_1_3_1_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_7_0_1_3_1_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getRightCurlyBracketKeyword_7_0_1_3_1_1_2()); }
	'}'
	{ after(grammarAccess.getProcedureAccess().getRightCurlyBracketKeyword_7_0_1_3_1_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Procedure__Group_8_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_8_0__0__Impl
	rule__Procedure__Group_8_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_8_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getInputKeyword_8_0_0()); }
	'@input:'
	{ after(grammarAccess.getProcedureAccess().getInputKeyword_8_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_8_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_8_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_8_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getAlternatives_8_0_1()); }
	(rule__Procedure__Alternatives_8_0_1)*
	{ after(grammarAccess.getProcedureAccess().getAlternatives_8_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Procedure__Group_8_0_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_8_0_1_1__0__Impl
	rule__Procedure__Group_8_0_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_8_0_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getLeftCurlyBracketKeyword_8_0_1_1_0()); }
	'{'
	{ after(grammarAccess.getProcedureAccess().getLeftCurlyBracketKeyword_8_0_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_8_0_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_8_0_1_1__1__Impl
	rule__Procedure__Group_8_0_1_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_8_0_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getProcedureAccess().getParameterAssignment_8_0_1_1_1()); }
		(rule__Procedure__ParameterAssignment_8_0_1_1_1)
		{ after(grammarAccess.getProcedureAccess().getParameterAssignment_8_0_1_1_1()); }
	)
	(
		{ before(grammarAccess.getProcedureAccess().getParameterAssignment_8_0_1_1_1()); }
		(rule__Procedure__ParameterAssignment_8_0_1_1_1)*
		{ after(grammarAccess.getProcedureAccess().getParameterAssignment_8_0_1_1_1()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_8_0_1_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_8_0_1_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_8_0_1_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getRightCurlyBracketKeyword_8_0_1_1_2()); }
	'}'
	{ after(grammarAccess.getProcedureAccess().getRightCurlyBracketKeyword_8_0_1_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Procedure__Group_8_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_8_1__0__Impl
	rule__Procedure__Group_8_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_8_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getInoutKeyword_8_1_0()); }
	'@inout:'
	{ after(grammarAccess.getProcedureAccess().getInoutKeyword_8_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_8_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_8_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_8_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getAlternatives_8_1_1()); }
	(rule__Procedure__Alternatives_8_1_1)*
	{ after(grammarAccess.getProcedureAccess().getAlternatives_8_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Procedure__Group_8_1_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_8_1_1_1__0__Impl
	rule__Procedure__Group_8_1_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_8_1_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getLeftCurlyBracketKeyword_8_1_1_1_0()); }
	'{'
	{ after(grammarAccess.getProcedureAccess().getLeftCurlyBracketKeyword_8_1_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_8_1_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_8_1_1_1__1__Impl
	rule__Procedure__Group_8_1_1_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_8_1_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getProcedureAccess().getParameterAssignment_8_1_1_1_1()); }
		(rule__Procedure__ParameterAssignment_8_1_1_1_1)
		{ after(grammarAccess.getProcedureAccess().getParameterAssignment_8_1_1_1_1()); }
	)
	(
		{ before(grammarAccess.getProcedureAccess().getParameterAssignment_8_1_1_1_1()); }
		(rule__Procedure__ParameterAssignment_8_1_1_1_1)*
		{ after(grammarAccess.getProcedureAccess().getParameterAssignment_8_1_1_1_1()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_8_1_1_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_8_1_1_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_8_1_1_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getRightCurlyBracketKeyword_8_1_1_1_2()); }
	'}'
	{ after(grammarAccess.getProcedureAccess().getRightCurlyBracketKeyword_8_1_1_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Procedure__Group_8_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_8_2__0__Impl
	rule__Procedure__Group_8_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_8_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getOutputKeyword_8_2_0()); }
	'@output:'
	{ after(grammarAccess.getProcedureAccess().getOutputKeyword_8_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_8_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_8_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_8_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getAlternatives_8_2_1()); }
	(rule__Procedure__Alternatives_8_2_1)*
	{ after(grammarAccess.getProcedureAccess().getAlternatives_8_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Procedure__Group_8_2_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_8_2_1_1__0__Impl
	rule__Procedure__Group_8_2_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_8_2_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getLeftCurlyBracketKeyword_8_2_1_1_0()); }
	'{'
	{ after(grammarAccess.getProcedureAccess().getLeftCurlyBracketKeyword_8_2_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_8_2_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_8_2_1_1__1__Impl
	rule__Procedure__Group_8_2_1_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_8_2_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getProcedureAccess().getParameterAssignment_8_2_1_1_1()); }
		(rule__Procedure__ParameterAssignment_8_2_1_1_1)
		{ after(grammarAccess.getProcedureAccess().getParameterAssignment_8_2_1_1_1()); }
	)
	(
		{ before(grammarAccess.getProcedureAccess().getParameterAssignment_8_2_1_1_1()); }
		(rule__Procedure__ParameterAssignment_8_2_1_1_1)*
		{ after(grammarAccess.getProcedureAccess().getParameterAssignment_8_2_1_1_1()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_8_2_1_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_8_2_1_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_8_2_1_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getRightCurlyBracketKeyword_8_2_1_1_2()); }
	'}'
	{ after(grammarAccess.getProcedureAccess().getRightCurlyBracketKeyword_8_2_1_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Procedure__Group_8_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_8_3__0__Impl
	rule__Procedure__Group_8_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_8_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getReturnKeyword_8_3_0()); }
	'@return:'
	{ after(grammarAccess.getProcedureAccess().getReturnKeyword_8_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_8_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_8_3__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_8_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getAlternatives_8_3_1()); }
	(rule__Procedure__Alternatives_8_3_1)*
	{ after(grammarAccess.getProcedureAccess().getAlternatives_8_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Procedure__Group_8_3_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_8_3_1_1__0__Impl
	rule__Procedure__Group_8_3_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_8_3_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getLeftCurlyBracketKeyword_8_3_1_1_0()); }
	'{'
	{ after(grammarAccess.getProcedureAccess().getLeftCurlyBracketKeyword_8_3_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_8_3_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_8_3_1_1__1__Impl
	rule__Procedure__Group_8_3_1_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_8_3_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getProcedureAccess().getParameterAssignment_8_3_1_1_1()); }
		(rule__Procedure__ParameterAssignment_8_3_1_1_1)
		{ after(grammarAccess.getProcedureAccess().getParameterAssignment_8_3_1_1_1()); }
	)
	(
		{ before(grammarAccess.getProcedureAccess().getParameterAssignment_8_3_1_1_1()); }
		(rule__Procedure__ParameterAssignment_8_3_1_1_1)*
		{ after(grammarAccess.getProcedureAccess().getParameterAssignment_8_3_1_1_1()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_8_3_1_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_8_3_1_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_8_3_1_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getRightCurlyBracketKeyword_8_3_1_1_2()); }
	'}'
	{ after(grammarAccess.getProcedureAccess().getRightCurlyBracketKeyword_8_3_1_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Procedure__Group_9_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_9_0__0__Impl
	rule__Procedure__Group_9_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_9_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getPropertyKeyword_9_0_0()); }
	'@property:'
	{ after(grammarAccess.getProcedureAccess().getPropertyKeyword_9_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_9_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_9_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_9_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getAlternatives_9_0_1()); }
	(rule__Procedure__Alternatives_9_0_1)*
	{ after(grammarAccess.getProcedureAccess().getAlternatives_9_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Procedure__Group_9_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_9_1__0__Impl
	rule__Procedure__Group_9_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_9_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getPublicKeyword_9_1_0()); }
	'@public:'
	{ after(grammarAccess.getProcedureAccess().getPublicKeyword_9_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_9_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_9_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_9_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getAlternatives_9_1_1()); }
	(rule__Procedure__Alternatives_9_1_1)*
	{ after(grammarAccess.getProcedureAccess().getAlternatives_9_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Procedure__Group_9_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_9_2__0__Impl
	rule__Procedure__Group_9_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_9_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getProtectedKeyword_9_2_0()); }
	'@protected:'
	{ after(grammarAccess.getProcedureAccess().getProtectedKeyword_9_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_9_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_9_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_9_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getAlternatives_9_2_1()); }
	(rule__Procedure__Alternatives_9_2_1)*
	{ after(grammarAccess.getProcedureAccess().getAlternatives_9_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Procedure__Group_9_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_9_3__0__Impl
	rule__Procedure__Group_9_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_9_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getPrivateKeyword_9_3_0()); }
	'@private:'
	{ after(grammarAccess.getProcedureAccess().getPrivateKeyword_9_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_9_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_9_3__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_9_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getAlternatives_9_3_1()); }
	(rule__Procedure__Alternatives_9_3_1)*
	{ after(grammarAccess.getProcedureAccess().getAlternatives_9_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Procedure__Group_10_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_10_0_0__0__Impl
	rule__Procedure__Group_10_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_10_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getAlternatives_10_0_0_0()); }
	(rule__Procedure__Alternatives_10_0_0_0)
	{ after(grammarAccess.getProcedureAccess().getAlternatives_10_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_10_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_10_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_10_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getProcedureAccess().getRoutineAssignment_10_0_0_1()); }
		(rule__Procedure__RoutineAssignment_10_0_0_1)
		{ after(grammarAccess.getProcedureAccess().getRoutineAssignment_10_0_0_1()); }
	)
	(
		{ before(grammarAccess.getProcedureAccess().getRoutineAssignment_10_0_0_1()); }
		(rule__Procedure__RoutineAssignment_10_0_0_1)*
		{ after(grammarAccess.getProcedureAccess().getRoutineAssignment_10_0_0_1()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Procedure__Group_10_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_10_0_1__0__Impl
	rule__Procedure__Group_10_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_10_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureAccess().getProcedureKeyword_10_0_1_0()); }
	'@procedure:'
	{ after(grammarAccess.getProcedureAccess().getProcedureKeyword_10_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_10_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Procedure__Group_10_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Procedure__Group_10_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getProcedureAccess().getProcedureAssignment_10_0_1_1()); }
		(rule__Procedure__ProcedureAssignment_10_0_1_1)
		{ after(grammarAccess.getProcedureAccess().getProcedureAssignment_10_0_1_1()); }
	)
	(
		{ before(grammarAccess.getProcedureAccess().getProcedureAssignment_10_0_1_1()); }
		(rule__Procedure__ProcedureAssignment_10_0_1_1)*
		{ after(grammarAccess.getProcedureAccess().getProcedureAssignment_10_0_1_1()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ProcedureExecution__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ProcedureExecution__Group__0__Impl
	rule__ProcedureExecution__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ProcedureExecution__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureExecutionAccess().getModelOfExecutionAction_0()); }
	()
	{ after(grammarAccess.getProcedureExecutionAccess().getModelOfExecutionAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ProcedureExecution__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ProcedureExecution__Group__1__Impl
	rule__ProcedureExecution__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ProcedureExecution__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureExecutionAccess().getMoeKeyword_1()); }
	('@moe:')?
	{ after(grammarAccess.getProcedureExecutionAccess().getMoeKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ProcedureExecution__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ProcedureExecution__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ProcedureExecution__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureExecutionAccess().getUnorderedGroup_2()); }
	(rule__ProcedureExecution__UnorderedGroup_2)
	{ after(grammarAccess.getProcedureExecutionAccess().getUnorderedGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ProcedureExecution__Group_2_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ProcedureExecution__Group_2_0__0__Impl
	rule__ProcedureExecution__Group_2_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ProcedureExecution__Group_2_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureExecutionAccess().getScheduleKeyword_2_0_0()); }
	'@schedule'
	{ after(grammarAccess.getProcedureExecutionAccess().getScheduleKeyword_2_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ProcedureExecution__Group_2_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ProcedureExecution__Group_2_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ProcedureExecution__Group_2_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureExecutionAccess().getScheduleRoutineAssignment_2_0_1()); }
	(rule__ProcedureExecution__ScheduleRoutineAssignment_2_0_1)
	{ after(grammarAccess.getProcedureExecutionAccess().getScheduleRoutineAssignment_2_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ProcedureExecution__Group_2_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ProcedureExecution__Group_2_1__0__Impl
	rule__ProcedureExecution__Group_2_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ProcedureExecution__Group_2_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureExecutionAccess().getRunKeyword_2_1_0()); }
	'@run'
	{ after(grammarAccess.getProcedureExecutionAccess().getRunKeyword_2_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ProcedureExecution__Group_2_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ProcedureExecution__Group_2_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ProcedureExecution__Group_2_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getProcedureExecutionAccess().getRunRoutineAssignment_2_1_1()); }
	(rule__ProcedureExecution__RunRoutineAssignment_2_1_1)
	{ after(grammarAccess.getProcedureExecutionAccess().getRunRoutineAssignment_2_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MoeBehavior__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MoeBehavior__Group__0__Impl
	rule__MoeBehavior__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeBehavior__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMoeBehaviorAccess().getBehaviorAction_0()); }
	()
	{ after(grammarAccess.getMoeBehaviorAccess().getBehaviorAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeBehavior__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MoeBehavior__Group__1__Impl
	rule__MoeBehavior__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeBehavior__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMoeBehaviorAccess().getGroup_1()); }
	(rule__MoeBehavior__Group_1__0)?
	{ after(grammarAccess.getMoeBehaviorAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeBehavior__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MoeBehavior__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeBehavior__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMoeBehaviorAccess().getUnorderedGroup_2()); }
	(rule__MoeBehavior__UnorderedGroup_2)
	{ after(grammarAccess.getMoeBehaviorAccess().getUnorderedGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MoeBehavior__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MoeBehavior__Group_1__0__Impl
	rule__MoeBehavior__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeBehavior__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMoeBehaviorAccess().getLocalKeyword_1_0()); }
	'@local:'
	{ after(grammarAccess.getMoeBehaviorAccess().getLocalKeyword_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeBehavior__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MoeBehavior__Group_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeBehavior__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMoeBehaviorAccess().getAlternatives_1_1()); }
	(rule__MoeBehavior__Alternatives_1_1)*
	{ after(grammarAccess.getMoeBehaviorAccess().getAlternatives_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Statemachine__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group__0__Impl
	rule__Statemachine__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getStatemachineAction_0()); }
	()
	{ after(grammarAccess.getStatemachineAccess().getStatemachineAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group__1__Impl
	rule__Statemachine__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getUnorderedGroup_1()); }
	(rule__Statemachine__UnorderedGroup_1)
	{ after(grammarAccess.getStatemachineAccess().getUnorderedGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group__2__Impl
	rule__Statemachine__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getStatemachineKeyword_2()); }
	'statemachine'
	{ after(grammarAccess.getStatemachineAccess().getStatemachineKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group__3__Impl
	rule__Statemachine__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getGroup_3()); }
	(rule__Statemachine__Group_3__0)?
	{ after(grammarAccess.getStatemachineAccess().getGroup_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group__4__Impl
	rule__Statemachine__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getNameAssignment_4()); }
	(rule__Statemachine__NameAssignment_4)
	{ after(grammarAccess.getStatemachineAccess().getNameAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group__5__Impl
	rule__Statemachine__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getUnrestrictedNameAssignment_5()); }
	(rule__Statemachine__UnrestrictedNameAssignment_5)?
	{ after(grammarAccess.getStatemachineAccess().getUnrestrictedNameAssignment_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group__6__Impl
	rule__Statemachine__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getLeftCurlyBracketKeyword_6()); }
	'{'
	{ after(grammarAccess.getStatemachineAccess().getLeftCurlyBracketKeyword_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group__7__Impl
	rule__Statemachine__Group__8
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getAlternatives_7()); }
	(rule__Statemachine__Alternatives_7)
	{ after(grammarAccess.getStatemachineAccess().getAlternatives_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group__8__Impl
	rule__Statemachine__Group__9
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getAlternatives_8()); }
	(rule__Statemachine__Alternatives_8)*
	{ after(grammarAccess.getStatemachineAccess().getAlternatives_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group__9
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group__9__Impl
	rule__Statemachine__Group__10
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group__9__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getAlternatives_9()); }
	(rule__Statemachine__Alternatives_9)*
	{ after(grammarAccess.getStatemachineAccess().getAlternatives_9()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group__10
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group__10__Impl
	rule__Statemachine__Group__11
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group__10__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getAlternatives_10()); }
	(rule__Statemachine__Alternatives_10)
	{ after(grammarAccess.getStatemachineAccess().getAlternatives_10()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group__11
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group__11__Impl
	rule__Statemachine__Group__12
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group__11__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getAlternatives_11()); }
	(rule__Statemachine__Alternatives_11)
	{ after(grammarAccess.getStatemachineAccess().getAlternatives_11()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group__12
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group__12__Impl
	rule__Statemachine__Group__13
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group__12__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getUnorderedGroup_12()); }
	(rule__Statemachine__UnorderedGroup_12)
	{ after(grammarAccess.getStatemachineAccess().getUnorderedGroup_12()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group__13
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group__13__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group__13__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getRightCurlyBracketKeyword_13()); }
	'}'
	{ after(grammarAccess.getStatemachineAccess().getRightCurlyBracketKeyword_13()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Statemachine__Group_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_3__0__Impl
	rule__Statemachine__Group_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getLessThanSignKeyword_3_0()); }
	'<'
	{ after(grammarAccess.getStatemachineAccess().getLessThanSignKeyword_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_3__1__Impl
	rule__Statemachine__Group_3__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getMocKeyword_3_1()); }
	('moc:')?
	{ after(grammarAccess.getStatemachineAccess().getMocKeyword_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_3__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_3__2__Impl
	rule__Statemachine__Group_3__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_3__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getAlternatives_3_2()); }
	(rule__Statemachine__Alternatives_3_2)
	{ after(grammarAccess.getStatemachineAccess().getAlternatives_3_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_3__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_3__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_3__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getGreaterThanSignKeyword_3_3()); }
	'>'
	{ after(grammarAccess.getStatemachineAccess().getGreaterThanSignKeyword_3_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Statemachine__Group_7_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_7_0__0__Impl
	rule__Statemachine__Group_7_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getParameterKeyword_7_0_0()); }
	'@parameter:'
	{ after(grammarAccess.getStatemachineAccess().getParameterKeyword_7_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_7_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getAlternatives_7_0_1()); }
	(rule__Statemachine__Alternatives_7_0_1)*
	{ after(grammarAccess.getStatemachineAccess().getAlternatives_7_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Statemachine__Group_7_0_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_7_0_1_0__0__Impl
	rule__Statemachine__Group_7_0_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getInputKeyword_7_0_1_0_0()); }
	'input'
	{ after(grammarAccess.getStatemachineAccess().getInputKeyword_7_0_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_7_0_1_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getAlternatives_7_0_1_0_1()); }
	(rule__Statemachine__Alternatives_7_0_1_0_1)
	{ after(grammarAccess.getStatemachineAccess().getAlternatives_7_0_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Statemachine__Group_7_0_1_0_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_7_0_1_0_1_1__0__Impl
	rule__Statemachine__Group_7_0_1_0_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0_1_0_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getLeftCurlyBracketKeyword_7_0_1_0_1_1_0()); }
	'{'
	{ after(grammarAccess.getStatemachineAccess().getLeftCurlyBracketKeyword_7_0_1_0_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0_1_0_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_7_0_1_0_1_1__1__Impl
	rule__Statemachine__Group_7_0_1_0_1_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0_1_0_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getStatemachineAccess().getParameterAssignment_7_0_1_0_1_1_1()); }
		(rule__Statemachine__ParameterAssignment_7_0_1_0_1_1_1)
		{ after(grammarAccess.getStatemachineAccess().getParameterAssignment_7_0_1_0_1_1_1()); }
	)
	(
		{ before(grammarAccess.getStatemachineAccess().getParameterAssignment_7_0_1_0_1_1_1()); }
		(rule__Statemachine__ParameterAssignment_7_0_1_0_1_1_1)*
		{ after(grammarAccess.getStatemachineAccess().getParameterAssignment_7_0_1_0_1_1_1()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0_1_0_1_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_7_0_1_0_1_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0_1_0_1_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getRightCurlyBracketKeyword_7_0_1_0_1_1_2()); }
	'}'
	{ after(grammarAccess.getStatemachineAccess().getRightCurlyBracketKeyword_7_0_1_0_1_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Statemachine__Group_7_0_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_7_0_1_1__0__Impl
	rule__Statemachine__Group_7_0_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getInoutKeyword_7_0_1_1_0()); }
	'inout'
	{ after(grammarAccess.getStatemachineAccess().getInoutKeyword_7_0_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_7_0_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getAlternatives_7_0_1_1_1()); }
	(rule__Statemachine__Alternatives_7_0_1_1_1)
	{ after(grammarAccess.getStatemachineAccess().getAlternatives_7_0_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Statemachine__Group_7_0_1_1_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_7_0_1_1_1_1__0__Impl
	rule__Statemachine__Group_7_0_1_1_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0_1_1_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getLeftCurlyBracketKeyword_7_0_1_1_1_1_0()); }
	'{'
	{ after(grammarAccess.getStatemachineAccess().getLeftCurlyBracketKeyword_7_0_1_1_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0_1_1_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_7_0_1_1_1_1__1__Impl
	rule__Statemachine__Group_7_0_1_1_1_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0_1_1_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getStatemachineAccess().getParameterAssignment_7_0_1_1_1_1_1()); }
		(rule__Statemachine__ParameterAssignment_7_0_1_1_1_1_1)
		{ after(grammarAccess.getStatemachineAccess().getParameterAssignment_7_0_1_1_1_1_1()); }
	)
	(
		{ before(grammarAccess.getStatemachineAccess().getParameterAssignment_7_0_1_1_1_1_1()); }
		(rule__Statemachine__ParameterAssignment_7_0_1_1_1_1_1)*
		{ after(grammarAccess.getStatemachineAccess().getParameterAssignment_7_0_1_1_1_1_1()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0_1_1_1_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_7_0_1_1_1_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0_1_1_1_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getRightCurlyBracketKeyword_7_0_1_1_1_1_2()); }
	'}'
	{ after(grammarAccess.getStatemachineAccess().getRightCurlyBracketKeyword_7_0_1_1_1_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Statemachine__Group_7_0_1_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_7_0_1_2__0__Impl
	rule__Statemachine__Group_7_0_1_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0_1_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getOutputKeyword_7_0_1_2_0()); }
	'output'
	{ after(grammarAccess.getStatemachineAccess().getOutputKeyword_7_0_1_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0_1_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_7_0_1_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0_1_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getAlternatives_7_0_1_2_1()); }
	(rule__Statemachine__Alternatives_7_0_1_2_1)
	{ after(grammarAccess.getStatemachineAccess().getAlternatives_7_0_1_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Statemachine__Group_7_0_1_2_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_7_0_1_2_1_1__0__Impl
	rule__Statemachine__Group_7_0_1_2_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0_1_2_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getLeftCurlyBracketKeyword_7_0_1_2_1_1_0()); }
	'{'
	{ after(grammarAccess.getStatemachineAccess().getLeftCurlyBracketKeyword_7_0_1_2_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0_1_2_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_7_0_1_2_1_1__1__Impl
	rule__Statemachine__Group_7_0_1_2_1_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0_1_2_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getStatemachineAccess().getParameterAssignment_7_0_1_2_1_1_1()); }
		(rule__Statemachine__ParameterAssignment_7_0_1_2_1_1_1)
		{ after(grammarAccess.getStatemachineAccess().getParameterAssignment_7_0_1_2_1_1_1()); }
	)
	(
		{ before(grammarAccess.getStatemachineAccess().getParameterAssignment_7_0_1_2_1_1_1()); }
		(rule__Statemachine__ParameterAssignment_7_0_1_2_1_1_1)*
		{ after(grammarAccess.getStatemachineAccess().getParameterAssignment_7_0_1_2_1_1_1()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0_1_2_1_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_7_0_1_2_1_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0_1_2_1_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getRightCurlyBracketKeyword_7_0_1_2_1_1_2()); }
	'}'
	{ after(grammarAccess.getStatemachineAccess().getRightCurlyBracketKeyword_7_0_1_2_1_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Statemachine__Group_7_0_1_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_7_0_1_3__0__Impl
	rule__Statemachine__Group_7_0_1_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0_1_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getReturnKeyword_7_0_1_3_0()); }
	'return'
	{ after(grammarAccess.getStatemachineAccess().getReturnKeyword_7_0_1_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0_1_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_7_0_1_3__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0_1_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getAlternatives_7_0_1_3_1()); }
	(rule__Statemachine__Alternatives_7_0_1_3_1)
	{ after(grammarAccess.getStatemachineAccess().getAlternatives_7_0_1_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Statemachine__Group_7_0_1_3_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_7_0_1_3_1_1__0__Impl
	rule__Statemachine__Group_7_0_1_3_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0_1_3_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getLeftCurlyBracketKeyword_7_0_1_3_1_1_0()); }
	'{'
	{ after(grammarAccess.getStatemachineAccess().getLeftCurlyBracketKeyword_7_0_1_3_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0_1_3_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_7_0_1_3_1_1__1__Impl
	rule__Statemachine__Group_7_0_1_3_1_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0_1_3_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getStatemachineAccess().getParameterAssignment_7_0_1_3_1_1_1()); }
		(rule__Statemachine__ParameterAssignment_7_0_1_3_1_1_1)
		{ after(grammarAccess.getStatemachineAccess().getParameterAssignment_7_0_1_3_1_1_1()); }
	)
	(
		{ before(grammarAccess.getStatemachineAccess().getParameterAssignment_7_0_1_3_1_1_1()); }
		(rule__Statemachine__ParameterAssignment_7_0_1_3_1_1_1)*
		{ after(grammarAccess.getStatemachineAccess().getParameterAssignment_7_0_1_3_1_1_1()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0_1_3_1_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_7_0_1_3_1_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_7_0_1_3_1_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getRightCurlyBracketKeyword_7_0_1_3_1_1_2()); }
	'}'
	{ after(grammarAccess.getStatemachineAccess().getRightCurlyBracketKeyword_7_0_1_3_1_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Statemachine__Group_8_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_8_0__0__Impl
	rule__Statemachine__Group_8_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_8_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getInputKeyword_8_0_0()); }
	'@input:'
	{ after(grammarAccess.getStatemachineAccess().getInputKeyword_8_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_8_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_8_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_8_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getAlternatives_8_0_1()); }
	(rule__Statemachine__Alternatives_8_0_1)*
	{ after(grammarAccess.getStatemachineAccess().getAlternatives_8_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Statemachine__Group_8_0_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_8_0_1_1__0__Impl
	rule__Statemachine__Group_8_0_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_8_0_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getLeftCurlyBracketKeyword_8_0_1_1_0()); }
	'{'
	{ after(grammarAccess.getStatemachineAccess().getLeftCurlyBracketKeyword_8_0_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_8_0_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_8_0_1_1__1__Impl
	rule__Statemachine__Group_8_0_1_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_8_0_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getStatemachineAccess().getParameterAssignment_8_0_1_1_1()); }
		(rule__Statemachine__ParameterAssignment_8_0_1_1_1)
		{ after(grammarAccess.getStatemachineAccess().getParameterAssignment_8_0_1_1_1()); }
	)
	(
		{ before(grammarAccess.getStatemachineAccess().getParameterAssignment_8_0_1_1_1()); }
		(rule__Statemachine__ParameterAssignment_8_0_1_1_1)*
		{ after(grammarAccess.getStatemachineAccess().getParameterAssignment_8_0_1_1_1()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_8_0_1_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_8_0_1_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_8_0_1_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getRightCurlyBracketKeyword_8_0_1_1_2()); }
	'}'
	{ after(grammarAccess.getStatemachineAccess().getRightCurlyBracketKeyword_8_0_1_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Statemachine__Group_8_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_8_1__0__Impl
	rule__Statemachine__Group_8_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_8_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getInoutKeyword_8_1_0()); }
	'@inout:'
	{ after(grammarAccess.getStatemachineAccess().getInoutKeyword_8_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_8_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_8_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_8_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getAlternatives_8_1_1()); }
	(rule__Statemachine__Alternatives_8_1_1)*
	{ after(grammarAccess.getStatemachineAccess().getAlternatives_8_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Statemachine__Group_8_1_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_8_1_1_1__0__Impl
	rule__Statemachine__Group_8_1_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_8_1_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getLeftCurlyBracketKeyword_8_1_1_1_0()); }
	'{'
	{ after(grammarAccess.getStatemachineAccess().getLeftCurlyBracketKeyword_8_1_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_8_1_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_8_1_1_1__1__Impl
	rule__Statemachine__Group_8_1_1_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_8_1_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getStatemachineAccess().getParameterAssignment_8_1_1_1_1()); }
		(rule__Statemachine__ParameterAssignment_8_1_1_1_1)
		{ after(grammarAccess.getStatemachineAccess().getParameterAssignment_8_1_1_1_1()); }
	)
	(
		{ before(grammarAccess.getStatemachineAccess().getParameterAssignment_8_1_1_1_1()); }
		(rule__Statemachine__ParameterAssignment_8_1_1_1_1)*
		{ after(grammarAccess.getStatemachineAccess().getParameterAssignment_8_1_1_1_1()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_8_1_1_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_8_1_1_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_8_1_1_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getRightCurlyBracketKeyword_8_1_1_1_2()); }
	'}'
	{ after(grammarAccess.getStatemachineAccess().getRightCurlyBracketKeyword_8_1_1_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Statemachine__Group_8_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_8_2__0__Impl
	rule__Statemachine__Group_8_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_8_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getOutputKeyword_8_2_0()); }
	'@output:'
	{ after(grammarAccess.getStatemachineAccess().getOutputKeyword_8_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_8_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_8_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_8_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getAlternatives_8_2_1()); }
	(rule__Statemachine__Alternatives_8_2_1)*
	{ after(grammarAccess.getStatemachineAccess().getAlternatives_8_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Statemachine__Group_8_2_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_8_2_1_1__0__Impl
	rule__Statemachine__Group_8_2_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_8_2_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getLeftCurlyBracketKeyword_8_2_1_1_0()); }
	'{'
	{ after(grammarAccess.getStatemachineAccess().getLeftCurlyBracketKeyword_8_2_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_8_2_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_8_2_1_1__1__Impl
	rule__Statemachine__Group_8_2_1_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_8_2_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getStatemachineAccess().getParameterAssignment_8_2_1_1_1()); }
		(rule__Statemachine__ParameterAssignment_8_2_1_1_1)
		{ after(grammarAccess.getStatemachineAccess().getParameterAssignment_8_2_1_1_1()); }
	)
	(
		{ before(grammarAccess.getStatemachineAccess().getParameterAssignment_8_2_1_1_1()); }
		(rule__Statemachine__ParameterAssignment_8_2_1_1_1)*
		{ after(grammarAccess.getStatemachineAccess().getParameterAssignment_8_2_1_1_1()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_8_2_1_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_8_2_1_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_8_2_1_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getRightCurlyBracketKeyword_8_2_1_1_2()); }
	'}'
	{ after(grammarAccess.getStatemachineAccess().getRightCurlyBracketKeyword_8_2_1_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Statemachine__Group_8_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_8_3__0__Impl
	rule__Statemachine__Group_8_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_8_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getReturnKeyword_8_3_0()); }
	'@return:'
	{ after(grammarAccess.getStatemachineAccess().getReturnKeyword_8_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_8_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_8_3__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_8_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getAlternatives_8_3_1()); }
	(rule__Statemachine__Alternatives_8_3_1)*
	{ after(grammarAccess.getStatemachineAccess().getAlternatives_8_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Statemachine__Group_8_3_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_8_3_1_1__0__Impl
	rule__Statemachine__Group_8_3_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_8_3_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getLeftCurlyBracketKeyword_8_3_1_1_0()); }
	'{'
	{ after(grammarAccess.getStatemachineAccess().getLeftCurlyBracketKeyword_8_3_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_8_3_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_8_3_1_1__1__Impl
	rule__Statemachine__Group_8_3_1_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_8_3_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getStatemachineAccess().getParameterAssignment_8_3_1_1_1()); }
		(rule__Statemachine__ParameterAssignment_8_3_1_1_1)
		{ after(grammarAccess.getStatemachineAccess().getParameterAssignment_8_3_1_1_1()); }
	)
	(
		{ before(grammarAccess.getStatemachineAccess().getParameterAssignment_8_3_1_1_1()); }
		(rule__Statemachine__ParameterAssignment_8_3_1_1_1)*
		{ after(grammarAccess.getStatemachineAccess().getParameterAssignment_8_3_1_1_1()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_8_3_1_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_8_3_1_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_8_3_1_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getRightCurlyBracketKeyword_8_3_1_1_2()); }
	'}'
	{ after(grammarAccess.getStatemachineAccess().getRightCurlyBracketKeyword_8_3_1_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Statemachine__Group_9_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_9_0__0__Impl
	rule__Statemachine__Group_9_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_9_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getPropertyKeyword_9_0_0()); }
	'@property:'
	{ after(grammarAccess.getStatemachineAccess().getPropertyKeyword_9_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_9_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_9_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_9_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getAlternatives_9_0_1()); }
	(rule__Statemachine__Alternatives_9_0_1)*
	{ after(grammarAccess.getStatemachineAccess().getAlternatives_9_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Statemachine__Group_9_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_9_1__0__Impl
	rule__Statemachine__Group_9_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_9_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getPublicKeyword_9_1_0()); }
	'@public:'
	{ after(grammarAccess.getStatemachineAccess().getPublicKeyword_9_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_9_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_9_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_9_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getAlternatives_9_1_1()); }
	(rule__Statemachine__Alternatives_9_1_1)*
	{ after(grammarAccess.getStatemachineAccess().getAlternatives_9_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Statemachine__Group_9_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_9_2__0__Impl
	rule__Statemachine__Group_9_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_9_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getProtectedKeyword_9_2_0()); }
	'@protected:'
	{ after(grammarAccess.getStatemachineAccess().getProtectedKeyword_9_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_9_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_9_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_9_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getAlternatives_9_2_1()); }
	(rule__Statemachine__Alternatives_9_2_1)*
	{ after(grammarAccess.getStatemachineAccess().getAlternatives_9_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Statemachine__Group_9_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_9_3__0__Impl
	rule__Statemachine__Group_9_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_9_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getPrivateKeyword_9_3_0()); }
	'@private:'
	{ after(grammarAccess.getStatemachineAccess().getPrivateKeyword_9_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_9_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_9_3__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_9_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getAlternatives_9_3_1()); }
	(rule__Statemachine__Alternatives_9_3_1)*
	{ after(grammarAccess.getStatemachineAccess().getAlternatives_9_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Statemachine__Group_10_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_10_0_0__0__Impl
	rule__Statemachine__Group_10_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_10_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getAlternatives_10_0_0_0()); }
	(rule__Statemachine__Alternatives_10_0_0_0)
	{ after(grammarAccess.getStatemachineAccess().getAlternatives_10_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_10_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_10_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_10_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getStatemachineAccess().getRoutineAssignment_10_0_0_1()); }
		(rule__Statemachine__RoutineAssignment_10_0_0_1)
		{ after(grammarAccess.getStatemachineAccess().getRoutineAssignment_10_0_0_1()); }
	)
	(
		{ before(grammarAccess.getStatemachineAccess().getRoutineAssignment_10_0_0_1()); }
		(rule__Statemachine__RoutineAssignment_10_0_0_1)*
		{ after(grammarAccess.getStatemachineAccess().getRoutineAssignment_10_0_0_1()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Statemachine__Group_10_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_10_0_1__0__Impl
	rule__Statemachine__Group_10_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_10_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getProcedureKeyword_10_0_1_0()); }
	'@procedure:'
	{ after(grammarAccess.getStatemachineAccess().getProcedureKeyword_10_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_10_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_10_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_10_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getStatemachineAccess().getProcedureAssignment_10_0_1_1()); }
		(rule__Statemachine__ProcedureAssignment_10_0_1_1)
		{ after(grammarAccess.getStatemachineAccess().getProcedureAssignment_10_0_1_1()); }
	)
	(
		{ before(grammarAccess.getStatemachineAccess().getProcedureAssignment_10_0_1_1()); }
		(rule__Statemachine__ProcedureAssignment_10_0_1_1)*
		{ after(grammarAccess.getStatemachineAccess().getProcedureAssignment_10_0_1_1()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Statemachine__Group_11_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_11_0__0__Impl
	rule__Statemachine__Group_11_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_11_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineAccess().getAlternatives_11_0_0()); }
	(rule__Statemachine__Alternatives_11_0_0)
	{ after(grammarAccess.getStatemachineAccess().getAlternatives_11_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_11_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Statemachine__Group_11_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Statemachine__Group_11_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getStatemachineAccess().getMachineAssignment_11_0_1()); }
		(rule__Statemachine__MachineAssignment_11_0_1)
		{ after(grammarAccess.getStatemachineAccess().getMachineAssignment_11_0_1()); }
	)
	(
		{ before(grammarAccess.getStatemachineAccess().getMachineAssignment_11_0_1()); }
		(rule__Statemachine__MachineAssignment_11_0_1)*
		{ after(grammarAccess.getStatemachineAccess().getMachineAssignment_11_0_1()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}


rule__StatemachineRegion__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StatemachineRegion__Group__0__Impl
	rule__StatemachineRegion__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__StatemachineRegion__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineRegionAccess().getRegionAction_0()); }
	()
	{ after(grammarAccess.getStatemachineRegionAccess().getRegionAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StatemachineRegion__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StatemachineRegion__Group__1__Impl
	rule__StatemachineRegion__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__StatemachineRegion__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineRegionAccess().getAlternatives_1()); }
	(rule__StatemachineRegion__Alternatives_1)
	{ after(grammarAccess.getStatemachineRegionAccess().getAlternatives_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StatemachineRegion__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StatemachineRegion__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__StatemachineRegion__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getStatemachineRegionAccess().getAlternatives_2()); }
		(rule__StatemachineRegion__Alternatives_2)
		{ after(grammarAccess.getStatemachineRegionAccess().getAlternatives_2()); }
	)
	(
		{ before(grammarAccess.getStatemachineRegionAccess().getAlternatives_2()); }
		(rule__StatemachineRegion__Alternatives_2)*
		{ after(grammarAccess.getStatemachineRegionAccess().getAlternatives_2()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}


rule__StatemachineRegion__Group_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StatemachineRegion__Group_1_1__0__Impl
	rule__StatemachineRegion__Group_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__StatemachineRegion__Group_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineRegionAccess().getRegionKeyword_1_1_0()); }
	'@region<'
	{ after(grammarAccess.getStatemachineRegionAccess().getRegionKeyword_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StatemachineRegion__Group_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StatemachineRegion__Group_1_1__1__Impl
	rule__StatemachineRegion__Group_1_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__StatemachineRegion__Group_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineRegionAccess().getNameAssignment_1_1_1()); }
	(rule__StatemachineRegion__NameAssignment_1_1_1)
	{ after(grammarAccess.getStatemachineRegionAccess().getNameAssignment_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StatemachineRegion__Group_1_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StatemachineRegion__Group_1_1__2__Impl
	rule__StatemachineRegion__Group_1_1__3
;
finally {
	restoreStackSize(stackSize);
}

rule__StatemachineRegion__Group_1_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineRegionAccess().getUnrestrictedNameAssignment_1_1_2()); }
	(rule__StatemachineRegion__UnrestrictedNameAssignment_1_1_2)?
	{ after(grammarAccess.getStatemachineRegionAccess().getUnrestrictedNameAssignment_1_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StatemachineRegion__Group_1_1__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StatemachineRegion__Group_1_1__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__StatemachineRegion__Group_1_1__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStatemachineRegionAccess().getGreaterThanSignColonKeyword_1_1_3()); }
	'>:'
	{ after(grammarAccess.getStatemachineRegionAccess().getGreaterThanSignColonKeyword_1_1_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__CompositeState__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CompositeState__Group__0__Impl
	rule__CompositeState__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCompositeStateAccess().getStateAction_0()); }
	()
	{ after(grammarAccess.getCompositeStateAccess().getStateAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CompositeState__Group__1__Impl
	rule__CompositeState__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCompositeStateAccess().getCompositeAssignment_1()); }
	(rule__CompositeState__CompositeAssignment_1)
	{ after(grammarAccess.getCompositeStateAccess().getCompositeAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CompositeState__Group__2__Impl
	rule__CompositeState__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCompositeStateAccess().getLessThanSignKeyword_2()); }
	'<'
	{ after(grammarAccess.getCompositeStateAccess().getLessThanSignKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CompositeState__Group__3__Impl
	rule__CompositeState__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCompositeStateAccess().getMocKeyword_3()); }
	('moc:')?
	{ after(grammarAccess.getCompositeStateAccess().getMocKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CompositeState__Group__4__Impl
	rule__CompositeState__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCompositeStateAccess().getAlternatives_4()); }
	(rule__CompositeState__Alternatives_4)
	{ after(grammarAccess.getCompositeStateAccess().getAlternatives_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CompositeState__Group__5__Impl
	rule__CompositeState__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCompositeStateAccess().getGreaterThanSignKeyword_5()); }
	'>'
	{ after(grammarAccess.getCompositeStateAccess().getGreaterThanSignKeyword_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CompositeState__Group__6__Impl
	rule__CompositeState__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCompositeStateAccess().getNameAssignment_6()); }
	(rule__CompositeState__NameAssignment_6)
	{ after(grammarAccess.getCompositeStateAccess().getNameAssignment_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CompositeState__Group__7__Impl
	rule__CompositeState__Group__8
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCompositeStateAccess().getUnrestrictedNameAssignment_7()); }
	(rule__CompositeState__UnrestrictedNameAssignment_7)?
	{ after(grammarAccess.getCompositeStateAccess().getUnrestrictedNameAssignment_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Group__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CompositeState__Group__8__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Group__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCompositeStateAccess().getAlternatives_8()); }
	(rule__CompositeState__Alternatives_8)
	{ after(grammarAccess.getCompositeStateAccess().getAlternatives_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__CompositeState__Group_8_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CompositeState__Group_8_0__0__Impl
	rule__CompositeState__Group_8_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Group_8_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCompositeStateAccess().getLeftCurlyBracketKeyword_8_0_0()); }
	'{'
	{ after(grammarAccess.getCompositeStateAccess().getLeftCurlyBracketKeyword_8_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Group_8_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CompositeState__Group_8_0__1__Impl
	rule__CompositeState__Group_8_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Group_8_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCompositeStateAccess().getAlternatives_8_0_1()); }
	(rule__CompositeState__Alternatives_8_0_1)
	{ after(grammarAccess.getCompositeStateAccess().getAlternatives_8_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Group_8_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CompositeState__Group_8_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Group_8_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCompositeStateAccess().getRightCurlyBracketKeyword_8_0_2()); }
	'}'
	{ after(grammarAccess.getCompositeStateAccess().getRightCurlyBracketKeyword_8_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__CompositeState__Group_8_0_1_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CompositeState__Group_8_0_1_0_1__0__Impl
	rule__CompositeState__Group_8_0_1_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Group_8_0_1_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCompositeStateAccess().getMoeKeyword_8_0_1_0_1_0()); }
	'@moe:'
	{ after(grammarAccess.getCompositeStateAccess().getMoeKeyword_8_0_1_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Group_8_0_1_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CompositeState__Group_8_0_1_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Group_8_0_1_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCompositeStateAccess().getMoeAssignment_8_0_1_0_1_1()); }
	(rule__CompositeState__MoeAssignment_8_0_1_0_1_1)*
	{ after(grammarAccess.getCompositeStateAccess().getMoeAssignment_8_0_1_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__CompositeState__Group_8_0_1_0_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CompositeState__Group_8_0_1_0_2__0__Impl
	rule__CompositeState__Group_8_0_1_0_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Group_8_0_1_0_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCompositeStateAccess().getTransitionKeyword_8_0_1_0_2_0()); }
	'@transition:'
	{ after(grammarAccess.getCompositeStateAccess().getTransitionKeyword_8_0_1_0_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Group_8_0_1_0_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CompositeState__Group_8_0_1_0_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Group_8_0_1_0_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCompositeStateAccess().getTransitionAssignment_8_0_1_0_2_1()); }
	(rule__CompositeState__TransitionAssignment_8_0_1_0_2_1)*
	{ after(grammarAccess.getCompositeStateAccess().getTransitionAssignment_8_0_1_0_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__CompositeState__Group_8_0_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CompositeState__Group_8_0_1_1__0__Impl
	rule__CompositeState__Group_8_0_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Group_8_0_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCompositeStateAccess().getRegionAssignment_8_0_1_1_0()); }
	(rule__CompositeState__RegionAssignment_8_0_1_1_0)
	{ after(grammarAccess.getCompositeStateAccess().getRegionAssignment_8_0_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Group_8_0_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CompositeState__Group_8_0_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__CompositeState__Group_8_0_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCompositeStateAccess().getAlternatives_8_0_1_1_1()); }
	(rule__CompositeState__Alternatives_8_0_1_1_1)*
	{ after(grammarAccess.getCompositeStateAccess().getAlternatives_8_0_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MoeCompositeStateRoutines__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MoeCompositeStateRoutines__Group__0__Impl
	rule__MoeCompositeStateRoutines__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeCompositeStateRoutines__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMoeCompositeStateRoutinesAccess().getRoutineAction_0()); }
	()
	{ after(grammarAccess.getMoeCompositeStateRoutinesAccess().getRoutineAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeCompositeStateRoutines__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MoeCompositeStateRoutines__Group__1__Impl
	rule__MoeCompositeStateRoutines__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeCompositeStateRoutines__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMoeCompositeStateRoutinesAccess().getNameAssignment_1()); }
	(rule__MoeCompositeStateRoutines__NameAssignment_1)
	{ after(grammarAccess.getMoeCompositeStateRoutinesAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeCompositeStateRoutines__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MoeCompositeStateRoutines__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeCompositeStateRoutines__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMoeCompositeStateRoutinesAccess().getBodyBlockAssignment_2()); }
	(rule__MoeCompositeStateRoutines__BodyBlockAssignment_2)
	{ after(grammarAccess.getMoeCompositeStateRoutinesAccess().getBodyBlockAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SimpleState__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleState__Group__0__Impl
	rule__SimpleState__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleState__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleStateAccess().getStateAction_0()); }
	()
	{ after(grammarAccess.getSimpleStateAccess().getStateAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleState__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleState__Group__1__Impl
	rule__SimpleState__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleState__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleStateAccess().getSimpleAssignment_1()); }
	(rule__SimpleState__SimpleAssignment_1)
	{ after(grammarAccess.getSimpleStateAccess().getSimpleAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleState__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleState__Group__2__Impl
	rule__SimpleState__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleState__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleStateAccess().getGroup_2()); }
	(rule__SimpleState__Group_2__0)?
	{ after(grammarAccess.getSimpleStateAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleState__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleState__Group__3__Impl
	rule__SimpleState__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleState__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleStateAccess().getNameAssignment_3()); }
	(rule__SimpleState__NameAssignment_3)
	{ after(grammarAccess.getSimpleStateAccess().getNameAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleState__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleState__Group__4__Impl
	rule__SimpleState__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleState__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleStateAccess().getUnrestrictedNameAssignment_4()); }
	(rule__SimpleState__UnrestrictedNameAssignment_4)?
	{ after(grammarAccess.getSimpleStateAccess().getUnrestrictedNameAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleState__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleState__Group__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleState__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleStateAccess().getAlternatives_5()); }
	(rule__SimpleState__Alternatives_5)
	{ after(grammarAccess.getSimpleStateAccess().getAlternatives_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SimpleState__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleState__Group_2__0__Impl
	rule__SimpleState__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleState__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleStateAccess().getLessThanSignKeyword_2_0()); }
	'<'
	{ after(grammarAccess.getSimpleStateAccess().getLessThanSignKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleState__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleState__Group_2__1__Impl
	rule__SimpleState__Group_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleState__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleStateAccess().getMocKeyword_2_1()); }
	('moc:')?
	{ after(grammarAccess.getSimpleStateAccess().getMocKeyword_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleState__Group_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleState__Group_2__2__Impl
	rule__SimpleState__Group_2__3
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleState__Group_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleStateAccess().getSimpleKeyword_2_2()); }
	'simple'
	{ after(grammarAccess.getSimpleStateAccess().getSimpleKeyword_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleState__Group_2__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleState__Group_2__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleState__Group_2__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleStateAccess().getGreaterThanSignKeyword_2_3()); }
	'>'
	{ after(grammarAccess.getSimpleStateAccess().getGreaterThanSignKeyword_2_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SimpleState__Group_5_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleState__Group_5_0__0__Impl
	rule__SimpleState__Group_5_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleState__Group_5_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleStateAccess().getLeftCurlyBracketKeyword_5_0_0()); }
	'{'
	{ after(grammarAccess.getSimpleStateAccess().getLeftCurlyBracketKeyword_5_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleState__Group_5_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleState__Group_5_0__1__Impl
	rule__SimpleState__Group_5_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleState__Group_5_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleStateAccess().getAlternatives_5_0_1()); }
	(rule__SimpleState__Alternatives_5_0_1)*
	{ after(grammarAccess.getSimpleStateAccess().getAlternatives_5_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleState__Group_5_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SimpleState__Group_5_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SimpleState__Group_5_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSimpleStateAccess().getRightCurlyBracketKeyword_5_0_2()); }
	'}'
	{ after(grammarAccess.getSimpleStateAccess().getRightCurlyBracketKeyword_5_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MoeSimpleStateRoutines__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MoeSimpleStateRoutines__Group__0__Impl
	rule__MoeSimpleStateRoutines__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeSimpleStateRoutines__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMoeSimpleStateRoutinesAccess().getRoutineAction_0()); }
	()
	{ after(grammarAccess.getMoeSimpleStateRoutinesAccess().getRoutineAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeSimpleStateRoutines__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MoeSimpleStateRoutines__Group__1__Impl
	rule__MoeSimpleStateRoutines__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeSimpleStateRoutines__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMoeSimpleStateRoutinesAccess().getNameAssignment_1()); }
	(rule__MoeSimpleStateRoutines__NameAssignment_1)
	{ after(grammarAccess.getMoeSimpleStateRoutinesAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeSimpleStateRoutines__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MoeSimpleStateRoutines__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeSimpleStateRoutines__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMoeSimpleStateRoutinesAccess().getBodyBlockAssignment_2()); }
	(rule__MoeSimpleStateRoutines__BodyBlockAssignment_2)
	{ after(grammarAccess.getMoeSimpleStateRoutinesAccess().getBodyBlockAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__StartState__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StartState__Group__0__Impl
	rule__StartState__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__StartState__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStartStateAccess().getStartStateAction_0()); }
	()
	{ after(grammarAccess.getStartStateAccess().getStartStateAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StartState__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StartState__Group__1__Impl
	rule__StartState__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__StartState__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStartStateAccess().getAlternatives_1()); }
	(rule__StartState__Alternatives_1)
	{ after(grammarAccess.getStartStateAccess().getAlternatives_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StartState__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StartState__Group__2__Impl
	rule__StartState__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__StartState__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStartStateAccess().getUnrestrictedNameAssignment_2()); }
	(rule__StartState__UnrestrictedNameAssignment_2)?
	{ after(grammarAccess.getStartStateAccess().getUnrestrictedNameAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StartState__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StartState__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__StartState__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStartStateAccess().getAlternatives_3()); }
	(rule__StartState__Alternatives_3)
	{ after(grammarAccess.getStartStateAccess().getAlternatives_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__StartState__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StartState__Group_1_0__0__Impl
	rule__StartState__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__StartState__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStartStateAccess().getSimpleAssignment_1_0_0()); }
	(rule__StartState__SimpleAssignment_1_0_0)
	{ after(grammarAccess.getStartStateAccess().getSimpleAssignment_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StartState__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StartState__Group_1_0__1__Impl
	rule__StartState__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__StartState__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStartStateAccess().getLessThanSignKeyword_1_0_1()); }
	'<'
	{ after(grammarAccess.getStartStateAccess().getLessThanSignKeyword_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StartState__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StartState__Group_1_0__2__Impl
	rule__StartState__Group_1_0__3
;
finally {
	restoreStackSize(stackSize);
}

rule__StartState__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStartStateAccess().getMocKeyword_1_0_2()); }
	('moc:')?
	{ after(grammarAccess.getStartStateAccess().getMocKeyword_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StartState__Group_1_0__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StartState__Group_1_0__3__Impl
	rule__StartState__Group_1_0__4
;
finally {
	restoreStackSize(stackSize);
}

rule__StartState__Group_1_0__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStartStateAccess().getStartKeyword_1_0_3()); }
	'start'
	{ after(grammarAccess.getStartStateAccess().getStartKeyword_1_0_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StartState__Group_1_0__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StartState__Group_1_0__4__Impl
	rule__StartState__Group_1_0__5
;
finally {
	restoreStackSize(stackSize);
}

rule__StartState__Group_1_0__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStartStateAccess().getGreaterThanSignKeyword_1_0_4()); }
	'>'
	{ after(grammarAccess.getStartStateAccess().getGreaterThanSignKeyword_1_0_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StartState__Group_1_0__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StartState__Group_1_0__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__StartState__Group_1_0__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStartStateAccess().getNameAssignment_1_0_5()); }
	(rule__StartState__NameAssignment_1_0_5)
	{ after(grammarAccess.getStartStateAccess().getNameAssignment_1_0_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__StartState__Group_3_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StartState__Group_3_0__0__Impl
	rule__StartState__Group_3_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__StartState__Group_3_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStartStateAccess().getLeftCurlyBracketKeyword_3_0_0()); }
	'{'
	{ after(grammarAccess.getStartStateAccess().getLeftCurlyBracketKeyword_3_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StartState__Group_3_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StartState__Group_3_0__1__Impl
	rule__StartState__Group_3_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__StartState__Group_3_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStartStateAccess().getAlternatives_3_0_1()); }
	(rule__StartState__Alternatives_3_0_1)*
	{ after(grammarAccess.getStartStateAccess().getAlternatives_3_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StartState__Group_3_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StartState__Group_3_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__StartState__Group_3_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStartStateAccess().getRightCurlyBracketKeyword_3_0_2()); }
	'}'
	{ after(grammarAccess.getStartStateAccess().getRightCurlyBracketKeyword_3_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MoeStartStateRoutines__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MoeStartStateRoutines__Group__0__Impl
	rule__MoeStartStateRoutines__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeStartStateRoutines__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMoeStartStateRoutinesAccess().getRoutineAction_0()); }
	()
	{ after(grammarAccess.getMoeStartStateRoutinesAccess().getRoutineAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeStartStateRoutines__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MoeStartStateRoutines__Group__1__Impl
	rule__MoeStartStateRoutines__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeStartStateRoutines__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMoeStartStateRoutinesAccess().getNameAssignment_1()); }
	(rule__MoeStartStateRoutines__NameAssignment_1)
	{ after(grammarAccess.getMoeStartStateRoutinesAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeStartStateRoutines__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MoeStartStateRoutines__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeStartStateRoutines__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMoeStartStateRoutinesAccess().getBodyBlockAssignment_2()); }
	(rule__MoeStartStateRoutines__BodyBlockAssignment_2)
	{ after(grammarAccess.getMoeStartStateRoutinesAccess().getBodyBlockAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FinalState__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FinalState__Group__0__Impl
	rule__FinalState__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FinalState__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFinalStateAccess().getFinalStateAction_0()); }
	()
	{ after(grammarAccess.getFinalStateAccess().getFinalStateAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FinalState__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FinalState__Group__1__Impl
	rule__FinalState__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__FinalState__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFinalStateAccess().getAlternatives_1()); }
	(rule__FinalState__Alternatives_1)
	{ after(grammarAccess.getFinalStateAccess().getAlternatives_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FinalState__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FinalState__Group__2__Impl
	rule__FinalState__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__FinalState__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFinalStateAccess().getUnrestrictedNameAssignment_2()); }
	(rule__FinalState__UnrestrictedNameAssignment_2)?
	{ after(grammarAccess.getFinalStateAccess().getUnrestrictedNameAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FinalState__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FinalState__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FinalState__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFinalStateAccess().getAlternatives_3()); }
	(rule__FinalState__Alternatives_3)
	{ after(grammarAccess.getFinalStateAccess().getAlternatives_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FinalState__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FinalState__Group_1_0__0__Impl
	rule__FinalState__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FinalState__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFinalStateAccess().getSimpleAssignment_1_0_0()); }
	(rule__FinalState__SimpleAssignment_1_0_0)
	{ after(grammarAccess.getFinalStateAccess().getSimpleAssignment_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FinalState__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FinalState__Group_1_0__1__Impl
	rule__FinalState__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__FinalState__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFinalStateAccess().getLessThanSignKeyword_1_0_1()); }
	'<'
	{ after(grammarAccess.getFinalStateAccess().getLessThanSignKeyword_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FinalState__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FinalState__Group_1_0__2__Impl
	rule__FinalState__Group_1_0__3
;
finally {
	restoreStackSize(stackSize);
}

rule__FinalState__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFinalStateAccess().getMocKeyword_1_0_2()); }
	('moc:')?
	{ after(grammarAccess.getFinalStateAccess().getMocKeyword_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FinalState__Group_1_0__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FinalState__Group_1_0__3__Impl
	rule__FinalState__Group_1_0__4
;
finally {
	restoreStackSize(stackSize);
}

rule__FinalState__Group_1_0__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFinalStateAccess().getFinalKeyword_1_0_3()); }
	'final'
	{ after(grammarAccess.getFinalStateAccess().getFinalKeyword_1_0_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FinalState__Group_1_0__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FinalState__Group_1_0__4__Impl
	rule__FinalState__Group_1_0__5
;
finally {
	restoreStackSize(stackSize);
}

rule__FinalState__Group_1_0__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFinalStateAccess().getGreaterThanSignKeyword_1_0_4()); }
	'>'
	{ after(grammarAccess.getFinalStateAccess().getGreaterThanSignKeyword_1_0_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FinalState__Group_1_0__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FinalState__Group_1_0__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FinalState__Group_1_0__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFinalStateAccess().getNameAssignment_1_0_5()); }
	(rule__FinalState__NameAssignment_1_0_5)
	{ after(grammarAccess.getFinalStateAccess().getNameAssignment_1_0_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FinalState__Group_3_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FinalState__Group_3_0__0__Impl
	rule__FinalState__Group_3_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FinalState__Group_3_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFinalStateAccess().getLeftCurlyBracketKeyword_3_0_0()); }
	'{'
	{ after(grammarAccess.getFinalStateAccess().getLeftCurlyBracketKeyword_3_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FinalState__Group_3_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FinalState__Group_3_0__1__Impl
	rule__FinalState__Group_3_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__FinalState__Group_3_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFinalStateAccess().getMoeAssignment_3_0_1()); }
	(rule__FinalState__MoeAssignment_3_0_1)*
	{ after(grammarAccess.getFinalStateAccess().getMoeAssignment_3_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FinalState__Group_3_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FinalState__Group_3_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FinalState__Group_3_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFinalStateAccess().getRightCurlyBracketKeyword_3_0_2()); }
	'}'
	{ after(grammarAccess.getFinalStateAccess().getRightCurlyBracketKeyword_3_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MoeFinalStateRoutines__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MoeFinalStateRoutines__Group__0__Impl
	rule__MoeFinalStateRoutines__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeFinalStateRoutines__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMoeFinalStateRoutinesAccess().getRoutineAction_0()); }
	()
	{ after(grammarAccess.getMoeFinalStateRoutinesAccess().getRoutineAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeFinalStateRoutines__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MoeFinalStateRoutines__Group__1__Impl
	rule__MoeFinalStateRoutines__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeFinalStateRoutines__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMoeFinalStateRoutinesAccess().getNameAssignment_1()); }
	(rule__MoeFinalStateRoutines__NameAssignment_1)
	{ after(grammarAccess.getMoeFinalStateRoutinesAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeFinalStateRoutines__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MoeFinalStateRoutines__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeFinalStateRoutines__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMoeFinalStateRoutinesAccess().getBodyBlockAssignment_2()); }
	(rule__MoeFinalStateRoutines__BodyBlockAssignment_2)
	{ after(grammarAccess.getMoeFinalStateRoutinesAccess().getBodyBlockAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__OtherPseudostate__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherPseudostate__Group__0__Impl
	rule__OtherPseudostate__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherPseudostate__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherPseudostateAccess().getPseudostateAction_0()); }
	()
	{ after(grammarAccess.getOtherPseudostateAccess().getPseudostateAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherPseudostate__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherPseudostate__Group__1__Impl
	rule__OtherPseudostate__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherPseudostate__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherPseudostateAccess().getAlternatives_1()); }
	(rule__OtherPseudostate__Alternatives_1)
	{ after(grammarAccess.getOtherPseudostateAccess().getAlternatives_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherPseudostate__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherPseudostate__Group__2__Impl
	rule__OtherPseudostate__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherPseudostate__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherPseudostateAccess().getLessThanSignKeyword_2()); }
	'<'
	{ after(grammarAccess.getOtherPseudostateAccess().getLessThanSignKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherPseudostate__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherPseudostate__Group__3__Impl
	rule__OtherPseudostate__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherPseudostate__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherPseudostateAccess().getMocKeyword_3()); }
	('moc:')?
	{ after(grammarAccess.getOtherPseudostateAccess().getMocKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherPseudostate__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherPseudostate__Group__4__Impl
	rule__OtherPseudostate__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherPseudostate__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherPseudostateAccess().getKindAssignment_4()); }
	(rule__OtherPseudostate__KindAssignment_4)
	{ after(grammarAccess.getOtherPseudostateAccess().getKindAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherPseudostate__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherPseudostate__Group__5__Impl
	rule__OtherPseudostate__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherPseudostate__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherPseudostateAccess().getGreaterThanSignKeyword_5()); }
	'>'
	{ after(grammarAccess.getOtherPseudostateAccess().getGreaterThanSignKeyword_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherPseudostate__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherPseudostate__Group__6__Impl
	rule__OtherPseudostate__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherPseudostate__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherPseudostateAccess().getNameAssignment_6()); }
	(rule__OtherPseudostate__NameAssignment_6)
	{ after(grammarAccess.getOtherPseudostateAccess().getNameAssignment_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherPseudostate__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherPseudostate__Group__7__Impl
	rule__OtherPseudostate__Group__8
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherPseudostate__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherPseudostateAccess().getUnrestrictedNameAssignment_7()); }
	(rule__OtherPseudostate__UnrestrictedNameAssignment_7)?
	{ after(grammarAccess.getOtherPseudostateAccess().getUnrestrictedNameAssignment_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherPseudostate__Group__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherPseudostate__Group__8__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherPseudostate__Group__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherPseudostateAccess().getAlternatives_8()); }
	(rule__OtherPseudostate__Alternatives_8)
	{ after(grammarAccess.getOtherPseudostateAccess().getAlternatives_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__OtherPseudostate__Group_8_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherPseudostate__Group_8_0__0__Impl
	rule__OtherPseudostate__Group_8_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherPseudostate__Group_8_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherPseudostateAccess().getLeftCurlyBracketKeyword_8_0_0()); }
	'{'
	{ after(grammarAccess.getOtherPseudostateAccess().getLeftCurlyBracketKeyword_8_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherPseudostate__Group_8_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherPseudostate__Group_8_0__1__Impl
	rule__OtherPseudostate__Group_8_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherPseudostate__Group_8_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherPseudostateAccess().getTransitionAssignment_8_0_1()); }
	(rule__OtherPseudostate__TransitionAssignment_8_0_1)*
	{ after(grammarAccess.getOtherPseudostateAccess().getTransitionAssignment_8_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherPseudostate__Group_8_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherPseudostate__Group_8_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherPseudostate__Group_8_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherPseudostateAccess().getRightCurlyBracketKeyword_8_0_2()); }
	'}'
	{ after(grammarAccess.getOtherPseudostateAccess().getRightCurlyBracketKeyword_8_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PseudostateInitial__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PseudostateInitial__Group__0__Impl
	rule__PseudostateInitial__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PseudostateInitial__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPseudostateInitialAccess().getPseudostateAction_0()); }
	()
	{ after(grammarAccess.getPseudostateInitialAccess().getPseudostateAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PseudostateInitial__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PseudostateInitial__Group__1__Impl
	rule__PseudostateInitial__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PseudostateInitial__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPseudostateInitialAccess().getAlternatives_1()); }
	(rule__PseudostateInitial__Alternatives_1)
	{ after(grammarAccess.getPseudostateInitialAccess().getAlternatives_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PseudostateInitial__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PseudostateInitial__Group__2__Impl
	rule__PseudostateInitial__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__PseudostateInitial__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPseudostateInitialAccess().getUnrestrictedNameAssignment_2()); }
	(rule__PseudostateInitial__UnrestrictedNameAssignment_2)?
	{ after(grammarAccess.getPseudostateInitialAccess().getUnrestrictedNameAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PseudostateInitial__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PseudostateInitial__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PseudostateInitial__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPseudostateInitialAccess().getAlternatives_3()); }
	(rule__PseudostateInitial__Alternatives_3)
	{ after(grammarAccess.getPseudostateInitialAccess().getAlternatives_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PseudostateInitial__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PseudostateInitial__Group_1_0__0__Impl
	rule__PseudostateInitial__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PseudostateInitial__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPseudostateInitialAccess().getAlternatives_1_0_0()); }
	(rule__PseudostateInitial__Alternatives_1_0_0)
	{ after(grammarAccess.getPseudostateInitialAccess().getAlternatives_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PseudostateInitial__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PseudostateInitial__Group_1_0__1__Impl
	rule__PseudostateInitial__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PseudostateInitial__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPseudostateInitialAccess().getLessThanSignKeyword_1_0_1()); }
	'<'
	{ after(grammarAccess.getPseudostateInitialAccess().getLessThanSignKeyword_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PseudostateInitial__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PseudostateInitial__Group_1_0__2__Impl
	rule__PseudostateInitial__Group_1_0__3
;
finally {
	restoreStackSize(stackSize);
}

rule__PseudostateInitial__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPseudostateInitialAccess().getMocKeyword_1_0_2()); }
	('moc:')?
	{ after(grammarAccess.getPseudostateInitialAccess().getMocKeyword_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PseudostateInitial__Group_1_0__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PseudostateInitial__Group_1_0__3__Impl
	rule__PseudostateInitial__Group_1_0__4
;
finally {
	restoreStackSize(stackSize);
}

rule__PseudostateInitial__Group_1_0__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPseudostateInitialAccess().getKindAssignment_1_0_3()); }
	(rule__PseudostateInitial__KindAssignment_1_0_3)
	{ after(grammarAccess.getPseudostateInitialAccess().getKindAssignment_1_0_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PseudostateInitial__Group_1_0__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PseudostateInitial__Group_1_0__4__Impl
	rule__PseudostateInitial__Group_1_0__5
;
finally {
	restoreStackSize(stackSize);
}

rule__PseudostateInitial__Group_1_0__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPseudostateInitialAccess().getGreaterThanSignKeyword_1_0_4()); }
	'>'
	{ after(grammarAccess.getPseudostateInitialAccess().getGreaterThanSignKeyword_1_0_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PseudostateInitial__Group_1_0__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PseudostateInitial__Group_1_0__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PseudostateInitial__Group_1_0__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPseudostateInitialAccess().getNameAssignment_1_0_5()); }
	(rule__PseudostateInitial__NameAssignment_1_0_5)
	{ after(grammarAccess.getPseudostateInitialAccess().getNameAssignment_1_0_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PseudostateInitial__Group_3_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PseudostateInitial__Group_3_0__0__Impl
	rule__PseudostateInitial__Group_3_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PseudostateInitial__Group_3_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPseudostateInitialAccess().getLeftCurlyBracketKeyword_3_0_0()); }
	'{'
	{ after(grammarAccess.getPseudostateInitialAccess().getLeftCurlyBracketKeyword_3_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PseudostateInitial__Group_3_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PseudostateInitial__Group_3_0__1__Impl
	rule__PseudostateInitial__Group_3_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PseudostateInitial__Group_3_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPseudostateInitialAccess().getTransitionAssignment_3_0_1()); }
	(rule__PseudostateInitial__TransitionAssignment_3_0_1)*
	{ after(grammarAccess.getPseudostateInitialAccess().getTransitionAssignment_3_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PseudostateInitial__Group_3_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PseudostateInitial__Group_3_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PseudostateInitial__Group_3_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPseudostateInitialAccess().getRightCurlyBracketKeyword_3_0_2()); }
	'}'
	{ after(grammarAccess.getPseudostateInitialAccess().getRightCurlyBracketKeyword_3_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__EndingPseudostate__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EndingPseudostate__Group__0__Impl
	rule__EndingPseudostate__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__EndingPseudostate__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEndingPseudostateAccess().getPseudostateAction_0()); }
	()
	{ after(grammarAccess.getEndingPseudostateAccess().getPseudostateAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EndingPseudostate__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EndingPseudostate__Group__1__Impl
	rule__EndingPseudostate__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__EndingPseudostate__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEndingPseudostateAccess().getAlternatives_1()); }
	(rule__EndingPseudostate__Alternatives_1)
	{ after(grammarAccess.getEndingPseudostateAccess().getAlternatives_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EndingPseudostate__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EndingPseudostate__Group__2__Impl
	rule__EndingPseudostate__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__EndingPseudostate__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEndingPseudostateAccess().getLessThanSignKeyword_2()); }
	'<'
	{ after(grammarAccess.getEndingPseudostateAccess().getLessThanSignKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EndingPseudostate__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EndingPseudostate__Group__3__Impl
	rule__EndingPseudostate__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__EndingPseudostate__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEndingPseudostateAccess().getMocKeyword_3()); }
	('moc:')?
	{ after(grammarAccess.getEndingPseudostateAccess().getMocKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EndingPseudostate__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EndingPseudostate__Group__4__Impl
	rule__EndingPseudostate__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__EndingPseudostate__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEndingPseudostateAccess().getKindAssignment_4()); }
	(rule__EndingPseudostate__KindAssignment_4)
	{ after(grammarAccess.getEndingPseudostateAccess().getKindAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EndingPseudostate__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EndingPseudostate__Group__5__Impl
	rule__EndingPseudostate__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__EndingPseudostate__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEndingPseudostateAccess().getGreaterThanSignKeyword_5()); }
	'>'
	{ after(grammarAccess.getEndingPseudostateAccess().getGreaterThanSignKeyword_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EndingPseudostate__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EndingPseudostate__Group__6__Impl
	rule__EndingPseudostate__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__EndingPseudostate__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEndingPseudostateAccess().getNameAssignment_6()); }
	(rule__EndingPseudostate__NameAssignment_6)
	{ after(grammarAccess.getEndingPseudostateAccess().getNameAssignment_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EndingPseudostate__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EndingPseudostate__Group__7__Impl
	rule__EndingPseudostate__Group__8
;
finally {
	restoreStackSize(stackSize);
}

rule__EndingPseudostate__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEndingPseudostateAccess().getUnrestrictedNameAssignment_7()); }
	(rule__EndingPseudostate__UnrestrictedNameAssignment_7)?
	{ after(grammarAccess.getEndingPseudostateAccess().getUnrestrictedNameAssignment_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EndingPseudostate__Group__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EndingPseudostate__Group__8__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__EndingPseudostate__Group__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEndingPseudostateAccess().getAlternatives_8()); }
	(rule__EndingPseudostate__Alternatives_8)
	{ after(grammarAccess.getEndingPseudostateAccess().getAlternatives_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__EndingPseudostate__Group_8_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EndingPseudostate__Group_8_0__0__Impl
	rule__EndingPseudostate__Group_8_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__EndingPseudostate__Group_8_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEndingPseudostateAccess().getLeftCurlyBracketKeyword_8_0_0()); }
	'{'
	{ after(grammarAccess.getEndingPseudostateAccess().getLeftCurlyBracketKeyword_8_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EndingPseudostate__Group_8_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EndingPseudostate__Group_8_0__1__Impl
	rule__EndingPseudostate__Group_8_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__EndingPseudostate__Group_8_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEndingPseudostateAccess().getMoeAssignment_8_0_1()); }
	(rule__EndingPseudostate__MoeAssignment_8_0_1)*
	{ after(grammarAccess.getEndingPseudostateAccess().getMoeAssignment_8_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EndingPseudostate__Group_8_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EndingPseudostate__Group_8_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__EndingPseudostate__Group_8_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEndingPseudostateAccess().getRightCurlyBracketKeyword_8_0_2()); }
	'}'
	{ after(grammarAccess.getEndingPseudostateAccess().getRightCurlyBracketKeyword_8_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ModelOfExecution__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ModelOfExecution__Group__0__Impl
	rule__ModelOfExecution__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfExecution__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getModelOfExecutionAccess().getModelOfExecutionAction_0()); }
	()
	{ after(grammarAccess.getModelOfExecutionAccess().getModelOfExecutionAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfExecution__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ModelOfExecution__Group__1__Impl
	rule__ModelOfExecution__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfExecution__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getModelOfExecutionAccess().getMoeKeyword_1()); }
	'@moe:'
	{ after(grammarAccess.getModelOfExecutionAccess().getMoeKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfExecution__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ModelOfExecution__Group__2__Impl
	rule__ModelOfExecution__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfExecution__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getModelOfExecutionAccess().getRoutineAssignment_2()); }
	(rule__ModelOfExecution__RoutineAssignment_2)*
	{ after(grammarAccess.getModelOfExecutionAccess().getRoutineAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfExecution__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ModelOfExecution__Group__3__Impl
	rule__ModelOfExecution__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfExecution__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getModelOfExecutionAccess().getUnorderedGroup_3()); }
	(rule__ModelOfExecution__UnorderedGroup_3)
	{ after(grammarAccess.getModelOfExecutionAccess().getUnorderedGroup_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfExecution__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ModelOfExecution__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfExecution__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getModelOfExecutionAccess().getRoutineAssignment_4()); }
	(rule__ModelOfExecution__RoutineAssignment_4)*
	{ after(grammarAccess.getModelOfExecutionAccess().getRoutineAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ModelOfExecution__Group_3_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ModelOfExecution__Group_3_0__0__Impl
	rule__ModelOfExecution__Group_3_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfExecution__Group_3_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getModelOfExecutionAccess().getInitKeyword_3_0_0()); }
	'@init'
	{ after(grammarAccess.getModelOfExecutionAccess().getInitKeyword_3_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfExecution__Group_3_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ModelOfExecution__Group_3_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfExecution__Group_3_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getModelOfExecutionAccess().getInitRoutineAssignment_3_0_1()); }
	(rule__ModelOfExecution__InitRoutineAssignment_3_0_1)
	{ after(grammarAccess.getModelOfExecutionAccess().getInitRoutineAssignment_3_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ModelOfExecution__Group_3_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ModelOfExecution__Group_3_1__0__Impl
	rule__ModelOfExecution__Group_3_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfExecution__Group_3_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getModelOfExecutionAccess().getFinalKeyword_3_1_0()); }
	'@final'
	{ after(grammarAccess.getModelOfExecutionAccess().getFinalKeyword_3_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfExecution__Group_3_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ModelOfExecution__Group_3_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfExecution__Group_3_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getModelOfExecutionAccess().getFinalRoutineAssignment_3_1_1()); }
	(rule__ModelOfExecution__FinalRoutineAssignment_3_1_1)
	{ after(grammarAccess.getModelOfExecutionAccess().getFinalRoutineAssignment_3_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ModelOfExecution__Group_3_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ModelOfExecution__Group_3_2__0__Impl
	rule__ModelOfExecution__Group_3_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfExecution__Group_3_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getModelOfExecutionAccess().getEnableKeyword_3_2_0()); }
	'@enable'
	{ after(grammarAccess.getModelOfExecutionAccess().getEnableKeyword_3_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfExecution__Group_3_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ModelOfExecution__Group_3_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfExecution__Group_3_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getModelOfExecutionAccess().getEnableRoutineAssignment_3_2_1()); }
	(rule__ModelOfExecution__EnableRoutineAssignment_3_2_1)
	{ after(grammarAccess.getModelOfExecutionAccess().getEnableRoutineAssignment_3_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ModelOfExecution__Group_3_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ModelOfExecution__Group_3_3__0__Impl
	rule__ModelOfExecution__Group_3_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfExecution__Group_3_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getModelOfExecutionAccess().getDisableKeyword_3_3_0()); }
	'@disable'
	{ after(grammarAccess.getModelOfExecutionAccess().getDisableKeyword_3_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfExecution__Group_3_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ModelOfExecution__Group_3_3__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfExecution__Group_3_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getModelOfExecutionAccess().getDisableRoutineAssignment_3_3_1()); }
	(rule__ModelOfExecution__DisableRoutineAssignment_3_3_1)
	{ after(grammarAccess.getModelOfExecutionAccess().getDisableRoutineAssignment_3_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ModelOfExecution__Group_3_4__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ModelOfExecution__Group_3_4__0__Impl
	rule__ModelOfExecution__Group_3_4__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfExecution__Group_3_4__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getModelOfExecutionAccess().getConcurrencyKeyword_3_4_0()); }
	'@concurrency'
	{ after(grammarAccess.getModelOfExecutionAccess().getConcurrencyKeyword_3_4_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfExecution__Group_3_4__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ModelOfExecution__Group_3_4__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfExecution__Group_3_4__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getModelOfExecutionAccess().getConcurrencyRoutineAssignment_3_4_1()); }
	(rule__ModelOfExecution__ConcurrencyRoutineAssignment_3_4_1)
	{ after(grammarAccess.getModelOfExecutionAccess().getConcurrencyRoutineAssignment_3_4_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ModelOfExecution__Group_3_5__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ModelOfExecution__Group_3_5__0__Impl
	rule__ModelOfExecution__Group_3_5__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfExecution__Group_3_5__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getModelOfExecutionAccess().getScheduleKeyword_3_5_0()); }
	'@schedule'
	{ after(grammarAccess.getModelOfExecutionAccess().getScheduleKeyword_3_5_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfExecution__Group_3_5__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ModelOfExecution__Group_3_5__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfExecution__Group_3_5__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getModelOfExecutionAccess().getScheduleRoutineAssignment_3_5_1()); }
	(rule__ModelOfExecution__ScheduleRoutineAssignment_3_5_1)
	{ after(grammarAccess.getModelOfExecutionAccess().getScheduleRoutineAssignment_3_5_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ModelOfExecution__Group_3_6__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ModelOfExecution__Group_3_6__0__Impl
	rule__ModelOfExecution__Group_3_6__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfExecution__Group_3_6__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getModelOfExecutionAccess().getIrunKeyword_3_6_0()); }
	'@irun'
	{ after(grammarAccess.getModelOfExecutionAccess().getIrunKeyword_3_6_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfExecution__Group_3_6__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ModelOfExecution__Group_3_6__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfExecution__Group_3_6__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getModelOfExecutionAccess().getIrunRoutineAssignment_3_6_1()); }
	(rule__ModelOfExecution__IrunRoutineAssignment_3_6_1)
	{ after(grammarAccess.getModelOfExecutionAccess().getIrunRoutineAssignment_3_6_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ModelOfExecution__Group_3_7__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ModelOfExecution__Group_3_7__0__Impl
	rule__ModelOfExecution__Group_3_7__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfExecution__Group_3_7__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getModelOfExecutionAccess().getRunKeyword_3_7_0()); }
	'@run'
	{ after(grammarAccess.getModelOfExecutionAccess().getRunKeyword_3_7_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfExecution__Group_3_7__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ModelOfExecution__Group_3_7__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfExecution__Group_3_7__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getModelOfExecutionAccess().getRunRoutineAssignment_3_7_1()); }
	(rule__ModelOfExecution__RunRoutineAssignment_3_7_1)
	{ after(grammarAccess.getModelOfExecutionAccess().getRunRoutineAssignment_3_7_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MoeRoutine__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MoeRoutine__Group__0__Impl
	rule__MoeRoutine__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeRoutine__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMoeRoutineAccess().getRoutineAction_0()); }
	()
	{ after(grammarAccess.getMoeRoutineAccess().getRoutineAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeRoutine__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MoeRoutine__Group__1__Impl
	rule__MoeRoutine__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeRoutine__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMoeRoutineAccess().getGroup_1()); }
	(rule__MoeRoutine__Group_1__0)?
	{ after(grammarAccess.getMoeRoutineAccess().getGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeRoutine__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MoeRoutine__Group__2__Impl
	rule__MoeRoutine__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeRoutine__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMoeRoutineAccess().getGroup_2()); }
	(rule__MoeRoutine__Group_2__0)?
	{ after(grammarAccess.getMoeRoutineAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeRoutine__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MoeRoutine__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeRoutine__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMoeRoutineAccess().getBodyBlockAssignment_3()); }
	(rule__MoeRoutine__BodyBlockAssignment_3)
	{ after(grammarAccess.getMoeRoutineAccess().getBodyBlockAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MoeRoutine__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MoeRoutine__Group_1__0__Impl
	rule__MoeRoutine__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeRoutine__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMoeRoutineAccess().getLeftParenthesisKeyword_1_0()); }
	'('
	{ after(grammarAccess.getMoeRoutineAccess().getLeftParenthesisKeyword_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeRoutine__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MoeRoutine__Group_1__1__Impl
	rule__MoeRoutine__Group_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeRoutine__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMoeRoutineAccess().getDomainAssignment_1_1()); }
	(rule__MoeRoutine__DomainAssignment_1_1)?
	{ after(grammarAccess.getMoeRoutineAccess().getDomainAssignment_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeRoutine__Group_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MoeRoutine__Group_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeRoutine__Group_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMoeRoutineAccess().getRightParenthesisKeyword_1_2()); }
	')'
	{ after(grammarAccess.getMoeRoutineAccess().getRightParenthesisKeyword_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MoeRoutine__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MoeRoutine__Group_2__0__Impl
	rule__MoeRoutine__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeRoutine__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMoeRoutineAccess().getHyphenMinusGreaterThanSignKeyword_2_0()); }
	'->'
	{ after(grammarAccess.getMoeRoutineAccess().getHyphenMinusGreaterThanSignKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeRoutine__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MoeRoutine__Group_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeRoutine__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMoeRoutineAccess().getAlternatives_2_1()); }
	(rule__MoeRoutine__Alternatives_2_1)
	{ after(grammarAccess.getMoeRoutineAccess().getAlternatives_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__MoeRoutine__Group_2_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MoeRoutine__Group_2_1_0__0__Impl
	rule__MoeRoutine__Group_2_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeRoutine__Group_2_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMoeRoutineAccess().getLeftParenthesisKeyword_2_1_0_0()); }
	'('
	{ after(grammarAccess.getMoeRoutineAccess().getLeftParenthesisKeyword_2_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeRoutine__Group_2_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MoeRoutine__Group_2_1_0__1__Impl
	rule__MoeRoutine__Group_2_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeRoutine__Group_2_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMoeRoutineAccess().getCodomainAssignment_2_1_0_1()); }
	(rule__MoeRoutine__CodomainAssignment_2_1_0_1)
	{ after(grammarAccess.getMoeRoutineAccess().getCodomainAssignment_2_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeRoutine__Group_2_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__MoeRoutine__Group_2_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__MoeRoutine__Group_2_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getMoeRoutineAccess().getRightParenthesisKeyword_2_1_0_2()); }
	')'
	{ after(grammarAccess.getMoeRoutineAccess().getRightParenthesisKeyword_2_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Routine__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Routine__Group__0__Impl
	rule__Routine__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Routine__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRoutineAccess().getVisibilityAssignment_0()); }
	(rule__Routine__VisibilityAssignment_0)?
	{ after(grammarAccess.getRoutineAccess().getVisibilityAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Routine__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Routine__Group__1__Impl
	rule__Routine__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Routine__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRoutineAccess().getMacroKeyword_1()); }
	('macro')?
	{ after(grammarAccess.getRoutineAccess().getMacroKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Routine__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Routine__Group__2__Impl
	rule__Routine__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Routine__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRoutineAccess().getRoutineKeyword_2()); }
	'routine'
	{ after(grammarAccess.getRoutineAccess().getRoutineKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Routine__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Routine__Group__3__Impl
	rule__Routine__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__Routine__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRoutineAccess().getNameAssignment_3()); }
	(rule__Routine__NameAssignment_3)
	{ after(grammarAccess.getRoutineAccess().getNameAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Routine__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Routine__Group__4__Impl
	rule__Routine__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__Routine__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRoutineAccess().getUnrestrictedNameAssignment_4()); }
	(rule__Routine__UnrestrictedNameAssignment_4)?
	{ after(grammarAccess.getRoutineAccess().getUnrestrictedNameAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Routine__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Routine__Group__5__Impl
	rule__Routine__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__Routine__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRoutineAccess().getGroup_5()); }
	(rule__Routine__Group_5__0)?
	{ after(grammarAccess.getRoutineAccess().getGroup_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Routine__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Routine__Group__6__Impl
	rule__Routine__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__Routine__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRoutineAccess().getGroup_6()); }
	(rule__Routine__Group_6__0)?
	{ after(grammarAccess.getRoutineAccess().getGroup_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Routine__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Routine__Group__7__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Routine__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRoutineAccess().getBodyBlockAssignment_7()); }
	(rule__Routine__BodyBlockAssignment_7)
	{ after(grammarAccess.getRoutineAccess().getBodyBlockAssignment_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Routine__Group_5__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Routine__Group_5__0__Impl
	rule__Routine__Group_5__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Routine__Group_5__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRoutineAccess().getLeftParenthesisKeyword_5_0()); }
	'('
	{ after(grammarAccess.getRoutineAccess().getLeftParenthesisKeyword_5_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Routine__Group_5__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Routine__Group_5__1__Impl
	rule__Routine__Group_5__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Routine__Group_5__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRoutineAccess().getDomainAssignment_5_1()); }
	(rule__Routine__DomainAssignment_5_1)?
	{ after(grammarAccess.getRoutineAccess().getDomainAssignment_5_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Routine__Group_5__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Routine__Group_5__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Routine__Group_5__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRoutineAccess().getRightParenthesisKeyword_5_2()); }
	')'
	{ after(grammarAccess.getRoutineAccess().getRightParenthesisKeyword_5_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Routine__Group_6__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Routine__Group_6__0__Impl
	rule__Routine__Group_6__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Routine__Group_6__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRoutineAccess().getHyphenMinusHyphenMinusGreaterThanSignKeyword_6_0()); }
	'-->'
	{ after(grammarAccess.getRoutineAccess().getHyphenMinusHyphenMinusGreaterThanSignKeyword_6_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Routine__Group_6__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Routine__Group_6__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Routine__Group_6__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRoutineAccess().getAlternatives_6_1()); }
	(rule__Routine__Alternatives_6_1)
	{ after(grammarAccess.getRoutineAccess().getAlternatives_6_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Routine__Group_6_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Routine__Group_6_1_0__0__Impl
	rule__Routine__Group_6_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Routine__Group_6_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRoutineAccess().getLeftParenthesisKeyword_6_1_0_0()); }
	'('
	{ after(grammarAccess.getRoutineAccess().getLeftParenthesisKeyword_6_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Routine__Group_6_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Routine__Group_6_1_0__1__Impl
	rule__Routine__Group_6_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Routine__Group_6_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRoutineAccess().getCodomainAssignment_6_1_0_1()); }
	(rule__Routine__CodomainAssignment_6_1_0_1)
	{ after(grammarAccess.getRoutineAccess().getCodomainAssignment_6_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Routine__Group_6_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Routine__Group_6_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Routine__Group_6_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRoutineAccess().getRightParenthesisKeyword_6_1_0_2()); }
	')'
	{ after(grammarAccess.getRoutineAccess().getRightParenthesisKeyword_6_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ModelOfInteraction__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ModelOfInteraction__Group__0__Impl
	rule__ModelOfInteraction__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfInteraction__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getModelOfInteractionAccess().getModelOfInteractionAction_0()); }
	()
	{ after(grammarAccess.getModelOfInteractionAccess().getModelOfInteractionAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfInteraction__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ModelOfInteraction__Group__1__Impl
	rule__ModelOfInteraction__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfInteraction__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getModelOfInteractionAccess().getComKeyword_1()); }
	'@com:'
	{ after(grammarAccess.getModelOfInteractionAccess().getComKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfInteraction__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ModelOfInteraction__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ModelOfInteraction__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getModelOfInteractionAccess().getAlternatives_2()); }
	(rule__ModelOfInteraction__Alternatives_2)*
	{ after(grammarAccess.getModelOfInteractionAccess().getAlternatives_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Route__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Route__Group__0__Impl
	rule__Route__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Route__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRouteAccess().getRouteAction_0()); }
	()
	{ after(grammarAccess.getRouteAccess().getRouteAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Route__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Route__Group__1__Impl
	rule__Route__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Route__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRouteAccess().getRouteKeyword_1()); }
	'route'
	{ after(grammarAccess.getRouteAccess().getRouteKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Route__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Route__Group__2__Impl
	rule__Route__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Route__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRouteAccess().getLessThanSignKeyword_2()); }
	'<'
	{ after(grammarAccess.getRouteAccess().getLessThanSignKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Route__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Route__Group__3__Impl
	rule__Route__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__Route__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRouteAccess().getProtocolAssignment_3()); }
	(rule__Route__ProtocolAssignment_3)
	{ after(grammarAccess.getRouteAccess().getProtocolAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Route__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Route__Group__4__Impl
	rule__Route__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__Route__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRouteAccess().getGreaterThanSignKeyword_4()); }
	'>'
	{ after(grammarAccess.getRouteAccess().getGreaterThanSignKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Route__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Route__Group__5__Impl
	rule__Route__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__Route__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRouteAccess().getGroup_5()); }
	(rule__Route__Group_5__0)?
	{ after(grammarAccess.getRouteAccess().getGroup_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Route__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Route__Group__6__Impl
	rule__Route__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__Route__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRouteAccess().getLeftSquareBracketKeyword_6()); }
	'['
	{ after(grammarAccess.getRouteAccess().getLeftSquareBracketKeyword_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Route__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Route__Group__7__Impl
	rule__Route__Group__8
;
finally {
	restoreStackSize(stackSize);
}

rule__Route__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRouteAccess().getAlternatives_7()); }
	(rule__Route__Alternatives_7)
	{ after(grammarAccess.getRouteAccess().getAlternatives_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Route__Group__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Route__Group__8__Impl
	rule__Route__Group__9
;
finally {
	restoreStackSize(stackSize);
}

rule__Route__Group__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRouteAccess().getRightSquareBracketKeyword_8()); }
	']'
	{ after(grammarAccess.getRouteAccess().getRightSquareBracketKeyword_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Route__Group__9
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Route__Group__9__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Route__Group__9__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRouteAccess().getSemicolonKeyword_9()); }
	';'
	{ after(grammarAccess.getRouteAccess().getSemicolonKeyword_9()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Route__Group_5__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Route__Group_5__0__Impl
	rule__Route__Group_5__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Route__Group_5__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRouteAccess().getNameAssignment_5_0()); }
	(rule__Route__NameAssignment_5_0)
	{ after(grammarAccess.getRouteAccess().getNameAssignment_5_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Route__Group_5__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Route__Group_5__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Route__Group_5__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRouteAccess().getUnrestrictedNameAssignment_5_1()); }
	(rule__Route__UnrestrictedNameAssignment_5_1)?
	{ after(grammarAccess.getRouteAccess().getUnrestrictedNameAssignment_5_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Route__Group_7_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Route__Group_7_1__0__Impl
	rule__Route__Group_7_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Route__Group_7_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRouteAccess().getSignalsAssignment_7_1_0()); }
	(rule__Route__SignalsAssignment_7_1_0)
	{ after(grammarAccess.getRouteAccess().getSignalsAssignment_7_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Route__Group_7_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Route__Group_7_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Route__Group_7_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRouteAccess().getGroup_7_1_1()); }
	(rule__Route__Group_7_1_1__0)*
	{ after(grammarAccess.getRouteAccess().getGroup_7_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Route__Group_7_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Route__Group_7_1_1__0__Impl
	rule__Route__Group_7_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Route__Group_7_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRouteAccess().getCommaKeyword_7_1_1_0()); }
	','
	{ after(grammarAccess.getRouteAccess().getCommaKeyword_7_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Route__Group_7_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Route__Group_7_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Route__Group_7_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getRouteAccess().getSignalsAssignment_7_1_1_1()); }
	(rule__Route__SignalsAssignment_7_1_1_1)
	{ after(grammarAccess.getRouteAccess().getSignalsAssignment_7_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ComRouteProtocol__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComRouteProtocol__Group_1__0__Impl
	rule__ComRouteProtocol__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ComRouteProtocol__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComRouteProtocolAccess().getProtocolAssignment_1_0()); }
	(rule__ComRouteProtocol__ProtocolAssignment_1_0)
	{ after(grammarAccess.getComRouteProtocolAccess().getProtocolAssignment_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComRouteProtocol__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComRouteProtocol__Group_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ComRouteProtocol__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComRouteProtocolAccess().getAlternatives_1_1()); }
	(rule__ComRouteProtocol__Alternatives_1_1)?
	{ after(grammarAccess.getComRouteProtocolAccess().getAlternatives_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ComRouteProtocol__Group_1_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComRouteProtocol__Group_1_1_0__0__Impl
	rule__ComRouteProtocol__Group_1_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ComRouteProtocol__Group_1_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComRouteProtocolAccess().getColonKeyword_1_1_0_0()); }
	':'
	{ after(grammarAccess.getComRouteProtocolAccess().getColonKeyword_1_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComRouteProtocol__Group_1_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComRouteProtocol__Group_1_1_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ComRouteProtocol__Group_1_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComRouteProtocolAccess().getAlternatives_1_1_0_1()); }
	(rule__ComRouteProtocol__Alternatives_1_1_0_1)
	{ after(grammarAccess.getComRouteProtocolAccess().getAlternatives_1_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ComRouteProtocol__Group_1_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComRouteProtocol__Group_1_1_1__0__Impl
	rule__ComRouteProtocol__Group_1_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ComRouteProtocol__Group_1_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComRouteProtocolAccess().getLessThanSignKeyword_1_1_1_0()); }
	'<'
	{ after(grammarAccess.getComRouteProtocolAccess().getLessThanSignKeyword_1_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComRouteProtocol__Group_1_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComRouteProtocol__Group_1_1_1__1__Impl
	rule__ComRouteProtocol__Group_1_1_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ComRouteProtocol__Group_1_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComRouteProtocolAccess().getAlternatives_1_1_1_1()); }
	(rule__ComRouteProtocol__Alternatives_1_1_1_1)
	{ after(grammarAccess.getComRouteProtocolAccess().getAlternatives_1_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComRouteProtocol__Group_1_1_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComRouteProtocol__Group_1_1_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ComRouteProtocol__Group_1_1_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComRouteProtocolAccess().getGreaterThanSignKeyword_1_1_1_2()); }
	'>'
	{ after(grammarAccess.getComRouteProtocolAccess().getGreaterThanSignKeyword_1_1_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Connection__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Connection__Group__0__Impl
	rule__Connection__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Connection__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConnectionAccess().getAlternatives_0()); }
	(rule__Connection__Alternatives_0)
	{ after(grammarAccess.getConnectionAccess().getAlternatives_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Connection__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Connection__Group__1__Impl
	rule__Connection__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Connection__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConnectionAccess().getLessThanSignKeyword_1()); }
	'<'
	{ after(grammarAccess.getConnectionAccess().getLessThanSignKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Connection__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Connection__Group__2__Impl
	rule__Connection__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Connection__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConnectionAccess().getProtocolAssignment_2()); }
	(rule__Connection__ProtocolAssignment_2)
	{ after(grammarAccess.getConnectionAccess().getProtocolAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Connection__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Connection__Group__3__Impl
	rule__Connection__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__Connection__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConnectionAccess().getGreaterThanSignKeyword_3()); }
	'>'
	{ after(grammarAccess.getConnectionAccess().getGreaterThanSignKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Connection__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Connection__Group__4__Impl
	rule__Connection__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__Connection__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConnectionAccess().getGroup_4()); }
	(rule__Connection__Group_4__0)?
	{ after(grammarAccess.getConnectionAccess().getGroup_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Connection__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Connection__Group__5__Impl
	rule__Connection__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__Connection__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConnectionAccess().getLeftCurlyBracketKeyword_5()); }
	'{'
	{ after(grammarAccess.getConnectionAccess().getLeftCurlyBracketKeyword_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Connection__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Connection__Group__6__Impl
	rule__Connection__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__Connection__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getConnectionAccess().getComPointsAssignment_6()); }
		(rule__Connection__ComPointsAssignment_6)
		{ after(grammarAccess.getConnectionAccess().getComPointsAssignment_6()); }
	)
	(
		{ before(grammarAccess.getConnectionAccess().getComPointsAssignment_6()); }
		(rule__Connection__ComPointsAssignment_6)*
		{ after(grammarAccess.getConnectionAccess().getComPointsAssignment_6()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Connection__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Connection__Group__7__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Connection__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConnectionAccess().getRightCurlyBracketKeyword_7()); }
	'}'
	{ after(grammarAccess.getConnectionAccess().getRightCurlyBracketKeyword_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Connection__Group_4__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Connection__Group_4__0__Impl
	rule__Connection__Group_4__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Connection__Group_4__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConnectionAccess().getNameAssignment_4_0()); }
	(rule__Connection__NameAssignment_4_0)
	{ after(grammarAccess.getConnectionAccess().getNameAssignment_4_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Connection__Group_4__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Connection__Group_4__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Connection__Group_4__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getConnectionAccess().getUnrestrictedNameAssignment_4_1()); }
	(rule__Connection__UnrestrictedNameAssignment_4_1)?
	{ after(grammarAccess.getConnectionAccess().getUnrestrictedNameAssignment_4_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ComProtocol__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComProtocol__Group_1__0__Impl
	rule__ComProtocol__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ComProtocol__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComProtocolAccess().getProtocolAssignment_1_0()); }
	(rule__ComProtocol__ProtocolAssignment_1_0)
	{ after(grammarAccess.getComProtocolAccess().getProtocolAssignment_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComProtocol__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComProtocol__Group_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ComProtocol__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComProtocolAccess().getGroup_1_1()); }
	(rule__ComProtocol__Group_1_1__0)?
	{ after(grammarAccess.getComProtocolAccess().getGroup_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ComProtocol__Group_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComProtocol__Group_1_1__0__Impl
	rule__ComProtocol__Group_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ComProtocol__Group_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComProtocolAccess().getLessThanSignKeyword_1_1_0()); }
	'<'
	{ after(grammarAccess.getComProtocolAccess().getLessThanSignKeyword_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComProtocol__Group_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComProtocol__Group_1_1__1__Impl
	rule__ComProtocol__Group_1_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ComProtocol__Group_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComProtocolAccess().getCastAssignment_1_1_1()); }
	(rule__ComProtocol__CastAssignment_1_1_1)
	{ after(grammarAccess.getComProtocolAccess().getCastAssignment_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComProtocol__Group_1_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComProtocol__Group_1_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ComProtocol__Group_1_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComProtocolAccess().getGreaterThanSignKeyword_1_1_2()); }
	'>'
	{ after(grammarAccess.getComProtocolAccess().getGreaterThanSignKeyword_1_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ComProtocol__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComProtocol__Group_2__0__Impl
	rule__ComProtocol__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ComProtocol__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComProtocolAccess().getProtocolAssignment_2_0()); }
	(rule__ComProtocol__ProtocolAssignment_2_0)
	{ after(grammarAccess.getComProtocolAccess().getProtocolAssignment_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComProtocol__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComProtocol__Group_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ComProtocol__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComProtocolAccess().getAlternatives_2_1()); }
	(rule__ComProtocol__Alternatives_2_1)?
	{ after(grammarAccess.getComProtocolAccess().getAlternatives_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ComProtocol__Group_2_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComProtocol__Group_2_1_0__0__Impl
	rule__ComProtocol__Group_2_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ComProtocol__Group_2_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComProtocolAccess().getColonKeyword_2_1_0_0()); }
	':'
	{ after(grammarAccess.getComProtocolAccess().getColonKeyword_2_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComProtocol__Group_2_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComProtocol__Group_2_1_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ComProtocol__Group_2_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComProtocolAccess().getAlternatives_2_1_0_1()); }
	(rule__ComProtocol__Alternatives_2_1_0_1)
	{ after(grammarAccess.getComProtocolAccess().getAlternatives_2_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ComProtocol__Group_2_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComProtocol__Group_2_1_1__0__Impl
	rule__ComProtocol__Group_2_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ComProtocol__Group_2_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComProtocolAccess().getLessThanSignKeyword_2_1_1_0()); }
	'<'
	{ after(grammarAccess.getComProtocolAccess().getLessThanSignKeyword_2_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComProtocol__Group_2_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComProtocol__Group_2_1_1__1__Impl
	rule__ComProtocol__Group_2_1_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ComProtocol__Group_2_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComProtocolAccess().getAlternatives_2_1_1_1()); }
	(rule__ComProtocol__Alternatives_2_1_1_1)
	{ after(grammarAccess.getComProtocolAccess().getAlternatives_2_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComProtocol__Group_2_1_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComProtocol__Group_2_1_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ComProtocol__Group_2_1_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComProtocolAccess().getGreaterThanSignKeyword_2_1_1_2()); }
	'>'
	{ after(grammarAccess.getComProtocolAccess().getGreaterThanSignKeyword_2_1_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ComPoint__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComPoint__Group__0__Impl
	rule__ComPoint__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPoint__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComPointAccess().getComPointAction_0()); }
	()
	{ after(grammarAccess.getComPointAccess().getComPointAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPoint__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComPoint__Group__1__Impl
	rule__ComPoint__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPoint__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComPointAccess().getDirectionAssignment_1()); }
	(rule__ComPoint__DirectionAssignment_1)
	{ after(grammarAccess.getComPointAccess().getDirectionAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPoint__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComPoint__Group__2__Impl
	rule__ComPoint__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPoint__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComPointAccess().getGroup_2()); }
	(rule__ComPoint__Group_2__0)?
	{ after(grammarAccess.getComPointAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPoint__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComPoint__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPoint__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComPointAccess().getAlternatives_3()); }
	(rule__ComPoint__Alternatives_3)
	{ after(grammarAccess.getComPointAccess().getAlternatives_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ComPoint__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComPoint__Group_2__0__Impl
	rule__ComPoint__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPoint__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComPointAccess().getLessThanSignKeyword_2_0()); }
	'<'
	{ after(grammarAccess.getComPointAccess().getLessThanSignKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPoint__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComPoint__Group_2__1__Impl
	rule__ComPoint__Group_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPoint__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComPointAccess().getProtocolAssignment_2_1()); }
	(rule__ComPoint__ProtocolAssignment_2_1)
	{ after(grammarAccess.getComPointAccess().getProtocolAssignment_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPoint__Group_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComPoint__Group_2__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPoint__Group_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComPointAccess().getGreaterThanSignKeyword_2_2()); }
	'>'
	{ after(grammarAccess.getComPointAccess().getGreaterThanSignKeyword_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ComPoint__Group_3_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComPoint__Group_3_0__0__Impl
	rule__ComPoint__Group_3_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPoint__Group_3_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComPointAccess().getPointAssignment_3_0_0()); }
	(rule__ComPoint__PointAssignment_3_0_0)
	{ after(grammarAccess.getComPointAccess().getPointAssignment_3_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPoint__Group_3_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComPoint__Group_3_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPoint__Group_3_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComPointAccess().getSemicolonKeyword_3_0_1()); }
	';'
	{ after(grammarAccess.getComPointAccess().getSemicolonKeyword_3_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ComPoint__Group_3_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComPoint__Group_3_1__0__Impl
	rule__ComPoint__Group_3_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPoint__Group_3_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComPointAccess().getLeftCurlyBracketKeyword_3_1_0()); }
	'{'
	{ after(grammarAccess.getComPointAccess().getLeftCurlyBracketKeyword_3_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPoint__Group_3_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComPoint__Group_3_1__1__Impl
	rule__ComPoint__Group_3_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPoint__Group_3_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComPointAccess().getPointsAssignment_3_1_1()); }
	(rule__ComPoint__PointsAssignment_3_1_1)
	{ after(grammarAccess.getComPointAccess().getPointsAssignment_3_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPoint__Group_3_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComPoint__Group_3_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPoint__Group_3_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComPointAccess().getRightCurlyBracketKeyword_3_1_2()); }
	'}'
	{ after(grammarAccess.getComPointAccess().getRightCurlyBracketKeyword_3_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ComPointProtocol__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComPointProtocol__Group_0__0__Impl
	rule__ComPointProtocol__Group_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPointProtocol__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComPointProtocolAccess().getProtocolAssignment_0_0()); }
	(rule__ComPointProtocol__ProtocolAssignment_0_0)
	{ after(grammarAccess.getComPointProtocolAccess().getProtocolAssignment_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPointProtocol__Group_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComPointProtocol__Group_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPointProtocol__Group_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComPointProtocolAccess().getAlternatives_0_1()); }
	(rule__ComPointProtocol__Alternatives_0_1)?
	{ after(grammarAccess.getComPointProtocolAccess().getAlternatives_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ComPointProtocol__Group_0_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComPointProtocol__Group_0_1_0__0__Impl
	rule__ComPointProtocol__Group_0_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPointProtocol__Group_0_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComPointProtocolAccess().getColonKeyword_0_1_0_0()); }
	':'
	{ after(grammarAccess.getComPointProtocolAccess().getColonKeyword_0_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPointProtocol__Group_0_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComPointProtocol__Group_0_1_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPointProtocol__Group_0_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComPointProtocolAccess().getAlternatives_0_1_0_1()); }
	(rule__ComPointProtocol__Alternatives_0_1_0_1)
	{ after(grammarAccess.getComPointProtocolAccess().getAlternatives_0_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ComPointProtocol__Group_0_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComPointProtocol__Group_0_1_1__0__Impl
	rule__ComPointProtocol__Group_0_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPointProtocol__Group_0_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComPointProtocolAccess().getLessThanSignKeyword_0_1_1_0()); }
	'<'
	{ after(grammarAccess.getComPointProtocolAccess().getLessThanSignKeyword_0_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPointProtocol__Group_0_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComPointProtocol__Group_0_1_1__1__Impl
	rule__ComPointProtocol__Group_0_1_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPointProtocol__Group_0_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComPointProtocolAccess().getAlternatives_0_1_1_1()); }
	(rule__ComPointProtocol__Alternatives_0_1_1_1)
	{ after(grammarAccess.getComPointProtocolAccess().getAlternatives_0_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPointProtocol__Group_0_1_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComPointProtocol__Group_0_1_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ComPointProtocol__Group_0_1_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComPointProtocolAccess().getGreaterThanSignKeyword_0_1_1_2()); }
	'>'
	{ after(grammarAccess.getComPointProtocolAccess().getGreaterThanSignKeyword_0_1_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ComBuffer__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComBuffer__Group__0__Impl
	rule__ComBuffer__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ComBuffer__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComBufferAccess().getGroup_0()); }
	(rule__ComBuffer__Group_0__0)?
	{ after(grammarAccess.getComBufferAccess().getGroup_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComBuffer__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComBuffer__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ComBuffer__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComBufferAccess().getElementAssignment_1()); }
	(rule__ComBuffer__ElementAssignment_1)
	{ after(grammarAccess.getComBufferAccess().getElementAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ComBuffer__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComBuffer__Group_0__0__Impl
	rule__ComBuffer__Group_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ComBuffer__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComBufferAccess().getTargetAssignment_0_0()); }
	(rule__ComBuffer__TargetAssignment_0_0)
	{ after(grammarAccess.getComBufferAccess().getTargetAssignment_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComBuffer__Group_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComBuffer__Group_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ComBuffer__Group_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComBufferAccess().getKindAssignment_0_1()); }
	(rule__ComBuffer__KindAssignment_0_1)
	{ after(grammarAccess.getComBufferAccess().getKindAssignment_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ComElement__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComElement__Group__0__Impl
	rule__ComElement__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ComElement__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComElementAccess().getGroup_0()); }
	(rule__ComElement__Group_0__0)?
	{ after(grammarAccess.getComElementAccess().getGroup_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComElement__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComElement__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ComElement__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComElementAccess().getElementAssignment_1()); }
	(rule__ComElement__ElementAssignment_1)
	{ after(grammarAccess.getComElementAccess().getElementAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ComElement__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComElement__Group_0__0__Impl
	rule__ComElement__Group_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ComElement__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComElementAccess().getTargetAssignment_0_0()); }
	(rule__ComElement__TargetAssignment_0_0)
	{ after(grammarAccess.getComElementAccess().getTargetAssignment_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ComElement__Group_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ComElement__Group_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ComElement__Group_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getComElementAccess().getKindAssignment_0_1()); }
	(rule__ComElement__KindAssignment_0_1)
	{ after(grammarAccess.getComElementAccess().getKindAssignment_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__LiteralPureReferenceMachine__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LiteralPureReferenceMachine__Group_0__0__Impl
	rule__LiteralPureReferenceMachine__Group_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__LiteralPureReferenceMachine__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLiteralPureReferenceMachineAccess().getLiteralReferenceElementAction_0_0()); }
	()
	{ after(grammarAccess.getLiteralPureReferenceMachineAccess().getLiteralReferenceElementAction_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__LiteralPureReferenceMachine__Group_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__LiteralPureReferenceMachine__Group_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__LiteralPureReferenceMachine__Group_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getLiteralPureReferenceMachineAccess().getValueAssignment_0_1()); }
	(rule__LiteralPureReferenceMachine__ValueAssignment_0_1)
	{ after(grammarAccess.getLiteralPureReferenceMachineAccess().getValueAssignment_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__DataTypeReference__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DataTypeReference__Group_0__0__Impl
	rule__DataTypeReference__Group_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__DataTypeReference__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDataTypeReferenceAccess().getSimpleDataTypeParserRuleCall_0_0()); }
	ruleSimpleDataType
	{ after(grammarAccess.getDataTypeReferenceAccess().getSimpleDataTypeParserRuleCall_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DataTypeReference__Group_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DataTypeReference__Group_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__DataTypeReference__Group_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDataTypeReferenceAccess().getGroup_0_1()); }
	(rule__DataTypeReference__Group_0_1__0)?
	{ after(grammarAccess.getDataTypeReferenceAccess().getGroup_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__DataTypeReference__Group_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DataTypeReference__Group_0_1__0__Impl
	rule__DataTypeReference__Group_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__DataTypeReference__Group_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDataTypeReferenceAccess().getDataTypeReferenceSupportAction_0_1_0()); }
	()
	{ after(grammarAccess.getDataTypeReferenceAccess().getDataTypeReferenceSupportAction_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DataTypeReference__Group_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DataTypeReference__Group_0_1__1__Impl
	rule__DataTypeReference__Group_0_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__DataTypeReference__Group_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDataTypeReferenceAccess().getLeftSquareBracketKeyword_0_1_1()); }
	'['
	{ after(grammarAccess.getDataTypeReferenceAccess().getLeftSquareBracketKeyword_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DataTypeReference__Group_0_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DataTypeReference__Group_0_1__2__Impl
	rule__DataTypeReference__Group_0_1__3
;
finally {
	restoreStackSize(stackSize);
}

rule__DataTypeReference__Group_0_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDataTypeReferenceAccess().getMultiplicityAssignment_0_1_2()); }
	(rule__DataTypeReference__MultiplicityAssignment_0_1_2)
	{ after(grammarAccess.getDataTypeReferenceAccess().getMultiplicityAssignment_0_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DataTypeReference__Group_0_1__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DataTypeReference__Group_0_1__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__DataTypeReference__Group_0_1__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDataTypeReferenceAccess().getRightSquareBracketKeyword_0_1_3()); }
	']'
	{ after(grammarAccess.getDataTypeReferenceAccess().getRightSquareBracketKeyword_0_1_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__DataTypeReference__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DataTypeReference__Group_1__0__Impl
	rule__DataTypeReference__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__DataTypeReference__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDataTypeReferenceAccess().getDataTypeReferenceAction_1_0()); }
	()
	{ after(grammarAccess.getDataTypeReferenceAccess().getDataTypeReferenceAction_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DataTypeReference__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DataTypeReference__Group_1__1__Impl
	rule__DataTypeReference__Group_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__DataTypeReference__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDataTypeReferenceAccess().getTyperefAssignment_1_1()); }
	(rule__DataTypeReference__TyperefAssignment_1_1)
	{ after(grammarAccess.getDataTypeReferenceAccess().getTyperefAssignment_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DataTypeReference__Group_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DataTypeReference__Group_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__DataTypeReference__Group_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDataTypeReferenceAccess().getGroup_1_2()); }
	(rule__DataTypeReference__Group_1_2__0)?
	{ after(grammarAccess.getDataTypeReferenceAccess().getGroup_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__DataTypeReference__Group_1_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DataTypeReference__Group_1_2__0__Impl
	rule__DataTypeReference__Group_1_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__DataTypeReference__Group_1_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDataTypeReferenceAccess().getLeftSquareBracketKeyword_1_2_0()); }
	'['
	{ after(grammarAccess.getDataTypeReferenceAccess().getLeftSquareBracketKeyword_1_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DataTypeReference__Group_1_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DataTypeReference__Group_1_2__1__Impl
	rule__DataTypeReference__Group_1_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__DataTypeReference__Group_1_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDataTypeReferenceAccess().getMultiplicityAssignment_1_2_1()); }
	(rule__DataTypeReference__MultiplicityAssignment_1_2_1)
	{ after(grammarAccess.getDataTypeReferenceAccess().getMultiplicityAssignment_1_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__DataTypeReference__Group_1_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__DataTypeReference__Group_1_2__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__DataTypeReference__Group_1_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getDataTypeReferenceAccess().getRightSquareBracketKeyword_1_2_2()); }
	']'
	{ after(grammarAccess.getDataTypeReferenceAccess().getRightSquareBracketKeyword_1_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__OtherDataTypeDefinition__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherDataTypeDefinition__Group__0__Impl
	rule__OtherDataTypeDefinition__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinition__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherDataTypeDefinitionAccess().getDataTypeReferenceAction_0()); }
	()
	{ after(grammarAccess.getOtherDataTypeDefinitionAccess().getDataTypeReferenceAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinition__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherDataTypeDefinition__Group__1__Impl
	rule__OtherDataTypeDefinition__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinition__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherDataTypeDefinitionAccess().getVisibilityAssignment_1()); }
	(rule__OtherDataTypeDefinition__VisibilityAssignment_1)?
	{ after(grammarAccess.getOtherDataTypeDefinitionAccess().getVisibilityAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinition__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherDataTypeDefinition__Group__2__Impl
	rule__OtherDataTypeDefinition__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinition__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherDataTypeDefinitionAccess().getTypeKeyword_2()); }
	'type'
	{ after(grammarAccess.getOtherDataTypeDefinitionAccess().getTypeKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinition__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherDataTypeDefinition__Group__3__Impl
	rule__OtherDataTypeDefinition__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinition__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherDataTypeDefinitionAccess().getNameAssignment_3()); }
	(rule__OtherDataTypeDefinition__NameAssignment_3)
	{ after(grammarAccess.getOtherDataTypeDefinitionAccess().getNameAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinition__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherDataTypeDefinition__Group__4__Impl
	rule__OtherDataTypeDefinition__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinition__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherDataTypeDefinitionAccess().getUnrestrictedNameAssignment_4()); }
	(rule__OtherDataTypeDefinition__UnrestrictedNameAssignment_4)?
	{ after(grammarAccess.getOtherDataTypeDefinitionAccess().getUnrestrictedNameAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinition__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherDataTypeDefinition__Group__5__Impl
	rule__OtherDataTypeDefinition__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinition__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherDataTypeDefinitionAccess().getAlternatives_5()); }
	(rule__OtherDataTypeDefinition__Alternatives_5)
	{ after(grammarAccess.getOtherDataTypeDefinitionAccess().getAlternatives_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinition__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherDataTypeDefinition__Group__6__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinition__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherDataTypeDefinitionAccess().getTypedefAssignment_6()); }
	(rule__OtherDataTypeDefinition__TypedefAssignment_6)
	{ after(grammarAccess.getOtherDataTypeDefinitionAccess().getTypedefAssignment_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__OtherDataTypeDefinition__Group_5_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherDataTypeDefinition__Group_5_0__0__Impl
	rule__OtherDataTypeDefinition__Group_5_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinition__Group_5_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherDataTypeDefinitionAccess().getSupportAssignment_5_0_0()); }
	(rule__OtherDataTypeDefinition__SupportAssignment_5_0_0)
	{ after(grammarAccess.getOtherDataTypeDefinitionAccess().getSupportAssignment_5_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinition__Group_5_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherDataTypeDefinition__Group_5_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinition__Group_5_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherDataTypeDefinitionAccess().getGroup_5_0_1()); }
	(rule__OtherDataTypeDefinition__Group_5_0_1__0)?
	{ after(grammarAccess.getOtherDataTypeDefinitionAccess().getGroup_5_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__OtherDataTypeDefinition__Group_5_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherDataTypeDefinition__Group_5_0_1__0__Impl
	rule__OtherDataTypeDefinition__Group_5_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinition__Group_5_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherDataTypeDefinitionAccess().getLeftSquareBracketKeyword_5_0_1_0()); }
	'['
	{ after(grammarAccess.getOtherDataTypeDefinitionAccess().getLeftSquareBracketKeyword_5_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinition__Group_5_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherDataTypeDefinition__Group_5_0_1__1__Impl
	rule__OtherDataTypeDefinition__Group_5_0_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinition__Group_5_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherDataTypeDefinitionAccess().getMultiplicityAssignment_5_0_1_1()); }
	(rule__OtherDataTypeDefinition__MultiplicityAssignment_5_0_1_1)
	{ after(grammarAccess.getOtherDataTypeDefinitionAccess().getMultiplicityAssignment_5_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinition__Group_5_0_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherDataTypeDefinition__Group_5_0_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinition__Group_5_0_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherDataTypeDefinitionAccess().getRightSquareBracketKeyword_5_0_1_2()); }
	']'
	{ after(grammarAccess.getOtherDataTypeDefinitionAccess().getRightSquareBracketKeyword_5_0_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__OtherDataTypeDefinition__Group_5_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherDataTypeDefinition__Group_5_1__0__Impl
	rule__OtherDataTypeDefinition__Group_5_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinition__Group_5_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherDataTypeDefinitionAccess().getTyperefAssignment_5_1_0()); }
	(rule__OtherDataTypeDefinition__TyperefAssignment_5_1_0)
	{ after(grammarAccess.getOtherDataTypeDefinitionAccess().getTyperefAssignment_5_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinition__Group_5_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherDataTypeDefinition__Group_5_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinition__Group_5_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherDataTypeDefinitionAccess().getGroup_5_1_1()); }
	(rule__OtherDataTypeDefinition__Group_5_1_1__0)?
	{ after(grammarAccess.getOtherDataTypeDefinitionAccess().getGroup_5_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__OtherDataTypeDefinition__Group_5_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherDataTypeDefinition__Group_5_1_1__0__Impl
	rule__OtherDataTypeDefinition__Group_5_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinition__Group_5_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherDataTypeDefinitionAccess().getLeftSquareBracketKeyword_5_1_1_0()); }
	'['
	{ after(grammarAccess.getOtherDataTypeDefinitionAccess().getLeftSquareBracketKeyword_5_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinition__Group_5_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherDataTypeDefinition__Group_5_1_1__1__Impl
	rule__OtherDataTypeDefinition__Group_5_1_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinition__Group_5_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherDataTypeDefinitionAccess().getMultiplicityAssignment_5_1_1_1()); }
	(rule__OtherDataTypeDefinition__MultiplicityAssignment_5_1_1_1)
	{ after(grammarAccess.getOtherDataTypeDefinitionAccess().getMultiplicityAssignment_5_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinition__Group_5_1_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherDataTypeDefinition__Group_5_1_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinition__Group_5_1_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherDataTypeDefinitionAccess().getRightSquareBracketKeyword_5_1_1_2()); }
	']'
	{ after(grammarAccess.getOtherDataTypeDefinitionAccess().getRightSquareBracketKeyword_5_1_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__OtherDataTypeDefinitionImpl__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherDataTypeDefinitionImpl__Group__0__Impl
	rule__OtherDataTypeDefinitionImpl__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinitionImpl__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherDataTypeDefinitionImplAccess().getDataTypeReferenceAction_0()); }
	()
	{ after(grammarAccess.getOtherDataTypeDefinitionImplAccess().getDataTypeReferenceAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinitionImpl__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherDataTypeDefinitionImpl__Group__1__Impl
	rule__OtherDataTypeDefinitionImpl__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinitionImpl__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherDataTypeDefinitionImplAccess().getNameAssignment_1()); }
	(rule__OtherDataTypeDefinitionImpl__NameAssignment_1)
	{ after(grammarAccess.getOtherDataTypeDefinitionImplAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinitionImpl__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherDataTypeDefinitionImpl__Group__2__Impl
	rule__OtherDataTypeDefinitionImpl__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinitionImpl__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherDataTypeDefinitionImplAccess().getUnrestrictedNameAssignment_2()); }
	(rule__OtherDataTypeDefinitionImpl__UnrestrictedNameAssignment_2)?
	{ after(grammarAccess.getOtherDataTypeDefinitionImplAccess().getUnrestrictedNameAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinitionImpl__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherDataTypeDefinitionImpl__Group__3__Impl
	rule__OtherDataTypeDefinitionImpl__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinitionImpl__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherDataTypeDefinitionImplAccess().getAlternatives_3()); }
	(rule__OtherDataTypeDefinitionImpl__Alternatives_3)
	{ after(grammarAccess.getOtherDataTypeDefinitionImplAccess().getAlternatives_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinitionImpl__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherDataTypeDefinitionImpl__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinitionImpl__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherDataTypeDefinitionImplAccess().getTypedefAssignment_4()); }
	(rule__OtherDataTypeDefinitionImpl__TypedefAssignment_4)
	{ after(grammarAccess.getOtherDataTypeDefinitionImplAccess().getTypedefAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__OtherDataTypeDefinitionImpl__Group_3_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherDataTypeDefinitionImpl__Group_3_0__0__Impl
	rule__OtherDataTypeDefinitionImpl__Group_3_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinitionImpl__Group_3_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherDataTypeDefinitionImplAccess().getSupportAssignment_3_0_0()); }
	(rule__OtherDataTypeDefinitionImpl__SupportAssignment_3_0_0)
	{ after(grammarAccess.getOtherDataTypeDefinitionImplAccess().getSupportAssignment_3_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinitionImpl__Group_3_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherDataTypeDefinitionImpl__Group_3_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinitionImpl__Group_3_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherDataTypeDefinitionImplAccess().getGroup_3_0_1()); }
	(rule__OtherDataTypeDefinitionImpl__Group_3_0_1__0)?
	{ after(grammarAccess.getOtherDataTypeDefinitionImplAccess().getGroup_3_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__OtherDataTypeDefinitionImpl__Group_3_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherDataTypeDefinitionImpl__Group_3_0_1__0__Impl
	rule__OtherDataTypeDefinitionImpl__Group_3_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinitionImpl__Group_3_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherDataTypeDefinitionImplAccess().getLeftSquareBracketKeyword_3_0_1_0()); }
	'['
	{ after(grammarAccess.getOtherDataTypeDefinitionImplAccess().getLeftSquareBracketKeyword_3_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinitionImpl__Group_3_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherDataTypeDefinitionImpl__Group_3_0_1__1__Impl
	rule__OtherDataTypeDefinitionImpl__Group_3_0_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinitionImpl__Group_3_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherDataTypeDefinitionImplAccess().getMultiplicityAssignment_3_0_1_1()); }
	(rule__OtherDataTypeDefinitionImpl__MultiplicityAssignment_3_0_1_1)
	{ after(grammarAccess.getOtherDataTypeDefinitionImplAccess().getMultiplicityAssignment_3_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinitionImpl__Group_3_0_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherDataTypeDefinitionImpl__Group_3_0_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinitionImpl__Group_3_0_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherDataTypeDefinitionImplAccess().getRightSquareBracketKeyword_3_0_1_2()); }
	']'
	{ after(grammarAccess.getOtherDataTypeDefinitionImplAccess().getRightSquareBracketKeyword_3_0_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__OtherDataTypeDefinitionImpl__Group_3_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherDataTypeDefinitionImpl__Group_3_1__0__Impl
	rule__OtherDataTypeDefinitionImpl__Group_3_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinitionImpl__Group_3_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherDataTypeDefinitionImplAccess().getTyperefAssignment_3_1_0()); }
	(rule__OtherDataTypeDefinitionImpl__TyperefAssignment_3_1_0)
	{ after(grammarAccess.getOtherDataTypeDefinitionImplAccess().getTyperefAssignment_3_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinitionImpl__Group_3_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherDataTypeDefinitionImpl__Group_3_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinitionImpl__Group_3_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherDataTypeDefinitionImplAccess().getGroup_3_1_1()); }
	(rule__OtherDataTypeDefinitionImpl__Group_3_1_1__0)?
	{ after(grammarAccess.getOtherDataTypeDefinitionImplAccess().getGroup_3_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__OtherDataTypeDefinitionImpl__Group_3_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherDataTypeDefinitionImpl__Group_3_1_1__0__Impl
	rule__OtherDataTypeDefinitionImpl__Group_3_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinitionImpl__Group_3_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherDataTypeDefinitionImplAccess().getLeftSquareBracketKeyword_3_1_1_0()); }
	'['
	{ after(grammarAccess.getOtherDataTypeDefinitionImplAccess().getLeftSquareBracketKeyword_3_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinitionImpl__Group_3_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherDataTypeDefinitionImpl__Group_3_1_1__1__Impl
	rule__OtherDataTypeDefinitionImpl__Group_3_1_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinitionImpl__Group_3_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherDataTypeDefinitionImplAccess().getMultiplicityAssignment_3_1_1_1()); }
	(rule__OtherDataTypeDefinitionImpl__MultiplicityAssignment_3_1_1_1)
	{ after(grammarAccess.getOtherDataTypeDefinitionImplAccess().getMultiplicityAssignment_3_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinitionImpl__Group_3_1_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OtherDataTypeDefinitionImpl__Group_3_1_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__OtherDataTypeDefinitionImpl__Group_3_1_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOtherDataTypeDefinitionImplAccess().getRightSquareBracketKeyword_3_1_1_2()); }
	']'
	{ after(grammarAccess.getOtherDataTypeDefinitionImplAccess().getRightSquareBracketKeyword_3_1_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PrimitiveIntegerType__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveIntegerType__Group__0__Impl
	rule__PrimitiveIntegerType__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveIntegerType__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveIntegerTypeAccess().getPrimitiveIntegerTypeAction_0()); }
	()
	{ after(grammarAccess.getPrimitiveIntegerTypeAccess().getPrimitiveIntegerTypeAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveIntegerType__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveIntegerType__Group__1__Impl
	rule__PrimitiveIntegerType__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveIntegerType__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveIntegerTypeAccess().getSignAssignment_1()); }
	(rule__PrimitiveIntegerType__SignAssignment_1)?
	{ after(grammarAccess.getPrimitiveIntegerTypeAccess().getSignAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveIntegerType__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveIntegerType__Group__2__Impl
	rule__PrimitiveIntegerType__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveIntegerType__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveIntegerTypeAccess().getAlternatives_2()); }
	(rule__PrimitiveIntegerType__Alternatives_2)
	{ after(grammarAccess.getPrimitiveIntegerTypeAccess().getAlternatives_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveIntegerType__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveIntegerType__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveIntegerType__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveIntegerTypeAccess().getAlternatives_3()); }
	(rule__PrimitiveIntegerType__Alternatives_3)?
	{ after(grammarAccess.getPrimitiveIntegerTypeAccess().getAlternatives_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PrimitiveIntegerType__Group_3_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveIntegerType__Group_3_0__0__Impl
	rule__PrimitiveIntegerType__Group_3_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveIntegerType__Group_3_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveIntegerTypeAccess().getColonKeyword_3_0_0()); }
	':'
	{ after(grammarAccess.getPrimitiveIntegerTypeAccess().getColonKeyword_3_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveIntegerType__Group_3_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveIntegerType__Group_3_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveIntegerType__Group_3_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveIntegerTypeAccess().getSizeAssignment_3_0_1()); }
	(rule__PrimitiveIntegerType__SizeAssignment_3_0_1)
	{ after(grammarAccess.getPrimitiveIntegerTypeAccess().getSizeAssignment_3_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PrimitiveIntegerType__Group_3_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveIntegerType__Group_3_1__0__Impl
	rule__PrimitiveIntegerType__Group_3_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveIntegerType__Group_3_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveIntegerTypeAccess().getLessThanSignKeyword_3_1_0()); }
	'<'
	{ after(grammarAccess.getPrimitiveIntegerTypeAccess().getLessThanSignKeyword_3_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveIntegerType__Group_3_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveIntegerType__Group_3_1__1__Impl
	rule__PrimitiveIntegerType__Group_3_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveIntegerType__Group_3_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveIntegerTypeAccess().getSizeKeyword_3_1_1()); }
	('size:')?
	{ after(grammarAccess.getPrimitiveIntegerTypeAccess().getSizeKeyword_3_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveIntegerType__Group_3_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveIntegerType__Group_3_1__2__Impl
	rule__PrimitiveIntegerType__Group_3_1__3
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveIntegerType__Group_3_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveIntegerTypeAccess().getSizeAssignment_3_1_2()); }
	(rule__PrimitiveIntegerType__SizeAssignment_3_1_2)
	{ after(grammarAccess.getPrimitiveIntegerTypeAccess().getSizeAssignment_3_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveIntegerType__Group_3_1__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveIntegerType__Group_3_1__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveIntegerType__Group_3_1__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveIntegerTypeAccess().getGreaterThanSignKeyword_3_1_3()); }
	'>'
	{ after(grammarAccess.getPrimitiveIntegerTypeAccess().getGreaterThanSignKeyword_3_1_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PrimitiveRationalType__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveRationalType__Group__0__Impl
	rule__PrimitiveRationalType__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRationalType__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveRationalTypeAccess().getPrimitiveRationalTypeAction_0()); }
	()
	{ after(grammarAccess.getPrimitiveRationalTypeAccess().getPrimitiveRationalTypeAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRationalType__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveRationalType__Group__1__Impl
	rule__PrimitiveRationalType__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRationalType__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveRationalTypeAccess().getSignAssignment_1()); }
	(rule__PrimitiveRationalType__SignAssignment_1)?
	{ after(grammarAccess.getPrimitiveRationalTypeAccess().getSignAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRationalType__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveRationalType__Group__2__Impl
	rule__PrimitiveRationalType__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRationalType__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveRationalTypeAccess().getAlternatives_2()); }
	(rule__PrimitiveRationalType__Alternatives_2)
	{ after(grammarAccess.getPrimitiveRationalTypeAccess().getAlternatives_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRationalType__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveRationalType__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRationalType__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveRationalTypeAccess().getAlternatives_3()); }
	(rule__PrimitiveRationalType__Alternatives_3)?
	{ after(grammarAccess.getPrimitiveRationalTypeAccess().getAlternatives_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PrimitiveRationalType__Group_3_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveRationalType__Group_3_0__0__Impl
	rule__PrimitiveRationalType__Group_3_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRationalType__Group_3_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveRationalTypeAccess().getColonKeyword_3_0_0()); }
	':'
	{ after(grammarAccess.getPrimitiveRationalTypeAccess().getColonKeyword_3_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRationalType__Group_3_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveRationalType__Group_3_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRationalType__Group_3_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveRationalTypeAccess().getSizeAssignment_3_0_1()); }
	(rule__PrimitiveRationalType__SizeAssignment_3_0_1)
	{ after(grammarAccess.getPrimitiveRationalTypeAccess().getSizeAssignment_3_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PrimitiveRationalType__Group_3_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveRationalType__Group_3_1__0__Impl
	rule__PrimitiveRationalType__Group_3_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRationalType__Group_3_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveRationalTypeAccess().getLessThanSignKeyword_3_1_0()); }
	'<'
	{ after(grammarAccess.getPrimitiveRationalTypeAccess().getLessThanSignKeyword_3_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRationalType__Group_3_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveRationalType__Group_3_1__1__Impl
	rule__PrimitiveRationalType__Group_3_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRationalType__Group_3_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveRationalTypeAccess().getSizeKeyword_3_1_1()); }
	('size:')?
	{ after(grammarAccess.getPrimitiveRationalTypeAccess().getSizeKeyword_3_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRationalType__Group_3_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveRationalType__Group_3_1__2__Impl
	rule__PrimitiveRationalType__Group_3_1__3
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRationalType__Group_3_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveRationalTypeAccess().getSizeAssignment_3_1_2()); }
	(rule__PrimitiveRationalType__SizeAssignment_3_1_2)
	{ after(grammarAccess.getPrimitiveRationalTypeAccess().getSizeAssignment_3_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRationalType__Group_3_1__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveRationalType__Group_3_1__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRationalType__Group_3_1__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveRationalTypeAccess().getGreaterThanSignKeyword_3_1_3()); }
	'>'
	{ after(grammarAccess.getPrimitiveRationalTypeAccess().getGreaterThanSignKeyword_3_1_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PrimitiveFloatType__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveFloatType__Group__0__Impl
	rule__PrimitiveFloatType__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveFloatType__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveFloatTypeAccess().getPrimitiveFloatTypeAction_0()); }
	()
	{ after(grammarAccess.getPrimitiveFloatTypeAccess().getPrimitiveFloatTypeAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveFloatType__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveFloatType__Group__1__Impl
	rule__PrimitiveFloatType__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveFloatType__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveFloatTypeAccess().getSignAssignment_1()); }
	(rule__PrimitiveFloatType__SignAssignment_1)?
	{ after(grammarAccess.getPrimitiveFloatTypeAccess().getSignAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveFloatType__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveFloatType__Group__2__Impl
	rule__PrimitiveFloatType__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveFloatType__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveFloatTypeAccess().getAlternatives_2()); }
	(rule__PrimitiveFloatType__Alternatives_2)
	{ after(grammarAccess.getPrimitiveFloatTypeAccess().getAlternatives_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveFloatType__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveFloatType__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveFloatType__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveFloatTypeAccess().getAlternatives_3()); }
	(rule__PrimitiveFloatType__Alternatives_3)?
	{ after(grammarAccess.getPrimitiveFloatTypeAccess().getAlternatives_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PrimitiveFloatType__Group_3_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveFloatType__Group_3_0__0__Impl
	rule__PrimitiveFloatType__Group_3_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveFloatType__Group_3_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveFloatTypeAccess().getColonKeyword_3_0_0()); }
	':'
	{ after(grammarAccess.getPrimitiveFloatTypeAccess().getColonKeyword_3_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveFloatType__Group_3_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveFloatType__Group_3_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveFloatType__Group_3_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveFloatTypeAccess().getSizeAssignment_3_0_1()); }
	(rule__PrimitiveFloatType__SizeAssignment_3_0_1)
	{ after(grammarAccess.getPrimitiveFloatTypeAccess().getSizeAssignment_3_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PrimitiveFloatType__Group_3_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveFloatType__Group_3_1__0__Impl
	rule__PrimitiveFloatType__Group_3_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveFloatType__Group_3_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveFloatTypeAccess().getLessThanSignKeyword_3_1_0()); }
	'<'
	{ after(grammarAccess.getPrimitiveFloatTypeAccess().getLessThanSignKeyword_3_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveFloatType__Group_3_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveFloatType__Group_3_1__1__Impl
	rule__PrimitiveFloatType__Group_3_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveFloatType__Group_3_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveFloatTypeAccess().getSizeKeyword_3_1_1()); }
	('size:')?
	{ after(grammarAccess.getPrimitiveFloatTypeAccess().getSizeKeyword_3_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveFloatType__Group_3_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveFloatType__Group_3_1__2__Impl
	rule__PrimitiveFloatType__Group_3_1__3
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveFloatType__Group_3_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveFloatTypeAccess().getSizeAssignment_3_1_2()); }
	(rule__PrimitiveFloatType__SizeAssignment_3_1_2)
	{ after(grammarAccess.getPrimitiveFloatTypeAccess().getSizeAssignment_3_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveFloatType__Group_3_1__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveFloatType__Group_3_1__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveFloatType__Group_3_1__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveFloatTypeAccess().getGreaterThanSignKeyword_3_1_3()); }
	'>'
	{ after(grammarAccess.getPrimitiveFloatTypeAccess().getGreaterThanSignKeyword_3_1_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PrimitiveRealType__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveRealType__Group__0__Impl
	rule__PrimitiveRealType__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRealType__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveRealTypeAccess().getPrimitiveRealTypeAction_0()); }
	()
	{ after(grammarAccess.getPrimitiveRealTypeAccess().getPrimitiveRealTypeAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRealType__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveRealType__Group__1__Impl
	rule__PrimitiveRealType__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRealType__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveRealTypeAccess().getSignAssignment_1()); }
	(rule__PrimitiveRealType__SignAssignment_1)?
	{ after(grammarAccess.getPrimitiveRealTypeAccess().getSignAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRealType__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveRealType__Group__2__Impl
	rule__PrimitiveRealType__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRealType__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveRealTypeAccess().getAlternatives_2()); }
	(rule__PrimitiveRealType__Alternatives_2)
	{ after(grammarAccess.getPrimitiveRealTypeAccess().getAlternatives_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRealType__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveRealType__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRealType__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveRealTypeAccess().getAlternatives_3()); }
	(rule__PrimitiveRealType__Alternatives_3)?
	{ after(grammarAccess.getPrimitiveRealTypeAccess().getAlternatives_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PrimitiveRealType__Group_3_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveRealType__Group_3_0__0__Impl
	rule__PrimitiveRealType__Group_3_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRealType__Group_3_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveRealTypeAccess().getColonKeyword_3_0_0()); }
	':'
	{ after(grammarAccess.getPrimitiveRealTypeAccess().getColonKeyword_3_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRealType__Group_3_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveRealType__Group_3_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRealType__Group_3_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveRealTypeAccess().getSizeAssignment_3_0_1()); }
	(rule__PrimitiveRealType__SizeAssignment_3_0_1)
	{ after(grammarAccess.getPrimitiveRealTypeAccess().getSizeAssignment_3_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PrimitiveRealType__Group_3_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveRealType__Group_3_1__0__Impl
	rule__PrimitiveRealType__Group_3_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRealType__Group_3_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveRealTypeAccess().getLessThanSignKeyword_3_1_0()); }
	'<'
	{ after(grammarAccess.getPrimitiveRealTypeAccess().getLessThanSignKeyword_3_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRealType__Group_3_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveRealType__Group_3_1__1__Impl
	rule__PrimitiveRealType__Group_3_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRealType__Group_3_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveRealTypeAccess().getSizeKeyword_3_1_1()); }
	('size:')?
	{ after(grammarAccess.getPrimitiveRealTypeAccess().getSizeKeyword_3_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRealType__Group_3_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveRealType__Group_3_1__2__Impl
	rule__PrimitiveRealType__Group_3_1__3
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRealType__Group_3_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveRealTypeAccess().getSizeAssignment_3_1_2()); }
	(rule__PrimitiveRealType__SizeAssignment_3_1_2)
	{ after(grammarAccess.getPrimitiveRealTypeAccess().getSizeAssignment_3_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRealType__Group_3_1__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveRealType__Group_3_1__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveRealType__Group_3_1__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveRealTypeAccess().getGreaterThanSignKeyword_3_1_3()); }
	'>'
	{ after(grammarAccess.getPrimitiveRealTypeAccess().getGreaterThanSignKeyword_3_1_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PrimitiveTimeType__Group_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveTimeType__Group_0__0__Impl
	rule__PrimitiveTimeType__Group_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveTimeType__Group_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveTimeTypeAccess().getPrimitiveTimeTypeAction_0_0()); }
	()
	{ after(grammarAccess.getPrimitiveTimeTypeAccess().getPrimitiveTimeTypeAction_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveTimeType__Group_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveTimeType__Group_0__1__Impl
	rule__PrimitiveTimeType__Group_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveTimeType__Group_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveTimeTypeAccess().getTimeKeyword_0_1()); }
	'time'
	{ after(grammarAccess.getPrimitiveTimeTypeAccess().getTimeKeyword_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveTimeType__Group_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveTimeType__Group_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveTimeType__Group_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveTimeTypeAccess().getAlternatives_0_2()); }
	(rule__PrimitiveTimeType__Alternatives_0_2)?
	{ after(grammarAccess.getPrimitiveTimeTypeAccess().getAlternatives_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PrimitiveTimeType__Group_0_2_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveTimeType__Group_0_2_0__0__Impl
	rule__PrimitiveTimeType__Group_0_2_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveTimeType__Group_0_2_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveTimeTypeAccess().getLessThanSignKeyword_0_2_0_0()); }
	'<'
	{ after(grammarAccess.getPrimitiveTimeTypeAccess().getLessThanSignKeyword_0_2_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveTimeType__Group_0_2_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveTimeType__Group_0_2_0__1__Impl
	rule__PrimitiveTimeType__Group_0_2_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveTimeType__Group_0_2_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveTimeTypeAccess().getSupportAssignment_0_2_0_1()); }
	(rule__PrimitiveTimeType__SupportAssignment_0_2_0_1)
	{ after(grammarAccess.getPrimitiveTimeTypeAccess().getSupportAssignment_0_2_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveTimeType__Group_0_2_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveTimeType__Group_0_2_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveTimeType__Group_0_2_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveTimeTypeAccess().getGreaterThanSignKeyword_0_2_0_2()); }
	'>'
	{ after(grammarAccess.getPrimitiveTimeTypeAccess().getGreaterThanSignKeyword_0_2_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PrimitiveTimeType__Group_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveTimeType__Group_1__0__Impl
	rule__PrimitiveTimeType__Group_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveTimeType__Group_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveTimeTypeAccess().getPrimitiveTimeTypeAction_1_0()); }
	()
	{ after(grammarAccess.getPrimitiveTimeTypeAccess().getPrimitiveTimeTypeAction_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveTimeType__Group_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveTimeType__Group_1__1__Impl
	rule__PrimitiveTimeType__Group_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveTimeType__Group_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveTimeTypeAccess().getClockAssignment_1_1()); }
	(rule__PrimitiveTimeType__ClockAssignment_1_1)
	{ after(grammarAccess.getPrimitiveTimeTypeAccess().getClockAssignment_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveTimeType__Group_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveTimeType__Group_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveTimeType__Group_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveTimeTypeAccess().getAlternatives_1_2()); }
	(rule__PrimitiveTimeType__Alternatives_1_2)?
	{ after(grammarAccess.getPrimitiveTimeTypeAccess().getAlternatives_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PrimitiveTimeType__Group_1_2_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveTimeType__Group_1_2_0__0__Impl
	rule__PrimitiveTimeType__Group_1_2_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveTimeType__Group_1_2_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveTimeTypeAccess().getLessThanSignKeyword_1_2_0_0()); }
	'<'
	{ after(grammarAccess.getPrimitiveTimeTypeAccess().getLessThanSignKeyword_1_2_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveTimeType__Group_1_2_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveTimeType__Group_1_2_0__1__Impl
	rule__PrimitiveTimeType__Group_1_2_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveTimeType__Group_1_2_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveTimeTypeAccess().getSupportAssignment_1_2_0_1()); }
	(rule__PrimitiveTimeType__SupportAssignment_1_2_0_1)
	{ after(grammarAccess.getPrimitiveTimeTypeAccess().getSupportAssignment_1_2_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveTimeType__Group_1_2_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveTimeType__Group_1_2_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveTimeType__Group_1_2_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveTimeTypeAccess().getGreaterThanSignKeyword_1_2_0_2()); }
	'>'
	{ after(grammarAccess.getPrimitiveTimeTypeAccess().getGreaterThanSignKeyword_1_2_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PrimitiveBooleanType__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveBooleanType__Group__0__Impl
	rule__PrimitiveBooleanType__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveBooleanType__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveBooleanTypeAccess().getPrimitiveBooleanTypeAction_0()); }
	()
	{ after(grammarAccess.getPrimitiveBooleanTypeAccess().getPrimitiveBooleanTypeAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveBooleanType__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveBooleanType__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveBooleanType__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveBooleanTypeAccess().getAlternatives_1()); }
	(rule__PrimitiveBooleanType__Alternatives_1)
	{ after(grammarAccess.getPrimitiveBooleanTypeAccess().getAlternatives_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PrimitiveCharacterType__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveCharacterType__Group__0__Impl
	rule__PrimitiveCharacterType__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveCharacterType__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveCharacterTypeAccess().getPrimitiveCharacterTypeAction_0()); }
	()
	{ after(grammarAccess.getPrimitiveCharacterTypeAccess().getPrimitiveCharacterTypeAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveCharacterType__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveCharacterType__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveCharacterType__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveCharacterTypeAccess().getCharKeyword_1()); }
	'char'
	{ after(grammarAccess.getPrimitiveCharacterTypeAccess().getCharKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PrimitiveStringType__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveStringType__Group__0__Impl
	rule__PrimitiveStringType__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveStringType__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveStringTypeAccess().getPrimitiveStringTypeAction_0()); }
	()
	{ after(grammarAccess.getPrimitiveStringTypeAccess().getPrimitiveStringTypeAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveStringType__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveStringType__Group__1__Impl
	rule__PrimitiveStringType__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveStringType__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveStringTypeAccess().getStringKeyword_1()); }
	'string'
	{ after(grammarAccess.getPrimitiveStringTypeAccess().getStringKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveStringType__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveStringType__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveStringType__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveStringTypeAccess().getAlternatives_2()); }
	(rule__PrimitiveStringType__Alternatives_2)?
	{ after(grammarAccess.getPrimitiveStringTypeAccess().getAlternatives_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PrimitiveStringType__Group_2_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveStringType__Group_2_0__0__Impl
	rule__PrimitiveStringType__Group_2_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveStringType__Group_2_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveStringTypeAccess().getColonKeyword_2_0_0()); }
	':'
	{ after(grammarAccess.getPrimitiveStringTypeAccess().getColonKeyword_2_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveStringType__Group_2_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveStringType__Group_2_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveStringType__Group_2_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveStringTypeAccess().getSizeAssignment_2_0_1()); }
	(rule__PrimitiveStringType__SizeAssignment_2_0_1)
	{ after(grammarAccess.getPrimitiveStringTypeAccess().getSizeAssignment_2_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PrimitiveStringType__Group_2_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveStringType__Group_2_1__0__Impl
	rule__PrimitiveStringType__Group_2_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveStringType__Group_2_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveStringTypeAccess().getLessThanSignKeyword_2_1_0()); }
	'<'
	{ after(grammarAccess.getPrimitiveStringTypeAccess().getLessThanSignKeyword_2_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveStringType__Group_2_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveStringType__Group_2_1__1__Impl
	rule__PrimitiveStringType__Group_2_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveStringType__Group_2_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveStringTypeAccess().getSizeKeyword_2_1_1()); }
	('size:')?
	{ after(grammarAccess.getPrimitiveStringTypeAccess().getSizeKeyword_2_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveStringType__Group_2_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveStringType__Group_2_1__2__Impl
	rule__PrimitiveStringType__Group_2_1__3
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveStringType__Group_2_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveStringTypeAccess().getSizeAssignment_2_1_2()); }
	(rule__PrimitiveStringType__SizeAssignment_2_1_2)
	{ after(grammarAccess.getPrimitiveStringTypeAccess().getSizeAssignment_2_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveStringType__Group_2_1__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveStringType__Group_2_1__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveStringType__Group_2_1__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveStringTypeAccess().getGreaterThanSignKeyword_2_1_3()); }
	'>'
	{ after(grammarAccess.getPrimitiveStringTypeAccess().getGreaterThanSignKeyword_2_1_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PrimitiveInstanceType__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveInstanceType__Group__0__Impl
	rule__PrimitiveInstanceType__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveInstanceType__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveInstanceTypeAccess().getPrimitiveInstanceTypeAction_0()); }
	()
	{ after(grammarAccess.getPrimitiveInstanceTypeAccess().getPrimitiveInstanceTypeAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveInstanceType__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveInstanceType__Group__1__Impl
	rule__PrimitiveInstanceType__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveInstanceType__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveInstanceTypeAccess().getExpectedAssignment_1()); }
	(rule__PrimitiveInstanceType__ExpectedAssignment_1)
	{ after(grammarAccess.getPrimitiveInstanceTypeAccess().getExpectedAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveInstanceType__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveInstanceType__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveInstanceType__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveInstanceTypeAccess().getGroup_2()); }
	(rule__PrimitiveInstanceType__Group_2__0)?
	{ after(grammarAccess.getPrimitiveInstanceTypeAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PrimitiveInstanceType__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveInstanceType__Group_2__0__Impl
	rule__PrimitiveInstanceType__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveInstanceType__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveInstanceTypeAccess().getLessThanSignKeyword_2_0()); }
	'<'
	{ after(grammarAccess.getPrimitiveInstanceTypeAccess().getLessThanSignKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveInstanceType__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveInstanceType__Group_2__1__Impl
	rule__PrimitiveInstanceType__Group_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveInstanceType__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveInstanceTypeAccess().getModelAssignment_2_1()); }
	(rule__PrimitiveInstanceType__ModelAssignment_2_1)
	{ after(grammarAccess.getPrimitiveInstanceTypeAccess().getModelAssignment_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveInstanceType__Group_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PrimitiveInstanceType__Group_2__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PrimitiveInstanceType__Group_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPrimitiveInstanceTypeAccess().getGreaterThanSignKeyword_2_2()); }
	'>'
	{ after(grammarAccess.getPrimitiveInstanceTypeAccess().getGreaterThanSignKeyword_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__IntervalType__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalType__Group__0__Impl
	rule__IntervalType__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalType__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeAccess().getIntervalTypeAction_0()); }
	()
	{ after(grammarAccess.getIntervalTypeAccess().getIntervalTypeAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalType__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalType__Group__1__Impl
	rule__IntervalType__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalType__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeAccess().getIntervalKeyword_1()); }
	'interval'
	{ after(grammarAccess.getIntervalTypeAccess().getIntervalKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalType__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalType__Group__2__Impl
	rule__IntervalType__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalType__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeAccess().getLessThanSignKeyword_2()); }
	'<'
	{ after(grammarAccess.getIntervalTypeAccess().getLessThanSignKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalType__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalType__Group__3__Impl
	rule__IntervalType__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalType__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeAccess().getSupportAssignment_3()); }
	(rule__IntervalType__SupportAssignment_3)
	{ after(grammarAccess.getIntervalTypeAccess().getSupportAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalType__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalType__Group__4__Impl
	rule__IntervalType__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalType__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeAccess().getAlternatives_4()); }
	(rule__IntervalType__Alternatives_4)
	{ after(grammarAccess.getIntervalTypeAccess().getAlternatives_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalType__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalType__Group__5__Impl
	rule__IntervalType__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalType__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeAccess().getInfimumAssignment_5()); }
	(rule__IntervalType__InfimumAssignment_5)
	{ after(grammarAccess.getIntervalTypeAccess().getInfimumAssignment_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalType__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalType__Group__6__Impl
	rule__IntervalType__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalType__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeAccess().getCommaKeyword_6()); }
	','
	{ after(grammarAccess.getIntervalTypeAccess().getCommaKeyword_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalType__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalType__Group__7__Impl
	rule__IntervalType__Group__8
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalType__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeAccess().getSupremumAssignment_7()); }
	(rule__IntervalType__SupremumAssignment_7)
	{ after(grammarAccess.getIntervalTypeAccess().getSupremumAssignment_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalType__Group__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalType__Group__8__Impl
	rule__IntervalType__Group__9
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalType__Group__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeAccess().getAlternatives_8()); }
	(rule__IntervalType__Alternatives_8)
	{ after(grammarAccess.getIntervalTypeAccess().getAlternatives_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalType__Group__9
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalType__Group__9__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalType__Group__9__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeAccess().getGreaterThanSignKeyword_9()); }
	'>'
	{ after(grammarAccess.getIntervalTypeAccess().getGreaterThanSignKeyword_9()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__IntervalTypeDefinition__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalTypeDefinition__Group__0__Impl
	rule__IntervalTypeDefinition__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinition__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeDefinitionAccess().getIntervalTypeAction_0()); }
	()
	{ after(grammarAccess.getIntervalTypeDefinitionAccess().getIntervalTypeAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinition__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalTypeDefinition__Group__1__Impl
	rule__IntervalTypeDefinition__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinition__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeDefinitionAccess().getVisibilityAssignment_1()); }
	(rule__IntervalTypeDefinition__VisibilityAssignment_1)?
	{ after(grammarAccess.getIntervalTypeDefinitionAccess().getVisibilityAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinition__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalTypeDefinition__Group__2__Impl
	rule__IntervalTypeDefinition__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinition__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeDefinitionAccess().getTypeKeyword_2()); }
	'type'
	{ after(grammarAccess.getIntervalTypeDefinitionAccess().getTypeKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinition__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalTypeDefinition__Group__3__Impl
	rule__IntervalTypeDefinition__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinition__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeDefinitionAccess().getNameAssignment_3()); }
	(rule__IntervalTypeDefinition__NameAssignment_3)
	{ after(grammarAccess.getIntervalTypeDefinitionAccess().getNameAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinition__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalTypeDefinition__Group__4__Impl
	rule__IntervalTypeDefinition__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinition__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeDefinitionAccess().getUnrestrictedNameAssignment_4()); }
	(rule__IntervalTypeDefinition__UnrestrictedNameAssignment_4)?
	{ after(grammarAccess.getIntervalTypeDefinitionAccess().getUnrestrictedNameAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinition__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalTypeDefinition__Group__5__Impl
	rule__IntervalTypeDefinition__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinition__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeDefinitionAccess().getIntervalKeyword_5()); }
	'interval'
	{ after(grammarAccess.getIntervalTypeDefinitionAccess().getIntervalKeyword_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinition__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalTypeDefinition__Group__6__Impl
	rule__IntervalTypeDefinition__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinition__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeDefinitionAccess().getLessThanSignKeyword_6()); }
	'<'
	{ after(grammarAccess.getIntervalTypeDefinitionAccess().getLessThanSignKeyword_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinition__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalTypeDefinition__Group__7__Impl
	rule__IntervalTypeDefinition__Group__8
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinition__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeDefinitionAccess().getSupportAssignment_7()); }
	(rule__IntervalTypeDefinition__SupportAssignment_7)
	{ after(grammarAccess.getIntervalTypeDefinitionAccess().getSupportAssignment_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinition__Group__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalTypeDefinition__Group__8__Impl
	rule__IntervalTypeDefinition__Group__9
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinition__Group__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeDefinitionAccess().getAlternatives_8()); }
	(rule__IntervalTypeDefinition__Alternatives_8)
	{ after(grammarAccess.getIntervalTypeDefinitionAccess().getAlternatives_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinition__Group__9
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalTypeDefinition__Group__9__Impl
	rule__IntervalTypeDefinition__Group__10
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinition__Group__9__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeDefinitionAccess().getInfimumAssignment_9()); }
	(rule__IntervalTypeDefinition__InfimumAssignment_9)
	{ after(grammarAccess.getIntervalTypeDefinitionAccess().getInfimumAssignment_9()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinition__Group__10
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalTypeDefinition__Group__10__Impl
	rule__IntervalTypeDefinition__Group__11
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinition__Group__10__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeDefinitionAccess().getCommaKeyword_10()); }
	','
	{ after(grammarAccess.getIntervalTypeDefinitionAccess().getCommaKeyword_10()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinition__Group__11
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalTypeDefinition__Group__11__Impl
	rule__IntervalTypeDefinition__Group__12
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinition__Group__11__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeDefinitionAccess().getSupremumAssignment_11()); }
	(rule__IntervalTypeDefinition__SupremumAssignment_11)
	{ after(grammarAccess.getIntervalTypeDefinitionAccess().getSupremumAssignment_11()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinition__Group__12
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalTypeDefinition__Group__12__Impl
	rule__IntervalTypeDefinition__Group__13
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinition__Group__12__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeDefinitionAccess().getAlternatives_12()); }
	(rule__IntervalTypeDefinition__Alternatives_12)
	{ after(grammarAccess.getIntervalTypeDefinitionAccess().getAlternatives_12()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinition__Group__13
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalTypeDefinition__Group__13__Impl
	rule__IntervalTypeDefinition__Group__14
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinition__Group__13__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeDefinitionAccess().getGreaterThanSignKeyword_13()); }
	'>'
	{ after(grammarAccess.getIntervalTypeDefinitionAccess().getGreaterThanSignKeyword_13()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinition__Group__14
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalTypeDefinition__Group__14__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinition__Group__14__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeDefinitionAccess().getSemicolonKeyword_14()); }
	';'
	{ after(grammarAccess.getIntervalTypeDefinitionAccess().getSemicolonKeyword_14()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__IntervalTypeDefinitionImpl__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalTypeDefinitionImpl__Group__0__Impl
	rule__IntervalTypeDefinitionImpl__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinitionImpl__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeDefinitionImplAccess().getIntervalTypeAction_0()); }
	()
	{ after(grammarAccess.getIntervalTypeDefinitionImplAccess().getIntervalTypeAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinitionImpl__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalTypeDefinitionImpl__Group__1__Impl
	rule__IntervalTypeDefinitionImpl__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinitionImpl__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeDefinitionImplAccess().getNameAssignment_1()); }
	(rule__IntervalTypeDefinitionImpl__NameAssignment_1)
	{ after(grammarAccess.getIntervalTypeDefinitionImplAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinitionImpl__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalTypeDefinitionImpl__Group__2__Impl
	rule__IntervalTypeDefinitionImpl__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinitionImpl__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeDefinitionImplAccess().getUnrestrictedNameAssignment_2()); }
	(rule__IntervalTypeDefinitionImpl__UnrestrictedNameAssignment_2)?
	{ after(grammarAccess.getIntervalTypeDefinitionImplAccess().getUnrestrictedNameAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinitionImpl__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalTypeDefinitionImpl__Group__3__Impl
	rule__IntervalTypeDefinitionImpl__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinitionImpl__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeDefinitionImplAccess().getIntervalKeyword_3()); }
	'interval'
	{ after(grammarAccess.getIntervalTypeDefinitionImplAccess().getIntervalKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinitionImpl__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalTypeDefinitionImpl__Group__4__Impl
	rule__IntervalTypeDefinitionImpl__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinitionImpl__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeDefinitionImplAccess().getLessThanSignKeyword_4()); }
	'<'
	{ after(grammarAccess.getIntervalTypeDefinitionImplAccess().getLessThanSignKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinitionImpl__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalTypeDefinitionImpl__Group__5__Impl
	rule__IntervalTypeDefinitionImpl__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinitionImpl__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeDefinitionImplAccess().getSupportAssignment_5()); }
	(rule__IntervalTypeDefinitionImpl__SupportAssignment_5)
	{ after(grammarAccess.getIntervalTypeDefinitionImplAccess().getSupportAssignment_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinitionImpl__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalTypeDefinitionImpl__Group__6__Impl
	rule__IntervalTypeDefinitionImpl__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinitionImpl__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeDefinitionImplAccess().getAlternatives_6()); }
	(rule__IntervalTypeDefinitionImpl__Alternatives_6)
	{ after(grammarAccess.getIntervalTypeDefinitionImplAccess().getAlternatives_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinitionImpl__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalTypeDefinitionImpl__Group__7__Impl
	rule__IntervalTypeDefinitionImpl__Group__8
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinitionImpl__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeDefinitionImplAccess().getInfimumAssignment_7()); }
	(rule__IntervalTypeDefinitionImpl__InfimumAssignment_7)
	{ after(grammarAccess.getIntervalTypeDefinitionImplAccess().getInfimumAssignment_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinitionImpl__Group__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalTypeDefinitionImpl__Group__8__Impl
	rule__IntervalTypeDefinitionImpl__Group__9
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinitionImpl__Group__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeDefinitionImplAccess().getCommaKeyword_8()); }
	','
	{ after(grammarAccess.getIntervalTypeDefinitionImplAccess().getCommaKeyword_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinitionImpl__Group__9
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalTypeDefinitionImpl__Group__9__Impl
	rule__IntervalTypeDefinitionImpl__Group__10
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinitionImpl__Group__9__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeDefinitionImplAccess().getSupremumAssignment_9()); }
	(rule__IntervalTypeDefinitionImpl__SupremumAssignment_9)
	{ after(grammarAccess.getIntervalTypeDefinitionImplAccess().getSupremumAssignment_9()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinitionImpl__Group__10
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalTypeDefinitionImpl__Group__10__Impl
	rule__IntervalTypeDefinitionImpl__Group__11
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinitionImpl__Group__10__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeDefinitionImplAccess().getAlternatives_10()); }
	(rule__IntervalTypeDefinitionImpl__Alternatives_10)
	{ after(grammarAccess.getIntervalTypeDefinitionImplAccess().getAlternatives_10()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinitionImpl__Group__11
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalTypeDefinitionImpl__Group__11__Impl
	rule__IntervalTypeDefinitionImpl__Group__12
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinitionImpl__Group__11__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeDefinitionImplAccess().getGreaterThanSignKeyword_11()); }
	'>'
	{ after(grammarAccess.getIntervalTypeDefinitionImplAccess().getGreaterThanSignKeyword_11()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinitionImpl__Group__12
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__IntervalTypeDefinitionImpl__Group__12__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__IntervalTypeDefinitionImpl__Group__12__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getIntervalTypeDefinitionImplAccess().getSemicolonKeyword_12()); }
	';'
	{ after(grammarAccess.getIntervalTypeDefinitionImplAccess().getSemicolonKeyword_12()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__CollectionType__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CollectionType__Group__0__Impl
	rule__CollectionType__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionType__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCollectionTypeAccess().getCollectionTypeAction_0()); }
	()
	{ after(grammarAccess.getCollectionTypeAccess().getCollectionTypeAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionType__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CollectionType__Group__1__Impl
	rule__CollectionType__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionType__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCollectionTypeAccess().getContainerAssignment_1()); }
	(rule__CollectionType__ContainerAssignment_1)
	{ after(grammarAccess.getCollectionTypeAccess().getContainerAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionType__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CollectionType__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionType__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCollectionTypeAccess().getGroup_2()); }
	(rule__CollectionType__Group_2__0)?
	{ after(grammarAccess.getCollectionTypeAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__CollectionType__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CollectionType__Group_2__0__Impl
	rule__CollectionType__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionType__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCollectionTypeAccess().getLessThanSignKeyword_2_0()); }
	'<'
	{ after(grammarAccess.getCollectionTypeAccess().getLessThanSignKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionType__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CollectionType__Group_2__1__Impl
	rule__CollectionType__Group_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionType__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCollectionTypeAccess().getSupportAssignment_2_1()); }
	(rule__CollectionType__SupportAssignment_2_1)
	{ after(grammarAccess.getCollectionTypeAccess().getSupportAssignment_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionType__Group_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CollectionType__Group_2__2__Impl
	rule__CollectionType__Group_2__3
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionType__Group_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCollectionTypeAccess().getGroup_2_2()); }
	(rule__CollectionType__Group_2_2__0)?
	{ after(grammarAccess.getCollectionTypeAccess().getGroup_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionType__Group_2__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CollectionType__Group_2__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionType__Group_2__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCollectionTypeAccess().getGreaterThanSignKeyword_2_3()); }
	'>'
	{ after(grammarAccess.getCollectionTypeAccess().getGreaterThanSignKeyword_2_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__CollectionType__Group_2_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CollectionType__Group_2_2__0__Impl
	rule__CollectionType__Group_2_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionType__Group_2_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCollectionTypeAccess().getCommaKeyword_2_2_0()); }
	','
	{ after(grammarAccess.getCollectionTypeAccess().getCommaKeyword_2_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionType__Group_2_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CollectionType__Group_2_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionType__Group_2_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCollectionTypeAccess().getAlternatives_2_2_1()); }
	(rule__CollectionType__Alternatives_2_2_1)
	{ after(grammarAccess.getCollectionTypeAccess().getAlternatives_2_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__CollectionTypeDefinition__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CollectionTypeDefinition__Group__0__Impl
	rule__CollectionTypeDefinition__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinition__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCollectionTypeDefinitionAccess().getCollectionTypeAction_0()); }
	()
	{ after(grammarAccess.getCollectionTypeDefinitionAccess().getCollectionTypeAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinition__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CollectionTypeDefinition__Group__1__Impl
	rule__CollectionTypeDefinition__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinition__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCollectionTypeDefinitionAccess().getVisibilityAssignment_1()); }
	(rule__CollectionTypeDefinition__VisibilityAssignment_1)?
	{ after(grammarAccess.getCollectionTypeDefinitionAccess().getVisibilityAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinition__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CollectionTypeDefinition__Group__2__Impl
	rule__CollectionTypeDefinition__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinition__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCollectionTypeDefinitionAccess().getTypeKeyword_2()); }
	'type'
	{ after(grammarAccess.getCollectionTypeDefinitionAccess().getTypeKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinition__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CollectionTypeDefinition__Group__3__Impl
	rule__CollectionTypeDefinition__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinition__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCollectionTypeDefinitionAccess().getNameAssignment_3()); }
	(rule__CollectionTypeDefinition__NameAssignment_3)
	{ after(grammarAccess.getCollectionTypeDefinitionAccess().getNameAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinition__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CollectionTypeDefinition__Group__4__Impl
	rule__CollectionTypeDefinition__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinition__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCollectionTypeDefinitionAccess().getUnrestrictedNameAssignment_4()); }
	(rule__CollectionTypeDefinition__UnrestrictedNameAssignment_4)?
	{ after(grammarAccess.getCollectionTypeDefinitionAccess().getUnrestrictedNameAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinition__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CollectionTypeDefinition__Group__5__Impl
	rule__CollectionTypeDefinition__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinition__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCollectionTypeDefinitionAccess().getContainerAssignment_5()); }
	(rule__CollectionTypeDefinition__ContainerAssignment_5)
	{ after(grammarAccess.getCollectionTypeDefinitionAccess().getContainerAssignment_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinition__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CollectionTypeDefinition__Group__6__Impl
	rule__CollectionTypeDefinition__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinition__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCollectionTypeDefinitionAccess().getLessThanSignKeyword_6()); }
	'<'
	{ after(grammarAccess.getCollectionTypeDefinitionAccess().getLessThanSignKeyword_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinition__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CollectionTypeDefinition__Group__7__Impl
	rule__CollectionTypeDefinition__Group__8
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinition__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCollectionTypeDefinitionAccess().getSupportAssignment_7()); }
	(rule__CollectionTypeDefinition__SupportAssignment_7)
	{ after(grammarAccess.getCollectionTypeDefinitionAccess().getSupportAssignment_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinition__Group__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CollectionTypeDefinition__Group__8__Impl
	rule__CollectionTypeDefinition__Group__9
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinition__Group__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCollectionTypeDefinitionAccess().getGroup_8()); }
	(rule__CollectionTypeDefinition__Group_8__0)?
	{ after(grammarAccess.getCollectionTypeDefinitionAccess().getGroup_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinition__Group__9
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CollectionTypeDefinition__Group__9__Impl
	rule__CollectionTypeDefinition__Group__10
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinition__Group__9__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCollectionTypeDefinitionAccess().getGreaterThanSignKeyword_9()); }
	'>'
	{ after(grammarAccess.getCollectionTypeDefinitionAccess().getGreaterThanSignKeyword_9()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinition__Group__10
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CollectionTypeDefinition__Group__10__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinition__Group__10__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCollectionTypeDefinitionAccess().getSemicolonKeyword_10()); }
	';'
	{ after(grammarAccess.getCollectionTypeDefinitionAccess().getSemicolonKeyword_10()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__CollectionTypeDefinition__Group_8__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CollectionTypeDefinition__Group_8__0__Impl
	rule__CollectionTypeDefinition__Group_8__1
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinition__Group_8__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCollectionTypeDefinitionAccess().getCommaKeyword_8_0()); }
	','
	{ after(grammarAccess.getCollectionTypeDefinitionAccess().getCommaKeyword_8_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinition__Group_8__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CollectionTypeDefinition__Group_8__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinition__Group_8__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCollectionTypeDefinitionAccess().getAlternatives_8_1()); }
	(rule__CollectionTypeDefinition__Alternatives_8_1)
	{ after(grammarAccess.getCollectionTypeDefinitionAccess().getAlternatives_8_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__CollectionTypeDefinitionImpl__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CollectionTypeDefinitionImpl__Group__0__Impl
	rule__CollectionTypeDefinitionImpl__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinitionImpl__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCollectionTypeDefinitionImplAccess().getCollectionTypeAction_0()); }
	()
	{ after(grammarAccess.getCollectionTypeDefinitionImplAccess().getCollectionTypeAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinitionImpl__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CollectionTypeDefinitionImpl__Group__1__Impl
	rule__CollectionTypeDefinitionImpl__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinitionImpl__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCollectionTypeDefinitionImplAccess().getNameAssignment_1()); }
	(rule__CollectionTypeDefinitionImpl__NameAssignment_1)
	{ after(grammarAccess.getCollectionTypeDefinitionImplAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinitionImpl__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CollectionTypeDefinitionImpl__Group__2__Impl
	rule__CollectionTypeDefinitionImpl__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinitionImpl__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCollectionTypeDefinitionImplAccess().getUnrestrictedNameAssignment_2()); }
	(rule__CollectionTypeDefinitionImpl__UnrestrictedNameAssignment_2)?
	{ after(grammarAccess.getCollectionTypeDefinitionImplAccess().getUnrestrictedNameAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinitionImpl__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CollectionTypeDefinitionImpl__Group__3__Impl
	rule__CollectionTypeDefinitionImpl__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinitionImpl__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCollectionTypeDefinitionImplAccess().getContainerAssignment_3()); }
	(rule__CollectionTypeDefinitionImpl__ContainerAssignment_3)
	{ after(grammarAccess.getCollectionTypeDefinitionImplAccess().getContainerAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinitionImpl__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CollectionTypeDefinitionImpl__Group__4__Impl
	rule__CollectionTypeDefinitionImpl__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinitionImpl__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCollectionTypeDefinitionImplAccess().getLessThanSignKeyword_4()); }
	'<'
	{ after(grammarAccess.getCollectionTypeDefinitionImplAccess().getLessThanSignKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinitionImpl__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CollectionTypeDefinitionImpl__Group__5__Impl
	rule__CollectionTypeDefinitionImpl__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinitionImpl__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCollectionTypeDefinitionImplAccess().getSupportAssignment_5()); }
	(rule__CollectionTypeDefinitionImpl__SupportAssignment_5)
	{ after(grammarAccess.getCollectionTypeDefinitionImplAccess().getSupportAssignment_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinitionImpl__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CollectionTypeDefinitionImpl__Group__6__Impl
	rule__CollectionTypeDefinitionImpl__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinitionImpl__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCollectionTypeDefinitionImplAccess().getGroup_6()); }
	(rule__CollectionTypeDefinitionImpl__Group_6__0)?
	{ after(grammarAccess.getCollectionTypeDefinitionImplAccess().getGroup_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinitionImpl__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CollectionTypeDefinitionImpl__Group__7__Impl
	rule__CollectionTypeDefinitionImpl__Group__8
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinitionImpl__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCollectionTypeDefinitionImplAccess().getGreaterThanSignKeyword_7()); }
	'>'
	{ after(grammarAccess.getCollectionTypeDefinitionImplAccess().getGreaterThanSignKeyword_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinitionImpl__Group__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CollectionTypeDefinitionImpl__Group__8__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinitionImpl__Group__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCollectionTypeDefinitionImplAccess().getSemicolonKeyword_8()); }
	';'
	{ after(grammarAccess.getCollectionTypeDefinitionImplAccess().getSemicolonKeyword_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__CollectionTypeDefinitionImpl__Group_6__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CollectionTypeDefinitionImpl__Group_6__0__Impl
	rule__CollectionTypeDefinitionImpl__Group_6__1
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinitionImpl__Group_6__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCollectionTypeDefinitionImplAccess().getCommaKeyword_6_0()); }
	','
	{ after(grammarAccess.getCollectionTypeDefinitionImplAccess().getCommaKeyword_6_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinitionImpl__Group_6__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__CollectionTypeDefinitionImpl__Group_6__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__CollectionTypeDefinitionImpl__Group_6__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getCollectionTypeDefinitionImplAccess().getAlternatives_6_1()); }
	(rule__CollectionTypeDefinitionImpl__Alternatives_6_1)
	{ after(grammarAccess.getCollectionTypeDefinitionImplAccess().getAlternatives_6_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__EnumerationType__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationType__Group__0__Impl
	rule__EnumerationType__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationType__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationTypeAccess().getEnumerationTypeAction_0()); }
	()
	{ after(grammarAccess.getEnumerationTypeAccess().getEnumerationTypeAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationType__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationType__Group__1__Impl
	rule__EnumerationType__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationType__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationTypeAccess().getEnumKeyword_1()); }
	'enum'
	{ after(grammarAccess.getEnumerationTypeAccess().getEnumKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationType__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationType__Group__2__Impl
	rule__EnumerationType__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationType__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationTypeAccess().getLeftCurlyBracketKeyword_2()); }
	'{'
	{ after(grammarAccess.getEnumerationTypeAccess().getLeftCurlyBracketKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationType__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationType__Group__3__Impl
	rule__EnumerationType__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationType__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationTypeAccess().getLiteralAssignment_3()); }
	(rule__EnumerationType__LiteralAssignment_3)
	{ after(grammarAccess.getEnumerationTypeAccess().getLiteralAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationType__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationType__Group__4__Impl
	rule__EnumerationType__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationType__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationTypeAccess().getGroup_4()); }
	(rule__EnumerationType__Group_4__0)*
	{ after(grammarAccess.getEnumerationTypeAccess().getGroup_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationType__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationType__Group__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationType__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationTypeAccess().getRightCurlyBracketKeyword_5()); }
	'}'
	{ after(grammarAccess.getEnumerationTypeAccess().getRightCurlyBracketKeyword_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__EnumerationType__Group_4__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationType__Group_4__0__Impl
	rule__EnumerationType__Group_4__1
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationType__Group_4__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationTypeAccess().getCommaKeyword_4_0()); }
	','
	{ after(grammarAccess.getEnumerationTypeAccess().getCommaKeyword_4_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationType__Group_4__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationType__Group_4__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationType__Group_4__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationTypeAccess().getLiteralAssignment_4_1()); }
	(rule__EnumerationType__LiteralAssignment_4_1)
	{ after(grammarAccess.getEnumerationTypeAccess().getLiteralAssignment_4_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__EnumerationTypeDefinition__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationTypeDefinition__Group__0__Impl
	rule__EnumerationTypeDefinition__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinition__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationTypeDefinitionAccess().getEnumerationTypeAction_0()); }
	()
	{ after(grammarAccess.getEnumerationTypeDefinitionAccess().getEnumerationTypeAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinition__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationTypeDefinition__Group__1__Impl
	rule__EnumerationTypeDefinition__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinition__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationTypeDefinitionAccess().getVisibilityAssignment_1()); }
	(rule__EnumerationTypeDefinition__VisibilityAssignment_1)?
	{ after(grammarAccess.getEnumerationTypeDefinitionAccess().getVisibilityAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinition__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationTypeDefinition__Group__2__Impl
	rule__EnumerationTypeDefinition__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinition__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationTypeDefinitionAccess().getTypeKeyword_2()); }
	'type'
	{ after(grammarAccess.getEnumerationTypeDefinitionAccess().getTypeKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinition__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationTypeDefinition__Group__3__Impl
	rule__EnumerationTypeDefinition__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinition__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationTypeDefinitionAccess().getNameAssignment_3()); }
	(rule__EnumerationTypeDefinition__NameAssignment_3)
	{ after(grammarAccess.getEnumerationTypeDefinitionAccess().getNameAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinition__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationTypeDefinition__Group__4__Impl
	rule__EnumerationTypeDefinition__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinition__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationTypeDefinitionAccess().getUnrestrictedNameAssignment_4()); }
	(rule__EnumerationTypeDefinition__UnrestrictedNameAssignment_4)?
	{ after(grammarAccess.getEnumerationTypeDefinitionAccess().getUnrestrictedNameAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinition__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationTypeDefinition__Group__5__Impl
	rule__EnumerationTypeDefinition__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinition__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationTypeDefinitionAccess().getTypedefAssignment_5()); }
	(rule__EnumerationTypeDefinition__TypedefAssignment_5)
	{ after(grammarAccess.getEnumerationTypeDefinitionAccess().getTypedefAssignment_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinition__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationTypeDefinition__Group__6__Impl
	rule__EnumerationTypeDefinition__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinition__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationTypeDefinitionAccess().getLeftCurlyBracketKeyword_6()); }
	'{'
	{ after(grammarAccess.getEnumerationTypeDefinitionAccess().getLeftCurlyBracketKeyword_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinition__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationTypeDefinition__Group__7__Impl
	rule__EnumerationTypeDefinition__Group__8
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinition__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationTypeDefinitionAccess().getLiteralAssignment_7()); }
	(rule__EnumerationTypeDefinition__LiteralAssignment_7)
	{ after(grammarAccess.getEnumerationTypeDefinitionAccess().getLiteralAssignment_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinition__Group__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationTypeDefinition__Group__8__Impl
	rule__EnumerationTypeDefinition__Group__9
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinition__Group__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationTypeDefinitionAccess().getGroup_8()); }
	(rule__EnumerationTypeDefinition__Group_8__0)*
	{ after(grammarAccess.getEnumerationTypeDefinitionAccess().getGroup_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinition__Group__9
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationTypeDefinition__Group__9__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinition__Group__9__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationTypeDefinitionAccess().getRightCurlyBracketKeyword_9()); }
	'}'
	{ after(grammarAccess.getEnumerationTypeDefinitionAccess().getRightCurlyBracketKeyword_9()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__EnumerationTypeDefinition__Group_8__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationTypeDefinition__Group_8__0__Impl
	rule__EnumerationTypeDefinition__Group_8__1
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinition__Group_8__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationTypeDefinitionAccess().getCommaKeyword_8_0()); }
	','
	{ after(grammarAccess.getEnumerationTypeDefinitionAccess().getCommaKeyword_8_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinition__Group_8__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationTypeDefinition__Group_8__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinition__Group_8__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationTypeDefinitionAccess().getLiteralAssignment_8_1()); }
	(rule__EnumerationTypeDefinition__LiteralAssignment_8_1)
	{ after(grammarAccess.getEnumerationTypeDefinitionAccess().getLiteralAssignment_8_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__EnumerationTypeDefinitionImpl__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationTypeDefinitionImpl__Group__0__Impl
	rule__EnumerationTypeDefinitionImpl__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinitionImpl__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationTypeDefinitionImplAccess().getEnumerationTypeAction_0()); }
	()
	{ after(grammarAccess.getEnumerationTypeDefinitionImplAccess().getEnumerationTypeAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinitionImpl__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationTypeDefinitionImpl__Group__1__Impl
	rule__EnumerationTypeDefinitionImpl__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinitionImpl__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationTypeDefinitionImplAccess().getNameAssignment_1()); }
	(rule__EnumerationTypeDefinitionImpl__NameAssignment_1)
	{ after(grammarAccess.getEnumerationTypeDefinitionImplAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinitionImpl__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationTypeDefinitionImpl__Group__2__Impl
	rule__EnumerationTypeDefinitionImpl__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinitionImpl__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationTypeDefinitionImplAccess().getUnrestrictedNameAssignment_2()); }
	(rule__EnumerationTypeDefinitionImpl__UnrestrictedNameAssignment_2)?
	{ after(grammarAccess.getEnumerationTypeDefinitionImplAccess().getUnrestrictedNameAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinitionImpl__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationTypeDefinitionImpl__Group__3__Impl
	rule__EnumerationTypeDefinitionImpl__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinitionImpl__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationTypeDefinitionImplAccess().getTypedefAssignment_3()); }
	(rule__EnumerationTypeDefinitionImpl__TypedefAssignment_3)
	{ after(grammarAccess.getEnumerationTypeDefinitionImplAccess().getTypedefAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinitionImpl__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationTypeDefinitionImpl__Group__4__Impl
	rule__EnumerationTypeDefinitionImpl__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinitionImpl__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationTypeDefinitionImplAccess().getLeftCurlyBracketKeyword_4()); }
	'{'
	{ after(grammarAccess.getEnumerationTypeDefinitionImplAccess().getLeftCurlyBracketKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinitionImpl__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationTypeDefinitionImpl__Group__5__Impl
	rule__EnumerationTypeDefinitionImpl__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinitionImpl__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationTypeDefinitionImplAccess().getLiteralAssignment_5()); }
	(rule__EnumerationTypeDefinitionImpl__LiteralAssignment_5)
	{ after(grammarAccess.getEnumerationTypeDefinitionImplAccess().getLiteralAssignment_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinitionImpl__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationTypeDefinitionImpl__Group__6__Impl
	rule__EnumerationTypeDefinitionImpl__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinitionImpl__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationTypeDefinitionImplAccess().getGroup_6()); }
	(rule__EnumerationTypeDefinitionImpl__Group_6__0)*
	{ after(grammarAccess.getEnumerationTypeDefinitionImplAccess().getGroup_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinitionImpl__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationTypeDefinitionImpl__Group__7__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinitionImpl__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationTypeDefinitionImplAccess().getRightCurlyBracketKeyword_7()); }
	'}'
	{ after(grammarAccess.getEnumerationTypeDefinitionImplAccess().getRightCurlyBracketKeyword_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__EnumerationTypeDefinitionImpl__Group_6__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationTypeDefinitionImpl__Group_6__0__Impl
	rule__EnumerationTypeDefinitionImpl__Group_6__1
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinitionImpl__Group_6__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationTypeDefinitionImplAccess().getCommaKeyword_6_0()); }
	','
	{ after(grammarAccess.getEnumerationTypeDefinitionImplAccess().getCommaKeyword_6_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinitionImpl__Group_6__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationTypeDefinitionImpl__Group_6__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationTypeDefinitionImpl__Group_6__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationTypeDefinitionImplAccess().getLiteralAssignment_6_1()); }
	(rule__EnumerationTypeDefinitionImpl__LiteralAssignment_6_1)
	{ after(grammarAccess.getEnumerationTypeDefinitionImplAccess().getLiteralAssignment_6_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__EnumerationLiteral__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationLiteral__Group__0__Impl
	rule__EnumerationLiteral__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationLiteral__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationLiteralAccess().getNameAssignment_0()); }
	(rule__EnumerationLiteral__NameAssignment_0)
	{ after(grammarAccess.getEnumerationLiteralAccess().getNameAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationLiteral__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationLiteral__Group__1__Impl
	rule__EnumerationLiteral__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationLiteral__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationLiteralAccess().getUnrestrictedNameAssignment_1()); }
	(rule__EnumerationLiteral__UnrestrictedNameAssignment_1)?
	{ after(grammarAccess.getEnumerationLiteralAccess().getUnrestrictedNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationLiteral__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationLiteral__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationLiteral__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationLiteralAccess().getGroup_2()); }
	(rule__EnumerationLiteral__Group_2__0)?
	{ after(grammarAccess.getEnumerationLiteralAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__EnumerationLiteral__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationLiteral__Group_2__0__Impl
	rule__EnumerationLiteral__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationLiteral__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationLiteralAccess().getEqualsSignKeyword_2_0()); }
	'='
	{ after(grammarAccess.getEnumerationLiteralAccess().getEqualsSignKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationLiteral__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__EnumerationLiteral__Group_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__EnumerationLiteral__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getEnumerationLiteralAccess().getValueAssignment_2_1()); }
	(rule__EnumerationLiteral__ValueAssignment_2_1)
	{ after(grammarAccess.getEnumerationLiteralAccess().getValueAssignment_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__StructureType__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StructureType__Group__0__Impl
	rule__StructureType__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureType__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStructureTypeAccess().getStructureTypeAction_0()); }
	()
	{ after(grammarAccess.getStructureTypeAccess().getStructureTypeAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureType__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StructureType__Group__1__Impl
	rule__StructureType__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureType__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStructureTypeAccess().getStructKeyword_1()); }
	'struct'
	{ after(grammarAccess.getStructureTypeAccess().getStructKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureType__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StructureType__Group__2__Impl
	rule__StructureType__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureType__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStructureTypeAccess().getLeftCurlyBracketKeyword_2()); }
	'{'
	{ after(grammarAccess.getStructureTypeAccess().getLeftCurlyBracketKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureType__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StructureType__Group__3__Impl
	rule__StructureType__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureType__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getStructureTypeAccess().getPropertyAssignment_3()); }
		(rule__StructureType__PropertyAssignment_3)
		{ after(grammarAccess.getStructureTypeAccess().getPropertyAssignment_3()); }
	)
	(
		{ before(grammarAccess.getStructureTypeAccess().getPropertyAssignment_3()); }
		(rule__StructureType__PropertyAssignment_3)*
		{ after(grammarAccess.getStructureTypeAccess().getPropertyAssignment_3()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureType__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StructureType__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureType__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStructureTypeAccess().getRightCurlyBracketKeyword_4()); }
	'}'
	{ after(grammarAccess.getStructureTypeAccess().getRightCurlyBracketKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__StructureTypeDefinition__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StructureTypeDefinition__Group__0__Impl
	rule__StructureTypeDefinition__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureTypeDefinition__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStructureTypeDefinitionAccess().getStructureTypeAction_0()); }
	()
	{ after(grammarAccess.getStructureTypeDefinitionAccess().getStructureTypeAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureTypeDefinition__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StructureTypeDefinition__Group__1__Impl
	rule__StructureTypeDefinition__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureTypeDefinition__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStructureTypeDefinitionAccess().getVisibilityAssignment_1()); }
	(rule__StructureTypeDefinition__VisibilityAssignment_1)?
	{ after(grammarAccess.getStructureTypeDefinitionAccess().getVisibilityAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureTypeDefinition__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StructureTypeDefinition__Group__2__Impl
	rule__StructureTypeDefinition__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureTypeDefinition__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStructureTypeDefinitionAccess().getTypeKeyword_2()); }
	'type'
	{ after(grammarAccess.getStructureTypeDefinitionAccess().getTypeKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureTypeDefinition__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StructureTypeDefinition__Group__3__Impl
	rule__StructureTypeDefinition__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureTypeDefinition__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStructureTypeDefinitionAccess().getNameAssignment_3()); }
	(rule__StructureTypeDefinition__NameAssignment_3)
	{ after(grammarAccess.getStructureTypeDefinitionAccess().getNameAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureTypeDefinition__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StructureTypeDefinition__Group__4__Impl
	rule__StructureTypeDefinition__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureTypeDefinition__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStructureTypeDefinitionAccess().getUnrestrictedNameAssignment_4()); }
	(rule__StructureTypeDefinition__UnrestrictedNameAssignment_4)?
	{ after(grammarAccess.getStructureTypeDefinitionAccess().getUnrestrictedNameAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureTypeDefinition__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StructureTypeDefinition__Group__5__Impl
	rule__StructureTypeDefinition__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureTypeDefinition__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStructureTypeDefinitionAccess().getTypedefAssignment_5()); }
	(rule__StructureTypeDefinition__TypedefAssignment_5)
	{ after(grammarAccess.getStructureTypeDefinitionAccess().getTypedefAssignment_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureTypeDefinition__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StructureTypeDefinition__Group__6__Impl
	rule__StructureTypeDefinition__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureTypeDefinition__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStructureTypeDefinitionAccess().getLeftCurlyBracketKeyword_6()); }
	'{'
	{ after(grammarAccess.getStructureTypeDefinitionAccess().getLeftCurlyBracketKeyword_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureTypeDefinition__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StructureTypeDefinition__Group__7__Impl
	rule__StructureTypeDefinition__Group__8
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureTypeDefinition__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getStructureTypeDefinitionAccess().getPropertyAssignment_7()); }
		(rule__StructureTypeDefinition__PropertyAssignment_7)
		{ after(grammarAccess.getStructureTypeDefinitionAccess().getPropertyAssignment_7()); }
	)
	(
		{ before(grammarAccess.getStructureTypeDefinitionAccess().getPropertyAssignment_7()); }
		(rule__StructureTypeDefinition__PropertyAssignment_7)*
		{ after(grammarAccess.getStructureTypeDefinitionAccess().getPropertyAssignment_7()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureTypeDefinition__Group__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StructureTypeDefinition__Group__8__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureTypeDefinition__Group__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStructureTypeDefinitionAccess().getRightCurlyBracketKeyword_8()); }
	'}'
	{ after(grammarAccess.getStructureTypeDefinitionAccess().getRightCurlyBracketKeyword_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__StructureTypeDefinitionImpl__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StructureTypeDefinitionImpl__Group__0__Impl
	rule__StructureTypeDefinitionImpl__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureTypeDefinitionImpl__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStructureTypeDefinitionImplAccess().getStructureTypeAction_0()); }
	()
	{ after(grammarAccess.getStructureTypeDefinitionImplAccess().getStructureTypeAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureTypeDefinitionImpl__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StructureTypeDefinitionImpl__Group__1__Impl
	rule__StructureTypeDefinitionImpl__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureTypeDefinitionImpl__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStructureTypeDefinitionImplAccess().getNameAssignment_1()); }
	(rule__StructureTypeDefinitionImpl__NameAssignment_1)
	{ after(grammarAccess.getStructureTypeDefinitionImplAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureTypeDefinitionImpl__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StructureTypeDefinitionImpl__Group__2__Impl
	rule__StructureTypeDefinitionImpl__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureTypeDefinitionImpl__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStructureTypeDefinitionImplAccess().getUnrestrictedNameAssignment_2()); }
	(rule__StructureTypeDefinitionImpl__UnrestrictedNameAssignment_2)?
	{ after(grammarAccess.getStructureTypeDefinitionImplAccess().getUnrestrictedNameAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureTypeDefinitionImpl__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StructureTypeDefinitionImpl__Group__3__Impl
	rule__StructureTypeDefinitionImpl__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureTypeDefinitionImpl__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStructureTypeDefinitionImplAccess().getTypedefAssignment_3()); }
	(rule__StructureTypeDefinitionImpl__TypedefAssignment_3)
	{ after(grammarAccess.getStructureTypeDefinitionImplAccess().getTypedefAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureTypeDefinitionImpl__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StructureTypeDefinitionImpl__Group__4__Impl
	rule__StructureTypeDefinitionImpl__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureTypeDefinitionImpl__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStructureTypeDefinitionImplAccess().getLeftCurlyBracketKeyword_4()); }
	'{'
	{ after(grammarAccess.getStructureTypeDefinitionImplAccess().getLeftCurlyBracketKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureTypeDefinitionImpl__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StructureTypeDefinitionImpl__Group__5__Impl
	rule__StructureTypeDefinitionImpl__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureTypeDefinitionImpl__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getStructureTypeDefinitionImplAccess().getPropertyAssignment_5()); }
		(rule__StructureTypeDefinitionImpl__PropertyAssignment_5)
		{ after(grammarAccess.getStructureTypeDefinitionImplAccess().getPropertyAssignment_5()); }
	)
	(
		{ before(grammarAccess.getStructureTypeDefinitionImplAccess().getPropertyAssignment_5()); }
		(rule__StructureTypeDefinitionImpl__PropertyAssignment_5)*
		{ after(grammarAccess.getStructureTypeDefinitionImplAccess().getPropertyAssignment_5()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureTypeDefinitionImpl__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__StructureTypeDefinitionImpl__Group__6__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__StructureTypeDefinitionImpl__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getStructureTypeDefinitionImplAccess().getRightCurlyBracketKeyword_6()); }
	'}'
	{ after(grammarAccess.getStructureTypeDefinitionImplAccess().getRightCurlyBracketKeyword_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__UnionType__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnionType__Group__0__Impl
	rule__UnionType__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionType__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnionTypeAccess().getUnionTypeAction_0()); }
	()
	{ after(grammarAccess.getUnionTypeAccess().getUnionTypeAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionType__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnionType__Group__1__Impl
	rule__UnionType__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionType__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnionTypeAccess().getUnionKeyword_1()); }
	'union'
	{ after(grammarAccess.getUnionTypeAccess().getUnionKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionType__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnionType__Group__2__Impl
	rule__UnionType__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionType__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnionTypeAccess().getLeftCurlyBracketKeyword_2()); }
	'{'
	{ after(grammarAccess.getUnionTypeAccess().getLeftCurlyBracketKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionType__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnionType__Group__3__Impl
	rule__UnionType__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionType__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getUnionTypeAccess().getPropertyAssignment_3()); }
		(rule__UnionType__PropertyAssignment_3)
		{ after(grammarAccess.getUnionTypeAccess().getPropertyAssignment_3()); }
	)
	(
		{ before(grammarAccess.getUnionTypeAccess().getPropertyAssignment_3()); }
		(rule__UnionType__PropertyAssignment_3)*
		{ after(grammarAccess.getUnionTypeAccess().getPropertyAssignment_3()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionType__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnionType__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionType__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnionTypeAccess().getRightCurlyBracketKeyword_4()); }
	'}'
	{ after(grammarAccess.getUnionTypeAccess().getRightCurlyBracketKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__UnionTypeDefinition__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnionTypeDefinition__Group__0__Impl
	rule__UnionTypeDefinition__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionTypeDefinition__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnionTypeDefinitionAccess().getUnionTypeAction_0()); }
	()
	{ after(grammarAccess.getUnionTypeDefinitionAccess().getUnionTypeAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionTypeDefinition__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnionTypeDefinition__Group__1__Impl
	rule__UnionTypeDefinition__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionTypeDefinition__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnionTypeDefinitionAccess().getVisibilityAssignment_1()); }
	(rule__UnionTypeDefinition__VisibilityAssignment_1)?
	{ after(grammarAccess.getUnionTypeDefinitionAccess().getVisibilityAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionTypeDefinition__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnionTypeDefinition__Group__2__Impl
	rule__UnionTypeDefinition__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionTypeDefinition__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnionTypeDefinitionAccess().getTypeKeyword_2()); }
	'type'
	{ after(grammarAccess.getUnionTypeDefinitionAccess().getTypeKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionTypeDefinition__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnionTypeDefinition__Group__3__Impl
	rule__UnionTypeDefinition__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionTypeDefinition__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnionTypeDefinitionAccess().getNameAssignment_3()); }
	(rule__UnionTypeDefinition__NameAssignment_3)
	{ after(grammarAccess.getUnionTypeDefinitionAccess().getNameAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionTypeDefinition__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnionTypeDefinition__Group__4__Impl
	rule__UnionTypeDefinition__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionTypeDefinition__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnionTypeDefinitionAccess().getUnrestrictedNameAssignment_4()); }
	(rule__UnionTypeDefinition__UnrestrictedNameAssignment_4)?
	{ after(grammarAccess.getUnionTypeDefinitionAccess().getUnrestrictedNameAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionTypeDefinition__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnionTypeDefinition__Group__5__Impl
	rule__UnionTypeDefinition__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionTypeDefinition__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnionTypeDefinitionAccess().getTypedefAssignment_5()); }
	(rule__UnionTypeDefinition__TypedefAssignment_5)
	{ after(grammarAccess.getUnionTypeDefinitionAccess().getTypedefAssignment_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionTypeDefinition__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnionTypeDefinition__Group__6__Impl
	rule__UnionTypeDefinition__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionTypeDefinition__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnionTypeDefinitionAccess().getLeftCurlyBracketKeyword_6()); }
	'{'
	{ after(grammarAccess.getUnionTypeDefinitionAccess().getLeftCurlyBracketKeyword_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionTypeDefinition__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnionTypeDefinition__Group__7__Impl
	rule__UnionTypeDefinition__Group__8
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionTypeDefinition__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getUnionTypeDefinitionAccess().getPropertyAssignment_7()); }
		(rule__UnionTypeDefinition__PropertyAssignment_7)
		{ after(grammarAccess.getUnionTypeDefinitionAccess().getPropertyAssignment_7()); }
	)
	(
		{ before(grammarAccess.getUnionTypeDefinitionAccess().getPropertyAssignment_7()); }
		(rule__UnionTypeDefinition__PropertyAssignment_7)*
		{ after(grammarAccess.getUnionTypeDefinitionAccess().getPropertyAssignment_7()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionTypeDefinition__Group__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnionTypeDefinition__Group__8__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionTypeDefinition__Group__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnionTypeDefinitionAccess().getRightCurlyBracketKeyword_8()); }
	'}'
	{ after(grammarAccess.getUnionTypeDefinitionAccess().getRightCurlyBracketKeyword_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__UnionTypeDefinitionImpl__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnionTypeDefinitionImpl__Group__0__Impl
	rule__UnionTypeDefinitionImpl__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionTypeDefinitionImpl__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnionTypeDefinitionImplAccess().getUnionTypeAction_0()); }
	()
	{ after(grammarAccess.getUnionTypeDefinitionImplAccess().getUnionTypeAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionTypeDefinitionImpl__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnionTypeDefinitionImpl__Group__1__Impl
	rule__UnionTypeDefinitionImpl__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionTypeDefinitionImpl__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnionTypeDefinitionImplAccess().getNameAssignment_1()); }
	(rule__UnionTypeDefinitionImpl__NameAssignment_1)
	{ after(grammarAccess.getUnionTypeDefinitionImplAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionTypeDefinitionImpl__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnionTypeDefinitionImpl__Group__2__Impl
	rule__UnionTypeDefinitionImpl__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionTypeDefinitionImpl__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnionTypeDefinitionImplAccess().getUnrestrictedNameAssignment_2()); }
	(rule__UnionTypeDefinitionImpl__UnrestrictedNameAssignment_2)?
	{ after(grammarAccess.getUnionTypeDefinitionImplAccess().getUnrestrictedNameAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionTypeDefinitionImpl__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnionTypeDefinitionImpl__Group__3__Impl
	rule__UnionTypeDefinitionImpl__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionTypeDefinitionImpl__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnionTypeDefinitionImplAccess().getTypedefAssignment_3()); }
	(rule__UnionTypeDefinitionImpl__TypedefAssignment_3)
	{ after(grammarAccess.getUnionTypeDefinitionImplAccess().getTypedefAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionTypeDefinitionImpl__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnionTypeDefinitionImpl__Group__4__Impl
	rule__UnionTypeDefinitionImpl__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionTypeDefinitionImpl__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnionTypeDefinitionImplAccess().getLeftCurlyBracketKeyword_4()); }
	'{'
	{ after(grammarAccess.getUnionTypeDefinitionImplAccess().getLeftCurlyBracketKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionTypeDefinitionImpl__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnionTypeDefinitionImpl__Group__5__Impl
	rule__UnionTypeDefinitionImpl__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionTypeDefinitionImpl__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getUnionTypeDefinitionImplAccess().getPropertyAssignment_5()); }
		(rule__UnionTypeDefinitionImpl__PropertyAssignment_5)
		{ after(grammarAccess.getUnionTypeDefinitionImplAccess().getPropertyAssignment_5()); }
	)
	(
		{ before(grammarAccess.getUnionTypeDefinitionImplAccess().getPropertyAssignment_5()); }
		(rule__UnionTypeDefinitionImpl__PropertyAssignment_5)*
		{ after(grammarAccess.getUnionTypeDefinitionImplAccess().getPropertyAssignment_5()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionTypeDefinitionImpl__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__UnionTypeDefinitionImpl__Group__6__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__UnionTypeDefinitionImpl__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getUnionTypeDefinitionImplAccess().getRightCurlyBracketKeyword_6()); }
	'}'
	{ after(grammarAccess.getUnionTypeDefinitionImplAccess().getRightCurlyBracketKeyword_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ChoiceType__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChoiceType__Group__0__Impl
	rule__ChoiceType__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceType__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChoiceTypeAccess().getChoiceTypeAction_0()); }
	()
	{ after(grammarAccess.getChoiceTypeAccess().getChoiceTypeAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceType__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChoiceType__Group__1__Impl
	rule__ChoiceType__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceType__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChoiceTypeAccess().getChoiceKeyword_1()); }
	'choice'
	{ after(grammarAccess.getChoiceTypeAccess().getChoiceKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceType__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChoiceType__Group__2__Impl
	rule__ChoiceType__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceType__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChoiceTypeAccess().getLeftCurlyBracketKeyword_2()); }
	'{'
	{ after(grammarAccess.getChoiceTypeAccess().getLeftCurlyBracketKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceType__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChoiceType__Group__3__Impl
	rule__ChoiceType__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceType__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getChoiceTypeAccess().getPropertyAssignment_3()); }
		(rule__ChoiceType__PropertyAssignment_3)
		{ after(grammarAccess.getChoiceTypeAccess().getPropertyAssignment_3()); }
	)
	(
		{ before(grammarAccess.getChoiceTypeAccess().getPropertyAssignment_3()); }
		(rule__ChoiceType__PropertyAssignment_3)*
		{ after(grammarAccess.getChoiceTypeAccess().getPropertyAssignment_3()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceType__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChoiceType__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceType__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChoiceTypeAccess().getRightCurlyBracketKeyword_4()); }
	'}'
	{ after(grammarAccess.getChoiceTypeAccess().getRightCurlyBracketKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ChoiceTypeDefinition__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChoiceTypeDefinition__Group__0__Impl
	rule__ChoiceTypeDefinition__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceTypeDefinition__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChoiceTypeDefinitionAccess().getChoiceTypeAction_0()); }
	()
	{ after(grammarAccess.getChoiceTypeDefinitionAccess().getChoiceTypeAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceTypeDefinition__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChoiceTypeDefinition__Group__1__Impl
	rule__ChoiceTypeDefinition__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceTypeDefinition__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChoiceTypeDefinitionAccess().getVisibilityAssignment_1()); }
	(rule__ChoiceTypeDefinition__VisibilityAssignment_1)?
	{ after(grammarAccess.getChoiceTypeDefinitionAccess().getVisibilityAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceTypeDefinition__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChoiceTypeDefinition__Group__2__Impl
	rule__ChoiceTypeDefinition__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceTypeDefinition__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChoiceTypeDefinitionAccess().getTypeKeyword_2()); }
	'type'
	{ after(grammarAccess.getChoiceTypeDefinitionAccess().getTypeKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceTypeDefinition__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChoiceTypeDefinition__Group__3__Impl
	rule__ChoiceTypeDefinition__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceTypeDefinition__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChoiceTypeDefinitionAccess().getNameAssignment_3()); }
	(rule__ChoiceTypeDefinition__NameAssignment_3)
	{ after(grammarAccess.getChoiceTypeDefinitionAccess().getNameAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceTypeDefinition__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChoiceTypeDefinition__Group__4__Impl
	rule__ChoiceTypeDefinition__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceTypeDefinition__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChoiceTypeDefinitionAccess().getUnrestrictedNameAssignment_4()); }
	(rule__ChoiceTypeDefinition__UnrestrictedNameAssignment_4)?
	{ after(grammarAccess.getChoiceTypeDefinitionAccess().getUnrestrictedNameAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceTypeDefinition__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChoiceTypeDefinition__Group__5__Impl
	rule__ChoiceTypeDefinition__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceTypeDefinition__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChoiceTypeDefinitionAccess().getTypedefAssignment_5()); }
	(rule__ChoiceTypeDefinition__TypedefAssignment_5)
	{ after(grammarAccess.getChoiceTypeDefinitionAccess().getTypedefAssignment_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceTypeDefinition__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChoiceTypeDefinition__Group__6__Impl
	rule__ChoiceTypeDefinition__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceTypeDefinition__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChoiceTypeDefinitionAccess().getLeftCurlyBracketKeyword_6()); }
	'{'
	{ after(grammarAccess.getChoiceTypeDefinitionAccess().getLeftCurlyBracketKeyword_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceTypeDefinition__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChoiceTypeDefinition__Group__7__Impl
	rule__ChoiceTypeDefinition__Group__8
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceTypeDefinition__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getChoiceTypeDefinitionAccess().getPropertyAssignment_7()); }
		(rule__ChoiceTypeDefinition__PropertyAssignment_7)
		{ after(grammarAccess.getChoiceTypeDefinitionAccess().getPropertyAssignment_7()); }
	)
	(
		{ before(grammarAccess.getChoiceTypeDefinitionAccess().getPropertyAssignment_7()); }
		(rule__ChoiceTypeDefinition__PropertyAssignment_7)*
		{ after(grammarAccess.getChoiceTypeDefinitionAccess().getPropertyAssignment_7()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceTypeDefinition__Group__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChoiceTypeDefinition__Group__8__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceTypeDefinition__Group__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChoiceTypeDefinitionAccess().getRightCurlyBracketKeyword_8()); }
	'}'
	{ after(grammarAccess.getChoiceTypeDefinitionAccess().getRightCurlyBracketKeyword_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ChoiceTypeDefinitionImpl__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChoiceTypeDefinitionImpl__Group__0__Impl
	rule__ChoiceTypeDefinitionImpl__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceTypeDefinitionImpl__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChoiceTypeDefinitionImplAccess().getChoiceTypeAction_0()); }
	()
	{ after(grammarAccess.getChoiceTypeDefinitionImplAccess().getChoiceTypeAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceTypeDefinitionImpl__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChoiceTypeDefinitionImpl__Group__1__Impl
	rule__ChoiceTypeDefinitionImpl__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceTypeDefinitionImpl__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChoiceTypeDefinitionImplAccess().getNameAssignment_1()); }
	(rule__ChoiceTypeDefinitionImpl__NameAssignment_1)
	{ after(grammarAccess.getChoiceTypeDefinitionImplAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceTypeDefinitionImpl__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChoiceTypeDefinitionImpl__Group__2__Impl
	rule__ChoiceTypeDefinitionImpl__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceTypeDefinitionImpl__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChoiceTypeDefinitionImplAccess().getUnrestrictedNameAssignment_2()); }
	(rule__ChoiceTypeDefinitionImpl__UnrestrictedNameAssignment_2)?
	{ after(grammarAccess.getChoiceTypeDefinitionImplAccess().getUnrestrictedNameAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceTypeDefinitionImpl__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChoiceTypeDefinitionImpl__Group__3__Impl
	rule__ChoiceTypeDefinitionImpl__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceTypeDefinitionImpl__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChoiceTypeDefinitionImplAccess().getTypedefAssignment_3()); }
	(rule__ChoiceTypeDefinitionImpl__TypedefAssignment_3)
	{ after(grammarAccess.getChoiceTypeDefinitionImplAccess().getTypedefAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceTypeDefinitionImpl__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChoiceTypeDefinitionImpl__Group__4__Impl
	rule__ChoiceTypeDefinitionImpl__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceTypeDefinitionImpl__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChoiceTypeDefinitionImplAccess().getLeftCurlyBracketKeyword_4()); }
	'{'
	{ after(grammarAccess.getChoiceTypeDefinitionImplAccess().getLeftCurlyBracketKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceTypeDefinitionImpl__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChoiceTypeDefinitionImpl__Group__5__Impl
	rule__ChoiceTypeDefinitionImpl__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceTypeDefinitionImpl__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getChoiceTypeDefinitionImplAccess().getPropertyAssignment_5()); }
		(rule__ChoiceTypeDefinitionImpl__PropertyAssignment_5)
		{ after(grammarAccess.getChoiceTypeDefinitionImplAccess().getPropertyAssignment_5()); }
	)
	(
		{ before(grammarAccess.getChoiceTypeDefinitionImplAccess().getPropertyAssignment_5()); }
		(rule__ChoiceTypeDefinitionImpl__PropertyAssignment_5)*
		{ after(grammarAccess.getChoiceTypeDefinitionImplAccess().getPropertyAssignment_5()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceTypeDefinitionImpl__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChoiceTypeDefinitionImpl__Group__6__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ChoiceTypeDefinitionImpl__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChoiceTypeDefinitionImplAccess().getRightCurlyBracketKeyword_6()); }
	'}'
	{ after(grammarAccess.getChoiceTypeDefinitionImplAccess().getRightCurlyBracketKeyword_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Modifier__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Modifier__Group__0__Impl
	rule__Modifier__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Modifier__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getModifierAccess().getModifierAction_0()); }
	()
	{ after(grammarAccess.getModifierAccess().getModifierAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Modifier__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Modifier__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Modifier__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getModifierAccess().getUnorderedGroup_1()); }
	(rule__Modifier__UnorderedGroup_1)
	{ after(grammarAccess.getModifierAccess().getUnorderedGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Variable__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Variable__Group__0__Impl
	rule__Variable__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableAccess().getUnorderedGroup_0()); }
	(rule__Variable__UnorderedGroup_0)
	{ after(grammarAccess.getVariableAccess().getUnorderedGroup_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Variable__Group__1__Impl
	rule__Variable__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableAccess().getAlternatives_1()); }
	(rule__Variable__Alternatives_1)
	{ after(grammarAccess.getVariableAccess().getAlternatives_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Variable__Group__2__Impl
	rule__Variable__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableAccess().getTypeAssignment_2()); }
	(rule__Variable__TypeAssignment_2)
	{ after(grammarAccess.getVariableAccess().getTypeAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Variable__Group__3__Impl
	rule__Variable__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableAccess().getReferenceAssignment_3()); }
	(rule__Variable__ReferenceAssignment_3)?
	{ after(grammarAccess.getVariableAccess().getReferenceAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Variable__Group__4__Impl
	rule__Variable__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableAccess().getNameAssignment_4()); }
	(rule__Variable__NameAssignment_4)
	{ after(grammarAccess.getVariableAccess().getNameAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Variable__Group__5__Impl
	rule__Variable__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableAccess().getUnrestrictedNameAssignment_5()); }
	(rule__Variable__UnrestrictedNameAssignment_5)?
	{ after(grammarAccess.getVariableAccess().getUnrestrictedNameAssignment_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Variable__Group__6__Impl
	rule__Variable__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableAccess().getGroup_6()); }
	(rule__Variable__Group_6__0)?
	{ after(grammarAccess.getVariableAccess().getGroup_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Variable__Group__7__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableAccess().getAlternatives_7()); }
	(rule__Variable__Alternatives_7)
	{ after(grammarAccess.getVariableAccess().getAlternatives_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Variable__Group_1_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Variable__Group_1_2__0__Impl
	rule__Variable__Group_1_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Group_1_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableAccess().getAlternatives_1_2_0()); }
	(rule__Variable__Alternatives_1_2_0)
	{ after(grammarAccess.getVariableAccess().getAlternatives_1_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Group_1_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Variable__Group_1_2__1__Impl
	rule__Variable__Group_1_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Group_1_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableAccess().getMacroAssignment_1_2_1()); }
	(rule__Variable__MacroAssignment_1_2_1)?
	{ after(grammarAccess.getVariableAccess().getMacroAssignment_1_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Group_1_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Variable__Group_1_2__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Group_1_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableAccess().getVarKeyword_1_2_2()); }
	('var')?
	{ after(grammarAccess.getVariableAccess().getVarKeyword_1_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Variable__Group_1_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Variable__Group_1_3__0__Impl
	rule__Variable__Group_1_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Group_1_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableAccess().getMacroAssignment_1_3_0()); }
	(rule__Variable__MacroAssignment_1_3_0)
	{ after(grammarAccess.getVariableAccess().getMacroAssignment_1_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Group_1_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Variable__Group_1_3__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Group_1_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableAccess().getAlternatives_1_3_1()); }
	(rule__Variable__Alternatives_1_3_1)?
	{ after(grammarAccess.getVariableAccess().getAlternatives_1_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Variable__Group_6__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Variable__Group_6__0__Impl
	rule__Variable__Group_6__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Group_6__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableAccess().getEqualsSignKeyword_6_0()); }
	'='
	{ after(grammarAccess.getVariableAccess().getEqualsSignKeyword_6_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Group_6__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Variable__Group_6__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Group_6__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableAccess().getDefaultValueAssignment_6_1()); }
	(rule__Variable__DefaultValueAssignment_6_1)
	{ after(grammarAccess.getVariableAccess().getDefaultValueAssignment_6_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Variable__Group_7_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Variable__Group_7_0__0__Impl
	rule__Variable__Group_7_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Group_7_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableAccess().getLeftCurlyBracketKeyword_7_0_0()); }
	'{'
	{ after(grammarAccess.getVariableAccess().getLeftCurlyBracketKeyword_7_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Group_7_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Variable__Group_7_0__1__Impl
	rule__Variable__Group_7_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Group_7_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableAccess().getOnWriteActionAssignment_7_0_1()); }
	(rule__Variable__OnWriteActionAssignment_7_0_1)
	{ after(grammarAccess.getVariableAccess().getOnWriteActionAssignment_7_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Group_7_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Variable__Group_7_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Variable__Group_7_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableAccess().getRightCurlyBracketKeyword_7_0_2()); }
	'}'
	{ after(grammarAccess.getVariableAccess().getRightCurlyBracketKeyword_7_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__OnWriteRoutine__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OnWriteRoutine__Group__0__Impl
	rule__OnWriteRoutine__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__OnWriteRoutine__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOnWriteRoutineAccess().getRoutineAction_0()); }
	()
	{ after(grammarAccess.getOnWriteRoutineAccess().getRoutineAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OnWriteRoutine__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OnWriteRoutine__Group__1__Impl
	rule__OnWriteRoutine__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__OnWriteRoutine__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOnWriteRoutineAccess().getOn_writeKeyword_1()); }
	'@on_write'
	{ after(grammarAccess.getOnWriteRoutineAccess().getOn_writeKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OnWriteRoutine__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OnWriteRoutine__Group__2__Impl
	rule__OnWriteRoutine__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__OnWriteRoutine__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOnWriteRoutineAccess().getGroup_2()); }
	(rule__OnWriteRoutine__Group_2__0)?
	{ after(grammarAccess.getOnWriteRoutineAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OnWriteRoutine__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OnWriteRoutine__Group__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__OnWriteRoutine__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOnWriteRoutineAccess().getBodyBlockAssignment_3()); }
	(rule__OnWriteRoutine__BodyBlockAssignment_3)
	{ after(grammarAccess.getOnWriteRoutineAccess().getBodyBlockAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__OnWriteRoutine__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OnWriteRoutine__Group_2__0__Impl
	rule__OnWriteRoutine__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__OnWriteRoutine__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOnWriteRoutineAccess().getLeftParenthesisKeyword_2_0()); }
	'('
	{ after(grammarAccess.getOnWriteRoutineAccess().getLeftParenthesisKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OnWriteRoutine__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OnWriteRoutine__Group_2__1__Impl
	rule__OnWriteRoutine__Group_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__OnWriteRoutine__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOnWriteRoutineAccess().getParameterAssignment_2_1()); }
	(rule__OnWriteRoutine__ParameterAssignment_2_1)
	{ after(grammarAccess.getOnWriteRoutineAccess().getParameterAssignment_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__OnWriteRoutine__Group_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__OnWriteRoutine__Group_2__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__OnWriteRoutine__Group_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getOnWriteRoutineAccess().getRightParenthesisKeyword_2_2()); }
	')'
	{ after(grammarAccess.getOnWriteRoutineAccess().getRightParenthesisKeyword_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__VariableRoutineParameter__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableRoutineParameter__Group__0__Impl
	rule__VariableRoutineParameter__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableRoutineParameter__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableRoutineParameterAccess().getTypeAssignment_0()); }
	(rule__VariableRoutineParameter__TypeAssignment_0)?
	{ after(grammarAccess.getVariableRoutineParameterAccess().getTypeAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableRoutineParameter__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableRoutineParameter__Group__1__Impl
	rule__VariableRoutineParameter__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableRoutineParameter__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableRoutineParameterAccess().getNameAssignment_1()); }
	(rule__VariableRoutineParameter__NameAssignment_1)
	{ after(grammarAccess.getVariableRoutineParameterAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableRoutineParameter__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableRoutineParameter__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableRoutineParameter__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableRoutineParameterAccess().getGroup_2()); }
	(rule__VariableRoutineParameter__Group_2__0)?
	{ after(grammarAccess.getVariableRoutineParameterAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__VariableRoutineParameter__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableRoutineParameter__Group_2__0__Impl
	rule__VariableRoutineParameter__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableRoutineParameter__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableRoutineParameterAccess().getEqualsSignKeyword_2_0()); }
	'='
	{ after(grammarAccess.getVariableRoutineParameterAccess().getEqualsSignKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableRoutineParameter__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableRoutineParameter__Group_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableRoutineParameter__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableRoutineParameterAccess().getDefaultValueAssignment_2_1()); }
	(rule__VariableRoutineParameter__DefaultValueAssignment_2_1)
	{ after(grammarAccess.getVariableRoutineParameterAccess().getDefaultValueAssignment_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__VariablePublic__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariablePublic__Group__0__Impl
	rule__VariablePublic__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePublic__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariablePublicAccess().getModifierAssignment_0()); }
	(rule__VariablePublic__ModifierAssignment_0)?
	{ after(grammarAccess.getVariablePublicAccess().getModifierAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePublic__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariablePublic__Group__1__Impl
	rule__VariablePublic__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePublic__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariablePublicAccess().getUnorderedGroup_1()); }
	(rule__VariablePublic__UnorderedGroup_1)?
	{ after(grammarAccess.getVariablePublicAccess().getUnorderedGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePublic__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariablePublic__Group__2__Impl
	rule__VariablePublic__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePublic__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariablePublicAccess().getVisibilityAssignment_2()); }
	(rule__VariablePublic__VisibilityAssignment_2)
	{ after(grammarAccess.getVariablePublicAccess().getVisibilityAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePublic__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariablePublic__Group__3__Impl
	rule__VariablePublic__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePublic__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariablePublicAccess().getTypeAssignment_3()); }
	(rule__VariablePublic__TypeAssignment_3)
	{ after(grammarAccess.getVariablePublicAccess().getTypeAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePublic__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariablePublic__Group__4__Impl
	rule__VariablePublic__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePublic__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariablePublicAccess().getReferenceAssignment_4()); }
	(rule__VariablePublic__ReferenceAssignment_4)?
	{ after(grammarAccess.getVariablePublicAccess().getReferenceAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePublic__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariablePublic__Group__5__Impl
	rule__VariablePublic__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePublic__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariablePublicAccess().getNameAssignment_5()); }
	(rule__VariablePublic__NameAssignment_5)
	{ after(grammarAccess.getVariablePublicAccess().getNameAssignment_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePublic__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariablePublic__Group__6__Impl
	rule__VariablePublic__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePublic__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariablePublicAccess().getUnrestrictedNameAssignment_6()); }
	(rule__VariablePublic__UnrestrictedNameAssignment_6)?
	{ after(grammarAccess.getVariablePublicAccess().getUnrestrictedNameAssignment_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePublic__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariablePublic__Group__7__Impl
	rule__VariablePublic__Group__8
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePublic__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariablePublicAccess().getGroup_7()); }
	(rule__VariablePublic__Group_7__0)?
	{ after(grammarAccess.getVariablePublicAccess().getGroup_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePublic__Group__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariablePublic__Group__8__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePublic__Group__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariablePublicAccess().getAlternatives_8()); }
	(rule__VariablePublic__Alternatives_8)
	{ after(grammarAccess.getVariablePublicAccess().getAlternatives_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__VariablePublic__Group_7__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariablePublic__Group_7__0__Impl
	rule__VariablePublic__Group_7__1
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePublic__Group_7__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariablePublicAccess().getEqualsSignKeyword_7_0()); }
	'='
	{ after(grammarAccess.getVariablePublicAccess().getEqualsSignKeyword_7_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePublic__Group_7__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariablePublic__Group_7__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePublic__Group_7__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariablePublicAccess().getDefaultValueAssignment_7_1()); }
	(rule__VariablePublic__DefaultValueAssignment_7_1)
	{ after(grammarAccess.getVariablePublicAccess().getDefaultValueAssignment_7_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__VariablePublic__Group_8_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariablePublic__Group_8_0__0__Impl
	rule__VariablePublic__Group_8_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePublic__Group_8_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariablePublicAccess().getLeftCurlyBracketKeyword_8_0_0()); }
	'{'
	{ after(grammarAccess.getVariablePublicAccess().getLeftCurlyBracketKeyword_8_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePublic__Group_8_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariablePublic__Group_8_0__1__Impl
	rule__VariablePublic__Group_8_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePublic__Group_8_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariablePublicAccess().getOnWriteActionAssignment_8_0_1()); }
	(rule__VariablePublic__OnWriteActionAssignment_8_0_1)
	{ after(grammarAccess.getVariablePublicAccess().getOnWriteActionAssignment_8_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePublic__Group_8_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariablePublic__Group_8_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePublic__Group_8_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariablePublicAccess().getRightCurlyBracketKeyword_8_0_2()); }
	'}'
	{ after(grammarAccess.getVariablePublicAccess().getRightCurlyBracketKeyword_8_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__VariableProtected__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableProtected__Group__0__Impl
	rule__VariableProtected__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableProtected__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableProtectedAccess().getModifierAssignment_0()); }
	(rule__VariableProtected__ModifierAssignment_0)?
	{ after(grammarAccess.getVariableProtectedAccess().getModifierAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableProtected__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableProtected__Group__1__Impl
	rule__VariableProtected__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableProtected__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableProtectedAccess().getUnorderedGroup_1()); }
	(rule__VariableProtected__UnorderedGroup_1)?
	{ after(grammarAccess.getVariableProtectedAccess().getUnorderedGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableProtected__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableProtected__Group__2__Impl
	rule__VariableProtected__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableProtected__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableProtectedAccess().getVisibilityAssignment_2()); }
	(rule__VariableProtected__VisibilityAssignment_2)
	{ after(grammarAccess.getVariableProtectedAccess().getVisibilityAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableProtected__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableProtected__Group__3__Impl
	rule__VariableProtected__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableProtected__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableProtectedAccess().getTypeAssignment_3()); }
	(rule__VariableProtected__TypeAssignment_3)
	{ after(grammarAccess.getVariableProtectedAccess().getTypeAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableProtected__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableProtected__Group__4__Impl
	rule__VariableProtected__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableProtected__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableProtectedAccess().getReferenceAssignment_4()); }
	(rule__VariableProtected__ReferenceAssignment_4)?
	{ after(grammarAccess.getVariableProtectedAccess().getReferenceAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableProtected__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableProtected__Group__5__Impl
	rule__VariableProtected__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableProtected__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableProtectedAccess().getNameAssignment_5()); }
	(rule__VariableProtected__NameAssignment_5)
	{ after(grammarAccess.getVariableProtectedAccess().getNameAssignment_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableProtected__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableProtected__Group__6__Impl
	rule__VariableProtected__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableProtected__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableProtectedAccess().getUnrestrictedNameAssignment_6()); }
	(rule__VariableProtected__UnrestrictedNameAssignment_6)?
	{ after(grammarAccess.getVariableProtectedAccess().getUnrestrictedNameAssignment_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableProtected__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableProtected__Group__7__Impl
	rule__VariableProtected__Group__8
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableProtected__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableProtectedAccess().getGroup_7()); }
	(rule__VariableProtected__Group_7__0)?
	{ after(grammarAccess.getVariableProtectedAccess().getGroup_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableProtected__Group__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableProtected__Group__8__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableProtected__Group__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableProtectedAccess().getAlternatives_8()); }
	(rule__VariableProtected__Alternatives_8)
	{ after(grammarAccess.getVariableProtectedAccess().getAlternatives_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__VariableProtected__Group_7__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableProtected__Group_7__0__Impl
	rule__VariableProtected__Group_7__1
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableProtected__Group_7__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableProtectedAccess().getEqualsSignKeyword_7_0()); }
	'='
	{ after(grammarAccess.getVariableProtectedAccess().getEqualsSignKeyword_7_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableProtected__Group_7__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableProtected__Group_7__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableProtected__Group_7__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableProtectedAccess().getDefaultValueAssignment_7_1()); }
	(rule__VariableProtected__DefaultValueAssignment_7_1)
	{ after(grammarAccess.getVariableProtectedAccess().getDefaultValueAssignment_7_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__VariableProtected__Group_8_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableProtected__Group_8_0__0__Impl
	rule__VariableProtected__Group_8_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableProtected__Group_8_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableProtectedAccess().getLeftCurlyBracketKeyword_8_0_0()); }
	'{'
	{ after(grammarAccess.getVariableProtectedAccess().getLeftCurlyBracketKeyword_8_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableProtected__Group_8_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableProtected__Group_8_0__1__Impl
	rule__VariableProtected__Group_8_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableProtected__Group_8_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableProtectedAccess().getOnWriteActionAssignment_8_0_1()); }
	(rule__VariableProtected__OnWriteActionAssignment_8_0_1)
	{ after(grammarAccess.getVariableProtectedAccess().getOnWriteActionAssignment_8_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableProtected__Group_8_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariableProtected__Group_8_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__VariableProtected__Group_8_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariableProtectedAccess().getRightCurlyBracketKeyword_8_0_2()); }
	'}'
	{ after(grammarAccess.getVariableProtectedAccess().getRightCurlyBracketKeyword_8_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__VariablePrivate__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariablePrivate__Group__0__Impl
	rule__VariablePrivate__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePrivate__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariablePrivateAccess().getModifierAssignment_0()); }
	(rule__VariablePrivate__ModifierAssignment_0)?
	{ after(grammarAccess.getVariablePrivateAccess().getModifierAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePrivate__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariablePrivate__Group__1__Impl
	rule__VariablePrivate__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePrivate__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariablePrivateAccess().getUnorderedGroup_1()); }
	(rule__VariablePrivate__UnorderedGroup_1)?
	{ after(grammarAccess.getVariablePrivateAccess().getUnorderedGroup_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePrivate__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariablePrivate__Group__2__Impl
	rule__VariablePrivate__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePrivate__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariablePrivateAccess().getVisibilityAssignment_2()); }
	(rule__VariablePrivate__VisibilityAssignment_2)
	{ after(grammarAccess.getVariablePrivateAccess().getVisibilityAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePrivate__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariablePrivate__Group__3__Impl
	rule__VariablePrivate__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePrivate__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariablePrivateAccess().getTypeAssignment_3()); }
	(rule__VariablePrivate__TypeAssignment_3)
	{ after(grammarAccess.getVariablePrivateAccess().getTypeAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePrivate__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariablePrivate__Group__4__Impl
	rule__VariablePrivate__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePrivate__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariablePrivateAccess().getReferenceAssignment_4()); }
	(rule__VariablePrivate__ReferenceAssignment_4)?
	{ after(grammarAccess.getVariablePrivateAccess().getReferenceAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePrivate__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariablePrivate__Group__5__Impl
	rule__VariablePrivate__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePrivate__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariablePrivateAccess().getNameAssignment_5()); }
	(rule__VariablePrivate__NameAssignment_5)
	{ after(grammarAccess.getVariablePrivateAccess().getNameAssignment_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePrivate__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariablePrivate__Group__6__Impl
	rule__VariablePrivate__Group__7
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePrivate__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariablePrivateAccess().getUnrestrictedNameAssignment_6()); }
	(rule__VariablePrivate__UnrestrictedNameAssignment_6)?
	{ after(grammarAccess.getVariablePrivateAccess().getUnrestrictedNameAssignment_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePrivate__Group__7
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariablePrivate__Group__7__Impl
	rule__VariablePrivate__Group__8
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePrivate__Group__7__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariablePrivateAccess().getGroup_7()); }
	(rule__VariablePrivate__Group_7__0)?
	{ after(grammarAccess.getVariablePrivateAccess().getGroup_7()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePrivate__Group__8
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariablePrivate__Group__8__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePrivate__Group__8__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariablePrivateAccess().getAlternatives_8()); }
	(rule__VariablePrivate__Alternatives_8)
	{ after(grammarAccess.getVariablePrivateAccess().getAlternatives_8()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__VariablePrivate__Group_7__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariablePrivate__Group_7__0__Impl
	rule__VariablePrivate__Group_7__1
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePrivate__Group_7__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariablePrivateAccess().getEqualsSignKeyword_7_0()); }
	'='
	{ after(grammarAccess.getVariablePrivateAccess().getEqualsSignKeyword_7_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePrivate__Group_7__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariablePrivate__Group_7__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePrivate__Group_7__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariablePrivateAccess().getDefaultValueAssignment_7_1()); }
	(rule__VariablePrivate__DefaultValueAssignment_7_1)
	{ after(grammarAccess.getVariablePrivateAccess().getDefaultValueAssignment_7_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__VariablePrivate__Group_8_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariablePrivate__Group_8_0__0__Impl
	rule__VariablePrivate__Group_8_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePrivate__Group_8_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariablePrivateAccess().getLeftCurlyBracketKeyword_8_0_0()); }
	'{'
	{ after(grammarAccess.getVariablePrivateAccess().getLeftCurlyBracketKeyword_8_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePrivate__Group_8_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariablePrivate__Group_8_0__1__Impl
	rule__VariablePrivate__Group_8_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePrivate__Group_8_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariablePrivateAccess().getOnWriteActionAssignment_8_0_1()); }
	(rule__VariablePrivate__OnWriteActionAssignment_8_0_1)
	{ after(grammarAccess.getVariablePrivateAccess().getOnWriteActionAssignment_8_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePrivate__Group_8_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__VariablePrivate__Group_8_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__VariablePrivate__Group_8_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getVariablePrivateAccess().getRightCurlyBracketKeyword_8_0_2()); }
	'}'
	{ after(grammarAccess.getVariablePrivateAccess().getRightCurlyBracketKeyword_8_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FunctionalParameterSet__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionalParameterSet__Group__0__Impl
	rule__FunctionalParameterSet__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionalParameterSet__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionalParameterSetAccess().getParameterSetAction_0()); }
	()
	{ after(grammarAccess.getFunctionalParameterSetAccess().getParameterSetAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionalParameterSet__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionalParameterSet__Group__1__Impl
	rule__FunctionalParameterSet__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionalParameterSet__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionalParameterSetAccess().getParameterAssignment_1()); }
	(rule__FunctionalParameterSet__ParameterAssignment_1)
	{ after(grammarAccess.getFunctionalParameterSetAccess().getParameterAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionalParameterSet__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionalParameterSet__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionalParameterSet__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionalParameterSetAccess().getGroup_2()); }
	(rule__FunctionalParameterSet__Group_2__0)*
	{ after(grammarAccess.getFunctionalParameterSetAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FunctionalParameterSet__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionalParameterSet__Group_2__0__Impl
	rule__FunctionalParameterSet__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionalParameterSet__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionalParameterSetAccess().getCommaKeyword_2_0()); }
	','
	{ after(grammarAccess.getFunctionalParameterSetAccess().getCommaKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionalParameterSet__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionalParameterSet__Group_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionalParameterSet__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionalParameterSetAccess().getParameterAssignment_2_1()); }
	(rule__FunctionalParameterSet__ParameterAssignment_2_1)
	{ after(grammarAccess.getFunctionalParameterSetAccess().getParameterAssignment_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FunctionalParameter__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionalParameter__Group__0__Impl
	rule__FunctionalParameter__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionalParameter__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionalParameterAccess().getParameterAction_0()); }
	()
	{ after(grammarAccess.getFunctionalParameterAccess().getParameterAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionalParameter__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionalParameter__Group__1__Impl
	rule__FunctionalParameter__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionalParameter__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionalParameterAccess().getDirectionAssignment_1()); }
	(rule__FunctionalParameter__DirectionAssignment_1)?
	{ after(grammarAccess.getFunctionalParameterAccess().getDirectionAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionalParameter__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionalParameter__Group__2__Impl
	rule__FunctionalParameter__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionalParameter__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionalParameterAccess().getTypeAssignment_2()); }
	(rule__FunctionalParameter__TypeAssignment_2)
	{ after(grammarAccess.getFunctionalParameterAccess().getTypeAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionalParameter__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionalParameter__Group__3__Impl
	rule__FunctionalParameter__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionalParameter__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionalParameterAccess().getNameAssignment_3()); }
	(rule__FunctionalParameter__NameAssignment_3)
	{ after(grammarAccess.getFunctionalParameterAccess().getNameAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionalParameter__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionalParameter__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionalParameter__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionalParameterAccess().getGroup_4()); }
	(rule__FunctionalParameter__Group_4__0)?
	{ after(grammarAccess.getFunctionalParameterAccess().getGroup_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FunctionalParameter__Group_4__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionalParameter__Group_4__0__Impl
	rule__FunctionalParameter__Group_4__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionalParameter__Group_4__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionalParameterAccess().getEqualsSignKeyword_4_0()); }
	'='
	{ after(grammarAccess.getFunctionalParameterAccess().getEqualsSignKeyword_4_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionalParameter__Group_4__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FunctionalParameter__Group_4__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FunctionalParameter__Group_4__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFunctionalParameterAccess().getDefaultValueAssignment_4_1()); }
	(rule__FunctionalParameter__DefaultValueAssignment_4_1)
	{ after(grammarAccess.getFunctionalParameterAccess().getDefaultValueAssignment_4_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FormalParameterSet__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FormalParameterSet__Group__0__Impl
	rule__FormalParameterSet__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FormalParameterSet__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormalParameterSetAccess().getParameterSetAction_0()); }
	()
	{ after(grammarAccess.getFormalParameterSetAccess().getParameterSetAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FormalParameterSet__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FormalParameterSet__Group__1__Impl
	rule__FormalParameterSet__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__FormalParameterSet__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormalParameterSetAccess().getParameterAssignment_1()); }
	(rule__FormalParameterSet__ParameterAssignment_1)
	{ after(grammarAccess.getFormalParameterSetAccess().getParameterAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FormalParameterSet__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FormalParameterSet__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FormalParameterSet__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormalParameterSetAccess().getGroup_2()); }
	(rule__FormalParameterSet__Group_2__0)*
	{ after(grammarAccess.getFormalParameterSetAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FormalParameterSet__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FormalParameterSet__Group_2__0__Impl
	rule__FormalParameterSet__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FormalParameterSet__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormalParameterSetAccess().getCommaKeyword_2_0()); }
	','
	{ after(grammarAccess.getFormalParameterSetAccess().getCommaKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FormalParameterSet__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FormalParameterSet__Group_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FormalParameterSet__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormalParameterSetAccess().getParameterAssignment_2_1()); }
	(rule__FormalParameterSet__ParameterAssignment_2_1)
	{ after(grammarAccess.getFormalParameterSetAccess().getParameterAssignment_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FormalParameter__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FormalParameter__Group__0__Impl
	rule__FormalParameter__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FormalParameter__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormalParameterAccess().getParameterAction_0()); }
	()
	{ after(grammarAccess.getFormalParameterAccess().getParameterAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FormalParameter__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FormalParameter__Group__1__Impl
	rule__FormalParameter__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__FormalParameter__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormalParameterAccess().getDirectionAssignment_1()); }
	(rule__FormalParameter__DirectionAssignment_1)?
	{ after(grammarAccess.getFormalParameterAccess().getDirectionAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FormalParameter__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FormalParameter__Group__2__Impl
	rule__FormalParameter__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__FormalParameter__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormalParameterAccess().getTypeAssignment_2()); }
	(rule__FormalParameter__TypeAssignment_2)
	{ after(grammarAccess.getFormalParameterAccess().getTypeAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FormalParameter__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FormalParameter__Group__3__Impl
	rule__FormalParameter__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__FormalParameter__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormalParameterAccess().getNameAssignment_3()); }
	(rule__FormalParameter__NameAssignment_3)?
	{ after(grammarAccess.getFormalParameterAccess().getNameAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FormalParameter__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FormalParameter__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FormalParameter__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormalParameterAccess().getGroup_4()); }
	(rule__FormalParameter__Group_4__0)?
	{ after(grammarAccess.getFormalParameterAccess().getGroup_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__FormalParameter__Group_4__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FormalParameter__Group_4__0__Impl
	rule__FormalParameter__Group_4__1
;
finally {
	restoreStackSize(stackSize);
}

rule__FormalParameter__Group_4__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormalParameterAccess().getEqualsSignKeyword_4_0()); }
	'='
	{ after(grammarAccess.getFormalParameterAccess().getEqualsSignKeyword_4_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__FormalParameter__Group_4__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__FormalParameter__Group_4__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__FormalParameter__Group_4__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getFormalParameterAccess().getDefaultValueAssignment_4_1()); }
	(rule__FormalParameter__DefaultValueAssignment_4_1)
	{ after(grammarAccess.getFormalParameterAccess().getDefaultValueAssignment_4_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ParameterInput__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterInput__Group__0__Impl
	rule__ParameterInput__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterInput__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterInputAccess().getDirectionAssignment_0()); }
	(rule__ParameterInput__DirectionAssignment_0)
	{ after(grammarAccess.getParameterInputAccess().getDirectionAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterInput__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterInput__Group__1__Impl
	rule__ParameterInput__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterInput__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterInputAccess().getTypeAssignment_1()); }
	(rule__ParameterInput__TypeAssignment_1)
	{ after(grammarAccess.getParameterInputAccess().getTypeAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterInput__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterInput__Group__2__Impl
	rule__ParameterInput__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterInput__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterInputAccess().getNameAssignment_2()); }
	(rule__ParameterInput__NameAssignment_2)
	{ after(grammarAccess.getParameterInputAccess().getNameAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterInput__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterInput__Group__3__Impl
	rule__ParameterInput__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterInput__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterInputAccess().getUnrestrictedNameAssignment_3()); }
	(rule__ParameterInput__UnrestrictedNameAssignment_3)?
	{ after(grammarAccess.getParameterInputAccess().getUnrestrictedNameAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterInput__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterInput__Group__4__Impl
	rule__ParameterInput__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterInput__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterInputAccess().getGroup_4()); }
	(rule__ParameterInput__Group_4__0)?
	{ after(grammarAccess.getParameterInputAccess().getGroup_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterInput__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterInput__Group__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterInput__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterInputAccess().getSemicolonKeyword_5()); }
	';'
	{ after(grammarAccess.getParameterInputAccess().getSemicolonKeyword_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ParameterInput__Group_4__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterInput__Group_4__0__Impl
	rule__ParameterInput__Group_4__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterInput__Group_4__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterInputAccess().getEqualsSignKeyword_4_0()); }
	'='
	{ after(grammarAccess.getParameterInputAccess().getEqualsSignKeyword_4_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterInput__Group_4__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterInput__Group_4__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterInput__Group_4__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterInputAccess().getDefaultValueAssignment_4_1()); }
	(rule__ParameterInput__DefaultValueAssignment_4_1)
	{ after(grammarAccess.getParameterInputAccess().getDefaultValueAssignment_4_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ParameterInout__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterInout__Group__0__Impl
	rule__ParameterInout__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterInout__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterInoutAccess().getDirectionAssignment_0()); }
	(rule__ParameterInout__DirectionAssignment_0)
	{ after(grammarAccess.getParameterInoutAccess().getDirectionAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterInout__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterInout__Group__1__Impl
	rule__ParameterInout__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterInout__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterInoutAccess().getTypeAssignment_1()); }
	(rule__ParameterInout__TypeAssignment_1)
	{ after(grammarAccess.getParameterInoutAccess().getTypeAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterInout__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterInout__Group__2__Impl
	rule__ParameterInout__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterInout__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterInoutAccess().getNameAssignment_2()); }
	(rule__ParameterInout__NameAssignment_2)
	{ after(grammarAccess.getParameterInoutAccess().getNameAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterInout__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterInout__Group__3__Impl
	rule__ParameterInout__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterInout__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterInoutAccess().getUnrestrictedNameAssignment_3()); }
	(rule__ParameterInout__UnrestrictedNameAssignment_3)?
	{ after(grammarAccess.getParameterInoutAccess().getUnrestrictedNameAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterInout__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterInout__Group__4__Impl
	rule__ParameterInout__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterInout__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterInoutAccess().getGroup_4()); }
	(rule__ParameterInout__Group_4__0)?
	{ after(grammarAccess.getParameterInoutAccess().getGroup_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterInout__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterInout__Group__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterInout__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterInoutAccess().getSemicolonKeyword_5()); }
	';'
	{ after(grammarAccess.getParameterInoutAccess().getSemicolonKeyword_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ParameterInout__Group_4__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterInout__Group_4__0__Impl
	rule__ParameterInout__Group_4__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterInout__Group_4__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterInoutAccess().getEqualsSignKeyword_4_0()); }
	'='
	{ after(grammarAccess.getParameterInoutAccess().getEqualsSignKeyword_4_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterInout__Group_4__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterInout__Group_4__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterInout__Group_4__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterInoutAccess().getDefaultValueAssignment_4_1()); }
	(rule__ParameterInout__DefaultValueAssignment_4_1)
	{ after(grammarAccess.getParameterInoutAccess().getDefaultValueAssignment_4_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ParameterOutput__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterOutput__Group__0__Impl
	rule__ParameterOutput__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterOutput__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterOutputAccess().getDirectionAssignment_0()); }
	(rule__ParameterOutput__DirectionAssignment_0)
	{ after(grammarAccess.getParameterOutputAccess().getDirectionAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterOutput__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterOutput__Group__1__Impl
	rule__ParameterOutput__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterOutput__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterOutputAccess().getTypeAssignment_1()); }
	(rule__ParameterOutput__TypeAssignment_1)
	{ after(grammarAccess.getParameterOutputAccess().getTypeAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterOutput__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterOutput__Group__2__Impl
	rule__ParameterOutput__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterOutput__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterOutputAccess().getNameAssignment_2()); }
	(rule__ParameterOutput__NameAssignment_2)
	{ after(grammarAccess.getParameterOutputAccess().getNameAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterOutput__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterOutput__Group__3__Impl
	rule__ParameterOutput__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterOutput__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterOutputAccess().getUnrestrictedNameAssignment_3()); }
	(rule__ParameterOutput__UnrestrictedNameAssignment_3)?
	{ after(grammarAccess.getParameterOutputAccess().getUnrestrictedNameAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterOutput__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterOutput__Group__4__Impl
	rule__ParameterOutput__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterOutput__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterOutputAccess().getGroup_4()); }
	(rule__ParameterOutput__Group_4__0)?
	{ after(grammarAccess.getParameterOutputAccess().getGroup_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterOutput__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterOutput__Group__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterOutput__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterOutputAccess().getSemicolonKeyword_5()); }
	';'
	{ after(grammarAccess.getParameterOutputAccess().getSemicolonKeyword_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ParameterOutput__Group_4__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterOutput__Group_4__0__Impl
	rule__ParameterOutput__Group_4__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterOutput__Group_4__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterOutputAccess().getEqualsSignKeyword_4_0()); }
	'='
	{ after(grammarAccess.getParameterOutputAccess().getEqualsSignKeyword_4_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterOutput__Group_4__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterOutput__Group_4__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterOutput__Group_4__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterOutputAccess().getDefaultValueAssignment_4_1()); }
	(rule__ParameterOutput__DefaultValueAssignment_4_1)
	{ after(grammarAccess.getParameterOutputAccess().getDefaultValueAssignment_4_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ParameterReturn__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterReturn__Group__0__Impl
	rule__ParameterReturn__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterReturn__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterReturnAccess().getDirectionAssignment_0()); }
	(rule__ParameterReturn__DirectionAssignment_0)
	{ after(grammarAccess.getParameterReturnAccess().getDirectionAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterReturn__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterReturn__Group__1__Impl
	rule__ParameterReturn__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterReturn__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterReturnAccess().getTypeAssignment_1()); }
	(rule__ParameterReturn__TypeAssignment_1)
	{ after(grammarAccess.getParameterReturnAccess().getTypeAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterReturn__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterReturn__Group__2__Impl
	rule__ParameterReturn__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterReturn__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterReturnAccess().getNameAssignment_2()); }
	(rule__ParameterReturn__NameAssignment_2)
	{ after(grammarAccess.getParameterReturnAccess().getNameAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterReturn__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterReturn__Group__3__Impl
	rule__ParameterReturn__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterReturn__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterReturnAccess().getUnrestrictedNameAssignment_3()); }
	(rule__ParameterReturn__UnrestrictedNameAssignment_3)?
	{ after(grammarAccess.getParameterReturnAccess().getUnrestrictedNameAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterReturn__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterReturn__Group__4__Impl
	rule__ParameterReturn__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterReturn__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterReturnAccess().getGroup_4()); }
	(rule__ParameterReturn__Group_4__0)?
	{ after(grammarAccess.getParameterReturnAccess().getGroup_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterReturn__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterReturn__Group__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterReturn__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterReturnAccess().getSemicolonKeyword_5()); }
	';'
	{ after(grammarAccess.getParameterReturnAccess().getSemicolonKeyword_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ParameterReturn__Group_4__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterReturn__Group_4__0__Impl
	rule__ParameterReturn__Group_4__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterReturn__Group_4__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterReturnAccess().getEqualsSignKeyword_4_0()); }
	'='
	{ after(grammarAccess.getParameterReturnAccess().getEqualsSignKeyword_4_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterReturn__Group_4__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ParameterReturn__Group_4__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ParameterReturn__Group_4__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getParameterReturnAccess().getDefaultValueAssignment_4_1()); }
	(rule__ParameterReturn__DefaultValueAssignment_4_1)
	{ after(grammarAccess.getParameterReturnAccess().getDefaultValueAssignment_4_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BufferContainerType__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BufferContainerType__Group__0__Impl
	rule__BufferContainerType__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferContainerType__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBufferContainerTypeAccess().getCollectionTypeAction_0()); }
	()
	{ after(grammarAccess.getBufferContainerTypeAccess().getCollectionTypeAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferContainerType__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BufferContainerType__Group__1__Impl
	rule__BufferContainerType__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferContainerType__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBufferContainerTypeAccess().getContainerAssignment_1()); }
	(rule__BufferContainerType__ContainerAssignment_1)
	{ after(grammarAccess.getBufferContainerTypeAccess().getContainerAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferContainerType__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BufferContainerType__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferContainerType__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBufferContainerTypeAccess().getGroup_2()); }
	(rule__BufferContainerType__Group_2__0)?
	{ after(grammarAccess.getBufferContainerTypeAccess().getGroup_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BufferContainerType__Group_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BufferContainerType__Group_2__0__Impl
	rule__BufferContainerType__Group_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferContainerType__Group_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBufferContainerTypeAccess().getLessThanSignKeyword_2_0()); }
	'<'
	{ after(grammarAccess.getBufferContainerTypeAccess().getLessThanSignKeyword_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferContainerType__Group_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BufferContainerType__Group_2__1__Impl
	rule__BufferContainerType__Group_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferContainerType__Group_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBufferContainerTypeAccess().getAlternatives_2_1()); }
	(rule__BufferContainerType__Alternatives_2_1)?
	{ after(grammarAccess.getBufferContainerTypeAccess().getAlternatives_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferContainerType__Group_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BufferContainerType__Group_2__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferContainerType__Group_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBufferContainerTypeAccess().getGreaterThanSignKeyword_2_2()); }
	'>'
	{ after(grammarAccess.getBufferContainerTypeAccess().getGreaterThanSignKeyword_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Buffer__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Buffer__Group__0__Impl
	rule__Buffer__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Buffer__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBufferAccess().getUnorderedGroup_0()); }
	(rule__Buffer__UnorderedGroup_0)
	{ after(grammarAccess.getBufferAccess().getUnorderedGroup_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Buffer__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Buffer__Group__1__Impl
	rule__Buffer__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Buffer__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBufferAccess().getBufferKeyword_1()); }
	'buffer'
	{ after(grammarAccess.getBufferAccess().getBufferKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Buffer__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Buffer__Group__2__Impl
	rule__Buffer__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Buffer__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBufferAccess().getTypeAssignment_2()); }
	(rule__Buffer__TypeAssignment_2)
	{ after(grammarAccess.getBufferAccess().getTypeAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Buffer__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Buffer__Group__3__Impl
	rule__Buffer__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__Buffer__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBufferAccess().getNameAssignment_3()); }
	(rule__Buffer__NameAssignment_3)
	{ after(grammarAccess.getBufferAccess().getNameAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Buffer__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Buffer__Group__4__Impl
	rule__Buffer__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__Buffer__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBufferAccess().getUnrestrictedNameAssignment_4()); }
	(rule__Buffer__UnrestrictedNameAssignment_4)?
	{ after(grammarAccess.getBufferAccess().getUnrestrictedNameAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Buffer__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Buffer__Group__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Buffer__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBufferAccess().getSemicolonKeyword_5()); }
	';'
	{ after(grammarAccess.getBufferAccess().getSemicolonKeyword_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BufferPublic__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BufferPublic__Group__0__Impl
	rule__BufferPublic__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferPublic__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBufferPublicAccess().getModifierAssignment_0()); }
	(rule__BufferPublic__ModifierAssignment_0)?
	{ after(grammarAccess.getBufferPublicAccess().getModifierAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferPublic__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BufferPublic__Group__1__Impl
	rule__BufferPublic__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferPublic__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBufferPublicAccess().getVisibilityAssignment_1()); }
	(rule__BufferPublic__VisibilityAssignment_1)
	{ after(grammarAccess.getBufferPublicAccess().getVisibilityAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferPublic__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BufferPublic__Group__2__Impl
	rule__BufferPublic__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferPublic__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBufferPublicAccess().getTypeAssignment_2()); }
	(rule__BufferPublic__TypeAssignment_2)
	{ after(grammarAccess.getBufferPublicAccess().getTypeAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferPublic__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BufferPublic__Group__3__Impl
	rule__BufferPublic__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferPublic__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBufferPublicAccess().getNameAssignment_3()); }
	(rule__BufferPublic__NameAssignment_3)
	{ after(grammarAccess.getBufferPublicAccess().getNameAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferPublic__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BufferPublic__Group__4__Impl
	rule__BufferPublic__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferPublic__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBufferPublicAccess().getUnrestrictedNameAssignment_4()); }
	(rule__BufferPublic__UnrestrictedNameAssignment_4)?
	{ after(grammarAccess.getBufferPublicAccess().getUnrestrictedNameAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferPublic__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BufferPublic__Group__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferPublic__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBufferPublicAccess().getSemicolonKeyword_5()); }
	';'
	{ after(grammarAccess.getBufferPublicAccess().getSemicolonKeyword_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BufferProtected__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BufferProtected__Group__0__Impl
	rule__BufferProtected__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferProtected__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBufferProtectedAccess().getModifierAssignment_0()); }
	(rule__BufferProtected__ModifierAssignment_0)?
	{ after(grammarAccess.getBufferProtectedAccess().getModifierAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferProtected__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BufferProtected__Group__1__Impl
	rule__BufferProtected__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferProtected__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBufferProtectedAccess().getVisibilityAssignment_1()); }
	(rule__BufferProtected__VisibilityAssignment_1)
	{ after(grammarAccess.getBufferProtectedAccess().getVisibilityAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferProtected__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BufferProtected__Group__2__Impl
	rule__BufferProtected__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferProtected__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBufferProtectedAccess().getTypeAssignment_2()); }
	(rule__BufferProtected__TypeAssignment_2)
	{ after(grammarAccess.getBufferProtectedAccess().getTypeAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferProtected__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BufferProtected__Group__3__Impl
	rule__BufferProtected__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferProtected__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBufferProtectedAccess().getNameAssignment_3()); }
	(rule__BufferProtected__NameAssignment_3)
	{ after(grammarAccess.getBufferProtectedAccess().getNameAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferProtected__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BufferProtected__Group__4__Impl
	rule__BufferProtected__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferProtected__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBufferProtectedAccess().getUnrestrictedNameAssignment_4()); }
	(rule__BufferProtected__UnrestrictedNameAssignment_4)?
	{ after(grammarAccess.getBufferProtectedAccess().getUnrestrictedNameAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferProtected__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BufferProtected__Group__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferProtected__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBufferProtectedAccess().getSemicolonKeyword_5()); }
	';'
	{ after(grammarAccess.getBufferProtectedAccess().getSemicolonKeyword_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__BufferPrivate__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BufferPrivate__Group__0__Impl
	rule__BufferPrivate__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferPrivate__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBufferPrivateAccess().getModifierAssignment_0()); }
	(rule__BufferPrivate__ModifierAssignment_0)?
	{ after(grammarAccess.getBufferPrivateAccess().getModifierAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferPrivate__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BufferPrivate__Group__1__Impl
	rule__BufferPrivate__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferPrivate__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBufferPrivateAccess().getVisibilityAssignment_1()); }
	(rule__BufferPrivate__VisibilityAssignment_1)
	{ after(grammarAccess.getBufferPrivateAccess().getVisibilityAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferPrivate__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BufferPrivate__Group__2__Impl
	rule__BufferPrivate__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferPrivate__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBufferPrivateAccess().getTypeAssignment_2()); }
	(rule__BufferPrivate__TypeAssignment_2)
	{ after(grammarAccess.getBufferPrivateAccess().getTypeAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferPrivate__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BufferPrivate__Group__3__Impl
	rule__BufferPrivate__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferPrivate__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBufferPrivateAccess().getNameAssignment_3()); }
	(rule__BufferPrivate__NameAssignment_3)
	{ after(grammarAccess.getBufferPrivateAccess().getNameAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferPrivate__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BufferPrivate__Group__4__Impl
	rule__BufferPrivate__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferPrivate__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBufferPrivateAccess().getUnrestrictedNameAssignment_4()); }
	(rule__BufferPrivate__UnrestrictedNameAssignment_4)?
	{ after(grammarAccess.getBufferPrivateAccess().getUnrestrictedNameAssignment_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferPrivate__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__BufferPrivate__Group__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__BufferPrivate__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getBufferPrivateAccess().getSemicolonKeyword_5()); }
	';'
	{ after(grammarAccess.getBufferPrivateAccess().getSemicolonKeyword_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Port__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Port__Group__0__Impl
	rule__Port__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Port__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortAccess().getVisibilityAssignment_0()); }
	(rule__Port__VisibilityAssignment_0)?
	{ after(grammarAccess.getPortAccess().getVisibilityAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Port__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Port__Group__1__Impl
	rule__Port__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Port__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortAccess().getAlternatives_1()); }
	(rule__Port__Alternatives_1)
	{ after(grammarAccess.getPortAccess().getAlternatives_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Port__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Port__Group__2__Impl
	rule__Port__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Port__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortAccess().getNameAssignment_2()); }
	(rule__Port__NameAssignment_2)
	{ after(grammarAccess.getPortAccess().getNameAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Port__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Port__Group__3__Impl
	rule__Port__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__Port__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortAccess().getUnrestrictedNameAssignment_3()); }
	(rule__Port__UnrestrictedNameAssignment_3)?
	{ after(grammarAccess.getPortAccess().getUnrestrictedNameAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Port__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Port__Group__4__Impl
	rule__Port__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__Port__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortAccess().getGroup_4()); }
	(rule__Port__Group_4__0)?
	{ after(grammarAccess.getPortAccess().getGroup_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Port__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Port__Group__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Port__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortAccess().getSemicolonKeyword_5()); }
	';'
	{ after(grammarAccess.getPortAccess().getSemicolonKeyword_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Port__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Port__Group_1_0__0__Impl
	rule__Port__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Port__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortAccess().getDirectionAssignment_1_0_0()); }
	(rule__Port__DirectionAssignment_1_0_0)
	{ after(grammarAccess.getPortAccess().getDirectionAssignment_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Port__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Port__Group_1_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Port__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortAccess().getPortKeyword_1_0_1()); }
	'port'
	{ after(grammarAccess.getPortAccess().getPortKeyword_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Port__Group_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Port__Group_1_1__0__Impl
	rule__Port__Group_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Port__Group_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortAccess().getPortKeyword_1_1_0()); }
	'port'
	{ after(grammarAccess.getPortAccess().getPortKeyword_1_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Port__Group_1_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Port__Group_1_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Port__Group_1_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortAccess().getDirectionAssignment_1_1_1()); }
	(rule__Port__DirectionAssignment_1_1_1)?
	{ after(grammarAccess.getPortAccess().getDirectionAssignment_1_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Port__Group_4__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Port__Group_4__0__Impl
	rule__Port__Group_4__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Port__Group_4__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortAccess().getLeftParenthesisKeyword_4_0()); }
	'('
	{ after(grammarAccess.getPortAccess().getLeftParenthesisKeyword_4_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Port__Group_4__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Port__Group_4__1__Impl
	rule__Port__Group_4__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Port__Group_4__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortAccess().getParameterAssignment_4_1()); }
	(rule__Port__ParameterAssignment_4_1)
	{ after(grammarAccess.getPortAccess().getParameterAssignment_4_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Port__Group_4__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Port__Group_4__2__Impl
	rule__Port__Group_4__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Port__Group_4__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortAccess().getGroup_4_2()); }
	(rule__Port__Group_4_2__0)*
	{ after(grammarAccess.getPortAccess().getGroup_4_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Port__Group_4__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Port__Group_4__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Port__Group_4__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortAccess().getRightParenthesisKeyword_4_3()); }
	')'
	{ after(grammarAccess.getPortAccess().getRightParenthesisKeyword_4_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Port__Group_4_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Port__Group_4_2__0__Impl
	rule__Port__Group_4_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Port__Group_4_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortAccess().getCommaKeyword_4_2_0()); }
	','
	{ after(grammarAccess.getPortAccess().getCommaKeyword_4_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Port__Group_4_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Port__Group_4_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Port__Group_4_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortAccess().getParameterAssignment_4_2_1()); }
	(rule__Port__ParameterAssignment_4_2_1)
	{ after(grammarAccess.getPortAccess().getParameterAssignment_4_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PortPublic__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortPublic__Group__0__Impl
	rule__PortPublic__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPublic__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortPublicAccess().getAlternatives_0()); }
	(rule__PortPublic__Alternatives_0)
	{ after(grammarAccess.getPortPublicAccess().getAlternatives_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPublic__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortPublic__Group__1__Impl
	rule__PortPublic__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPublic__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortPublicAccess().getNameAssignment_1()); }
	(rule__PortPublic__NameAssignment_1)
	{ after(grammarAccess.getPortPublicAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPublic__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortPublic__Group__2__Impl
	rule__PortPublic__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPublic__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortPublicAccess().getUnrestrictedNameAssignment_2()); }
	(rule__PortPublic__UnrestrictedNameAssignment_2)?
	{ after(grammarAccess.getPortPublicAccess().getUnrestrictedNameAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPublic__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortPublic__Group__3__Impl
	rule__PortPublic__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPublic__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortPublicAccess().getGroup_3()); }
	(rule__PortPublic__Group_3__0)?
	{ after(grammarAccess.getPortPublicAccess().getGroup_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPublic__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortPublic__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPublic__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortPublicAccess().getSemicolonKeyword_4()); }
	';'
	{ after(grammarAccess.getPortPublicAccess().getSemicolonKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PortPublic__Group_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortPublic__Group_0_0__0__Impl
	rule__PortPublic__Group_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPublic__Group_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortPublicAccess().getDirectionAssignment_0_0_0()); }
	(rule__PortPublic__DirectionAssignment_0_0_0)
	{ after(grammarAccess.getPortPublicAccess().getDirectionAssignment_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPublic__Group_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortPublic__Group_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPublic__Group_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortPublicAccess().getVisibilityAssignment_0_0_1()); }
	(rule__PortPublic__VisibilityAssignment_0_0_1)
	{ after(grammarAccess.getPortPublicAccess().getVisibilityAssignment_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PortPublic__Group_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortPublic__Group_0_1__0__Impl
	rule__PortPublic__Group_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPublic__Group_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortPublicAccess().getVisibilityAssignment_0_1_0()); }
	(rule__PortPublic__VisibilityAssignment_0_1_0)
	{ after(grammarAccess.getPortPublicAccess().getVisibilityAssignment_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPublic__Group_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortPublic__Group_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPublic__Group_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortPublicAccess().getDirectionAssignment_0_1_1()); }
	(rule__PortPublic__DirectionAssignment_0_1_1)?
	{ after(grammarAccess.getPortPublicAccess().getDirectionAssignment_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PortPublic__Group_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortPublic__Group_3__0__Impl
	rule__PortPublic__Group_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPublic__Group_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortPublicAccess().getLeftParenthesisKeyword_3_0()); }
	'('
	{ after(grammarAccess.getPortPublicAccess().getLeftParenthesisKeyword_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPublic__Group_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortPublic__Group_3__1__Impl
	rule__PortPublic__Group_3__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPublic__Group_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortPublicAccess().getParameterAssignment_3_1()); }
	(rule__PortPublic__ParameterAssignment_3_1)
	{ after(grammarAccess.getPortPublicAccess().getParameterAssignment_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPublic__Group_3__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortPublic__Group_3__2__Impl
	rule__PortPublic__Group_3__3
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPublic__Group_3__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortPublicAccess().getGroup_3_2()); }
	(rule__PortPublic__Group_3_2__0)*
	{ after(grammarAccess.getPortPublicAccess().getGroup_3_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPublic__Group_3__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortPublic__Group_3__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPublic__Group_3__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortPublicAccess().getRightParenthesisKeyword_3_3()); }
	')'
	{ after(grammarAccess.getPortPublicAccess().getRightParenthesisKeyword_3_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PortPublic__Group_3_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortPublic__Group_3_2__0__Impl
	rule__PortPublic__Group_3_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPublic__Group_3_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortPublicAccess().getCommaKeyword_3_2_0()); }
	','
	{ after(grammarAccess.getPortPublicAccess().getCommaKeyword_3_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPublic__Group_3_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortPublic__Group_3_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPublic__Group_3_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortPublicAccess().getParameterAssignment_3_2_1()); }
	(rule__PortPublic__ParameterAssignment_3_2_1)
	{ after(grammarAccess.getPortPublicAccess().getParameterAssignment_3_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PortProtected__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortProtected__Group__0__Impl
	rule__PortProtected__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PortProtected__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortProtectedAccess().getAlternatives_0()); }
	(rule__PortProtected__Alternatives_0)
	{ after(grammarAccess.getPortProtectedAccess().getAlternatives_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PortProtected__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortProtected__Group__1__Impl
	rule__PortProtected__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PortProtected__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortProtectedAccess().getNameAssignment_1()); }
	(rule__PortProtected__NameAssignment_1)
	{ after(grammarAccess.getPortProtectedAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PortProtected__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortProtected__Group__2__Impl
	rule__PortProtected__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__PortProtected__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortProtectedAccess().getUnrestrictedNameAssignment_2()); }
	(rule__PortProtected__UnrestrictedNameAssignment_2)?
	{ after(grammarAccess.getPortProtectedAccess().getUnrestrictedNameAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PortProtected__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortProtected__Group__3__Impl
	rule__PortProtected__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__PortProtected__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortProtectedAccess().getGroup_3()); }
	(rule__PortProtected__Group_3__0)?
	{ after(grammarAccess.getPortProtectedAccess().getGroup_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PortProtected__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortProtected__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PortProtected__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortProtectedAccess().getSemicolonKeyword_4()); }
	';'
	{ after(grammarAccess.getPortProtectedAccess().getSemicolonKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PortProtected__Group_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortProtected__Group_0_0__0__Impl
	rule__PortProtected__Group_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PortProtected__Group_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortProtectedAccess().getDirectionAssignment_0_0_0()); }
	(rule__PortProtected__DirectionAssignment_0_0_0)
	{ after(grammarAccess.getPortProtectedAccess().getDirectionAssignment_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PortProtected__Group_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortProtected__Group_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PortProtected__Group_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortProtectedAccess().getVisibilityAssignment_0_0_1()); }
	(rule__PortProtected__VisibilityAssignment_0_0_1)
	{ after(grammarAccess.getPortProtectedAccess().getVisibilityAssignment_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PortProtected__Group_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortProtected__Group_0_1__0__Impl
	rule__PortProtected__Group_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PortProtected__Group_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortProtectedAccess().getVisibilityAssignment_0_1_0()); }
	(rule__PortProtected__VisibilityAssignment_0_1_0)
	{ after(grammarAccess.getPortProtectedAccess().getVisibilityAssignment_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PortProtected__Group_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortProtected__Group_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PortProtected__Group_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortProtectedAccess().getDirectionAssignment_0_1_1()); }
	(rule__PortProtected__DirectionAssignment_0_1_1)?
	{ after(grammarAccess.getPortProtectedAccess().getDirectionAssignment_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PortProtected__Group_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortProtected__Group_3__0__Impl
	rule__PortProtected__Group_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PortProtected__Group_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortProtectedAccess().getLeftParenthesisKeyword_3_0()); }
	'('
	{ after(grammarAccess.getPortProtectedAccess().getLeftParenthesisKeyword_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PortProtected__Group_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortProtected__Group_3__1__Impl
	rule__PortProtected__Group_3__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PortProtected__Group_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortProtectedAccess().getParameterAssignment_3_1()); }
	(rule__PortProtected__ParameterAssignment_3_1)
	{ after(grammarAccess.getPortProtectedAccess().getParameterAssignment_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PortProtected__Group_3__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortProtected__Group_3__2__Impl
	rule__PortProtected__Group_3__3
;
finally {
	restoreStackSize(stackSize);
}

rule__PortProtected__Group_3__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortProtectedAccess().getGroup_3_2()); }
	(rule__PortProtected__Group_3_2__0)*
	{ after(grammarAccess.getPortProtectedAccess().getGroup_3_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PortProtected__Group_3__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortProtected__Group_3__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PortProtected__Group_3__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortProtectedAccess().getRightParenthesisKeyword_3_3()); }
	')'
	{ after(grammarAccess.getPortProtectedAccess().getRightParenthesisKeyword_3_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PortProtected__Group_3_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortProtected__Group_3_2__0__Impl
	rule__PortProtected__Group_3_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PortProtected__Group_3_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortProtectedAccess().getCommaKeyword_3_2_0()); }
	','
	{ after(grammarAccess.getPortProtectedAccess().getCommaKeyword_3_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PortProtected__Group_3_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortProtected__Group_3_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PortProtected__Group_3_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortProtectedAccess().getParameterAssignment_3_2_1()); }
	(rule__PortProtected__ParameterAssignment_3_2_1)
	{ after(grammarAccess.getPortProtectedAccess().getParameterAssignment_3_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PortPrivate__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortPrivate__Group__0__Impl
	rule__PortPrivate__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPrivate__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortPrivateAccess().getAlternatives_0()); }
	(rule__PortPrivate__Alternatives_0)
	{ after(grammarAccess.getPortPrivateAccess().getAlternatives_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPrivate__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortPrivate__Group__1__Impl
	rule__PortPrivate__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPrivate__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortPrivateAccess().getNameAssignment_1()); }
	(rule__PortPrivate__NameAssignment_1)
	{ after(grammarAccess.getPortPrivateAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPrivate__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortPrivate__Group__2__Impl
	rule__PortPrivate__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPrivate__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortPrivateAccess().getUnrestrictedNameAssignment_2()); }
	(rule__PortPrivate__UnrestrictedNameAssignment_2)?
	{ after(grammarAccess.getPortPrivateAccess().getUnrestrictedNameAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPrivate__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortPrivate__Group__3__Impl
	rule__PortPrivate__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPrivate__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortPrivateAccess().getGroup_3()); }
	(rule__PortPrivate__Group_3__0)?
	{ after(grammarAccess.getPortPrivateAccess().getGroup_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPrivate__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortPrivate__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPrivate__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortPrivateAccess().getSemicolonKeyword_4()); }
	';'
	{ after(grammarAccess.getPortPrivateAccess().getSemicolonKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PortPrivate__Group_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortPrivate__Group_0_0__0__Impl
	rule__PortPrivate__Group_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPrivate__Group_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortPrivateAccess().getDirectionAssignment_0_0_0()); }
	(rule__PortPrivate__DirectionAssignment_0_0_0)
	{ after(grammarAccess.getPortPrivateAccess().getDirectionAssignment_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPrivate__Group_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortPrivate__Group_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPrivate__Group_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortPrivateAccess().getVisibilityAssignment_0_0_1()); }
	(rule__PortPrivate__VisibilityAssignment_0_0_1)
	{ after(grammarAccess.getPortPrivateAccess().getVisibilityAssignment_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PortPrivate__Group_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortPrivate__Group_0_1__0__Impl
	rule__PortPrivate__Group_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPrivate__Group_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortPrivateAccess().getVisibilityAssignment_0_1_0()); }
	(rule__PortPrivate__VisibilityAssignment_0_1_0)
	{ after(grammarAccess.getPortPrivateAccess().getVisibilityAssignment_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPrivate__Group_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortPrivate__Group_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPrivate__Group_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortPrivateAccess().getDirectionAssignment_0_1_1()); }
	(rule__PortPrivate__DirectionAssignment_0_1_1)?
	{ after(grammarAccess.getPortPrivateAccess().getDirectionAssignment_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PortPrivate__Group_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortPrivate__Group_3__0__Impl
	rule__PortPrivate__Group_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPrivate__Group_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortPrivateAccess().getLeftParenthesisKeyword_3_0()); }
	'('
	{ after(grammarAccess.getPortPrivateAccess().getLeftParenthesisKeyword_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPrivate__Group_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortPrivate__Group_3__1__Impl
	rule__PortPrivate__Group_3__2
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPrivate__Group_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortPrivateAccess().getParameterAssignment_3_1()); }
	(rule__PortPrivate__ParameterAssignment_3_1)
	{ after(grammarAccess.getPortPrivateAccess().getParameterAssignment_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPrivate__Group_3__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortPrivate__Group_3__2__Impl
	rule__PortPrivate__Group_3__3
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPrivate__Group_3__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortPrivateAccess().getGroup_3_2()); }
	(rule__PortPrivate__Group_3_2__0)*
	{ after(grammarAccess.getPortPrivateAccess().getGroup_3_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPrivate__Group_3__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortPrivate__Group_3__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPrivate__Group_3__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortPrivateAccess().getRightParenthesisKeyword_3_3()); }
	')'
	{ after(grammarAccess.getPortPrivateAccess().getRightParenthesisKeyword_3_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__PortPrivate__Group_3_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortPrivate__Group_3_2__0__Impl
	rule__PortPrivate__Group_3_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPrivate__Group_3_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortPrivateAccess().getCommaKeyword_3_2_0()); }
	','
	{ after(grammarAccess.getPortPrivateAccess().getCommaKeyword_3_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPrivate__Group_3_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__PortPrivate__Group_3_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__PortPrivate__Group_3_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getPortPrivateAccess().getParameterAssignment_3_2_1()); }
	(rule__PortPrivate__ParameterAssignment_3_2_1)
	{ after(grammarAccess.getPortPrivateAccess().getParameterAssignment_3_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Signal__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group__0__Impl
	rule__Signal__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getAlternatives_0()); }
	(rule__Signal__Alternatives_0)
	{ after(grammarAccess.getSignalAccess().getAlternatives_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group__1__Impl
	rule__Signal__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getNameAssignment_1()); }
	(rule__Signal__NameAssignment_1)
	{ after(grammarAccess.getSignalAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group__2__Impl
	rule__Signal__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getUnrestrictedNameAssignment_2()); }
	(rule__Signal__UnrestrictedNameAssignment_2)?
	{ after(grammarAccess.getSignalAccess().getUnrestrictedNameAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group__3__Impl
	rule__Signal__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getGroup_3()); }
	(rule__Signal__Group_3__0)?
	{ after(grammarAccess.getSignalAccess().getGroup_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getSemicolonKeyword_4()); }
	';'
	{ after(grammarAccess.getSignalAccess().getSemicolonKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Signal__Group_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_0_0__0__Impl
	rule__Signal__Group_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getDirectionAssignment_0_0_0()); }
	(rule__Signal__DirectionAssignment_0_0_0)
	{ after(grammarAccess.getSignalAccess().getDirectionAssignment_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getSignalKeyword_0_0_1()); }
	'signal'
	{ after(grammarAccess.getSignalAccess().getSignalKeyword_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Signal__Group_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_0_1__0__Impl
	rule__Signal__Group_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getSignalKeyword_0_1_0()); }
	'signal'
	{ after(grammarAccess.getSignalAccess().getSignalKeyword_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getDirectionAssignment_0_1_1()); }
	(rule__Signal__DirectionAssignment_0_1_1)?
	{ after(grammarAccess.getSignalAccess().getDirectionAssignment_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Signal__Group_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_3__0__Impl
	rule__Signal__Group_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getLeftParenthesisKeyword_3_0()); }
	'('
	{ after(grammarAccess.getSignalAccess().getLeftParenthesisKeyword_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_3__1__Impl
	rule__Signal__Group_3__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getParameterAssignment_3_1()); }
	(rule__Signal__ParameterAssignment_3_1)
	{ after(grammarAccess.getSignalAccess().getParameterAssignment_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_3__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_3__2__Impl
	rule__Signal__Group_3__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_3__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getGroup_3_2()); }
	(rule__Signal__Group_3_2__0)*
	{ after(grammarAccess.getSignalAccess().getGroup_3_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_3__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_3__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_3__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getRightParenthesisKeyword_3_3()); }
	')'
	{ after(grammarAccess.getSignalAccess().getRightParenthesisKeyword_3_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Signal__Group_3_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_3_2__0__Impl
	rule__Signal__Group_3_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_3_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getCommaKeyword_3_2_0()); }
	','
	{ after(grammarAccess.getSignalAccess().getCommaKeyword_3_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_3_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Signal__Group_3_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Signal__Group_3_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalAccess().getParameterAssignment_3_2_1()); }
	(rule__Signal__ParameterAssignment_3_2_1)
	{ after(grammarAccess.getSignalAccess().getParameterAssignment_3_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SignalPublic__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalPublic__Group__0__Impl
	rule__SignalPublic__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPublic__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalPublicAccess().getAlternatives_0()); }
	(rule__SignalPublic__Alternatives_0)
	{ after(grammarAccess.getSignalPublicAccess().getAlternatives_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPublic__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalPublic__Group__1__Impl
	rule__SignalPublic__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPublic__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalPublicAccess().getNameAssignment_1()); }
	(rule__SignalPublic__NameAssignment_1)
	{ after(grammarAccess.getSignalPublicAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPublic__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalPublic__Group__2__Impl
	rule__SignalPublic__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPublic__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalPublicAccess().getUnrestrictedNameAssignment_2()); }
	(rule__SignalPublic__UnrestrictedNameAssignment_2)?
	{ after(grammarAccess.getSignalPublicAccess().getUnrestrictedNameAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPublic__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalPublic__Group__3__Impl
	rule__SignalPublic__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPublic__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalPublicAccess().getGroup_3()); }
	(rule__SignalPublic__Group_3__0)?
	{ after(grammarAccess.getSignalPublicAccess().getGroup_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPublic__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalPublic__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPublic__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalPublicAccess().getSemicolonKeyword_4()); }
	';'
	{ after(grammarAccess.getSignalPublicAccess().getSemicolonKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SignalPublic__Group_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalPublic__Group_0_0__0__Impl
	rule__SignalPublic__Group_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPublic__Group_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalPublicAccess().getDirectionAssignment_0_0_0()); }
	(rule__SignalPublic__DirectionAssignment_0_0_0)
	{ after(grammarAccess.getSignalPublicAccess().getDirectionAssignment_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPublic__Group_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalPublic__Group_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPublic__Group_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalPublicAccess().getVisibilityAssignment_0_0_1()); }
	(rule__SignalPublic__VisibilityAssignment_0_0_1)
	{ after(grammarAccess.getSignalPublicAccess().getVisibilityAssignment_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SignalPublic__Group_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalPublic__Group_0_1__0__Impl
	rule__SignalPublic__Group_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPublic__Group_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalPublicAccess().getVisibilityAssignment_0_1_0()); }
	(rule__SignalPublic__VisibilityAssignment_0_1_0)
	{ after(grammarAccess.getSignalPublicAccess().getVisibilityAssignment_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPublic__Group_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalPublic__Group_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPublic__Group_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalPublicAccess().getDirectionAssignment_0_1_1()); }
	(rule__SignalPublic__DirectionAssignment_0_1_1)?
	{ after(grammarAccess.getSignalPublicAccess().getDirectionAssignment_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SignalPublic__Group_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalPublic__Group_3__0__Impl
	rule__SignalPublic__Group_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPublic__Group_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalPublicAccess().getLeftParenthesisKeyword_3_0()); }
	'('
	{ after(grammarAccess.getSignalPublicAccess().getLeftParenthesisKeyword_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPublic__Group_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalPublic__Group_3__1__Impl
	rule__SignalPublic__Group_3__2
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPublic__Group_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalPublicAccess().getParameterAssignment_3_1()); }
	(rule__SignalPublic__ParameterAssignment_3_1)
	{ after(grammarAccess.getSignalPublicAccess().getParameterAssignment_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPublic__Group_3__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalPublic__Group_3__2__Impl
	rule__SignalPublic__Group_3__3
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPublic__Group_3__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalPublicAccess().getGroup_3_2()); }
	(rule__SignalPublic__Group_3_2__0)*
	{ after(grammarAccess.getSignalPublicAccess().getGroup_3_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPublic__Group_3__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalPublic__Group_3__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPublic__Group_3__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalPublicAccess().getRightParenthesisKeyword_3_3()); }
	')'
	{ after(grammarAccess.getSignalPublicAccess().getRightParenthesisKeyword_3_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SignalPublic__Group_3_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalPublic__Group_3_2__0__Impl
	rule__SignalPublic__Group_3_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPublic__Group_3_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalPublicAccess().getCommaKeyword_3_2_0()); }
	','
	{ after(grammarAccess.getSignalPublicAccess().getCommaKeyword_3_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPublic__Group_3_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalPublic__Group_3_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPublic__Group_3_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalPublicAccess().getParameterAssignment_3_2_1()); }
	(rule__SignalPublic__ParameterAssignment_3_2_1)
	{ after(grammarAccess.getSignalPublicAccess().getParameterAssignment_3_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SignalProtected__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalProtected__Group__0__Impl
	rule__SignalProtected__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalProtected__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalProtectedAccess().getAlternatives_0()); }
	(rule__SignalProtected__Alternatives_0)
	{ after(grammarAccess.getSignalProtectedAccess().getAlternatives_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalProtected__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalProtected__Group__1__Impl
	rule__SignalProtected__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalProtected__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalProtectedAccess().getNameAssignment_1()); }
	(rule__SignalProtected__NameAssignment_1)
	{ after(grammarAccess.getSignalProtectedAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalProtected__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalProtected__Group__2__Impl
	rule__SignalProtected__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalProtected__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalProtectedAccess().getUnrestrictedNameAssignment_2()); }
	(rule__SignalProtected__UnrestrictedNameAssignment_2)?
	{ after(grammarAccess.getSignalProtectedAccess().getUnrestrictedNameAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalProtected__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalProtected__Group__3__Impl
	rule__SignalProtected__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalProtected__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalProtectedAccess().getGroup_3()); }
	(rule__SignalProtected__Group_3__0)?
	{ after(grammarAccess.getSignalProtectedAccess().getGroup_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalProtected__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalProtected__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalProtected__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalProtectedAccess().getSemicolonKeyword_4()); }
	';'
	{ after(grammarAccess.getSignalProtectedAccess().getSemicolonKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SignalProtected__Group_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalProtected__Group_0_0__0__Impl
	rule__SignalProtected__Group_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalProtected__Group_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalProtectedAccess().getDirectionAssignment_0_0_0()); }
	(rule__SignalProtected__DirectionAssignment_0_0_0)
	{ after(grammarAccess.getSignalProtectedAccess().getDirectionAssignment_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalProtected__Group_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalProtected__Group_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalProtected__Group_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalProtectedAccess().getVisibilityAssignment_0_0_1()); }
	(rule__SignalProtected__VisibilityAssignment_0_0_1)
	{ after(grammarAccess.getSignalProtectedAccess().getVisibilityAssignment_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SignalProtected__Group_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalProtected__Group_0_1__0__Impl
	rule__SignalProtected__Group_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalProtected__Group_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalProtectedAccess().getVisibilityAssignment_0_1_0()); }
	(rule__SignalProtected__VisibilityAssignment_0_1_0)
	{ after(grammarAccess.getSignalProtectedAccess().getVisibilityAssignment_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalProtected__Group_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalProtected__Group_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalProtected__Group_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalProtectedAccess().getDirectionAssignment_0_1_1()); }
	(rule__SignalProtected__DirectionAssignment_0_1_1)?
	{ after(grammarAccess.getSignalProtectedAccess().getDirectionAssignment_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SignalProtected__Group_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalProtected__Group_3__0__Impl
	rule__SignalProtected__Group_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalProtected__Group_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalProtectedAccess().getLeftParenthesisKeyword_3_0()); }
	'('
	{ after(grammarAccess.getSignalProtectedAccess().getLeftParenthesisKeyword_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalProtected__Group_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalProtected__Group_3__1__Impl
	rule__SignalProtected__Group_3__2
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalProtected__Group_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalProtectedAccess().getParameterAssignment_3_1()); }
	(rule__SignalProtected__ParameterAssignment_3_1)
	{ after(grammarAccess.getSignalProtectedAccess().getParameterAssignment_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalProtected__Group_3__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalProtected__Group_3__2__Impl
	rule__SignalProtected__Group_3__3
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalProtected__Group_3__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalProtectedAccess().getGroup_3_2()); }
	(rule__SignalProtected__Group_3_2__0)*
	{ after(grammarAccess.getSignalProtectedAccess().getGroup_3_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalProtected__Group_3__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalProtected__Group_3__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalProtected__Group_3__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalProtectedAccess().getRightParenthesisKeyword_3_3()); }
	')'
	{ after(grammarAccess.getSignalProtectedAccess().getRightParenthesisKeyword_3_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SignalProtected__Group_3_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalProtected__Group_3_2__0__Impl
	rule__SignalProtected__Group_3_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalProtected__Group_3_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalProtectedAccess().getCommaKeyword_3_2_0()); }
	','
	{ after(grammarAccess.getSignalProtectedAccess().getCommaKeyword_3_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalProtected__Group_3_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalProtected__Group_3_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalProtected__Group_3_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalProtectedAccess().getParameterAssignment_3_2_1()); }
	(rule__SignalProtected__ParameterAssignment_3_2_1)
	{ after(grammarAccess.getSignalProtectedAccess().getParameterAssignment_3_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SignalPrivate__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalPrivate__Group__0__Impl
	rule__SignalPrivate__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPrivate__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalPrivateAccess().getAlternatives_0()); }
	(rule__SignalPrivate__Alternatives_0)
	{ after(grammarAccess.getSignalPrivateAccess().getAlternatives_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPrivate__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalPrivate__Group__1__Impl
	rule__SignalPrivate__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPrivate__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalPrivateAccess().getNameAssignment_1()); }
	(rule__SignalPrivate__NameAssignment_1)
	{ after(grammarAccess.getSignalPrivateAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPrivate__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalPrivate__Group__2__Impl
	rule__SignalPrivate__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPrivate__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalPrivateAccess().getUnrestrictedNameAssignment_2()); }
	(rule__SignalPrivate__UnrestrictedNameAssignment_2)?
	{ after(grammarAccess.getSignalPrivateAccess().getUnrestrictedNameAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPrivate__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalPrivate__Group__3__Impl
	rule__SignalPrivate__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPrivate__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalPrivateAccess().getGroup_3()); }
	(rule__SignalPrivate__Group_3__0)?
	{ after(grammarAccess.getSignalPrivateAccess().getGroup_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPrivate__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalPrivate__Group__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPrivate__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalPrivateAccess().getSemicolonKeyword_4()); }
	';'
	{ after(grammarAccess.getSignalPrivateAccess().getSemicolonKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SignalPrivate__Group_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalPrivate__Group_0_0__0__Impl
	rule__SignalPrivate__Group_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPrivate__Group_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalPrivateAccess().getDirectionAssignment_0_0_0()); }
	(rule__SignalPrivate__DirectionAssignment_0_0_0)
	{ after(grammarAccess.getSignalPrivateAccess().getDirectionAssignment_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPrivate__Group_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalPrivate__Group_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPrivate__Group_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalPrivateAccess().getVisibilityAssignment_0_0_1()); }
	(rule__SignalPrivate__VisibilityAssignment_0_0_1)
	{ after(grammarAccess.getSignalPrivateAccess().getVisibilityAssignment_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SignalPrivate__Group_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalPrivate__Group_0_1__0__Impl
	rule__SignalPrivate__Group_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPrivate__Group_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalPrivateAccess().getVisibilityAssignment_0_1_0()); }
	(rule__SignalPrivate__VisibilityAssignment_0_1_0)
	{ after(grammarAccess.getSignalPrivateAccess().getVisibilityAssignment_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPrivate__Group_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalPrivate__Group_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPrivate__Group_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalPrivateAccess().getDirectionAssignment_0_1_1()); }
	(rule__SignalPrivate__DirectionAssignment_0_1_1)?
	{ after(grammarAccess.getSignalPrivateAccess().getDirectionAssignment_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SignalPrivate__Group_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalPrivate__Group_3__0__Impl
	rule__SignalPrivate__Group_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPrivate__Group_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalPrivateAccess().getLeftParenthesisKeyword_3_0()); }
	'('
	{ after(grammarAccess.getSignalPrivateAccess().getLeftParenthesisKeyword_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPrivate__Group_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalPrivate__Group_3__1__Impl
	rule__SignalPrivate__Group_3__2
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPrivate__Group_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalPrivateAccess().getParameterAssignment_3_1()); }
	(rule__SignalPrivate__ParameterAssignment_3_1)
	{ after(grammarAccess.getSignalPrivateAccess().getParameterAssignment_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPrivate__Group_3__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalPrivate__Group_3__2__Impl
	rule__SignalPrivate__Group_3__3
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPrivate__Group_3__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalPrivateAccess().getGroup_3_2()); }
	(rule__SignalPrivate__Group_3_2__0)*
	{ after(grammarAccess.getSignalPrivateAccess().getGroup_3_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPrivate__Group_3__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalPrivate__Group_3__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPrivate__Group_3__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalPrivateAccess().getRightParenthesisKeyword_3_3()); }
	')'
	{ after(grammarAccess.getSignalPrivateAccess().getRightParenthesisKeyword_3_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SignalPrivate__Group_3_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalPrivate__Group_3_2__0__Impl
	rule__SignalPrivate__Group_3_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPrivate__Group_3_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalPrivateAccess().getCommaKeyword_3_2_0()); }
	','
	{ after(grammarAccess.getSignalPrivateAccess().getCommaKeyword_3_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPrivate__Group_3_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalPrivate__Group_3_2__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalPrivate__Group_3_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalPrivateAccess().getParameterAssignment_3_2_1()); }
	(rule__SignalPrivate__ParameterAssignment_3_2_1)
	{ after(grammarAccess.getSignalPrivateAccess().getParameterAssignment_3_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Channel__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Channel__Group__0__Impl
	rule__Channel__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Channel__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChannelAccess().getVisibilityAssignment_0()); }
	(rule__Channel__VisibilityAssignment_0)?
	{ after(grammarAccess.getChannelAccess().getVisibilityAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Channel__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Channel__Group__1__Impl
	rule__Channel__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Channel__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChannelAccess().getChannelKeyword_1()); }
	'channel'
	{ after(grammarAccess.getChannelAccess().getChannelKeyword_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Channel__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Channel__Group__2__Impl
	rule__Channel__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Channel__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChannelAccess().getNameAssignment_2()); }
	(rule__Channel__NameAssignment_2)
	{ after(grammarAccess.getChannelAccess().getNameAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Channel__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Channel__Group__3__Impl
	rule__Channel__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__Channel__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChannelAccess().getUnrestrictedNameAssignment_3()); }
	(rule__Channel__UnrestrictedNameAssignment_3)?
	{ after(grammarAccess.getChannelAccess().getUnrestrictedNameAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Channel__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Channel__Group__4__Impl
	rule__Channel__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__Channel__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChannelAccess().getLeftCurlyBracketKeyword_4()); }
	'{'
	{ after(grammarAccess.getChannelAccess().getLeftCurlyBracketKeyword_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Channel__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Channel__Group__5__Impl
	rule__Channel__Group__6
;
finally {
	restoreStackSize(stackSize);
}

rule__Channel__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getChannelAccess().getGroup_5()); }
		(rule__Channel__Group_5__0)
		{ after(grammarAccess.getChannelAccess().getGroup_5()); }
	)
	(
		{ before(grammarAccess.getChannelAccess().getGroup_5()); }
		(rule__Channel__Group_5__0)*
		{ after(grammarAccess.getChannelAccess().getGroup_5()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Channel__Group__6
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Channel__Group__6__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Channel__Group__6__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChannelAccess().getRightCurlyBracketKeyword_6()); }
	'}'
	{ after(grammarAccess.getChannelAccess().getRightCurlyBracketKeyword_6()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Channel__Group_5__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Channel__Group_5__0__Impl
	rule__Channel__Group_5__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Channel__Group_5__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChannelAccess().getSignalAssignment_5_0()); }
	(rule__Channel__SignalAssignment_5_0)
	{ after(grammarAccess.getChannelAccess().getSignalAssignment_5_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Channel__Group_5__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Channel__Group_5__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Channel__Group_5__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChannelAccess().getSemicolonKeyword_5_1()); }
	';'
	{ after(grammarAccess.getChannelAccess().getSemicolonKeyword_5_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__SignalReference__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalReference__Group__0__Impl
	rule__SignalReference__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalReference__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalReferenceAccess().getDirectionAssignment_0()); }
	(rule__SignalReference__DirectionAssignment_0)?
	{ after(grammarAccess.getSignalReferenceAccess().getDirectionAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalReference__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__SignalReference__Group__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__SignalReference__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getSignalReferenceAccess().getNameAssignment_1()); }
	(rule__SignalReference__NameAssignment_1)
	{ after(grammarAccess.getSignalReferenceAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ChannelPublic__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChannelPublic__Group__0__Impl
	rule__ChannelPublic__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelPublic__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChannelPublicAccess().getVisibilityAssignment_0()); }
	(rule__ChannelPublic__VisibilityAssignment_0)
	{ after(grammarAccess.getChannelPublicAccess().getVisibilityAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelPublic__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChannelPublic__Group__1__Impl
	rule__ChannelPublic__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelPublic__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChannelPublicAccess().getNameAssignment_1()); }
	(rule__ChannelPublic__NameAssignment_1)
	{ after(grammarAccess.getChannelPublicAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelPublic__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChannelPublic__Group__2__Impl
	rule__ChannelPublic__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelPublic__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChannelPublicAccess().getUnrestrictedNameAssignment_2()); }
	(rule__ChannelPublic__UnrestrictedNameAssignment_2)?
	{ after(grammarAccess.getChannelPublicAccess().getUnrestrictedNameAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelPublic__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChannelPublic__Group__3__Impl
	rule__ChannelPublic__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelPublic__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChannelPublicAccess().getLeftCurlyBracketKeyword_3()); }
	'{'
	{ after(grammarAccess.getChannelPublicAccess().getLeftCurlyBracketKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelPublic__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChannelPublic__Group__4__Impl
	rule__ChannelPublic__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelPublic__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getChannelPublicAccess().getGroup_4()); }
		(rule__ChannelPublic__Group_4__0)
		{ after(grammarAccess.getChannelPublicAccess().getGroup_4()); }
	)
	(
		{ before(grammarAccess.getChannelPublicAccess().getGroup_4()); }
		(rule__ChannelPublic__Group_4__0)*
		{ after(grammarAccess.getChannelPublicAccess().getGroup_4()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelPublic__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChannelPublic__Group__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelPublic__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChannelPublicAccess().getRightCurlyBracketKeyword_5()); }
	'}'
	{ after(grammarAccess.getChannelPublicAccess().getRightCurlyBracketKeyword_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ChannelPublic__Group_4__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChannelPublic__Group_4__0__Impl
	rule__ChannelPublic__Group_4__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelPublic__Group_4__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChannelPublicAccess().getSignalAssignment_4_0()); }
	(rule__ChannelPublic__SignalAssignment_4_0)
	{ after(grammarAccess.getChannelPublicAccess().getSignalAssignment_4_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelPublic__Group_4__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChannelPublic__Group_4__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelPublic__Group_4__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChannelPublicAccess().getSemicolonKeyword_4_1()); }
	';'
	{ after(grammarAccess.getChannelPublicAccess().getSemicolonKeyword_4_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ChannelProtected__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChannelProtected__Group__0__Impl
	rule__ChannelProtected__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelProtected__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChannelProtectedAccess().getVisibilityAssignment_0()); }
	(rule__ChannelProtected__VisibilityAssignment_0)
	{ after(grammarAccess.getChannelProtectedAccess().getVisibilityAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelProtected__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChannelProtected__Group__1__Impl
	rule__ChannelProtected__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelProtected__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChannelProtectedAccess().getNameAssignment_1()); }
	(rule__ChannelProtected__NameAssignment_1)
	{ after(grammarAccess.getChannelProtectedAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelProtected__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChannelProtected__Group__2__Impl
	rule__ChannelProtected__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelProtected__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChannelProtectedAccess().getUnrestrictedNameAssignment_2()); }
	(rule__ChannelProtected__UnrestrictedNameAssignment_2)?
	{ after(grammarAccess.getChannelProtectedAccess().getUnrestrictedNameAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelProtected__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChannelProtected__Group__3__Impl
	rule__ChannelProtected__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelProtected__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChannelProtectedAccess().getLeftCurlyBracketKeyword_3()); }
	'{'
	{ after(grammarAccess.getChannelProtectedAccess().getLeftCurlyBracketKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelProtected__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChannelProtected__Group__4__Impl
	rule__ChannelProtected__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelProtected__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getChannelProtectedAccess().getGroup_4()); }
		(rule__ChannelProtected__Group_4__0)
		{ after(grammarAccess.getChannelProtectedAccess().getGroup_4()); }
	)
	(
		{ before(grammarAccess.getChannelProtectedAccess().getGroup_4()); }
		(rule__ChannelProtected__Group_4__0)*
		{ after(grammarAccess.getChannelProtectedAccess().getGroup_4()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelProtected__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChannelProtected__Group__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelProtected__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChannelProtectedAccess().getRightCurlyBracketKeyword_5()); }
	'}'
	{ after(grammarAccess.getChannelProtectedAccess().getRightCurlyBracketKeyword_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ChannelProtected__Group_4__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChannelProtected__Group_4__0__Impl
	rule__ChannelProtected__Group_4__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelProtected__Group_4__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChannelProtectedAccess().getSignalAssignment_4_0()); }
	(rule__ChannelProtected__SignalAssignment_4_0)
	{ after(grammarAccess.getChannelProtectedAccess().getSignalAssignment_4_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelProtected__Group_4__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChannelProtected__Group_4__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelProtected__Group_4__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChannelProtectedAccess().getSemicolonKeyword_4_1()); }
	';'
	{ after(grammarAccess.getChannelProtectedAccess().getSemicolonKeyword_4_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ChannelPrivate__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChannelPrivate__Group__0__Impl
	rule__ChannelPrivate__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelPrivate__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChannelPrivateAccess().getVisibilityAssignment_0()); }
	(rule__ChannelPrivate__VisibilityAssignment_0)
	{ after(grammarAccess.getChannelPrivateAccess().getVisibilityAssignment_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelPrivate__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChannelPrivate__Group__1__Impl
	rule__ChannelPrivate__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelPrivate__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChannelPrivateAccess().getNameAssignment_1()); }
	(rule__ChannelPrivate__NameAssignment_1)
	{ after(grammarAccess.getChannelPrivateAccess().getNameAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelPrivate__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChannelPrivate__Group__2__Impl
	rule__ChannelPrivate__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelPrivate__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChannelPrivateAccess().getUnrestrictedNameAssignment_2()); }
	(rule__ChannelPrivate__UnrestrictedNameAssignment_2)?
	{ after(grammarAccess.getChannelPrivateAccess().getUnrestrictedNameAssignment_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelPrivate__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChannelPrivate__Group__3__Impl
	rule__ChannelPrivate__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelPrivate__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChannelPrivateAccess().getLeftCurlyBracketKeyword_3()); }
	'{'
	{ after(grammarAccess.getChannelPrivateAccess().getLeftCurlyBracketKeyword_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelPrivate__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChannelPrivate__Group__4__Impl
	rule__ChannelPrivate__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelPrivate__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	(
		{ before(grammarAccess.getChannelPrivateAccess().getGroup_4()); }
		(rule__ChannelPrivate__Group_4__0)
		{ after(grammarAccess.getChannelPrivateAccess().getGroup_4()); }
	)
	(
		{ before(grammarAccess.getChannelPrivateAccess().getGroup_4()); }
		(rule__ChannelPrivate__Group_4__0)*
		{ after(grammarAccess.getChannelPrivateAccess().getGroup_4()); }
	)
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelPrivate__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChannelPrivate__Group__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelPrivate__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChannelPrivateAccess().getRightCurlyBracketKeyword_5()); }
	'}'
	{ after(grammarAccess.getChannelPrivateAccess().getRightCurlyBracketKeyword_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__ChannelPrivate__Group_4__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChannelPrivate__Group_4__0__Impl
	rule__ChannelPrivate__Group_4__1
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelPrivate__Group_4__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChannelPrivateAccess().getSignalAssignment_4_0()); }
	(rule__ChannelPrivate__SignalAssignment_4_0)
	{ after(grammarAccess.getChannelPrivateAccess().getSignalAssignment_4_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelPrivate__Group_4__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__ChannelPrivate__Group_4__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__ChannelPrivate__Group_4__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getChannelPrivateAccess().getSemicolonKeyword_4_1()); }
	';'
	{ after(grammarAccess.getChannelPrivateAccess().getSemicolonKeyword_4_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Transition__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group__0__Impl
	rule__Transition__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getTransitionAction_0()); }
	()
	{ after(grammarAccess.getTransitionAccess().getTransitionAction_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group__1__Impl
	rule__Transition__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getTransientAssignment_1()); }
	(rule__Transition__TransientAssignment_1)?
	{ after(grammarAccess.getTransitionAccess().getTransientAssignment_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group__2__Impl
	rule__Transition__Group__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getTransitionKeyword_2()); }
	'transition'
	{ after(grammarAccess.getTransitionAccess().getTransitionKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group__3__Impl
	rule__Transition__Group__4
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getMoeAssignment_3()); }
	(rule__Transition__MoeAssignment_3)?
	{ after(grammarAccess.getTransitionAccess().getMoeAssignment_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group__4__Impl
	rule__Transition__Group__5
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getGroup_4()); }
	(rule__Transition__Group_4__0)?
	{ after(grammarAccess.getTransitionAccess().getGroup_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group__5
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group__5__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group__5__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getAlternatives_5()); }
	(rule__Transition__Alternatives_5)
	{ after(grammarAccess.getTransitionAccess().getAlternatives_5()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Transition__Group_4__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group_4__0__Impl
	rule__Transition__Group_4__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_4__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getNameAssignment_4_0()); }
	(rule__Transition__NameAssignment_4_0)
	{ after(grammarAccess.getTransitionAccess().getNameAssignment_4_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_4__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group_4__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_4__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getUnrestrictedNameAssignment_4_1()); }
	(rule__Transition__UnrestrictedNameAssignment_4_1)?
	{ after(grammarAccess.getTransitionAccess().getUnrestrictedNameAssignment_4_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Transition__Group_5_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group_5_0__0__Impl
	rule__Transition__Group_5_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getLeftCurlyBracketKeyword_5_0_0()); }
	'{'
	{ after(grammarAccess.getTransitionAccess().getLeftCurlyBracketKeyword_5_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group_5_0__1__Impl
	rule__Transition__Group_5_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getAlternatives_5_0_1()); }
	(rule__Transition__Alternatives_5_0_1)?
	{ after(grammarAccess.getTransitionAccess().getAlternatives_5_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group_5_0__2__Impl
	rule__Transition__Group_5_0__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getRightCurlyBracketKeyword_5_0_2()); }
	'}'
	{ after(grammarAccess.getTransitionAccess().getRightCurlyBracketKeyword_5_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_0__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group_5_0__3__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_0__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getGroup_5_0_3()); }
	(rule__Transition__Group_5_0_3__0)?
	{ after(grammarAccess.getTransitionAccess().getGroup_5_0_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Transition__Group_5_0_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group_5_0_1_0__0__Impl
	rule__Transition__Group_5_0_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_0_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getGroup_5_0_1_0_0()); }
	(rule__Transition__Group_5_0_1_0_0__0)?
	{ after(grammarAccess.getTransitionAccess().getGroup_5_0_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_0_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group_5_0_1_0__1__Impl
	rule__Transition__Group_5_0_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_0_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getAlternatives_5_0_1_0_1()); }
	(rule__Transition__Alternatives_5_0_1_0_1)?
	{ after(grammarAccess.getTransitionAccess().getAlternatives_5_0_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_0_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group_5_0_1_0__2__Impl
	rule__Transition__Group_5_0_1_0__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_0_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getAlternatives_5_0_1_0_2()); }
	(rule__Transition__Alternatives_5_0_1_0_2)?
	{ after(grammarAccess.getTransitionAccess().getAlternatives_5_0_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_0_1_0__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group_5_0_1_0__3__Impl
	rule__Transition__Group_5_0_1_0__4
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_0_1_0__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getEffectKeyword_5_0_1_0_3()); }
	'@effect:'
	{ after(grammarAccess.getTransitionAccess().getEffectKeyword_5_0_1_0_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_0_1_0__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group_5_0_1_0__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_0_1_0__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getEffectAssignment_5_0_1_0_4()); }
	(rule__Transition__EffectAssignment_5_0_1_0_4)?
	{ after(grammarAccess.getTransitionAccess().getEffectAssignment_5_0_1_0_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Transition__Group_5_0_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group_5_0_1_0_0__0__Impl
	rule__Transition__Group_5_0_1_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_0_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getTriggerKeyword_5_0_1_0_0_0()); }
	'@trigger:'
	{ after(grammarAccess.getTransitionAccess().getTriggerKeyword_5_0_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_0_1_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group_5_0_1_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_0_1_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getTriggerAssignment_5_0_1_0_0_1()); }
	(rule__Transition__TriggerAssignment_5_0_1_0_0_1)*
	{ after(grammarAccess.getTransitionAccess().getTriggerAssignment_5_0_1_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Transition__Group_5_0_3__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group_5_0_3__0__Impl
	rule__Transition__Group_5_0_3__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_0_3__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getHyphenMinusHyphenMinusGreaterThanSignKeyword_5_0_3_0()); }
	'-->'
	{ after(grammarAccess.getTransitionAccess().getHyphenMinusHyphenMinusGreaterThanSignKeyword_5_0_3_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_0_3__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group_5_0_3__1__Impl
	rule__Transition__Group_5_0_3__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_0_3__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getTargetAssignment_5_0_3_1()); }
	(rule__Transition__TargetAssignment_5_0_3_1)
	{ after(grammarAccess.getTransitionAccess().getTargetAssignment_5_0_3_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_0_3__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group_5_0_3__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_0_3__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getSemicolonKeyword_5_0_3_2()); }
	';'
	{ after(grammarAccess.getTransitionAccess().getSemicolonKeyword_5_0_3_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Transition__Group_5_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group_5_1__0__Impl
	rule__Transition__Group_5_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getHyphenMinusHyphenMinusGreaterThanSignKeyword_5_1_0()); }
	'-->'
	{ after(grammarAccess.getTransitionAccess().getHyphenMinusHyphenMinusGreaterThanSignKeyword_5_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group_5_1__1__Impl
	rule__Transition__Group_5_1__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getTargetAssignment_5_1_1()); }
	(rule__Transition__TargetAssignment_5_1_1)
	{ after(grammarAccess.getTransitionAccess().getTargetAssignment_5_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_1__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group_5_1__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_1__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getAlternatives_5_1_2()); }
	(rule__Transition__Alternatives_5_1_2)
	{ after(grammarAccess.getTransitionAccess().getAlternatives_5_1_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Transition__Group_5_1_2_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group_5_1_2_0__0__Impl
	rule__Transition__Group_5_1_2_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_1_2_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getLeftCurlyBracketKeyword_5_1_2_0_0()); }
	'{'
	{ after(grammarAccess.getTransitionAccess().getLeftCurlyBracketKeyword_5_1_2_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_1_2_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group_5_1_2_0__1__Impl
	rule__Transition__Group_5_1_2_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_1_2_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getAlternatives_5_1_2_0_1()); }
	(rule__Transition__Alternatives_5_1_2_0_1)?
	{ after(grammarAccess.getTransitionAccess().getAlternatives_5_1_2_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_1_2_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group_5_1_2_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_1_2_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getRightCurlyBracketKeyword_5_1_2_0_2()); }
	'}'
	{ after(grammarAccess.getTransitionAccess().getRightCurlyBracketKeyword_5_1_2_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Transition__Group_5_1_2_0_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group_5_1_2_0_1_0__0__Impl
	rule__Transition__Group_5_1_2_0_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_1_2_0_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getGroup_5_1_2_0_1_0_0()); }
	(rule__Transition__Group_5_1_2_0_1_0_0__0)?
	{ after(grammarAccess.getTransitionAccess().getGroup_5_1_2_0_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_1_2_0_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group_5_1_2_0_1_0__1__Impl
	rule__Transition__Group_5_1_2_0_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_1_2_0_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getAlternatives_5_1_2_0_1_0_1()); }
	(rule__Transition__Alternatives_5_1_2_0_1_0_1)?
	{ after(grammarAccess.getTransitionAccess().getAlternatives_5_1_2_0_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_1_2_0_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group_5_1_2_0_1_0__2__Impl
	rule__Transition__Group_5_1_2_0_1_0__3
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_1_2_0_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getAlternatives_5_1_2_0_1_0_2()); }
	(rule__Transition__Alternatives_5_1_2_0_1_0_2)?
	{ after(grammarAccess.getTransitionAccess().getAlternatives_5_1_2_0_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_1_2_0_1_0__3
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group_5_1_2_0_1_0__3__Impl
	rule__Transition__Group_5_1_2_0_1_0__4
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_1_2_0_1_0__3__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getEffectKeyword_5_1_2_0_1_0_3()); }
	'@effect:'
	{ after(grammarAccess.getTransitionAccess().getEffectKeyword_5_1_2_0_1_0_3()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_1_2_0_1_0__4
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group_5_1_2_0_1_0__4__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_1_2_0_1_0__4__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getEffectAssignment_5_1_2_0_1_0_4()); }
	(rule__Transition__EffectAssignment_5_1_2_0_1_0_4)?
	{ after(grammarAccess.getTransitionAccess().getEffectAssignment_5_1_2_0_1_0_4()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__Transition__Group_5_1_2_0_1_0_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group_5_1_2_0_1_0_0__0__Impl
	rule__Transition__Group_5_1_2_0_1_0_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_1_2_0_1_0_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getTriggerKeyword_5_1_2_0_1_0_0_0()); }
	'@trigger:'
	{ after(grammarAccess.getTransitionAccess().getTriggerKeyword_5_1_2_0_1_0_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_1_2_0_1_0_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__Transition__Group_5_1_2_0_1_0_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__Transition__Group_5_1_2_0_1_0_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionAccess().getTriggerAssignment_5_1_2_0_1_0_0_1()); }
	(rule__Transition__TriggerAssignment_5_1_2_0_1_0_0_1)*
	{ after(grammarAccess.getTransitionAccess().getTriggerAssignment_5_1_2_0_1_0_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TransitionMoe__Group__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TransitionMoe__Group__0__Impl
	rule__TransitionMoe__Group__1
;
finally {
	restoreStackSize(stackSize);
}

rule__TransitionMoe__Group__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionMoeAccess().getLessThanSignKeyword_0()); }
	'<'
	{ after(grammarAccess.getTransitionMoeAccess().getLessThanSignKeyword_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TransitionMoe__Group__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TransitionMoe__Group__1__Impl
	rule__TransitionMoe__Group__2
;
finally {
	restoreStackSize(stackSize);
}

rule__TransitionMoe__Group__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionMoeAccess().getAlternatives_1()); }
	(rule__TransitionMoe__Alternatives_1)
	{ after(grammarAccess.getTransitionMoeAccess().getAlternatives_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TransitionMoe__Group__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TransitionMoe__Group__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TransitionMoe__Group__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionMoeAccess().getGreaterThanSignKeyword_2()); }
	'>'
	{ after(grammarAccess.getTransitionMoeAccess().getGreaterThanSignKeyword_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TransitionMoe__Group_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TransitionMoe__Group_1_0__0__Impl
	rule__TransitionMoe__Group_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__TransitionMoe__Group_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionMoeAccess().getMocKeyword_1_0_0()); }
	('moc:')?
	{ after(grammarAccess.getTransitionMoeAccess().getMocKeyword_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TransitionMoe__Group_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TransitionMoe__Group_1_0__1__Impl
	rule__TransitionMoe__Group_1_0__2
;
finally {
	restoreStackSize(stackSize);
}

rule__TransitionMoe__Group_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionMoeAccess().getAlternatives_1_0_1()); }
	(rule__TransitionMoe__Alternatives_1_0_1)
	{ after(grammarAccess.getTransitionMoeAccess().getAlternatives_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TransitionMoe__Group_1_0__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TransitionMoe__Group_1_0__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TransitionMoe__Group_1_0__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionMoeAccess().getGroup_1_0_2()); }
	(rule__TransitionMoe__Group_1_0_2__0)?
	{ after(grammarAccess.getTransitionMoeAccess().getGroup_1_0_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TransitionMoe__Group_1_0_1_0__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TransitionMoe__Group_1_0_1_0__0__Impl
	rule__TransitionMoe__Group_1_0_1_0__1
;
finally {
	restoreStackSize(stackSize);
}

rule__TransitionMoe__Group_1_0_1_0__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionMoeAccess().getMocAssignment_1_0_1_0_0()); }
	(rule__TransitionMoe__MocAssignment_1_0_1_0_0)
	{ after(grammarAccess.getTransitionMoeAccess().getMocAssignment_1_0_1_0_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TransitionMoe__Group_1_0_1_0__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TransitionMoe__Group_1_0_1_0__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TransitionMoe__Group_1_0_1_0__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionMoeAccess().getGroup_1_0_1_0_1()); }
	(rule__TransitionMoe__Group_1_0_1_0_1__0)?
	{ after(grammarAccess.getTransitionMoeAccess().getGroup_1_0_1_0_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TransitionMoe__Group_1_0_1_0_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TransitionMoe__Group_1_0_1_0_1__0__Impl
	rule__TransitionMoe__Group_1_0_1_0_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__TransitionMoe__Group_1_0_1_0_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionMoeAccess().getAmpersandKeyword_1_0_1_0_1_0()); }
	'&'
	{ after(grammarAccess.getTransitionMoeAccess().getAmpersandKeyword_1_0_1_0_1_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TransitionMoe__Group_1_0_1_0_1__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TransitionMoe__Group_1_0_1_0_1__1__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TransitionMoe__Group_1_0_1_0_1__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionMoeAccess().getIsElseAssignment_1_0_1_0_1_1()); }
	(rule__TransitionMoe__IsElseAssignment_1_0_1_0_1_1)
	{ after(grammarAccess.getTransitionMoeAccess().getIsElseAssignment_1_0_1_0_1_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TransitionMoe__Group_1_0_2__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TransitionMoe__Group_1_0_2__0__Impl
	rule__TransitionMoe__Group_1_0_2__1
;
finally {
	restoreStackSize(stackSize);
}

rule__TransitionMoe__Group_1_0_2__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionMoeAccess().getCommaKeyword_1_0_2_0()); }
	','
	{ after(grammarAccess.getTransitionMoeAccess().getCommaKeyword_1_0_2_0()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TransitionMoe__Group_1_0_2__1
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TransitionMoe__Group_1_0_2__1__Impl
	rule__TransitionMoe__Group_1_0_2__2
;
finally {
	restoreStackSize(stackSize);
}

rule__TransitionMoe__Group_1_0_2__1__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionMoeAccess().getPriorKeyword_1_0_2_1()); }
	('prior:')?
	{ after(grammarAccess.getTransitionMoeAccess().getPriorKeyword_1_0_2_1()); }
)
;
finally {
	restoreStackSize(stackSize);
}

rule__TransitionMoe__Group_1_0_2__2
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TransitionMoe__Group_1_0_2__2__Impl
;
finally {
	restoreStackSize(stackSize);
}

rule__TransitionMoe__Group_1_0_2__2__Impl
	@init {
		int stackSize = keepStackSize();
	}
:
(
	{ before(grammarAccess.getTransitionMoeAccess().getPriorAssignment_1_0_2_2()); }
	(rule__TransitionMoe__PriorAssignment_1_0_2_2)
	{ after(grammarAccess.getTransitionMoeAccess().getPriorAssignment_1_0_2_2()); }
)
;
finally {
	restoreStackSize(stackSize);
}


rule__TransitionMoe__Group_1_1__0
	@init {
		int stackSize = keepStackSize();
	}
:
	rule__TransitionMoe__Group_1_1__0__Impl
	rule__TransitionMoe__Group_1_1__1
;
finally {
	restoreStackSize(stackSize);
}

rule__TransitionMoe__Group_1_1__0__Impl
	@init {
		int stackSize = keepStackSize();
	}
