/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpand2.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.internal.xpand2.ast.Statement;
import org.eclipse.xpand2.output.FileHandle;
import org.eclipse.xpand2.output.InsertionPointSupport;
import org.eclipse.xpand2.output.Outlet;

public class FileHandleImpl
implements FileHandle,
InsertionPointSupport {
    private final Log log = LogFactory.getLog(this.getClass());
    private List<CharSequence> buffers = new ArrayList<CharSequence>();
    private Map<Statement, CharSequence> namedBuffers = new HashMap<Statement, CharSequence>();
    private CharSequence currentNamedBuffer = null;
    private CharSequence currentUnnamedBuffer;
    private File targetFile = null;
    private Outlet outlet = null;

    public FileHandleImpl(Outlet outlet, File f) {
        this.outlet = outlet;
        this.targetFile = f.getAbsoluteFile();
        this.buffers.add(new StringBuilder(4096));
        this.currentUnnamedBuffer = this.buffers.get(0);
    }

    public Outlet getOutlet() {
        return this.outlet;
    }

    public CharSequence getBuffer() {
        if (!this.namedBuffers.isEmpty()) {
            return this.currentNamedBuffer != null ? this.currentNamedBuffer : this.currentUnnamedBuffer;
        }
        if (this.buffers.size() > 1) {
            StringBuilder compacted = new StringBuilder();
            for (CharSequence cs : this.buffers) {
                compacted.append(cs);
            }
            this.buffers.clear();
            this.buffers.add(compacted);
            this.currentUnnamedBuffer = compacted;
        }
        return this.buffers.get(0);
    }

    public void setBuffer(CharSequence newBuffer) {
        if (this.currentNamedBuffer != null) {
            int idx = this.buffers.indexOf(this.currentNamedBuffer);
            while (idx >= 0) {
                this.buffers.add(idx, newBuffer);
                this.buffers.remove(idx + 1);
                idx = this.buffers.indexOf(this.currentNamedBuffer);
            }
            for (Statement key : this.namedBuffers.keySet()) {
                if (this.namedBuffers.get(key) != this.currentNamedBuffer) continue;
                this.namedBuffers.put(key, newBuffer);
            }
            this.currentNamedBuffer = newBuffer;
        } else {
            int idx = this.buffers.indexOf(this.currentUnnamedBuffer);
            this.buffers.add(idx, newBuffer);
            this.buffers.remove(idx + 1);
            this.currentUnnamedBuffer = newBuffer;
        }
    }

    public File getTargetFile() {
        return this.targetFile;
    }

    public String getAbsolutePath() {
        return this.getTargetFile().getAbsolutePath();
    }

    public boolean isAppend() {
        return this.outlet.isAppend();
    }

    public boolean isOverwrite() {
        return this.outlet.isOverwrite();
    }

    public String getFileEncoding() {
        return this.outlet.getFileEncoding();
    }

    public void writeAndClose() {
        block15: {
            try {
                File parentDir;
                if (!this.isOverwrite() && this.targetFile.exists()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Skipping file : " + this.targetFile.getAbsolutePath() + " cause it exists already"));
                    }
                    return;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Opening file : " + this.targetFile.getAbsolutePath()));
                }
                if (!(parentDir = this.targetFile.getParentFile()).exists()) {
                    parentDir.mkdirs();
                    if (!parentDir.isDirectory()) {
                        throw new RuntimeException("Failed to create parent directories of file " + this.targetFile.getAbsolutePath());
                    }
                }
                this.outlet.beforeWriteAndClose(this);
                if (!this.outlet.shouldWrite(this)) break block15;
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(this.targetFile, this.isAppend());
                    out.write(this.getBytes());
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                            this.outlet.afterClose(this);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public byte[] getBytes() {
        CharSequence buffer = null;
        if (this.buffers.size() == 1) {
            buffer = this.buffers.get(0);
        } else {
            StringBuilder tmp = new StringBuilder();
            for (CharSequence cs : this.buffers) {
                tmp.append(cs);
            }
            buffer = tmp;
        }
        if (this.getFileEncoding() != null) {
            try {
                return buffer.toString().getBytes(this.getFileEncoding());
            }
            catch (UnsupportedEncodingException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return buffer.toString().getBytes();
    }

    public void activateInsertionPoint(Statement stmt) {
        CharSequence buffer = this.namedBuffers.get(stmt);
        if (buffer == null) {
            throw new IllegalStateException("Unknown insertion point " + stmt + ".");
        }
        this.currentNamedBuffer = buffer;
    }

    public void deactivateInsertionPoint(Statement stmt) {
        if (this.currentNamedBuffer == null) {
            throw new IllegalStateException("Insertion point for " + stmt + " was not activated.");
        }
        CharSequence buffer = this.namedBuffers.get(stmt);
        if (buffer == null) {
            throw new IllegalStateException("Unknown insertion point " + stmt + ".");
        }
        if (buffer != this.currentNamedBuffer) {
            throw new IllegalStateException("Insertion point " + stmt + " is not the active one!");
        }
        this.namedBuffers.remove(stmt);
        this.currentNamedBuffer = null;
    }

    public void registerInsertionPoint(Statement stmt) {
        CharSequence namedBuffer = this.namedBuffers.get(stmt);
        if (namedBuffer == null) {
            namedBuffer = new StringBuilder();
            this.namedBuffers.put(stmt, namedBuffer);
        }
        this.buffers.add(namedBuffer);
        this.currentUnnamedBuffer = new StringBuilder();
        this.buffers.add(this.currentUnnamedBuffer);
    }
}

